/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.types;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class LobLocation
implements Serializable {
    long ldbBlobId;
    long pallasBlobId;
    String nodeId;
    String tblName;
    long shardId;
    String txn;
    long sn;
    List<String> nodeIds;
    public int blockAddress;

    public LobLocation(int blockAddress) {
        this.blockAddress = blockAddress;
    }

    public LobLocation(long ldbBlobId, long pallasBlobId, String nodeId, String tblName, long shardId, String txn, long sn, List<String> nodeIds) {
        this.ldbBlobId = ldbBlobId;
        this.pallasBlobId = pallasBlobId;
        this.nodeId = nodeId;
        this.tblName = tblName;
        this.shardId = shardId;
        this.txn = txn;
        this.sn = sn;
        this.nodeIds = nodeIds;
    }

    public long getLdbBlobId() {
        return this.ldbBlobId;
    }

    public void setLdbBlobId(long ldbBlobId) {
        this.ldbBlobId = ldbBlobId;
    }

    public long getPallasBlobId() {
        return this.pallasBlobId;
    }

    public void setPallasBlobId(long pallasBlobId) {
        this.pallasBlobId = pallasBlobId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getTblName() {
        return this.tblName;
    }

    public void setTblName(String tblName) {
        this.tblName = tblName;
    }

    public long getShardId() {
        return this.shardId;
    }

    public void setShardId(long shardId) {
        this.shardId = shardId;
    }

    public String getTxn() {
        return this.txn;
    }

    public void setTxn(String txn) {
        this.txn = txn;
    }

    public long getSn() {
        return this.sn;
    }

    public void setSn(long sn) {
        this.sn = sn;
    }

    public List<String> getNodeIds() {
        return this.nodeIds;
    }

    public void setNodeIds(List<String> nodeIds) {
        this.nodeIds = nodeIds;
    }

    public int getBlockAddress() {
        return this.blockAddress;
    }

    public void setBlockAddress(int blockAddress) {
        this.blockAddress = blockAddress;
    }

    public byte[] serialize() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(bos);
        try {
            dataOutputStream.writeLong(this.pallasBlobId);
            dataOutputStream.writeUTF(this.nodeId);
            dataOutputStream.writeUTF(this.tblName);
            dataOutputStream.writeLong(this.shardId);
            dataOutputStream.writeUTF(this.txn);
            dataOutputStream.writeLong(this.sn);
            dataOutputStream.writeInt(this.nodeIds.size());
            for (int i = 0; i < this.nodeIds.size(); ++i) {
                dataOutputStream.writeUTF(this.nodeIds.get(i));
            }
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static LobLocation deserialize(byte[] bytes) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream ins = new DataInputStream(bis);
        try {
            long pallasBlobId = ins.readLong();
            String nodeId = ins.readUTF();
            String tblName = ins.readUTF();
            long shardId = ins.readLong();
            String txn = ins.readUTF();
            long sn = ins.readLong();
            ArrayList<String> nodeIds = new ArrayList<String>();
            int size = ins.readInt();
            for (int i = 0; i < size; ++i) {
                nodeIds.add(ins.readUTF());
            }
            return new LobLocation(0L, pallasBlobId, nodeId, tblName, shardId, txn, sn, nodeIds);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

