import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining resilience lambda checker aspect.
 */
export interface ResilienceLambdaCheckerProps {
    readonly fail?: boolean;
}
/**
 * Define an aspect that validates all Lambda Invoke tasks and warns if AWS Lambda transient errors are not handled properly.
 */
export declare class ResilienceLambdaChecker implements cdk.IAspect {
    private readonly _fail?;
    constructor(props?: ResilienceLambdaCheckerProps);
    visit(construct: cdk.IConstruct): void;
    private getUnhandledTransientErrors;
    private getRetryConfiguration;
}
