import * as cdk from '@aws-cdk/core';
import * as tasks from '@aws-cdk/aws-stepfunctions-tasks';
/**
 * Define a Lambda Invoke task with transient errors handling implemented.
 */
export declare class ResilientLambdaTask extends tasks.LambdaInvoke {
    static readonly TransientErrors: string[];
    constructor(scope: cdk.Construct, id: string, props: tasks.LambdaInvokeProps);
    /**
     * Adds retry for transient Lambda errors.
     * @param task Lambda tast to modify.
     */
    static addDefaultRetry(task: tasks.LambdaInvoke): void;
}
