"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResilientLambdaTask = void 0;
const cdk = require("@aws-cdk/core");
const tasks = require("@aws-cdk/aws-stepfunctions-tasks");
/**
 * Define a Lambda Invoke task with transient errors handling implemented.
 */
class ResilientLambdaTask extends tasks.LambdaInvoke {
    constructor(scope, id, props) {
        super(scope, id, props);
        ResilientLambdaTask.addDefaultRetry(this);
    }
    /**
     * Adds retry for transient Lambda errors.
     * @param task Lambda tast to modify.
     */
    static addDefaultRetry(task) {
        // https://docs.aws.amazon.com/step-functions/latest/dg/bp-lambda-serviceexception.html
        task.addRetry({
            errors: ResilientLambdaTask.TransientErrors,
            backoffRate: 2,
            maxAttempts: 6,
            interval: cdk.Duration.seconds(2)
        });
    }
}
exports.ResilientLambdaTask = ResilientLambdaTask;
ResilientLambdaTask.TransientErrors = [
    "Lambda.ServiceException",
    "Lambda.AWSLambdaException",
    "Lambda.SdkClientException",
    "Lambda.TooManyRequestsException"
];
//# sourceMappingURL=data:application/json;base64,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