import * as cdk from '@aws-cdk/core';
import * as sfn from '@aws-cdk/aws-stepfunctions';
/**
 * Properties for defining a retry with backoff and jitter construct.
 */
export interface RetryWithJitterProps {
    /**
     * An optional description for this state
     *
     * @default No comment
     */
    readonly comment?: string;
    /**
     * JSONPath expression to select part of the state to be the input to this state.
     *
     * May also be the special value DISCARD, which will cause the effective
     * input to be the empty object {}.
     *
     * @default $
     */
    readonly inputPath?: string;
    /**
     * JSONPath expression to indicate where to inject the state's output
     *
     * May also be the special value DISCARD, which will cause the state's
     * input to become its output.
     *
     * @default $
     */
    readonly resultPath?: string;
    /**
     * Try chain to execute.
     */
    readonly tryProcess: sfn.IChainable;
    /**
     * Retry configuration.
     */
    readonly retryProps: sfn.RetryProps;
}
/**
 * Define a construct that implements retry with backoff and jitter.
 */
export declare class RetryWithJitterTask extends sfn.Parallel {
    constructor(scope: cdk.Construct, id: string, props: RetryWithJitterProps);
    private createStateName;
}
