"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TryTask = void 0;
const sfn = require("@aws-cdk/aws-stepfunctions");
/**
 * Define a construct that helps with handling StepFunctions exceptions.
 */
class TryTask extends sfn.Parallel {
    constructor(scope, id, props) {
        const parallelProps = {
            comment: props.comment,
            inputPath: props.inputPath,
            outputPath: "$[0]",
            resultPath: props.resultPath
        };
        super(scope, id, parallelProps);
        let process = props.tryProcess;
        if (props.catchProcess) {
            process = new sfn.Parallel(this, this.createStateName('TryCatch'), {
                outputPath: "$[0]" // unwrap result from the first (and only) branch
            })
                .branch(process)
                .addCatch(props.catchProcess, props.catchProps);
        }
        if (props.finallyProcess) {
            process = new sfn.Parallel(this, this.createStateName('TryFinally'), {
                outputPath: "$[0]" // unwrap result from the first (and only) branch
            })
                .branch(process)
                .addCatch(props.finallyProcess, {
                resultPath: props.finallyErrorPath
            })
                .next(props.finallyProcess);
        }
        this.branch(process);
    }
    createStateName(name) {
        return `${name}_${this.node.uniqueId}`;
    }
}
exports.TryTask = TryTask;
//# sourceMappingURL=data:application/json;base64,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