/*
 * Decompiled with CFR 0.152.
 */
package codetoolkit.janalysis.dg.cfg;

import codetoolkit.janalysis.common.graph.AbstractProgramGraph;
import codetoolkit.janalysis.common.graph.Edge;
import codetoolkit.janalysis.dg.DEPNode;
import codetoolkit.janalysis.dg.cfg.CFEdge;
import codetoolkit.janalysis.utils.StringUtils;
import java.lang.invoke.CallSite;
import java.util.LinkedHashMap;
import java.util.Map;

public class ControlFlowGraph
extends AbstractProgramGraph<DEPNode, CFEdge> {
    private String name;
    private DEPNode entry;

    public ControlFlowGraph(String name) {
        this.name = name;
        this.entry = null;
        this.properties.put("label", "CFG");
        this.properties.put("type", "Control Flow Graph (CFG)");
    }

    public String getName() {
        return this.name;
    }

    public void setEntry(DEPNode entry) {
        this.entry = entry;
    }

    public DEPNode getEntry() {
        return this.entry;
    }

    @Override
    public String exportDOT() {
        StringBuilder dot = new StringBuilder();
        dot.append("digraph CFG {\n");
        dot.append("  // graph-vertices\n");
        LinkedHashMap<DEPNode, CallSite> nodeNames = new LinkedHashMap<DEPNode, CallSite>();
        int nodeCounter = 1;
        for (DEPNode node : this.allVertices) {
            String name = "v" + nodeCounter++;
            nodeNames.put(node, (CallSite)((Object)name));
            StringBuilder label = new StringBuilder("  [label=\"");
            if (node.getLineOfCode() > 0) {
                label.append(node.getLineOfCode()).append(":  ");
            }
            label.append(StringUtils.escape(node.getCode())).append("\"];");
            dot.append("  " + name + label.toString() + "\n");
        }
        dot.append("  // graph-edges\n");
        for (Edge edge : this.allEdges) {
            String src = (String)nodeNames.get(edge.source);
            String trg = (String)nodeNames.get(edge.target);
            if (((CFEdge)edge.label).getLabel().equals("")) {
                dot.append("  " + src + " -> " + trg + ";\n");
                continue;
            }
            dot.append("  " + src + " -> " + trg + "  [label=\"" + ((CFEdge)edge.label).getLabel() + "\"];\n");
        }
        dot.append("  // end-of-graph\n}\n");
        return dot.toString();
    }

    @Override
    public String exportJSON() {
        StringBuilder json = new StringBuilder();
        json.append("{\n  \"directed\": true,\n");
        json.append("  \"multigraph\": true,\n");
        block6: for (Map.Entry property : this.properties.entrySet()) {
            switch ((String)property.getKey()) {
                case "directed": {
                    continue block6;
                }
            }
            json.append("  \"" + (String)property.getKey() + "\": \"" + (String)property.getValue() + "\",\n");
        }
        json.append("  \"nodes\": [\n");
        LinkedHashMap<DEPNode, Integer> nodeIDs = new LinkedHashMap<DEPNode, Integer>();
        int nodeCounter = 0;
        for (DEPNode node : this.allVertices) {
            json.append("    {\n");
            json.append("      \"id\": " + nodeCounter + ",\n");
            json.append("      \"line\": " + node.getLineOfCode() + ",\n");
            json.append("      \"label\": \"" + StringUtils.escape(node.getCode()) + "\"\n");
            nodeIDs.put(node, nodeCounter);
            if (++nodeCounter == this.allVertices.size()) {
                json.append("    }\n");
                continue;
            }
            json.append("    },\n");
        }
        json.append("  ],\n\n  \"edges\": [\n");
        int edgeCounter = 0;
        for (Edge edge : this.allEdges) {
            json.append("    {\n");
            json.append("      \"id\": " + edgeCounter + ",\n");
            json.append("      \"source\": " + nodeIDs.get(edge.source) + ",\n");
            json.append("      \"target\": " + nodeIDs.get(edge.target) + ",\n");
            json.append("      \"label\": \"" + ((CFEdge)edge.label).getLabel() + "\"\n");
            if (++edgeCounter == this.allEdges.size()) {
                json.append("    }\n");
                continue;
            }
            json.append("    },\n");
        }
        json.append("  ]\n}\n");
        return json.toString();
    }
}

