/*
 * Decompiled with CFR 0.152.
 */
package codetoolkit.janalysis.dg.pdg;

import codetoolkit.janalysis.common.antlrparser.JavaBaseVisitor;
import codetoolkit.janalysis.common.antlrparser.JavaLexer;
import codetoolkit.janalysis.common.antlrparser.JavaParser;
import codetoolkit.janalysis.dg.pdg.JavaClass;
import codetoolkit.janalysis.dg.pdg.JavaField;
import codetoolkit.janalysis.dg.pdg.JavaMethod;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class JavaClassExtractor {
    public static List<JavaClass> extractInfo(String javaFile) throws IOException {
        return JavaClassExtractor.extractInfo(new File(javaFile));
    }

    public static List<JavaClass> extractInfo(File javaFile) throws IOException {
        return JavaClassExtractor.extractInfo(new FileInputStream(javaFile));
    }

    public static List<JavaClass> extractInfo(InputStream inStream) throws IOException {
        ANTLRInputStream input = new ANTLRInputStream(inStream);
        JavaLexer lexer = new JavaLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        JavaParser parser = new JavaParser(tokens);
        JavaParser.CompilationUnitContext tree = parser.compilationUnit();
        return JavaClassExtractor.extractInfo(tree);
    }

    public static List<JavaClass> extractInfo(ParseTree tree) {
        JavaClassVisitor visitor = new JavaClassVisitor();
        return visitor.build(tree);
    }

    public static List<JavaClass> extractJavaLangInfo() throws IOException {
        ZipFile zip = new ZipFile("lib/src.zip");
        ArrayList<JavaClass> javaLangClasses = new ArrayList<JavaClass>();
        String qualifiedName = "java.lang.*";
        for (ZipEntry ent : JavaClassExtractor.getPackageEntries(zip, qualifiedName)) {
            javaLangClasses.addAll(JavaClassExtractor.extractInfo(zip.getInputStream(ent)));
        }
        return javaLangClasses;
    }

    public static List<JavaClass> extractImportsInfo(String[] imports) throws IOException {
        ZipFile zip = new ZipFile("lib/src.zip");
        ArrayList<JavaClass> classes = new ArrayList<JavaClass>();
        for (String qualifiedName : imports) {
            if (qualifiedName.endsWith(".*")) {
                for (ZipEntry ent : JavaClassExtractor.getPackageEntries(zip, qualifiedName)) {
                    classes.addAll(JavaClassExtractor.extractInfo(zip.getInputStream(ent)));
                }
                continue;
            }
            ZipEntry entry = JavaClassExtractor.getZipEntry(zip, qualifiedName);
            if (entry == null) continue;
            classes.addAll(JavaClassExtractor.extractInfo(zip.getInputStream(entry)));
        }
        return classes;
    }

    private static ZipEntry getZipEntry(ZipFile zip, String qualifiedName) {
        return zip.getEntry(qualifiedName.replace('.', '/') + ".java");
    }

    private static ZipEntry[] getPackageEntries(ZipFile zip, String qualifiedName) {
        String pkg = qualifiedName.replace('.', '/').substring(0, qualifiedName.length() - 1);
        int slashCount = JavaClassExtractor.countSlashes(pkg);
        ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
        Enumeration<? extends ZipEntry> zipEntries = zip.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry entry = zipEntries.nextElement();
            if (!entry.getName().startsWith(pkg) || entry.isDirectory() || slashCount != JavaClassExtractor.countSlashes(entry.getName())) continue;
            entries.add(entry);
        }
        return entries.toArray(new ZipEntry[entries.size()]);
    }

    private static int countSlashes(String str) {
        int slashCount = 0;
        for (char chr : str.toCharArray()) {
            if (chr != '/') continue;
            ++slashCount;
        }
        return slashCount;
    }

    private static class JavaClassVisitor
    extends JavaBaseVisitor<String> {
        private boolean isStatic;
        private boolean isAbstract;
        private String packageName;
        private String lastModifier;
        private List<String> importsList;
        private List<JavaClass> javaClasses;
        private Deque<JavaClass> activeClasses;

        public List<JavaClass> build(ParseTree tree) {
            this.packageName = "";
            this.isStatic = false;
            this.isAbstract = false;
            this.javaClasses = new ArrayList<JavaClass>();
            this.importsList = new ArrayList<String>();
            this.activeClasses = new ArrayDeque<JavaClass>();
            this.visit(tree);
            return this.javaClasses;
        }

        @Override
        public String visitPackageDeclaration(JavaParser.PackageDeclarationContext ctx) {
            this.packageName = ctx.qualifiedName().getText();
            return null;
        }

        @Override
        public String visitImportDeclaration(JavaParser.ImportDeclarationContext ctx) {
            Object qualifiedName = ctx.qualifiedName().getText();
            int last = ctx.getChildCount() - 1;
            if (ctx.getChild(last - 1).getText().equals("*") && ctx.getChild(last - 2).getText().equals(".")) {
                qualifiedName = (String)qualifiedName + ".*";
            }
            this.importsList.add((String)qualifiedName);
            return null;
        }

        @Override
        public String visitClassDeclaration(JavaParser.ClassDeclarationContext ctx) {
            String extend = null;
            if (ctx.typeType() != null) {
                extend = (String)this.visit(ctx.typeType());
            }
            String[] implementations = null;
            ArrayList<String> impList = new ArrayList<String>();
            if (ctx.typeList() != null) {
                for (JavaParser.TypeTypeContext type : ctx.typeList().typeType()) {
                    impList.add((String)this.visit(type));
                }
            }
            if (impList.size() > 0) {
                implementations = impList.toArray(new String[impList.size()]);
            }
            String[] imports = this.importsList.toArray(new String[this.importsList.size()]);
            JavaClass cls = new JavaClass(ctx.Identifier().getText(), this.packageName, extend, imports);
            if (ctx.typeParameters() != null) {
                cls.setTypeParameters(ctx.typeParameters().getText().substring(1, ctx.typeParameters().getText().length() - 1).trim());
            }
            this.activeClasses.push(cls);
            this.activeClasses.peek().setInterfaces(implementations);
            this.visit(ctx.classBody());
            this.javaClasses.add(this.activeClasses.pop());
            return null;
        }

        @Override
        public String visitClassBodyDeclaration(JavaParser.ClassBodyDeclarationContext ctx) {
            if (ctx.memberDeclaration() != null) {
                this.isStatic = false;
                this.isAbstract = false;
                this.lastModifier = null;
                if (ctx.modifier() != null && ctx.modifier().size() > 0) {
                    for (JavaParser.ModifierContext cx : ctx.modifier()) {
                        if (cx.classOrInterfaceModifier() == null) continue;
                        if (cx.classOrInterfaceModifier().getText().startsWith("public")) {
                            this.lastModifier = "public";
                            continue;
                        }
                        if (cx.classOrInterfaceModifier().getText().startsWith("private")) {
                            this.lastModifier = "private";
                            continue;
                        }
                        if (cx.classOrInterfaceModifier().getText().startsWith("protected")) {
                            this.lastModifier = "protected";
                            continue;
                        }
                        if (cx.classOrInterfaceModifier().getText().startsWith("static")) {
                            this.isStatic = true;
                            continue;
                        }
                        if (!cx.classOrInterfaceModifier().getText().startsWith("abstract")) continue;
                        this.isAbstract = true;
                    }
                }
                return (String)this.visit(ctx.memberDeclaration());
            }
            return null;
        }

        @Override
        public String visitMethodDeclaration(JavaParser.MethodDeclarationContext ctx) {
            String type = "void";
            if (ctx.typeType() != null) {
                type = (String)this.visit(ctx.typeType());
            }
            String name = ctx.Identifier().getText();
            String[] args = null;
            ArrayList<String> argsList = new ArrayList<String>();
            if (ctx.formalParameters().formalParameterList() != null) {
                for (JavaParser.FormalParameterContext param : ctx.formalParameters().formalParameterList().formalParameter()) {
                    argsList.add((String)this.visit(param.typeType()));
                }
                if (ctx.formalParameters().formalParameterList().lastFormalParameter() != null) {
                    argsList.add((String)this.visit(ctx.formalParameters().formalParameterList().lastFormalParameter().typeType()));
                }
            }
            if (argsList.size() > 0) {
                args = argsList.toArray(new String[argsList.size()]);
            }
            int line = ctx.getStart().getLine();
            this.activeClasses.peek().addMethod(new JavaMethod(this.lastModifier, this.isStatic, this.isAbstract, type, name, args, line));
            return null;
        }

        @Override
        public String visitConstructorDeclaration(JavaParser.ConstructorDeclarationContext ctx) {
            String type = null;
            String name = ctx.Identifier().getText();
            String[] args = null;
            ArrayList<String> argsList = new ArrayList<String>();
            if (ctx.formalParameters().formalParameterList() != null) {
                for (JavaParser.FormalParameterContext param : ctx.formalParameters().formalParameterList().formalParameter()) {
                    argsList.add((String)this.visit(param.typeType()));
                }
                if (ctx.formalParameters().formalParameterList().lastFormalParameter() != null) {
                    argsList.add((String)this.visit(ctx.formalParameters().formalParameterList().lastFormalParameter().typeType()));
                }
            }
            if (argsList.size() > 0) {
                args = argsList.toArray(new String[argsList.size()]);
            }
            int line = ctx.getStart().getLine();
            this.activeClasses.peek().addMethod(new JavaMethod(this.lastModifier, this.isStatic, this.isAbstract, type, name, args, line));
            return null;
        }

        @Override
        public String visitFieldDeclaration(JavaParser.FieldDeclarationContext ctx) {
            for (JavaParser.VariableDeclaratorContext var : ctx.variableDeclarators().variableDeclarator()) {
                String name = var.variableDeclaratorId().Identifier().getText();
                StringBuilder type = new StringBuilder((String)this.visit(ctx.typeType()));
                int idx = var.variableDeclaratorId().getText().indexOf(91);
                if (idx > 0) {
                    type.append(var.variableDeclaratorId().getText().substring(idx));
                }
                this.activeClasses.peek().addField(new JavaField(this.lastModifier, this.isStatic, type.toString(), name));
            }
            return null;
        }

        @Override
        public String visitTypeType(JavaParser.TypeTypeContext ctx) {
            return ctx.getText();
        }

        @Override
        public String visitEnumDeclaration(JavaParser.EnumDeclarationContext ctx) {
            return null;
        }

        @Override
        public String visitInterfaceDeclaration(JavaParser.InterfaceDeclarationContext ctx) {
            return null;
        }
    }
}

