/*
 * Decompiled with CFR 0.152.
 */
package codetoolkit.janalysis.dg.pdg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class MethodDefInfo {
    public final String NAME;
    public final String PACKAGE;
    public final String RET_TYPE;
    public final String CLASS_NAME;
    public final String[] PARAM_TYPES;
    private boolean stateDEF;
    private boolean[] argDEFs;
    private List<String> fieldDEFs;

    public MethodDefInfo(String ret, String name, String pkg, String cls, String[] args) {
        this.NAME = name;
        this.RET_TYPE = ret;
        this.CLASS_NAME = cls;
        this.PACKAGE = pkg == null ? "" : pkg;
        this.PARAM_TYPES = args == null ? new String[]{} : args;
        this.fieldDEFs = new ArrayList<String>();
        this.stateDEF = this.guessByTypeOrName();
        this.argDEFs = new boolean[this.PARAM_TYPES.length];
    }

    private boolean guessByTypeOrName() {
        String[] prefixes;
        if (this.RET_TYPE == null) {
            return true;
        }
        for (String pre : prefixes = new String[]{"set", "put", "add", "insert", "push", "append"}) {
            if (!this.NAME.toLowerCase().startsWith(pre)) continue;
            return true;
        }
        return false;
    }

    public boolean doesStateDEF() {
        return this.stateDEF;
    }

    public void setStateDEF(boolean stateDef) {
        this.stateDEF = stateDef;
    }

    public boolean[] argDEFs() {
        return this.argDEFs;
    }

    public void setArgDEF(int argIndex, boolean def) {
        this.argDEFs[argIndex] = def;
    }

    public void setAllArgDEFs(boolean[] argDefs) {
        this.argDEFs = argDefs;
    }

    public String[] fieldDEFs() {
        return this.fieldDEFs.toArray(new String[this.fieldDEFs.size()]);
    }

    public void addFieldDEF(String fieldName) {
        if (!this.fieldDEFs.contains(fieldName)) {
            this.fieldDEFs.add(fieldName);
            this.stateDEF = true;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MethodDefInfo)) {
            return false;
        }
        MethodDefInfo info = (MethodDefInfo)obj;
        return this.NAME.equals(info.NAME) && this.CLASS_NAME.equals(info.CLASS_NAME) && this.PACKAGE.equals(info.PACKAGE) && this.RET_TYPE.equals(info.RET_TYPE) && Arrays.equals(this.PARAM_TYPES, info.PARAM_TYPES);
    }

    public String toString() {
        String retType = this.RET_TYPE == null ? "null" : this.RET_TYPE;
        String args = this.PARAM_TYPES == null ? "null" : Arrays.toString(this.PARAM_TYPES);
        StringBuilder str = new StringBuilder();
        str.append("{ TYPE : \"").append(retType).append("\", ");
        str.append("NAME : \"").append(this.NAME).append("\", ");
        str.append("ARGS : ").append(args).append(", ");
        str.append("CLASS : \"").append(this.CLASS_NAME).append("\", ");
        str.append("PACKAGE : \"").append(this.PACKAGE).append("\" }");
        return str.toString();
    }
}

