/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.arraybounds;

import com.ibm.wala.analysis.arraybounds.hypergraph.DirectedHyperEdge;
import com.ibm.wala.analysis.arraybounds.hypergraph.DirectedHyperGraph;
import com.ibm.wala.analysis.arraybounds.hypergraph.HyperNode;
import com.ibm.wala.analysis.arraybounds.hypergraph.SoftFinalHyperNode;
import com.ibm.wala.analysis.arraybounds.hypergraph.weight.Weight;
import com.ibm.wala.analysis.arraybounds.hypergraph.weight.edgeweights.AdditiveEdgeWeight;
import com.ibm.wala.util.collections.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ArrayBoundsGraph
extends DirectedHyperGraph<Integer> {
    public static final Integer ZERO = -1;
    public static final Integer ZERO_HELPER = -3;
    public static final Integer UNLIMITED = -2;
    private final HashMap<Integer, Set<Integer>> arrayAccess = new HashMap();
    private final HashMap<Integer, Integer> arrayLength = new HashMap();
    private final HashSet<Integer> phis;
    private final HashMap<Integer, Pair<Integer, Integer>> constants = new HashMap();
    private Integer arrayCounter = -4;

    public ArrayBoundsGraph() {
        this.phis = new HashSet();
        this.addNode(UNLIMITED);
        this.phis.add(UNLIMITED);
        this.createSourceVar(ZERO);
        this.addNode(ZERO_HELPER);
        this.addEdge(ZERO, ZERO_HELPER);
    }

    public void postProcessConstants() {
        for (Map.Entry<Integer, Pair<Integer, Integer>> entry : this.constants.entrySet()) {
            HyperNode constantNode = this.getNodes().get(entry.getKey());
            Pair<Integer, Integer> value = entry.getValue();
            HyperNode helper1 = this.getNodes().get(value.fst);
            HyperNode helper2 = this.getNodes().get(value.snd);
            for (DirectedHyperEdge edge : constantNode.getOutEdges()) {
                if (edge.getDestination().contains(helper2)) continue;
                edge.getSource().remove(constantNode);
                edge.getSource().add(helper1);
            }
        }
    }

    public void addAdditionEdge(Integer src, Integer dst, Integer value) {
        this.addNode(src);
        HyperNode srcNode = this.getNodes().get(src);
        this.addNode(dst);
        HyperNode dstNode = this.getNodes().get(dst);
        Weight weight = value == 0 ? Weight.ZERO : new Weight(Weight.Type.NUMBER, value);
        AdditiveEdgeWeight edgeWeight = new AdditiveEdgeWeight(weight);
        DirectedHyperEdge edge = new DirectedHyperEdge();
        edge.getDestination().add(dstNode);
        edge.getSource().add(srcNode);
        edge.setWeight(edgeWeight);
        this.getEdges().add(edge);
    }

    public void addArray(Integer array) {
        this.getArrayNode(array);
    }

    public void addConstant(Integer variable, Integer value) {
        Integer helper1 = this.generateNewVar();
        Integer helper2 = this.generateNewVar();
        this.addAdditionEdge(ZERO_HELPER, helper1, value);
        this.addAdditionEdge(variable, helper2, -value.intValue());
        this.addEdge(helper2, ZERO_HELPER);
        this.constants.put(variable, Pair.make(helper1, helper2));
    }

    public void addEdge(Integer src, Integer dst) {
        this.addAdditionEdge(src, dst, 0);
    }

    public HyperNode<Integer> addNode(Integer value) {
        HyperNode<Integer> result;
        if (!this.getNodes().containsKey(value)) {
            result = new HyperNode<Integer>(value);
            this.getNodes().put(value, result);
        } else {
            result = this.getNodes().get(value);
        }
        return result;
    }

    public void addPhi(Integer dst) {
        this.phis.add(dst);
    }

    public void addPi(Integer dst, Integer src1, Integer src2) {
        this.addEdge(src1, dst);
        this.addEdge(src2, dst);
    }

    public void createSourceVar(Integer var) {
        if (this.getNodes().containsKey(var)) {
            throw new AssertionError((Object)"Source variables should only be created once.");
        }
        SoftFinalHyperNode<Integer> node = new SoftFinalHyperNode<Integer>(var);
        this.getNodes().put(var, node);
        this.addEdge(UNLIMITED, var);
    }

    public Integer generateNewVar() {
        int result = this.arrayCounter;
        ArrayBoundsGraph arrayBoundsGraph = this;
        arrayBoundsGraph.arrayCounter = arrayBoundsGraph.arrayCounter - 1;
        return result;
    }

    public HashMap<Integer, Set<Integer>> getArrayAccess() {
        return this.arrayAccess;
    }

    public HashMap<Integer, Integer> getArrayLength() {
        return this.arrayLength;
    }

    public Integer getArrayNode(Integer array) {
        Integer arrayVar;
        if (!this.arrayLength.containsKey(array)) {
            arrayVar = this.generateNewVar();
            this.arrayLength.put(array, arrayVar);
            this.createSourceVar(arrayVar);
        } else {
            arrayVar = this.arrayLength.get(array);
        }
        return arrayVar;
    }

    public HashSet<Integer> getPhis() {
        return this.phis;
    }

    public void markAsArrayAccess(Integer array, Integer index) {
        Set<Object> indices;
        if (!this.arrayAccess.containsKey(array)) {
            indices = new HashSet();
            this.arrayAccess.put(array, indices);
        } else {
            indices = this.arrayAccess.get(array);
        }
        indices.add(index);
        this.addArray(array);
    }

    public void markAsArrayLength(Integer array, Integer variable) {
        this.addEdge(this.getArrayNode(array), variable);
    }

    public void markAsDeadEnd(Integer variable) {
        this.addEdge(UNLIMITED, variable);
    }

    public Weight getVariableWeight(Integer variable) {
        if (this.constants.containsKey(variable)) {
            variable = (Integer)this.constants.get((Object)variable).fst;
        }
        return this.getNodes().get(variable).getWeight();
    }

    @Override
    public void reset() {
        super.reset();
        this.getNodes().get(UNLIMITED).setWeight(Weight.UNLIMITED);
        this.getNodes().get(UNLIMITED).setNewWeight(Weight.UNLIMITED);
    }
}

