/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.reflection.AbstractReflectionInterpreter;
import com.ibm.wala.analysis.typeInference.ConeType;
import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.InducedCFG;
import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.CodeScanner;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.SyntheticMethod;
import com.ibm.wala.core.util.warnings.Warnings;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.SummarizedMethod;
import com.ibm.wala.ipa.summaries.SyntheticIR;
import com.ibm.wala.shrike.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.IRView;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.debug.Assertions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FactoryBypassInterpreter
extends AbstractReflectionInterpreter {
    private final Map<Context, Set<TypeReference>> map = HashMapFactory.make();
    private final Map<Context, SpecializedFactoryMethod> syntheticMethodCache = HashMapFactory.make();

    public FactoryBypassInterpreter(AnalysisOptions options, IAnalysisCacheView iAnalysisCacheView) {
        this.options = options;
        this.cache = iAnalysisCacheView;
    }

    @Override
    public IR getIR(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod m = this.findOrCreateSpecializedFactoryMethod(node);
        return this.cache.getIR(m, node.getContext());
    }

    @Override
    public IRView getIRView(CGNode node) {
        return this.getIR(node);
    }

    private Set<TypeReference> getTypesForContext(Context context) {
        Set<TypeReference> types = this.map.get(context);
        return types;
    }

    @Override
    public int getNumberOfStatements(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod m = this.findOrCreateSpecializedFactoryMethod(node);
        return m.allInstructions.size();
    }

    @Override
    public boolean understands(CGNode node) {
        SyntheticMethod s;
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        if (node.getMethod().isWalaSynthetic() && (s = (SyntheticMethod)node.getMethod()).isFactoryMethod()) {
            return this.getTypesForContext(node.getContext()) != null;
        }
        return false;
    }

    @Override
    public Iterator<NewSiteReference> iterateNewSites(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod m = this.findOrCreateSpecializedFactoryMethod(node);
        HashSet result = HashSetFactory.make(5);
        for (SSAInstruction ssaInstruction : m.getAllocationStatements()) {
            SSANewInstruction s = (SSANewInstruction)ssaInstruction;
            result.add(s.getNewSite());
        }
        return result.iterator();
    }

    public Iterator<SSAInstruction> getInvokeStatements(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod m = this.findOrCreateSpecializedFactoryMethod(node);
        return m.getInvokeStatements().iterator();
    }

    @Override
    public Iterator<CallSiteReference> iterateCallSites(CGNode node) {
        final Iterator<SSAInstruction> I = this.getInvokeStatements(node);
        return new Iterator<CallSiteReference>(){

            @Override
            public boolean hasNext() {
                return I.hasNext();
            }

            @Override
            public CallSiteReference next() {
                SSAInvokeInstruction s = (SSAInvokeInstruction)I.next();
                return s.getCallSite();
            }

            @Override
            public void remove() {
                Assertions.UNREACHABLE();
            }
        };
    }

    public boolean recordType(IClassHierarchy cha, Context context, TypeReference type) {
        Set<TypeReference> types = this.map.get(context);
        if (types == null) {
            types = HashSetFactory.make(2);
            this.map.put(context, types);
        }
        if (!types.add(type)) {
            return false;
        }
        SpecializedFactoryMethod m = this.syntheticMethodCache.get(context);
        if (m != null) {
            TypeAbstraction T = this.typeRef2TypeAbstraction(cha, type);
            m.addStatementsForTypeAbstraction(T);
            this.cache.invalidate(m, context);
        }
        return true;
    }

    @Override
    public boolean recordFactoryType(CGNode node, IClass klass) {
        if (klass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        return this.recordType(node.getMethod().getClassHierarchy(), node.getContext(), klass.getReference());
    }

    @Override
    public Iterator<FieldReference> iterateFieldsRead(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod m = this.findOrCreateSpecializedFactoryMethod(node);
        try {
            return CodeScanner.getFieldsRead(m).iterator();
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    @Override
    public Iterator<FieldReference> iterateFieldsWritten(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod m = this.findOrCreateSpecializedFactoryMethod(node);
        try {
            return CodeScanner.getFieldsWritten(m).iterator();
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    private SpecializedFactoryMethod findOrCreateSpecializedFactoryMethod(CGNode node) {
        SpecializedFactoryMethod m = this.syntheticMethodCache.get(node.getContext());
        if (m == null) {
            Set<TypeReference> types = this.getTypesForContext(node.getContext());
            m = new SpecializedFactoryMethod((SummarizedMethod)node.getMethod(), node.getContext(), types);
            this.syntheticMethodCache.put(node.getContext(), m);
        }
        return m;
    }

    public Set<TypeReference> getCaughtExceptions(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod m = this.findOrCreateSpecializedFactoryMethod(node);
        try {
            return CodeScanner.getCaughtExceptions(m);
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    public boolean hasObjectArrayLoad(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod m = this.findOrCreateSpecializedFactoryMethod(node);
        try {
            return CodeScanner.hasObjectArrayLoad(m);
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return false;
        }
    }

    public boolean hasObjectArrayStore(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod m = this.findOrCreateSpecializedFactoryMethod(node);
        try {
            return CodeScanner.hasObjectArrayStore(m);
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return false;
        }
    }

    public Iterator<TypeReference> iterateCastTypes(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod m = this.findOrCreateSpecializedFactoryMethod(node);
        try {
            return CodeScanner.iterateCastTypes(m);
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    @Override
    public ControlFlowGraph<SSAInstruction, ISSABasicBlock> getCFG(CGNode N) {
        return this.getIR(N).getControlFlowGraph();
    }

    @Override
    public DefUse getDU(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        return this.cache.getDefUse(this.getIR(node));
    }

    protected class SpecializedFactoryMethod
    extends AbstractReflectionInterpreter.SpecializedMethod {
        private final ArrayList<SSAInstruction> calls;
        private final IMethod method;
        private final Context context;
        private int nextLocal;
        private int valueNumberForConstantOne;
        private final SSAInstructionFactory insts;

        private void initValueNumberForConstantOne() {
            if (this.valueNumberForConstantOne == -1) {
                this.valueNumberForConstantOne = this.nextLocal++;
            }
        }

        protected SpecializedFactoryMethod(SummarizedMethod m, Context context, Set<TypeReference> S) {
            super(m, m.getDeclaringClass(), m.isStatic(), true);
            this.calls = new ArrayList();
            this.valueNumberForConstantOne = -1;
            this.insts = this.declaringClass.getClassLoader().getInstructionFactory();
            this.context = context;
            this.method = m;
            assert (S != null);
            assert (m.getDeclaringClass() != null) : "null declaring class for " + m;
            this.nextLocal = this.addOriginalStatements(m);
            for (TypeReference type : S) {
                TypeAbstraction T = FactoryBypassInterpreter.this.typeRef2TypeAbstraction(m.getClassHierarchy(), type);
                this.addStatementsForTypeAbstraction(T);
            }
        }

        protected void addStatementsForTypeAbstraction(TypeAbstraction T) {
            if ((T = this.interceptType(T)) == null) {
                return;
            }
            if (T instanceof PointType || T instanceof ConeType) {
                TypeReference ref = T.getType().getReference();
                NewSiteReference site = NewSiteReference.make(0, ref);
                if (T instanceof PointType) {
                    if (!this.typesAllocated.contains(ref)) {
                        this.addStatementsForConcreteType(ref);
                    }
                } else if (T instanceof ConeType) {
                    if (((ConeType)T).isInterface()) {
                        Set<IClass> implementors = T.getType().getClassHierarchy().getImplementors(ref);
                        if (implementors.isEmpty()) {
                            Warnings.add(AbstractReflectionInterpreter.NoSubtypesWarning.create(T));
                        }
                        if (implementors.size() > 10) {
                            Warnings.add(AbstractReflectionInterpreter.ManySubtypesWarning.create(T, implementors.size()));
                        }
                        this.addStatementsForSetOfTypes(implementors.iterator());
                    } else {
                        Collection<IClass> subclasses = T.getType().getClassHierarchy().computeSubClasses(ref);
                        if (subclasses.isEmpty()) {
                            Warnings.add(AbstractReflectionInterpreter.NoSubtypesWarning.create(T));
                        }
                        if (subclasses.size() > 10) {
                            Warnings.add(AbstractReflectionInterpreter.ManySubtypesWarning.create(T, subclasses.size()));
                        }
                        this.addStatementsForSetOfTypes(subclasses.iterator());
                    }
                } else {
                    Assertions.UNREACHABLE("Unexpected type " + T.getClass());
                }
            } else {
                Assertions.UNREACHABLE("Unexpected type " + T.getClass());
            }
        }

        private TypeAbstraction interceptType(TypeAbstraction T) {
            TypeReference type = T.getType().getReference();
            if (type.equals(TypeReference.JavaIoSerializable)) {
                Warnings.add(AbstractReflectionInterpreter.IgnoreSerializableWarning.create());
                return null;
            }
            return T;
        }

        private void addStatementsForConcreteType(TypeReference T) {
            int alloc = this.addStatementsForConcreteSimpleType(T);
            if (alloc == -1) {
                return;
            }
            if (T.isArrayType()) {
                MethodReference init = MethodReference.findOrCreate(T, MethodReference.initAtom, MethodReference.defaultInitDesc);
                CallSiteReference site = CallSiteReference.make(FactoryBypassInterpreter.this.getCallSiteForType(T), init, IInvokeInstruction.Dispatch.SPECIAL);
                int[] params = new int[]{alloc};
                int exc = FactoryBypassInterpreter.this.getExceptionsForType(T);
                SSAAbstractInvokeInstruction s = this.insts.InvokeInstruction(this.allInstructions.size(), params, exc, site, null);
                this.calls.add(s);
                this.allInstructions.add(s);
            }
        }

        private int addOriginalStatements(SummarizedMethod m) {
            SSAInstruction[] original = m.getStatements(FactoryBypassInterpreter.this.options.getSSAOptions());
            int nextLocal = 2;
            for (SSAInstruction s : original) {
                int j;
                this.allInstructions.add(s);
                if (s instanceof SSAInvokeInstruction) {
                    this.calls.add(s);
                }
                if (s instanceof SSANewInstruction) {
                    this.allocations.add(s);
                }
                for (j = 0; j < s.getNumberOfDefs(); ++j) {
                    int def = s.getDef(j);
                    if (def < nextLocal) continue;
                    nextLocal = def + 1;
                }
                for (j = 0; j < s.getNumberOfUses(); ++j) {
                    int use = s.getUse(j);
                    if (use < nextLocal) continue;
                    nextLocal = use + 1;
                }
            }
            return nextLocal;
        }

        private void addStatementsForSetOfTypes(Iterator<IClass> it) {
            if (!it.hasNext()) {
                SSAReturnInstruction r = this.insts.ReturnInstruction(this.allInstructions.size(), this.nextLocal, false);
                this.allInstructions.add(r);
            }
            for (IClass klass : Iterator2Iterable.make(it)) {
                TypeReference T = klass.getReference();
                if (klass.isAbstract() || klass.isInterface() || this.typesAllocated.contains(T)) continue;
                this.typesAllocated.add(T);
                int i = FactoryBypassInterpreter.this.getLocalForType(T);
                NewSiteReference ref = NewSiteReference.make(FactoryBypassInterpreter.this.getNewSiteForType(T), T);
                SSANewInstruction a = null;
                if (T.isArrayType()) {
                    int[] sizes = new int[((ArrayClass)klass).getDimensionality()];
                    this.initValueNumberForConstantOne();
                    Arrays.fill(sizes, this.valueNumberForConstantOne);
                    a = this.insts.NewInstruction(this.allInstructions.size(), i, ref, sizes);
                } else {
                    a = this.insts.NewInstruction(this.allInstructions.size(), i, ref);
                }
                this.allocations.add(a);
                this.allInstructions.add(a);
                SSAReturnInstruction r = this.insts.ReturnInstruction(this.allInstructions.size(), i, false);
                this.allInstructions.add(r);
                MethodReference init = MethodReference.findOrCreate(T, MethodReference.initAtom, MethodReference.defaultInitDesc);
                CallSiteReference site = CallSiteReference.make(FactoryBypassInterpreter.this.getCallSiteForType(T), init, IInvokeInstruction.Dispatch.SPECIAL);
                int[] params = new int[]{i};
                SSAAbstractInvokeInstruction s = this.insts.InvokeInstruction(this.allInstructions.size(), params, FactoryBypassInterpreter.this.getExceptionsForType(T), site, null);
                this.calls.add(s);
                this.allInstructions.add(s);
            }
        }

        public List<SSAInstruction> getAllocationStatements() {
            return this.allocations;
        }

        public List<SSAInstruction> getInvokeStatements() {
            return this.calls;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public String toString() {
            return super.toString();
        }

        @Override
        public SSAInstruction[] getStatements() {
            SSAInstruction[] result = new SSAInstruction[this.allInstructions.size()];
            int i = 0;
            for (SSAInstruction ssaInstruction : this.allInstructions) {
                result[i++] = ssaInstruction;
            }
            return result;
        }

        @Override
        public IClass getDeclaringClass() {
            assert (this.method.getDeclaringClass() != null) : "null declaring class for original method " + this.method;
            return this.method.getDeclaringClass();
        }

        @Override
        public int getNumberOfParameters() {
            return this.method.getNumberOfParameters();
        }

        @Override
        public TypeReference getParameterType(int i) {
            return this.method.getParameterType(i);
        }

        @Override
        public IR makeIR(Context C, SSAOptions options) {
            SSAInstruction[] instrs = this.getStatements();
            HashMap<Integer, ConstantValue> constants = null;
            if (this.valueNumberForConstantOne > -1) {
                constants = HashMapFactory.make(1);
                constants.put(this.valueNumberForConstantOne, new ConstantValue((Object)1));
            }
            return new SyntheticIR(this, this.context, new InducedCFG(instrs, this, this.context), instrs, options, constants);
        }
    }
}

