/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.ClassFileModule;
import com.ibm.wala.classLoader.DirectoryTreeModule;
import com.ibm.wala.classLoader.FileModule;
import com.ibm.wala.core.util.warnings.Warning;
import com.ibm.wala.core.util.warnings.Warnings;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;
import java.io.File;

public class BinaryDirectoryTreeModule
extends DirectoryTreeModule {
    public BinaryDirectoryTreeModule(File root) {
        super(root);
    }

    @Override
    protected boolean includeFile(File file) {
        return file.getName().endsWith("class");
    }

    @Override
    protected FileModule makeFile(final File file) {
        try {
            return new ClassFileModule(file, this);
        }
        catch (InvalidClassFileException e) {
            Warnings.add(new Warning(1){

                @Override
                public String getMsg() {
                    return "Invalid class file at path " + file.getAbsolutePath();
                }
            });
            return null;
        }
    }
}

