/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.impl.DefaultEntrypoint;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public class SubtypesEntrypoint
extends DefaultEntrypoint {
    public SubtypesEntrypoint(MethodReference method, IClassHierarchy cha) {
        super(method, cha);
    }

    public SubtypesEntrypoint(IMethod method, IClassHierarchy cha) {
        super(method, cha);
    }

    @Override
    protected TypeReference[][] makeParameterTypes(IMethod method) {
        TypeReference[][] result = new TypeReference[method.getNumberOfParameters()][];
        Arrays.setAll(result, i -> this.makeParameterTypes(method, i));
        return result;
    }

    @Override
    protected TypeReference[] makeParameterTypes(IMethod method, int i) {
        TypeReference nominal = method.getParameterType(i);
        if (nominal.isPrimitiveType() || nominal.isArrayType()) {
            return new TypeReference[]{nominal};
        }
        IClass nc = this.getCha().lookupClass(nominal);
        if (nc == null) {
            throw new IllegalStateException("Could not resolve in cha: " + nominal);
        }
        Collection<IClass> subcs = nc.isInterface() ? this.getCha().getImplementors(nominal) : this.getCha().computeSubClasses(nominal);
        HashSet<TypeReference> subs = HashSetFactory.make();
        for (IClass cs : subcs) {
            if (cs.isAbstract() || cs.isInterface()) continue;
            subs.add(cs.getReference());
        }
        return subs.toArray(new TypeReference[0]);
    }
}

