/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.SyntheticMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.rta.RTAContextInterpreter;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.slicer.NormalReturnCallee;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.Slicer;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Set;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public class ReflectionHandler {
    private static final boolean VERBOSE = false;
    private final PropagationCallGraphBuilder builder;

    public ReflectionHandler(PropagationCallGraphBuilder builder) {
        this.builder = builder;
    }

    protected boolean updateForReflection(MonitorUtil.IProgressMonitor monitor) throws IllegalArgumentException, CancelException {
        Collection<Statement> returnStatements = this.computeFactoryReturnStatements();
        HashSet<CGNode> changedNodes = HashSetFactory.make();
        for (Statement st : returnStatements) {
            Collection<Statement> slice = Slicer.computeForwardSlice(st, this.builder.callGraph, null, Slicer.DataDependenceOptions.REFLECTION, Slicer.ControlDependenceOptions.NONE);
            Predicate<Statement> f = s -> {
                if (s.getKind() == Statement.Kind.NORMAL) {
                    return ((NormalStatement)s).getInstruction() instanceof SSACheckCastInstruction;
                }
                return false;
            };
            Iterator2Set<Statement> casts = Iterator2Collection.toSet(new FilterIterator<Statement>(slice.iterator(), f));
            changedNodes.addAll(ReflectionHandler.modifyFactoryInterpreter(st, casts, this.builder.getContextInterpreter(), this.builder.getClassHierarchy()));
        }
        for (CGNode cgNode : changedNodes) {
            this.builder.addConstraintsFromChangedNode(cgNode, monitor);
        }
        return changedNodes.size() > 0;
    }

    private Collection<Statement> computeFactoryReturnStatements() {
        HashSet<Statement> result = HashSetFactory.make();
        for (CGNode n : this.builder.getCallGraph()) {
            SyntheticMethod m;
            if (!(n.getMethod() instanceof SyntheticMethod) || !(m = (SyntheticMethod)n.getMethod()).isFactoryMethod()) continue;
            result.add(new NormalReturnCallee(n));
        }
        return result;
    }

    private static Set<CGNode> modifyFactoryInterpreter(Statement returnStatement, Collection<Statement> casts, RTAContextInterpreter contextInterpreter, IClassHierarchy cha) {
        HashSet<CGNode> result = HashSetFactory.make();
        for (Statement st : casts) {
            SSACheckCastInstruction c = (SSACheckCastInstruction)((NormalStatement)st).getInstruction();
            for (TypeReference type : c.getDeclaredResultTypes()) {
                IClass klass = cha.lookupClass(type);
                if (klass == null || !contextInterpreter.recordFactoryType(returnStatement.getNode(), klass)) continue;
                result.add(returnStatement.getNode());
            }
        }
        return result;
    }
}

