/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.bench;

import com.ibm.wala.shrike.shrikeBT.DupInstruction;
import com.ibm.wala.shrike.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrike.shrikeBT.MethodData;
import com.ibm.wala.shrike.shrikeBT.MethodEditor;
import com.ibm.wala.shrike.shrikeBT.Util;
import com.ibm.wala.shrike.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrike.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrike.shrikeCT.ClassWriter;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Writer;

public class AddBytecodeDebug {
    private static OfflineInstrumenter instrumenter;

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 1; ++i) {
            instrumenter = new OfflineInstrumenter();
            try (BufferedWriter w = new BufferedWriter(new FileWriter("report", false));){
                ClassInstrumenter ci;
                args = instrumenter.parseStandardArgs(args);
                instrumenter.setPassUnmodifiedClasses(true);
                instrumenter.beginTraversal();
                while ((ci = instrumenter.nextClass()) != null) {
                    AddBytecodeDebug.doClass(ci, w);
                }
                instrumenter.close();
                continue;
            }
        }
    }

    private static void doClass(ClassInstrumenter ci, Writer w) throws Exception {
        String className = ci.getReader().getName();
        w.write("Class: " + className + '\n');
        w.flush();
        ci.enableFakeLineNumbers(10000);
        for (int m = 0; m < ci.getReader().getMethodCount(); ++m) {
            MethodData d = ci.visitMethod(m);
            if (d == null) continue;
            d.setHasChanged();
            MethodEditor me = new MethodEditor(d);
            me.beginPass();
            ExceptionHandler[][] handlers = me.getHandlers();
            boolean[] putDumperAt = new boolean[handlers.length];
            ExceptionHandler[][] exceptionHandlerArray = handlers;
            int n = exceptionHandlerArray.length;
            for (int i = 0; i < n; ++i) {
                ExceptionHandler[] handler;
                for (ExceptionHandler element : handler = exceptionHandlerArray[i]) {
                    int offset = element.getHandler();
                    if (putDumperAt[offset]) continue;
                    putDumperAt[offset] = true;
                    me.insertBefore(offset, new MethodEditor.Patch(){

                        @Override
                        public void emitTo(MethodEditor.Output w) {
                            w.emit(DupInstruction.make(0));
                            w.emit(Util.makeInvoke(Throwable.class, "printStackTrace", new Class[0]));
                        }
                    });
                }
            }
            me.applyPatches();
        }
        if (ci.isChanged()) {
            ClassWriter cw = ci.emitClass();
            instrumenter.outputModifiedClass(ci, cw);
        }
    }
}

