/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;

public class SSAGetCaughtExceptionInstruction
extends SSAInstruction {
    private final int exceptionValueNumber;
    private final int bbNumber;

    public SSAGetCaughtExceptionInstruction(int iindex, int bbNumber, int exceptionValueNumber) {
        super(iindex);
        this.exceptionValueNumber = exceptionValueNumber;
        this.bbNumber = bbNumber;
    }

    @Override
    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        assert (defs == null || defs.length == 1);
        return insts.GetCaughtExceptionInstruction(this.iIndex(), this.bbNumber, defs == null ? this.exceptionValueNumber : defs[0]);
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        return this.getValueString(symbolTable, this.exceptionValueNumber) + " = getCaughtException ";
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitGetCaughtException(this);
    }

    public int getException() {
        return this.exceptionValueNumber;
    }

    @Override
    public boolean hasDef() {
        return true;
    }

    @Override
    public int getDef() {
        return this.exceptionValueNumber;
    }

    @Override
    public int getDef(int i) {
        assert (i == 0);
        return this.exceptionValueNumber;
    }

    @Override
    public int getNumberOfDefs() {
        return 1;
    }

    public int getBasicBlockNumber() {
        return this.bbNumber;
    }

    @Override
    public int hashCode() {
        return 2243 * this.exceptionValueNumber;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }
}

