/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;

public abstract class SSALoadMetadataInstruction
extends SSAInstruction {
    private final int lval;
    private final Object token;
    private final TypeReference entityType;

    protected SSALoadMetadataInstruction(int iindex, int lval, TypeReference entityType, Object token) {
        super(iindex);
        this.lval = lval;
        this.token = token;
        this.entityType = entityType;
        if (token == null) {
            throw new IllegalArgumentException("null typeRef");
        }
    }

    @Override
    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        if (defs != null && defs.length == 0) {
            throw new IllegalArgumentException("(defs != null) and (defs.length == 0)");
        }
        return insts.LoadMetadataInstruction(this.iIndex(), defs == null ? this.lval : defs[0], this.entityType, this.token);
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        return this.getValueString(symbolTable, this.lval) + " = load_metadata: " + this.token + ", " + this.entityType;
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitLoadMetadata(this);
    }

    @Override
    public int hashCode() {
        return this.token.hashCode() * this.lval;
    }

    @Override
    public boolean isPEI() {
        return true;
    }

    @Override
    public boolean hasDef() {
        return true;
    }

    @Override
    public int getDef() {
        return this.lval;
    }

    @Override
    public int getDef(int i) {
        assert (i == 0);
        return this.lval;
    }

    @Override
    public int getNumberOfDefs() {
        return 1;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }

    public Object getToken() {
        return this.token;
    }

    public TypeReference getType() {
        return this.entityType;
    }
}

