/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types.annotations;

import com.ibm.wala.shrike.shrikeCT.AnnotationsReader;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

public class Annotation {
    private final TypeReference type;
    private final Map<String, AnnotationsReader.ElementValue> namedArguments;
    private final Pair<TypeReference, Object>[] unnamedArguments;

    private Annotation(TypeReference type, Map<String, AnnotationsReader.ElementValue> namedArguments, Pair<TypeReference, Object>[] unnamedArguments) {
        this.type = type;
        if (namedArguments == null) {
            throw new IllegalArgumentException("namedArguments is null");
        }
        this.namedArguments = namedArguments;
        this.unnamedArguments = unnamedArguments;
    }

    public static Annotation makeUnnamedAndNamed(TypeReference t, Map<String, AnnotationsReader.ElementValue> namedArguments, Pair<TypeReference, Object>[] unnamedArguments) {
        return new Annotation(t, namedArguments, unnamedArguments);
    }

    public static Annotation makeWithUnnamed(TypeReference t, Pair<TypeReference, Object>[] unnamedArguments) {
        return new Annotation(t, Collections.emptyMap(), unnamedArguments);
    }

    public static Annotation make(TypeReference t) {
        return new Annotation(t, Collections.emptyMap(), null);
    }

    public static Annotation makeWithNamed(TypeReference t, Map<String, AnnotationsReader.ElementValue> namedArguments) {
        return new Annotation(t, namedArguments, null);
    }

    public static Collection<Annotation> getAnnotationsFromReader(AnnotationsReader r, ClassLoaderReference clRef) throws InvalidClassFileException {
        if (r != null) {
            AnnotationsReader.AnnotationAttribute[] allAnnotations = r.getAllAnnotations();
            Collection<Annotation> result = Annotation.convertToAnnotations(clRef, allAnnotations);
            return result;
        }
        return Collections.emptySet();
    }

    public static Collection<Annotation>[] getParameterAnnotationsFromReader(AnnotationsReader r, ClassLoaderReference clRef) throws InvalidClassFileException {
        if (r != null) {
            AnnotationsReader.AnnotationAttribute[][] allAnnots = r.getAllParameterAnnotations();
            Collection[] result = new Collection[allAnnots.length];
            Arrays.setAll(result, i -> Annotation.convertToAnnotations(clRef, allAnnots[i]));
            return result;
        }
        return null;
    }

    protected static Collection<Annotation> convertToAnnotations(ClassLoaderReference clRef, AnnotationsReader.AnnotationAttribute[] allAnnotations) {
        HashSet<Annotation> result = HashSetFactory.make();
        for (AnnotationsReader.AnnotationAttribute annot : allAnnotations) {
            String type = annot.type;
            type = type.replaceAll(";", "");
            TypeReference t = TypeReference.findOrCreate(clRef, type);
            result.add(Annotation.makeWithNamed(t, annot.elementValues));
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Annotation type " + this.type);
        if (this.unnamedArguments != null) {
            sb.append('[');
            for (Pair<TypeReference, Object> arg : this.unnamedArguments) {
                sb.append(' ').append(((TypeReference)arg.fst).getName().getClassName()).append(':').append(arg.snd);
            }
            sb.append(" ]");
        }
        if (!this.namedArguments.isEmpty()) {
            sb.append(' ').append(new TreeMap<String, AnnotationsReader.ElementValue>(this.namedArguments));
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.namedArguments == null ? 0 : this.namedArguments.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + Arrays.hashCode(this.unnamedArguments);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Annotation other = (Annotation)obj;
        if (this.namedArguments == null ? other.namedArguments != null : !this.namedArguments.equals(other.namedArguments)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return Arrays.equals(this.unnamedArguments, other.unnamedArguments);
    }

    public Pair<TypeReference, Object>[] getUnnamedArguments() {
        return this.unnamedArguments;
    }

    public Map<String, AnnotationsReader.ElementValue> getNamedArguments() {
        return this.namedArguments;
    }

    public TypeReference getType() {
        return this.type;
    }
}

