/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.HashSetFactory;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class FifoQueue<T> {
    final ArrayDeque<T> qItems = new ArrayDeque();
    final Set<T> inQueue = HashSetFactory.make();

    public FifoQueue() {
    }

    public FifoQueue(T element) {
        this.push(element);
    }

    public FifoQueue(Collection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("collection is null");
        }
        this.push(collection.iterator());
    }

    public int size() {
        return this.qItems.size();
    }

    public boolean isEmpty() {
        return this.qItems.isEmpty();
    }

    public boolean contains(T element) {
        return this.inQueue.contains(element);
    }

    public void push(T element) {
        if (this.inQueue.add(element)) {
            this.qItems.add(element);
        }
    }

    public void push(Iterator<? extends T> elements) throws IllegalArgumentException {
        if (elements == null) {
            throw new IllegalArgumentException("elements == null");
        }
        while (elements.hasNext()) {
            T element = elements.next();
            if (!this.inQueue.add(element)) continue;
            this.qItems.add(element);
        }
    }

    public T pop() throws IllegalStateException {
        if (this.isEmpty()) {
            throw new IllegalStateException("Unexpected empty queue during pop");
        }
        T element = this.qItems.removeLast();
        this.inQueue.remove(element);
        return element;
    }

    public T peek() throws IllegalStateException {
        if (this.isEmpty()) {
            throw new IllegalStateException("Unexpected empty queue during peek");
        }
        return this.qItems.getLast();
    }
}

