/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.graph.NumberedGraph;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class WelshPowell<T> {
    public static <T> Comparator<T> defaultComparator(NumberedGraph<T> G) {
        return (o1, o2) -> {
            int o2edges;
            int o1edges = G.getSuccNodeCount(o1) + G.getPredNodeCount(o1);
            if (o1edges != (o2edges = G.getSuccNodeCount(o2) + G.getPredNodeCount(o2))) {
                return o2edges - o1edges;
            }
            return o2.toString().compareTo(o1.toString());
        };
    }

    public ColoredVertices<T> color(NumberedGraph<T> G) {
        return this.color(G, WelshPowell.defaultComparator(G), Integer.MAX_VALUE);
    }

    public ColoredVertices<T> color(NumberedGraph<T> G, int maxColors) {
        return this.color(G, WelshPowell.defaultComparator(G), maxColors);
    }

    public ColoredVertices<T> color(NumberedGraph<T> G, Comparator<T> order, int maxColors) {
        int[] colors = new int[G.getMaxNumber() + 1];
        Arrays.fill(colors, -1);
        TreeSet<T> vertices = new TreeSet<T>(order);
        for (Object n : G) {
            vertices.add(n);
        }
        int currentColor = 0;
        int colored = 0;
        for (Object n : vertices) {
            int id = G.getNumber(n);
            if (colors[id] != -1) continue;
            colors[id] = currentColor;
            ++colored;
            block2: for (Object m : vertices) {
                if (colors[G.getNumber(m)] != -1) continue;
                for (Object p : Iterator2Iterable.make(G.getPredNodes(m))) {
                    if (colors[G.getNumber(p)] != currentColor) continue;
                    continue block2;
                }
                for (Object s : Iterator2Iterable.make(G.getSuccNodes(m))) {
                    if (colors[G.getNumber(s)] != currentColor) continue;
                    continue block2;
                }
                colors[G.getNumber(m)] = currentColor;
                ++colored;
                if (currentColor != maxColors - 1) continue;
                return new ColoredVertices<T>(false, G, colors, currentColor);
            }
            if (++currentColor != maxColors - 1) continue;
            return new ColoredVertices<T>(false, G, colors, currentColor);
        }
        assert (colored == G.getNumberOfNodes());
        return new ColoredVertices<T>(true, G, colors, currentColor);
    }

    public static class ColoredVertices<T> {
        private final boolean fullColoring;
        private final Map<T, Integer> colors;
        private final int numColors;

        public boolean isFullColoring() {
            return this.fullColoring;
        }

        public Map<T, Integer> getColors() {
            return this.colors;
        }

        public int getNumColors() {
            return this.numColors;
        }

        public ColoredVertices(boolean fullColoring, NumberedGraph<T> G, int[] colors, int numColors) {
            this(fullColoring, ColoredVertices.makeMap(G, colors), numColors);
        }

        private static <T> Map<T, Integer> makeMap(NumberedGraph<T> G, int[] colors) {
            HashMap colorMap = HashMapFactory.make();
            for (int i = 0; i < colors.length; ++i) {
                if (colors[i] == -1) continue;
                colorMap.put(G.getNode(i), colors[i]);
            }
            return colorMap;
        }

        public ColoredVertices(boolean fullColoring, Map<T, Integer> colors, int numColors) {
            this.fullColoring = fullColoring;
            this.colors = colors;
            this.numColors = numColors;
        }

        public String toString() {
            return this.colors.toString();
        }
    }
}

