"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const aws_cdk_lib_2 = require("aws-cdk-lib");
const tasks = require("aws-cdk-lib/aws-stepfunctions-tasks");
const events = require("aws-cdk-lib/aws-events");
const lambda = require("aws-cdk-lib/aws-lambda");
const core_1 = require("@aws-solutions-constructs/core");
const stepfunctions = require("aws-cdk-lib/aws-stepfunctions");
const core_2 = require("@aws-solutions-constructs/core");
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, core_2.generateIntegStackName(__filename));
const submitLambda = core_1.deployLambdaFunction(stack, {
    runtime: lambda.Runtime.NODEJS_14_X,
    code: lambda.Code.fromAsset(`${__dirname}/lambda`),
    handler: 'index.handler'
});
const submitJob = new tasks.LambdaInvoke(stack, 'LambdaTask', {
    lambdaFunction: submitLambda
});
const startState = new stepfunctions.Pass(stack, 'StartState');
startState.next(submitJob);
const props = {
    stateMachineProps: {
        definition: startState,
        timeout: aws_cdk_lib_2.Duration.minutes(5)
    },
    eventRuleProps: {
        schedule: events.Schedule.rate(aws_cdk_lib_2.Duration.minutes(5))
    },
    logGroupProps: {
        removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY
    },
};
new lib_1.EventbridgeToStepfunctions(stack, 'test-eventbridge-stepfunctions-and-lambda-construct', props);
app.synth();
//# sourceMappingURL=data:application/json;base64,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