# Async Task
A simple library for managing asynchrony; inspired by [Microsoft's Task Class](https://learn.microsoft.com/en-us/dotnet/api/system.threading.tasks.task?view=net-7.0).

## Motivation
async_task provides an equally accessible syntax to the `async` and `await`
keywords, but with simpler usage semantics, particularly when calling asynchronous code from within synchronous code. 

## Usage
Import the `Async` class from `async_tasks` and use as a wrapper for callable objects to execute them asynchronously, or
apply as a decorator to permanently transform a function or method into an Async object. 

Invoke Async instances as any other callable. The return of the call will be an `Async.Worker` instance. Workers have a `wait` 
method and a `result` property; when either of these are called, the caller will synchronize with the background worker, 
blocking until completion or timeout.  
e.g.:

```python
from async_task import Async

@Async
def func():
    return 0

worker = func()
worker.wait(1) 
assert worker.result == 0
# it is not necessary to call wait() prior to accessing result, however, it is not possible to provide a timeout with 
# result.
```

```python
from async_task import Async

def func():
    return 0

async_obj = Async(func)
worker = async_obj() 
assert func() == worker.result
```

```python
from async_task import Async

class Cls:
    def __init__(self, attr):
        self.attr = attr
    @Async
    def func(self):
        return self.attr

assert Cls(0).func().result == 0
```