# Generated by Django 3.2.8 on 2021-11-23 19:16

import uuid

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="EmailTemplate",
            fields=[
                ("deleted", models.DateTimeField(editable=False, null=True)),
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("datetime_created", models.DateTimeField(auto_now_add=True)),
                ("datetime_modified", models.DateTimeField(auto_now=True)),
                ("path", models.CharField(max_length=300)),
                ("nickname", models.CharField(max_length=300)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="PushNotification",
            fields=[
                ("deleted", models.DateTimeField(editable=False, null=True)),
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("datetime_created", models.DateTimeField(auto_now_add=True)),
                ("datetime_modified", models.DateTimeField(auto_now=True)),
                ("datetime_sent", models.DateTimeField(blank=True, null=True)),
                ("sent_successfully", models.BooleanField(default=False)),
                ("message", models.CharField(max_length=300)),
                (
                    "from_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="notifications_pushnotification_sending_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "recipients",
                    models.ManyToManyField(
                        related_name="notifications_pushnotification_receiving_users",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="EmailNotification",
            fields=[
                ("deleted", models.DateTimeField(editable=False, null=True)),
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("datetime_created", models.DateTimeField(auto_now_add=True)),
                ("datetime_modified", models.DateTimeField(auto_now=True)),
                ("datetime_sent", models.DateTimeField(blank=True, null=True)),
                ("sent_successfully", models.BooleanField(default=False)),
                ("subject", models.CharField(max_length=300)),
                ("context", models.JSONField(blank=True, null=True)),
                (
                    "from_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="notifications_emailnotification_sending_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "recipients",
                    models.ManyToManyField(
                        related_name="notifications_emailnotification_receiving_users",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "template",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="template",
                        to="notifications.emailtemplate",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="BasicNotification",
            fields=[
                ("deleted", models.DateTimeField(editable=False, null=True)),
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("datetime_created", models.DateTimeField(auto_now_add=True)),
                ("datetime_modified", models.DateTimeField(auto_now=True)),
                ("datetime_sent", models.DateTimeField(blank=True, null=True)),
                ("sent_successfully", models.BooleanField(default=False)),
                ("read", models.BooleanField(default=False)),
                ("message", models.CharField(max_length=600)),
                (
                    "from_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="notifications_basicnotification_sending_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "recipients",
                    models.ManyToManyField(
                        related_name="notifications_basicnotification_receiving_users",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
    ]
