# Generated by Django 3.2.5 on 2021-07-16 14:15

import django.core.serializers.json
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.expressions
import ipam.fields
import taggit.managers


class Migration(migrations.Migration):

    dependencies = [
        ('extras', '0061_extras_change_logging'),
        ('tenancy', '0001_squashed_0012'),
        ('ipam', '0049_prefix_mark_utilized'),
    ]

    operations = [
        migrations.CreateModel(
            name='IPRange',
            fields=[
                ('created', models.DateField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('start_address', ipam.fields.IPAddressField()),
                ('end_address', ipam.fields.IPAddressField()),
                ('size', models.PositiveIntegerField(editable=False)),
                ('status', models.CharField(default='active', max_length=50)),
                ('description', models.CharField(blank=True, max_length=200)),
                ('role', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='ip_ranges', to='ipam.role')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
                ('tenant', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='ip_ranges', to='tenancy.tenant')),
                ('vrf', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='ip_ranges', to='ipam.vrf')),
            ],
            options={
                'verbose_name': 'IP range',
                'verbose_name_plural': 'IP ranges',
                'ordering': (django.db.models.expressions.OrderBy(django.db.models.expressions.F('vrf'), nulls_first=True), 'start_address', 'pk'),
            },
        ),
    ]
