# mypy-boto3-codepipeline

[![PyPI - mypy-boto3-codepipeline](https://img.shields.io/pypi/v/mypy-boto3-codepipeline.svg?color=blue)](https://pypi.org/project/mypy-boto3-codepipeline)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-codepipeline.svg?color=blue)](https://pypi.org/project/mypy-boto3-codepipeline)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.CodePipeline 1.14.38](https://boto3.amazonaws.com/v1/documentation/api/1.14.38/reference/services/codepipeline.html#CodePipeline) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `CodePipeline` service.

```bash
python -m pip install boto3-stubs[codepipeline]
```

## How to use

### Client annotations

`CodePipelineClient` provides annotations for `boto3.client("codepipeline")`.

```python
import boto3

from mypy_boto3_codepipeline import CodePipelineClient
from mypy_boto3_codepipeline.paginator import (
    ListActionExecutionsPaginator,
    ListActionTypesPaginator,
    ListPipelineExecutionsPaginator,
    ListPipelinesPaginator,
    ListTagsForResourcePaginator,
    ListWebhooksPaginator,
)
from mypy_boto3_codepipeline.type_defs import AWSSessionCredentialsTypeDef, ...

client: CodePipelineClient = boto3.client("codepipeline")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CodePipelineClient = session.client("codepipeline")
```

### Paginators annotations

`mypy_boto3_codepipeline.paginator` module contains type annotations for all paginators.

```python

client: CodePipelineClient = boto3.client("codepipeline")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_action_executions_paginator: ListActionExecutionsPaginator = client.get_paginator("list_action_executions")
list_action_types_paginator: ListActionTypesPaginator = client.get_paginator("list_action_types")
list_pipeline_executions_paginator: ListPipelineExecutionsPaginator = client.get_paginator("list_pipeline_executions")
list_pipelines_paginator: ListPipelinesPaginator = client.get_paginator("list_pipelines")
list_tags_for_resource_paginator: ListTagsForResourcePaginator = client.get_paginator("list_tags_for_resource")
list_webhooks_paginator: ListWebhooksPaginator = client.get_paginator("list_webhooks")
```







### Typed dictionations

`mypy_boto3_codepipeline.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> AWSSessionCredentialsTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_codepipeline` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("codepipeline")

session_client = boto3.Session().client("codepipeline")
```
