from typing import Any, Dict, List, Type, TypeVar, Union

import attr

from ..types import UNSET, Unset

T = TypeVar("T", bound="Postv3EmailTemplatesJsonBody")


@attr.s(auto_attribs=True)
class Postv3EmailTemplatesJsonBody:
    """
    Attributes:
        name (Union[Unset, str]): Name of the email template.
        from_name (Union[Unset, str]): Name of the email sender.
        from_email (Union[Unset, str]): From email address.
        cc (Union[Unset, None, str]): Cc address for the email template.
        bcc (Union[Unset, None, str]): Bcc address for the email template.
        subject (Union[Unset, str]): Subject of the email template.
        body (Union[Unset, str]): Body of the email template.
        reply_to (Union[Unset, None, str]): Reply-To address for the email template.
        event (Union[Unset, str]): Event to trigger sending of the email.
        enabled (Union[Unset, bool]): Enable or disable the email template.
        custom (Union[Unset, bool]): Use custom email template.
    """

    name: Union[Unset, str] = UNSET
    from_name: Union[Unset, str] = UNSET
    from_email: Union[Unset, str] = UNSET
    cc: Union[Unset, None, str] = UNSET
    bcc: Union[Unset, None, str] = UNSET
    subject: Union[Unset, str] = UNSET
    body: Union[Unset, str] = UNSET
    reply_to: Union[Unset, None, str] = UNSET
    event: Union[Unset, str] = UNSET
    enabled: Union[Unset, bool] = UNSET
    custom: Union[Unset, bool] = UNSET
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        name = self.name
        from_name = self.from_name
        from_email = self.from_email
        cc = self.cc
        bcc = self.bcc
        subject = self.subject
        body = self.body
        reply_to = self.reply_to
        event = self.event
        enabled = self.enabled
        custom = self.custom

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if name is not UNSET:
            field_dict["name"] = name
        if from_name is not UNSET:
            field_dict["fromName"] = from_name
        if from_email is not UNSET:
            field_dict["fromEmail"] = from_email
        if cc is not UNSET:
            field_dict["cc"] = cc
        if bcc is not UNSET:
            field_dict["bcc"] = bcc
        if subject is not UNSET:
            field_dict["subject"] = subject
        if body is not UNSET:
            field_dict["body"] = body
        if reply_to is not UNSET:
            field_dict["replyTo"] = reply_to
        if event is not UNSET:
            field_dict["event"] = event
        if enabled is not UNSET:
            field_dict["enabled"] = enabled
        if custom is not UNSET:
            field_dict["custom"] = custom

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        name = d.pop("name", UNSET)

        from_name = d.pop("fromName", UNSET)

        from_email = d.pop("fromEmail", UNSET)

        cc = d.pop("cc", UNSET)

        bcc = d.pop("bcc", UNSET)

        subject = d.pop("subject", UNSET)

        body = d.pop("body", UNSET)

        reply_to = d.pop("replyTo", UNSET)

        event = d.pop("event", UNSET)

        enabled = d.pop("enabled", UNSET)

        custom = d.pop("custom", UNSET)

        postv_3_email_templates_json_body = cls(
            name=name,
            from_name=from_name,
            from_email=from_email,
            cc=cc,
            bcc=bcc,
            subject=subject,
            body=body,
            reply_to=reply_to,
            event=event,
            enabled=enabled,
            custom=custom,
        )

        postv_3_email_templates_json_body.additional_properties = d
        return postv_3_email_templates_json_body

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
