# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest 1.0.20.34  # noqa: E501
    The version of the OpenAPI document: 0.8.11
    Contact: contact@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


import pprint
import re  # noqa: F401

import six

from symbol_openapi_client.configuration import Configuration


class MosaicDefinitionTransactionBodyDTO(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'duration': 'str',
        'nonce': 'int',
        'flags': 'int',
        'divisibility': 'int'
    }

    attribute_map = {
        'id': 'id',
        'duration': 'duration',
        'nonce': 'nonce',
        'flags': 'flags',
        'divisibility': 'divisibility'
    }

    def __init__(self, id=None, duration=None, nonce=None, flags=None, divisibility=None, local_vars_configuration=None):  # noqa: E501
        """MosaicDefinitionTransactionBodyDTO - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._duration = None
        self._nonce = None
        self._flags = None
        self._divisibility = None
        self.discriminator = None

        self.id = id
        self.duration = duration
        self.nonce = nonce
        self.flags = flags
        self.divisibility = divisibility

    @property
    def id(self):
        """Gets the id of this MosaicDefinitionTransactionBodyDTO.  # noqa: E501

        Mosaic identifier.  # noqa: E501

        :return: The id of this MosaicDefinitionTransactionBodyDTO.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this MosaicDefinitionTransactionBodyDTO.

        Mosaic identifier.  # noqa: E501

        :param id: The id of this MosaicDefinitionTransactionBodyDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def duration(self):
        """Gets the duration of this MosaicDefinitionTransactionBodyDTO.  # noqa: E501

        Duration expressed in number of blocks.  # noqa: E501

        :return: The duration of this MosaicDefinitionTransactionBodyDTO.  # noqa: E501
        :rtype: str
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """Sets the duration of this MosaicDefinitionTransactionBodyDTO.

        Duration expressed in number of blocks.  # noqa: E501

        :param duration: The duration of this MosaicDefinitionTransactionBodyDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and duration is None:  # noqa: E501
            raise ValueError("Invalid value for `duration`, must not be `None`")  # noqa: E501

        self._duration = duration

    @property
    def nonce(self):
        """Gets the nonce of this MosaicDefinitionTransactionBodyDTO.  # noqa: E501

        Random nonce used to generate the mosaic id.  # noqa: E501

        :return: The nonce of this MosaicDefinitionTransactionBodyDTO.  # noqa: E501
        :rtype: int
        """
        return self._nonce

    @nonce.setter
    def nonce(self, nonce):
        """Sets the nonce of this MosaicDefinitionTransactionBodyDTO.

        Random nonce used to generate the mosaic id.  # noqa: E501

        :param nonce: The nonce of this MosaicDefinitionTransactionBodyDTO.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and nonce is None:  # noqa: E501
            raise ValueError("Invalid value for `nonce`, must not be `None`")  # noqa: E501

        self._nonce = nonce

    @property
    def flags(self):
        """Gets the flags of this MosaicDefinitionTransactionBodyDTO.  # noqa: E501

        - 0x00 (none) - No flags present. - 0x01 (supplyMutable) - Mosaic supports supply changes even when mosaic owner owns partial supply. - 0x02 (transferable) - Mosaic supports transfers between arbitrary accounts. When not set, mosaic can only be transferred to and from mosaic owner. - 0x04 (restrictable) - Mosaic supports custom restrictions configured by mosaic owner.   # noqa: E501

        :return: The flags of this MosaicDefinitionTransactionBodyDTO.  # noqa: E501
        :rtype: int
        """
        return self._flags

    @flags.setter
    def flags(self, flags):
        """Sets the flags of this MosaicDefinitionTransactionBodyDTO.

        - 0x00 (none) - No flags present. - 0x01 (supplyMutable) - Mosaic supports supply changes even when mosaic owner owns partial supply. - 0x02 (transferable) - Mosaic supports transfers between arbitrary accounts. When not set, mosaic can only be transferred to and from mosaic owner. - 0x04 (restrictable) - Mosaic supports custom restrictions configured by mosaic owner.   # noqa: E501

        :param flags: The flags of this MosaicDefinitionTransactionBodyDTO.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and flags is None:  # noqa: E501
            raise ValueError("Invalid value for `flags`, must not be `None`")  # noqa: E501

        self._flags = flags

    @property
    def divisibility(self):
        """Gets the divisibility of this MosaicDefinitionTransactionBodyDTO.  # noqa: E501

        Determines up to what decimal place the mosaic can be divided. Divisibility of 3 means that a mosaic can be divided into smallest parts of 0.001 mosaics. The divisibility must be in the range of 0 and 6.   # noqa: E501

        :return: The divisibility of this MosaicDefinitionTransactionBodyDTO.  # noqa: E501
        :rtype: int
        """
        return self._divisibility

    @divisibility.setter
    def divisibility(self, divisibility):
        """Sets the divisibility of this MosaicDefinitionTransactionBodyDTO.

        Determines up to what decimal place the mosaic can be divided. Divisibility of 3 means that a mosaic can be divided into smallest parts of 0.001 mosaics. The divisibility must be in the range of 0 and 6.   # noqa: E501

        :param divisibility: The divisibility of this MosaicDefinitionTransactionBodyDTO.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and divisibility is None:  # noqa: E501
            raise ValueError("Invalid value for `divisibility`, must not be `None`")  # noqa: E501

        self._divisibility = divisibility

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MosaicDefinitionTransactionBodyDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MosaicDefinitionTransactionBodyDTO):
            return True

        return self.to_dict() != other.to_dict()
