"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DevStack = void 0;
const sns = require("@aws-cdk/aws-sns");
const core_1 = require("@aws-cdk/core");
const __1 = require("../..");
class DevStack extends core_1.Stack {
    constructor(scope, id) {
        super(scope, id, {
            env: {
                account: process.env.CDK_DEFAULT_ACCOUNT,
                region: process.env.CDK_DEFAULT_REGION,
            },
        });
        const topic = new sns.Topic(this, 'Topic');
        new __1.ConstructHub(this, 'ConstructHub', {
            alarmActions: {
                normalSeverity: topic.topicArn,
                highSeverity: topic.topicArn,
            },
        });
    }
}
exports.DevStack = DevStack;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGV2LXN0YWNrLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL19fdGVzdHNfXy9kZXZhcHAvZGV2LXN0YWNrLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHdDQUF3QztBQUN4Qyx3Q0FBaUQ7QUFDakQsNkJBQXFDO0FBRXJDLE1BQWEsUUFBUyxTQUFRLFlBQUs7SUFDakMsWUFBWSxLQUFnQixFQUFFLEVBQVU7UUFDdEMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixHQUFHLEVBQUU7Z0JBQ0gsT0FBTyxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsbUJBQW1CO2dCQUN4QyxNQUFNLEVBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxrQkFBa0I7YUFDdkM7U0FDRixDQUFDLENBQUM7UUFFSCxNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsSUFBSSxFQUFFLE9BQU8sQ0FBQyxDQUFDO1FBRTNDLElBQUksZ0JBQVksQ0FBQyxJQUFJLEVBQUUsY0FBYyxFQUFFO1lBQ3JDLFlBQVksRUFBRTtnQkFDWixjQUFjLEVBQUUsS0FBSyxDQUFDLFFBQVE7Z0JBQzlCLFlBQVksRUFBRSxLQUFLLENBQUMsUUFBUTthQUM3QjtTQUNGLENBQUMsQ0FBQztJQUNMLENBQUM7Q0FDRjtBQWxCRCw0QkFrQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBzbnMgZnJvbSAnQGF3cy1jZGsvYXdzLXNucyc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QsIFN0YWNrIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3RIdWIgfSBmcm9tICcuLi8uLic7XG5cbmV4cG9ydCBjbGFzcyBEZXZTdGFjayBleHRlbmRzIFN0YWNrIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgZW52OiB7XG4gICAgICAgIGFjY291bnQ6IHByb2Nlc3MuZW52LkNES19ERUZBVUxUX0FDQ09VTlQsXG4gICAgICAgIHJlZ2lvbjogcHJvY2Vzcy5lbnYuQ0RLX0RFRkFVTFRfUkVHSU9OLFxuICAgICAgfSxcbiAgICB9KTtcblxuICAgIGNvbnN0IHRvcGljID0gbmV3IHNucy5Ub3BpYyh0aGlzLCAnVG9waWMnKTtcblxuICAgIG5ldyBDb25zdHJ1Y3RIdWIodGhpcywgJ0NvbnN0cnVjdEh1YicsIHtcbiAgICAgIGFsYXJtQWN0aW9uczoge1xuICAgICAgICBub3JtYWxTZXZlcml0eTogdG9waWMudG9waWNBcm4sXG4gICAgICAgIGhpZ2hTZXZlcml0eTogdG9waWMudG9waWNBcm4sXG4gICAgICB9LFxuICAgIH0pO1xuICB9XG59XG4iXX0=