"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const core_1 = require("@aws-cdk/core");
const cxapi = require("@aws-cdk/cx-api");
const yaml_1 = require("yaml");
const dev_stack_1 = require("./dev-stack");
expect.addSnapshotSerializer({
    test: (val) => val instanceof cxapi.CloudFormationStackArtifact,
    serialize: (val) => yaml_1.stringify(val.template),
});
test.skip('golden snapshot (Pending resolution of https://github.com/cdklabs/construct-hub/pull/171)', () => {
    const app = new core_1.App();
    const stack = new dev_stack_1.DevStack(app, 'dev');
    expect(app.synth().getStackByName(stack.stackName)).toMatchSnapshot();
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25hcHNob3QudGVzdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9fX3Rlc3RzX18vZGV2YXBwL3NuYXBzaG90LnRlc3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxnQ0FBOEI7QUFFOUIsd0NBQW9DO0FBQ3BDLHlDQUF5QztBQUN6QywrQkFBeUM7QUFFekMsMkNBQXVDO0FBRXZDLE1BQU0sQ0FBQyxxQkFBcUIsQ0FBQztJQUMzQixJQUFJLEVBQUUsQ0FBQyxHQUFHLEVBQUUsRUFBRSxDQUFDLEdBQUcsWUFBWSxLQUFLLENBQUMsMkJBQTJCO0lBQy9ELFNBQVMsRUFBRSxDQUFDLEdBQXNDLEVBQUUsRUFBRSxDQUFDLGdCQUFJLENBQUMsR0FBRyxDQUFDLFFBQVEsQ0FBQztDQUMxRSxDQUFDLENBQUM7QUFFSCxJQUFJLENBQUMsSUFBSSxDQUFDLDJGQUEyRixFQUFFLEdBQUcsRUFBRTtJQUMxRyxNQUFNLEdBQUcsR0FBRyxJQUFJLFVBQUcsRUFBRSxDQUFDO0lBQ3RCLE1BQU0sS0FBSyxHQUFHLElBQUksb0JBQVEsQ0FBQyxHQUFHLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDdkMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyxjQUFjLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsZUFBZSxFQUFFLENBQUM7QUFDeEUsQ0FBQyxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgJ0Bhd3MtY2RrL2Fzc2VydC9qZXN0JztcblxuaW1wb3J0IHsgQXBwIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgKiBhcyBjeGFwaSBmcm9tICdAYXdzLWNkay9jeC1hcGknO1xuaW1wb3J0IHsgc3RyaW5naWZ5IGFzIHlhbWwgfSBmcm9tICd5YW1sJztcblxuaW1wb3J0IHsgRGV2U3RhY2sgfSBmcm9tICcuL2Rldi1zdGFjayc7XG5cbmV4cGVjdC5hZGRTbmFwc2hvdFNlcmlhbGl6ZXIoe1xuICB0ZXN0OiAodmFsKSA9PiB2YWwgaW5zdGFuY2VvZiBjeGFwaS5DbG91ZEZvcm1hdGlvblN0YWNrQXJ0aWZhY3QsXG4gIHNlcmlhbGl6ZTogKHZhbDogY3hhcGkuQ2xvdWRGb3JtYXRpb25TdGFja0FydGlmYWN0KSA9PiB5YW1sKHZhbC50ZW1wbGF0ZSksXG59KTtcblxudGVzdC5za2lwKCdnb2xkZW4gc25hcHNob3QgKFBlbmRpbmcgcmVzb2x1dGlvbiBvZiBodHRwczovL2dpdGh1Yi5jb20vY2RrbGFicy9jb25zdHJ1Y3QtaHViL3B1bGwvMTcxKScsICgpID0+IHtcbiAgY29uc3QgYXBwID0gbmV3IEFwcCgpO1xuICBjb25zdCBzdGFjayA9IG5ldyBEZXZTdGFjayhhcHAsICdkZXYnKTtcbiAgZXhwZWN0KGFwcC5zeW50aCgpLmdldFN0YWNrQnlOYW1lKHN0YWNrLnN0YWNrTmFtZSkpLnRvTWF0Y2hTbmFwc2hvdCgpO1xufSk7XG4iXX0=