"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.reset = exports.sqs = exports.s3 = void 0;
const AWS = require("aws-sdk");
let _s3;
let _sqs;
function s3() {
    if (_s3 == null) {
        _s3 = new AWS.S3();
    }
    return _s3;
}
exports.s3 = s3;
function sqs() {
    if (_sqs == null) {
        _sqs = new AWS.SQS();
    }
    return _sqs;
}
exports.sqs = sqs;
/**
 * Resets all clients vended by this module. This is useful in unit tests when
 * `aws-sdk-mocks` is used, so that new mocks are injected as intended.
 */
function reset() {
    _s3 = _sqs = undefined;
}
exports.reset = reset;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzLmxhbWJkYS1zaGFyZWQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvYmFja2VuZC9zaGFyZWQvYXdzLmxhbWJkYS1zaGFyZWQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsK0JBQStCO0FBRS9CLElBQUksR0FBdUIsQ0FBQztBQUM1QixJQUFJLElBQXlCLENBQUM7QUFFOUIsU0FBZ0IsRUFBRTtJQUNoQixJQUFJLEdBQUcsSUFBSSxJQUFJLEVBQUU7UUFDZixHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsRUFBRSxFQUFFLENBQUM7S0FDcEI7SUFDRCxPQUFPLEdBQUcsQ0FBQztBQUNiLENBQUM7QUFMRCxnQkFLQztBQUVELFNBQWdCLEdBQUc7SUFDakIsSUFBSSxJQUFJLElBQUksSUFBSSxFQUFFO1FBQ2hCLElBQUksR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztLQUN0QjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQUxELGtCQUtDO0FBRUQ7OztHQUdHO0FBQ0gsU0FBZ0IsS0FBSztJQUNuQixHQUFHLEdBQUcsSUFBSSxHQUFHLFNBQVMsQ0FBQztBQUN6QixDQUFDO0FBRkQsc0JBRUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBBV1MgZnJvbSAnYXdzLXNkayc7XG5cbmxldCBfczM6IEFXUy5TMyB8IHVuZGVmaW5lZDtcbmxldCBfc3FzOiBBV1MuU1FTIHwgdW5kZWZpbmVkO1xuXG5leHBvcnQgZnVuY3Rpb24gczMoKTogQVdTLlMzIHtcbiAgaWYgKF9zMyA9PSBudWxsKSB7XG4gICAgX3MzID0gbmV3IEFXUy5TMygpO1xuICB9XG4gIHJldHVybiBfczM7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBzcXMoKTogQVdTLlNRUyB7XG4gIGlmIChfc3FzID09IG51bGwpIHtcbiAgICBfc3FzID0gbmV3IEFXUy5TUVMoKTtcbiAgfVxuICByZXR1cm4gX3Nxcztcbn1cblxuLyoqXG4gKiBSZXNldHMgYWxsIGNsaWVudHMgdmVuZGVkIGJ5IHRoaXMgbW9kdWxlLiBUaGlzIGlzIHVzZWZ1bCBpbiB1bml0IHRlc3RzIHdoZW5cbiAqIGBhd3Mtc2RrLW1vY2tzYCBpcyB1c2VkLCBzbyB0aGF0IG5ldyBtb2NrcyBhcmUgaW5qZWN0ZWQgYXMgaW50ZW5kZWQuXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiByZXNldCgpOiB2b2lkIHtcbiAgX3MzID0gX3NxcyA9IHVuZGVmaW5lZDtcbn1cbiJdfQ==