"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructHub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const backend_1 = require("./backend");
const inventory_1 = require("./backend/inventory");
const repository_1 = require("./codeartifact/repository");
const monitoring_1 = require("./monitoring");
const webapp_1 = require("./webapp");
/**
 * (experimental) Construct Hub.
 *
 * @experimental
 */
class ConstructHub extends core_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        const monitoring = new monitoring_1.Monitoring(this, 'Monitoring', {
            alarmActions: props.alarmActions,
            dashboardName: (_b = props.dashboardName) !== null && _b !== void 0 ? _b : 'construct-hub',
        });
        const packageData = new s3.Bucket(this, 'PackageData', {
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            encryption: s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [
                // Abort multi-part uploads after 1 day
                { abortIncompleteMultipartUploadAfter: core_1.Duration.days(1) },
                // Transition non-current object versions to IA after 1 month
                { noncurrentVersionTransitions: [{ storageClass: s3.StorageClass.INFREQUENT_ACCESS, transitionAfter: core_1.Duration.days(31) }] },
                // Permanently delete non-current object versions after 3 months
                { noncurrentVersionExpiration: core_1.Duration.days(90) },
            ],
            versioned: true,
        });
        const codeArtifact = new repository_1.Repository(this, 'CodeArtifact', { description: 'Proxy to npmjs.com for ConstructHub' });
        const vpc = ((_c = props.isolateLambdas) !== null && _c !== void 0 ? _c : true)
            ? new ec2.Vpc(this, 'VPC', {
                enableDnsHostnames: true,
                enableDnsSupport: true,
                natGateways: 0,
                subnetConfiguration: [{ name: 'Isolated', subnetType: ec2.SubnetType.ISOLATED }],
            })
            : undefined;
        const vpcEndpoints = vpc && {
            codeArtifactApi: vpc.addInterfaceEndpoint('CodeArtifact.API', {
                privateDnsEnabled: false,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.api'),
                subnets: { subnetType: ec2.SubnetType.ISOLATED },
            }),
            codeArtifact: vpc.addInterfaceEndpoint('CodeArtifact', {
                privateDnsEnabled: true,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.repositories'),
                subnets: { subnetType: ec2.SubnetType.ISOLATED },
            }),
            s3: vpc.addGatewayEndpoint('S3', {
                service: ec2.GatewayVpcEndpointAwsService.S3,
                subnets: [{ subnetType: ec2.SubnetType.ISOLATED }],
            }),
        };
        // The S3 access is necessary for the CodeArtifact VPC endpoint to be used.
        vpcEndpoints === null || vpcEndpoints === void 0 ? void 0 : vpcEndpoints.s3.addToPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['s3:GetObject'],
            resources: [`${codeArtifact.s3BucketArn}/*`],
            principals: [new aws_iam_1.AnyPrincipal()],
            sid: 'Allow-CodeArtifact-Bucket',
        }));
        this.ingestion = new backend_1.Ingestion(this, 'Ingestion', { bucket: packageData, monitoring });
        const discovery = new backend_1.Discovery(this, 'Discovery', { queue: this.ingestion.queue, monitoring });
        discovery.bucket.grantRead(this.ingestion);
        new backend_1.Transliterator(this, 'Transliterator', { bucket: packageData, codeArtifact, monitoring, vpc, vpcEndpoints });
        new backend_1.CatalogBuilder(this, 'CatalogBuilder', { bucket: packageData, monitoring });
        new inventory_1.Inventory(this, 'InventoryCanary', { bucket: packageData, monitoring });
        new webapp_1.WebApp(this, 'WebApp', {
            domain: props.domain,
            monitoring,
            packageData,
        });
    }
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    get grantPrincipal() {
        return this.ingestion.grantPrincipal;
    }
    /**
     * @experimental
     */
    get ingestionQueue() {
        return this.ingestion.queue;
    }
}
exports.ConstructHub = ConstructHub;
_a = JSII_RTTI_SYMBOL_1;
ConstructHub[_a] = { fqn: "construct-hub.ConstructHub", version: "0.1.78" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29uc3RydWN0LWh1Yi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9jb25zdHJ1Y3QtaHViLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsd0NBQXdDO0FBRXhDLDhDQUF5RTtBQUN6RSxzQ0FBc0M7QUFDdEMsNENBQW9EO0FBRXBELHdDQUFxRTtBQUdyRSx1Q0FBaUY7QUFDakYsbURBQWdEO0FBQ2hELDBEQUF1RDtBQUN2RCw2Q0FBMEM7QUFDMUMscUNBQWtDOzs7Ozs7QUFrQmxDLE1BQWEsWUFBYSxTQUFRLGdCQUFhOzs7O0lBRzdDLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXdCOztRQUN2RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sVUFBVSxHQUFHLElBQUksdUJBQVUsQ0FBQyxJQUFJLEVBQUUsWUFBWSxFQUFFO1lBQ3BELFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWTtZQUNoQyxhQUFhLFFBQUUsS0FBSyxDQUFDLGFBQWEsbUNBQUksZUFBZTtTQUN0RCxDQUFDLENBQUM7UUFFSCxNQUFNLFdBQVcsR0FBRyxJQUFJLEVBQUUsQ0FBQyxNQUFNLENBQUMsSUFBSSxFQUFFLGFBQWEsRUFBRTtZQUNyRCxpQkFBaUIsRUFBRSwwQkFBaUIsQ0FBQyxTQUFTO1lBQzlDLFVBQVUsRUFBRSxFQUFFLENBQUMsZ0JBQWdCLENBQUMsVUFBVTtZQUMxQyxjQUFjLEVBQUU7Z0JBQ2QsdUNBQXVDO2dCQUN2QyxFQUFFLG1DQUFtQyxFQUFFLGVBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUU7Z0JBQ3pELDZEQUE2RDtnQkFDN0QsRUFBRSw0QkFBNEIsRUFBRSxDQUFDLEVBQUUsWUFBWSxFQUFFLEVBQUUsQ0FBQyxZQUFZLENBQUMsaUJBQWlCLEVBQUUsZUFBZSxFQUFFLGVBQVEsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxFQUFFO2dCQUMzSCxnRUFBZ0U7Z0JBQ2hFLEVBQUUsMkJBQTJCLEVBQUUsZUFBUSxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsRUFBRTthQUNuRDtZQUNELFNBQVMsRUFBRSxJQUFJO1NBQ2hCLENBQUMsQ0FBQztRQUVILE1BQU0sWUFBWSxHQUFHLElBQUksdUJBQVUsQ0FBQyxJQUFJLEVBQUUsY0FBYyxFQUFFLEVBQUUsV0FBVyxFQUFFLHFDQUFxQyxFQUFFLENBQUMsQ0FBQztRQUVsSCxNQUFNLEdBQUcsR0FBRyxPQUFDLEtBQUssQ0FBQyxjQUFjLG1DQUFJLElBQUksQ0FBQztZQUN4QyxDQUFDLENBQUMsSUFBSSxHQUFHLENBQUMsR0FBRyxDQUFDLElBQUksRUFBRSxLQUFLLEVBQUU7Z0JBQ3pCLGtCQUFrQixFQUFFLElBQUk7Z0JBQ3hCLGdCQUFnQixFQUFFLElBQUk7Z0JBQ3RCLFdBQVcsRUFBRSxDQUFDO2dCQUNkLG1CQUFtQixFQUFFLENBQUMsRUFBRSxJQUFJLEVBQUUsVUFBVSxFQUFFLFVBQVUsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLFFBQVEsRUFBRSxDQUFDO2FBQ2pGLENBQUM7WUFDRixDQUFDLENBQUMsU0FBUyxDQUFDO1FBQ2QsTUFBTSxZQUFZLEdBQUcsR0FBRyxJQUFJO1lBQzFCLGVBQWUsRUFBRSxHQUFHLENBQUMsb0JBQW9CLENBQUMsa0JBQWtCLEVBQUU7Z0JBQzVELGlCQUFpQixFQUFFLEtBQUs7Z0JBQ3hCLE9BQU8sRUFBRSxJQUFJLEdBQUcsQ0FBQyw4QkFBOEIsQ0FBQyxrQkFBa0IsQ0FBQztnQkFDbkUsT0FBTyxFQUFFLEVBQUUsVUFBVSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsUUFBUSxFQUFFO2FBQ2pELENBQUM7WUFDRixZQUFZLEVBQUUsR0FBRyxDQUFDLG9CQUFvQixDQUFDLGNBQWMsRUFBRTtnQkFDckQsaUJBQWlCLEVBQUUsSUFBSTtnQkFDdkIsT0FBTyxFQUFFLElBQUksR0FBRyxDQUFDLDhCQUE4QixDQUFDLDJCQUEyQixDQUFDO2dCQUM1RSxPQUFPLEVBQUUsRUFBRSxVQUFVLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxRQUFRLEVBQUU7YUFDakQsQ0FBQztZQUNGLEVBQUUsRUFBRSxHQUFHLENBQUMsa0JBQWtCLENBQUMsSUFBSSxFQUFFO2dCQUMvQixPQUFPLEVBQUUsR0FBRyxDQUFDLDRCQUE0QixDQUFDLEVBQUU7Z0JBQzVDLE9BQU8sRUFBRSxDQUFDLEVBQUUsVUFBVSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsUUFBUSxFQUFFLENBQUM7YUFDbkQsQ0FBQztTQUNILENBQUM7UUFDRiwyRUFBMkU7UUFDM0UsWUFBWSxhQUFaLFlBQVksdUJBQVosWUFBWSxDQUFFLEVBQUUsQ0FBQyxXQUFXLENBQUMsSUFBSSx5QkFBZSxDQUFDO1lBQy9DLE1BQU0sRUFBRSxnQkFBTSxDQUFDLEtBQUs7WUFDcEIsT0FBTyxFQUFFLENBQUMsY0FBYyxDQUFDO1lBQ3pCLFNBQVMsRUFBRSxDQUFDLEdBQUcsWUFBWSxDQUFDLFdBQVcsSUFBSSxDQUFDO1lBQzVDLFVBQVUsRUFBRSxDQUFDLElBQUksc0JBQVksRUFBRSxDQUFDO1lBQ2hDLEdBQUcsRUFBRSwyQkFBMkI7U0FDakMsQ0FBQyxFQUFFO1FBRUosSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLG1CQUFTLENBQUMsSUFBSSxFQUFFLFdBQVcsRUFBRSxFQUFFLE1BQU0sRUFBRSxXQUFXLEVBQUUsVUFBVSxFQUFFLENBQUMsQ0FBQztRQUV2RixNQUFNLFNBQVMsR0FBRyxJQUFJLG1CQUFTLENBQUMsSUFBSSxFQUFFLFdBQVcsRUFBRSxFQUFFLEtBQUssRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssRUFBRSxVQUFVLEVBQUUsQ0FBQyxDQUFDO1FBQ2hHLFNBQVMsQ0FBQyxNQUFNLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FBQztRQUUzQyxJQUFJLHdCQUFjLENBQUMsSUFBSSxFQUFFLGdCQUFnQixFQUFFLEVBQUUsTUFBTSxFQUFFLFdBQVcsRUFBRSxZQUFZLEVBQUUsVUFBVSxFQUFFLEdBQUcsRUFBRSxZQUFZLEVBQUUsQ0FBQyxDQUFDO1FBQ2pILElBQUksd0JBQWMsQ0FBQyxJQUFJLEVBQUUsZ0JBQWdCLEVBQUUsRUFBRSxNQUFNLEVBQUUsV0FBVyxFQUFFLFVBQVUsRUFBRSxDQUFDLENBQUM7UUFFaEYsSUFBSSxxQkFBUyxDQUFDLElBQUksRUFBRSxpQkFBaUIsRUFBRSxFQUFFLE1BQU0sRUFBRSxXQUFXLEVBQUUsVUFBVSxFQUFFLENBQUMsQ0FBQztRQUU1RSxJQUFJLGVBQU0sQ0FBQyxJQUFJLEVBQUUsUUFBUSxFQUFFO1lBQ3pCLE1BQU0sRUFBRSxLQUFLLENBQUMsTUFBTTtZQUNwQixVQUFVO1lBQ1YsV0FBVztTQUNaLENBQUMsQ0FBQztJQUNMLENBQUM7Ozs7OztJQUVELElBQVcsY0FBYztRQUN2QixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUMsY0FBYyxDQUFDO0lBQ3ZDLENBQUM7Ozs7SUFFRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssQ0FBQztJQUM5QixDQUFDOztBQW5GSCxvQ0FvRkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBlYzIgZnJvbSAnQGF3cy1jZGsvYXdzLWVjMic7XG5pbXBvcnQgKiBhcyBpYW0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgeyBBbnlQcmluY2lwYWwsIEVmZmVjdCwgUG9saWN5U3RhdGVtZW50IH0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgKiBhcyBzMyBmcm9tICdAYXdzLWNkay9hd3MtczMnO1xuaW1wb3J0IHsgQmxvY2tQdWJsaWNBY2Nlc3MgfSBmcm9tICdAYXdzLWNkay9hd3MtczMnO1xuaW1wb3J0ICogYXMgc3FzIGZyb20gJ0Bhd3MtY2RrL2F3cy1zcXMnO1xuaW1wb3J0IHsgQ29uc3RydWN0IGFzIENvcmVDb25zdHJ1Y3QsIER1cmF0aW9uIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IEFsYXJtQWN0aW9ucywgRG9tYWluIH0gZnJvbSAnLi9hcGknO1xuaW1wb3J0IHsgQ2F0YWxvZ0J1aWxkZXIsIERpc2NvdmVyeSwgSW5nZXN0aW9uLCBUcmFuc2xpdGVyYXRvciB9IGZyb20gJy4vYmFja2VuZCc7XG5pbXBvcnQgeyBJbnZlbnRvcnkgfSBmcm9tICcuL2JhY2tlbmQvaW52ZW50b3J5JztcbmltcG9ydCB7IFJlcG9zaXRvcnkgfSBmcm9tICcuL2NvZGVhcnRpZmFjdC9yZXBvc2l0b3J5JztcbmltcG9ydCB7IE1vbml0b3JpbmcgfSBmcm9tICcuL21vbml0b3JpbmcnO1xuaW1wb3J0IHsgV2ViQXBwIH0gZnJvbSAnLi93ZWJhcHAnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgQ29uc3RydWN0SHViUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBkb21haW4/OiBEb21haW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGRhc2hib2FyZE5hbWU/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGFsYXJtQWN0aW9uczogQWxhcm1BY3Rpb25zO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBpc29sYXRlTGFtYmRhcz86IGJvb2xlYW47XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBDb25zdHJ1Y3RIdWIgZXh0ZW5kcyBDb3JlQ29uc3RydWN0IGltcGxlbWVudHMgaWFtLklHcmFudGFibGUge1xuICBwcml2YXRlIHJlYWRvbmx5IGluZ2VzdGlvbjogSW5nZXN0aW9uO1xuXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ29uc3RydWN0SHViUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3QgbW9uaXRvcmluZyA9IG5ldyBNb25pdG9yaW5nKHRoaXMsICdNb25pdG9yaW5nJywge1xuICAgICAgYWxhcm1BY3Rpb25zOiBwcm9wcy5hbGFybUFjdGlvbnMsXG4gICAgICBkYXNoYm9hcmROYW1lOiBwcm9wcy5kYXNoYm9hcmROYW1lID8/ICdjb25zdHJ1Y3QtaHViJyxcbiAgICB9KTtcblxuICAgIGNvbnN0IHBhY2thZ2VEYXRhID0gbmV3IHMzLkJ1Y2tldCh0aGlzLCAnUGFja2FnZURhdGEnLCB7XG4gICAgICBibG9ja1B1YmxpY0FjY2VzczogQmxvY2tQdWJsaWNBY2Nlc3MuQkxPQ0tfQUxMLFxuICAgICAgZW5jcnlwdGlvbjogczMuQnVja2V0RW5jcnlwdGlvbi5TM19NQU5BR0VELFxuICAgICAgbGlmZWN5Y2xlUnVsZXM6IFtcbiAgICAgICAgLy8gQWJvcnQgbXVsdGktcGFydCB1cGxvYWRzIGFmdGVyIDEgZGF5XG4gICAgICAgIHsgYWJvcnRJbmNvbXBsZXRlTXVsdGlwYXJ0VXBsb2FkQWZ0ZXI6IER1cmF0aW9uLmRheXMoMSkgfSxcbiAgICAgICAgLy8gVHJhbnNpdGlvbiBub24tY3VycmVudCBvYmplY3QgdmVyc2lvbnMgdG8gSUEgYWZ0ZXIgMSBtb250aFxuICAgICAgICB7IG5vbmN1cnJlbnRWZXJzaW9uVHJhbnNpdGlvbnM6IFt7IHN0b3JhZ2VDbGFzczogczMuU3RvcmFnZUNsYXNzLklORlJFUVVFTlRfQUNDRVNTLCB0cmFuc2l0aW9uQWZ0ZXI6IER1cmF0aW9uLmRheXMoMzEpIH1dIH0sXG4gICAgICAgIC8vIFBlcm1hbmVudGx5IGRlbGV0ZSBub24tY3VycmVudCBvYmplY3QgdmVyc2lvbnMgYWZ0ZXIgMyBtb250aHNcbiAgICAgICAgeyBub25jdXJyZW50VmVyc2lvbkV4cGlyYXRpb246IER1cmF0aW9uLmRheXMoOTApIH0sXG4gICAgICBdLFxuICAgICAgdmVyc2lvbmVkOiB0cnVlLFxuICAgIH0pO1xuXG4gICAgY29uc3QgY29kZUFydGlmYWN0ID0gbmV3IFJlcG9zaXRvcnkodGhpcywgJ0NvZGVBcnRpZmFjdCcsIHsgZGVzY3JpcHRpb246ICdQcm94eSB0byBucG1qcy5jb20gZm9yIENvbnN0cnVjdEh1YicgfSk7XG5cbiAgICBjb25zdCB2cGMgPSAocHJvcHMuaXNvbGF0ZUxhbWJkYXMgPz8gdHJ1ZSlcbiAgICAgID8gbmV3IGVjMi5WcGModGhpcywgJ1ZQQycsIHtcbiAgICAgICAgZW5hYmxlRG5zSG9zdG5hbWVzOiB0cnVlLFxuICAgICAgICBlbmFibGVEbnNTdXBwb3J0OiB0cnVlLFxuICAgICAgICBuYXRHYXRld2F5czogMCxcbiAgICAgICAgc3VibmV0Q29uZmlndXJhdGlvbjogW3sgbmFtZTogJ0lzb2xhdGVkJywgc3VibmV0VHlwZTogZWMyLlN1Ym5ldFR5cGUuSVNPTEFURUQgfV0sXG4gICAgICB9KVxuICAgICAgOiB1bmRlZmluZWQ7XG4gICAgY29uc3QgdnBjRW5kcG9pbnRzID0gdnBjICYmIHtcbiAgICAgIGNvZGVBcnRpZmFjdEFwaTogdnBjLmFkZEludGVyZmFjZUVuZHBvaW50KCdDb2RlQXJ0aWZhY3QuQVBJJywge1xuICAgICAgICBwcml2YXRlRG5zRW5hYmxlZDogZmFsc2UsXG4gICAgICAgIHNlcnZpY2U6IG5ldyBlYzIuSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdjb2RlYXJ0aWZhY3QuYXBpJyksXG4gICAgICAgIHN1Ym5ldHM6IHsgc3VibmV0VHlwZTogZWMyLlN1Ym5ldFR5cGUuSVNPTEFURUQgfSxcbiAgICAgIH0pLFxuICAgICAgY29kZUFydGlmYWN0OiB2cGMuYWRkSW50ZXJmYWNlRW5kcG9pbnQoJ0NvZGVBcnRpZmFjdCcsIHtcbiAgICAgICAgcHJpdmF0ZURuc0VuYWJsZWQ6IHRydWUsXG4gICAgICAgIHNlcnZpY2U6IG5ldyBlYzIuSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlKCdjb2RlYXJ0aWZhY3QucmVwb3NpdG9yaWVzJyksXG4gICAgICAgIHN1Ym5ldHM6IHsgc3VibmV0VHlwZTogZWMyLlN1Ym5ldFR5cGUuSVNPTEFURUQgfSxcbiAgICAgIH0pLFxuICAgICAgczM6IHZwYy5hZGRHYXRld2F5RW5kcG9pbnQoJ1MzJywge1xuICAgICAgICBzZXJ2aWNlOiBlYzIuR2F0ZXdheVZwY0VuZHBvaW50QXdzU2VydmljZS5TMyxcbiAgICAgICAgc3VibmV0czogW3sgc3VibmV0VHlwZTogZWMyLlN1Ym5ldFR5cGUuSVNPTEFURUQgfV0sXG4gICAgICB9KSxcbiAgICB9O1xuICAgIC8vIFRoZSBTMyBhY2Nlc3MgaXMgbmVjZXNzYXJ5IGZvciB0aGUgQ29kZUFydGlmYWN0IFZQQyBlbmRwb2ludCB0byBiZSB1c2VkLlxuICAgIHZwY0VuZHBvaW50cz8uczMuYWRkVG9Qb2xpY3kobmV3IFBvbGljeVN0YXRlbWVudCh7XG4gICAgICBlZmZlY3Q6IEVmZmVjdC5BTExPVyxcbiAgICAgIGFjdGlvbnM6IFsnczM6R2V0T2JqZWN0J10sXG4gICAgICByZXNvdXJjZXM6IFtgJHtjb2RlQXJ0aWZhY3QuczNCdWNrZXRBcm59LypgXSxcbiAgICAgIHByaW5jaXBhbHM6IFtuZXcgQW55UHJpbmNpcGFsKCldLFxuICAgICAgc2lkOiAnQWxsb3ctQ29kZUFydGlmYWN0LUJ1Y2tldCcsXG4gICAgfSkpO1xuXG4gICAgdGhpcy5pbmdlc3Rpb24gPSBuZXcgSW5nZXN0aW9uKHRoaXMsICdJbmdlc3Rpb24nLCB7IGJ1Y2tldDogcGFja2FnZURhdGEsIG1vbml0b3JpbmcgfSk7XG5cbiAgICBjb25zdCBkaXNjb3ZlcnkgPSBuZXcgRGlzY292ZXJ5KHRoaXMsICdEaXNjb3ZlcnknLCB7IHF1ZXVlOiB0aGlzLmluZ2VzdGlvbi5xdWV1ZSwgbW9uaXRvcmluZyB9KTtcbiAgICBkaXNjb3ZlcnkuYnVja2V0LmdyYW50UmVhZCh0aGlzLmluZ2VzdGlvbik7XG5cbiAgICBuZXcgVHJhbnNsaXRlcmF0b3IodGhpcywgJ1RyYW5zbGl0ZXJhdG9yJywgeyBidWNrZXQ6IHBhY2thZ2VEYXRhLCBjb2RlQXJ0aWZhY3QsIG1vbml0b3JpbmcsIHZwYywgdnBjRW5kcG9pbnRzIH0pO1xuICAgIG5ldyBDYXRhbG9nQnVpbGRlcih0aGlzLCAnQ2F0YWxvZ0J1aWxkZXInLCB7IGJ1Y2tldDogcGFja2FnZURhdGEsIG1vbml0b3JpbmcgfSk7XG5cbiAgICBuZXcgSW52ZW50b3J5KHRoaXMsICdJbnZlbnRvcnlDYW5hcnknLCB7IGJ1Y2tldDogcGFja2FnZURhdGEsIG1vbml0b3JpbmcgfSk7XG5cbiAgICBuZXcgV2ViQXBwKHRoaXMsICdXZWJBcHAnLCB7XG4gICAgICBkb21haW46IHByb3BzLmRvbWFpbixcbiAgICAgIG1vbml0b3JpbmcsXG4gICAgICBwYWNrYWdlRGF0YSxcbiAgICB9KTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgZ3JhbnRQcmluY2lwYWwoKTogaWFtLklQcmluY2lwYWwge1xuICAgIHJldHVybiB0aGlzLmluZ2VzdGlvbi5ncmFudFByaW5jaXBhbDtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW5nZXN0aW9uUXVldWUoKTogc3FzLklRdWV1ZSB7XG4gICAgcmV0dXJuIHRoaXMuaW5nZXN0aW9uLnF1ZXVlO1xuICB9XG59XG4iXX0=