from localgraphclustering import *
import time
import numpy as np
import sys
from collections import defaultdict
import pytest

sys.path.append("notebooks/")

from helper import *
import random

@pytest.mark.deep_tests
def test_flow_deep():
    correct_output = defaultdict(dict)
    correct_output["dolphins"]["crd"] = [(22, 0.0707070707070707),
                                 (40, 0.0707070707070707),
                                 (21, 0.06382978723404255),
                                 (14, 0.125),
                                 (20, 0.06521739130434782),
                                 (9, 0.36585365853658536),
                                 (41, 0.06382978723404255),
                                 (21, 0.06382978723404255),
                                 (20, 0.06521739130434782),
                                 (20, 0.06521739130434782),
                                 (41, 0.06382978723404255),
                                 (22, 0.0784313725490196),
                                 (14, 0.2777777777777778),
                                 (20, 0.06521739130434782),
                                 (18, 0.3157894736842105),
                                 (14, 0.125),
                                 (18, 0.38461538461538464),
                                 (21, 0.3380281690140845),
                                 (41, 0.06382978723404255),
                                 (35, 0.14285714285714285)]
    correct_output["dolphins"]["mqi"] = [(8, 0.4230769230769231),
                                 (6, 0.48),
                                 (2, 0.8),
                                 (3, 0.6666666666666666),
                                 (3, 0.45454545454545453),
                                 (5, 0.5454545454545454),
                                 (7, 0.5238095238095238),
                                 (2, 0.5),
                                 (2, 0.8),
                                 (3, 0.45454545454545453),
                                 (5, 0.6363636363636364),
                                 (5, 0.5172413793103449),
                                 (6, 0.4838709677419355),
                                 (2, 0.8),
                                 (10, 0.4666666666666667),
                                 (9, 0.2413793103448276),
                                 (3, 0.5555555555555556),
                                 (5, 0.5714285714285714),
                                 (7, 0.39285714285714285),
                                 (5, 0.6666666666666666)]
    correct_output["dolphins"]["sl"] = [(20, 0.06521739130434782),
                                 (12, 0.25),
                                 (2, 0.8),
                                 (3, 0.6666666666666666),
                                 (3, 0.45454545454545453),
                                 (5, 0.5454545454545454),
                                 (11, 0.3783783783783784),
                                 (2, 0.5),
                                 (3, 0.6363636363636364),
                                 (6, 0.36363636363636365),
                                 (10, 0.5882352941176471),
                                 (5, 0.5172413793103449),
                                 (6, 0.4838709677419355),
                                 (3, 0.6363636363636364),
                                 (18, 0.32710280373831774),
                                 (14, 0.125),
                                 (3, 0.5555555555555556),
                                 (5, 0.5714285714285714),
                                 (12, 0.25),
                                 (6, 0.6129032258064516)]
    correct_output["ASTRAL"]["crd"] = [(297, 0.6552586610151693),
                                 (843, 0.7703208285784449),
                                 (249, 0.7031941406846041),
                                 (607, 0.5431249022312604),
                                 (1028, 0.9735653337794881),
                                 (514, 0.5208152106375047),
                                 (292, 0.6678235306126615),
                                 (364, 0.5279174863972736),
                                 (714, 0.6536140539090787),
                                 (457, 0.47221752844429427),
                                 (410, 0.4568834705920498),
                                 (269, 0.6517458458385184),
                                 (905, 0.834524318491826),
                                 (472, 0.47143248925861597),
                                 (183, 0.8479762587595701),
                                 (379, 0.5358479280488427),
                                 (260, 0.6940196539247729),
                                 (1035, 0.9819978046103184),
                                 (354, 0.4919573876255179),
                                 (422, 0.5808358781336552)]
    correct_output["ASTRAL"]["mqi"] = [(297, 0.6552586610151693),
                                 (46, 0.842753300697226),
                                 (249, 0.7031941406846041),
                                 (426, 0.4488660053076378),
                                 (504, 0.5310901836107164),
                                 (204, 0.7623716153127917),
                                 (292, 0.6678235306126615),
                                 (342, 0.5572823926009163),
                                 (147, 0.8341059520563227),
                                 (396, 0.46715002565623315),
                                 (381, 0.49155637958587867),
                                 (13, 0.8861940298507462),
                                 (468, 0.4951481345764966),
                                 (412, 0.5272351494850871),
                                 (411, 0.448540501326817),
                                 (371, 0.5482615406411011),
                                 (260, 0.6940196539247729),
                                 (496, 0.5300379564591423),
                                 (419, 0.45740906190172304),
                                 (206, 0.7796431229339379)]
    correct_output["ASTRAL"]["sl"] = [(297, 0.6552586610151693),
                                 (46, 0.842753300697226),
                                 (249, 0.7031941406846041),
                                 (426, 0.4488660053076378),
                                 (504, 0.5310901836107164),
                                 (204, 0.7623716153127917),
                                 (292, 0.6678235306126615),
                                 (342, 0.5572823926009163),
                                 (147, 0.8341059520563227),
                                 (396, 0.46715002565623315),
                                 (381, 0.49155637958587867),
                                 (13, 0.8861940298507462),
                                 (468, 0.4951481345764966),
                                 (412, 0.5272351494850871),
                                 (412, 0.4485334826684315),
                                 (371, 0.5482615406411011),
                                 (260, 0.6940196539247729),
                                 (498, 0.5306238267778408),
                                 (420, 0.4573904608747814),
                                 (206, 0.7796431229339379)]
    correct_output["neuro-fmri-01"]["crd"] = [(115, 0.2014995313964386),
                                     (45, 0.15610217596972564),
                                     (91, 0.18893466745144202),
                                     (289, 0.15307079231129864),
                                     (138, 0.1591192355629414),
                                     (423, 0.24884762708563266),
                                     (75, 0.23904382470119523),
                                     (300, 0.21632430467187785),
                                     (130, 0.17767722473604827),
                                     (57, 0.3),
                                     (118, 0.16),
                                     (100, 0.2867132867132867),
                                     (86, 0.20980533525594808),
                                     (150, 0.15830985915492957),
                                     (1, 1),
                                     (283, 0.13108108108108107),
                                     (175, 0.22342938119981107),
                                     (1035, 0.06297744053549986),
                                     (95, 0.1795446061963419),
                                     (288, 0.18113585188891668)]
    correct_output["neuro-fmri-01"]["mqi"] = [(20, 0.48028673835125446),
                                     (7, 0.7342657342657343),
                                     (6, 0.7945205479452054),
                                     (26, 0.6734033953112368),
                                     (34, 0.35444579780755175),
                                     (19, 0.47634069400630913),
                                     (7, 0.7391304347826086),
                                     (46, 0.4929270946681175),
                                     (37, 0.450313339301701),
                                     (12, 0.5227272727272727),
                                     (19, 0.5035460992907801),
                                     (18, 0.5224913494809689),
                                     (7, 0.5384615384615384),
                                     (38, 0.4353109363831308),
                                     (0, 1),
                                     (18, 0.686382393397524),
                                     (35, 0.5219573400250941),
                                     (89, 0.4670280036133695),
                                     (6, 0.8660714285714286),
                                     (18, 0.6304347826086957)]
    correct_output["neuro-fmri-01"]["sl"] = [(20, 0.48028673835125446),
                                     (7, 0.7342657342657343),
                                     (6, 0.7945205479452054),
                                     (30, 0.6520566419420094),
                                     (56, 0.25517241379310346),
                                     (20, 0.45962732919254656),
                                     (7, 0.7391304347826086),
                                     (48, 0.4843581445523193),
                                     (42, 0.399833748960931),
                                     (12, 0.5227272727272727),
                                     (21, 0.47706422018348627),
                                     (20, 0.48),
                                     (7, 0.5384615384615384),
                                     (49, 0.33414485696895924),
                                     (1, 1),
                                     (18, 0.686382393397524),
                                     (43, 0.4792022792022792),
                                     (117, 0.40568260568260567),
                                     (6, 0.8660714285714286),
                                     (18, 0.6304347826086957)]
    correct_output["disconnected"]["crd"] = [(4, 0.0),
                                     (4, 0.0),
                                     (4, 0.0),
                                     (4, 0.0),
                                     (2, 0.5),
                                     (4, 0.0),
                                     (4, 0.0),
                                     (4, 0.0)]
    correct_output["disconnected"]["mqi"] = [(3, 0.3333333333333333),
                                     (3, 0.3333333333333333),
                                     (3, 0.14285714285714285),
                                     (4, 0.0),
                                     (2, 0.5),
                                     (3, 0.3333333333333333),
                                     (3, 0.14285714285714285),
                                     (3, 0.3333333333333333)]
    correct_output["disconnected"]["sl"] = [(4, 0.0),
                                     (4, 0.0),
                                     (4, 0.0),
                                     (4, 0.0),
                                     (4, 0.0),
                                     (4, 0.0),
                                     (4, 0.0),
                                     (4, 0.0)]
    correct_output["ppi-homo"]["crd"] = [(2768, 0.19060210672330832),
                                 (1379, 0.3017579543803574),
                                 (8, 0.21739130434782608),
                                 (3786, 0.2335430863030224),
                                 (3, 0.2),
                                 (25, 0.18309859154929578),
                                 (3298, 0.2667533754490276),
                                 (32, 0.24444444444444444),
                                 (10, 0.2413793103448276),
                                 (64, 0.3193717277486911),
                                 (19, 0.22857142857142856),
                                 (1774, 0.28492573834860296),
                                 (12, 0.13043478260869565),
                                 (11, 0.25),
                                 (29, 0.30434782608695654),
                                 (10, 0.22580645161290322),
                                 (9, 0.22448979591836735),
                                 (47, 0.25806451612903225),
                                 (522, 0.3180952380952381),
                                 (13, 0.2413793103448276)]
    correct_output["ppi-homo"]["mqi"] = [(4, 0.8064516129032258),
                                 (2, 0.95),
                                 (2, 0.9967266775777414),
                                 (4, 0.9036144578313253),
                                 (2, 0.9894179894179894),
                                 (2, 0.8),
                                 (3, 0.8181818181818182),
                                 (7, 0.6944444444444444),
                                 (2, 0.6),
                                 (2, 0.9375),
                                 (3, 0.9318181818181818),
                                 (2, 0.8),
                                 (4, 0.625),
                                 (2, 0.7142857142857143),
                                 (2, 0.9310344827586207),
                                 (5, 0.4444444444444444),
                                 (2, 0.8888888888888888),
                                 (4, 0.7931034482758621),
                                 (2, 0.8666666666666667),
                                 (4, 0.8588235294117647)]
    correct_output["ppi-homo"]["sl"] = [(29, 0.762589928057554),
                                 (12, 0.8633540372670807),
                                 (128, 0.6541554959785523),
                                 (26, 0.8721461187214612),
                                 (7, 0.9381443298969072),
                                 (2, 0.8),
                                 (3, 0.6666666666666666),
                                 (9, 0.6266666666666667),
                                 (3, 0.3333333333333333),
                                 (50, 0.45251396648044695),
                                 (19, 0.8480243161094225),
                                 (2, 0.8),
                                 (4, 0.625),
                                 (7, 0.3333333333333333),
                                 (9, 0.5555555555555556),
                                 (5, 0.4444444444444444),
                                 (10, 0.6538461538461539),
                                 (4, 0.7931034482758621),
                                 (37, 0.75),
                                 (10, 0.8293838862559242)]
    nsamples = 20
    for key in correct_output.keys():
        g = lgc_data(key)
        g.discard_weights()
        n = g._num_vertices
        random.seed(0)
        nodes = random.sample(range(n),min(n,nsamples))
        results = defaultdict(list)
        for method in ["crd"]:    
            for i in nodes:
                R = [i]
                R.extend(g.neighbors(i))
                S = lgc.flow_clustering(g,R,method=method)
                results[method].append((len(S[0]),g.set_scores(S[0])['cond']))
        print(results)
        correct_result = correct_output[key]
        for method in ["crd"]:  
            for i in range(len(nodes)):
                assert(results[method][i][0] == correct_result[method][i][0])
                assert(abs(results[method][i][1] - correct_result[method][i][1]) < 0.0001)
"""
@pytest.mark.deep_tests
def test_spectral_deep():
    correct_output = defaultdict(dict)
    correct_output["dolphins"]["acl"] = [(22, 0.0707070707070707),
                                 (42, 0.06521739130434782),
                                 (21, 0.06382978723404255),
                                 (21, 0.06382978723404255),
                                 (24, 0.0990990990990991),
                                 (43, 0.08235294117647059),
                                 (41, 0.06382978723404255),
                                 (21, 0.06382978723404255),
                                 (21, 0.06382978723404255),
                                 (19, 0.07692307692307693),
                                 (41, 0.06382978723404255),
                                 (29, 0.1267605633802817),
                                 (29, 0.29411764705882354),
                                 (21, 0.06382978723404255),
                                 (41, 0.07216494845360824),
                                 (21, 0.06382978723404255),
                                 (42, 0.06521739130434782),
                                 (43, 0.11904761904761904),
                                 (41, 0.06382978723404255),
                                 (42, 0.06521739130434782)]
    correct_output["dolphins"]["l1reg"] = [(22, 0.15517241379310345),
                                 (36, 0.11764705882352941),
                                 (23, 0.09433962264150944),
                                 (22, 0.0891089108910891),
                                 (13, 0.189873417721519),
                                 (42, 0.1780821917808219),
                                 (37, 0.1111111111111111),
                                 (19, 0.08695652173913043),
                                 (18, 0.08888888888888889),
                                 (16, 0.12941176470588237),
                                 (36, 0.11764705882352941),
                                 (23, 0.21428571428571427),
                                 (15, 0.3707865168539326),
                                 (18, 0.08888888888888889),
                                 (34, 0.1320754716981132),
                                 (19, 0.08695652173913043),
                                 (35, 0.12871287128712872),
                                 (36, 0.20454545454545456),
                                 (45, 0.12),
                                 (35, 0.14563106796116504)]
    correct_output["ASTRAL"]["acl"] = [(513, 0.4836994204945198),
                                 (603, 0.4191458213990198),
                                 (584, 0.41923858158918553),
                                 (415, 0.4339588998350644),
                                 (437, 0.4595396328266239),
                                 (489, 0.4163321138857961),
                                 (526, 0.43591995164010056),
                                 (493, 0.40792715927541306),
                                 (603, 0.41475713567167316),
                                 (421, 0.4370356234096692),
                                 (421, 0.4411970620807291),
                                 (606, 0.41677010330933606),
                                 (448, 0.4671386460727451),
                                 (530, 0.4648575719777003),
                                 (413, 0.45000764019762646),
                                 (458, 0.4589495512343441),
                                 (486, 0.42776261633491736),
                                 (458, 0.4796577147877908),
                                 (422, 0.4554013938258864),
                                 (606, 0.40982688747367685)]
    correct_output["ASTRAL"]["l1reg"] = [(412, 0.4724544302749782),
                                 (474, 0.4598128461391559),
                                 (437, 0.44957071301735607),
                                 (394, 0.4240439037123339),
                                 (379, 0.4251864294622178),
                                 (412, 0.46319894645095205),
                                 (422, 0.47742490364093904),
                                 (436, 0.4361290650923711),
                                 (456, 0.4661568996666582),
                                 (411, 0.4422865285402579),
                                 (412, 0.44889053113074723),
                                 (500, 0.4521675426023252),
                                 (408, 0.45770954272329156),
                                 (448, 0.4669067357183303),
                                 (409, 0.44818984224359015),
                                 (420, 0.46963142301933675),
                                 (408, 0.4746548474196342),
                                 (394, 0.44705380289046426),
                                 (420, 0.4558364137246544),
                                 (465, 0.4691275466987651)]
    correct_output["neuro-fmri-01"]["acl"] = [(530, 0.1391425168717745),
                                     (104, 0.08120649651972157),
                                     (689, 0.1111884461458152),
                                     (1107, 0.11700380532745844),
                                     (395, 0.10316967060285892),
                                     (1302, 0.07496275925289332),
                                     (1544, 0.06664839789387147),
                                     (1113, 0.10773285180937507),
                                     (233, 0.10884101040118871),
                                     (867, 0.13999777604803737),
                                     (784, 0.09330162504954419),
                                     (897, 0.1314159292035398),
                                     (267, 0.15891472868217055),
                                     (910, 0.08101714961561206),
                                     (1, 1),
                                     (1060, 0.09085404314368614),
                                     (1142, 0.10195919607148281),
                                     (1413, 0.05271959350813627),
                                     (266, 0.07692307692307693),
                                     (468, 0.1794871794871795)]
    correct_output["neuro-fmri-01"]["l1reg"] = [(3480, 0.15049464499372575),
                                     (94, 0.09194854692710815),
                                     (662, 0.11534984632073766),
                                     (997, 0.1592636606201933),
                                     (537, 0.12796310200579214),
                                     (1234, 0.08230747208703121),
                                     (1556, 0.07405138415591377),
                                     (1270, 0.11696362769324142),
                                     (3242, 0.1431401395423361),
                                     (829, 0.14554349487845894),
                                     (759, 0.09798810784393581),
                                     (849, 0.1403678606001936),
                                     (3275, 0.1427777290148922),
                                     (864, 0.08437343984023964),
                                     (3238, 0.14599607946399837),
                                     (977, 0.1062580093976933),
                                     (1118, 0.10986524537409494),
                                     (1415, 0.058192760871407984),
                                     (276, 0.08341232227488152),
                                     (930, 0.21164262872805586)]
    correct_output["disconnected"]["acl"] = [(4, 0.0),
                                     (4, 0.0),
                                     (4, 0.0),
                                     (4, 0.0),
                                     (2, 0.5),
                                     (4, 0.0),
                                     (4, 0.0),
                                     (4, 0.0)]
    correct_output["disconnected"]["l1reg"] = [(4, 0.0),
                                     (4, 0.0),
                                     (4, 0.0),
                                     (4, 0.0),
                                     (4, 0.0),
                                     (4, 0.0),
                                     (4, 0.0),
                                     (4, 0.0)]
    correct_output["ppi-homo"]["acl"] = [(3543, 0.2340138556802158),
                                 (2901, 0.2413603278487981),
                                 (3611, 0.283311930532624),
                                 (3157, 0.2515059780448277),
                                 (3185, 0.2392269762028728),
                                 (3367, 0.25898510384485973),
                                 (3372, 0.25329938204515107),
                                 (3110, 0.2687968200580951),
                                 (10, 0.2413793103448276),
                                 (3458, 0.3219592735277931),
                                 (3448, 0.2480240181361436),
                                 (3416, 0.24605311467384652),
                                 (2834, 0.29539078156312626),
                                 (3236, 0.292530739585245),
                                 (3409, 0.27990949949552085),
                                 (3353, 0.2692307692307692),
                                 (3677, 0.2627227631820687),
                                 (3276, 0.28365443612713215),
                                 (3358, 0.31409001956947163),
                                 (2862, 0.28564875691874864)]
    correct_output["ppi-homo"]["l1reg"] = [(1350, 0.42838780756518546),
                                 (1187, 0.388087084148728),
                                 (1517, 0.44820625745481235),
                                 (1361, 0.41521898703205284),
                                 (1302, 0.38361659776450774),
                                 (1364, 0.40750932550602337),
                                 (1402, 0.40939392086110943),
                                 (1219, 0.40736890383733376),
                                 (3366, 0.2824585635359116),
                                 (1521, 0.4378325484679836),
                                 (1392, 0.42739734429145326),
                                 (1282, 0.4108906350322561),
                                 (1240, 0.4104947709620207),
                                 (2066, 0.36808295861246215),
                                 (1498, 0.41167472312304965),
                                 (1309, 0.41997247285517664),
                                 (1510, 0.4078762306610408),
                                 (1492, 0.4068252706256498),
                                 (1282, 0.44180784049905203),
                                 (1184, 0.41734450492324626)]
    nsamples = 20
    for key in correct_output.keys():
        g = lgc_data(key)
        g.discard_weights()
        n = g._num_vertices
        random.seed(0)
        nodes = random.sample(range(n),min(n,nsamples))
        results = defaultdict(list)
        for method in ["acl","l1reg"]:    
            for i in nodes:
                R = [i]
                S = lgc.spectral_clustering(g,R,method=method)
                results[method].append((len(S[0]),g.set_scores(S[0])['cond']))
        print(results)
        correct_result = correct_output[key]
        for method in ["acl","l1reg"]:  
            for i in range(len(nodes)):
                assert(results[method][i][0] == correct_result[method][i][0])
                assert(abs(results[method][i][1] - correct_result[method][i][1]) < 0.0001)
"""