# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['drizm_django_commons',
 'drizm_django_commons.management.commands',
 'drizm_django_commons.serializers']

package_data = \
{'': ['*']}

install_requires = \
['django==3.1.1', 'djangorestframework==3.12.1']

setup_kwargs = {
    'name': 'drizm-django-commons',
    'version': '0.2.1',
    'description': 'Django commons for the Drizm organization',
    'long_description': '# Django Commons\n[![PyPI version](https://badge.fury.io/py/drizm-django-commons.svg)](https://badge.fury.io/py/drizm-django-commons)\n\nThis package includes shared code used by\nthe Drizm organizations development team.  \n\nIt is not intended for public usage but you\nmay still download, redistribute or \nmodify it to your liking.\n\n## Installation\n\nInstall:  \n>pip install drizm-django-commons\n\nOnce installed through pip, include\nthe app in your settings.py like so:  \nINSTALLED_APPS += ["drizm_django_commons"]  \n\nIn order to use the applications\nmanage.py commands you must include the\napp at the top of the INSTALLED_APPS list.\n\nImport like so:  \nimport drizm_django_commons\n\n## Documentation\n\npass\n\n## Changelog\n\n### 0.2.1\n\n- Added HrefModelSerializer which will\nserialize primary keys to hyperlinks\n- Moved testing.py dependencies to\ndrizm-commons package utilities\n',
    'author': 'ThaRising',
    'author_email': 'kochbe.ber@gmail.com',
    'maintainer': 'Dominik Lewandowski',
    'maintainer_email': 'dominik.lewandow@gmail.com',
    'url': 'https://github.com/drizm-team/django-commons',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
