# Generated by Django 2.2.28 on 2023-03-01 12:18

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Component',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, help_text='Component tag', max_length=255, null=True)),
                ('short_description', models.CharField(blank=True, max_length=255, null=True)),
                ('slug', models.SlugField(blank=True, null=True, unique=True)),
                ('creator', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='components', to=settings.AUTH_USER_MODEL)),
                ('preferred_route', models.CharField(blank=True, default='false', max_length=255, null=True)),
                ('auto_import', models.BooleanField(default=False, help_text='Enable the experimental routing functionnality, does not require script declaration.')),
                ('friendly_name', models.CharField(blank=True, max_length=255, null=True)),
            ],
            options={
                'verbose_name': 'component',
                'verbose_name_plural': 'components',
                'ordering': ['slug'],
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'lookup_field': 'slug',
                'rdf_type': 'sib:Component',
                'rdf_context': {'creator': 'foaf:user', 'name': 'sib:ComponentName', 'short_description': 'sib:ComponentShortDescription'},
                'auto_author': 'creator',
                'owner_field': 'creator',
                'container_path': '/components/',
                'serializer_fields': ['@id', 'name', 'short_description', 'creator', 'parameters'],
                'nested_fields': ['parameters'],
                'depth': 1,
                'anonymous_perms': ['view'],
                'authenticated_perms': ['inherit', 'add'],
                'owner_perms': ['inherit', 'change', 'delete'],
                'superuser_perms': ['view'],
            },
        ),
        migrations.CreateModel(
            name='Package',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('friendly_name', models.CharField(blank=True, max_length=255, null=True)),
                ('short_description', models.CharField(blank=True, max_length=255, null=True)),
                ('distribution', models.CharField(blank=True, max_length=255, null=True)),
                ('module', models.CharField(blank=True, max_length=255, null=True)),
                ('slug', models.SlugField(blank=True, null=True, unique=True)),
                ('creator', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='packages', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'package',
                'verbose_name_plural': 'packages',
                'ordering': ['slug'],
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'lookup_field': 'slug',
                'rdf_type': 'sib:Package',
                'rdf_context': {'creator': 'foaf:user', 'name': 'sib:PackageName', 'short_description': 'sib:PackageShortDescription'},
                'auto_author': 'creator',
                'owner_field': 'creator',
                'container_path': '/packages/',
                'serializer_fields': ['@id', 'name', 'short_description', 'creator', 'distribution', 'module', 'parameters'],
                'nested_fields': ['parameters'],
                'depth': 1,
                'anonymous_perms': ['view'],
                'authenticated_perms': ['inherit', 'add'],
                'owner_perms': ['inherit', 'change', 'delete'],
                'superuser_perms': ['view'],
            },
        ),
        migrations.CreateModel(
            name='Parameter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('friendly_name', models.CharField(blank=True, max_length=255, null=True)),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
                ('key', models.CharField(blank=True, max_length=255, null=True)),
                ('default', models.CharField(blank=True, max_length=255, null=True)),
                ('component', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='parameters', to='djangoldp_component.Component')),
            ],
            options={
                'verbose_name': 'parameter',
                'verbose_name_plural': 'parameters',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'sib:Parameter',
                'rdf_context': {'component': 'sib:Component', 'default': 'sib:ParameterDefaultValue', 'description': 'sib:ParameterDescription', 'key': 'sib:ParameterKey', 'name': 'sib:ParameterName', 'type': 'sib:ParameterType'},
                'owner_field': 'component.creator',
                'container_path': 'parameters/',
                'serializer_fields': ['@id', 'name', 'description', 'key', 'type', 'default'],
                'depth': 0,
                'anonymous_perms': ['view'],
                'authenticated_perms': ['inherit'],
                'owner_perms': ['inherit', 'change', 'delete'],
                'superuser_perms': ['inherit'],
            },
        ),
        migrations.CreateModel(
            name='ServerParameter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('friendly_name', models.CharField(blank=True, max_length=255, null=True)),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
                ('key', models.CharField(blank=True, max_length=255, null=True)),
                ('default', models.CharField(blank=True, max_length=255, null=True)),
                ('package', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='parameters', to='djangoldp_component.Package')),
            ],
            options={
                'verbose_name': 'server parameter',
                'verbose_name_plural': 'server parameters',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'sib:Parameter',
                'rdf_context': {'default': 'sib:ParameterDefaultValue', 'description': 'sib:ParameterDescription', 'key': 'sib:ParameterKey', 'name': 'sib:ParameterName', 'package': 'sib:Package'},
                'owner_field': 'package',
                'container_path': 'server-parameters/',
                'serializer_fields': ['@id', 'name', 'description', 'key', 'default'],
                'depth': 0,
                'anonymous_perms': ['view'],
                'authenticated_perms': ['inherit'],
                'owner_perms': ['inherit', 'change', 'delete'],
                'superuser_perms': ['inherit'],
            },
        ),
        migrations.CreateModel(
            name='Dependency',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('component', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='dependencies', to='djangoldp_component.Component')),
                ('package', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='dependencies', to='djangoldp_component.Package')),
            ],
            options={
                'verbose_name': 'dependency',
                'verbose_name_plural': 'dependencies',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'sib:dependency',
                'rdf_context': {'component': 'sib:component', 'package': 'sib:package'},
                'container_path': 'dependencies/',
                'serializer_fields': ['@id', 'component', 'package'],
                'depth': 0,
                'anonymous_perms': ['view'],
                'authenticated_perms': ['inherit'],
                'superuser_perms': ['inherit'],
            },
        ),
        migrations.CreateModel(
            name='ComponentScriptTag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('friendly_name', models.CharField(blank=True, max_length=255, null=True)),
                ('src', models.URLField(blank=True, max_length=255, null=True)),
                ('integrity', models.CharField(blank=True, max_length=255, null=True)),
                ('component', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='script_tags', to='djangoldp_component.Component')),
            ],
            options={
                'verbose_name': 'script tag',
                'verbose_name_plural': 'script tags',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'sib:scriptTag',
                'rdf_context': {'component': 'sib:component', 'friendly_name': 'sib:friendlyName', 'integrity': 'sib:componentScriptTagIntegrity', 'src': 'sib:componentScriptTagSrc'},
                'owner_field': 'component',
                'container_path': 'script-tags/',
                'serializer_fields': ['@id', 'friendly_name', 'src', 'integrity'],
                'depth': 0,
                'anonymous_perms': ['view'],
                'authenticated_perms': ['inherit'],
                'owner_perms': ['inherit', 'change', 'delete'],
                'superuser_perms': ['inherit'],
            },
        ),
    ]
