'''
## pdk_pipeline

TODO
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from .._jsii import *

import aws_cdk.aws_codecommit
import aws_cdk.aws_codepipeline
import aws_cdk.pipelines
import constructs


class PDKPipeline(
    aws_cdk.pipelines.CodePipeline,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-prototyping-sdk.pdk_pipeline.PDKPipeline",
):
    '''An extension to CodePipeline which configures sane defaults for a NX Monorepo codebase.

    In addition to this, it also creates a CodeCommit repository with
    automated PR builds and approvals.
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        primary_synth_directory: builtins.str,
        repository_name: builtins.str,
        default_branch_name: typing.Optional[builtins.str] = None,
        pr_build_checker: typing.Optional[builtins.bool] = None,
        sonar_code_scanner_config: typing.Optional["SonarCodeScannerConfig"] = None,
        synth_shell_step_partial_props: typing.Optional[aws_cdk.pipelines.ShellStepProps] = None,
        synth: aws_cdk.pipelines.IFileSetProducer,
        asset_publishing_code_build_defaults: typing.Optional[aws_cdk.pipelines.CodeBuildOptions] = None,
        cli_version: typing.Optional[builtins.str] = None,
        code_build_defaults: typing.Optional[aws_cdk.pipelines.CodeBuildOptions] = None,
        code_pipeline: typing.Optional[aws_cdk.aws_codepipeline.Pipeline] = None,
        cross_account_keys: typing.Optional[builtins.bool] = None,
        docker_credentials: typing.Optional[typing.Sequence[aws_cdk.pipelines.DockerCredential]] = None,
        docker_enabled_for_self_mutation: typing.Optional[builtins.bool] = None,
        docker_enabled_for_synth: typing.Optional[builtins.bool] = None,
        pipeline_name: typing.Optional[builtins.str] = None,
        publish_assets_in_parallel: typing.Optional[builtins.bool] = None,
        reuse_cross_region_support_stacks: typing.Optional[builtins.bool] = None,
        self_mutation: typing.Optional[builtins.bool] = None,
        self_mutation_code_build_defaults: typing.Optional[aws_cdk.pipelines.CodeBuildOptions] = None,
        synth_code_build_defaults: typing.Optional[aws_cdk.pipelines.CodeBuildOptions] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param primary_synth_directory: Output directory for cdk synthesized artifacts i.e: packages/infra/cdk.out.
        :param repository_name: Name of the CodeCommit repository to create.
        :param default_branch_name: Branch to trigger the pipeline execution. Default: mainline
        :param pr_build_checker: Enables a build job to trigger on PR merges to the defaultBranchName. This will automatically build the codebase and add an Approval to the PR on successful build. Default: true
        :param sonar_code_scanner_config: Configuration for enabling Sonarqube code scanning. Default: undefined
        :param synth_shell_step_partial_props: PDKPipeline by default assumes a NX Monorepo structure for it's codebase and uses sane defaults for the install and run commands. To override these defaults and/or provide additional inputs, specify env settings, etc you can provide a partial ShellStepProps.
        :param synth: The build step that produces the CDK Cloud Assembly. The primary output of this step needs to be the ``cdk.out`` directory generated by the ``cdk synth`` command. If you use a ``ShellStep`` here and you don't configure an output directory, the output directory will automatically be assumed to be ``cdk.out``.
        :param asset_publishing_code_build_defaults: Additional customizations to apply to the asset publishing CodeBuild projects. Default: - Only ``codeBuildDefaults`` are applied
        :param cli_version: CDK CLI version to use in self-mutation and asset publishing steps. If you want to lock the CDK CLI version used in the pipeline, by steps that are automatically generated for you, specify the version here. We recommend you do not specify this value, as not specifying it always uses the latest CLI version which is backwards compatible with old versions. If you do specify it, be aware that this version should always be equal to or higher than the version of the CDK framework used by the CDK app, when the CDK commands are run during your pipeline execution. When you change this version, the *next time* the ``SelfMutate`` step runs it will still be using the CLI of the the *previous* version that was in this property: it will only start using the new version after ``SelfMutate`` completes successfully. That means that if you want to update both framework and CLI version, you should update the CLI version first, commit, push and deploy, and only then update the framework version. Default: - Latest version
        :param code_build_defaults: Customize the CodeBuild projects created for this pipeline. Default: - All projects run non-privileged build, SMALL instance, LinuxBuildImage.STANDARD_5_0
        :param code_pipeline: An existing Pipeline to be reused and built upon. [disable-awslint:ref-via-interface] Default: - a new underlying pipeline is created.
        :param cross_account_keys: Create KMS keys for the artifact buckets, allowing cross-account deployments. The artifact buckets have to be encrypted to support deploying CDK apps to another account, so if you want to do that or want to have your artifact buckets encrypted, be sure to set this value to ``true``. Be aware there is a cost associated with maintaining the KMS keys. Default: false
        :param docker_credentials: A list of credentials used to authenticate to Docker registries. Specify any credentials necessary within the pipeline to build, synth, update, or publish assets. Default: []
        :param docker_enabled_for_self_mutation: Enable Docker for the self-mutate step. Set this to true if the pipeline itself uses Docker container assets (for example, if you use ``LinuxBuildImage.fromAsset()`` as the build image of a CodeBuild step in the pipeline). You do not need to set it if you build Docker image assets in the application Stages and Stacks that are *deployed* by this pipeline. Configures privileged mode for the self-mutation CodeBuild action. If you are about to turn this on in an already-deployed Pipeline, set the value to ``true`` first, commit and allow the pipeline to self-update, and only then use the Docker asset in the pipeline. Default: false
        :param docker_enabled_for_synth: Enable Docker for the 'synth' step. Set this to true if you are using file assets that require "bundling" anywhere in your application (meaning an asset compilation step will be run with the tools provided by a Docker image), both for the Pipeline stack as well as the application stacks. A common way to use bundling assets in your application is by using the ``@aws-cdk/aws-lambda-nodejs`` library. Configures privileged mode for the synth CodeBuild action. If you are about to turn this on in an already-deployed Pipeline, set the value to ``true`` first, commit and allow the pipeline to self-update, and only then use the bundled asset. Default: false
        :param pipeline_name: The name of the CodePipeline pipeline. Default: - Automatically generated
        :param publish_assets_in_parallel: Publish assets in multiple CodeBuild projects. If set to false, use one Project per type to publish all assets. Publishing in parallel improves concurrency and may reduce publishing latency, but may also increase overall provisioning time of the CodeBuild projects. Experiment and see what value works best for you. Default: true
        :param reuse_cross_region_support_stacks: Reuse the same cross region support stack for all pipelines in the App. Default: - true (Use the same support stack for all pipelines in App)
        :param self_mutation: Whether the pipeline will update itself. This needs to be set to ``true`` to allow the pipeline to reconfigure itself when assets or stages are being added to it, and ``true`` is the recommended setting. You can temporarily set this to ``false`` while you are iterating on the pipeline itself and prefer to deploy changes using ``cdk deploy``. Default: true
        :param self_mutation_code_build_defaults: Additional customizations to apply to the self mutation CodeBuild projects. Default: - Only ``codeBuildDefaults`` are applied
        :param synth_code_build_defaults: Additional customizations to apply to the synthesize CodeBuild projects. Default: - Only ``codeBuildDefaults`` are applied
        '''
        props = PDKPipelineProps(
            primary_synth_directory=primary_synth_directory,
            repository_name=repository_name,
            default_branch_name=default_branch_name,
            pr_build_checker=pr_build_checker,
            sonar_code_scanner_config=sonar_code_scanner_config,
            synth_shell_step_partial_props=synth_shell_step_partial_props,
            synth=synth,
            asset_publishing_code_build_defaults=asset_publishing_code_build_defaults,
            cli_version=cli_version,
            code_build_defaults=code_build_defaults,
            code_pipeline=code_pipeline,
            cross_account_keys=cross_account_keys,
            docker_credentials=docker_credentials,
            docker_enabled_for_self_mutation=docker_enabled_for_self_mutation,
            docker_enabled_for_synth=docker_enabled_for_synth,
            pipeline_name=pipeline_name,
            publish_assets_in_parallel=publish_assets_in_parallel,
            reuse_cross_region_support_stacks=reuse_cross_region_support_stacks,
            self_mutation=self_mutation,
            self_mutation_code_build_defaults=self_mutation_code_build_defaults,
            synth_code_build_defaults=synth_code_build_defaults,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="buildPipeline")
    def build_pipeline(self) -> None:
        '''Send the current pipeline definition to the engine, and construct the pipeline.

        It is not possible to modify the pipeline after calling this method.
        '''
        return typing.cast(None, jsii.invoke(self, "buildPipeline", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="codeRepository")
    def code_repository(self) -> aws_cdk.aws_codecommit.Repository:
        return typing.cast(aws_cdk.aws_codecommit.Repository, jsii.get(self, "codeRepository"))


@jsii.data_type(
    jsii_type="aws-prototyping-sdk.pdk_pipeline.PDKPipelineProps",
    jsii_struct_bases=[aws_cdk.pipelines.CodePipelineProps],
    name_mapping={
        "synth": "synth",
        "asset_publishing_code_build_defaults": "assetPublishingCodeBuildDefaults",
        "cli_version": "cliVersion",
        "code_build_defaults": "codeBuildDefaults",
        "code_pipeline": "codePipeline",
        "cross_account_keys": "crossAccountKeys",
        "docker_credentials": "dockerCredentials",
        "docker_enabled_for_self_mutation": "dockerEnabledForSelfMutation",
        "docker_enabled_for_synth": "dockerEnabledForSynth",
        "pipeline_name": "pipelineName",
        "publish_assets_in_parallel": "publishAssetsInParallel",
        "reuse_cross_region_support_stacks": "reuseCrossRegionSupportStacks",
        "self_mutation": "selfMutation",
        "self_mutation_code_build_defaults": "selfMutationCodeBuildDefaults",
        "synth_code_build_defaults": "synthCodeBuildDefaults",
        "primary_synth_directory": "primarySynthDirectory",
        "repository_name": "repositoryName",
        "default_branch_name": "defaultBranchName",
        "pr_build_checker": "prBuildChecker",
        "sonar_code_scanner_config": "sonarCodeScannerConfig",
        "synth_shell_step_partial_props": "synthShellStepPartialProps",
    },
)
class PDKPipelineProps(aws_cdk.pipelines.CodePipelineProps):
    def __init__(
        self,
        *,
        synth: aws_cdk.pipelines.IFileSetProducer,
        asset_publishing_code_build_defaults: typing.Optional[aws_cdk.pipelines.CodeBuildOptions] = None,
        cli_version: typing.Optional[builtins.str] = None,
        code_build_defaults: typing.Optional[aws_cdk.pipelines.CodeBuildOptions] = None,
        code_pipeline: typing.Optional[aws_cdk.aws_codepipeline.Pipeline] = None,
        cross_account_keys: typing.Optional[builtins.bool] = None,
        docker_credentials: typing.Optional[typing.Sequence[aws_cdk.pipelines.DockerCredential]] = None,
        docker_enabled_for_self_mutation: typing.Optional[builtins.bool] = None,
        docker_enabled_for_synth: typing.Optional[builtins.bool] = None,
        pipeline_name: typing.Optional[builtins.str] = None,
        publish_assets_in_parallel: typing.Optional[builtins.bool] = None,
        reuse_cross_region_support_stacks: typing.Optional[builtins.bool] = None,
        self_mutation: typing.Optional[builtins.bool] = None,
        self_mutation_code_build_defaults: typing.Optional[aws_cdk.pipelines.CodeBuildOptions] = None,
        synth_code_build_defaults: typing.Optional[aws_cdk.pipelines.CodeBuildOptions] = None,
        primary_synth_directory: builtins.str,
        repository_name: builtins.str,
        default_branch_name: typing.Optional[builtins.str] = None,
        pr_build_checker: typing.Optional[builtins.bool] = None,
        sonar_code_scanner_config: typing.Optional["SonarCodeScannerConfig"] = None,
        synth_shell_step_partial_props: typing.Optional[aws_cdk.pipelines.ShellStepProps] = None,
    ) -> None:
        '''Properties to configure the PDKPipeline.

        Note: Due to limitations with JSII and generic support it should be noted that
        the synth, synthShellStepPartialProps.input and
        synthShellStepPartialProps.primaryOutputDirectory properties will be ignored
        if passed in to this construct.

        synthShellStepPartialProps.commands is marked as a required field, however
        if you pass in [] the default commands of this construct will be retained.

        :param synth: The build step that produces the CDK Cloud Assembly. The primary output of this step needs to be the ``cdk.out`` directory generated by the ``cdk synth`` command. If you use a ``ShellStep`` here and you don't configure an output directory, the output directory will automatically be assumed to be ``cdk.out``.
        :param asset_publishing_code_build_defaults: Additional customizations to apply to the asset publishing CodeBuild projects. Default: - Only ``codeBuildDefaults`` are applied
        :param cli_version: CDK CLI version to use in self-mutation and asset publishing steps. If you want to lock the CDK CLI version used in the pipeline, by steps that are automatically generated for you, specify the version here. We recommend you do not specify this value, as not specifying it always uses the latest CLI version which is backwards compatible with old versions. If you do specify it, be aware that this version should always be equal to or higher than the version of the CDK framework used by the CDK app, when the CDK commands are run during your pipeline execution. When you change this version, the *next time* the ``SelfMutate`` step runs it will still be using the CLI of the the *previous* version that was in this property: it will only start using the new version after ``SelfMutate`` completes successfully. That means that if you want to update both framework and CLI version, you should update the CLI version first, commit, push and deploy, and only then update the framework version. Default: - Latest version
        :param code_build_defaults: Customize the CodeBuild projects created for this pipeline. Default: - All projects run non-privileged build, SMALL instance, LinuxBuildImage.STANDARD_5_0
        :param code_pipeline: An existing Pipeline to be reused and built upon. [disable-awslint:ref-via-interface] Default: - a new underlying pipeline is created.
        :param cross_account_keys: Create KMS keys for the artifact buckets, allowing cross-account deployments. The artifact buckets have to be encrypted to support deploying CDK apps to another account, so if you want to do that or want to have your artifact buckets encrypted, be sure to set this value to ``true``. Be aware there is a cost associated with maintaining the KMS keys. Default: false
        :param docker_credentials: A list of credentials used to authenticate to Docker registries. Specify any credentials necessary within the pipeline to build, synth, update, or publish assets. Default: []
        :param docker_enabled_for_self_mutation: Enable Docker for the self-mutate step. Set this to true if the pipeline itself uses Docker container assets (for example, if you use ``LinuxBuildImage.fromAsset()`` as the build image of a CodeBuild step in the pipeline). You do not need to set it if you build Docker image assets in the application Stages and Stacks that are *deployed* by this pipeline. Configures privileged mode for the self-mutation CodeBuild action. If you are about to turn this on in an already-deployed Pipeline, set the value to ``true`` first, commit and allow the pipeline to self-update, and only then use the Docker asset in the pipeline. Default: false
        :param docker_enabled_for_synth: Enable Docker for the 'synth' step. Set this to true if you are using file assets that require "bundling" anywhere in your application (meaning an asset compilation step will be run with the tools provided by a Docker image), both for the Pipeline stack as well as the application stacks. A common way to use bundling assets in your application is by using the ``@aws-cdk/aws-lambda-nodejs`` library. Configures privileged mode for the synth CodeBuild action. If you are about to turn this on in an already-deployed Pipeline, set the value to ``true`` first, commit and allow the pipeline to self-update, and only then use the bundled asset. Default: false
        :param pipeline_name: The name of the CodePipeline pipeline. Default: - Automatically generated
        :param publish_assets_in_parallel: Publish assets in multiple CodeBuild projects. If set to false, use one Project per type to publish all assets. Publishing in parallel improves concurrency and may reduce publishing latency, but may also increase overall provisioning time of the CodeBuild projects. Experiment and see what value works best for you. Default: true
        :param reuse_cross_region_support_stacks: Reuse the same cross region support stack for all pipelines in the App. Default: - true (Use the same support stack for all pipelines in App)
        :param self_mutation: Whether the pipeline will update itself. This needs to be set to ``true`` to allow the pipeline to reconfigure itself when assets or stages are being added to it, and ``true`` is the recommended setting. You can temporarily set this to ``false`` while you are iterating on the pipeline itself and prefer to deploy changes using ``cdk deploy``. Default: true
        :param self_mutation_code_build_defaults: Additional customizations to apply to the self mutation CodeBuild projects. Default: - Only ``codeBuildDefaults`` are applied
        :param synth_code_build_defaults: Additional customizations to apply to the synthesize CodeBuild projects. Default: - Only ``codeBuildDefaults`` are applied
        :param primary_synth_directory: Output directory for cdk synthesized artifacts i.e: packages/infra/cdk.out.
        :param repository_name: Name of the CodeCommit repository to create.
        :param default_branch_name: Branch to trigger the pipeline execution. Default: mainline
        :param pr_build_checker: Enables a build job to trigger on PR merges to the defaultBranchName. This will automatically build the codebase and add an Approval to the PR on successful build. Default: true
        :param sonar_code_scanner_config: Configuration for enabling Sonarqube code scanning. Default: undefined
        :param synth_shell_step_partial_props: PDKPipeline by default assumes a NX Monorepo structure for it's codebase and uses sane defaults for the install and run commands. To override these defaults and/or provide additional inputs, specify env settings, etc you can provide a partial ShellStepProps.
        '''
        if isinstance(asset_publishing_code_build_defaults, dict):
            asset_publishing_code_build_defaults = aws_cdk.pipelines.CodeBuildOptions(**asset_publishing_code_build_defaults)
        if isinstance(code_build_defaults, dict):
            code_build_defaults = aws_cdk.pipelines.CodeBuildOptions(**code_build_defaults)
        if isinstance(self_mutation_code_build_defaults, dict):
            self_mutation_code_build_defaults = aws_cdk.pipelines.CodeBuildOptions(**self_mutation_code_build_defaults)
        if isinstance(synth_code_build_defaults, dict):
            synth_code_build_defaults = aws_cdk.pipelines.CodeBuildOptions(**synth_code_build_defaults)
        if isinstance(sonar_code_scanner_config, dict):
            sonar_code_scanner_config = SonarCodeScannerConfig(**sonar_code_scanner_config)
        if isinstance(synth_shell_step_partial_props, dict):
            synth_shell_step_partial_props = aws_cdk.pipelines.ShellStepProps(**synth_shell_step_partial_props)
        self._values: typing.Dict[str, typing.Any] = {
            "synth": synth,
            "primary_synth_directory": primary_synth_directory,
            "repository_name": repository_name,
        }
        if asset_publishing_code_build_defaults is not None:
            self._values["asset_publishing_code_build_defaults"] = asset_publishing_code_build_defaults
        if cli_version is not None:
            self._values["cli_version"] = cli_version
        if code_build_defaults is not None:
            self._values["code_build_defaults"] = code_build_defaults
        if code_pipeline is not None:
            self._values["code_pipeline"] = code_pipeline
        if cross_account_keys is not None:
            self._values["cross_account_keys"] = cross_account_keys
        if docker_credentials is not None:
            self._values["docker_credentials"] = docker_credentials
        if docker_enabled_for_self_mutation is not None:
            self._values["docker_enabled_for_self_mutation"] = docker_enabled_for_self_mutation
        if docker_enabled_for_synth is not None:
            self._values["docker_enabled_for_synth"] = docker_enabled_for_synth
        if pipeline_name is not None:
            self._values["pipeline_name"] = pipeline_name
        if publish_assets_in_parallel is not None:
            self._values["publish_assets_in_parallel"] = publish_assets_in_parallel
        if reuse_cross_region_support_stacks is not None:
            self._values["reuse_cross_region_support_stacks"] = reuse_cross_region_support_stacks
        if self_mutation is not None:
            self._values["self_mutation"] = self_mutation
        if self_mutation_code_build_defaults is not None:
            self._values["self_mutation_code_build_defaults"] = self_mutation_code_build_defaults
        if synth_code_build_defaults is not None:
            self._values["synth_code_build_defaults"] = synth_code_build_defaults
        if default_branch_name is not None:
            self._values["default_branch_name"] = default_branch_name
        if pr_build_checker is not None:
            self._values["pr_build_checker"] = pr_build_checker
        if sonar_code_scanner_config is not None:
            self._values["sonar_code_scanner_config"] = sonar_code_scanner_config
        if synth_shell_step_partial_props is not None:
            self._values["synth_shell_step_partial_props"] = synth_shell_step_partial_props

    @builtins.property
    def synth(self) -> aws_cdk.pipelines.IFileSetProducer:
        '''The build step that produces the CDK Cloud Assembly.

        The primary output of this step needs to be the ``cdk.out`` directory
        generated by the ``cdk synth`` command.

        If you use a ``ShellStep`` here and you don't configure an output directory,
        the output directory will automatically be assumed to be ``cdk.out``.
        '''
        result = self._values.get("synth")
        assert result is not None, "Required property 'synth' is missing"
        return typing.cast(aws_cdk.pipelines.IFileSetProducer, result)

    @builtins.property
    def asset_publishing_code_build_defaults(
        self,
    ) -> typing.Optional[aws_cdk.pipelines.CodeBuildOptions]:
        '''Additional customizations to apply to the asset publishing CodeBuild projects.

        :default: - Only ``codeBuildDefaults`` are applied
        '''
        result = self._values.get("asset_publishing_code_build_defaults")
        return typing.cast(typing.Optional[aws_cdk.pipelines.CodeBuildOptions], result)

    @builtins.property
    def cli_version(self) -> typing.Optional[builtins.str]:
        '''CDK CLI version to use in self-mutation and asset publishing steps.

        If you want to lock the CDK CLI version used in the pipeline, by steps
        that are automatically generated for you, specify the version here.

        We recommend you do not specify this value, as not specifying it always
        uses the latest CLI version which is backwards compatible with old versions.

        If you do specify it, be aware that this version should always be equal to or higher than the
        version of the CDK framework used by the CDK app, when the CDK commands are
        run during your pipeline execution. When you change this version, the *next
        time* the ``SelfMutate`` step runs it will still be using the CLI of the the
        *previous* version that was in this property: it will only start using the
        new version after ``SelfMutate`` completes successfully. That means that if
        you want to update both framework and CLI version, you should update the
        CLI version first, commit, push and deploy, and only then update the
        framework version.

        :default: - Latest version
        '''
        result = self._values.get("cli_version")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def code_build_defaults(
        self,
    ) -> typing.Optional[aws_cdk.pipelines.CodeBuildOptions]:
        '''Customize the CodeBuild projects created for this pipeline.

        :default: - All projects run non-privileged build, SMALL instance, LinuxBuildImage.STANDARD_5_0
        '''
        result = self._values.get("code_build_defaults")
        return typing.cast(typing.Optional[aws_cdk.pipelines.CodeBuildOptions], result)

    @builtins.property
    def code_pipeline(self) -> typing.Optional[aws_cdk.aws_codepipeline.Pipeline]:
        '''An existing Pipeline to be reused and built upon.

        [disable-awslint:ref-via-interface]

        :default: - a new underlying pipeline is created.
        '''
        result = self._values.get("code_pipeline")
        return typing.cast(typing.Optional[aws_cdk.aws_codepipeline.Pipeline], result)

    @builtins.property
    def cross_account_keys(self) -> typing.Optional[builtins.bool]:
        '''Create KMS keys for the artifact buckets, allowing cross-account deployments.

        The artifact buckets have to be encrypted to support deploying CDK apps to
        another account, so if you want to do that or want to have your artifact
        buckets encrypted, be sure to set this value to ``true``.

        Be aware there is a cost associated with maintaining the KMS keys.

        :default: false
        '''
        result = self._values.get("cross_account_keys")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def docker_credentials(
        self,
    ) -> typing.Optional[typing.List[aws_cdk.pipelines.DockerCredential]]:
        '''A list of credentials used to authenticate to Docker registries.

        Specify any credentials necessary within the pipeline to build, synth, update, or publish assets.

        :default: []
        '''
        result = self._values.get("docker_credentials")
        return typing.cast(typing.Optional[typing.List[aws_cdk.pipelines.DockerCredential]], result)

    @builtins.property
    def docker_enabled_for_self_mutation(self) -> typing.Optional[builtins.bool]:
        '''Enable Docker for the self-mutate step.

        Set this to true if the pipeline itself uses Docker container assets
        (for example, if you use ``LinuxBuildImage.fromAsset()`` as the build
        image of a CodeBuild step in the pipeline).

        You do not need to set it if you build Docker image assets in the
        application Stages and Stacks that are *deployed* by this pipeline.

        Configures privileged mode for the self-mutation CodeBuild action.

        If you are about to turn this on in an already-deployed Pipeline,
        set the value to ``true`` first, commit and allow the pipeline to
        self-update, and only then use the Docker asset in the pipeline.

        :default: false
        '''
        result = self._values.get("docker_enabled_for_self_mutation")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def docker_enabled_for_synth(self) -> typing.Optional[builtins.bool]:
        '''Enable Docker for the 'synth' step.

        Set this to true if you are using file assets that require
        "bundling" anywhere in your application (meaning an asset
        compilation step will be run with the tools provided by
        a Docker image), both for the Pipeline stack as well as the
        application stacks.

        A common way to use bundling assets in your application is by
        using the ``@aws-cdk/aws-lambda-nodejs`` library.

        Configures privileged mode for the synth CodeBuild action.

        If you are about to turn this on in an already-deployed Pipeline,
        set the value to ``true`` first, commit and allow the pipeline to
        self-update, and only then use the bundled asset.

        :default: false
        '''
        result = self._values.get("docker_enabled_for_synth")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def pipeline_name(self) -> typing.Optional[builtins.str]:
        '''The name of the CodePipeline pipeline.

        :default: - Automatically generated
        '''
        result = self._values.get("pipeline_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def publish_assets_in_parallel(self) -> typing.Optional[builtins.bool]:
        '''Publish assets in multiple CodeBuild projects.

        If set to false, use one Project per type to publish all assets.

        Publishing in parallel improves concurrency and may reduce publishing
        latency, but may also increase overall provisioning time of the CodeBuild
        projects.

        Experiment and see what value works best for you.

        :default: true
        '''
        result = self._values.get("publish_assets_in_parallel")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def reuse_cross_region_support_stacks(self) -> typing.Optional[builtins.bool]:
        '''Reuse the same cross region support stack for all pipelines in the App.

        :default: - true (Use the same support stack for all pipelines in App)
        '''
        result = self._values.get("reuse_cross_region_support_stacks")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def self_mutation(self) -> typing.Optional[builtins.bool]:
        '''Whether the pipeline will update itself.

        This needs to be set to ``true`` to allow the pipeline to reconfigure
        itself when assets or stages are being added to it, and ``true`` is the
        recommended setting.

        You can temporarily set this to ``false`` while you are iterating
        on the pipeline itself and prefer to deploy changes using ``cdk deploy``.

        :default: true
        '''
        result = self._values.get("self_mutation")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def self_mutation_code_build_defaults(
        self,
    ) -> typing.Optional[aws_cdk.pipelines.CodeBuildOptions]:
        '''Additional customizations to apply to the self mutation CodeBuild projects.

        :default: - Only ``codeBuildDefaults`` are applied
        '''
        result = self._values.get("self_mutation_code_build_defaults")
        return typing.cast(typing.Optional[aws_cdk.pipelines.CodeBuildOptions], result)

    @builtins.property
    def synth_code_build_defaults(
        self,
    ) -> typing.Optional[aws_cdk.pipelines.CodeBuildOptions]:
        '''Additional customizations to apply to the synthesize CodeBuild projects.

        :default: - Only ``codeBuildDefaults`` are applied
        '''
        result = self._values.get("synth_code_build_defaults")
        return typing.cast(typing.Optional[aws_cdk.pipelines.CodeBuildOptions], result)

    @builtins.property
    def primary_synth_directory(self) -> builtins.str:
        '''Output directory for cdk synthesized artifacts i.e: packages/infra/cdk.out.'''
        result = self._values.get("primary_synth_directory")
        assert result is not None, "Required property 'primary_synth_directory' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def repository_name(self) -> builtins.str:
        '''Name of the CodeCommit repository to create.'''
        result = self._values.get("repository_name")
        assert result is not None, "Required property 'repository_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def default_branch_name(self) -> typing.Optional[builtins.str]:
        '''Branch to trigger the pipeline execution.

        :default: mainline
        '''
        result = self._values.get("default_branch_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def pr_build_checker(self) -> typing.Optional[builtins.bool]:
        '''Enables a build job to trigger on PR merges to the defaultBranchName.

        This
        will automatically build the codebase and add an Approval to the PR on
        successful build.

        :default: true
        '''
        result = self._values.get("pr_build_checker")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def sonar_code_scanner_config(self) -> typing.Optional["SonarCodeScannerConfig"]:
        '''Configuration for enabling Sonarqube code scanning.

        :default: undefined
        '''
        result = self._values.get("sonar_code_scanner_config")
        return typing.cast(typing.Optional["SonarCodeScannerConfig"], result)

    @builtins.property
    def synth_shell_step_partial_props(
        self,
    ) -> typing.Optional[aws_cdk.pipelines.ShellStepProps]:
        '''PDKPipeline by default assumes a NX Monorepo structure for it's codebase and uses sane defaults for the install and run commands.

        To override these defaults
        and/or provide additional inputs, specify env settings, etc you can provide
        a partial ShellStepProps.
        '''
        result = self._values.get("synth_shell_step_partial_props")
        return typing.cast(typing.Optional[aws_cdk.pipelines.ShellStepProps], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PDKPipelineProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class SonarCodeScanner(
    constructs.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="aws-prototyping-sdk.pdk_pipeline.SonarCodeScanner",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        artifact_bucket_arn: builtins.str,
        synth_build_arn: builtins.str,
        artifact_bucket_key_arn: typing.Optional[builtins.str] = None,
        sonarqube_authorized_group: builtins.str,
        sonarqube_default_profile_or_gate_name: builtins.str,
        sonarqube_endpoint: builtins.str,
        sonarqube_project_name: builtins.str,
        cfn_nag_ignore_path: typing.Optional[builtins.str] = None,
        sonarqube_specific_profile_or_gate_name: typing.Optional[builtins.str] = None,
        sonarqube_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param artifact_bucket_arn: 
        :param synth_build_arn: 
        :param artifact_bucket_key_arn: 
        :param sonarqube_authorized_group: 
        :param sonarqube_default_profile_or_gate_name: 
        :param sonarqube_endpoint: 
        :param sonarqube_project_name: 
        :param cfn_nag_ignore_path: 
        :param sonarqube_specific_profile_or_gate_name: 
        :param sonarqube_tags: 
        '''
        props = SonarCodeScannerProps(
            artifact_bucket_arn=artifact_bucket_arn,
            synth_build_arn=synth_build_arn,
            artifact_bucket_key_arn=artifact_bucket_key_arn,
            sonarqube_authorized_group=sonarqube_authorized_group,
            sonarqube_default_profile_or_gate_name=sonarqube_default_profile_or_gate_name,
            sonarqube_endpoint=sonarqube_endpoint,
            sonarqube_project_name=sonarqube_project_name,
            cfn_nag_ignore_path=cfn_nag_ignore_path,
            sonarqube_specific_profile_or_gate_name=sonarqube_specific_profile_or_gate_name,
            sonarqube_tags=sonarqube_tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])


@jsii.data_type(
    jsii_type="aws-prototyping-sdk.pdk_pipeline.SonarCodeScannerConfig",
    jsii_struct_bases=[],
    name_mapping={
        "sonarqube_authorized_group": "sonarqubeAuthorizedGroup",
        "sonarqube_default_profile_or_gate_name": "sonarqubeDefaultProfileOrGateName",
        "sonarqube_endpoint": "sonarqubeEndpoint",
        "sonarqube_project_name": "sonarqubeProjectName",
        "cfn_nag_ignore_path": "cfnNagIgnorePath",
        "sonarqube_specific_profile_or_gate_name": "sonarqubeSpecificProfileOrGateName",
        "sonarqube_tags": "sonarqubeTags",
    },
)
class SonarCodeScannerConfig:
    def __init__(
        self,
        *,
        sonarqube_authorized_group: builtins.str,
        sonarqube_default_profile_or_gate_name: builtins.str,
        sonarqube_endpoint: builtins.str,
        sonarqube_project_name: builtins.str,
        cfn_nag_ignore_path: typing.Optional[builtins.str] = None,
        sonarqube_specific_profile_or_gate_name: typing.Optional[builtins.str] = None,
        sonarqube_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param sonarqube_authorized_group: 
        :param sonarqube_default_profile_or_gate_name: 
        :param sonarqube_endpoint: 
        :param sonarqube_project_name: 
        :param cfn_nag_ignore_path: 
        :param sonarqube_specific_profile_or_gate_name: 
        :param sonarqube_tags: 
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "sonarqube_authorized_group": sonarqube_authorized_group,
            "sonarqube_default_profile_or_gate_name": sonarqube_default_profile_or_gate_name,
            "sonarqube_endpoint": sonarqube_endpoint,
            "sonarqube_project_name": sonarqube_project_name,
        }
        if cfn_nag_ignore_path is not None:
            self._values["cfn_nag_ignore_path"] = cfn_nag_ignore_path
        if sonarqube_specific_profile_or_gate_name is not None:
            self._values["sonarqube_specific_profile_or_gate_name"] = sonarqube_specific_profile_or_gate_name
        if sonarqube_tags is not None:
            self._values["sonarqube_tags"] = sonarqube_tags

    @builtins.property
    def sonarqube_authorized_group(self) -> builtins.str:
        result = self._values.get("sonarqube_authorized_group")
        assert result is not None, "Required property 'sonarqube_authorized_group' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def sonarqube_default_profile_or_gate_name(self) -> builtins.str:
        result = self._values.get("sonarqube_default_profile_or_gate_name")
        assert result is not None, "Required property 'sonarqube_default_profile_or_gate_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def sonarqube_endpoint(self) -> builtins.str:
        result = self._values.get("sonarqube_endpoint")
        assert result is not None, "Required property 'sonarqube_endpoint' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def sonarqube_project_name(self) -> builtins.str:
        result = self._values.get("sonarqube_project_name")
        assert result is not None, "Required property 'sonarqube_project_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def cfn_nag_ignore_path(self) -> typing.Optional[builtins.str]:
        result = self._values.get("cfn_nag_ignore_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def sonarqube_specific_profile_or_gate_name(self) -> typing.Optional[builtins.str]:
        result = self._values.get("sonarqube_specific_profile_or_gate_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def sonarqube_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("sonarqube_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SonarCodeScannerConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="aws-prototyping-sdk.pdk_pipeline.SonarCodeScannerProps",
    jsii_struct_bases=[SonarCodeScannerConfig],
    name_mapping={
        "sonarqube_authorized_group": "sonarqubeAuthorizedGroup",
        "sonarqube_default_profile_or_gate_name": "sonarqubeDefaultProfileOrGateName",
        "sonarqube_endpoint": "sonarqubeEndpoint",
        "sonarqube_project_name": "sonarqubeProjectName",
        "cfn_nag_ignore_path": "cfnNagIgnorePath",
        "sonarqube_specific_profile_or_gate_name": "sonarqubeSpecificProfileOrGateName",
        "sonarqube_tags": "sonarqubeTags",
        "artifact_bucket_arn": "artifactBucketArn",
        "synth_build_arn": "synthBuildArn",
        "artifact_bucket_key_arn": "artifactBucketKeyArn",
    },
)
class SonarCodeScannerProps(SonarCodeScannerConfig):
    def __init__(
        self,
        *,
        sonarqube_authorized_group: builtins.str,
        sonarqube_default_profile_or_gate_name: builtins.str,
        sonarqube_endpoint: builtins.str,
        sonarqube_project_name: builtins.str,
        cfn_nag_ignore_path: typing.Optional[builtins.str] = None,
        sonarqube_specific_profile_or_gate_name: typing.Optional[builtins.str] = None,
        sonarqube_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        artifact_bucket_arn: builtins.str,
        synth_build_arn: builtins.str,
        artifact_bucket_key_arn: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param sonarqube_authorized_group: 
        :param sonarqube_default_profile_or_gate_name: 
        :param sonarqube_endpoint: 
        :param sonarqube_project_name: 
        :param cfn_nag_ignore_path: 
        :param sonarqube_specific_profile_or_gate_name: 
        :param sonarqube_tags: 
        :param artifact_bucket_arn: 
        :param synth_build_arn: 
        :param artifact_bucket_key_arn: 
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "sonarqube_authorized_group": sonarqube_authorized_group,
            "sonarqube_default_profile_or_gate_name": sonarqube_default_profile_or_gate_name,
            "sonarqube_endpoint": sonarqube_endpoint,
            "sonarqube_project_name": sonarqube_project_name,
            "artifact_bucket_arn": artifact_bucket_arn,
            "synth_build_arn": synth_build_arn,
        }
        if cfn_nag_ignore_path is not None:
            self._values["cfn_nag_ignore_path"] = cfn_nag_ignore_path
        if sonarqube_specific_profile_or_gate_name is not None:
            self._values["sonarqube_specific_profile_or_gate_name"] = sonarqube_specific_profile_or_gate_name
        if sonarqube_tags is not None:
            self._values["sonarqube_tags"] = sonarqube_tags
        if artifact_bucket_key_arn is not None:
            self._values["artifact_bucket_key_arn"] = artifact_bucket_key_arn

    @builtins.property
    def sonarqube_authorized_group(self) -> builtins.str:
        result = self._values.get("sonarqube_authorized_group")
        assert result is not None, "Required property 'sonarqube_authorized_group' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def sonarqube_default_profile_or_gate_name(self) -> builtins.str:
        result = self._values.get("sonarqube_default_profile_or_gate_name")
        assert result is not None, "Required property 'sonarqube_default_profile_or_gate_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def sonarqube_endpoint(self) -> builtins.str:
        result = self._values.get("sonarqube_endpoint")
        assert result is not None, "Required property 'sonarqube_endpoint' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def sonarqube_project_name(self) -> builtins.str:
        result = self._values.get("sonarqube_project_name")
        assert result is not None, "Required property 'sonarqube_project_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def cfn_nag_ignore_path(self) -> typing.Optional[builtins.str]:
        result = self._values.get("cfn_nag_ignore_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def sonarqube_specific_profile_or_gate_name(self) -> typing.Optional[builtins.str]:
        result = self._values.get("sonarqube_specific_profile_or_gate_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def sonarqube_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        result = self._values.get("sonarqube_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def artifact_bucket_arn(self) -> builtins.str:
        result = self._values.get("artifact_bucket_arn")
        assert result is not None, "Required property 'artifact_bucket_arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def synth_build_arn(self) -> builtins.str:
        result = self._values.get("synth_build_arn")
        assert result is not None, "Required property 'synth_build_arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def artifact_bucket_key_arn(self) -> typing.Optional[builtins.str]:
        result = self._values.get("artifact_bucket_key_arn")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SonarCodeScannerProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


__all__ = [
    "PDKPipeline",
    "PDKPipelineProps",
    "SonarCodeScanner",
    "SonarCodeScannerConfig",
    "SonarCodeScannerProps",
]

publication.publish()
