"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PDKPipeline = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_codecommit_1 = require("aws-cdk-lib/aws-codecommit");
const pipelines_1 = require("aws-cdk-lib/pipelines");
const sonar_code_scanner_1 = require("./code_scanner/sonar-code-scanner");
__exportStar(require("./code_scanner/sonar-code-scanner"), exports);
const DEFAULT_BRANCH_NAME = "mainline";
/**
 * An extension to CodePipeline which configures sane defaults for a NX Monorepo
 * codebase. In addition to this, it also creates a CodeCommit repository with
 * automated PR builds and approvals.
 */
class PDKPipeline extends pipelines_1.CodePipeline {
    constructor(scope, id, props) {
        const codeRepository = new aws_codecommit_1.Repository(scope, "CodeRepository", {
            repositoryName: props.repositoryName,
        });
        // TODO: Implement prBuildChecker
        // ignore input and primaryOutputDirectory
        const { input, primaryOutputDirectory, commands, ...synthShellStepPartialProps } = props.synthShellStepPartialProps || {};
        const codePipelineProps = {
            ...props,
            synth: new pipelines_1.ShellStep("Synth", {
                input: pipelines_1.CodePipelineSource.codeCommit(codeRepository, props.defaultBranchName || DEFAULT_BRANCH_NAME),
                installCommands: ["yarn install --frozen-lockfile"],
                commands: commands && commands.length > 0
                    ? commands
                    : ["npx nx run-many --target=build --all"],
                primaryOutputDirectory: props.primarySynthDirectory,
                ...(synthShellStepPartialProps || {}),
            }),
        };
        super(scope, id, codePipelineProps);
        this.codeRepository = codeRepository;
        this.sonarCodeScannerConfig =
            props.sonarCodeScannerConfig ||
                this.node.tryGetContext("sonarqubeScannerConfig");
        new aws_cdk_lib_1.CfnOutput(scope, "CodeRepositoryGRCUrl", {
            exportName: "CodeRepositoryGRCUrl",
            value: this.codeRepository.repositoryCloneUrlGrc,
        });
    }
    buildPipeline() {
        var _b;
        super.buildPipeline();
        this.sonarCodeScannerConfig &&
            new sonar_code_scanner_1.SonarCodeScanner(this, "SonarCodeScanner", {
                artifactBucketArn: this.pipeline.artifactBucket.bucketArn,
                artifactBucketKeyArn: (_b = this.pipeline.artifactBucket.encryptionKey) === null || _b === void 0 ? void 0 : _b.keyArn,
                synthBuildArn: this.synthProject.projectArn,
                ...this.sonarCodeScannerConfig,
            });
    }
}
exports.PDKPipeline = PDKPipeline;
_a = JSII_RTTI_SYMBOL_1;
PDKPipeline[_a] = { fqn: "aws-prototyping-sdk.pdk_pipeline.PDKPipeline", version: "0.0.38" };
//# sourceMappingURL=data:application/json;base64,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