#!/usr/bin/env python
from setuptools import setup
setup(
  name = 'cs.buffer',
  description = 'Facilities to do with buffers, particularly CornuCopyBuffer, an automatically refilling buffer to support parsing of data streams.',
  author = 'Cameron Simpson',
  author_email = 'cs@cskk.id.au',
  version = '20200229',
  url = 'https://bitbucket.org/cameron_simpson/css/commits/all',
  classifiers = ['Programming Language :: Python', 'Programming Language :: Python :: 3', 'Development Status :: 5 - Production/Stable', 'Intended Audience :: Developers', 'Operating System :: OS Independent', 'Topic :: Software Development :: Libraries :: Python Modules', 'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)'],
  include_package_data = True,
  install_requires = ['cs.py3'],
  keywords = ['python3'],
  license = 'GNU General Public License v3 or later (GPLv3+)',
  long_description = '*Latest release 20200229*:\nNew CornuCopyBuffer.byte0() method consuming the next byte and returning it as an int.\nCornuCopyBuffer.takev: bugfix for size=0, logic refactor.\nCornuCopyBuffer: new .selfcheck method.\n\nFacilities to do with buffers, particularly CornuCopyBuffer,\nan automatically refilling buffer to support parsing of data streams.\n\n## Function `chunky(bfr_func)`\n\nDecorator for a function accepting a leading `CornuCopyBuffer`\nparameter.\nReturns a function accepting a leading data chunks parameter\n(bytes instances) and optional `offset` and \'copy_offsets`\nkeywords parameters.\n\nExample::\n\n    @chunky\n    def func(bfr, ...):\n\n## Class `CopyingIterator`\n\nWrapper for an iterator that copies every item retrieved to a callable.\n\n### Method `CopyingIterator.__init__(self, I, copy_to)`\n\nInitialise with the iterator `I` and the callable `copy_to`.\n\n## Class `CornuCopyBuffer`\n\nAn automatically refilling buffer intended to support parsing\nof data streams.\n\nIts purpose is to aid binary parsers\nwhich do not themselves need to handle sources specially;\n`CornuCopyBuffer`s are trivially made from `bytes`,\niterables of `bytes` and file-like objects.\nSee `cs.binary` for convenient parsing classes\nwhich work against `CornuCopyBuffer`s.\n\nAttributes:\n* `buf`: the first of any buffered leading chunks\n  buffer of unparsed data from the input, available\n  for direct inspection by parsers;\n  normally however parsers will use `.extend` and `.take`.\n* `offset`: the logical offset of the buffer; this excludes\n  buffered data and unconsumed input data\n\nThe primary methods supporting parsing of data streams are\n`.extend()` and `take()`.\nCalling `.extend(min_size)` arranges that `.buf` contains at least\n`min_size` bytes.\nCalling `.take(size)` fetches exactly `size` bytes from `.buf` and the\ninput source if necessary and returns them, adjusting `.buf`.\n\nlen(`CornuCopyBuffer`) returns the length of any buffered data.\n\nbool(`CornuCopyBuffer`) tests whether len() > 0.\n\nIndexing a `CornuCopyBuffer` accesses the buffered data only,\nreturning an individual byte\'s value (an `int`).\n\nA `CornuCopyBuffer` is also iterable, yielding data in whatever\nsizes come from its `input_data` source, preceeded by the\ncurrent `.buf` if not empty.\n\nA `CornuCopyBuffer` also supports the file methods `.read`,\n`.tell` and `.seek` supporting drop in use of the buffer in\nmany file contexts. Backward seeks are not supported. `.seek`\nwill take advantage of the `input_data`\'s .seek method if it\nhas one, otherwise it will use reads.\n\n### Method `CornuCopyBuffer.__init__(self, input_data, buf=None, offset=0, seekable=None, copy_offsets=None, copy_chunks=None)`\n\nPrepare the buffer.\n\nParameters:\n* `input_data`: an iterable of data chunks (bytes-like instances);\n  if your data source is a file see the .from_file factory;\n  if your data source is a file descriptor see the .from_fd\n  factory.\n* `buf`: if not `None`, the initial state of the parse buffer\n* `offset`: logical offset of the start of the buffer, default 0\n* `seekable`: whether `input_data` has a working `.seek` method;\n  the default is None meaning that it will be attempted on\n  the first skip or seek\n* `copy_offsets`: if not `None`, a callable for parsers to\n  report pertinent offsets via the buffer\'s .report_offset\n  method\n* `copy_chunks`: if not `None`, every fetched data chunk is\n  copied to this callable\n\nThe `input_data` is an iterable whose iterator may have\nsome optional additional properties:\n* `seek`: if present, this is a seek method after the fashion\n  of `file.seek`; the buffer\'s `seek`, `skip` and `skipto`\n  methods will take advantage of this if available.\n* `offset`: the current byte offset of the iterator; this\n  is used during the buffer initialisation to compute\n  `input_data_displacement`, the difference between the\n  buffer\'s logical offset and the input data\'s logical offset;\n  if unavailable during initialisation this is presumed to\n  be `0`.\n* `end_offset`: the end offset of the iterator if known.\n\n## Class `FDIterator(_Iterator)`\n\nAn iterator over the data of a file descriptor.\n\n*Note*: the iterator works with an os.dup() of the file\ndescriptor so that it can close it with impunity; this requires\nthe caller to close their descriptor.\n\n### Method `FDIterator.__init__(self, fd, offset=None, readsize=None, align=True)`\n\nInitialise the iterator.\n\nParameters:\n* `fd`: file descriptor\n* `offset`: the initial logical offset, kept up to date by\n  iteration; the default is the current file position.\n* `readsize`: a preferred read size; if omitted then\n  `DEFAULT_READSIZE` will be stored\n* `align`: whether to align reads by default: if true then\n  the iterator will do a short read to bring the `offset`\n  into alignment with `readsize`; the default is `True`\n\n## Class `FileIterator(_Iterator,SeekableIteratorMixin)`\n\nAn iterator over the data of a file object.\n\n*Note*: the iterator closes the file on `__del__` or if its\n`.close` method is called.\n\n### Method `FileIterator.__init__(self, fp, offset=None, readsize=None, align=False)`\n\nInitialise the iterator.\n\nParameters:\n* `fp`: file object\n* `offset`: the initial logical offset, kept up to date by\n  iteration; the default is 0.\n* `readsize`: a preferred read size; if omitted then\n  `DEFAULT_READSIZE` will be stored\n* `align`: whether to align reads by default: if true then\n  the iterator will do a short read to bring the `offset`\n  into alignment with `readsize`; the default is `False`\n\n## Class `SeekableFDIterator(FDIterator,_Iterator,SeekableIteratorMixin)`\n\nAn iterator over the data of a seekable file descriptor.\n\n*Note*: the iterator works with an `os.dup()` of the file\ndescriptor so that it can close it with impunity; this requires\nthe caller to close their descriptor.\n\n## Class `SeekableFileIterator(FileIterator,_Iterator,SeekableIteratorMixin)`\n\nAn iterator over the data of a seekable file object.\n\n*Note*: the iterator closes the file on __del__ or if its\n.close method is called.\n\n### Method `SeekableFileIterator.__init__(self, fp, offset=None, **kw)`\n\nInitialise the iterator.\n\nParameters:\n* `fp`: file object\n* `offset`: the initial logical offset, kept up to date by\n  iteration; the default is the current file position.\n* `readsize`: a preferred read size; if omitted then\n  `DEFAULT_READSIZE` will be stored\n* `align`: whether to align reads by default: if true then\n  the iterator will do a short read to bring the `offset`\n  into alignment with `readsize`; the default is `False`\n\n## Class `SeekableIteratorMixin`\n\nMixin supplying a logical with a `seek` method.\n\n## Class `SeekableMMapIterator(_Iterator,SeekableIteratorMixin)`\n\nAn iterator over the data of a mappable file descriptor.\n\n*Note*: the iterator works with an `mmap` of an `os.dup()` of the\nfile descriptor so that it can close it with impunity; this\nrequires the caller to close their descriptor.\n\n### Method `SeekableMMapIterator.__init__(self, fd, offset=None, readsize=None, align=True)`\n\nInitialise the iterator.\n\nParameters:\n* `offset`: the initial logical offset, kept up to date by\n  iteration; the default is the current file position.\n* `readsize`: a preferred read size; if omitted then\n  `DEFAULT_READSIZE` will be stored\n* `align`: whether to align reads by default: if true then\n  the iterator will do a short read to bring the `offset`\n  into alignment with `readsize`; the default is `True`\n\n\n\n# Release Log\n\n*Release 20200229*:\nNew CornuCopyBuffer.byte0() method consuming the next byte and returning it as an int.\nCornuCopyBuffer.takev: bugfix for size=0, logic refactor.\nCornuCopyBuffer: new .selfcheck method.\n\n*Release 20200130*:\nCornuCopyBuffer.skip: bugfix adjustment of skipto for already buffered data.\n\n*Release 20191230.1*:\nDocstring updates. Semantic changes were in the previous release.\n\n*Release 20191230*:\nCornuCopyBuffer: accept a size of Ellipsis in .take and .extend methods, indicating "all the remaining data".\nCornuCopyBuffer: refactor the buffering, replacing .buf with .bufs as an array of chunks;\nthis enables support for the new .push method and reduces memory copying.\n\n*Release 20181231*:\nSmall bugfix.\n\n*Release 20181108*:\nNew at_eof() method. Python 2 tweak to support incidental import by python 2 even if unused.\n\n*Release 20180823*:\nBetter handling of seekable and unseekable input data. Tiny bugfix for from_bytes sanity check.\n\n*Release 20180810*:\nRefactor SeekableFDIterator and SeekableFileIterator to subclass new SeekableIterator.\nNew SeekableMMapIterator to process a memory mapped file descriptor, intended for large files.\nNew CornuCopyBuffer.hint method to pass a length hint through to the input_data iterator\nif it has a `hint` method, causing it possibly to make a differently sized fetch.\nSeekableIterator: new __del__ method calling self.close() - subclasses must provide\na .close, which should be safe to call multiple times.\nCornuCopyBuffer: add support for .offset and .end_offset optional attributes on the input_data iterator.\n_BoundedBufferIterator: add .offset property plumbed to the underlying buffer offset.\nNew CornuCopyBuffer.from_mmap to make a mmap backed buffer so that large data can be returned without penalty.\nAssorted fixes and doc improvements.\n\n*Release 20180805*:\nBugfixes for at_eof method and end_offset initialisation.\n\n*Release 20180726.1*:\nImprove docstrings and release with better long_description.\n\n*Release 20180726*:\nFirst PyPI release: CornuCopyBuffer and friends.',
  long_description_content_type = 'text/markdown',
  package_dir = {'': 'lib/python'},
  py_modules = ['cs.buffer'],
)
