# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ecoindex_cli', 'ecoindex_cli.cli', 'ecoindex_cli.report']

package_data = \
{'': ['*']}

install_requires = \
['Jinja2>=3.0.1,<4.0.0',
 'Scrapy>=2.5.0,<3.0.0',
 'click-spinner>=0.1.10,<0.2.0',
 'ecoindex>=2.6.0,<3.0.0',
 'matplotlib>=3.4.3,<4.0.0',
 'pandas>=1.3.3,<2.0.0',
 'pydantic>=1.8.2,<2.0.0',
 'typer>=0.3.2,<0.5.0']

entry_points = \
{'console_scripts': ['ecoindex-cli = ecoindex_cli.cli.app:app']}

setup_kwargs = {
    'name': 'ecoindex-cli',
    'version': '2.4.0',
    'description': '`ecoindex-cli` is a CLI tool that let you make ecoindex tests on given pages',
    'long_description': '# Ecoindex-Cli\n\n[![Quality check](https://github.com/cnumr/ecoindex_cli/workflows/Quality%20checks/badge.svg)](https://github.com/cnumr/ecoindex_cli/actions/workflows/quality.yml)\n[![PyPI version](https://badge.fury.io/py/ecoindex-cli.svg)](https://badge.fury.io/py/ecoindex-cli)\n\nThis tool provides an easy way to analyze websites with [Ecoindex](http://www.ecoindex.fr) from your local computer. You have the ability to:\n\n- Make the analysis on multiple pages\n- Define multiple screen resolution\n- Make a recursive analysis from a given website\n\nThis CLI is built on top of [ecoindex-python](https://pypi.org/project/ecoindex/) with [Typer](https://typer.tiangolo.com/)\n\nThe output is always a CSV file with the results of the analysis.\n\n> **Current limitation:** This does not work well with SPA.\n\n## Requirements\n\n- Python ^3.8\n- [pip](https://pip.pypa.io/en/stable/)\n\n## Setup\n\n```Bash\n➜ pip install --user -U ecoindex-cli\n```\n\n## Use case\n\nThe cli gets 2 commands: `analyze` and `report` which can be used separately:\n\n```Bash\n➜ ecoindex-cli --help                                Usage: ecoindex-cli [OPTIONS] COMMAND [ARGS]...\n\n  Ecoindex cli to make analysis of webpages\n\nOptions:\n  --install-completion [bash|zsh|fish|powershell|pwsh]\n                                  Install completion for the specified shell.\n  --show-completion [bash|zsh|fish|powershell|pwsh]\n                                  Show completion for the specified shell, to\n                                  copy it or customize the installation.\n\n  --help                          Show this message and exit.\n\nCommands:\n  analyze  Make an ecoindex analysis of given webpages or website.\n  report   If you already performed an ecoindex analysis and have your...\n```\n\n### Make a simple analysis\n\nYou give just one web url\n\n```Bash\n➜ ecoindex-cli analyze --url http://www.ecoindex.fr\nThere are 1 url(s), do you want to process? [Y/n]:\n1 urls for 1 window size\nProcessing  [####################################]  100%\n🙌️ File /tmp/ecoindex-cli/output/www.ecoindex.fr/2021-04-20 16:44:33.468755/results.csv written !\n```\n\n> This makes an analysis with a screen resolution of 1920x1080px by default\n\n### Set the output file\n\nYou can define the csv output file\n\n```Bash\n➜ ecoindex-cli analyze --url http://www.ecoindex.fr --output-file ~/ecoindex-results/ecoindex.csv\n📁️ Urls recorded in file `input/www.ecoindex.fr.csv`\nThere are 1 url(s), do you want to process? [Y/n]:\n1 urls for 1 window size\nProcessing  [####################################]  100%\n🙌️ File /home/vvatelot/ecoindex-results/ecoindex.csv written !\n```\n\n### Multiple url analysis\n\n```Bash\n➜ ecoindex-cli analyze --url http://www.ecoindex.fr --url https://www.greenit.fr/\nThere are 2 url(s), do you want to process? [Y/n]:\n2 urls for 1 window size\nProcessing  [####################################]  100%\n🙌️ File /tmp/ecoindex-cli/output/www.ecoindex.fr/2021-04-20 16:45:24.458052/results.csv written !\n```\n\n### Provide urls from a file\n\nYou can use a file with given urls that you want to analyze: One url per line. This is helpful if you want to play the same scenario recurrently.\n\n```Bash\n➜ ecoindex-cli analyze --urls-file input/ecoindex.csv\nThere are 2 url(s), do you want to process? [Y/n]:\n2 urls for 1 window size\nProcessing  [####################################]  100%\n🙌️ File /tmp/ecoindex-cli/output/www.ecoindex.fr/2021-04-20 16:45:24.458052/results.csv written !\n```\n\n### Make a recursive analysis\n\nYou can make a recursive analysis of a given webiste. This means that the app will try to find out all the pages into your website and launch an analysis on all those web pages. ⚠️ This can process for a very long time! **Use it at your own risks!**\n\n```Bash\n➜ ecoindex-cli analyze --url http://www.ecoindex.fr --recursive\n⏲️ Crawling root url http://www.ecoindex.fr -> Wait a minute !\n📁️ Urls recorded in file `/tmp/ecoindex-cli/input/www.ecoindex.fr.csv`\nThere are 3 url(s), do you want to process? [Y/n]:\n3 urls for 1 window size\nProcessing  [####################################]  100%\n🙌️ File /tmp/ecoindex-cli/output/www.ecoindex.fr/2021-04-20 16:47:29.072472/results.csv written !\n```\n\n### Disable console interaction\n\nYou can disable confirmations, and force the app to answer yes to all of them. It can be useful if you need to start the app from another script, or if you have no time to wait it to finish.\n\n```Bash\n➜ ecoindex-cli analyze --url http://www.ecoindex.fr --recursive --no-interaction\n⏲️ Crawling root url http://www.ecoindex.fr -> Wait a minute !\n📁️ Urls recorded in file `/tmp/ecoindex-cli/input/www.ecoindex.fr.csv`\n3 urls for 1 window size\nProcessing  [####################################]  100%\n🙌️ File /tmp/ecoindex-cli/output/www.ecoindex.fr/2021-11-04 08:19:13.410571/results.csv written !\n```\n\n### Set other screen resolutions\n\nYou can provide other screen resolutions. By default, the screen resolution is `1920x1080px` but you can provide other resolution for example if you want to test ecoindex for mobile.\n\n```Bash\n➜ ecoindex-cli analyze --url http://www.ecoindex.fr --window-size 1920,1080 --window-size 386,540\nThere are 1 url(s), do you want to process? [Y/n]:\n1 urls for 2 window size\nProcessing  [####################################]  100%\n🙌️ File /tmp/ecoindex-cli/output/www.ecoindex.fr/2021-04-21 21:22:44.309077/results.csv written !\n```\n\n### Generate a html report\n\nYou can generate a html report easily at the end of the analysis. You just have to add the option `--html-report`.\n\n```Bash\n➜ ecoindex-cli analyze --url http://www.ecoindex.fr --recursive --html-report\n⏲️ Crawling root url http://www.ecoindex.fr -> Wait a minute !\n📁️ Urls recorded in file `input/www.ecoindex.fr.csv`\nThere are 3 url(s), do you want to process? [Y/n]:\n3 urls for 1 window size\nProcessing  [####################################]  100%\n🙌️ File output/www.ecoindex.fr/2021-04-21 21:21:27.629691/results.csv written !\n🦄️ Amazing! A report has been generated to `/tmp/ecoindex-cli/output/www.ecoindex.fr/2021-04-21 21:21:27.629691/report.html`\n```\n\nHere is a sample result:\n![Sample report](doc/report.png)\n\n### Only generate a report from existing result file\n\nIf you already performed an anlayzis and (for example), forgot to generate the html report, you do not need to re-run a full analyzis, you can simply request a report from your result file :\n\n```Bash\n➜ ecoindex-cli report "/tmp/ecoindex-cli/output/www.ecoindex.fr/2021-05-06 19:13:55.735935/results.csv" "www.synchrone.fr"\n🦄️ Amazing! A report has been generated to `/tmp/ecoindex-cli/output/www.ecoindex.fr/2021-05-06 19:13:55.735935/report.html`\n```\n\n## Results example\n\nThe result of the analysis is a CSV file which can be easily used for further analysis:\n\n```csv\nsize,nodes,requests,grade,score,ges,water,url,date,resolution,page_type\n119.095,45,8,A,89,1.22,1.83,http://www.ecoindex.fr,2021-04-20 16:45:28.570179,"1920,1080",\n769.252,730,94,D,41,2.18,3.27,https://www.greenit.fr/,2021-04-20 16:45:32.199242,"1920,1080",website\n```\n\nWhere:\n\n- `size` is the size of the page and of the downloaded elements of the page in KB\n- `nodes` is the number of the DOM elements in the page\n- `requests` is the number of external requests made by the page\n- `grade` is the corresponding ecoindex grade of the page (from A to G)\n- `score`\xa0is the corresponding ecoindex score of the page (0 to 100)\n- `ges` is the equivalent of greenhouse gases emission (in `gCO2e`) of the page\n- `water`is the equivalent water consumption (in `cl`) of the page\n- `url` is the analysed page url\n- `date` is the datetime of the page analysis\n- `resolution` is the screen resolution used for the page analysis (`width,height`)\n- `page_type` is the type of the page, based ton the [opengraph type tag](https://ogp.me/#types)\n\n## Testing\n\nIn order to develop or test, you have to use [Poetry](https://python-poetry.org/), install the dependencies and execute a poetry shell:\n\n```bash\npoetry install\npoetry shell\n```\n\nWe use Pytest to run unit tests for this project. The test suite are in the `tests` folder. Just execute :\n\n```Bash\npytest --cov-report term-missing:skip-covered --cov=. --cov-config=.coveragerc tests\n```\n\n> This runs pytest and also generate a [coverage report](https://pytest-cov.readthedocs.io/en/latest/) (terminal and html)\n\n## [Contributing](CONTRIBUTING.md)\n\n## [Code of conduct](CODE_OF_CONDUCT.md)\n',
    'author': 'Vincent Vatelot',
    'author_email': 'vincent.vatelot@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'http://www.ecoindex.fr',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
