from collections.abc import KeysView
from typing import Any

from ..sql.base import InPlaceGenerative

class ResultMetaData:
    @property
    def keys(self): ...

class RMKeyView(KeysView[Any]):
    def __init__(self, parent) -> None: ...
    def __len__(self): ...
    def __iter__(self): ...
    def __contains__(self, item): ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...

class SimpleResultMetaData(ResultMetaData):
    def __init__(
        self,
        keys,
        extra: Any | None = ...,
        _processors: Any | None = ...,
        _tuplefilter: Any | None = ...,
        _translated_indexes: Any | None = ...,
        _unique_filters: Any | None = ...,
    ) -> None: ...

def result_tuple(fields, extra: Any | None = ...): ...

class ResultInternal(InPlaceGenerative): ...

class _WithKeys:
    def keys(self): ...

class Result(_WithKeys, ResultInternal):
    def __init__(self, cursor_metadata) -> None: ...
    def close(self) -> None: ...
    def yield_per(self, num) -> None: ...
    def unique(self, strategy: Any | None = ...) -> None: ...
    def columns(self, *col_expressions): ...
    def scalars(self, index: int = ...): ...
    def mappings(self): ...
    def __iter__(self): ...
    def __next__(self): ...
    def partitions(self, size: Any | None = ...) -> None: ...
    def fetchall(self): ...
    def fetchone(self): ...
    def fetchmany(self, size: Any | None = ...): ...
    def all(self): ...
    def first(self): ...
    def one_or_none(self): ...
    def scalar_one(self): ...
    def scalar_one_or_none(self): ...
    def one(self): ...
    def scalar(self): ...
    def freeze(self): ...
    def merge(self, *others): ...

class FilterResult(ResultInternal): ...

class ScalarResult(FilterResult):
    def __init__(self, real_result, index) -> None: ...
    def unique(self, strategy: Any | None = ...): ...
    def partitions(self, size: Any | None = ...) -> None: ...
    def fetchall(self): ...
    def fetchmany(self, size: Any | None = ...): ...
    def all(self): ...
    def __iter__(self): ...
    def __next__(self): ...
    def first(self): ...
    def one_or_none(self): ...
    def one(self): ...

class MappingResult(_WithKeys, FilterResult):
    def __init__(self, result) -> None: ...
    def unique(self, strategy: Any | None = ...): ...
    def columns(self, *col_expressions): ...
    def partitions(self, size: Any | None = ...) -> None: ...
    def fetchall(self): ...
    def fetchone(self): ...
    def fetchmany(self, size: Any | None = ...): ...
    def all(self): ...
    def __iter__(self): ...
    def __next__(self): ...
    def first(self): ...
    def one_or_none(self): ...
    def one(self): ...

class FrozenResult:
    metadata: Any
    data: Any
    def __init__(self, result) -> None: ...
    def rewrite_rows(self): ...
    def with_new_rows(self, tuple_data): ...
    def __call__(self): ...

class IteratorResult(Result):
    iterator: Any
    raw: Any
    def __init__(self, cursor_metadata, iterator, raw: Any | None = ..., _source_supports_scalars: bool = ...) -> None: ...

def null_result(): ...

class ChunkedIteratorResult(IteratorResult):
    chunks: Any
    raw: Any
    iterator: Any
    dynamic_yield_per: Any
    def __init__(
        self, cursor_metadata, chunks, source_supports_scalars: bool = ..., raw: Any | None = ..., dynamic_yield_per: bool = ...
    ) -> None: ...
    def yield_per(self, num) -> None: ...

class MergedResult(IteratorResult):
    closed: bool
    def __init__(self, cursor_metadata, results) -> None: ...
