"use strict";
/*
 * IMPORTANT: This file is used both by bundled lambda functions and by
 * constructs. This means it should not directly or transitively import anything
 * not part of the package's `dependencies`, such as the `aws-sdk`.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.STAGED_KEY_PREFIX = exports.FAILED_KEY_PREFIX = exports.CATALOG_KEY = exports.assemblyKeySuffix = exports.ASSEMBLY_KEY_SUFFIX = exports.PACKAGE_KEY_SUFFIX = exports.STORAGE_KEY_PREFIX = void 0;
/**
 * Key prefix for the package data storage.
 */
exports.STORAGE_KEY_PREFIX = 'data/';
/**
 * Key suffix for storing npm package bundles.
 */
exports.PACKAGE_KEY_SUFFIX = '/package.tgz';
/**
 * The key suffix for (TypeScript) assembly files
 */
exports.ASSEMBLY_KEY_SUFFIX = '/assembly.json';
/**
 * The key suffix for assemblies in the provided language. This should NOT be
 * used for the TypeScript/JavaScript assembly however.
 */
function assemblyKeySuffix(lang) {
    return `/assembly-${lang}.json`;
}
exports.assemblyKeySuffix = assemblyKeySuffix;
/**
 * The key for the catalog document.
 */
exports.CATALOG_KEY = 'catalog.json';
/**
 * Key prefix used by the built-in discovery function to store failed records.
 */
exports.FAILED_KEY_PREFIX = 'failed/';
/**
 * Key prefix used by the built-in discovery function to stage tarballs.
 */
exports.STAGED_KEY_PREFIX = 'staged/';
//# sourceMappingURL=data:application/json;base64,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