"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructHub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const s3 = require("@aws-cdk/aws-s3");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const backend_1 = require("./backend");
const monitoring_1 = require("./monitoring");
const webapp_1 = require("./webapp");
/**
 * (experimental) Construct Hub.
 *
 * @experimental
 */
class ConstructHub extends core_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        const monitoring = new monitoring_1.Monitoring(this, 'Monitoring', {
            alarmActions: props.alarmActions,
            dashboardName: (_b = props.dashboardName) !== null && _b !== void 0 ? _b : 'construct-hub',
        });
        const packageData = new s3.Bucket(this, 'PackageData', {
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            encryption: s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [
                // Abort multi-part uploads after 1 day
                { abortIncompleteMultipartUploadAfter: core_1.Duration.days(1) },
                // Transition non-current object versions to IA after 1 month
                { noncurrentVersionTransitions: [{ storageClass: s3.StorageClass.INFREQUENT_ACCESS, transitionAfter: core_1.Duration.days(31) }] },
                // Permanently delete non-current object versions after 3 months
                { noncurrentVersionExpiration: core_1.Duration.days(90) },
            ],
            versioned: true,
        });
        this.ingestion = new backend_1.Ingestion(this, 'Ingestion', { bucket: packageData });
        const discovery = new backend_1.Discovery(this, 'Discovery', { queue: this.ingestion.queue });
        discovery.bucket.grantRead(this.ingestion);
        new backend_1.Transliterator(this, 'Transliterator', { bucket: packageData });
        new backend_1.CatalogBuilder(this, 'CatalogBuilder', { bucket: packageData });
        new webapp_1.WebApp(this, 'WebApp', {
            domain: props.domain,
            monitoring: monitoring,
            packageDataBucket: packageData,
        });
    }
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    get grantPrincipal() {
        return this.ingestion.grantPrincipal;
    }
    /**
     * @experimental
     */
    get ingestionQueue() {
        return this.ingestion.queue;
    }
}
exports.ConstructHub = ConstructHub;
_a = JSII_RTTI_SYMBOL_1;
ConstructHub[_a] = { fqn: "construct-hub.ConstructHub", version: "0.1.52" };
//# sourceMappingURL=data:application/json;base64,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