"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const pdk_nag_1 = require("../../pdk-nag");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const assertions_1 = require("aws-cdk-lib/assertions");
const aws_s3_assets_1 = require("aws-cdk-lib/aws-s3-assets");
const src_1 = require("../src");
describe("PDK Pipeline Unit Tests", () => {
    it("Defaults", () => {
        const app = pdk_nag_1.PDKNag.app();
        const stack = new aws_cdk_lib_1.Stack(app);
        const pipeline = new src_1.PDKPipeline(stack, "Defaults", {
            primarySynthDirectory: "cdk.out",
            repositoryName: "Defaults",
            synth: {},
        });
        const stage = new aws_cdk_lib_1.Stage(app, "Stage");
        const appStack = new aws_cdk_lib_1.Stack(stage, "AppStack");
        new aws_s3_assets_1.Asset(appStack, "Asset", {
            path: path.join(__dirname, "pdk-pipeline.test.ts"),
        });
        pipeline.addStage(stage);
        pipeline.buildPipeline();
        expect(assertions_1.Template.fromStack(stack)).toMatchSnapshot();
    });
});
//# sourceMappingURL=data:application/json;base64,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