/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./gdbgui/src/js/gdbgui.tsx");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./gdbgui/src/js/Actions.ts":
/*!**********************************!*\
  !*** ./gdbgui/src/js/Actions.ts ***!
  \**********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _GdbApi__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./GdbApi */ "./gdbgui/src/js/GdbApi.tsx");
/* harmony import */ var _SourceCode__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SourceCode */ "./gdbgui/src/js/SourceCode.tsx");
/* harmony import */ var _Locals__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Locals */ "./gdbgui/src/js/Locals.tsx");
/* harmony import */ var _Memory__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Memory */ "./gdbgui/src/js/Memory.tsx");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./constants */ "./gdbgui/src/js/constants.ts");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);
var __values = (undefined && undefined.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};







void react__WEBPACK_IMPORTED_MODULE_6___default.a; // using jsx implicity uses React
var Actions = {
    clear_program_state: function () {
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("line_of_source_to_flash", undefined);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("paused_on_frame", undefined);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("selected_frame_num", 0);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("current_thread_id", undefined);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("stack", []);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("threads", []);
        _Memory__WEBPACK_IMPORTED_MODULE_4__["default"].clear_cache();
        _Locals__WEBPACK_IMPORTED_MODULE_3__["default"].clear();
    },
    inferior_program_starting: function () {
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("inferior_program", _constants__WEBPACK_IMPORTED_MODULE_5__["default"].inferior_states.running);
        Actions.clear_program_state();
    },
    inferior_program_resuming: function () {
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("inferior_program", _constants__WEBPACK_IMPORTED_MODULE_5__["default"].inferior_states.running);
    },
    inferior_program_paused: function (frame) {
        if (frame === void 0) { frame = {}; }
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("inferior_program", _constants__WEBPACK_IMPORTED_MODULE_5__["default"].inferior_states.paused);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("source_code_selection_state", _constants__WEBPACK_IMPORTED_MODULE_5__["default"].source_code_selection_states.PAUSED_FRAME);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("paused_on_frame", frame);
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'fullname' does not exist on type '{}'.
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("fullname_to_render", frame.fullname);
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'line' does not exist on type '{}'.
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("line_of_source_to_flash", parseInt(frame.line));
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'addr' does not exist on type '{}'.
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("current_assembly_address", frame.addr);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("source_code_infinite_scrolling", false);
        _SourceCode__WEBPACK_IMPORTED_MODULE_2__["default"].make_current_line_visible();
        Actions.refresh_state_for_gdb_pause();
    },
    inferior_program_exited: function () {
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("inferior_program", _constants__WEBPACK_IMPORTED_MODULE_5__["default"].inferior_states.exited);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("disassembly_for_missing_file", []);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("root_gdb_tree_var", null);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("previous_register_values", {});
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("current_register_values", {});
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("inferior_pid", null);
        Actions.clear_program_state();
    },
    /**
     * Request relevant store information from gdb to refresh UI
     */
    refresh_state_for_gdb_pause: function () {
        _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].run_gdb_command(_GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"]._get_refresh_state_for_pause_cmds());
    },
    execute_console_command: function (command) {
        if (statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("refresh_state_after_sending_console_command")) {
            _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].run_command_and_refresh_state(command);
        }
        else {
            _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].run_gdb_command(command);
        }
    },
    onConsoleCommandRun: function () {
        if (statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("refresh_state_after_sending_console_command")) {
            _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].run_gdb_command(_GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"]._get_refresh_state_for_pause_cmds());
        }
    },
    clear_console: function () {
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("gdb_console_entries", []);
    },
    add_console_entries: function (entries, type) {
        if (type === _constants__WEBPACK_IMPORTED_MODULE_5__["default"].console_entry_type.STD_OUT) {
            // ignore
            return;
        }
        if (!Array.isArray(entries)) {
            entries = [entries];
        }
        var pty = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("gdbguiPty");
        if (pty) {
            entries.forEach(function (data) {
                var _a;
                var entriesToIgnore = [
                    // No registers. appears when refresh commands are run when program hasn't started.
                    // TODO The real fix for this is to not refresh commands when the program is not running.
                    "No registers."
                ];
                if (entriesToIgnore.indexOf(data) > -1) {
                    return;
                }
                // @ts-expect-error ts-migrate(2339) FIXME: Property 'colorTypeMap' does not exist on type 'Re... Remove this comment to see the full error message
                pty.write((_a = _constants__WEBPACK_IMPORTED_MODULE_5__["default"].colorTypeMap[type]) !== null && _a !== void 0 ? _a : _constants__WEBPACK_IMPORTED_MODULE_5__["default"].xtermColors["reset"]);
                pty.writeln(data);
                pty.write(_constants__WEBPACK_IMPORTED_MODULE_5__["default"].xtermColors["reset"]);
            });
        }
        else {
            console.error("Pty not available. New entries are:", entries);
        }
    },
    add_gdb_response_to_console: function (mi_obj) {
        var e_1, _a, e_2, _b;
        if (!mi_obj) {
            return;
        }
        // Update status
        var entries = [], error = false;
        if (mi_obj.message) {
            if (mi_obj.message === "error") {
                error = true;
            }
            else {
                entries.push(mi_obj.message);
            }
        }
        if (mi_obj.payload) {
            var interesting_keys = ["msg", "reason", "signal-name", "signal-meaning"];
            try {
                for (var interesting_keys_1 = __values(interesting_keys), interesting_keys_1_1 = interesting_keys_1.next(); !interesting_keys_1_1.done; interesting_keys_1_1 = interesting_keys_1.next()) {
                    var k = interesting_keys_1_1.value;
                    if (mi_obj.payload[k]) {
                        entries.push(mi_obj.payload[k]);
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (interesting_keys_1_1 && !interesting_keys_1_1.done && (_a = interesting_keys_1.return)) _a.call(interesting_keys_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            if (mi_obj.payload.frame) {
                try {
                    for (var _c = __values(["file", "func", "line", "addr"]), _d = _c.next(); !_d.done; _d = _c.next()) {
                        var i = _d.value;
                        if (i in mi_obj.payload.frame) {
                            entries.push(i + ": " + mi_obj.payload.frame[i]);
                        }
                    }
                }
                catch (e_2_1) { e_2 = { error: e_2_1 }; }
                finally {
                    try {
                        if (_d && !_d.done && (_b = _c.return)) _b.call(_c);
                    }
                    finally { if (e_2) throw e_2.error; }
                }
            }
        }
        var type = error
            ? _constants__WEBPACK_IMPORTED_MODULE_5__["default"].console_entry_type.STD_ERR
            : _constants__WEBPACK_IMPORTED_MODULE_5__["default"].console_entry_type.STD_OUT;
        Actions.add_console_entries(entries, type);
    },
    toggle_modal_visibility: function () {
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("show_modal", !statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("show_modal"));
    },
    show_modal: function (header, body) {
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("modal_header", header);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("modal_body", body);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("show_modal", true);
    },
    set_gdb_binary_and_arguments: function (binary, args) {
        // remove list of source files associated with the loaded binary since we're loading a new one
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("source_file_paths", []);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("language", "c_family");
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("inferior_binary_path", null);
        Actions.inferior_program_exited();
        var cmds = _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].get_load_binary_and_arguments_cmds(binary, args);
        _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].run_gdb_command(cmds);
        _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].get_inferior_binary_last_modified_unix_sec(binary);
    },
    connect_to_gdbserver: function (user_input) {
        // https://sourceware.org/gdb/onlinedocs/gdb/GDB_002fMI-Target-Manipulation.html#GDB_002fMI-Target-Manipulation
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("source_file_paths", []);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("language", "c_family");
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("inferior_binary_path", null);
        Actions.inferior_program_exited();
        _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].run_gdb_command(["-target-select remote " + user_input]);
    },
    remote_connected: function () {
        Actions.inferior_program_paused();
        var cmds = [];
        if (statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("auto_add_breakpoint_to_main")) {
            Actions.add_console_entries("Connected to remote target! Adding breakpoint to main, then continuing target execution.", _constants__WEBPACK_IMPORTED_MODULE_5__["default"].console_entry_type.GDBGUI_OUTPUT);
            cmds.push("-break-insert main");
            cmds.push("-exec-continue");
            cmds.push(_GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].get_break_list_cmd());
        }
        else {
            Actions.add_console_entries('Connected to remote target! Add breakpoint(s), then press "continue" button (do not press "run").', _constants__WEBPACK_IMPORTED_MODULE_5__["default"].console_entry_type.GDBGUI_OUTPUT);
        }
        _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].run_gdb_command(cmds);
    },
    attach_to_process: function (user_input) {
        // https://sourceware.org/gdb/onlinedocs/gdb/GDB_002fMI-Target-Manipulation.html#GDB_002fMI-Target-Manipulation
        _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].run_gdb_command("-target-attach " + user_input);
    },
    fetch_source_files: function () {
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("source_file_paths", []);
        _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].run_gdb_command("-file-list-exec-source-files");
    },
    view_file: function (fullname, line) {
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("fullname_to_render", fullname);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("source_code_infinite_scrolling", false);
        Actions.set_line_state(line);
    },
    set_line_state: function (line) {
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("source_code_infinite_scrolling", false);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("source_code_selection_state", _constants__WEBPACK_IMPORTED_MODULE_5__["default"].source_code_selection_states.USER_SELECTION);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("line_of_source_to_flash", parseInt(line));
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("make_current_line_visible", true);
    },
    clear_cached_assembly: function () {
        var e_3, _a;
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("disassembly_for_missing_file", []);
        var cached_source_files = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("cached_source_files");
        try {
            for (var cached_source_files_1 = __values(cached_source_files), cached_source_files_1_1 = cached_source_files_1.next(); !cached_source_files_1_1.done; cached_source_files_1_1 = cached_source_files_1.next()) {
                var file = cached_source_files_1_1.value;
                file.assembly = {};
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (cached_source_files_1_1 && !cached_source_files_1_1.done && (_a = cached_source_files_1.return)) _a.call(cached_source_files_1);
            }
            finally { if (e_3) throw e_3.error; }
        }
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("cached_source_files", cached_source_files);
    },
    update_max_lines_of_code_to_fetch: function (new_value) {
        if (new_value <= 0) {
            new_value = _constants__WEBPACK_IMPORTED_MODULE_5__["default"].default_max_lines_of_code_to_fetch;
        }
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("max_lines_of_code_to_fetch", new_value);
        localStorage.setItem("max_lines_of_code_to_fetch", JSON.stringify(new_value));
    },
    send_signal: function (signal_name, pid) {
        $.ajax({
            beforeSend: function (xhr) {
                xhr.setRequestHeader("x-csrftoken", 
                // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name 'initial_data'.
                initial_data.csrf_token); /* global initial_data */
            },
            url: "/send_signal_to_pid",
            cache: false,
            type: "POST",
            data: { signal_name: signal_name, pid: pid },
            success: function (response) {
                Actions.add_console_entries(response.message, _constants__WEBPACK_IMPORTED_MODULE_5__["default"].console_entry_type.GDBGUI_OUTPUT);
            },
            error: function (response) {
                if (response.responseJSON && response.responseJSON.message) {
                    Actions.add_console_entries(
                    // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
                    _.escape(response.responseJSON.message), _constants__WEBPACK_IMPORTED_MODULE_5__["default"].console_entry_type.STD_ERR);
                }
                else {
                    Actions.add_console_entries(response.statusText + " (" + response.status + " error)", _constants__WEBPACK_IMPORTED_MODULE_5__["default"].console_entry_type.STD_ERR);
                }
                console.error(response);
            },
            complete: function () { }
        });
    }
};
/* harmony default export */ __webpack_exports__["default"] = (Actions);


/***/ }),

/***/ "./gdbgui/src/js/BinaryLoader.tsx":
/*!****************************************!*\
  !*** ./gdbgui/src/js/BinaryLoader.tsx ***!
  \****************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./gdbgui/src/js/constants.ts");
/* harmony import */ var _Actions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Actions */ "./gdbgui/src/js/Actions.ts");
/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Util */ "./gdbgui/src/js/Util.ts");
/* harmony import */ var _ToolTipTourguide__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ToolTipTourguide */ "./gdbgui/src/js/ToolTipTourguide.tsx");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();





var TARGET_TYPES = {
    file: "file",
    server: "server",
    process: "process",
    target_download: "target_download"
};
/**
 * The BinaryLoader component allows the user to select their binary
 * and specify inputs
 */
var BinaryLoader = /** @class */ (function (_super) {
    __extends(BinaryLoader, _super);
    function BinaryLoader(props) {
        var _this = 
        // @ts-expect-error ts-migrate(2554) FIXME: Expected 1-2 arguments, but got 0.
        _super.call(this) || this;
        _this.state = {
            past_binaries: [],
            // @ts-expect-error ts-migrate(2339) FIXME: Property 'initial_user_input' does not exist on ty... Remove this comment to see the full error message
            user_input: props.initial_user_input.join(" "),
            // @ts-expect-error ts-migrate(2339) FIXME: Property 'initial_user_input' does not exist on ty... Remove this comment to see the full error message
            initial_set_target_app: props.initial_user_input.length,
            target_type: TARGET_TYPES.file
        };
        try {
            // @ts-expect-error ts-migrate(2542) FIXME: Index signature in type 'Readonly<any>' only permi... Remove this comment to see the full error message
            _this.state.past_binaries = _.uniq(
            // @ts-expect-error ts-migrate(2345) FIXME: Type 'null' is not assignable to type 'string'.
            JSON.parse(localStorage.getItem("past_binaries")));
            if (!_this.state.user_input) {
                var most_recent_binary = _this.state.past_binaries[0];
                // @ts-expect-error ts-migrate(2542) FIXME: Index signature in type 'Readonly<any>' only permi... Remove this comment to see the full error message
                _this.state.user_input = most_recent_binary;
            }
        }
        catch (err) {
            // @ts-expect-error ts-migrate(2542) FIXME: Index signature in type 'Readonly<any>' only permi... Remove this comment to see the full error message
            _this.state.past_binaries = [];
        }
        return _this;
    }
    BinaryLoader.prototype.render = function () {
        var _this = this;
        var button_text, title, placeholder;
        if (this.state.target_type === TARGET_TYPES.file) {
            button_text = "Load Binary";
            title =
                "Loads the binary and any arguments present in the input to the right. Backslashes are treated as escape characters. Windows users can either use two backslashes in paths, or forward slashes.";
            placeholder = "/path/to/target/executable -and -flags";
        }
        else if (this.state.target_type === TARGET_TYPES.server) {
            // https://sourceware.org/gdb/onlinedocs/gdb/GDB_002fMI-Target-Manipulation.html#GDB_002fMI-Target-Manipulation
            // -target-select
            button_text = "Connect to gdbserver";
            title = "Connect GDB to the remote target.";
            placeholder = "examples: 127.0.0.1:9999 | /dev/ttya";
        }
        else if (this.state.target_type === TARGET_TYPES.process) {
            // -target-attach
            button_text = "Attach to Process";
            title =
                "Attach to a process pid or a file file outside of GDB, or a thread group gid. If attaching to a thread group, the id previously returned by ‘-list-thread-groups --available’ must be used. Note: to do this, you usually need to run gdbgui as sudo.";
            placeholder = "pid | gid | file";
        }
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("form", { style: { marginBottom: 1, flex: "2 0 0" } },
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "input-group input-group-sm" },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "dropdown input-group-btn" },
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { className: "btn btn-primary dropdown-toggle", type: "button", "data-toggle": "dropdown" },
                        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "caret" })),
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("ul", { className: "dropdown-menu" },
                        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("li", null,
                            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", { className: "pointer", onClick: function () { return _this.setState({ target_type: TARGET_TYPES.file }); } }, "Load Binary")),
                        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("li", null,
                            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", { className: "pointer", onClick: function () { return _this.setState({ target_type: TARGET_TYPES.server }); } }, "Connect to gdbserver")),
                        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("li", null,
                            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", { className: "pointer", onClick: function () { return _this.setState({ target_type: TARGET_TYPES.process }); } }, "Attach to Process"))),
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { type: "button", title: title, onClick: this.click_set_target_app.bind(this), className: "btn btn-primary" }, button_text)),
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", { type: "text", placeholder: placeholder, list: "past_binaries", style: { fontFamily: "courier" }, className: "form-control", onKeyUp: this.onkeyup_user_input.bind(this), onChange: this.onchange_user_inpu.bind(this), value: this.state.user_input })),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_ToolTipTourguide__WEBPACK_IMPORTED_MODULE_4__["default"]
            // @ts-expect-error ts-migrate(2322) FIXME: Property 'step_num' does not exist on type 'Intrin... Remove this comment to see the full error message
            , { 
                // @ts-expect-error ts-migrate(2322) FIXME: Property 'step_num' does not exist on type 'Intrin... Remove this comment to see the full error message
                step_num: 1, position: "bottomcenter", content: react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("h5", null, "Enter the path to the binary you wish to debug here."),
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, "This is the first thing you should do."),
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, "The path can be absolute, or relative to where gdbgui was launched from.")) }),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_ToolTipTourguide__WEBPACK_IMPORTED_MODULE_4__["default"]
            // @ts-expect-error ts-migrate(2322) FIXME: Property 'step_num' does not exist on type 'Intrin... Remove this comment to see the full error message
            , { 
                // @ts-expect-error ts-migrate(2322) FIXME: Property 'step_num' does not exist on type 'Intrin... Remove this comment to see the full error message
                step_num: 2, position: "bottomleft", content: react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("h5", null, "Press this button to load the executable specified in the input."),
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, "This is the second thing you should do."),
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null,
                        "Debugging won't start, but you will be able to set breakpoints. If present,",
                        " ",
                        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", { href: "https://en.wikipedia.org/wiki/Debug_symbol" }, "debugging symbols"),
                        " ",
                        "in the binary are also loaded."),
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, "If you don't want to debug a binary, click the dropdown to choose a different target type.")) }),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("datalist", { id: "past_binaries" }, this.state.past_binaries.map(function (b, i) { return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("option", { key: i }, b)); }))));
    };
    BinaryLoader.prototype.componentDidMount = function () {
        if (this.state.initial_set_target_app) {
            this.setState({ initial_set_target_app: false });
            this.set_target_app();
        }
    };
    BinaryLoader.prototype.onkeyup_user_input = function (e) {
        if (e.keyCode === _constants__WEBPACK_IMPORTED_MODULE_1__["default"].ENTER_BUTTON_NUM) {
            this.set_target_app();
        }
    };
    BinaryLoader.prototype.onchange_user_inpu = function (e) {
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name 'initial_data'.
        if (initial_data.using_windows) {
            // replace backslashes with forward slashes when using windows
            this.setState({ user_input: e.target.value.replace(/\\/g, "/") });
        }
        else {
            this.setState({ user_input: e.target.value });
        }
    };
    BinaryLoader.prototype.click_set_target_app = function () {
        this.set_target_app();
    };
    // save to list of binaries used that autopopulates the input dropdown
    BinaryLoader.prototype._add_user_input_to_history = function (binary_and_args) {
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
        _.remove(this.state.past_binaries, function (i) { return i === binary_and_args; });
        this.state.past_binaries.unshift(binary_and_args); // add to beginning
        this.setState({ past_binaries: this.state.past_binaries });
        // @ts-expect-error ts-migrate(2345) FIXME: Type 'never[]' is not assignable to type 'string'.
        localStorage.setItem("past_binaries", JSON.stringify(this.state.past_binaries) || []);
        // @ts-expect-error ts-migrate(2345) FIXME: Type 'null' is not assignable to type 'string'.
        var num_gdbgui_sessions = parseInt(localStorage.getItem("num_gdbgui_sessions"));
        if (isNaN(num_gdbgui_sessions)) {
            num_gdbgui_sessions = 0;
        }
    };
    /**
     * parse tokens with awareness of double quotes
     *
     * @param      {string}  user_input raw input from user
     * @return     {Object}  { the binary (string) and arguments (array) parsed from user input }
     */
    BinaryLoader.prototype._parse_binary_and_args_from_user_input = function (user_input) {
        var list_of_params = _Util__WEBPACK_IMPORTED_MODULE_3__["default"].string_to_array_safe_quotes(user_input), binary = "", args = [], len = list_of_params.length;
        if (len === 1) {
            binary = list_of_params[0];
        }
        else if (len > 1) {
            binary = list_of_params[0];
            args = list_of_params.slice(1, len);
        }
        return { binary: binary, args: args.join(" ") };
    };
    BinaryLoader.prototype.set_target_app = function () {
        var user_input = this.state.user_input.trim();
        if (user_input === "") {
            _Actions__WEBPACK_IMPORTED_MODULE_2__["default"].add_console_entries("input cannot be empty", _constants__WEBPACK_IMPORTED_MODULE_1__["default"].console_entry_type.GDBGUI_OUTPUT);
            return;
        }
        this._add_user_input_to_history(user_input);
        if (this.state.target_type === TARGET_TYPES.file) {
            var _a = this._parse_binary_and_args_from_user_input(user_input), binary = _a.binary, args = _a.args;
            _Actions__WEBPACK_IMPORTED_MODULE_2__["default"].set_gdb_binary_and_arguments(binary, args);
        }
        else if (this.state.target_type === TARGET_TYPES.server) {
            _Actions__WEBPACK_IMPORTED_MODULE_2__["default"].connect_to_gdbserver(user_input);
        }
        else if (this.state.target_type === TARGET_TYPES.process) {
            _Actions__WEBPACK_IMPORTED_MODULE_2__["default"].attach_to_process(user_input);
        }
    };
    return BinaryLoader;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));
/* harmony default export */ __webpack_exports__["default"] = (BinaryLoader);


/***/ }),

/***/ "./gdbgui/src/js/Breakpoints.tsx":
/*!***************************************!*\
  !*** ./gdbgui/src/js/Breakpoints.tsx ***!
  \***************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _GdbApi__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./GdbApi */ "./gdbgui/src/js/GdbApi.tsx");
/* harmony import */ var _Actions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Actions */ "./gdbgui/src/js/Actions.ts");
/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Util */ "./gdbgui/src/js/Util.ts");
/* harmony import */ var _FileOps__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./FileOps */ "./gdbgui/src/js/FileOps.tsx");
/* harmony import */ var _Links__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Links */ "./gdbgui/src/js/Links.tsx");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./constants */ "./gdbgui/src/js/constants.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (undefined && undefined.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (undefined && undefined.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};








var BreakpointSourceLineCache = {
    _cache: {},
    get_line: function (fullname, linenum) {
        if (
        // @ts-expect-error ts-migrate(7053) FIXME: Property 'fullname' does not exist on type '{}'.
        BreakpointSourceLineCache._cache["fullname"] !== undefined &&
            // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
            _.isString(BreakpointSourceLineCache._cache["fullname"][linenum])) {
            // @ts-expect-error ts-migrate(7053) FIXME: Property 'fullname' does not exist on type '{}'.
            return BreakpointSourceLineCache._cache["fullname"][linenum];
        }
        return null;
    },
    add_line: function (fullname, linenum, escaped_text) {
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
        if (!_.isObject(BreakpointSourceLineCache._cache["fullname"])) {
            // @ts-expect-error ts-migrate(7053) FIXME: Property 'fullname' does not exist on type '{}'.
            BreakpointSourceLineCache._cache["fullname"] = {};
        }
        // @ts-expect-error ts-migrate(7053) FIXME: Property 'fullname' does not exist on type '{}'.
        BreakpointSourceLineCache._cache["fullname"][linenum] = escaped_text;
    }
};
var Breakpoint = /** @class */ (function (_super) {
    __extends(Breakpoint, _super);
    function Breakpoint(props) {
        var _this = _super.call(this, props) || this;
        _this.state = {
            breakpoint_condition: "",
            editing_breakpoint_condition: false
        };
        return _this;
    }
    Breakpoint.prototype.get_source_line = function (fullname, linenum) {
        // if we have the source file cached, we can display the line of text
        var MAX_CHARS_TO_SHOW_FROM_SOURCE = 40;
        var line = null;
        if (BreakpointSourceLineCache.get_line(fullname, linenum)) {
            line = BreakpointSourceLineCache.get_line(fullname, linenum);
            // @ts-expect-error ts-migrate(2554) FIXME: Expected 3 arguments, but got 2.
        }
        else if (_FileOps__WEBPACK_IMPORTED_MODULE_5__["default"].line_is_cached(fullname, linenum)) {
            var syntax_highlighted_line = _FileOps__WEBPACK_IMPORTED_MODULE_5__["default"].get_line_from_file(fullname, linenum);
            // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
            line = _.trim(_Util__WEBPACK_IMPORTED_MODULE_4__["default"].get_text_from_html(syntax_highlighted_line));
            if (line.length > MAX_CHARS_TO_SHOW_FROM_SOURCE) {
                line = line.slice(0, MAX_CHARS_TO_SHOW_FROM_SOURCE) + "...";
            }
            BreakpointSourceLineCache.add_line(fullname, linenum, line);
        }
        if (line) {
            return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "monospace", style: { whiteSpace: "nowrap", fontSize: "0.9em" } }, line || react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("br", null)));
        }
        return "(file not cached)";
    };
    Breakpoint.prototype.get_delete_jsx = function (bkpt_num_to_delete) {
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { style: { width: "10px", display: "inline" }, className: "pointer breakpoint_trashcan", onClick: function (e) {
                e.stopPropagation();
                Breakpoints.delete_breakpoint(bkpt_num_to_delete);
            }, title: "Delete breakpoint " + bkpt_num_to_delete },
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "glyphicon glyphicon-trash" }, " ")));
    };
    Breakpoint.prototype.get_num_times_hit = function (bkpt) {
        if (bkpt.times === undefined || // E.g. 'bkpt' is a child breakpoint
            bkpt.times == 0) {
            return "";
        }
        else if (bkpt.times == 1) {
            return "1 hit";
        }
        else {
            return bkpt.times + " hits";
        }
    };
    Breakpoint.prototype.on_change_bkpt_cond = function (e) {
        this.setState({
            breakpoint_condition: e.target.value,
            editing_breakpoint_condition: true
        });
    };
    Breakpoint.prototype.on_key_up_bktp_cond = function (number, e) {
        if (e.keyCode === _constants__WEBPACK_IMPORTED_MODULE_7__["default"].ENTER_BUTTON_NUM) {
            this.setState({ editing_breakpoint_condition: false });
            Breakpoints.set_breakpoint_condition(e.target.value, number);
        }
    };
    Breakpoint.prototype.on_break_cond_click = function (e) {
        this.setState({
            editing_breakpoint_condition: true
        });
    };
    Breakpoint.prototype.render = function () {
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'bkpt' does not exist on type 'Readonly<{... Remove this comment to see the full error message
        var b = this.props.bkpt, checked = b.enabled === "y" ? "checked" : "", source_line = this.get_source_line(b.fullname_to_display, b.line);
        var info_glyph, function_jsx, bkpt_num_to_delete;
        if (b.is_child_breakpoint) {
            bkpt_num_to_delete = b.parent_breakpoint_number;
            info_glyph = (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "glyphicon glyphicon-th-list", title: "Child breakpoint automatically created from parent. If parent or any child of this tree is deleted, all related breakpoints will be deleted." }));
        }
        else if (b.is_parent_breakpoint) {
            info_glyph = (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "glyphicon glyphicon-th-list", title: "Parent breakpoint with one or more child breakpoints. If parent or any child of this tree is deleted, all related breakpoints will be deleted." }));
            bkpt_num_to_delete = b.number;
        }
        else {
            bkpt_num_to_delete = b.number;
            info_glyph = "";
        }
        var delete_jsx = this.get_delete_jsx(bkpt_num_to_delete);
        var location_jsx = (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_Links__WEBPACK_IMPORTED_MODULE_6__["FileLink"], { fullname: b.fullname_to_display, file: b.fullname_to_display, line: b.line }));
        if (b.is_parent_breakpoint) {
            function_jsx = (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "placeholder" },
                info_glyph,
                " parent breakpoint on inline, template, or ambiguous location"));
        }
        else {
            var func = b.func === undefined ? "(unknown function)" : b.func;
            var break_condition = (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { onClick: this.on_break_cond_click.bind(this), className: "inline", title: (this.state.breakpoint_condition ? "Modify or remove" : "Add") + " breakpoint condition" },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "glyphicon glyphicon-edit" }),
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "italic " + (this.state.breakpoint_condition ? "bold" : "") }, "condition")));
            if (this.state.editing_breakpoint_condition) {
                break_condition = (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", { type: "text", style: {
                        display: "inline",
                        width: "110px",
                        padding: "10px 10px",
                        height: "25px",
                        fontSize: "1em"
                    }, placeholder: "Break condition", className: "form-control", onKeyUp: this.on_key_up_bktp_cond.bind(this, b.number), onChange: this.on_change_bkpt_cond.bind(this), value: this.state.breakpoint_condition }));
            }
            var times_hit = this.get_num_times_hit(b);
            function_jsx = (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { style: { display: "inline" } },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "monospace", style: { paddingRight: "5px" } },
                    info_glyph,
                    " ",
                    func),
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { style: {
                        color: "#bbbbbb",
                        fontStyle: "italic",
                        paddingRight: "5px"
                    } },
                    "thread groups: ",
                    b["thread-groups"]),
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", null, break_condition),
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { style: {
                        color: "#bbbbbb",
                        fontStyle: "italic",
                        paddingLeft: "5px"
                    } }, times_hit)));
        }
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "breakpoint", onClick: function () { return _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].view_file(b.fullname_to_display, b.line); } },
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("table", { style: {
                    width: "100%",
                    fontSize: "0.9em",
                    borderWidth: "0px"
                }, className: "lighttext table-condensed" },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("tbody", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("tr", null,
                        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("td", null,
                            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", { type: "checkbox", 
                                // @ts-expect-error ts-migrate(2322) FIXME: Type 'string' is not assignable to type 'boolean |... Remove this comment to see the full error message
                                checked: checked, onChange: function () { return Breakpoints.enable_or_disable_bkpt(checked, b.number); } }),
                            function_jsx,
                            " ",
                            delete_jsx)),
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("tr", null,
                        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("td", null, location_jsx)),
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("tr", null,
                        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("td", null, source_line))))));
    }; // render function
    return Breakpoint;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));
var Breakpoints = /** @class */ (function (_super) {
    __extends(Breakpoints, _super);
    function Breakpoints() {
        var _this = 
        // @ts-expect-error ts-migrate(2554) FIXME: Expected 1-2 arguments, but got 0.
        _super.call(this) || this;
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'connectComponentState' does not exist on... Remove this comment to see the full error message
        statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].connectComponentState(_this, ["breakpoints"]);
        return _this;
    }
    Breakpoints.prototype.render = function () {
        var e_1, _a;
        var breakpoints_jsx = [];
        try {
            for (var _b = __values(statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("breakpoints")), _c = _b.next(); !_c.done; _c = _b.next()) {
                var b = _c.value;
                // @ts-expect-error ts-migrate(2322) FIXME: Property 'bkpt' does not exist on type 'IntrinsicA... Remove this comment to see the full error message
                breakpoints_jsx.push(react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(Breakpoint, { bkpt: b, key: b.number }));
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        if (breakpoints_jsx.length) {
            return breakpoints_jsx;
        }
        else {
            return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "placeholder" }, "no breakpoints");
        }
    };
    Breakpoints.enable_or_disable_bkpt = function (checked, bkpt_num) {
        if (checked) {
            _GdbApi__WEBPACK_IMPORTED_MODULE_2__["default"].run_gdb_command(["-break-disable " + bkpt_num, _GdbApi__WEBPACK_IMPORTED_MODULE_2__["default"].get_break_list_cmd()]);
        }
        else {
            _GdbApi__WEBPACK_IMPORTED_MODULE_2__["default"].run_gdb_command(["-break-enable " + bkpt_num, _GdbApi__WEBPACK_IMPORTED_MODULE_2__["default"].get_break_list_cmd()]);
        }
    };
    Breakpoints.set_breakpoint_condition = function (condition, bkpt_num) {
        _GdbApi__WEBPACK_IMPORTED_MODULE_2__["default"].run_gdb_command([
            "-break-condition " + bkpt_num + " " + condition,
            _GdbApi__WEBPACK_IMPORTED_MODULE_2__["default"].get_break_list_cmd()
        ]);
    };
    Breakpoints.remove_breakpoint_if_present = function (fullname, line) {
        if (Breakpoints.has_breakpoint(fullname, line)) {
            var number = Breakpoints.get_breakpoint_number(fullname, line);
            var cmd = [_GdbApi__WEBPACK_IMPORTED_MODULE_2__["default"].get_delete_break_cmd(number), _GdbApi__WEBPACK_IMPORTED_MODULE_2__["default"].get_break_list_cmd()];
            _GdbApi__WEBPACK_IMPORTED_MODULE_2__["default"].run_gdb_command(cmd);
        }
    };
    Breakpoints.add_or_remove_breakpoint = function (fullname, line) {
        if (Breakpoints.has_breakpoint(fullname, line)) {
            Breakpoints.remove_breakpoint_if_present(fullname, line);
        }
        else {
            Breakpoints.add_breakpoint(fullname, line);
        }
    };
    Breakpoints.add_breakpoint = function (fullname, line) {
        _GdbApi__WEBPACK_IMPORTED_MODULE_2__["default"].run_gdb_command(_GdbApi__WEBPACK_IMPORTED_MODULE_2__["default"].get_insert_break_cmd(fullname, line));
    };
    Breakpoints.has_breakpoint = function (fullname, line) {
        var e_2, _a;
        var bkpts = statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("breakpoints");
        try {
            for (var bkpts_1 = __values(bkpts), bkpts_1_1 = bkpts_1.next(); !bkpts_1_1.done; bkpts_1_1 = bkpts_1.next()) {
                var b = bkpts_1_1.value;
                if (b.fullname === fullname && b.line == line) {
                    return true;
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (bkpts_1_1 && !bkpts_1_1.done && (_a = bkpts_1.return)) _a.call(bkpts_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return false;
    };
    Breakpoints.get_breakpoint_number = function (fullname, line) {
        var e_3, _a;
        var bkpts = statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("breakpoints");
        try {
            for (var bkpts_2 = __values(bkpts), bkpts_2_1 = bkpts_2.next(); !bkpts_2_1.done; bkpts_2_1 = bkpts_2.next()) {
                var b = bkpts_2_1.value;
                if (b.fullname === fullname && b.line == line) {
                    return b.number;
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (bkpts_2_1 && !bkpts_2_1.done && (_a = bkpts_2.return)) _a.call(bkpts_2);
            }
            finally { if (e_3) throw e_3.error; }
        }
        console.error("could not find breakpoint for " + fullname + ":" + line);
    };
    Breakpoints.delete_breakpoint = function (breakpoint_number) {
        _GdbApi__WEBPACK_IMPORTED_MODULE_2__["default"].run_gdb_command([
            _GdbApi__WEBPACK_IMPORTED_MODULE_2__["default"].get_delete_break_cmd(breakpoint_number),
            _GdbApi__WEBPACK_IMPORTED_MODULE_2__["default"].get_break_list_cmd()
        ]);
    };
    Breakpoints.get_breakpoint_lines_for_file = function (fullname) {
        return statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"]
            .get("breakpoints")
            .filter(function (b) { return b.fullname_to_display === fullname && b.enabled === "y"; })
            .map(function (b) { return parseInt(b.line); });
    };
    Breakpoints.get_disabled_breakpoint_lines_for_file = function (fullname) {
        return statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"]
            .get("breakpoints")
            .filter(function (b) { return b.fullname_to_display === fullname && b.enabled !== "y"; })
            .map(function (b) { return parseInt(b.line); });
    };
    Breakpoints.get_conditional_breakpoint_lines_for_file = function (fullname) {
        return statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"]
            .get("breakpoints")
            .filter(function (b) { return b.fullname_to_display === fullname && b.cond !== undefined; })
            .map(function (b) { return parseInt(b.line); });
    };
    Breakpoints.save_breakpoints = function (payload) {
        var e_4, _a;
        statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("breakpoints", []);
        if (payload && payload.BreakpointTable && payload.BreakpointTable.body) {
            try {
                for (var _b = __values(payload.BreakpointTable.body), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var breakpoint = _c.value;
                    Breakpoints.save_breakpoint(breakpoint);
                }
            }
            catch (e_4_1) { e_4 = { error: e_4_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_4) throw e_4.error; }
            }
        }
    };
    Breakpoints.save_breakpoint = function (breakpoint) {
        var _a;
        var bkpt = Object.assign({}, breakpoint);
        bkpt.is_parent_breakpoint = bkpt.addr === "(MULTIPLE)";
        // parent breakpoints have numbers like "5.6", whereas normal breakpoints and parent breakpoints have numbers like "5"
        bkpt.is_child_breakpoint = parseInt(bkpt.number) !== parseFloat(bkpt.number);
        bkpt.is_normal_breakpoint = !bkpt.is_parent_breakpoint && !bkpt.is_child_breakpoint;
        if (bkpt.is_child_breakpoint) {
            bkpt.parent_breakpoint_number = parseInt(bkpt.number);
        }
        if ("fullname" in breakpoint && breakpoint.fullname) {
            // this is a normal/child breakpoint; gdb gives it the fullname
            bkpt.fullname_to_display = breakpoint.fullname;
        }
        else if ("original-location" in breakpoint && breakpoint["original-location"]) {
            // this breakpoint is the parent breakpoint of multiple other breakpoints. gdb does not give it
            // the fullname field, but rather the "original-location" field.
            // example breakpoint['original-location']: /home/file.h:19
            // so we need to parse out the line number, and store it
            _a = __read(_Util__WEBPACK_IMPORTED_MODULE_4__["default"].parse_fullname_and_line(breakpoint["original-location"]), 2), bkpt.fullname_to_display = _a[0], bkpt.line = _a[1];
        }
        else {
            bkpt.fullname_to_display = null;
        }
        // add the breakpoint if it's not stored already
        var bkpts = statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("breakpoints");
        if (bkpts.indexOf(bkpt) === -1) {
            bkpts.push(bkpt);
            statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("breakpoints", bkpts);
        }
        return bkpt;
    };
    return Breakpoints;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));
/* harmony default export */ __webpack_exports__["default"] = (Breakpoints);


/***/ }),

/***/ "./gdbgui/src/js/ControlButtons.tsx":
/*!******************************************!*\
  !*** ./gdbgui/src/js/ControlButtons.tsx ***!
  \******************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Actions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Actions */ "./gdbgui/src/js/Actions.ts");
/* harmony import */ var _GdbApi__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./GdbApi */ "./gdbgui/src/js/GdbApi.tsx");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_3__);
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();




var ControlButtons = /** @class */ (function (_super) {
    __extends(ControlButtons, _super);
    function ControlButtons() {
        var _this = 
        // @ts-expect-error ts-migrate(2554) FIXME: Expected 1-2 arguments, but got 0.
        _super.call(this) || this;
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'connectComponentState' does not exist on... Remove this comment to see the full error message
        statorgfc__WEBPACK_IMPORTED_MODULE_3__["store"].connectComponentState(_this, ["gdb_pid", "reverse_supported"]);
        return _this;
    }
    ControlButtons.prototype.render = function () {
        var _this = this;
        var btn_class = "btn btn-default btn-sm";
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { id: "run_button", onClick: function () { return _GdbApi__WEBPACK_IMPORTED_MODULE_2__["default"].click_run_button(); }, type: "button", title: "Start inferior program from the beginning keyboard shortcut: r", className: btn_class },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "glyphicon glyphicon-repeat" })),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { id: "continue_button", onClick: function () { return _GdbApi__WEBPACK_IMPORTED_MODULE_2__["default"].click_continue_button(); }, type: "button", title: "Continue until breakpoint is hit or inferior program exits keyboard shortcut: c" +
                    (this.state.reverse_supported ? ". shift + c for reverse." : ""), className: btn_class },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "glyphicon glyphicon-play" })),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { onClick: function () { return _Actions__WEBPACK_IMPORTED_MODULE_1__["default"].send_signal("SIGINT", _this.state.gdb_pid); }, type: "button", title: "Send Interrupt signal (SIGINT) to gdb process to pause it (if it's running)", className: btn_class },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "glyphicon glyphicon-pause" })),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { id: "next_button", onClick: function () { return _GdbApi__WEBPACK_IMPORTED_MODULE_2__["default"].click_next_button(); }, type: "button", title: "Step over next function call keyboard shortcut: n or right arrow" +
                    (this.state.reverse_supported ? ". shift + n for reverse." : ""), className: btn_class },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "glyphicon glyphicon-step-forward" })),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { id: "step_button", onClick: function () { return _GdbApi__WEBPACK_IMPORTED_MODULE_2__["default"].click_step_button(); }, type: "button", title: "Step into next function call keyboard shortcut: s or down arrow" +
                    (this.state.reverse_supported ? ". shift + s for reverse." : ""), className: btn_class },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "glyphicon glyphicon-arrow-down" })),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { id: "return_button", onClick: function () { return _GdbApi__WEBPACK_IMPORTED_MODULE_2__["default"].click_return_button(); }, type: "button", title: "Step out of current function keyboard shortcut: u or up arrow", className: btn_class },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "glyphicon glyphicon-arrow-up" })),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { role: "group", className: "btn-group btn-group-xs" },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { id: "next_instruction_button", onClick: function () { return _GdbApi__WEBPACK_IMPORTED_MODULE_2__["default"].click_next_instruction_button(); }, type: "button", title: "Next Instruction: Execute one machine instruction, stepping over function calls keyboard shortcut: m" +
                        (this.state.reverse_supported ? ". shift + m for reverse." : ""), className: "btn btn-default" }, "NI"),
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { id: "step_instruction_button", onClick: function () { return _GdbApi__WEBPACK_IMPORTED_MODULE_2__["default"].click_step_instruction_button(); }, type: "button", title: "Step Instruction: Execute one machine instruction, stepping into function calls keyboard shortcut: ','" +
                        (this.state.reverse_supported ? ". shift + , for reverse." : ""), className: "btn btn-default" }, "SI"))));
    };
    return ControlButtons;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));
/* harmony default export */ __webpack_exports__["default"] = (ControlButtons);


/***/ }),

/***/ "./gdbgui/src/js/CopyToClipboard.tsx":
/*!*******************************************!*\
  !*** ./gdbgui/src/js/CopyToClipboard.tsx ***!
  \*******************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ToolTip__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ToolTip */ "./gdbgui/src/js/ToolTip.tsx");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_2__);
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



var CopyToClipboard = /** @class */ (function (_super) {
    __extends(CopyToClipboard, _super);
    function CopyToClipboard() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.node = null;
        return _this;
    }
    CopyToClipboard.prototype.render = function () {
        var _this = this;
        if (!this.props.content) {
            return null;
        }
        return (react__WEBPACK_IMPORTED_MODULE_0__["createElement"]("span", { className: "pointer glyphicon glyphicon-book", style: { color: "#ccc", display: "inline" }, ref: function (node) { return (_this.node = node); }, onMouseOver: function () {
                _ToolTip__WEBPACK_IMPORTED_MODULE_1__["default"].show_tooltip_on_node("copy to clipboard", _this.node);
            }, onMouseLeave: _ToolTip__WEBPACK_IMPORTED_MODULE_1__["default"].hide_tooltip, onClick: function () {
                try {
                    var textarea = statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].get("textarea_to_copy_to_clipboard");
                    textarea.value = _this.props.content;
                    textarea.select();
                    if (document.execCommand("copy") === true) {
                        _ToolTip__WEBPACK_IMPORTED_MODULE_1__["default"].show_copied_tooltip_on_node(_this.node);
                    }
                    else {
                        _ToolTip__WEBPACK_IMPORTED_MODULE_1__["default"].show_tooltip_on_node("unable to copy", _this.node);
                    }
                }
                catch (err) {
                    _ToolTip__WEBPACK_IMPORTED_MODULE_1__["default"].show_tooltip_on_node("unable to copy", _this.node);
                }
            } }));
    };
    return CopyToClipboard;
}(react__WEBPACK_IMPORTED_MODULE_0__["Component"]));
/* harmony default export */ __webpack_exports__["default"] = (CopyToClipboard);


/***/ }),

/***/ "./gdbgui/src/js/Expressions.tsx":
/*!***************************************!*\
  !*** ./gdbgui/src/js/Expressions.tsx ***!
  \***************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _GdbVariable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./GdbVariable */ "./gdbgui/src/js/GdbVariable.tsx");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./gdbgui/src/js/constants.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (undefined && undefined.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};




var Expressions = /** @class */ (function (_super) {
    __extends(Expressions, _super);
    function Expressions() {
        var _this = 
        // @ts-expect-error ts-migrate(2554) FIXME: Expected 1-2 arguments, but got 0.
        _super.call(this) || this;
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'connectComponentState' does not exist on... Remove this comment to see the full error message
        statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].connectComponentState(_this, ["expressions"]);
        return _this;
    }
    Expressions.prototype.render = function () {
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
        var sorted_expression_objs = _.sortBy(statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("expressions"), function (unsorted_obj) { return unsorted_obj.expression; });
        // only render variables in scope that were not created for the Locals component
        this.objs_to_render = sorted_expression_objs.filter(function (obj) { return obj.in_scope === "true" && obj.expr_type === "expr"; });
        this.objs_to_delete = sorted_expression_objs.filter(function (obj) { return obj.in_scope === "invalid"; });
        // delete invalid objects
        this.objs_to_delete.map(function (obj) { return _GdbVariable__WEBPACK_IMPORTED_MODULE_2__["default"].delete_gdb_variable(obj.name); });
        var content = this.objs_to_render.map(function (obj) { return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_GdbVariable__WEBPACK_IMPORTED_MODULE_2__["default"]
        // @ts-expect-error ts-migrate(2769) FIXME: Property 'obj' does not exist on type 'IntrinsicAt... Remove this comment to see the full error message
        , { 
            // @ts-expect-error ts-migrate(2769) FIXME: Property 'obj' does not exist on type 'IntrinsicAt... Remove this comment to see the full error message
            obj: obj, key: obj.expression, expression: obj.expression, expr_type: "expr" })); });
        if (content.length === 0) {
            content.push(react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { key: "empty", className: "placeholder" }, "no expressions in this context"));
        }
        content.push(react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { key: "tt", id: "plot_coordinate_tooltip", style: { display: "hidden" } }));
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", null,
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", { id: "expressions_input", className: "form-control", placeholder: "expression or variable", style: {
                    display: "inline",
                    padding: "6px 6px",
                    height: "25px",
                    fontSize: "1em",
                    marginTop: "5px"
                }, onKeyUp: Expressions.keydown_on_input }),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null),
            content));
    };
    Expressions.prototype.componentDidUpdate = function () {
        var e_1, _a;
        try {
            for (var _b = __values(this.objs_to_render), _c = _b.next(); !_c.done; _c = _b.next()) {
                var obj = _c.value;
                _GdbVariable__WEBPACK_IMPORTED_MODULE_2__["default"].plot_var_and_children(obj);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    Expressions.keydown_on_input = function (e) {
        if (e.keyCode === _constants__WEBPACK_IMPORTED_MODULE_3__["default"].ENTER_BUTTON_NUM) {
            var expr = e.currentTarget.value, 
            // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
            trimmed_expr = _.trim(expr);
            if (trimmed_expr !== "") {
                _GdbVariable__WEBPACK_IMPORTED_MODULE_2__["default"].create_variable(trimmed_expr, "expr");
            }
        }
    };
    return Expressions;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));
/* harmony default export */ __webpack_exports__["default"] = (Expressions);


/***/ }),

/***/ "./gdbgui/src/js/FileOps.tsx":
/*!***********************************!*\
  !*** ./gdbgui/src/js/FileOps.tsx ***!
  \***********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _GdbApi__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./GdbApi */ "./gdbgui/src/js/GdbApi.tsx");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./gdbgui/src/js/constants.ts");
/* harmony import */ var _Actions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Actions */ "./gdbgui/src/js/Actions.ts");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
var __values = (undefined && undefined.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};




 // needed for jsx
void react__WEBPACK_IMPORTED_MODULE_4___default.a;
var debug_print;
// @ts-expect-error ts-migrate(2304) FIXME: Cannot find name 'debug'.
if (debug) {
    /* global debug */
    debug_print = console.info;
}
else {
    debug_print = function () {
        // stubbed out
    };
}
var FileFetcher = {
    _is_fetching: false,
    _queue: [],
    _fetch: function (fullname, start_line, end_line) {
        if (FileOps.is_missing_file(fullname)) {
            // file doesn't exist and we already know about it
            // don't keep trying to fetch disassembly
            console.warn("tried to fetch a file known to be missing " + fullname);
            FileFetcher._is_fetching = false;
            FileFetcher._fetch_next();
            return;
        }
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
        if (!_.isString(fullname)) {
            console.warn("trying to fetch filename that is not a string", fullname);
            FileOps.add_missing_file(fullname);
            FileFetcher._is_fetching = false;
            FileFetcher._fetch_next();
        }
        FileFetcher._is_fetching = true;
        var data = {
            start_line: start_line,
            end_line: end_line,
            path: fullname,
            highlight: statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("highlight_source_code")
        };
        $.ajax({
            beforeSend: function (xhr) {
                xhr.setRequestHeader("x-csrftoken", 
                // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name 'initial_data'.
                initial_data.csrf_token); /* global initial_data */
            },
            url: "/read_file",
            cache: false,
            type: "GET",
            data: data,
            success: function (response) {
                var e_1, _a;
                response.source_code;
                var source_code_obj = {};
                var linenum = response.start_line;
                try {
                    for (var _b = __values(response.source_code_array), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var line = _c.value;
                        // @ts-expect-error ts-migrate(7053) FIXME: Element implicitly has an 'any' type because expre... Remove this comment to see the full error message
                        source_code_obj[linenum] = line;
                        linenum++;
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
                FileOps.add_source_file_to_cache(fullname, source_code_obj, response.last_modified_unix_sec, response.num_lines_in_file);
            },
            error: function (response) {
                if (response.responseJSON && response.responseJSON.message) {
                    _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].add_console_entries(
                    // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
                    _.escape(response.responseJSON.message), _constants__WEBPACK_IMPORTED_MODULE_2__["default"].console_entry_type.STD_ERR);
                }
                else {
                    _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].add_console_entries(response.statusText + " (" + response.status + " error)", _constants__WEBPACK_IMPORTED_MODULE_2__["default"].console_entry_type.STD_ERR);
                }
                FileOps.add_missing_file(fullname);
            },
            complete: function () {
                FileFetcher._is_fetching = false;
                // @ts-expect-error ts-migrate(2339) FIXME: Property 'fullname' does not exist on type 'never'... Remove this comment to see the full error message
                FileFetcher._queue = FileFetcher._queue.filter(function (o) { return o.fullname !== fullname; });
                FileFetcher._fetch_next();
            }
        });
    },
    _fetch_next: function () {
        if (FileFetcher._is_fetching) {
            return;
        }
        if (FileFetcher._queue.length) {
            var obj = FileFetcher._queue.shift();
            // @ts-expect-error ts-migrate(2532) FIXME: Object is possibly 'undefined'.
            FileFetcher._fetch(obj.fullname, obj.start_line, obj.end_line);
        }
    },
    fetch_complete: function () {
        FileFetcher._is_fetching = false;
        FileFetcher._fetch_next();
    },
    fetch: function (fullname, start_line, end_line) {
        if (!start_line) {
            start_line = 1;
            console.warn("expected start line");
        }
        if (!end_line) {
            end_line = start_line;
            console.warn("expected end line");
        }
        if (FileOps.lines_are_cached(fullname, start_line, end_line)) {
            debug_print("not fetching " + fullname + ":" + start_line + ":" + end_line + " because it's cached");
            return;
        }
        // @ts-expect-error ts-migrate(2322) FIXME: Type 'any' is not assignable to type 'never'.
        FileFetcher._queue.push({ fullname: fullname, start_line: start_line, end_line: end_line });
        FileFetcher._fetch_next();
    }
};
var FileOps = {
    warning_shown_for_old_binary: false,
    unfetchable_disassembly_addresses: {},
    disassembly_addr_being_fetched: null,
    init: function () {
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'subscribeToKeys' does not exist on type ... Remove this comment to see the full error message
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].subscribeToKeys([
            "inferior_program",
            "source_code_selection_state",
            "paused_on_frame",
            "current_assembly_address",
            "disassembly_for_missing_file",
            "highlight_source_code",
            "missing_files",
            "files_being_fetched",
            "gdb_version_array",
            "fullname_to_render",
            "line_of_source_to_flash",
            "cached_source_files",
            "max_lines_of_code_to_fetch"
        ], FileOps._store_change_callback);
    },
    user_select_file_to_view: function (fullname, line) {
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("source_code_selection_state", _constants__WEBPACK_IMPORTED_MODULE_2__["default"].source_code_selection_states.USER_SELECTION);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("fullname_to_render", fullname);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("line_of_source_to_flash", line);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("make_current_line_visible", true);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("source_code_infinite_scrolling", false);
    },
    _store_change_callback: function () {
        var _a;
        if (statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("inferior_program") === _constants__WEBPACK_IMPORTED_MODULE_2__["default"].inferior_states.running) {
            return;
        }
        var source_code_selection_state = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("source_code_selection_state"), fullname = null, is_paused = false, paused_addr = null, paused_frame_fullname = null, paused_frame = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("paused_on_frame");
        if (paused_frame) {
            paused_frame_fullname = paused_frame.fullname;
        }
        var require_cached_line_num;
        if (source_code_selection_state ===
            _constants__WEBPACK_IMPORTED_MODULE_2__["default"].source_code_selection_states.USER_SELECTION) {
            fullname = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("fullname_to_render");
            is_paused = false;
            paused_addr = null;
            require_cached_line_num = parseInt(statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("line_of_source_to_flash"));
        }
        else if (source_code_selection_state === _constants__WEBPACK_IMPORTED_MODULE_2__["default"].source_code_selection_states.PAUSED_FRAME) {
            is_paused = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("inferior_program") === _constants__WEBPACK_IMPORTED_MODULE_2__["default"].inferior_states.paused;
            paused_addr = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("current_assembly_address");
            fullname = paused_frame_fullname;
            require_cached_line_num = parseInt(statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("line_of_source_to_flash"));
        }
        var source_code_infinite_scrolling = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("source_code_infinite_scrolling"), assembly_is_cached = FileOps.assembly_is_cached(fullname), file_is_missing = FileOps.is_missing_file(fullname), start_line, end_line;
        (_a = FileOps.get_start_and_end_lines(fullname, require_cached_line_num, source_code_infinite_scrolling), start_line = _a.start_line, end_line = _a.end_line, require_cached_line_num = _a.require_cached_line_num);
        FileOps.update_source_code_state(fullname, start_line, require_cached_line_num, end_line, assembly_is_cached, file_is_missing, is_paused, paused_addr);
    },
    get_start_and_end_lines: function (fullname, require_cached_line_num, source_code_infinite_scrolling) {
        var start_line, end_line;
        if (source_code_infinite_scrolling) {
            start_line = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("source_linenum_to_display_start");
            end_line = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("source_linenum_to_display_end");
            require_cached_line_num = start_line;
        }
        else {
            var source_file_obj = FileOps.get_source_file_obj_from_cache(fullname);
            if (!require_cached_line_num) {
                require_cached_line_num = 1;
            }
            start_line = Math.max(Math.floor(require_cached_line_num - statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("max_lines_of_code_to_fetch") / 2), 1);
            end_line = Math.ceil(start_line + statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("max_lines_of_code_to_fetch"));
            if (source_file_obj) {
                // @ts-expect-error ts-migrate(2554) FIXME: Expected 2 arguments, but got 1.
                end_line = Math.ceil(Math.min(end_line, FileOps.get_num_lines_in_file(fullname))); // don't go past the end of the line
            }
            if (start_line > end_line) {
                start_line = Math.floor(Math.max(1, end_line - statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("max_lines_of_code_to_fetch")));
            }
            require_cached_line_num = Math.min(require_cached_line_num, end_line);
        }
        return { start_line: start_line, end_line: end_line, require_cached_line_num: require_cached_line_num };
    },
    update_source_code_state: function (fullname, start_line, require_cached_line_num, end_line, assembly_is_cached, file_is_missing, is_paused, paused_addr) {
        var states = _constants__WEBPACK_IMPORTED_MODULE_2__["default"].source_code_states, 
        // @ts-expect-error ts-migrate(2554) FIXME: Expected 3 arguments, but got 2.
        line_is_cached = FileOps.line_is_cached(fullname, require_cached_line_num);
        if (fullname && line_is_cached) {
            // we have file cached. We may have assembly cached too.
            statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("source_code_state", assembly_is_cached ? states.ASSM_AND_SOURCE_CACHED : states.SOURCE_CACHED);
            statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("source_linenum_to_display_start", start_line);
            // @ts-expect-error ts-migrate(2554) FIXME: Expected 2 arguments, but got 1.
            end_line = Math.min(end_line, FileOps.get_num_lines_in_file(fullname));
            statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("source_linenum_to_display_end", end_line);
        }
        else if (fullname && !file_is_missing) {
            // we don't have file cached, and it is not known to be missing on the file system, so try to get it
            statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("source_code_state", states.FETCHING_SOURCE);
            FileFetcher.fetch(fullname, start_line, end_line);
        }
        else if (is_paused &&
            paused_addr &&
            statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"]
                .get("disassembly_for_missing_file")
                .some(function (obj) { return parseInt(obj.address, 16) === parseInt(paused_addr, 16); })) {
            statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("source_code_state", states.ASSM_CACHED);
        }
        else if (is_paused && paused_addr) {
            if (paused_addr in FileOps.unfetchable_disassembly_addresses) {
                statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("source_code_state", states.ASSM_UNAVAILABLE);
            }
            else {
                // get disassembly
                statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("source_code_state", states.FETCHING_ASSM);
                FileOps.fetch_disassembly_for_missing_file(paused_addr);
            }
        }
        else if (file_is_missing) {
            statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("source_code_state", states.FILE_MISSING);
        }
        else {
            statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("source_code_state", states.NONE_AVAILABLE);
        }
    },
    get_num_lines_in_file: function (fullname, source_file_obj) {
        if (!source_file_obj) {
            source_file_obj = FileOps.get_source_file_obj_from_cache(fullname);
        }
        if (!source_file_obj) {
            console.error("Developer error: expected to find file object for " + fullname);
            return;
        }
        if (!source_file_obj.num_lines_in_file) {
            console.error('Developer error: expected key "num_lines_in_file"');
            return Infinity;
        }
        return source_file_obj.num_lines_in_file;
    },
    lines_are_cached: function (fullname, start_line, end_line) {
        var source_file_obj = FileOps.get_source_file_obj_from_cache(fullname), linenum = start_line;
        if (!source_file_obj) {
            return false;
        }
        var num_lines_in_file = FileOps.get_num_lines_in_file(fullname, source_file_obj);
        if (start_line > num_lines_in_file) {
            return false;
        }
        var safe_end_line = Math.min(end_line, num_lines_in_file);
        while (linenum <= safe_end_line) {
            if (!FileOps.line_is_cached(fullname, linenum, source_file_obj)) {
                return false;
            }
            linenum++;
        }
        return true;
    },
    line_is_cached: function (fullname, linenum, source_file_obj) {
        if (!source_file_obj) {
            source_file_obj = FileOps.get_source_file_obj_from_cache(fullname);
        }
        return (source_file_obj &&
            source_file_obj.source_code_obj &&
            source_file_obj.source_code_obj[linenum] !== undefined);
    },
    get_line_from_file: function (fullname, linenum) {
        var source_file_obj = FileOps.get_source_file_obj_from_cache(fullname);
        if (!source_file_obj) {
            return null;
        }
        return source_file_obj.source_code_obj[linenum];
    },
    assembly_is_cached: function (fullname) {
        var source_file_obj = FileOps.get_source_file_obj_from_cache(fullname);
        return (source_file_obj &&
            source_file_obj.assembly &&
            Object.keys(source_file_obj.assembly).length);
    },
    get_source_file_obj_from_cache: function (fullname) {
        var e_2, _a;
        var cached_files = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("cached_source_files");
        try {
            for (var cached_files_1 = __values(cached_files), cached_files_1_1 = cached_files_1.next(); !cached_files_1_1.done; cached_files_1_1 = cached_files_1.next()) {
                var sf = cached_files_1_1.value;
                if (sf.fullname === fullname) {
                    return sf;
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (cached_files_1_1 && !cached_files_1_1.done && (_a = cached_files_1.return)) _a.call(cached_files_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return null;
    },
    add_source_file_to_cache: function (fullname, source_code_obj, last_modified_unix_sec, num_lines_in_file) {
        var cached_file_obj = FileOps.get_source_file_obj_from_cache(fullname);
        if (cached_file_obj === null) {
            // nothing cached in the front end, add a new entry
            var new_source_file = {
                fullname: fullname,
                source_code_obj: source_code_obj,
                assembly: {},
                last_modified_unix_sec: last_modified_unix_sec,
                num_lines_in_file: num_lines_in_file,
                exists: true
            }, cached_source_files = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("cached_source_files");
            cached_source_files.push(new_source_file);
            statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("cached_source_files", cached_source_files);
            FileOps.warning_shown_for_old_binary = false;
            FileOps.show_modal_if_file_modified_after_binary(fullname, new_source_file.last_modified_unix_sec);
        }
        else {
            // mutate existing source code object by adding keys (lines) of the new source code object
            Object.assign(cached_file_obj.source_code_obj, source_code_obj);
            statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("cached_source_files", statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("cached_source_files"));
        }
    },
    /**
     * Show modal warning if user is trying to show a file that was modified after the binary was compiled
     */
    show_modal_if_file_modified_after_binary: function (fullname, src_last_modified_unix_sec) {
        if (statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("inferior_binary_path")) {
            if (src_last_modified_unix_sec >
                statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("inferior_binary_path_last_modified_unix_sec") &&
                FileOps.warning_shown_for_old_binary === false) {
                _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].show_modal("Warning", react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement("div", null,
                    "This source file was modified ",
                    react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement("span", { className: "bold" }, "after"),
                    " the binary was compiled. Recompile the binary, then try again. Otherwise the source code may not match the binary.",
                    react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement("p", null),
                    react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement("p", null, "Source file: " + fullname + ", modified " + moment(src_last_modified_unix_sec * 1000).format(_constants__WEBPACK_IMPORTED_MODULE_2__["default"].DATE_FORMAT)),
                    react__WEBPACK_IMPORTED_MODULE_4___default.a.createElement("p", null, "Binary: " + statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("inferior_binary_path") + ", modified " + moment(statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("inferior_binary_path_last_modified_unix_sec") * 1000).format(_constants__WEBPACK_IMPORTED_MODULE_2__["default"].DATE_FORMAT),
                        ")")));
                FileOps.warning_shown_for_old_binary = true;
            }
        }
    },
    get_cached_assembly_for_file: function (fullname) {
        var e_3, _a;
        try {
            for (var _b = __values(statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("cached_source_files")), _c = _b.next(); !_c.done; _c = _b.next()) {
                var file = _c.value;
                if (file.fullname === fullname) {
                    return file.assembly;
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_3) throw e_3.error; }
        }
        return [];
    },
    refresh_cached_source_files: function () {
        FileOps.clear_cached_source_files();
    },
    clear_cached_source_files: function () {
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("cached_source_files", []);
    },
    fetch_more_source_at_beginning: function () {
        var fullname = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("fullname_to_render");
        var center_on_line = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("source_linenum_to_display_start") - 1;
        // store.set('source_code_infinite_scrolling', true)
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("source_linenum_to_display_start", Math.max(statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("source_linenum_to_display_start") -
            Math.floor(statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("max_lines_of_code_to_fetch") / 2), 1));
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("source_linenum_to_display_end", Math.ceil(statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("source_linenum_to_display_start") +
            statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("max_lines_of_code_to_fetch")));
        _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].view_file(fullname, center_on_line);
        FileFetcher.fetch(fullname, statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("source_linenum_to_display_start"), statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("source_linenum_to_display_end"));
    },
    fetch_more_source_at_end: function () {
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("source_code_infinite_scrolling", true);
        var fullname = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("fullname_to_render");
        var end_line = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("source_linenum_to_display_end") +
            Math.ceil(statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("max_lines_of_code_to_fetch") / 2);
        var source_file_obj = FileOps.get_source_file_obj_from_cache(fullname);
        if (source_file_obj) {
            // @ts-expect-error ts-migrate(2554) FIXME: Expected 2 arguments, but got 1.
            end_line = Math.min(end_line, FileOps.get_num_lines_in_file(fullname)); // don't go past the end of the line
        }
        var start_line = end_line - statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("max_lines_of_code_to_fetch");
        start_line = Math.max(1, start_line);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("source_linenum_to_display_end", end_line);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("source_linenum_to_display_start", start_line);
        FileFetcher.fetch(fullname, statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("source_linenum_to_display_start"), statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("source_linenum_to_display_end"));
    },
    is_missing_file: function (fullname) {
        return statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("missing_files").indexOf(fullname) !== -1;
    },
    add_missing_file: function (fullname) {
        var missing_files = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("missing_files");
        missing_files.push(fullname);
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("missing_files", missing_files);
    },
    /**
     * gdb changed its api for the data-disassemble command
     * see https://www.sourceware.org/gdb/onlinedocs/gdb/GDB_002fMI-Data-Manipulation.html
     * TODO not sure which version this change occured in. I know in 7.7 it needs the '3' option,
     * and in 7.11 it needs the '4' option. I should test the various version at some point.
     */
    get_dissasembly_format_num: function (gdb_version_array) {
        if (gdb_version_array.length === 0) {
            // assuming new version, but we shouldn't ever not know the version...
            return 4;
        }
        else if (gdb_version_array[0] < 7 ||
            (parseInt(gdb_version_array[0]) === 7 && gdb_version_array[1] <= 7)) {
            // this option has been deprecated in newer versions, but is required in older ones
            return 3;
        }
        else {
            return 4;
        }
    },
    get_fetch_disassembly_command: function (fullname, start_line, mi_response_format) {
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
        if (_.isString(fullname)) {
            return (_constants__WEBPACK_IMPORTED_MODULE_2__["default"].INLINE_DISASSEMBLY_STR +
                ("-data-disassemble -f " + fullname + " -l " + start_line + " -n 1000 -- " + mi_response_format));
        }
        else {
            console.warn("not fetching undefined file");
        }
    },
    /**
     * Fetch disassembly for current file/line.
     */
    fetch_assembly_cur_line: function (mi_response_format) {
        if (mi_response_format === void 0) { mi_response_format = null; }
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
        if (mi_response_format === null || !_.isNumber(mi_response_format)) {
            // try to determine response format based on our guess of the gdb version being used
            // @ts-expect-error ts-migrate(2322) FIXME: Type '4' is not assignable to type 'null'.
            mi_response_format = FileOps.get_dissasembly_format_num(statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("gdb_version_array"));
        }
        var fullname = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("fullname_to_render"), line = parseInt(statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("line_of_source_to_flash"));
        if (!line) {
            line = 1;
        }
        FileOps.fetch_disassembly(fullname, line, mi_response_format);
    },
    fetch_disassembly: function (fullname, start_line, mi_response_format) {
        var cmd = FileOps.get_fetch_disassembly_command(fullname, start_line, mi_response_format);
        if (cmd) {
            _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].run_gdb_command(cmd);
        }
    },
    fetch_disassembly_for_missing_file: function (hex_addr) {
        // https://sourceware.org/gdb/onlinedocs/gdb/GDB_002fMI-Data-Manipulation.html
        if (window.isNaN(hex_addr)) {
            return;
        }
        _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].add_console_entries("Fetching assembly since file is missing", _constants__WEBPACK_IMPORTED_MODULE_2__["default"].console_entry_type.GDBGUI_OUTPUT);
        var start = parseInt(hex_addr, 16), end = start + 100;
        FileOps.disassembly_addr_being_fetched = hex_addr;
        _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].run_gdb_command(_constants__WEBPACK_IMPORTED_MODULE_2__["default"].DISASSEMBLY_FOR_MISSING_FILE_STR +
            ("-data-disassemble -s 0x" + start.toString(16) + " -e 0x" + end.toString(16) + " -- 0"));
    },
    fetch_disassembly_for_missing_file_failed: function () {
        var addr_being_fetched = FileOps.disassembly_addr_being_fetched;
        // @ts-expect-error ts-migrate(2538) FIXME: Type 'null' cannot be used as an index type.
        FileOps.unfetchable_disassembly_addresses[addr_being_fetched] = true;
        FileOps.disassembly_addr_being_fetched = null;
        _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].add_console_entries("Failed to retrieve assembly for missing file", _constants__WEBPACK_IMPORTED_MODULE_2__["default"].console_entry_type.GDBGUI_OUTPUT);
    },
    /**
     * Save assembly and render source code if desired
     * @param mi_assembly: array of assembly instructions
     * @param mi_token (int): corresponds to either null (when src file is known and exists),
     *  constants.DISASSEMBLY_FOR_MISSING_FILE_INT when source file is undefined or does not exist on filesystem
     */
    save_new_assembly: function (mi_assembly, mi_token) {
        var e_4, _a, e_5, _b;
        FileOps.disassembly_addr_being_fetched = null;
        if (!Array.isArray(mi_assembly) || mi_assembly.length === 0) {
            console.error("Attempted to save unexpected assembly", mi_assembly);
        }
        var fullname = mi_assembly[0].fullname;
        // @ts-expect-error ts-migrate(2551) FIXME: Property 'DISASSEMBLY_FOR_MISSING_FILE_INT' does n... Remove this comment to see the full error message
        if (mi_token === _constants__WEBPACK_IMPORTED_MODULE_2__["default"].DISASSEMBLY_FOR_MISSING_FILE_INT) {
            statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("disassembly_for_missing_file", mi_assembly);
            return;
        }
        // convert assembly to an object, with key corresponding to line numbers
        // and values corresponding to asm instructions for that line
        var assembly_to_save = {};
        try {
            for (var mi_assembly_1 = __values(mi_assembly), mi_assembly_1_1 = mi_assembly_1.next(); !mi_assembly_1_1.done; mi_assembly_1_1 = mi_assembly_1.next()) {
                var obj = mi_assembly_1_1.value;
                // @ts-expect-error ts-migrate(7053) FIXME: No index signature with a parameter of type 'numbe... Remove this comment to see the full error message
                assembly_to_save[parseInt(obj.line)] = obj.line_asm_insn;
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (mi_assembly_1_1 && !mi_assembly_1_1.done && (_a = mi_assembly_1.return)) _a.call(mi_assembly_1);
            }
            finally { if (e_4) throw e_4.error; }
        }
        var cached_source_files = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("cached_source_files");
        try {
            for (var cached_source_files_1 = __values(cached_source_files), cached_source_files_1_1 = cached_source_files_1.next(); !cached_source_files_1_1.done; cached_source_files_1_1 = cached_source_files_1.next()) {
                var cached_file = cached_source_files_1_1.value;
                if (cached_file.fullname === fullname) {
                    cached_file.assembly = Object.assign(cached_file.assembly, assembly_to_save);
                    // @ts-expect-error ts-migrate(2345) FIXME: Argument of type 'string[]' is not assignable to p... Remove this comment to see the full error message
                    var max_assm_line = Math.max(Object.keys(cached_file.assembly)), 
                    // @ts-expect-error ts-migrate(2345) FIXME: Argument of type 'string[]' is not assignable to p... Remove this comment to see the full error message
                    max_source_line = Math.max(Object.keys(cached_file.source_code_obj));
                    if (max_assm_line > max_source_line) {
                        cached_file.source_code_obj[max_assm_line] = "";
                        for (var i = 0; i < max_assm_line; i++) {
                            if (!cached_file.source_code_obj[i]) {
                                cached_file.source_code_obj[i] = "";
                            }
                        }
                    }
                    statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("cached_source_files", cached_source_files);
                    break;
                }
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (cached_source_files_1_1 && !cached_source_files_1_1.done && (_b = cached_source_files_1.return)) _b.call(cached_source_files_1);
            }
            finally { if (e_5) throw e_5.error; }
        }
    }
};
/* harmony default export */ __webpack_exports__["default"] = (FileOps);


/***/ }),

/***/ "./gdbgui/src/js/FileSystem.tsx":
/*!**************************************!*\
  !*** ./gdbgui/src/js/FileSystem.tsx ***!
  \**************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();

var FileSystem = /** @class */ (function (_super) {
    __extends(FileSystem, _super);
    function FileSystem() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    FileSystem.prototype.get_node_jsx = function (node, depth) {
        var _this = this;
        if (depth === void 0) { depth = 0; }
        if (!node) {
            return null;
        }
        this.nodecount++;
        var get_child_jsx_for_node = function (node) {
            if (!(node.children && node.toggled)) {
                return null;
            }
            return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("ul", null, node.children.map(function (child) { return _this.get_node_jsx(child, depth + 1); })));
        };
        var indent = "\u00A0\u00A0\u00A0".repeat(depth), glyph = null;
        var is_file = !node.children, is_dir = !is_file;
        if (is_dir) {
            glyph = node.toggled ? "glyphicon-chevron-down" : "glyphicon-chevron-right";
        }
        var onClickName = null;
        if (is_file) {
            onClickName = function () {
                // @ts-expect-error ts-migrate(2339) FIXME: Property 'onClickName' does not exist on type 'Rea... Remove this comment to see the full error message
                _this.props.onClickName(node);
            };
        }
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment, { key: this.nodecount },
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("li", { className: "pointer" },
                indent,
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "glyphicon  " + glyph, onClick: function () {
                        // @ts-expect-error ts-migrate(2339) FIXME: Property 'onToggle' does not exist on type 'Readon... Remove this comment to see the full error message
                        _this.props.onToggle(node);
                    } }),
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { onClick: onClickName }, node.name)),
            get_child_jsx_for_node(node)));
    };
    FileSystem.prototype.render = function () {
        this.nodecount = -1;
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { id: "filesystem" },
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("ul", { style: { color: "#ccc" } }, this.get_node_jsx(this.props.rootnode))));
    };
    return FileSystem;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));
/* harmony default export */ __webpack_exports__["default"] = (FileSystem);


/***/ }),

/***/ "./gdbgui/src/js/FoldersView.tsx":
/*!***************************************!*\
  !*** ./gdbgui/src/js/FoldersView.tsx ***!
  \***************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _FileOps__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./FileOps */ "./gdbgui/src/js/FileOps.tsx");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./gdbgui/src/js/constants.ts");
/* harmony import */ var _SourceFileAutocomplete__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SourceFileAutocomplete */ "./gdbgui/src/js/SourceFileAutocomplete.tsx");
/* harmony import */ var _FileSystem__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./FileSystem */ "./gdbgui/src/js/FileSystem.tsx");
/* harmony import */ var _Actions__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Actions */ "./gdbgui/src/js/Actions.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (undefined && undefined.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};







var default_rootnode = {
    name: 'Load inferior program, then click "Fetch source files" to populate this window',
    children: [],
    toggled: false
};
function get_child_node_with_name(name, curnode) {
    var e_1, _a;
    if (!curnode.children) {
        return null;
    }
    try {
        for (var _b = __values(curnode.children), _c = _b.next(); !_c.done; _c = _b.next()) {
            var node = _c.value;
            if (node.name === name) {
                return node;
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return null;
}
var FoldersView = /** @class */ (function (_super) {
    __extends(FoldersView, _super);
    function FoldersView(props) {
        var _this = _super.call(this, props) || this;
        _this.state = {
            rootnode: default_rootnode
        };
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'connectComponentState' does not exist on... Remove this comment to see the full error message
        statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].connectComponentState(_this, ["source_code_state", "source_file_paths"], _this.update_filesystem_data.bind(_this));
        _this.max_filesystem_entries = 300;
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name 'initial_data'.
        _this.project_home = initial_data.project_home; /* global initial_data */
        _this.onToggle = _this.onToggle.bind(_this);
        _this.onClickName = _this.onClickName.bind(_this);
        _this.reveal_path = _this.reveal_path.bind(_this);
        _this.expand_all = _this.expand_all.bind(_this);
        _this.collapse_all = _this.collapse_all.bind(_this);
        return _this;
    }
    FoldersView.prototype.render = function () {
        var _this = this;
        var source_code_state = this.state.source_code_state, file_is_rendered = source_code_state === _constants__WEBPACK_IMPORTED_MODULE_3__["default"].source_code_states.SOURCE_CACHED ||
            source_code_state === _constants__WEBPACK_IMPORTED_MODULE_3__["default"].source_code_states.ASSM_AND_SOURCE_CACHED, can_reveal = file_is_rendered && this.state.source_file_paths.length, hiding_entries = this.state.source_file_paths.length > this.max_filesystem_entries;
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", null,
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { className: "btn btn-xs btn-primary", onClick: _Actions__WEBPACK_IMPORTED_MODULE_6__["default"].fetch_source_files, style: { marginLeft: "5px", marginTop: "5px" } }, "Fetch source files"),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { style: { width: "100%" } },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_SourceFileAutocomplete__WEBPACK_IMPORTED_MODULE_4__["default"], null)),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { role: "group", className: "btn-group btn-group", style: { padding: "4px" } },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { className: "btn btn-xs btn-default", onClick: this.expand_all }, "Expand all"),
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { className: "btn btn-xs btn-default", onClick: this.collapse_all }, "Collapse all"),
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { className: "btn btn-xs btn-default " + (can_reveal ? "" : "hidden"), onClick: function () { return _this.reveal_path(statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("fullname_to_render")); } }, "Reveal current file")),
            statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("source_file_paths").length ? (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", { style: { color: "white", padding: "4px" } },
                statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("source_file_paths").length,
                " known files used to compile the inferior program")) : (""),
            hiding_entries ? (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", { style: { color: "black", background: "orange", padding: "4px" } },
                "Maximum entries in tree below is ",
                this.max_filesystem_entries,
                " (hiding",
                " ",
                statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("source_file_paths").length - this.max_filesystem_entries,
                "). All files can still be searched for in the input above.")) : (""),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_FileSystem__WEBPACK_IMPORTED_MODULE_5__["default"]
            // @ts-expect-error ts-migrate(2769) FIXME: Property 'rootnode' does not exist on type 'Intrin... Remove this comment to see the full error message
            , { 
                // @ts-expect-error ts-migrate(2769) FIXME: Property 'rootnode' does not exist on type 'Intrin... Remove this comment to see the full error message
                rootnode: this.state.rootnode, onToggle: this.onToggle, onClickName: this.onClickName })));
    };
    FoldersView.prototype.onClickName = function (node) {
        var curnode = node, path = [];
        while (curnode) {
            if (curnode.name === "root") {
                path.unshift("");
                break;
            }
            // prepend this file/directory to the path
            path.unshift(curnode.name);
            // try to prepend the parent
            curnode = curnode.parent;
        }
        if (path.length) {
            _FileOps__WEBPACK_IMPORTED_MODULE_2__["default"].user_select_file_to_view(path.join("/"), 1);
        }
    };
    FoldersView.prototype.reveal_path = function (path) {
        var e_2, _a;
        if (!path) {
            return;
        }
        if (this.state.cursor) {
            this.state.cursor.active = false;
        }
        if (this.project_home) {
            path = path.replace(this.project_home, "");
        }
        var names = path.split("/").filter(function (n) { return n !== ""; }), curnode = this.state.rootnode;
        curnode.toggled = true; // expand the root
        try {
            for (var names_1 = __values(names), names_1_1 = names_1.next(); !names_1_1.done; names_1_1 = names_1.next()) {
                var name = names_1_1.value;
                curnode = get_child_node_with_name(name, curnode);
                if (curnode) {
                    curnode.toggled = true;
                }
                else {
                    break;
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (names_1_1 && !names_1_1.done && (_a = names_1.return)) _a.call(names_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
        if (curnode) {
            curnode.active = true;
        }
        this.setState({ rootnode: this.state.rootnode, cursor: curnode });
    };
    FoldersView.prototype.update_filesystem_data = function (keys) {
        var e_3, _a, e_4, _b;
        if (keys.indexOf("source_file_paths") === -1) {
            return;
        }
        var source_paths = this.state.source_file_paths;
        if (!Array.isArray(source_paths) || !source_paths.length) {
            this.setState({
                rootnode: default_rootnode
            });
            return;
        }
        var rootnode = {
            name: this.project_home || "root",
            toggled: true,
            children: []
        };
        var relative_source_paths = source_paths;
        if (this.project_home) {
            var project_home_1 = this.project_home;
            relative_source_paths = source_paths
                .filter(function (p) { return p.startsWith(project_home_1); })
                .map(function (p) {
                p = p.replace(project_home_1, "");
                return p;
            });
        }
        try {
            for (var relative_source_paths_1 = __values(relative_source_paths), relative_source_paths_1_1 = relative_source_paths_1.next(); !relative_source_paths_1_1.done; relative_source_paths_1_1 = relative_source_paths_1.next()) {
                var path = relative_source_paths_1_1.value;
                var new_node = void 0, names = path.split("/").filter(function (n) { return n !== ""; }), curnode = rootnode, 
                // @ts-expect-error ts-migrate(2448) FIXME: Block-scoped variable 'depth' used before its decl... Remove this comment to see the full error message
                toggled = depth === 0;
                var depth = 0;
                try {
                    for (var names_2 = (e_4 = void 0, __values(names)), names_2_1 = names_2.next(); !names_2_1.done; names_2_1 = names_2.next()) {
                        var name = names_2_1.value;
                        var child = get_child_node_with_name(name, curnode);
                        if (child) {
                            // found an existing child node, use it
                            curnode = child;
                        }
                        else {
                            // add child and set it to cur node
                            // @ts-expect-error ts-migrate(2322) FIXME: Object literal may only specify known properties, ... Remove this comment to see the full error message
                            new_node = { name: name, toggled: toggled, parent: curnode };
                            if (curnode.children) {
                                // @ts-expect-error ts-migrate(2345) FIXME: Argument of type '{ name: any; toggled: boolean; p... Remove this comment to see the full error message
                                curnode.children.push(new_node);
                            }
                            else {
                                // @ts-expect-error ts-migrate(2322) FIXME: Type '{ name: any; toggled: boolean; parent: { nam... Remove this comment to see the full error message
                                curnode.children = [new_node];
                            }
                            curnode = new_node;
                        }
                        depth++;
                    }
                }
                catch (e_4_1) { e_4 = { error: e_4_1 }; }
                finally {
                    try {
                        if (names_2_1 && !names_2_1.done && (_b = names_2.return)) _b.call(names_2);
                    }
                    finally { if (e_4) throw e_4.error; }
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (relative_source_paths_1_1 && !relative_source_paths_1_1.done && (_a = relative_source_paths_1.return)) _a.call(relative_source_paths_1);
            }
            finally { if (e_3) throw e_3.error; }
        }
        this.setState({ rootnode: rootnode });
    };
    FoldersView.prototype.onToggle = function (node) {
        node.toggled = !node.toggled;
        this.setState({ rootnode: this.state.rootnode });
    };
    FoldersView.prototype.expand_all = function () {
        var e_5, _a;
        var callback = function (node) {
            node.toggled = true;
        };
        try {
            for (var _b = __values(this.state.rootnode.children), _c = _b.next(); !_c.done; _c = _b.next()) {
                var top_level_child = _c.value;
                this._dfs(top_level_child, callback);
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_5) throw e_5.error; }
        }
        this.setState({ rootnode: this.state.rootnode });
    };
    FoldersView.prototype.collapse_all = function () {
        var e_6, _a;
        var callback = function (node) {
            node.toggled = false;
        };
        try {
            for (var _b = __values(this.state.rootnode.children), _c = _b.next(); !_c.done; _c = _b.next()) {
                var top_level_child = _c.value;
                this._dfs(top_level_child, callback);
            }
        }
        catch (e_6_1) { e_6 = { error: e_6_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_6) throw e_6.error; }
        }
        this.setState({ rootnode: this.state.rootnode });
    };
    FoldersView.prototype._dfs = function (node, callback) {
        var e_7, _a;
        callback(node);
        if (node.children) {
            try {
                for (var _b = __values(node.children), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var child = _c.value;
                    this._dfs(child, callback);
                }
            }
            catch (e_7_1) { e_7 = { error: e_7_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_7) throw e_7.error; }
            }
        }
    };
    return FoldersView;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));
/* harmony default export */ __webpack_exports__["default"] = (FoldersView);


/***/ }),

/***/ "./gdbgui/src/js/GdbApi.tsx":
/*!**********************************!*\
  !*** ./gdbgui/src/js/GdbApi.tsx ***!
  \**********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Registers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Registers */ "./gdbgui/src/js/Registers.tsx");
/* harmony import */ var _Memory__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Memory */ "./gdbgui/src/js/Memory.tsx");
/* harmony import */ var _Actions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Actions */ "./gdbgui/src/js/Actions.ts");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants */ "./gdbgui/src/js/constants.ts");
/* harmony import */ var _process_gdb_response__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./process_gdb_response */ "./gdbgui/src/js/process_gdb_response.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var socket_io_client__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! socket.io-client */ "./node_modules/socket.io-client/build/index.js");
/* harmony import */ var socket_io_client__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(socket_io_client__WEBPACK_IMPORTED_MODULE_7__);
/**
 * An object to manage the websocket connection to the python server that manages gdb,
 * to send various commands to gdb, to and to dispatch gdb responses to gdbgui.
 */








void react__WEBPACK_IMPORTED_MODULE_6___default.a; // needed when using JSX, but not marked as used
/* global debug */
// print to console if debug is true
var log;
// @ts-expect-error ts-migrate(2304) FIXME: Cannot find name 'debug'.
if (debug) {
    log = console.info;
}
else {
    log = function () {
        // stubbed out
    };
}
/**
 * This object contains methods to interact with
 * gdb, but does not directly render anything in the DOM.
 */
// @ts-expect-error ts-migrate(2339) FIXME: Property 'initial_data' does not exist on type 'Wi... Remove this comment to see the full error message
var initial_data = window.initial_data;
var socket;
var GdbApi = {
    getSocket: function () {
        return socket;
    },
    init: function () {
        var TIMEOUT_MIN = 5;
        socket = socket_io_client__WEBPACK_IMPORTED_MODULE_7___default.a.connect("/gdb_listener", {
            timeout: TIMEOUT_MIN * 60 * 1000,
            query: {
                csrf_token: initial_data.csrf_token,
                gdbpid: initial_data.gdbpid,
                gdb_command: initial_data.gdb_command
            }
        });
        socket.on("connect", function () {
            log("connected");
            var queuedGdbCommands = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("queuedGdbCommands");
            if (queuedGdbCommands) {
                GdbApi.run_gdb_command(queuedGdbCommands);
                statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("queuedGdbCommands", []);
            }
        });
        socket.on("gdb_response", function (response_array) {
            // @ts-expect-error ts-migrate(2769) FIXME: Argument of type 'null' is not assignable to param... Remove this comment to see the full error message
            clearTimeout(GdbApi._waiting_for_response_timeout);
            statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("waiting_for_response", false);
            Object(_process_gdb_response__WEBPACK_IMPORTED_MODULE_5__["default"])(response_array);
        });
        socket.on("fatal_server_error", function (data) {
            _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].add_console_entries("Message from server: " + data.message, _constants__WEBPACK_IMPORTED_MODULE_4__["default"].console_entry_type.STD_ERR);
            socket.close();
        });
        socket.on("error_running_gdb_command", function (data) {
            _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].add_console_entries("Error occurred on server when running gdb command: " + data.message, _constants__WEBPACK_IMPORTED_MODULE_4__["default"].console_entry_type.STD_ERR);
            socket.close();
        });
        socket.on("server_error", function (data) {
            _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].add_console_entries("Server message: " + data.message, _constants__WEBPACK_IMPORTED_MODULE_4__["default"].console_entry_type.STD_ERR);
        });
        socket.on("debug_session_connection_event", function (gdb_pid_obj) {
            var gdb_pid = gdb_pid_obj.pid;
            var message = gdb_pid_obj.message;
            var error = !gdb_pid_obj.ok;
            var started_new_gdb_process = gdb_pid_obj.started_new_gdb_process;
            if (message) {
                _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].add_console_entries(message, error
                    ? _constants__WEBPACK_IMPORTED_MODULE_4__["default"].console_entry_type.STD_ERR
                    : _constants__WEBPACK_IMPORTED_MODULE_4__["default"].console_entry_type.GDBGUI_OUTPUT);
            }
            if (error) {
                socket.close();
                return;
            }
            statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("gdb_pid", gdb_pid);
            if (started_new_gdb_process) {
                GdbApi.run_initial_commands();
            }
            else {
                _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].refresh_state_for_gdb_pause();
            }
        });
        socket.on("disconnect", function () {
            // we no longer need to warn the user before they exit the page since the gdb process
            // on the server is already gone
            window.onbeforeunload = function () { return null; };
            _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].show_modal("", react__WEBPACK_IMPORTED_MODULE_6___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_6___default.a.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_6___default.a.createElement("p", null, "The connection to the gdb session has been closed. This tab will no longer function as expected."),
                react__WEBPACK_IMPORTED_MODULE_6___default.a.createElement("p", { className: "font-bold" },
                    "To start a new session or connect to a different session, go to the",
                    " ",
                    react__WEBPACK_IMPORTED_MODULE_6___default.a.createElement("a", { href: "/dashboard" }, "dashboard"),
                    ".")));
            _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].add_console_entries("The connection to the gdb session has been closed. To start a new session, go to " + window.location.origin + "/dashboard", _constants__WEBPACK_IMPORTED_MODULE_4__["default"].console_entry_type.STD_ERR);
            // if (debug) {
            //   window.location.reload(true);
            // }
        });
    },
    _waiting_for_response_timeout: null,
    click_run_button: function () {
        _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].inferior_program_starting();
        GdbApi.run_gdb_command("-exec-run");
    },
    run_initial_commands: function () {
        var cmds = ["-list-features", "-list-target-features"];
        for (var src in initial_data.remap_sources) {
            var dst = initial_data.remap_sources[src];
            cmds.push("set substitute-path \"" + src + "\" \"" + dst + "\"");
        }
        GdbApi.run_gdb_command(cmds);
    },
    inferior_is_paused: function () {
        return ([_constants__WEBPACK_IMPORTED_MODULE_4__["default"].inferior_states.unknown, _constants__WEBPACK_IMPORTED_MODULE_4__["default"].inferior_states.paused].indexOf(statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("inferior_program")) !== -1);
    },
    click_continue_button: function (reverse) {
        if (reverse === void 0) { reverse = false; }
        _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].inferior_program_resuming();
        GdbApi.run_gdb_command("-exec-continue" + (statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("debug_in_reverse") || reverse ? " --reverse" : ""));
    },
    click_next_button: function (reverse) {
        if (reverse === void 0) { reverse = false; }
        _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].inferior_program_resuming();
        GdbApi.run_gdb_command("-exec-next" + (statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("debug_in_reverse") || reverse ? " --reverse" : ""));
    },
    click_step_button: function (reverse) {
        if (reverse === void 0) { reverse = false; }
        _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].inferior_program_resuming();
        GdbApi.run_gdb_command("-exec-step" + (statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("debug_in_reverse") || reverse ? " --reverse" : ""));
    },
    click_return_button: function () {
        // From gdb mi docs (https://sourceware.org/gdb/onlinedocs/gdb/GDB_002fMI-Program-Execution.html#GDB_002fMI-Program-Execution):
        // `-exec-return` Makes current function return immediately. Doesn't execute the inferior.
        // That means we do NOT dispatch the event `event_inferior_program_resuming`, because it's not, in fact, running.
        // The return also doesn't even indicate that it's paused, so we need to manually trigger the event here.
        GdbApi.run_gdb_command("-exec-return");
        _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].inferior_program_paused();
    },
    click_next_instruction_button: function (reverse) {
        if (reverse === void 0) { reverse = false; }
        _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].inferior_program_resuming();
        GdbApi.run_gdb_command("-exec-next-instruction" +
            (statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("debug_in_reverse") || reverse ? " --reverse" : ""));
    },
    click_step_instruction_button: function (reverse) {
        if (reverse === void 0) { reverse = false; }
        _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].inferior_program_resuming();
        GdbApi.run_gdb_command("-exec-step-instruction" +
            (statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("debug_in_reverse") || reverse ? " --reverse" : ""));
    },
    click_send_interrupt_button: function () {
        _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].inferior_program_resuming();
        GdbApi.run_gdb_command("-exec-interrupt");
    },
    send_autocomplete_command: function (command) {
        _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].inferior_program_resuming();
        GdbApi.run_gdb_command("complete " + command);
    },
    click_gdb_cmd_button: function (e) {
        if (e.currentTarget.dataset.cmd !== undefined) {
            // run single command
            // i.e. <a data-cmd='cmd' />
            GdbApi.run_gdb_command(e.currentTarget.dataset.cmd);
        }
        else if (e.currentTarget.dataset.cmd0 !== undefined) {
            // run multiple commands
            // i.e. <a data-cmd0='cmd 0' data-cmd1='cmd 1' data-...>
            var cmds = [];
            var i = 0;
            var cmd = e.currentTarget.dataset["cmd" + i];
            // extract all commands into an array, then run them
            // (max of 100 commands)
            while (cmd !== undefined && i < 100) {
                cmds.push(cmd);
                i++;
                cmd = e.currentTarget.dataset["cmd" + i];
            }
            GdbApi.run_gdb_command(cmds);
        }
        else {
            console.error("expected cmd or cmd0 [cmd1, cmd2, ...] data attribute(s) on element");
        }
    },
    select_frame: function (framenum) {
        // TODO this command is deprecated (https://sourceware.org/gdb/onlinedocs/gdb/GDB_002fMI-Stack-Manipulation.html)
        // This command in deprecated in favor of passing the ‘--frame’ option to every command.
        GdbApi.run_command_and_refresh_state("-stack-select-frame " + framenum);
    },
    select_thread_id: function (thread_id) {
        // TODO this command is deprecated (http://www.sourceware.org/gdb/current/onlinedocs/gdb/GDB_002fMI-Thread-Commands.html)
        // This command is deprecated in favor of explicitly using the ‘--thread’ option to each command.
        GdbApi.run_command_and_refresh_state("-thread-select " + thread_id);
    },
    /**
     * Before sending a command, set a timeout to notify the user that something might be wrong
     * if a response from gdb is not received
     */
    waiting_for_response: function () {
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("waiting_for_response", true);
        var WAIT_TIME_SEC = 10;
        // @ts-expect-error ts-migrate(2769) FIXME: Argument of type 'null' is not assignable to param... Remove this comment to see the full error message
        clearTimeout(GdbApi._waiting_for_response_timeout);
        // @ts-expect-error ts-migrate(2322) FIXME: Type 'Timeout' is not assignable to type 'null'.
        GdbApi._waiting_for_response_timeout = setTimeout(function () {
            _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].clear_program_state();
            statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("waiting_for_response", false);
            if (GdbApi.getSocket().disconnected) {
                return;
            }
            _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].add_console_entries("No gdb response received after " + WAIT_TIME_SEC + " seconds.", _constants__WEBPACK_IMPORTED_MODULE_4__["default"].console_entry_type.GDBGUI_OUTPUT);
            _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].add_console_entries("Possible reasons include:", _constants__WEBPACK_IMPORTED_MODULE_4__["default"].console_entry_type.GDBGUI_OUTPUT);
            _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].add_console_entries("1) gdbgui, gdb, or the debugged process is not running.", _constants__WEBPACK_IMPORTED_MODULE_4__["default"].console_entry_type.GDBGUI_OUTPUT);
            _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].add_console_entries("2) gdb or the inferior process is busy running and needs to be " +
                "interrupted (press the pause button up top).", _constants__WEBPACK_IMPORTED_MODULE_4__["default"].console_entry_type.GDBGUI_OUTPUT);
            _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].add_console_entries("3) Something is just taking a long time to finish and respond back to " +
                "this browser window, in which case you can just keep waiting.", _constants__WEBPACK_IMPORTED_MODULE_4__["default"].console_entry_type.GDBGUI_OUTPUT);
        }, WAIT_TIME_SEC * 1000);
    },
    /**
     * runs a gdb cmd (or commands) directly in gdb on the backend
     * validates command before sending, and updates the gdb console and status bar
     * @param cmd: a string or array of strings, that are directly evaluated by gdb
     * @return nothing
     */
    run_gdb_command: function (cmd) {
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
        if (_.trim(cmd) === "") {
            return;
        }
        var cmds = cmd;
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
        if (_.isString(cmds)) {
            cmds = [cmds];
        }
        if (socket.connected) {
            socket.emit("run_gdb_command", { cmd: cmds });
            GdbApi.waiting_for_response();
            // add the send command to the console to show commands that are
            // automatically run by gdb
            if (statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("show_all_sent_commands_in_console")) {
                _Actions__WEBPACK_IMPORTED_MODULE_3__["default"].add_console_entries(cmds, _constants__WEBPACK_IMPORTED_MODULE_4__["default"].console_entry_type.SENT_COMMAND);
            }
        }
        else {
            log("queuing commands");
            var queuedGdbCommands = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("queuedGdbCommands").concat(cmds);
            statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("queuedGdbCommands", queuedGdbCommands);
        }
    },
    run_command_and_refresh_state: function (user_cmd) {
        var cmds = [];
        if (Array.isArray(user_cmd)) {
            cmds = cmds.concat(user_cmd);
            // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
        }
        else if (_.isString(user_cmd) && user_cmd.length > 0) {
            cmds.push(user_cmd);
        }
        cmds = cmds.concat(GdbApi._get_refresh_state_for_pause_cmds());
        GdbApi.run_gdb_command(cmds);
    },
    backtrace: function () {
        var cmds = ["backtrace"];
        cmds = cmds.concat(GdbApi._get_refresh_state_for_pause_cmds());
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("inferior_program", _constants__WEBPACK_IMPORTED_MODULE_4__["default"].inferior_states.paused);
        GdbApi.run_gdb_command(cmds);
    },
    /**
     * Get array of commands to send to gdb that refreshes everything in the
     * frontend
     */
    _get_refresh_state_for_pause_cmds: function () {
        var cmds = [
            // get info on current thread
            // TODO run -thread-list-ids to store list of thread id's and know
            // which thread is the current thread
            _constants__WEBPACK_IMPORTED_MODULE_4__["default"].IGNORE_ERRORS_TOKEN_STR + "-thread-info",
            // print the name, type and value for simple data types,
            // and the name and type for arrays, structures and unions.
            _constants__WEBPACK_IMPORTED_MODULE_4__["default"].IGNORE_ERRORS_TOKEN_STR + "-stack-list-variables --simple-values"
        ];
        // update all user-defined variables in gdb
        cmds.push(_constants__WEBPACK_IMPORTED_MODULE_4__["default"].IGNORE_ERRORS_TOKEN_STR + "-var-update --all-values *");
        // update registers
        cmds = cmds.concat(_Registers__WEBPACK_IMPORTED_MODULE_1__["default"].get_update_cmds());
        // re-fetch memory over desired range as specified by DOM inputs
        cmds = cmds.concat(_Memory__WEBPACK_IMPORTED_MODULE_2__["default"].get_gdb_commands_from_state());
        // refresh breakpoints
        cmds.push(GdbApi.get_break_list_cmd());
        // List the frames currently on the stack.
        // avoid the "no registers" error
        cmds.push(_constants__WEBPACK_IMPORTED_MODULE_4__["default"].IGNORE_ERRORS_TOKEN_STR + "-stack-list-frames");
        return cmds;
    },
    refresh_breakpoints: function () {
        GdbApi.run_gdb_command([GdbApi.get_break_list_cmd()]);
    },
    get_inferior_binary_last_modified_unix_sec: function (path) {
        $.ajax({
            beforeSend: function (xhr) {
                xhr.setRequestHeader("x-csrftoken", initial_data.csrf_token);
            },
            url: "/get_last_modified_unix_sec",
            cache: false,
            method: "GET",
            data: { path: path },
            success: GdbApi._recieve_last_modified_unix_sec,
            error: GdbApi._error_getting_last_modified_unix_sec
        });
    },
    get_insert_break_cmd: function (fullname, line) {
        return ["-break-insert \"" + fullname + ":" + line + "\""];
    },
    get_delete_break_cmd: function (bkpt_num) {
        return "-break-delete " + bkpt_num;
    },
    get_break_list_cmd: function () {
        return "-break-list";
    },
    get_load_binary_and_arguments_cmds: function (binary, args) {
        // tell gdb which arguments to use when calling the binary, before loading the binary
        var cmds = [
            "-exec-arguments " + args,
            "-file-exec-and-symbols " + binary // Specify the executable file to be debugged. This file is the one from which the symbol table is also read.
        ];
        // add breakpoint if we don't already have one
        if (statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("auto_add_breakpoint_to_main")) {
            cmds.push("-break-insert main");
        }
        cmds.push(GdbApi.get_break_list_cmd());
        return cmds;
    },
    set_assembly_flavor: function (flavor) {
        GdbApi.run_gdb_command("set disassembly-flavor " + flavor);
    },
    _recieve_last_modified_unix_sec: function (data) {
        if (data.path === statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("inferior_binary_path")) {
            statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("inferior_binary_path_last_modified_unix_sec", data.last_modified_unix_sec);
        }
    },
    _error_getting_last_modified_unix_sec: function (data) {
        void data;
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("inferior_binary_path", null);
    }
};
// @ts-expect-error ts-migrate(2339) FIXME: Property 'socket' does not exist on type '{ getSoc... Remove this comment to see the full error message
GdbApi.socket = socket;
/* harmony default export */ __webpack_exports__["default"] = (GdbApi);


/***/ }),

/***/ "./gdbgui/src/js/GdbMiOutput.tsx":
/*!***************************************!*\
  !*** ./gdbgui/src/js/GdbMiOutput.tsx ***!
  \***************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_1__);
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/**
 * A component to display, in gory detail, what is
 * returned from gdb's machine interface. This displays the
 * data source that is fed to all components and UI elements
 * in gdb gui, and is useful when debugging gdbgui, or
 * a command that failed but didn't have a useful failure
 * message in gdbgui.
 */


var GdbMiOutput = /** @class */ (function (_super) {
    __extends(GdbMiOutput, _super);
    function GdbMiOutput() {
        var _this = 
        // @ts-expect-error ts-migrate(2554) FIXME: Expected 1-2 arguments, but got 0.
        _super.call(this) || this;
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'connectComponentState' does not exist on... Remove this comment to see the full error message
        statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].connectComponentState(_this, ["gdb_mi_output"]);
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
        _this._debounced_scroll_to_bottom = _.debounce(_this._scroll_to_bottom.bind(_this), 300, {
            leading: true
        });
        return _this;
    }
    GdbMiOutput.prototype.render = function () {
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", null,
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { title: "clear all mi output", className: "pointer btn btn-default btn-xs", onClick: function () { return statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("gdb_mi_output", []); } },
                "clear output",
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "glyphicon glyphicon-ban-circle pointer" })),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { id: "gdb_mi_output", className: "otpt", style: { fontSize: "0.8em" } }, this.state.gdb_mi_output)));
    };
    GdbMiOutput.prototype.componentDidMount = function () {
        this.el = document.getElementById("gdb_mi_output");
    };
    GdbMiOutput.prototype.componentDidUpdate = function () {
        this._debounced_scroll_to_bottom();
    };
    GdbMiOutput.prototype._scroll_to_bottom = function () {
        this.el.scrollTop = this.el.scrollHeight;
    };
    GdbMiOutput.add_mi_output = function (mi_obj) {
        var new_str = JSON.stringify(mi_obj, null, 4)
            // @ts-expect-error ts-migrate(2554) FIXME: Expected 2 arguments, but got 1.
            .replace(/[^(\\)]\\n/g)
            .replace("<", "&lt;")
            .replace(">", "&gt;"), gdb_mi_output = statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("gdb_mi_output");
        while (gdb_mi_output.length > GdbMiOutput.MAX_OUTPUT_ENTRIES) {
            gdb_mi_output.shift();
        }
        gdb_mi_output.push(new_str);
        statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("gdb_mi_output", gdb_mi_output);
    };
    GdbMiOutput.MAX_OUTPUT_ENTRIES = 500;
    return GdbMiOutput;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));
/* harmony default export */ __webpack_exports__["default"] = (GdbMiOutput);


/***/ }),

/***/ "./gdbgui/src/js/GdbVariable.tsx":
/*!***************************************!*\
  !*** ./gdbgui/src/js/GdbVariable.tsx ***!
  \***************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Memory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Memory */ "./gdbgui/src/js/Memory.tsx");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./gdbgui/src/js/constants.ts");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _GdbApi__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./GdbApi */ "./gdbgui/src/js/GdbApi.tsx");
/* harmony import */ var _CopyToClipboard__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./CopyToClipboard */ "./gdbgui/src/js/CopyToClipboard.tsx");
/* harmony import */ var _Actions__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Actions */ "./gdbgui/src/js/Actions.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (undefined && undefined.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
/**
 * A component to render gdb user variables, and
 * some library functions to interact with gdb. The library
 * functions create gdb variable objects locally, update them,
 * remove them, etc.
 */







/**
 * Simple object to manage fetching of child variables. Maintains a queue of parent expressions
 * to fetch children for, and fetches them in serial.
 */
var ChildVarFetcher = {
    expr_gdb_parent_var_currently_fetching_children: null,
    _is_fetching: false,
    _queue: [],
    _fetch_next_in_queue: function () {
        if (ChildVarFetcher._is_fetching) {
            return;
        }
        if (ChildVarFetcher._queue.length) {
            var obj = ChildVarFetcher._queue.shift();
            ChildVarFetcher.expr_gdb_parent_var_currently_fetching_children =
                // @ts-expect-error ts-migrate(2532) FIXME: Object is possibly 'undefined'.
                obj.expr_of_parent;
            ChildVarFetcher._is_fetching = true;
            // @ts-expect-error ts-migrate(2532) FIXME: Object is possibly 'undefined'.
            _GdbApi__WEBPACK_IMPORTED_MODULE_4__["default"].run_gdb_command("-var-list-children --all-values \"" + obj.expr_of_parent + "\"");
        }
        else {
            ChildVarFetcher.expr_gdb_parent_var_currently_fetching_children = null;
        }
    },
    fetch_children: function (expr_of_parent, expr_type) {
        // @ts-expect-error ts-migrate(2322) FIXME: Type 'any' is not assignable to type 'never'.
        ChildVarFetcher._queue.push({ expr_of_parent: expr_of_parent, expr_type: expr_type });
        ChildVarFetcher._fetch_next_in_queue();
    },
    fetch_complete: function () {
        ChildVarFetcher._is_fetching = false;
        ChildVarFetcher.expr_gdb_parent_var_currently_fetching_children = null;
        ChildVarFetcher._fetch_next_in_queue();
    }
};
/**
 * Simple object to manage fetching of variables. Maintains a queue of expressions
 * to fetch, and fetches them in serial.
 */
var VarCreator = {
    _queue: [],
    _is_fetching: false,
    expr_being_created: null,
    expr_type: null,
    _fetch_next_in_queue: function () {
        if (VarCreator._is_fetching) {
            return;
        }
        if (VarCreator._queue.length) {
            var obj = VarCreator._queue.shift(), 
            // @ts-expect-error ts-migrate(2532) FIXME: Object is possibly 'undefined'.
            expression = obj.expression, 
            // @ts-expect-error ts-migrate(2532) FIXME: Object is possibly 'undefined'.
            expr_type = obj.expr_type;
            VarCreator._is_fetching = true;
            VarCreator.expr_being_created = expression;
            VarCreator.expr_type = expr_type;
            // surround in quotes if we found a quote
            if (expression.length > 0 && expression.indexOf('"') !== 0) {
                expression = '"' + expression + '"';
            }
            var cmds = [];
            if (statorgfc__WEBPACK_IMPORTED_MODULE_3__["store"].get("pretty_print")) {
                cmds.push("-enable-pretty-printing");
            }
            // - means auto assign variable name in gdb
            // * means evaluate it at the current frame
            var var_create_cmd = _constants__WEBPACK_IMPORTED_MODULE_2__["default"].CREATE_VAR_STR + ("-var-create - * " + expression);
            cmds.push(var_create_cmd);
            _GdbApi__WEBPACK_IMPORTED_MODULE_4__["default"].run_gdb_command(cmds);
        }
        else {
            VarCreator._clear_state();
        }
    },
    /**
     * Create a new variable in gdb. gdb automatically chooses and assigns
     * a unique variable name.
     */
    create_variable: function (expression, expr_type) {
        // @ts-expect-error ts-migrate(2322) FIXME: Type 'any' is not assignable to type 'never'.
        VarCreator._queue.push({ expression: expression, expr_type: expr_type });
        VarCreator._fetch_next_in_queue();
    },
    /**
     * After a variable is created, we need to link the gdb
     * variable name (which is automatically created by gdb),
     * and the expression the user wanted to evailuate. The
     * new variable is saved locally. The variable UI element is then re-rendered
     * @param r (object): gdb mi object
     */
    created_variable: function (r) {
        var expr = VarCreator.expr_being_created;
        if (expr) {
            // example payload:
            // "payload": {
            //      "has_more": "0",
            //      "name": "var2",
            //      "numchild": "0",
            //      "thread-id": "1",
            //      "type": "int",
            //      "value": "0"
            //  },
            GdbVariable.save_new_expression(expr, VarCreator.expr_type, r.payload);
            VarCreator.expr_being_created = null;
            // automatically fetch first level of children for root variables
            GdbVariable.fetch_and_show_children_for_var(r.payload.name);
        }
        else {
            // gdbgui did not expect a new variable to be created here
            // it's likely this tab is viewing an instance of gdb that multiple users
            // are interacting with
        }
        VarCreator._fetch_complete();
    },
    fetch_failed: function (r) {
        if (VarCreator.expr_type === "hover") {
            // do nothing
        }
        else {
            _Actions__WEBPACK_IMPORTED_MODULE_6__["default"].add_gdb_response_to_console(r);
        }
        VarCreator._fetch_complete();
    },
    _fetch_complete: function () {
        VarCreator._is_fetching = false;
        VarCreator._clear_state();
        VarCreator._fetch_next_in_queue();
    },
    _clear_state: function () {
        VarCreator._is_fetching = false;
    }
};
var GdbVariable = /** @class */ (function (_super) {
    __extends(GdbVariable, _super);
    function GdbVariable() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    GdbVariable.prototype.render = function () {
        var is_root = true;
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'expr_type' does not exist on type 'Reado... Remove this comment to see the full error message
        if (this.props.expr_type === "local") {
            // @ts-expect-error ts-migrate(2339) FIXME: Property 'obj' does not exist on type 'Readonly<{}... Remove this comment to see the full error message
            return this.get_ul_for_local(this.props.obj);
        }
        else {
            // @ts-expect-error ts-migrate(2339) FIXME: Property 'obj' does not exist on type 'Readonly<{}... Remove this comment to see the full error message
            if (this.props.obj.numchild > 0) {
                return this.get_ul_for_var_with_children(
                // @ts-expect-error ts-migrate(2339) FIXME: Property 'expression' does not exist on type 'Read... Remove this comment to see the full error message
                this.props.expression, 
                // @ts-expect-error ts-migrate(2339) FIXME: Property 'obj' does not exist on type 'Readonly<{}... Remove this comment to see the full error message
                this.props.obj, 
                // @ts-expect-error ts-migrate(2339) FIXME: Property 'expr_type' does not exist on type 'Reado... Remove this comment to see the full error message
                this.props.expr_type, is_root);
            }
            else {
                return this.get_ul_for_var_without_children(
                // @ts-expect-error ts-migrate(2339) FIXME: Property 'expression' does not exist on type 'Read... Remove this comment to see the full error message
                this.props.expression, 
                // @ts-expect-error ts-migrate(2339) FIXME: Property 'obj' does not exist on type 'Readonly<{}... Remove this comment to see the full error message
                this.props.obj, 
                // @ts-expect-error ts-migrate(2339) FIXME: Property 'expr_type' does not exist on type 'Reado... Remove this comment to see the full error message
                this.props.expr_type, is_root);
            }
        }
    };
    /**
     * get unordered list for a "local" returned by gdb
     * these are special snowflakes; gdb returns a small subset of information for
     * locals. The list is useful to browse, but oftentimes needs to be expanded.
     * If the user clicks on a local that can be expanded, gdbgui will ask gdb
     * to create a full-fledged variable for the user to explore. gdbgui will then
     * render that instead of the "local".
     */
    GdbVariable.prototype.get_ul_for_local = function (local) {
        var can_be_expanded = local.can_be_expanded, 
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
        value = _.isString(local.value)
            ? _Memory__WEBPACK_IMPORTED_MODULE_1__["default"].make_addrs_into_links_react(local.value)
            : local.value, onclick = can_be_expanded
            ? function () { return GdbVariable.create_variable(local.name, "local"); }
            : function () { };
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", null,
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { onClick: onclick, className: can_be_expanded ? "pointer" : "" },
                can_be_expanded ? "+" : "",
                " ",
                local.name,
                "\u00A0"),
            value,
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "var_type" }, _.trim(local.type))));
    };
    /**
     * get unordered list for a variable that has children
     * @return unordered list, expanded or collapsed based on the key "show_children_in_ui"
     */
    GdbVariable.prototype.get_ul_for_var_with_children = function (expression, mi_obj, expr_type, is_root) {
        var e_1, _a;
        if (is_root === void 0) { is_root = false; }
        var child_tree;
        if (mi_obj.show_children_in_ui) {
            var content = [];
            if (mi_obj.children.length > 0) {
                try {
                    for (var _b = __values(mi_obj.children), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var child = _c.value;
                        if (child.numchild > 0) {
                            content.push(react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("li", { key: child.exp }, this.get_ul_for_var_with_children(child.exp, child, expr_type)));
                        }
                        else {
                            content.push(react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("li", { key: child.exp }, this.get_ul_for_var_without_children(child.exp, child, expr_type)));
                        }
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
            }
            child_tree = react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("ul", { key: mi_obj.exp }, content);
        }
        else {
            child_tree = "";
        }
        var plus_or_minus = mi_obj.show_children_in_ui ? "-" : "+";
        return this._get_ul_for_var(expression, mi_obj, expr_type, is_root, plus_or_minus, 
        // @ts-expect-error ts-migrate(2345) FIXME: Type 'Element' is not assignable to type 'string'.
        child_tree, mi_obj.numchild);
    };
    GdbVariable.prototype.get_ul_for_var_without_children = function (expression, mi_obj, expr_type, is_root) {
        if (is_root === void 0) { is_root = false; }
        return this._get_ul_for_var(expression, mi_obj, expr_type, is_root);
    };
    GdbVariable._get_value_jsx = function (obj) {
        var val;
        if (obj.is_int) {
            val = (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "inline" },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "gdbVarValue" },
                    _Memory__WEBPACK_IMPORTED_MODULE_1__["default"].make_addrs_into_links_react(obj._int_value_to_str_in_radix),
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { className: "btn btn-default btn-xs btn-radix", onClick: function () {
                            GdbVariable.change_radix(obj);
                        }, title: "click to change radix", style: { fontSize: "60%" } },
                        "base ",
                        obj._radix))));
        }
        else {
            // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
            val = _.isString(obj.value)
                ? _Memory__WEBPACK_IMPORTED_MODULE_1__["default"].make_addrs_into_links_react(obj.value)
                : obj.value;
        }
        return val;
    };
    GdbVariable.change_radix = function (obj) {
        if (obj._radix === 16) {
            obj._radix = 2;
        }
        else {
            obj._radix += 2;
        }
        GdbVariable._update_radix_values(obj);
        statorgfc__WEBPACK_IMPORTED_MODULE_3__["store"].set("expressions", statorgfc__WEBPACK_IMPORTED_MODULE_3__["store"].get("expressions"));
    };
    /**
     * Get ul for a variable with or without children
     */
    GdbVariable.prototype._get_ul_for_var = function (expression, mi_obj, expr_type, is_root, plus_or_minus, child_tree, numchild) {
        if (plus_or_minus === void 0) { plus_or_minus = ""; }
        if (child_tree === void 0) { child_tree = ""; }
        if (numchild === void 0) { numchild = 0; }
        var glyph_style = { fontSize: "0.8em", paddingLeft: "5px" }, delete_button = is_root && expr_type === "expr" ? (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { style: glyph_style, className: "glyphicon glyphicon-trash pointer", onClick: function () { return GdbVariable.delete_gdb_variable(mi_obj.name); } })) : (""), has_children = numchild > 0, can_draw_tree = has_children && (expr_type === "expr" || expr_type === "local"), // hover var can't draw tree
        tree = can_draw_tree ? (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { style: glyph_style, className: "glyphicon glyphicon-tree-deciduous pointer", onClick: function () { return GdbVariable.click_draw_tree_gdb_variable(mi_obj.name); } })) : (""), toggle_classes = has_children ? "pointer" : "", plot_content = "", plot_button = "", plusminus_click_callback = has_children
            ? function () { return GdbVariable.click_toggle_children_visibility(mi_obj.name); }
            : function () { };
        if (mi_obj.can_plot && mi_obj.show_plot) {
            // dots are not allowed in the dom as id's. replace with '-'.
            var id = mi_obj.dom_id_for_plot;
            // @ts-expect-error ts-migrate(2322) FIXME: Type 'Element' is not assignable to type 'string'.
            plot_button = (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { style: glyph_style, className: "pointer glyphicon glyphicon-ban-circle", onClick: function () { return GdbVariable.click_toggle_plot(mi_obj.name); }, title: "remove x/y plot" }));
            // @ts-expect-error ts-migrate(2322) FIXME: Type 'Element' is not assignable to type 'string'.
            plot_content = react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { id: id, className: "plot" });
        }
        else if (mi_obj.can_plot && !mi_obj.show_plot) {
            // @ts-expect-error ts-migrate(2322) FIXME: Type 'Element' is not assignable to type 'string'.
            plot_button = (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { style: glyph_style, className: "glyphicon glyphicon glyphicon-equalizer pointer", onClick: function () { return GdbVariable.click_toggle_plot(mi_obj.name); }, title: "show x/y plot" }));
        }
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("ul", { key: expression, className: "varUL" },
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("li", { className: "varLI" },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: toggle_classes, onClick: plusminus_click_callback },
                    plus_or_minus,
                    " ",
                    expression,
                    "\u00A0"),
                GdbVariable._get_value_jsx(mi_obj),
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "var_type" }, _.trim(mi_obj.type) || ""),
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "right_help_icon_show_on_hover" },
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_CopyToClipboard__WEBPACK_IMPORTED_MODULE_5__["default"], { content: GdbVariable._get_full_path(mi_obj) }),
                    ":",
                    tree,
                    plot_button,
                    delete_button),
                plot_content),
            child_tree));
    };
    GdbVariable._get_full_path = function (obj) {
        if (!obj) {
            return "";
        }
        function update_path(path, obj) {
            var potential_addition = obj.expression || obj.exp;
            if (potential_addition === "public" ||
                potential_addition === "private" ||
                potential_addition === "protected") {
                // these are inserted by gdb, and arent actually field names!
                return path;
            }
            else if (path) {
                return potential_addition + "." + path;
            }
            else {
                return potential_addition;
            }
        }
        var path = update_path("", obj);
        var cur_obj = obj.parent;
        var depth = 0;
        while (cur_obj) {
            path = update_path(path, cur_obj);
            cur_obj = cur_obj.parent;
            depth += 1;
            if (depth > 100) {
                console.warn("exceeded maximum depth, breaking while loop");
                break;
            }
        }
        return path;
    };
    GdbVariable.create_variable = function (expression, expr_type) {
        VarCreator.create_variable(expression, expr_type);
    };
    GdbVariable.gdb_created_root_variable = function (r) {
        VarCreator.created_variable(r);
    };
    GdbVariable.gdb_variable_fetch_failed = function (r) {
        VarCreator.fetch_failed(r);
    };
    /**
     * Got data regarding children of a gdb variable. It could be an immediate child, or grandchild, etc.
     * This method stores this child array data to the appropriate locally stored
     * object
     * @param r (object): gdb mi object
     */
    GdbVariable.gdb_created_children_variables = function (r) {
        // example reponse payload:
        // "payload": {
        //         "has_more": "0",
        //         "numchild": "2",
        //         "children": [
        //             {
        //                 "name": "var9.a",
        //                 "thread-id": "1",
        //                 "numchild": "0",
        //                 "value": "4195840",
        //                 "exp": "a",
        //                 "type": "int"
        //             }
        //             {
        //                 "name": "var9.b",
        //                 "thread-id": "1",
        //                 "numchild": "0",
        //                 "value": "0",
        //                 "exp": "b",
        //                 "type": "float"
        //             }
        //         ]
        //     }
        var e_2, _a;
        var parent_name = ChildVarFetcher.expr_gdb_parent_var_currently_fetching_children;
        if (!parent_name) {
            // gdb created child variable, but the parent variable is unknown
            // it's likely another tab interacting w/ the same gdb instance created this
        }
        ChildVarFetcher.fetch_complete();
        // get the parent object of these children
        var expressions = statorgfc__WEBPACK_IMPORTED_MODULE_3__["store"].get("expressions");
        var parent_obj = GdbVariable.get_obj_from_gdb_var_name(expressions, parent_name);
        if (parent_obj) {
            // prepare all the child objects we received for local storage
            var children = r.payload.children.map(function (child_obj) {
                return GdbVariable.prepare_gdb_obj_for_storage(child_obj, parent_obj);
            });
            // save these children as a field to their parent
            parent_obj.children = children;
            parent_obj.numchild = children.length;
            statorgfc__WEBPACK_IMPORTED_MODULE_3__["store"].set("expressions", expressions);
            try {
                // if this field is an anonymous struct, the user will want to
                // see this expanded by default
                for (var _b = __values(parent_obj.children), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var child = _c.value;
                    if (child.exp.includes("<anonymous")) {
                        GdbVariable.fetch_and_show_children_for_var(child.name);
                    }
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
        else {
            // gdbgui did not expect this.
            // another browser tab interacting w/ the same gdb instance likely created this
        }
    };
    /**
     * gdb returns objects for its variables,, but before we save that
     * data locally, we will add more fields to make it more useful for gdbgui
     * @param obj (object): mi object returned from gdb
     * @param expr_type (str): type of expression being created (see store creation for documentation)
     */
    GdbVariable.prepare_gdb_obj_for_storage = function (obj, parent) {
        var new_obj = Object.assign({}, obj);
        // obj was copied, now add some additional fields used by gdbgui
        new_obj.parent = parent;
        // A varobj's contents may be provided by a Python-based pretty-printer.
        // In this case the varobj is known as a dynamic varobj.
        // Dynamic varobjs have slightly different semantics in some cases.
        // https://sourceware.org/gdb/onlinedocs/gdb/GDB_002fMI-Variable-Objects.html#GDB_002fMI-Variable-Objects
        new_obj.numchild = obj.dynamic ? parseInt(obj.has_more) : parseInt(obj.numchild);
        new_obj.children = []; // actual child objects are fetched dynamically when the user requests them
        new_obj.show_children_in_ui = false;
        // this field is not returned when the variable is created, but
        // it is returned when the variables are updated
        // it is returned by gdb mi as a string, and we assume it starts out in scope
        new_obj.in_scope = "true";
        new_obj.expr_type = VarCreator.expr_type;
        GdbVariable._update_numeric_properties(new_obj);
        new_obj.dom_id_for_plot = new_obj.name
            .replace(/\./g, "-") // replace '.' with '-'
            .replace(/\$/g, "_") // replace '$' with '-'
            .replace(/\[/g, "_") // replace '[' with '_'
            .replace(/\]/g, "_"); // replace ']' with '_'
        new_obj.show_plot = false; // used when rendering to decide whether to show plot or not
        // push to this array each time a new value is assigned if value is numeric.
        // Plots use this data
        if (new_obj.value.indexOf("0x") === 0) {
            new_obj.values = [parseInt(new_obj.value, 16)];
            new_obj._radix = 16;
        }
        else if (!window.isNaN(parseFloat(new_obj.value))) {
            new_obj.values = [parseFloat(new_obj.value)];
            if (new_obj.is_int) {
                new_obj._radix = 10;
            }
            else {
                new_obj._radix = 0;
            }
        }
        else {
            new_obj.values = [];
            new_obj._radix = 0;
        }
        GdbVariable._update_radix_values(new_obj); // mutates new_obj
        return new_obj;
    };
    GdbVariable._update_numeric_properties = function (obj) {
        var value = obj.value;
        if (obj.value.startsWith("0x")) {
            value = parseInt(obj.value, 16);
        }
        obj._float_value = parseFloat(value);
        obj.is_numeric = !window.isNaN(obj._float_value);
        obj.can_plot = obj.is_numeric && obj.expr_type === "expr";
        obj.is_int = obj.is_numeric ? obj._float_value % 1 === 0 : false;
    };
    GdbVariable._update_radix_values = function (obj) {
        if (obj.is_int) {
            obj._int_value_decimal = parseInt(obj.value);
            if (obj._radix < 2 || obj._radix > 36) {
                // defensive programming
                console.warn("Got invalid radix. Setting to 10.");
                obj._radix = 10;
            }
            obj._int_value_to_str_in_radix = obj._int_value_decimal.toString(obj._radix);
            if (obj._radix === 16) {
                obj._int_value_to_str_in_radix = "0x" + obj._int_value_to_str_in_radix;
            }
        }
    };
    /**
     * function render a plot on an existing element
     * @param obj: object to make a plot for
     */
    GdbVariable._make_plot = function (obj) {
        var e_3, _a;
        var id = "#" + obj.dom_id_for_plot, // this div should have been created already
        jq = $(id), data = [], i = 0;
        try {
            // collect data
            for (var _b = __values(obj.values), _c = _b.next(); !_c.done; _c = _b.next()) {
                var val = _c.value;
                data.push([i, val]);
                i++;
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_3) throw e_3.error; }
        }
        // make the plot
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'plot' does not exist on type 'JQueryStat... Remove this comment to see the full error message
        $.plot(jq, [
            {
                data: data,
                shadowSize: 0,
                color: "#33cdff"
            }
        ], {
            series: {
                lines: { show: true },
                points: { show: true }
            },
            grid: { hoverable: true, clickable: false }
        });
        // add hover event to show tooltip
        jq.bind("plothover", function (event, pos, item) {
            if (item) {
                var x = item.datapoint[0], y = item.datapoint[1];
                $("#plot_coordinate_tooltip")
                    .html("(" + x + ", " + y + ")")
                    .css({ top: item.pageY + 5, left: item.pageX + 5 })
                    .show();
            }
            else {
                $("#plot_coordinate_tooltip").hide();
            }
        });
    };
    /**
     * look through all expression objects and see if they are supposed to show their plot.
     * If so, update the dom accordingly
     * @param obj: expression object to plot (may have children to plot too)
     */
    GdbVariable.plot_var_and_children = function (obj) {
        var e_4, _a;
        if (obj.show_plot) {
            GdbVariable._make_plot(obj);
        }
        try {
            for (var _b = __values(obj.children), _c = _b.next(); !_c.done; _c = _b.next()) {
                var child = _c.value;
                GdbVariable.plot_var_and_children(child);
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_4) throw e_4.error; }
        }
    };
    GdbVariable.fetch_and_show_children_for_var = function (gdb_var_name) {
        var expressions = statorgfc__WEBPACK_IMPORTED_MODULE_3__["store"].get("expressions");
        var obj = GdbVariable.get_obj_from_gdb_var_name(expressions, gdb_var_name);
        // mutate object by reference
        obj.show_children_in_ui = true;
        // update store
        statorgfc__WEBPACK_IMPORTED_MODULE_3__["store"].set("expressions", expressions);
        if (obj.numchild && obj.children.length === 0) {
            // need to fetch child data
            ChildVarFetcher.fetch_children(gdb_var_name, obj.expr_type);
        }
        else {
            // already have child data, re-render will occur from event dispatch
        }
    };
    GdbVariable.hide_children_in_ui = function (gdb_var_name) {
        var expressions = statorgfc__WEBPACK_IMPORTED_MODULE_3__["store"].get("expressions"), obj = GdbVariable.get_obj_from_gdb_var_name(expressions, gdb_var_name);
        if (obj) {
            obj.show_children_in_ui = false;
            statorgfc__WEBPACK_IMPORTED_MODULE_3__["store"].set("expressions", expressions);
        }
    };
    GdbVariable.click_toggle_children_visibility = function (gdb_variable_name) {
        GdbVariable._toggle_children_visibility(gdb_variable_name);
    };
    GdbVariable._toggle_children_visibility = function (gdb_var_name) {
        // get data object, which has field that says whether its expanded or not
        var obj = GdbVariable.get_obj_from_gdb_var_name(statorgfc__WEBPACK_IMPORTED_MODULE_3__["store"].get("expressions"), gdb_var_name);
        if (obj) {
            var showing_children_in_ui = obj.show_children_in_ui;
            if (showing_children_in_ui) {
                // collapse
                GdbVariable.hide_children_in_ui(gdb_var_name);
            }
            else {
                // expand
                GdbVariable.fetch_and_show_children_for_var(gdb_var_name);
            }
        }
        else {
            console.error("developer error - expected to find gdb variable object");
        }
    };
    GdbVariable.click_toggle_plot = function (gdb_var_name) {
        var expressions = statorgfc__WEBPACK_IMPORTED_MODULE_3__["store"].get("expressions"), 
        // get data object, which has field that says whether its expanded or not
        obj = GdbVariable.get_obj_from_gdb_var_name(expressions, gdb_var_name);
        if (obj) {
            obj.show_plot = !obj.show_plot;
            statorgfc__WEBPACK_IMPORTED_MODULE_3__["store"].set("expressions", expressions);
        }
    };
    GdbVariable.get_update_cmds = function () {
        var e_5, _a;
        function _get_cmds_for_obj(obj) {
            var e_6, _a;
            var cmds = ["-var-update --all-values " + obj.name];
            try {
                for (var _b = __values(obj.children), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var child = _c.value;
                    cmds = cmds.concat(_get_cmds_for_obj(child));
                }
            }
            catch (e_6_1) { e_6 = { error: e_6_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_6) throw e_6.error; }
            }
            return cmds;
        }
        var cmds = [];
        try {
            for (var _b = __values(statorgfc__WEBPACK_IMPORTED_MODULE_3__["store"].get("expressions")), _c = _b.next(); !_c.done; _c = _b.next()) {
                var obj = _c.value;
                cmds = cmds.concat(_get_cmds_for_obj(obj));
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_5) throw e_5.error; }
        }
        return cmds;
    };
    GdbVariable.handle_changelist = function (changelist_array) {
        var e_7, _a;
        var _loop_1 = function (changelist) {
            var expressions = statorgfc__WEBPACK_IMPORTED_MODULE_3__["store"].get("expressions"), obj = GdbVariable.get_obj_from_gdb_var_name(expressions, changelist.name);
            if (obj) {
                if (parseInt(changelist["has_more"]) === 1 && "name" in changelist) {
                    // already retrieved children of obj, but more fields were added.
                    // Re-fetch the object from gdb
                    ChildVarFetcher.fetch_children(changelist["name"], obj.expr_type);
                }
                if ("new_children" in changelist) {
                    var new_children = changelist.new_children.map(function (child_obj) {
                        return GdbVariable.prepare_gdb_obj_for_storage(child_obj, obj);
                    });
                    obj.children = obj.children.concat(new_children);
                }
                // overwrite fields of obj with fields from changelist
                obj = Object.assign(obj, changelist);
                GdbVariable._update_numeric_properties(obj);
                GdbVariable._update_radix_values(obj);
                if (obj.can_plot) {
                    obj.values.push(obj._float_value);
                }
                statorgfc__WEBPACK_IMPORTED_MODULE_3__["store"].set("expressions", expressions);
            }
            else {
                // error
            }
        };
        try {
            for (var changelist_array_1 = __values(changelist_array), changelist_array_1_1 = changelist_array_1.next(); !changelist_array_1_1.done; changelist_array_1_1 = changelist_array_1.next()) {
                var changelist = changelist_array_1_1.value;
                _loop_1(changelist);
            }
        }
        catch (e_7_1) { e_7 = { error: e_7_1 }; }
        finally {
            try {
                if (changelist_array_1_1 && !changelist_array_1_1.done && (_a = changelist_array_1.return)) _a.call(changelist_array_1);
            }
            finally { if (e_7) throw e_7.error; }
        }
    };
    GdbVariable.click_draw_tree_gdb_variable = function (gdb_variable) {
        statorgfc__WEBPACK_IMPORTED_MODULE_3__["store"].set("root_gdb_tree_var", gdb_variable);
    };
    GdbVariable.delete_gdb_variable = function (gdbvar) {
        // delete locally
        GdbVariable._delete_local_gdb_var_data(gdbvar);
        // delete in gdb too
        _GdbApi__WEBPACK_IMPORTED_MODULE_4__["default"].run_gdb_command("-var-delete " + gdbvar);
    };
    /**
     * Delete local copy of gdb variable (all its children are deleted too
     * since they are stored as fields in the object)
     */
    GdbVariable._delete_local_gdb_var_data = function (gdb_var_name) {
        var expressions = statorgfc__WEBPACK_IMPORTED_MODULE_3__["store"].get("expressions");
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
        _.remove(expressions, function (v) { return v.name === gdb_var_name; });
        statorgfc__WEBPACK_IMPORTED_MODULE_3__["store"].set("expressions", expressions);
    };
    /**
     * Locally save the variable to our cached variables
     */
    GdbVariable.save_new_expression = function (expression, expr_type, obj) {
        var new_obj = GdbVariable.prepare_gdb_obj_for_storage(obj, null);
        new_obj.expression = expression;
        var expressions = statorgfc__WEBPACK_IMPORTED_MODULE_3__["store"].get("expressions");
        expressions.push(new_obj);
        statorgfc__WEBPACK_IMPORTED_MODULE_3__["store"].set("expressions", expressions);
    };
    /**
     * Get child variable with a particular name
     */
    GdbVariable.get_child_with_name = function (children, name) {
        var e_8, _a;
        try {
            for (var children_1 = __values(children), children_1_1 = children_1.next(); !children_1_1.done; children_1_1 = children_1.next()) {
                var child = children_1_1.value;
                if (child.name === name) {
                    return child;
                }
            }
        }
        catch (e_8_1) { e_8 = { error: e_8_1 }; }
        finally {
            try {
                if (children_1_1 && !children_1_1.done && (_a = children_1.return)) _a.call(children_1);
            }
            finally { if (e_8) throw e_8.error; }
        }
        return undefined;
    };
    GdbVariable.get_root_name_from_gdbvar_name = function (gdb_var_name) {
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
        if (_.isString(gdb_var_name)) {
            return gdb_var_name.split(".")[0];
        }
        else {
            return "";
        }
    };
    GdbVariable.get_child_names_from_gdbvar_name = function (gdb_var_name) {
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
        if (_.isString(gdb_var_name)) {
            return gdb_var_name.split(".").slice(1, gdb_var_name.length);
        }
        else {
            return "";
        }
    };
    /**
     * Get object from gdb variable name. gdb variable names are unique, and don't match
     * the expression being evaluated. If drilling down into fields of structures, the
     * gdb variable name has dot notation, such as 'var.field1.field2'.
     * @param gdb_var_name: gdb variable name to find corresponding cached object. Can have dot notation
     * @return: object if found, or undefined if not found
     */
    GdbVariable.get_obj_from_gdb_var_name = function (expressions, gdb_var_name) {
        // gdb provides names in dot notation
        // let gdb_var_names = gdb_var_name.split('.'),
        var top_level_var_name = GdbVariable.get_root_name_from_gdbvar_name(gdb_var_name), children_names = GdbVariable.get_child_names_from_gdbvar_name(gdb_var_name);
        var objs = expressions.filter(function (v) { return v.name === top_level_var_name; });
        if (objs.length === 1) {
            // we found our top level object
            var obj = objs[0];
            var name_to_find = top_level_var_name;
            for (var i = 0; i < children_names.length; i++) {
                // append the '.' and field name to find as a child of the object we're looking at
                name_to_find += "." + children_names[i];
                var child_obj = GdbVariable.get_child_with_name(obj.children, name_to_find);
                if (child_obj) {
                    // our new object to search is this child
                    obj = child_obj;
                }
                else {
                    console.error("could not find " + name_to_find);
                    return undefined;
                }
            }
            return obj;
        }
        else if (objs.length === 0) {
            return undefined;
        }
        else {
            console.error("Somehow found multiple local gdb variables with the name " + top_level_var_name + ". Not using any of them. File a bug report with the developer.");
            return undefined;
        }
    };
    return GdbVariable;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));
/* harmony default export */ __webpack_exports__["default"] = (GdbVariable);


/***/ }),

/***/ "./gdbgui/src/js/GdbguiModal.tsx":
/*!***************************************!*\
  !*** ./gdbgui/src/js/GdbguiModal.tsx ***!
  \***************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Actions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Actions */ "./gdbgui/src/js/Actions.ts");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_2__);
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



var Modal = /** @class */ (function (_super) {
    __extends(Modal, _super);
    function Modal() {
        var _this = 
        // @ts-expect-error ts-migrate(2554) FIXME: Expected 1-2 arguments, but got 0.
        _super.call(this) || this;
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'connectComponentState' does not exist on... Remove this comment to see the full error message
        statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].connectComponentState(_this, ["show_modal", "modal_body", "modal_header"]);
        return _this;
    }
    Modal.prototype.render = function () {
        var _this = this;
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: this.state.show_modal ? "fullscreen_modal" : "hidden", ref: function (el) { return (_this.fullscreen_node = el); }, onClick: function (e) {
                if (e.target === _this.fullscreen_node) {
                    _Actions__WEBPACK_IMPORTED_MODULE_1__["default"].toggle_modal_visibility();
                }
            } },
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "modal_content" },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { type: "button", className: "close", onClick: _Actions__WEBPACK_IMPORTED_MODULE_1__["default"].toggle_modal_visibility }, "\u00D7")),
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("h4", null, this.state.modal_header),
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { style: { paddingBottom: "20px" } }, this.state.modal_body),
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { style: { float: "right" }, type: "button", className: "btn btn-success", onClick: _Actions__WEBPACK_IMPORTED_MODULE_1__["default"].toggle_modal_visibility }, "Close"),
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { style: { paddingBottom: "30px" } }))));
    };
    return Modal;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));
/* harmony default export */ __webpack_exports__["default"] = (Modal);


/***/ }),

/***/ "./gdbgui/src/js/GlobalEvents.ts":
/*!***************************************!*\
  !*** ./gdbgui/src/js/GlobalEvents.ts ***!
  \***************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "./gdbgui/src/js/constants.ts");
/* harmony import */ var _GdbApi__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./GdbApi */ "./gdbgui/src/js/GdbApi.tsx");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_2__);
/**
 * Setup global DOM events
 */



var GlobalEvents = {
    init: function () {
        window.onkeydown = function (e) {
            if (e.keyCode === _constants__WEBPACK_IMPORTED_MODULE_0__["default"].ENTER_BUTTON_NUM) {
                // when pressing enter in an input, don't redirect entire page!
                e.preventDefault();
            }
        };
        $("body").on("keydown", GlobalEvents.body_keydown);
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'tooltip' does not exist on type 'JQuery<... Remove this comment to see the full error message
        $('[data-toggle="tooltip"]').tooltip();
        window.onbeforeunload = function () {
            return "text here makes dialog appear when exiting. Set function to back to null for nomal behavior.";
        };
    },
    /**
     * keyboard shortcuts to interact with gdb.
     * enabled only when key is depressed on a target that is NOT an input.
     */
    body_keydown: function (e) {
        var modifier = e.altKey || e.ctrlKey || e.metaKey;
        if (e.target.nodeName !== "INPUT" && !modifier) {
            var char = String.fromCharCode(e.keyCode).toLowerCase();
            if (e.keyCode === _constants__WEBPACK_IMPORTED_MODULE_0__["default"].DOWN_BUTTON_NUM || char === "s") {
                _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].click_step_button();
            }
            else if (e.keyCode === _constants__WEBPACK_IMPORTED_MODULE_0__["default"].RIGHT_BUTTON_NUM) {
                _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].click_next_button();
            }
            else if (char === "n") {
                _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].click_next_button(e.shiftKey);
            }
            else if (char === "c") {
                _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].click_continue_button(e.shiftKey);
            }
            else if (e.keyCode === _constants__WEBPACK_IMPORTED_MODULE_0__["default"].UP_BUTTON_NUM || char === "u") {
                _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].click_return_button();
            }
            else if (char === "r") {
                _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].click_run_button();
            }
            else if (char === "m") {
                _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].click_next_instruction_button(e.shiftKey);
            }
            else if (e.keyCode === _constants__WEBPACK_IMPORTED_MODULE_0__["default"].COMMA_BUTTON_NUM) {
                _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].click_step_instruction_button(e.shiftKey);
            }
            else if (e.keyCode === _constants__WEBPACK_IMPORTED_MODULE_0__["default"].LEFT_BUTTON_NUM &&
                statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].get("reverse_supported")) {
                _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].click_next_button(true);
            }
        }
    }
};
/* harmony default export */ __webpack_exports__["default"] = (GlobalEvents);


/***/ }),

/***/ "./gdbgui/src/js/HoverVar.tsx":
/*!************************************!*\
  !*** ./gdbgui/src/js/HoverVar.tsx ***!
  \************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./gdbgui/src/js/constants.ts");
/* harmony import */ var _GdbVariable__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./GdbVariable */ "./gdbgui/src/js/GdbVariable.tsx");
/**
 * A component to show/hide variable exploration when hovering over a variable
 * in the source code
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();




var HoverVar = /** @class */ (function (_super) {
    __extends(HoverVar, _super);
    function HoverVar() {
        var _this = 
        // @ts-expect-error ts-migrate(2554) FIXME: Expected 1-2 arguments, but got 0.
        _super.call(this) || this;
        // when hovering over a potential variable
        $("body").on("mouseover", "#code_table span.n", HoverVar.mouseover_variable);
        $("body").on("mouseleave", "#code_table span.n", HoverVar.mouseout_variable);
        $("body").on("mouseover", "#code_table span.nx", HoverVar.mouseover_variable);
        $("body").on("mouseleave", "#code_table span.nx", HoverVar.mouseout_variable);
        // when hovering over the hover var "tooltip"-like window
        $("body").on("mouseenter", "#hovervar", HoverVar.mouseover_hover_window);
        $("body").on("mouseleave", "#hovervar", HoverVar.mouseout_hover_window);
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'connectComponentState' does not exist on... Remove this comment to see the full error message
        statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].connectComponentState(_this, ["expressions"]);
        return _this;
    }
    HoverVar.prototype.render = function () {
        var hover_objs = statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("expressions").filter(function (o) { return o.expr_type === "hover"; }), obj;
        if (Array.isArray(hover_objs) && hover_objs.length === 1) {
            obj = hover_objs[0];
        }
        this.obj = obj;
        if (obj) {
            var style = {
                position: "absolute",
                left: HoverVar.left + "px",
                top: HoverVar.top + "px",
                backgroundColor: "white"
            };
            return (
            // @ts-expect-error ts-migrate(2322) FIXME: Type 'string' is not assignable to type '"absolute... Remove this comment to see the full error message
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { style: style, id: "hovervar" },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_GdbVariable__WEBPACK_IMPORTED_MODULE_3__["default"]
                // @ts-expect-error ts-migrate(2769) FIXME: Property 'obj' does not exist on type 'IntrinsicAt... Remove this comment to see the full error message
                , { 
                    // @ts-expect-error ts-migrate(2769) FIXME: Property 'obj' does not exist on type 'IntrinsicAt... Remove this comment to see the full error message
                    obj: obj, key: obj.expression, expression: obj.expression, expr_type: "hover" })));
        }
        else {
            return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "hidden" }, "no variable hovered");
        }
    };
    HoverVar.mouseover_variable = function (e) {
        HoverVar.clear_hover_state();
        var rect = e.target.getBoundingClientRect(), var_name = e.target.textContent;
        // store coordinates of where the box should be displayed
        HoverVar.left = rect.left;
        HoverVar.top = rect.bottom;
        var WAIT_TIME_SEC = 0.5;
        // @ts-expect-error ts-migrate(2322) FIXME: Type 'Timeout' is not assignable to type 'undefine... Remove this comment to see the full error message
        HoverVar.enter_timeout = setTimeout(function () {
            if (statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("inferior_program") === _constants__WEBPACK_IMPORTED_MODULE_2__["default"].inferior_states.paused) {
                var ignore_errors = true;
                // @ts-expect-error ts-migrate(2554) FIXME: Expected 2 arguments, but got 3.
                _GdbVariable__WEBPACK_IMPORTED_MODULE_3__["default"].create_variable(var_name, "hover", ignore_errors);
            }
        }, WAIT_TIME_SEC * 1000);
    };
    HoverVar.mouseout_variable = function (e) {
        void e;
        var WAIT_TIME_SEC = 0.1;
        // @ts-expect-error ts-migrate(2322) FIXME: Type 'Timeout' is not assignable to type 'undefine... Remove this comment to see the full error message
        HoverVar.exit_timeout = setTimeout(function () {
            HoverVar.clear_hover_state();
        }, WAIT_TIME_SEC * 1000);
    };
    HoverVar.mouseover_hover_window = function (e) {
        void e;
        // Mouse went from hovering over variable name in source code to
        // hovering over the window showing the contents of the variable.
        // Don't remove the window in this case.
        clearTimeout(HoverVar.exit_timeout);
    };
    HoverVar.mouseout_hover_window = function (e) {
        void e;
        HoverVar.clear_hover_state();
    };
    HoverVar.clear_hover_state = function () {
        clearTimeout(HoverVar.enter_timeout);
        clearTimeout(HoverVar.exit_timeout);
        var exprs_objs_to_remove = statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"]
            .get("expressions")
            .filter(function (obj) { return obj.expr_type === "hover"; });
        exprs_objs_to_remove.map(function (obj) { return _GdbVariable__WEBPACK_IMPORTED_MODULE_3__["default"].delete_gdb_variable(obj.name); });
    };
    HoverVar.enter_timeout = undefined; // debounce fetching the expression
    HoverVar.exit_timeout = undefined; // debounce removing the box
    HoverVar.left = 0;
    HoverVar.top = 0;
    return HoverVar;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));
/* harmony default export */ __webpack_exports__["default"] = (HoverVar);


/***/ }),

/***/ "./gdbgui/src/js/InferiorProgramInfo.tsx":
/*!***********************************************!*\
  !*** ./gdbgui/src/js/InferiorProgramInfo.tsx ***!
  \***********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Actions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Actions */ "./gdbgui/src/js/Actions.ts");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_2__);
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



var InferiorProgramInfo = /** @class */ (function (_super) {
    __extends(InferiorProgramInfo, _super);
    function InferiorProgramInfo() {
        var _this = 
        // @ts-expect-error ts-migrate(2554) FIXME: Expected 1-2 arguments, but got 0.
        _super.call(this) || this;
        _this.get_li_for_signal = _this.get_li_for_signal.bind(_this);
        _this.get_dropdown = _this.get_dropdown.bind(_this);
        _this.state = {
            selected_signal: "SIGINT",
            other_pid: ""
        };
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'connectComponentState' does not exist on... Remove this comment to see the full error message
        statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].connectComponentState(_this, ["inferior_pid", "gdb_pid"]);
        return _this;
    }
    InferiorProgramInfo.prototype.get_li_for_signal = function (s, signal_key) {
        var onclick = function () {
            var obj = {};
            // @ts-expect-error ts-migrate(7053) FIXME: Element implicitly has an 'any' type because expre... Remove this comment to see the full error message
            obj[signal_key] = s;
            // @ts-expect-error ts-migrate(2683) FIXME: 'this' implicitly has type 'any' because it does n... Remove this comment to see the full error message
            this.setState(obj);
        }.bind(this);
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("li", { key: s, className: "pointer", value: s, onClick: onclick },
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", null, s + " (" + this.props.signals[s] + ")")));
    };
    InferiorProgramInfo.prototype.get_signal_choices = function (signal_key) {
        var signals = [];
        // push SIGINT and SIGKILL to top
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'signals' does not exist on type 'Readonl... Remove this comment to see the full error message
        for (var s in this.props.signals) {
            if (s === "SIGKILL" || s === "SIGINT") {
                signals.push(this.get_li_for_signal(s, signal_key));
            }
        }
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'signals' does not exist on type 'Readonl... Remove this comment to see the full error message
        for (var s in this.props.signals) {
            if (s !== "SIGKILL" && s !== "SIGINT") {
                signals.push(this.get_li_for_signal(s, signal_key));
            }
        }
        return signals;
    };
    InferiorProgramInfo.prototype.get_dropdown = function () {
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "dropdown btn-group" },
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { className: "btn btn-default btn-xs dropdown-toggle", type: "button", "data-toggle": "dropdown" },
                this.state.selected_signal,
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "caret", style: { marginLeft: "5px" } }, " ")),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("ul", { className: "dropdown-menu", style: { maxHeight: "300px", overflow: "auto" } }, this.get_signal_choices("selected_signal"))));
    };
    InferiorProgramInfo.prototype.render = function () {
        var _this = this;
        var gdb_button = (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { className: "btn btn-default btn-xs", 
            // id="step_instruction_button"
            // style={{marginLeft: '5px'}}
            type: "button", title: "Send signal to gdb", onClick: function () {
                return _Actions__WEBPACK_IMPORTED_MODULE_1__["default"].send_signal(_this.state.selected_signal, _this.state.gdb_pid);
            } }, "gdb (pid " + this.state.gdb_pid + ")"));
        var inferior_button = null;
        if (this.state.inferior_pid) {
            inferior_button = (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { className: "btn btn-default btn-xs", type: "button", title: "Send signal to program being debugged", onClick: function () {
                    return _Actions__WEBPACK_IMPORTED_MODULE_1__["default"].send_signal(_this.state.selected_signal, _this.state.inferior_pid);
                } }, "debug program (pid " + this.state.inferior_pid + ")"));
        }
        var other_input_and_button = (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { disabled: !this.state.other_pid, className: "btn btn-default btn-xs", type: "button", title: "Send signal to custom PID. Enter PID to enable this button.", onClick: function () {
                return _Actions__WEBPACK_IMPORTED_MODULE_1__["default"].send_signal(_this.state.selected_signal, _this.state.other_pid);
            } }, "other pid " + this.state.other_pid));
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", null,
            "send\u00A0",
            this.get_dropdown(),
            "\u00A0to\u00A0",
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "btn-group", role: "group" },
                gdb_button,
                inferior_button),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null,
                other_input_and_button,
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", { placeholder: "pid", style: {
                        display: "inline",
                        height: "25px",
                        width: "75px",
                        border: "1px solid #ccc",
                        borderRadius: "4px"
                    }, onChange: function (e) {
                        _this.setState({ other_pid: e.currentTarget.value });
                    }, value: this.state.other_pid })))); // return
    }; // render
    return InferiorProgramInfo;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component)); // component
/* harmony default export */ __webpack_exports__["default"] = (InferiorProgramInfo);


/***/ }),

/***/ "./gdbgui/src/js/InitialStoreData.ts":
/*!*******************************************!*\
  !*** ./gdbgui/src/js/InitialStoreData.ts ***!
  \*******************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "./gdbgui/src/js/constants.ts");
/* global initial_data */
/* global debug */

/**
 * The initial store data. Keys cannot be added after initialization.
 * All fields in here should be shared by > 1 component, otherwise they should
 * exist as local state for that component.
 */
var initial_store_data = {
    // environment
    // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name 'debug'.
    debug: debug,
    // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name 'initial_data'.
    gdbgui_version: initial_data.gdbgui_version,
    latest_gdbgui_version: "(not fetched)",
    gdb_version: "unknown",
    gdb_version_array: [],
    gdb_pid: undefined,
    // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name 'initial_data'.
    gdb_command: initial_data.gdb_command,
    can_fetch_register_values: true,
    show_settings: false,
    debug_in_reverse: false,
    reverse_supported: false,
    show_modal: false,
    modal_header: null,
    modal_body: null,
    show_tour_guide: true,
    tour_guide_step: 0,
    num_tour_guide_steps: 0,
    tooltip: { hidden: false, content: "placeholder", node: null, show_for_n_sec: null },
    textarea_to_copy_to_clipboard: {},
    // preferences
    // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name 'initial_data'.
    themes: initial_data.themes,
    // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name 'initial_data'.
    current_theme: localStorage.getItem("theme") || initial_data.themes[0],
    highlight_source_code: true,
    max_lines_of_code_to_fetch: _constants__WEBPACK_IMPORTED_MODULE_0__["default"].default_max_lines_of_code_to_fetch,
    auto_add_breakpoint_to_main: true,
    pretty_print: true,
    refresh_state_after_sending_console_command: true,
    // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name 'debug'.
    show_all_sent_commands_in_console: debug,
    inferior_program: _constants__WEBPACK_IMPORTED_MODULE_0__["default"].inferior_states.unknown,
    inferior_pid: null,
    paused_on_frame: undefined,
    selected_frame_num: 0,
    current_thread_id: undefined,
    stack: [],
    locals: [],
    threads: [],
    // source files
    source_file_paths: [],
    language: "c_family",
    files_being_fetched: [],
    fullname_to_render: null,
    line_of_source_to_flash: null,
    current_assembly_address: null,
    // rendered_source: {},
    make_current_line_visible: false,
    cached_source_files: [],
    disassembly_for_missing_file: [],
    missing_files: [],
    source_code_state: _constants__WEBPACK_IMPORTED_MODULE_0__["default"].source_code_states.NONE_AVAILABLE,
    source_code_selection_state: _constants__WEBPACK_IMPORTED_MODULE_0__["default"].source_code_selection_states.PAUSED_FRAME,
    source_code_infinite_scrolling: false,
    source_linenum_to_display_start: 0,
    source_linenum_to_display_end: 0,
    // binary selection
    inferior_binary_path: null,
    inferior_binary_path_last_modified_unix_sec: null,
    // registers
    register_names: [],
    previous_register_values: {},
    current_register_values: {},
    // memory
    memory_cache: {},
    start_addr: "",
    end_addr: "",
    bytes_per_line: "8",
    // breakpoints
    breakpoints: [],
    // expressions
    expressions: [],
    root_gdb_tree_var: null,
    waiting_for_response: false,
    gdb_mi_output: [],
    gdb_autocomplete_options: [],
    gdb_console_entries: [],
    // if we try to write something before the websocket is connected, store it here
    queuedGdbCommands: [],
    show_filesystem: false,
    middle_panes_split_obj: {},
    gdbguiPty: null
};
function get_stored(key, default_val) {
    try {
        if (localStorage.hasOwnProperty(key)) {
            // @ts-expect-error ts-migrate(2345) FIXME: Type 'null' is not assignable to type 'string'.
            var cached = JSON.parse(localStorage.getItem(key));
            if (typeof cached === typeof default_val) {
                return cached;
            }
            return default_val;
        }
    }
    catch (err) {
        console.error(err);
    }
    localStorage.removeItem(key);
    return default_val;
}
// restore saved localStorage data
for (var key in initial_store_data) {
    // @ts-expect-error ts-migrate(7053) FIXME: No index signature with a parameter of type 'strin... Remove this comment to see the full error message
    var default_val = initial_store_data[key];
    // @ts-expect-error ts-migrate(7053) FIXME: No index signature with a parameter of type 'strin... Remove this comment to see the full error message
    initial_store_data[key] = get_stored(key, default_val);
}
if (localStorage.hasOwnProperty("max_lines_of_code_to_fetch")) {
    // @ts-expect-error ts-migrate(2345) FIXME: Type 'null' is not assignable to type 'string'.
    var savedval = JSON.parse(localStorage.getItem("max_lines_of_code_to_fetch"));
    // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
    if (_.isInteger(savedval) && savedval > 0) {
        initial_store_data["max_lines_of_code_to_fetch"] = savedval;
    }
}
/* harmony default export */ __webpack_exports__["default"] = (initial_store_data);


/***/ }),

/***/ "./gdbgui/src/js/Links.tsx":
/*!*********************************!*\
  !*** ./gdbgui/src/js/Links.tsx ***!
  \*********************************/
/*! exports provided: FileLink, FrameLink */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FileLink", function() { return FileLink; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FrameLink", function() { return FrameLink; });
/* harmony import */ var _Actions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Actions */ "./gdbgui/src/js/Actions.ts");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _CopyToClipboard__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CopyToClipboard */ "./gdbgui/src/js/CopyToClipboard.tsx");
/* harmony import */ var _MemoryLink__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MemoryLink */ "./gdbgui/src/js/MemoryLink.tsx");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();




var FileLink = /** @class */ (function (_super) {
    __extends(FileLink, _super);
    function FileLink() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    FileLink.prototype.render = function () {
        var _this = this;
        var line = parseInt(this.props.line);
        var onclick = function () { }, cls = "";
        if (!this.props.file || !line) {
            line = 0;
        }
        var sep = "";
        if (line && line !== 0) {
            sep = ":";
        }
        if (this.props.fullname) {
            onclick = function () { return _Actions__WEBPACK_IMPORTED_MODULE_0__["default"].view_file(_this.props.fullname, line); };
            cls = "pointer";
        }
        var clipboard_content = null;
        if (this.props.fullname || this.props.file) {
            clipboard_content = (this.props.fullname || this.props.file) + sep + line;
        }
        return (react__WEBPACK_IMPORTED_MODULE_1__["createElement"]("div", { style: { display: "inline-block", whiteSpace: "nowrap" } },
            react__WEBPACK_IMPORTED_MODULE_1__["createElement"]("span", { onClick: onclick, className: cls, title: "click to view " + this.props.fullname, style: { display: "inline" } },
                this.props.file,
                sep,
                line > 0 ? line : ""),
            react__WEBPACK_IMPORTED_MODULE_1__["createElement"](_CopyToClipboard__WEBPACK_IMPORTED_MODULE_2__["default"], { content: clipboard_content }),
            this.props.num_lines ? "(" + this.props.num_lines + " lines total)" : ""));
    };
    return FileLink;
}(react__WEBPACK_IMPORTED_MODULE_1__["Component"]));

var FrameLink = /** @class */ (function (_super) {
    __extends(FrameLink, _super);
    function FrameLink() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    FrameLink.prototype.render = function () {
        return (react__WEBPACK_IMPORTED_MODULE_1__["createElement"]("div", null,
            react__WEBPACK_IMPORTED_MODULE_1__["createElement"](FileLink, { fullname: this.props.fullname, file: this.props.file, line: this.props.line }),
            react__WEBPACK_IMPORTED_MODULE_1__["createElement"]("span", { style: { whiteSpace: "pre" } }, " "),
            react__WEBPACK_IMPORTED_MODULE_1__["createElement"](_MemoryLink__WEBPACK_IMPORTED_MODULE_3__["default"], { addr: this.props.addr })));
    };
    return FrameLink;
}(react__WEBPACK_IMPORTED_MODULE_1__["Component"]));



/***/ }),

/***/ "./gdbgui/src/js/Locals.tsx":
/*!**********************************!*\
  !*** ./gdbgui/src/js/Locals.tsx ***!
  \**********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _GdbVariable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./GdbVariable */ "./gdbgui/src/js/GdbVariable.tsx");
/**
 * A component to render "local" variables, as well as a few static methods to
 * assist in their creation and deletion.
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (undefined && undefined.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};



var Locals = /** @class */ (function (_super) {
    __extends(Locals, _super);
    function Locals() {
        var _this = 
        // @ts-expect-error ts-migrate(2554) FIXME: Expected 1-2 arguments, but got 0.
        _super.call(this) || this;
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'connectComponentState' does not exist on... Remove this comment to see the full error message
        statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].connectComponentState(_this, ["expressions", "locals"]);
        return _this;
    }
    Locals.prototype.render = function () {
        var e_1, _a;
        var content = [];
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
        var sorted_local_objs = _.sortBy(statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("locals"), function (unsorted_obj) { return unsorted_obj.name; });
        try {
            for (var sorted_local_objs_1 = __values(sorted_local_objs), sorted_local_objs_1_1 = sorted_local_objs_1.next(); !sorted_local_objs_1_1.done; sorted_local_objs_1_1 = sorted_local_objs_1.next()) {
                var local = sorted_local_objs_1_1.value;
                var obj = this.get_autocreated_obj_from_expr(local.name);
                if (obj) {
                    content.push(react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_GdbVariable__WEBPACK_IMPORTED_MODULE_2__["default"]
                    // @ts-expect-error ts-migrate(2769) FIXME: Property 'obj' does not exist on type 'IntrinsicAt... Remove this comment to see the full error message
                    , { 
                        // @ts-expect-error ts-migrate(2769) FIXME: Property 'obj' does not exist on type 'IntrinsicAt... Remove this comment to see the full error message
                        obj: obj, key: obj.expression, expression: obj.expression, expr_type: "expr" }));
                }
                else {
                    content.push(react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_GdbVariable__WEBPACK_IMPORTED_MODULE_2__["default"]
                    // @ts-expect-error ts-migrate(2769) FIXME: Property 'obj' does not exist on type 'IntrinsicAt... Remove this comment to see the full error message
                    , { 
                        // @ts-expect-error ts-migrate(2769) FIXME: Property 'obj' does not exist on type 'IntrinsicAt... Remove this comment to see the full error message
                        obj: local, key: local.name, expression: local.name, expr_type: "local" }));
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (sorted_local_objs_1_1 && !sorted_local_objs_1_1.done && (_a = sorted_local_objs_1.return)) _a.call(sorted_local_objs_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        if (content.length === 0) {
            return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { key: "empty", className: "placeholder" }, "no locals in this context"));
        }
        else {
            return content;
        }
    };
    Locals.prototype.get_autocreated_obj_from_expr = function (expr) {
        var e_2, _a;
        try {
            for (var _b = __values(statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("expressions")), _c = _b.next(); !_c.done; _c = _b.next()) {
                var obj = _c.value;
                if (obj.expression === expr && obj.expr_type === "local") {
                    return obj;
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return null;
    };
    Locals.clear_autocreated_exprs = function () {
        var exprs_objs_to_remove = statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"]
            .get("expressions")
            .filter(function (obj) { return obj.expr_type === "local"; });
        exprs_objs_to_remove.map(function (obj) { return _GdbVariable__WEBPACK_IMPORTED_MODULE_2__["default"].delete_gdb_variable(obj.name); });
    };
    Locals.clear = function () {
        statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("locals", []);
        Locals.clear_autocreated_exprs();
    };
    Locals.save_locals = function (locals) {
        var locals_with_meta = locals.map(function (local) {
            // add field to local
            local.can_be_expanded = Locals.can_local_be_expanded(local) ? true : false;
            return local;
        });
        statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("locals", locals_with_meta);
    };
    Locals.can_local_be_expanded = function (local) {
        // gdb returns list of locals. We may want to turn that local into a GdbVariable
        // to explore its children
        if ("value" in local) {
            // local has a value associated with it. It's either a native
            // type or a pointer. It's not a complex type like a struct.
            if (local.type.indexOf("*") !== -1) {
                // make plus if value is a pointer (has asterisk)
                // and can therefore be evaluated further by gdb
                return true;
            }
            else {
                return false;
            }
        }
        else {
            // is a struct or object that can be evaluated further by gdb
            return true;
        }
    };
    return Locals;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));
/* harmony default export */ __webpack_exports__["default"] = (Locals);


/***/ }),

/***/ "./gdbgui/src/js/Memory.tsx":
/*!**********************************!*\
  !*** ./gdbgui/src/js/Memory.tsx ***!
  \**********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _GdbApi__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./GdbApi */ "./gdbgui/src/js/GdbApi.tsx");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./gdbgui/src/js/constants.ts");
/* harmony import */ var _ReactTable__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ReactTable */ "./gdbgui/src/js/ReactTable.tsx");
/* harmony import */ var _MemoryLink_tsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./MemoryLink.tsx */ "./gdbgui/src/js/MemoryLink.tsx");
/* harmony import */ var _Actions__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Actions */ "./gdbgui/src/js/Actions.ts");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);
/**
 * The Memory component allows the user to view
 * data stored at memory locations. It has some
 * static methods used by other objects to turn text into a clickable
 * address. It also has methods to manage the global store of memory data.
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();




// @ts-expect-error ts-migrate(2691) FIXME: An import path cannot end with a '.tsx' extension.... Remove this comment to see the full error message



var Memory = /** @class */ (function (_super) {
    __extends(Memory, _super);
    function Memory() {
        var _this = 
        // @ts-expect-error ts-migrate(2554) FIXME: Expected 1-2 arguments, but got 0.
        _super.call(this) || this;
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'connectComponentState' does not exist on... Remove this comment to see the full error message
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].connectComponentState(_this, [
            "memory_cache",
            "start_addr",
            "end_addr",
            "bytes_per_line"
        ]);
        return _this;
    }
    Memory.prototype.get_memory_component_jsx_content = function () {
        if (Object.keys(statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("memory_cache")).length === 0) {
            return (react__WEBPACK_IMPORTED_MODULE_6___default.a.createElement("span", { key: "nothing", className: "placeholder" }, "no memory to display"));
        }
        var data = [], hex_vals_for_this_addr = [], char_vals_for_this_addr = [], i = 0, hex_addr_to_display = null;
        var bytes_per_line = parseInt(statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("bytes_per_line")) || Memory.DEFAULT_BYTES_PER_LINE;
        bytes_per_line = Math.max(bytes_per_line, 1);
        data.push([
            react__WEBPACK_IMPORTED_MODULE_6___default.a.createElement("span", { key: "moretop", className: "pointer", style: { fontStyle: "italic", fontSize: "0.8em" }, onClick: Memory.click_read_preceding_memory }, "more"),
            "",
            ""
        ]);
        for (var hex_addr in statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("memory_cache")) {
            if (!hex_addr_to_display) {
                hex_addr_to_display = hex_addr;
            }
            if (i % bytes_per_line === 0 && hex_vals_for_this_addr.length > 0) {
                // begin new row
                data.push([
                    Memory.make_addrs_into_links_react(hex_addr_to_display),
                    hex_vals_for_this_addr.join(" "),
                    char_vals_for_this_addr
                ]);
                // update which address we're collecting values for
                i = 0;
                hex_addr_to_display = hex_addr;
                hex_vals_for_this_addr = [];
                char_vals_for_this_addr = [];
            }
            var hex_value = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("memory_cache")[hex_addr];
            hex_vals_for_this_addr.push(hex_value);
            var char = String.fromCharCode(parseInt(hex_value, 16)).replace(/\W/g, ".");
            char_vals_for_this_addr.push(react__WEBPACK_IMPORTED_MODULE_6___default.a.createElement("span", { key: i, className: "memory_char" }, char));
            i++;
        }
        if (hex_vals_for_this_addr.length > 0) {
            // memory range requested wasn't divisible by bytes per line
            // add the remaining memory
            data.push([
                Memory.make_addrs_into_links_react(hex_addr_to_display),
                hex_vals_for_this_addr.join(" "),
                char_vals_for_this_addr
            ]);
        }
        if (Object.keys(statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("memory_cache")).length > 0) {
            data.push([
                react__WEBPACK_IMPORTED_MODULE_6___default.a.createElement("span", { key: "morebottom", className: "pointer", style: { fontStyle: "italic", fontSize: "0.8em" }, onClick: Memory.click_read_more_memory }, "more"),
                "",
                ""
            ]);
        }
        // @ts-expect-error ts-migrate(2769) FIXME: Type 'string' is not assignable to type 'never'.
        return react__WEBPACK_IMPORTED_MODULE_6___default.a.createElement(_ReactTable__WEBPACK_IMPORTED_MODULE_3__["default"], { data: data, header: ["address", "hex", "char"] });
    };
    Memory.prototype.render = function () {
        var input_style = {
            display: "inline",
            width: "100px",
            padding: "6px 6px",
            height: "25px",
            fontSize: "1em"
        }, content = this.get_memory_component_jsx_content();
        return (react__WEBPACK_IMPORTED_MODULE_6___default.a.createElement("div", null,
            react__WEBPACK_IMPORTED_MODULE_6___default.a.createElement("input", { id: "memory_start_address", className: "form-control", placeholder: "start address (hex)", style: input_style, value: this.state.start_addr, onKeyUp: Memory.keypress_on_input, onChange: function (e) {
                    statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("start_addr", e.target.value);
                } }),
            react__WEBPACK_IMPORTED_MODULE_6___default.a.createElement("input", { id: "memory_end_address", className: "form-control", placeholder: "end address (hex)", style: input_style, value: this.state.end_addr, onKeyUp: Memory.keypress_on_input, onChange: function (e) {
                    statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("end_addr", e.target.value);
                } }),
            react__WEBPACK_IMPORTED_MODULE_6___default.a.createElement("input", { id: "memory_bytes_per_line", className: "form-control", placeholder: "bytes per line (dec)", style: input_style, value: this.state.bytes_per_line, onKeyUp: Memory.keypress_on_input, onChange: function (e) {
                    statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("bytes_per_line", e.target.value);
                } }),
            content));
    };
    Memory.keypress_on_input = function (e) {
        if (e.keyCode === _constants__WEBPACK_IMPORTED_MODULE_2__["default"].ENTER_BUTTON_NUM) {
            Memory.fetch_memory_from_state();
        }
    };
    Memory.set_inputs_from_address = function (addr) {
        // set inputs in DOM
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("start_addr", "0x" + parseInt(addr, 16).toString(16));
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("end_addr", "0x" + (parseInt(addr, 16) + Memory.DEFAULT_ADDRESS_DELTA_BYTES).toString(16));
        Memory.fetch_memory_from_state();
    };
    Memory.get_gdb_commands_from_state = function () {
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
        var start_addr = parseInt(_.trim(statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("start_addr")), 16), 
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
        end_addr = parseInt(_.trim(statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("end_addr")), 16);
        if (!window.isNaN(start_addr) && window.isNaN(end_addr)) {
            end_addr = start_addr + Memory.DEFAULT_ADDRESS_DELTA_BYTES;
        }
        var cmds = [];
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
        if (_.isInteger(start_addr) && end_addr) {
            if (start_addr > end_addr) {
                end_addr = start_addr + Memory.DEFAULT_ADDRESS_DELTA_BYTES;
                statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("end_addr", "0x" + end_addr.toString(16));
            }
            else if (end_addr - start_addr > Memory.MAX_ADDRESS_DELTA_BYTES) {
                var orig_end_addr = end_addr;
                end_addr = start_addr + Memory.MAX_ADDRESS_DELTA_BYTES;
                statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("end_addr", "0x" + end_addr.toString(16));
                _Actions__WEBPACK_IMPORTED_MODULE_5__["default"].add_console_entries("Cannot fetch " + (orig_end_addr -
                    start_addr) + " bytes. Changed end address to " + statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("end_addr") + " since maximum bytes gdbgui allows is " + Memory.MAX_ADDRESS_DELTA_BYTES + ".", _constants__WEBPACK_IMPORTED_MODULE_2__["default"].console_entry_type.STD_ERR);
            }
            var cur_addr = start_addr;
            while (cur_addr <= end_addr) {
                // TODO read more than 1 byte at a time?
                cmds.push("-data-read-memory-bytes " + ("0x" + cur_addr.toString(16)) + " 1");
                cur_addr = cur_addr + 1;
            }
        }
        if (!window.isNaN(start_addr)) {
            statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("start_addr", "0x" + start_addr.toString(16));
        }
        if (!window.isNaN(end_addr)) {
            statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("end_addr", "0x" + end_addr.toString(16));
        }
        return cmds;
    };
    Memory.fetch_memory_from_state = function () {
        var cmds = Memory.get_gdb_commands_from_state();
        Memory.clear_cache();
        _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].run_gdb_command(cmds);
    };
    Memory.click_read_preceding_memory = function () {
        // update starting value, then re-fetch
        var NUM_ROWS = 3;
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
        var start_addr = parseInt(_.trim(statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("start_addr")), 16), byte_offset = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("bytes_per_line") * NUM_ROWS;
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("start_addr", "0x" + (start_addr - byte_offset).toString(16));
        Memory.fetch_memory_from_state();
    };
    Memory.click_read_more_memory = function () {
        // update ending value, then re-fetch
        var NUM_ROWS = 3;
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
        var end_addr = parseInt(_.trim(statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("end_addr")), 16), byte_offset = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("bytes_per_line") * NUM_ROWS;
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("end_addr", "0x" + (end_addr + byte_offset).toString(16));
        Memory.fetch_memory_from_state();
    };
    /**
     * @param text: string to convert address-like text into clickable components
     * return react component
     */
    Memory.make_addrs_into_links_react = function (text) {
        var matches = text.match(/(0x[\d\w]+)/g);
        if (text && matches && matches.length) {
            var addr = matches[0];
            var leading_text = text.slice(0, text.indexOf(addr));
            var trailing_text = text.slice(text.indexOf(addr) + addr.length, text.length);
            var suffix_component = trailing_text;
            if (trailing_text) {
                // recursive call to turn additional addressed after the first
                suffix_component = Memory.make_addrs_into_links_react(trailing_text);
            }
            return (react__WEBPACK_IMPORTED_MODULE_6___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_6___default.a.Fragment, null,
                leading_text,
                react__WEBPACK_IMPORTED_MODULE_6___default.a.createElement(_MemoryLink_tsx__WEBPACK_IMPORTED_MODULE_4__["default"], { addr: addr }),
                suffix_component));
        }
        else {
            return text;
        }
    };
    Memory.add_value_to_cache = function (hex_str, hex_val) {
        // strip leading zeros off address provided by gdb
        // i.e. 0x000123 turns to
        // 0x123
        var hex_str_truncated = "0x" + parseInt(hex_str, 16).toString(16);
        var cache = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("memory_cache");
        cache[hex_str_truncated] = hex_val;
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("memory_cache", cache);
    };
    Memory.clear_cache = function () {
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("memory_cache", {});
    };
    Memory.MAX_ADDRESS_DELTA_BYTES = 1000;
    Memory.DEFAULT_ADDRESS_DELTA_BYTES = 31;
    Memory.DEFAULT_BYTES_PER_LINE = 8;
    return Memory;
}(react__WEBPACK_IMPORTED_MODULE_6___default.a.Component));
/* harmony default export */ __webpack_exports__["default"] = (Memory);


/***/ }),

/***/ "./gdbgui/src/js/MemoryLink.tsx":
/*!**************************************!*\
  !*** ./gdbgui/src/js/MemoryLink.tsx ***!
  \**************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Memory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Memory */ "./gdbgui/src/js/Memory.tsx");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


var MemoryLink = /** @class */ (function (_super) {
    __extends(MemoryLink, _super);
    function MemoryLink() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MemoryLink.prototype.render = function () {
        // turn 0x00000000000000 into 0x0
        var address_no_leading_zeros = "0x" + parseInt(this.props.addr, 16).toString(16);
        return (react__WEBPACK_IMPORTED_MODULE_0__["createElement"]("span", { className: "pointer memadr_react", onClick: function () { return _Memory__WEBPACK_IMPORTED_MODULE_1__["default"].set_inputs_from_address(address_no_leading_zeros); }, title: "click to explore memory at " + address_no_leading_zeros, style: this.props.style }, address_no_leading_zeros));
    };
    MemoryLink.defaultProps = { style: { fontFamily: "monospace" } };
    return MemoryLink;
}(react__WEBPACK_IMPORTED_MODULE_0__["Component"]));
/* harmony default export */ __webpack_exports__["default"] = (MemoryLink);


/***/ }),

/***/ "./gdbgui/src/js/MiddleLeft.tsx":
/*!**************************************!*\
  !*** ./gdbgui/src/js/MiddleLeft.tsx ***!
  \**************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _SourceCode__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SourceCode */ "./gdbgui/src/js/SourceCode.tsx");
/* harmony import */ var _FileOps__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./FileOps */ "./gdbgui/src/js/FileOps.tsx");
/**
 * The middle left div will be rendered with this content
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



var MiddleLeft = /** @class */ (function (_super) {
    __extends(MiddleLeft, _super);
    function MiddleLeft() {
        var _this = 
        // @ts-expect-error ts-migrate(2554) FIXME: Expected 1-2 arguments, but got 0.
        _super.call(this) || this;
        _this.onscroll_container = _this.onscroll_container.bind(_this);
        _this.onscroll_timeout = null;
        _this.fetch_more_at_top_timeout = null;
        return _this;
    }
    MiddleLeft.prototype.render = function () {
        var _this = this;
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { id: "code_container", style: { overflow: "auto", height: "100%" }, ref: function (el) { return (_this.source_code_container_node = el); } },
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_SourceCode__WEBPACK_IMPORTED_MODULE_1__["default"], null)));
    };
    MiddleLeft.prototype.componentDidMount = function () {
        // @ts-expect-error ts-migrate(2322) FIXME: Type 'JQuery<HTMLElement>' is not assignable to ty... Remove this comment to see the full error message
        _SourceCode__WEBPACK_IMPORTED_MODULE_1__["default"].el_code_container = $("#code_container"); // todo: no jquery
        if (this.source_code_container_node) {
            this.source_code_container_node.onscroll = this.onscroll_container.bind(this);
        }
    };
    MiddleLeft.prototype.onscroll_container = function () {
        clearTimeout(this.onscroll_timeout);
        this.onscroll_timeout = setTimeout(this.check_to_autofetch_more_source, 100);
    };
    MiddleLeft.prototype.check_to_autofetch_more_source = function () {
        // test if "view more" buttons are visible, and if so, fetch more source
        var fetching_for_top = false; // don't fetch for more at bottom and top at same time
        if (_SourceCode__WEBPACK_IMPORTED_MODULE_1__["default"].view_more_top_node) {
            var is_visible = _SourceCode__WEBPACK_IMPORTED_MODULE_1__["default"].is_source_line_visible(
            // @ts-expect-error ts-migrate(2769) FIXME: Argument of type 'null' is not assignable to param... Remove this comment to see the full error message
            $(_SourceCode__WEBPACK_IMPORTED_MODULE_1__["default"].view_more_top_node)).is_visible;
            if (is_visible) {
                fetching_for_top = true;
                _FileOps__WEBPACK_IMPORTED_MODULE_2__["default"].fetch_more_source_at_beginning();
            }
        }
        if (!fetching_for_top && _SourceCode__WEBPACK_IMPORTED_MODULE_1__["default"].view_more_bottom_node) {
            var is_visible = _SourceCode__WEBPACK_IMPORTED_MODULE_1__["default"].is_source_line_visible(
            // @ts-expect-error ts-migrate(2769) FIXME: Argument of type 'null' is not assignable to param... Remove this comment to see the full error message
            $(_SourceCode__WEBPACK_IMPORTED_MODULE_1__["default"].view_more_bottom_node)).is_visible;
            if (is_visible) {
                _FileOps__WEBPACK_IMPORTED_MODULE_2__["default"].fetch_more_source_at_end();
            }
        }
    };
    return MiddleLeft;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));
/* harmony default export */ __webpack_exports__["default"] = (MiddleLeft);


/***/ }),

/***/ "./gdbgui/src/js/ReactTable.tsx":
/*!**************************************!*\
  !*** ./gdbgui/src/js/ReactTable.tsx ***!
  \**************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (undefined && undefined.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};

var TableRow = /** @class */ (function (_super) {
    __extends(TableRow, _super);
    function TableRow() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TableRow.prototype.get_tds = function () {
        var tds = [];
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'data' does not exist on type 'Readonly<{... Remove this comment to see the full error message
        for (var i in this.props.data) {
            // @ts-expect-error ts-migrate(2339) FIXME: Property 'data' does not exist on type 'Readonly<{... Remove this comment to see the full error message
            tds.push(react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("td", { key: i }, this.props.data[i]));
        }
        return tds;
    };
    TableRow.prototype.render = function () {
        return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("tr", { className: this.className }, this.get_tds());
    };
    return TableRow;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));
var ReactTable = /** @class */ (function (_super) {
    __extends(ReactTable, _super);
    function ReactTable() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ReactTable.prototype.render_row = function (row_data, i) {
        // @ts-expect-error ts-migrate(2769) FIXME: Property 'data' does not exist on type 'IntrinsicA... Remove this comment to see the full error message
        return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(TableRow, { data: row_data, key: i });
    };
    ReactTable.prototype.render_head = function () {
        var e_1, _a;
        var ths = [], i = 0;
        try {
            // @ts-expect-error ts-migrate(2339) FIXME: Property 'header' does not exist on type 'Readonly... Remove this comment to see the full error message
            for (var _b = __values(this.props.header), _c = _b.next(); !_c.done; _c = _b.next()) {
                var th_data = _c.value;
                ths.push(react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("th", { key: i }, th_data));
                i++;
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return ths;
    };
    ReactTable.prototype.render = function () {
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'classes' does not exist on type 'Readonl... Remove this comment to see the full error message
        var classes = ["table", "table-condensed"].concat(this.props.classes);
        return (
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'style' does not exist on type 'Readonly<... Remove this comment to see the full error message
        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("table", { className: classes.join(" "), style: this.props.style },
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("thead", null,
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("tr", null, this.render_head())),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("tbody", null, this.props.data.map(this.render_row))));
    };
    ReactTable.defaultProps = { header: [] };
    return ReactTable;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));
/* harmony default export */ __webpack_exports__["default"] = (ReactTable);


/***/ }),

/***/ "./gdbgui/src/js/Registers.tsx":
/*!*************************************!*\
  !*** ./gdbgui/src/js/Registers.tsx ***!
  \*************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./gdbgui/src/js/constants.ts");
/* harmony import */ var _ReactTable__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ReactTable */ "./gdbgui/src/js/ReactTable.tsx");
/* harmony import */ var _Memory__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Memory */ "./gdbgui/src/js/Memory.tsx");
/* harmony import */ var _GdbApi__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./GdbApi */ "./gdbgui/src/js/GdbApi.tsx");
/* harmony import */ var _register_descriptions__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./register_descriptions */ "./gdbgui/src/js/register_descriptions.ts");
/**
 * A component to display, fetch, and store register
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();







var MAX_REGISTER_NAME_FETCH_COUNT = 5;
var register_name_fetch_count = 0, register_name_fetch_timeout = null;
var Registers = /** @class */ (function (_super) {
    __extends(Registers, _super);
    function Registers() {
        var _this = 
        // @ts-expect-error ts-migrate(2554) FIXME: Expected 1-2 arguments, but got 0.
        _super.call(this) || this;
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'connectComponentState' does not exist on... Remove this comment to see the full error message
        statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].connectComponentState(_this, [
            "inferior_program",
            "previous_register_values",
            "current_register_values",
            "register_names",
            "can_fetch_register_values"
        ]);
        return _this;
    }
    Registers.get_update_cmds = function () {
        var cmds = [];
        if ([_constants__WEBPACK_IMPORTED_MODULE_2__["default"].inferior_states.paused, _constants__WEBPACK_IMPORTED_MODULE_2__["default"].inferior_states.running].indexOf(
        // @ts-expect-error ts-migrate(2345) FIXME: Argument of type 'boolean' is not assignable to pa... Remove this comment to see the full error message
        statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("inferior_program")) == -1) {
            return cmds;
        }
        if (statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("can_fetch_register_values") === true) {
            if (statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("register_names").length === 0) {
                if (register_name_fetch_count <= MAX_REGISTER_NAME_FETCH_COUNT) {
                    clearTimeout(register_name_fetch_timeout);
                    register_name_fetch_count++;
                    // only fetch register names when we don't have them
                    // assumption is that the names don't change over time
                    cmds.push(_constants__WEBPACK_IMPORTED_MODULE_2__["default"].IGNORE_ERRORS_TOKEN_STR + "-data-list-register-names");
                }
                else {
                    register_name_fetch_timeout = setTimeout(function () {
                        register_name_fetch_count--;
                    }, 5000);
                }
            }
            // update all registers values
            cmds.push(_constants__WEBPACK_IMPORTED_MODULE_2__["default"].IGNORE_ERRORS_TOKEN_STR + "-data-list-register-values x");
        }
        else {
            Registers.clear_cached_values();
        }
        return cmds;
    };
    Registers.cache_register_names = function (names) {
        // filter out non-empty names
        statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("register_names", names.filter(function (name) { return name; }));
    };
    Registers.clear_register_name_cache = function () {
        statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("register_names", []);
    };
    Registers.clear_cached_values = function () {
        statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("previous_register_values", {});
        statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("current_register_values", {});
    };
    Registers.inferior_program_exited = function () {
        Registers.clear_cached_values();
    };
    Registers.prototype.render = function () {
        var num_register_names = statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("register_names").length, num_register_values = Object.keys(statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("current_register_values")).length;
        if (this.state.inferior_program !== _constants__WEBPACK_IMPORTED_MODULE_2__["default"].inferior_states.paused) {
            return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "placeholder" }, "no data to display");
        }
        if ((num_register_names > 0 &&
            num_register_values > 0 &&
            num_register_names !== num_register_values) ||
            (num_register_names === 0 &&
                register_name_fetch_count <= MAX_REGISTER_NAME_FETCH_COUNT)) {
            // Somehow register names and values do not match. Clear cached values, then refetch both.
            Registers.clear_register_name_cache();
            Registers.clear_cached_values();
            _GdbApi__WEBPACK_IMPORTED_MODULE_5__["default"].run_gdb_command(Registers.get_update_cmds());
        }
        else if (num_register_names === num_register_values) {
            var columns = ["name", "value (hex)", "value (decimal)", "description"], register_table_data = [], register_names = statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("register_names"), register_values = statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("current_register_values"), prev_register_values = statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("previous_register_values");
            var _loop_1 = function (i) {
                var name = register_names[i], 
                // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
                obj = _.find(register_values, function (v) { return v["number"] === i; }), hex_val_raw = "", disp_hex_val = "", disp_dec_val = "", 
                // @ts-expect-error ts-migrate(7053) FIXME: Element implicitly has an 'any' type because expre... Remove this comment to see the full error message
                register_description = _register_descriptions__WEBPACK_IMPORTED_MODULE_6__["default"][name] || "";
                if (obj && obj.value) {
                    hex_val_raw = obj["value"];
                    // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
                    var old_obj = _.find(prev_register_values, function (v) { return v["number"] === i; }), old_hex_val_raw = void 0, changed = false;
                    if (old_obj) {
                        old_hex_val_raw = old_obj["value"];
                    }
                    // if the value changed, highlight it
                    if (old_hex_val_raw !== undefined && hex_val_raw !== old_hex_val_raw) {
                        changed = true;
                    }
                    // if hex value is a valid value, convert it to a link
                    // and display decimal format too
                    if (obj["value"].indexOf("0x") === 0) {
                        disp_hex_val = _Memory__WEBPACK_IMPORTED_MODULE_4__["default"].make_addrs_into_links_react(hex_val_raw);
                        disp_dec_val = parseInt(obj["value"], 16).toString(10);
                    }
                    if (changed) {
                        name = react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "highlight bold" }, name);
                        // @ts-expect-error ts-migrate(2322) FIXME: Type 'Element' is not assignable to type 'string'.
                        disp_hex_val = react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "highlight bold" }, disp_hex_val);
                        // @ts-expect-error ts-migrate(2322) FIXME: Type 'Element' is not assignable to type 'string'.
                        disp_dec_val = react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "highlight bold" }, disp_dec_val);
                    }
                }
                register_table_data.push([
                    name,
                    disp_hex_val,
                    disp_dec_val,
                    register_description
                ]);
            };
            for (var i in register_names) {
                _loop_1(i);
            }
            return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_ReactTable__WEBPACK_IMPORTED_MODULE_3__["default"], { data: register_table_data, 
                // @ts-expect-error ts-migrate(2769) FIXME: Type 'string[]' is not assignable to type 'never[]... Remove this comment to see the full error message
                header: columns, style: { fontSize: "0.9em" } }));
        }
        return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "placeholder" }, "no data to display");
    };
    return Registers;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));
/* harmony default export */ __webpack_exports__["default"] = (Registers);


/***/ }),

/***/ "./gdbgui/src/js/RightSidebar.tsx":
/*!****************************************!*\
  !*** ./gdbgui/src/js/RightSidebar.tsx ***!
  \****************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Breakpoints__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Breakpoints */ "./gdbgui/src/js/Breakpoints.tsx");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./gdbgui/src/js/constants.ts");
/* harmony import */ var _Expressions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Expressions */ "./gdbgui/src/js/Expressions.tsx");
/* harmony import */ var _GdbMiOutput__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./GdbMiOutput */ "./gdbgui/src/js/GdbMiOutput.tsx");
/* harmony import */ var _InferiorProgramInfo__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./InferiorProgramInfo */ "./gdbgui/src/js/InferiorProgramInfo.tsx");
/* harmony import */ var _Locals__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Locals */ "./gdbgui/src/js/Locals.tsx");
/* harmony import */ var _Memory__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Memory */ "./gdbgui/src/js/Memory.tsx");
/* harmony import */ var _Registers__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Registers */ "./gdbgui/src/js/Registers.tsx");
/* harmony import */ var _Tree__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Tree */ "./gdbgui/src/js/Tree.ts");
/* harmony import */ var _Threads__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Threads */ "./gdbgui/src/js/Threads.tsx");
/* harmony import */ var _ToolTipTourguide__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./ToolTipTourguide */ "./gdbgui/src/js/ToolTipTourguide.tsx");
/**
 * A component to show/hide variable exploration when hovering over a variable
 * in the source code
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();












var onmouseup_in_parent_callbacks = [], onmousemove_in_parent_callbacks = [];
var onmouseup_in_parent_callback = function () {
    // @ts-expect-error ts-migrate(7006) FIXME: Parameter 'fn' implicitly has an 'any' type.
    onmouseup_in_parent_callbacks.map(function (fn) { return fn(); });
};
var onmousemove_in_parent_callback = function (e) {
    // @ts-expect-error ts-migrate(7006) FIXME: Parameter 'fn' implicitly has an 'any' type.
    onmousemove_in_parent_callbacks.map(function (fn) {
        fn(e);
    });
};
var Collapser = /** @class */ (function (_super) {
    __extends(Collapser, _super);
    function Collapser(props) {
        var _this = 
        // @ts-expect-error ts-migrate(2554) FIXME: Expected 1-2 arguments, but got 0.
        _super.call(this) || this;
        _this.state = {
            // @ts-expect-error ts-migrate(2339) FIXME: Property 'collapsed' does not exist on type '{}'.
            collapsed: props.collapsed,
            autosize: true,
            height_px: null,
            _mouse_y_click_pos_px: null,
            _height_when_clicked: null
        };
        _this.onmousedown_resizer = _this.onmousedown_resizer.bind(_this);
        _this.onmouseup_resizer = _this.onmouseup_resizer.bind(_this);
        _this.onmousemove_resizer = _this.onmousemove_resizer.bind(_this);
        _this.onclick_restore_autosize = _this.onclick_restore_autosize.bind(_this);
        onmouseup_in_parent_callbacks.push(_this.onmouseup_resizer.bind(_this));
        onmousemove_in_parent_callbacks.push(_this.onmousemove_resizer.bind(_this));
        return _this;
    }
    Collapser.prototype.toggle_visibility = function () {
        this.setState({ collapsed: !this.state.collapsed });
    };
    Collapser.prototype.onmousedown_resizer = function (e) {
        this._resizing = true;
        this._page_y_orig = e.pageY;
        this._height_when_clicked = this.collapser_box_node.clientHeight;
    };
    Collapser.prototype.onmouseup_resizer = function () {
        this._resizing = false;
    };
    Collapser.prototype.onmousemove_resizer = function (e) {
        if (this._resizing) {
            var dh = e.pageY - this._page_y_orig;
            this.setState({
                height_px: this._height_when_clicked + dh,
                autosize: false
            });
        }
    };
    Collapser.prototype.onclick_restore_autosize = function () {
        this.setState({ autosize: true });
    };
    Collapser.prototype.render = function () {
        var _this = this;
        var style = {
            height: this.state.autosize ? "auto" : this.state.height_px + "px",
            overflow: this.state.autosize ? "visible" : "auto"
        };
        var reset_size_button = "";
        if (!this.state.autosize) {
            // @ts-expect-error ts-migrate(2322) FIXME: Type 'Element' is not assignable to type 'string'.
            reset_size_button = (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { onClick: this.onclick_restore_autosize, className: "placeholder", title: "Height frozen at " + this.state.height_px + "px. Click to restore autosize.", style: {
                    // @ts-expect-error ts-migrate(2322) FIXME: Object literal may only specify known properties, ... Remove this comment to see the full error message
                    align: "right",
                    position: "relative",
                    top: "-10px",
                    cursor: "pointer"
                } }, "reset height"));
        }
        var resizer = "";
        if (!this.state.collapsed) {
            // @ts-expect-error ts-migrate(2322) FIXME: Type 'Element' is not assignable to type 'string'.
            resizer = (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "rowresizer", onMouseDown: this.onmousedown_resizer, style: { textAlign: "right" }, title: "Click and drag to resize height" },
                    " ",
                    reset_size_button)));
        }
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "collapser" },
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "pointer titlebar", onClick: this.toggle_visibility.bind(this) },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "glyphicon glyphicon-chevron-" + (this.state.collapsed ? "right" : "down"), style: { marginRight: "6px" } }),
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "lighttext" }, this.props.title)),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: this.state.collapsed ? "hidden" : "", 
                // @ts-expect-error ts-migrate(2339) FIXME: Property 'id' does not exist on type 'Readonly<{}>... Remove this comment to see the full error message
                id: this.props.id, style: style, ref: function (n) { return (_this.collapser_box_node = n); } }, this.props.content),
            resizer));
    };
    Collapser.defaultProps = { collapsed: false, id: "" };
    return Collapser;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));
var RightSidebar = /** @class */ (function (_super) {
    __extends(RightSidebar, _super);
    function RightSidebar() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    RightSidebar.prototype.render = function () {
        var input_style = {
            display: "inline",
            width: "100px",
            padding: "6px 6px",
            height: "25px",
            fontSize: "1em"
        }, mi_output = "";
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'debug' does not exist on type 'Readonly<... Remove this comment to see the full error message
        if (this.props.debug) {
            // @ts-expect-error ts-migrate(2322) FIXME: Type 'Element' is not assignable to type 'string'.
            mi_output = (
            // @ts-expect-error ts-migrate(2322) FIXME: Property 'title' does not exist on type 'Intrinsic... Remove this comment to see the full error message
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(Collapser, { title: "gdb mi output", content: react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_GdbMiOutput__WEBPACK_IMPORTED_MODULE_4__["default"], { id: "gdb_mi_output" }) }));
        }
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "content", onMouseUp: onmouseup_in_parent_callback, onMouseMove: onmousemove_in_parent_callback },
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_ToolTipTourguide__WEBPACK_IMPORTED_MODULE_11__["default"]
            // @ts-expect-error ts-migrate(2322) FIXME: Property 'position' does not exist on type 'Intrin... Remove this comment to see the full error message
            , { 
                // @ts-expect-error ts-migrate(2322) FIXME: Property 'position' does not exist on type 'Intrin... Remove this comment to see the full error message
                position: "topleft", content: react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("h5", null, "This sidebar contains a visual, interactive representation of the state of your program"),
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, "You can see which function the process is stopped in, explore variables, and much more."),
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, "There is more to discover, but this should be enough to get you started."),
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null,
                        "Something missing? Found a bug?",
                        " ",
                        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", { href: "https://github.com/cs01/gdbgui/issues/" }, "Create an issue"),
                        " on github."),
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, "Happy debugging!")), step_num: 5 }),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(Collapser, { title: "threads", content: react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_Threads__WEBPACK_IMPORTED_MODULE_10__["default"], null) }),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(Collapser, { id: "locals", title: "local variables", content: react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_Locals__WEBPACK_IMPORTED_MODULE_6__["default"], null) }),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(Collapser, { id: "expressions", title: "expressions", content: react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_Expressions__WEBPACK_IMPORTED_MODULE_3__["default"], null) }),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(Collapser
            // @ts-expect-error ts-migrate(2322) FIXME: Property 'title' does not exist on type 'Intrinsic... Remove this comment to see the full error message
            , { 
                // @ts-expect-error ts-migrate(2322) FIXME: Property 'title' does not exist on type 'Intrinsic... Remove this comment to see the full error message
                title: "Tree", content: react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", { id: "tree_width", className: "form-control", placeholder: "width (px)", style: input_style }),
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", { id: "tree_height", className: "form-control", placeholder: "height (px)", style: input_style }),
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { id: _constants__WEBPACK_IMPORTED_MODULE_2__["default"].tree_component_id })) }),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(Collapser, { id: "memory", title: "memory", content: react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_Memory__WEBPACK_IMPORTED_MODULE_7__["default"], null) }),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(Collapser, { title: "breakpoints", content: react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_Breakpoints__WEBPACK_IMPORTED_MODULE_1__["default"], null) }),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(Collapser
            // @ts-expect-error ts-migrate(2322) FIXME: Property 'title' does not exist on type 'Intrinsic... Remove this comment to see the full error message
            , { 
                // @ts-expect-error ts-migrate(2322) FIXME: Property 'title' does not exist on type 'Intrinsic... Remove this comment to see the full error message
                title: "signals", 
                // @ts-expect-error ts-migrate(2322) FIXME: Property 'signals' does not exist on type 'Intrins... Remove this comment to see the full error message
                content: react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_InferiorProgramInfo__WEBPACK_IMPORTED_MODULE_5__["default"], { signals: this.props.signals }) }),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(Collapser, { title: "registers", collapsed: true, content: react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_Registers__WEBPACK_IMPORTED_MODULE_8__["default"], null) }),
            mi_output));
    };
    RightSidebar.prototype.componentDidMount = function () {
        _Tree__WEBPACK_IMPORTED_MODULE_9__["default"].init();
    };
    return RightSidebar;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));
/* harmony default export */ __webpack_exports__["default"] = (RightSidebar);


/***/ }),

/***/ "./gdbgui/src/js/Settings.tsx":
/*!************************************!*\
  !*** ./gdbgui/src/js/Settings.tsx ***!
  \************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Actions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Actions */ "./gdbgui/src/js/Actions.ts");
/* harmony import */ var _ToolTip__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ToolTip */ "./gdbgui/src/js/ToolTip.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();




/**
 * Settings modal when clicking the gear icon
 */
var Settings = /** @class */ (function (_super) {
    __extends(Settings, _super);
    function Settings() {
        var _this = 
        // @ts-expect-error ts-migrate(2554) FIXME: Expected 1-2 arguments, but got 0.
        _super.call(this) || this;
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'connectComponentState' does not exist on... Remove this comment to see the full error message
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].connectComponentState(_this, [
            "debug",
            "current_theme",
            "themes",
            "gdb_version",
            "gdb_pid",
            "show_settings",
            "auto_add_breakpoint_to_main",
            "pretty_print",
            "refresh_state_after_sending_console_command",
            "show_all_sent_commands_in_console",
            "highlight_source_code"
        ]);
        _this.get_update_max_lines_of_code_to_fetch = _this.get_update_max_lines_of_code_to_fetch.bind(_this);
        return _this;
    }
    Settings.toggle_key = function (key) {
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set(key, !statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get(key));
        localStorage.setItem(key, JSON.stringify(statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get(key)));
    };
    Settings.get_checkbox_row = function (store_key, text) {
        return (react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement("tr", null,
            react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement("td", null,
                react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement("div", { className: "checkbox" },
                    react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement("label", null,
                        react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement("input", { type: "checkbox", checked: statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get(store_key), onChange: function () { return Settings.toggle_key(store_key); } }),
                        text)))));
    };
    Settings.prototype.get_update_max_lines_of_code_to_fetch = function () {
        var _this = this;
        return (react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement("tr", null,
            react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement("td", null,
                "Maximum number of source file lines to display:",
                react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement("input", { style: { width: "100px", marginLeft: "10px" }, defaultValue: statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("max_lines_of_code_to_fetch"), ref: function (el) { return (_this.max_source_file_lines_input = el); } }),
                react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement("button", { ref: function (n) { return (_this.save_button = n); }, onClick: function () {
                        var new_value = parseInt(_this.max_source_file_lines_input.value);
                        _Actions__WEBPACK_IMPORTED_MODULE_1__["default"].update_max_lines_of_code_to_fetch(new_value);
                        // @ts-expect-error ts-migrate(2345) FIXME: Argument of type '1' is not assignable to paramete... Remove this comment to see the full error message
                        _ToolTip__WEBPACK_IMPORTED_MODULE_2__["default"].show_tooltip_on_node("saved!", _this.save_button, 1);
                    } }, "save"))));
    };
    Settings.prototype.get_table = function () {
        return (react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement("table", { className: "table table-condensed" },
            react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement("tbody", null,
                Settings.get_checkbox_row("auto_add_breakpoint_to_main", "Add breakpoint to main after loading executable"),
                this.get_update_max_lines_of_code_to_fetch(),
                Settings.get_checkbox_row("pretty_print", "Pretty print dynamic variables (requires restart)"),
                Settings.get_checkbox_row("refresh_state_after_sending_console_command", "Refresh all components when a command is sent from the console"),
                Settings.get_checkbox_row("show_all_sent_commands_in_console", "Print all sent commands in console, including those sent automatically by gdbgui"),
                Settings.get_checkbox_row("highlight_source_code", "Add syntax highlighting to source files"),
                react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement("tr", null,
                    react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement("td", null,
                        "Theme:",
                        " ",
                        react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement("select", { value: statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("current_theme"), onChange: function (e) {
                                statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("current_theme", e.currentTarget.value);
                                localStorage.setItem("theme", e.currentTarget.value);
                            } }, statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("themes").map(function (t) { return (react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement("option", { key: t }, t)); })))))));
    };
    Settings.prototype.render = function () {
        var _this = this;
        return (react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement("div", { className: statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("show_settings") ? "fullscreen_modal" : "hidden", ref: function (el) { return (_this.settings_node = el); }, onClick: function (e) {
                if (e.target === _this.settings_node) {
                    Settings.toggle_key("show_settings");
                }
            } },
            react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement("div", { id: "gdb_settings_modal" },
                react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement("button", { className: "close", onClick: function () { return Settings.toggle_key("show_settings"); } }, "\u00D7"),
                react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement("h4", null, "Settings"),
                this.get_table(),
                react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement("div", { className: "modal-footer", style: { marginTop: "20px" } },
                    react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement("button", { className: "btn btn-success", onClick: function () { return Settings.toggle_key("show_settings"); }, "data-dismiss": "modal" }, "Close")))));
    };
    return Settings;
}(react__WEBPACK_IMPORTED_MODULE_3___default.a.Component));
/* harmony default export */ __webpack_exports__["default"] = (Settings);


/***/ }),

/***/ "./gdbgui/src/js/SourceCode.tsx":
/*!**************************************!*\
  !*** ./gdbgui/src/js/SourceCode.tsx ***!
  \**************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _FileOps__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./FileOps */ "./gdbgui/src/js/FileOps.tsx");
/* harmony import */ var _Breakpoints__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Breakpoints */ "./gdbgui/src/js/Breakpoints.tsx");
/* harmony import */ var _Memory__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Memory */ "./gdbgui/src/js/Memory.tsx");
/* harmony import */ var _MemoryLink__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./MemoryLink */ "./gdbgui/src/js/MemoryLink.tsx");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./constants */ "./gdbgui/src/js/constants.ts");
/* harmony import */ var _Actions__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Actions */ "./gdbgui/src/js/Actions.ts");
/**
 * A component to render source code, assembly, and break points
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (undefined && undefined.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};








var SourceCode = /** @class */ (function (_super) {
    __extends(SourceCode, _super);
    function SourceCode() {
        var _this = 
        // @ts-expect-error ts-migrate(2554) FIXME: Expected 1-2 arguments, but got 0.
        _super.call(this) || this;
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'connectComponentState' does not exist on... Remove this comment to see the full error message
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].connectComponentState(_this, [
            "fullname_to_render",
            "cached_source_files",
            "missing_files",
            "disassembly_for_missing_file",
            "line_of_source_to_flash",
            "paused_on_frame",
            "breakpoints",
            "source_code_state",
            "make_current_line_visible",
            "source_code_selection_state",
            "current_theme",
            "inferior_binary_path",
            "source_linenum_to_display_start",
            "source_linenum_to_display_end",
            "max_lines_of_code_to_fetch",
            "source_code_infinite_scrolling"
        ]);
        // bind methods
        _this.get_body_assembly_only = _this.get_body_assembly_only.bind(_this);
        _this._get_source_line = _this._get_source_line.bind(_this);
        _this._get_assm_row = _this._get_assm_row.bind(_this);
        _this.click_gutter = _this.click_gutter.bind(_this);
        _this.is_gdb_paused_on_this_line = _this.is_gdb_paused_on_this_line.bind(_this);
        return _this;
    }
    SourceCode.prototype.render = function () {
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: this.state.current_theme, style: { height: "100%" } },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("table", { id: "code_table", className: this.state.current_theme, style: { width: "100%" } },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("tbody", { id: "code_body" }, this.get_body()))));
    };
    SourceCode.prototype.componentDidUpdate = function () {
        var source_is_displayed = this.state.source_code_state === _constants__WEBPACK_IMPORTED_MODULE_6__["default"].source_code_states.SOURCE_CACHED ||
            this.state.source_code_state ===
                _constants__WEBPACK_IMPORTED_MODULE_6__["default"].source_code_states.ASSM_AND_SOURCE_CACHED;
        if (source_is_displayed) {
            if (this.state.make_current_line_visible) {
                var success = SourceCode.make_current_line_visible();
                if (success) {
                    statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("make_current_line_visible", false);
                }
            }
        }
    };
    SourceCode.prototype.get_body = function () {
        var states = _constants__WEBPACK_IMPORTED_MODULE_6__["default"].source_code_states;
        switch (this.state.source_code_state) {
            case states.ASSM_AND_SOURCE_CACHED: // fallthrough
            case states.SOURCE_CACHED: {
                var obj = _FileOps__WEBPACK_IMPORTED_MODULE_2__["default"].get_source_file_obj_from_cache(this.state.fullname_to_render);
                if (!obj) {
                    console.error("expected to find source file");
                    return this.get_body_empty();
                }
                var paused_addr = this.state.paused_on_frame
                    ? this.state.paused_on_frame.addr
                    : null, start_linenum = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("source_linenum_to_display_start"), end_linenum = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("source_linenum_to_display_end");
                return this.get_body_source_and_assm(obj.fullname, obj.source_code_obj, obj.assembly, paused_addr, start_linenum, end_linenum, obj.num_lines_in_file);
            }
            case states.FETCHING_SOURCE: {
                return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("tr", null,
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("td", null, "fetching source, please wait")));
            }
            case states.ASSM_CACHED: {
                var paused_addr = this.state.paused_on_frame
                    ? this.state.paused_on_frame.addr
                    : null, assm_array = this.state.disassembly_for_missing_file;
                return this.get_body_assembly_only(assm_array, paused_addr);
            }
            case states.FETCHING_ASSM: {
                return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("tr", null,
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("td", null, "fetching assembly, please wait")));
            }
            case states.ASSM_UNAVAILABLE: {
                var paused_addr = this.state.paused_on_frame
                    ? this.state.paused_on_frame.addr
                    : null;
                return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("tr", null,
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("td", null,
                        "cannot access address ",
                        paused_addr)));
            }
            case states.FILE_MISSING: {
                return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("tr", null,
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("td", null,
                        "file not found: ",
                        this.state.fullname_to_render)));
            }
            case states.NONE_AVAILABLE: {
                return this.get_body_empty();
            }
            default: {
                console.error("developer error: unhandled state");
                return this.get_body_empty();
            }
        }
    };
    SourceCode.prototype.click_gutter = function (line_num) {
        _Breakpoints__WEBPACK_IMPORTED_MODULE_3__["default"].add_or_remove_breakpoint(this.state.fullname_to_render, line_num);
    };
    SourceCode.prototype._get_source_line = function (source, line_should_flash, is_gdb_paused_on_this_line, line_num_being_rendered, has_bkpt, has_disabled_bkpt, has_conditional_bkpt, assembly_for_line, paused_addr) {
        var e_1, _a;
        var row_class = ["srccode"];
        if (is_gdb_paused_on_this_line) {
            row_class.push("paused_on_line");
        }
        else if (line_should_flash) {
            row_class.push("flash");
        }
        var id = "";
        if (this.state.source_code_selection_state ===
            _constants__WEBPACK_IMPORTED_MODULE_6__["default"].source_code_selection_states.PAUSED_FRAME) {
            if (is_gdb_paused_on_this_line) {
                id = "scroll_to_line";
            }
        }
        else if (this.state.source_code_selection_state ===
            _constants__WEBPACK_IMPORTED_MODULE_6__["default"].source_code_selection_states.USER_SELECTION) {
            if (line_should_flash) {
                id = "scroll_to_line";
            }
        }
        var gutter_cls = "";
        if (has_disabled_bkpt) {
            gutter_cls = "disabled_breakpoint";
        }
        else if (has_conditional_bkpt) {
            gutter_cls = "conditional_breakpoint";
        }
        else if (has_bkpt) {
            gutter_cls = "breakpoint";
        }
        var assembly_content = [];
        if (assembly_for_line) {
            var i = 0;
            try {
                for (var assembly_for_line_1 = __values(assembly_for_line), assembly_for_line_1_1 = assembly_for_line_1.next(); !assembly_for_line_1_1.done; assembly_for_line_1_1 = assembly_for_line_1.next()) {
                    var assm = assembly_for_line_1_1.value;
                    assembly_content.push(SourceCode._get_assm_content(i, assm, paused_addr));
                    assembly_content.push(react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("br", { key: "br" + i }));
                    i++;
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (assembly_for_line_1_1 && !assembly_for_line_1_1.done && (_a = assembly_for_line_1.return)) _a.call(assembly_for_line_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("tr", { id: id, key: line_num_being_rendered, className: "" + row_class.join(" ") },
            this.get_linenum_td(line_num_being_rendered, gutter_cls),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("td", { style: { verticalAlign: "top" }, className: "loc" },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: "wsp", dangerouslySetInnerHTML: { __html: source } })),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("td", { className: "assembly" }, assembly_content)));
    };
    SourceCode.prototype.get_linenum_td = function (linenum, gutter_cls) {
        var _this = this;
        if (gutter_cls === void 0) { gutter_cls = ""; }
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("td", { style: { verticalAlign: "top", width: "30px" }, className: "line_num " + gutter_cls, onClick: function () {
                _this.click_gutter(linenum);
            } },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", null, linenum)));
    };
    /**
     * example return value: mov $0x400684,%edi(00) main+8 0x0000000000400585
     */
    SourceCode._get_assm_content = function (key, assm, paused_addr) {
        var opcodes = assm.opcodes ? (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: "instrContent" }, "(" + assm.opcodes + ")")) : (""), instruction = _Memory__WEBPACK_IMPORTED_MODULE_4__["default"].make_addrs_into_links_react(assm.inst), func_name = assm["func-name"], offset = assm.offset, addr = assm.address, on_current_instruction = paused_addr === assm.address, cls = on_current_instruction ? "current_assembly_command" : "", asterisk = on_current_instruction ? (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: "glyphicon glyphicon-chevron-right", style: { width: "10px", display: "inline-block" } })) : (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { style: { width: "10px", display: "inline-block" } }, " "));
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { key: key, style: { whiteSpace: "nowrap" }, className: cls },
            asterisk,
            " ",
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_MemoryLink__WEBPACK_IMPORTED_MODULE_5__["default"], { addr: addr, style: { paddingRight: "5px" } }),
            opcodes /* i.e. mov */,
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", { className: "instrContent" }, instruction),
            func_name ? (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("span", null,
                func_name,
                "+",
                offset)) : ("")));
    };
    SourceCode.prototype._get_assm_row = function (key, assm, paused_addr) {
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("tr", { key: key, className: "srccode" },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("td", { className: "assembly loc" }, SourceCode._get_assm_content(key, assm, paused_addr))));
    };
    SourceCode.prototype.is_gdb_paused_on_this_line = function (line_num_being_rendered, line_gdb_is_paused_on) {
        if (this.state.paused_on_frame) {
            return (line_num_being_rendered === line_gdb_is_paused_on &&
                this.state.paused_on_frame.fullname === this.state.fullname_to_render);
        }
        else {
            return false;
        }
    };
    SourceCode.prototype.get_view_more_tr = function (fullname, linenum, node_key) {
        return (
        // @ts-expect-error ts-migrate(7053) FIXME: Element implicitly has an 'any' type because expre... Remove this comment to see the full error message
        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("tr", { key: linenum, className: "srccode", ref: function (el) { return (SourceCode[node_key] = el); } },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("td", null),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("td", { onClick: function () {
                    _Actions__WEBPACK_IMPORTED_MODULE_7__["default"].view_file(fullname, linenum);
                }, style: { fontStyle: "italic", paddingLeft: "10px" }, className: "pointer" }, "view more")));
    };
    SourceCode.prototype.get_end_of_file_tr = function (linenum) {
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("tr", { key: linenum },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("td", null),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("td", { style: { fontStyle: "italic", paddingLeft: "10px", fontSize: "0.8em" } }, "(end of file)")));
    };
    SourceCode.prototype.get_line_nums_to_render = function (source_code_obj, start_linenum, line_to_flash, end_linenum) {
        var start_linenum_to_render = start_linenum;
        var end_linenum_to_render = end_linenum;
        var linenum = start_linenum;
        // go backwards from center until missing element is found
        // linenum >= start_linenum &&
        while (linenum < end_linenum) {
            if (source_code_obj.hasOwnProperty(linenum)) {
                start_linenum_to_render = linenum;
                break;
            }
            else {
                linenum++;
            }
        }
        linenum = end_linenum;
        while (linenum > start_linenum) {
            if (source_code_obj.hasOwnProperty(linenum)) {
                end_linenum_to_render = linenum;
                break;
            }
            else {
                linenum--;
            }
        }
        return { start_linenum_to_render: start_linenum_to_render, end_linenum_to_render: end_linenum_to_render };
    };
    SourceCode.prototype.get_body_source_and_assm = function (fullname, source_code_obj, assembly, paused_addr, start_linenum, end_linenum, num_lines_in_file) {
        var body = [];
        var bkpt_lines = _Breakpoints__WEBPACK_IMPORTED_MODULE_3__["default"].get_breakpoint_lines_for_file(this.state.fullname_to_render), disabled_breakpoint_lines = _Breakpoints__WEBPACK_IMPORTED_MODULE_3__["default"].get_disabled_breakpoint_lines_for_file(this.state.fullname_to_render), conditional_breakpoint_lines = _Breakpoints__WEBPACK_IMPORTED_MODULE_3__["default"].get_conditional_breakpoint_lines_for_file(this.state.fullname_to_render), line_gdb_is_paused_on = this.state.paused_on_frame
            ? parseInt(this.state.paused_on_frame.line)
            : 0;
        var line_of_source_to_flash = this.state.line_of_source_to_flash;
        var _a = this.get_line_nums_to_render(source_code_obj, start_linenum, line_of_source_to_flash, end_linenum), start_linenum_to_render = _a.start_linenum_to_render, end_linenum_to_render = _a.end_linenum_to_render;
        var line_num_being_rendered = start_linenum_to_render;
        while (line_num_being_rendered <= end_linenum_to_render) {
            var cur_line_of_code = source_code_obj[line_num_being_rendered];
            var has_bkpt = bkpt_lines.indexOf(line_num_being_rendered) !== -1, has_disabled_bkpt = disabled_breakpoint_lines.indexOf(line_num_being_rendered) !== -1, has_conditional_bkpt = conditional_breakpoint_lines.indexOf(line_num_being_rendered) !== -1, is_gdb_paused_on_this_line = this.is_gdb_paused_on_this_line(line_num_being_rendered, line_gdb_is_paused_on), assembly_for_line = assembly[line_num_being_rendered];
            body.push(this._get_source_line(cur_line_of_code, line_of_source_to_flash === line_num_being_rendered, is_gdb_paused_on_this_line, line_num_being_rendered, has_bkpt, has_disabled_bkpt, has_conditional_bkpt, assembly_for_line, paused_addr));
            line_num_being_rendered++;
        }
        SourceCode.view_more_top_node = null;
        SourceCode.view_more_bottom_node = null;
        // add "view more" buttons if necessary
        if (start_linenum_to_render > start_linenum) {
            body.unshift(this.get_view_more_tr(fullname, start_linenum_to_render - 1, "view_more_top_node"));
        }
        else if (start_linenum !== 1) {
            body.unshift(this.get_view_more_tr(fullname, start_linenum - 1, "view_more_top_node"));
        }
        if (end_linenum_to_render < end_linenum) {
            body.push(this.get_view_more_tr(fullname, end_linenum_to_render + 1, "view_more_bottom_node"));
        }
        else if (end_linenum < num_lines_in_file) {
            body.push(this.get_view_more_tr(fullname, line_num_being_rendered, "view_more_bottom_node"));
        }
        if (end_linenum_to_render === num_lines_in_file) {
            body.push(this.get_end_of_file_tr(num_lines_in_file + 1));
        }
        return body;
    };
    SourceCode.prototype.get_body_assembly_only = function (assm_array, paused_addr) {
        var e_2, _a;
        var body = [], i = 0;
        try {
            for (var assm_array_1 = __values(assm_array), assm_array_1_1 = assm_array_1.next(); !assm_array_1_1.done; assm_array_1_1 = assm_array_1.next()) {
                var assm = assm_array_1_1.value;
                body.push(this._get_assm_row(i, assm, paused_addr));
                i++;
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (assm_array_1_1 && !assm_array_1_1.done && (_a = assm_array_1.return)) _a.call(assm_array_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return body;
    };
    SourceCode.prototype.get_body_empty = function () {
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("tr", null,
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("td", null, "no source code or assembly to display")));
    };
    SourceCode.make_current_line_visible = function () {
        return SourceCode._make_jq_selector_visible($("#scroll_to_line"));
    };
    SourceCode.is_source_line_visible = function (jq_selector) {
        if (jq_selector.length !== 1) {
            // make sure something is selected before trying to scroll to it
            throw "Unexpected jquery selector";
        }
        // @ts-expect-error ts-migrate(2531) FIXME: Object is possibly 'null'.
        var top_of_container = SourceCode.el_code_container.position().top, 
        // @ts-expect-error ts-migrate(2531) FIXME: Object is possibly 'null'.
        height_of_container = SourceCode.el_code_container.height(), bottom_of_container = top_of_container + height_of_container, top_of_line = jq_selector.position().top, bottom_of_line = top_of_line + jq_selector.height(), top_of_table = jq_selector.closest("table").position().top, is_visible = top_of_line >= top_of_container && bottom_of_line <= bottom_of_container;
        if (is_visible) {
            return { is_visible: true, top_of_line: top_of_line, top_of_table: top_of_table, height_of_container: height_of_container };
        }
        else {
            return { is_visible: false, top_of_line: top_of_line, top_of_table: top_of_table, height_of_container: height_of_container };
        }
    };
    /**
     * Scroll to a jQuery selection in the source code table
     * Used to jump around to various lines
     * returns true on success
     */
    SourceCode._make_jq_selector_visible = function (jq_selector) {
        if (jq_selector.length === 1) {
            // make sure something is selected before trying to scroll to it
            var _a = SourceCode.is_source_line_visible(jq_selector), is_visible = _a.is_visible, top_of_line = _a.top_of_line, top_of_table = _a.top_of_table, height_of_container = _a.height_of_container;
            if (!is_visible) {
                // line is out of view, scroll so it's in the middle of the table
                var time_to_scroll = 0;
                var scroll_top = top_of_line - (top_of_table + height_of_container / 2);
                // @ts-expect-error ts-migrate(2531) FIXME: Object is possibly 'null'.
                SourceCode.el_code_container.animate({ scrollTop: scroll_top }, time_to_scroll);
            }
            return true;
        }
        else {
            return false;
        }
    };
    SourceCode.el_code_container = null; // todo: no jquery
    SourceCode.el_code_container_node = null;
    SourceCode.code_container_node = null;
    SourceCode.view_more_top_node = null;
    SourceCode.view_more_bottom_node = null;
    return SourceCode;
}(react__WEBPACK_IMPORTED_MODULE_1___default.a.Component));
/* harmony default export */ __webpack_exports__["default"] = (SourceCode);


/***/ }),

/***/ "./gdbgui/src/js/SourceCodeHeading.tsx":
/*!*********************************************!*\
  !*** ./gdbgui/src/js/SourceCodeHeading.tsx ***!
  \*********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./gdbgui/src/js/constants.ts");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Links__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Links */ "./gdbgui/src/js/Links.tsx");
/* harmony import */ var _FileOps__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./FileOps */ "./gdbgui/src/js/FileOps.tsx");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();





var SourceCodeHeading = /** @class */ (function (_super) {
    __extends(SourceCodeHeading, _super);
    function SourceCodeHeading() {
        var _this = 
        // @ts-expect-error ts-migrate(2554) FIXME: Expected 1-2 arguments, but got 0.
        _super.call(this) || this;
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'connectComponentState' does not exist on... Remove this comment to see the full error message
        statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].connectComponentState(_this, [
            "fullname_to_render",
            "paused_on_frame",
            "line_of_source_to_flash",
            "source_code_selection_state"
        ]);
        return _this;
    }
    SourceCodeHeading.prototype.render = function () {
        var line;
        if (this.state.source_code_selection_state ===
            _constants__WEBPACK_IMPORTED_MODULE_1__["default"].source_code_selection_states.PAUSED_FRAME &&
            this.state.paused_on_frame) {
            line = this.state.paused_on_frame.line;
        }
        else {
            line = this.state.line_of_source_to_flash;
        }
        var num_lines = 0;
        if (this.state.fullname_to_render &&
            _FileOps__WEBPACK_IMPORTED_MODULE_4__["default"].get_source_file_obj_from_cache(this.state.fullname_to_render)) {
            // @ts-expect-error ts-migrate(2554) FIXME: Expected 2 arguments, but got 1.
            num_lines = _FileOps__WEBPACK_IMPORTED_MODULE_4__["default"].get_num_lines_in_file(this.state.fullname_to_render);
        }
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_Links__WEBPACK_IMPORTED_MODULE_3__["FileLink"], { fullname: this.state.fullname_to_render, file: this.state.fullname_to_render, line: line, num_lines: num_lines }));
    };
    return SourceCodeHeading;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));
/* harmony default export */ __webpack_exports__["default"] = (SourceCodeHeading);


/***/ }),

/***/ "./gdbgui/src/js/SourceFileAutocomplete.tsx":
/*!**************************************************!*\
  !*** ./gdbgui/src/js/SourceFileAutocomplete.tsx ***!
  \**************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./gdbgui/src/js/constants.ts");
/* harmony import */ var _Actions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Actions */ "./gdbgui/src/js/Actions.ts");
/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Util */ "./gdbgui/src/js/Util.ts");
/* harmony import */ var _FileOps__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./FileOps */ "./gdbgui/src/js/FileOps.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (undefined && undefined.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};






/**
 * The autocomplete dropdown of source files is complicated enough
 * to have its own component. It uses the awesomeplete library,
 * which is really nice: https://leaverou.github.io/awesomplete/
 */
var help_text = "Enter file path to view, press enter";
/* global Awesomplete */
var SourceFileAutocomplete = /** @class */ (function (_super) {
    __extends(SourceFileAutocomplete, _super);
    function SourceFileAutocomplete() {
        var _this = 
        // @ts-expect-error ts-migrate(2554) FIXME: Expected 1-2 arguments, but got 0.
        _super.call(this) || this;
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'subscribeToKeys' does not exist on type ... Remove this comment to see the full error message
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].subscribeToKeys(["source_file_paths"], _this.store_change_callback.bind(_this));
        return _this;
    }
    SourceFileAutocomplete.prototype.store_change_callback = function () {
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
        if (!_.isEqual(this.awesomeplete_input._list, statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("source_file_paths"))) {
            this.awesomeplete_input.list = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("source_file_paths");
        }
    };
    SourceFileAutocomplete.prototype.render = function () {
        var _this = this;
        return (react__WEBPACK_IMPORTED_MODULE_5___default.a.createElement("div", { style: { width: "100%", flex: "1 0", padding: "5px" }, className: "flex" },
            react__WEBPACK_IMPORTED_MODULE_5___default.a.createElement("input", { id: "source_file_input", autoComplete: "off", placeholder: help_text, title: help_text, className: "dropdown-input", onKeyUp: this.keyup_source_file_input.bind(this), role: "combobox", ref: function (el) { return (_this.html_input = el); }, style: { width: "100%" } }),
            react__WEBPACK_IMPORTED_MODULE_5___default.a.createElement("button", { id: "source_file_dropdown_button", style: { float: "right" }, type: "button", className: "dropdown-btn", onClick: this.onclick_dropdown.bind(this) },
                react__WEBPACK_IMPORTED_MODULE_5___default.a.createElement("span", { className: "caret" }))));
    };
    SourceFileAutocomplete.prototype.keyup_source_file_input = function (e) {
        var _a;
        if (e.keyCode === _constants__WEBPACK_IMPORTED_MODULE_1__["default"].ENTER_BUTTON_NUM) {
            // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
            var user_input = _.trim(e.currentTarget.value);
            if (user_input.length === 0) {
                return;
            }
            var fullname = void 0, default_line = 0, line = void 0;
            // @ts-expect-error ts-migrate(2345) FIXME: Argument of type 'number' is not assignable to par... Remove this comment to see the full error message
            _a = __read(_Util__WEBPACK_IMPORTED_MODULE_3__["default"].parse_fullname_and_line(user_input, default_line), 2), fullname = _a[0], line = _a[1];
            _FileOps__WEBPACK_IMPORTED_MODULE_4__["default"].user_select_file_to_view(fullname, line);
        }
        else if (statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("source_file_paths").length === 0) {
            // source file list has not been fetched yet, so fetch it
            _Actions__WEBPACK_IMPORTED_MODULE_2__["default"].fetch_source_files();
        }
    };
    SourceFileAutocomplete.prototype.onclick_dropdown = function () {
        if (statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("source_file_paths").length === 0) {
            // we have not asked gdb to get the list of source paths yet, or it just doesn't have any.
            // request that gdb populate this list.
            _Actions__WEBPACK_IMPORTED_MODULE_2__["default"].fetch_source_files();
            return;
        }
        if (this.awesomeplete_input.ul.childNodes.length === 0) {
            this.awesomeplete_input.evaluate();
        }
        else if (this.awesomeplete_input.ul.hasAttribute("hidden")) {
            this.awesomeplete_input.open();
        }
        else {
            this.awesomeplete_input.close();
        }
    };
    SourceFileAutocomplete.prototype.componentDidMount = function () {
        // initialize list of source files
        // TODO maybe use a pre-built React component for this
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name 'Awesomplete'.
        this.awesomeplete_input = new Awesomplete("#source_file_input", {
            minChars: 0,
            maxItems: 10000,
            list: [],
            // standard sort algorithm (the default Awesomeplete sort is weird)
            sort: function (a, b) {
                return a < b ? -1 : 1;
            }
        });
        // perform action when an item is selected
        this.html_input.addEventListener("awesomplete-selectcomplete", function (e) {
            var fullname = e.currentTarget.value;
            _FileOps__WEBPACK_IMPORTED_MODULE_4__["default"].user_select_file_to_view(fullname, 1);
        });
    };
    return SourceFileAutocomplete;
}(react__WEBPACK_IMPORTED_MODULE_5___default.a.Component));
/* harmony default export */ __webpack_exports__["default"] = (SourceFileAutocomplete);


/***/ }),

/***/ "./gdbgui/src/js/Terminals.tsx":
/*!*************************************!*\
  !*** ./gdbgui/src/js/Terminals.tsx ***!
  \*************************************/
/*! exports provided: Terminals */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Terminals", function() { return Terminals; });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _GdbApi__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./GdbApi */ "./gdbgui/src/js/GdbApi.tsx");
/* harmony import */ var xterm__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! xterm */ "./node_modules/xterm/lib/xterm.js");
/* harmony import */ var xterm__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(xterm__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var xterm_addon_fit__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! xterm-addon-fit */ "./node_modules/xterm-addon-fit/lib/xterm-addon-fit.js");
/* harmony import */ var xterm_addon_fit__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(xterm_addon_fit__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var xterm_css_xterm_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! xterm/css/xterm.css */ "./node_modules/xterm/css/xterm.css");
/* harmony import */ var xterm_css_xterm_css__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(xterm_css_xterm_css__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./constants */ "./gdbgui/src/js/constants.ts");
/* harmony import */ var _Actions__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Actions */ "./gdbgui/src/js/Actions.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (undefined && undefined.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};








function customKeyEventHandler(config) {
    var _this = this;
    return function (e) { return __awaiter(_this, void 0, Promise, function () {
        var key, toCopy, toPaste;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!(e.type === "keydown")) {
                        return [2 /*return*/, true];
                    }
                    if (!(e.shiftKey && e.ctrlKey)) return [3 /*break*/, 3];
                    key = e.key.toLowerCase();
                    if (!(key === "c")) return [3 /*break*/, 1];
                    toCopy = config.pty.getSelection();
                    navigator.clipboard.writeText(toCopy);
                    config.pty.focus();
                    return [2 /*return*/, false];
                case 1:
                    if (!(key === "v")) return [3 /*break*/, 3];
                    if (!config.canPaste) {
                        return [2 /*return*/, false];
                    }
                    return [4 /*yield*/, navigator.clipboard.readText()];
                case 2:
                    toPaste = _a.sent();
                    _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].getSocket().emit("pty_interaction", {
                        data: { pty_name: config.pty_name, key: toPaste, action: "write" }
                    });
                    return [2 /*return*/, false];
                case 3: return [2 /*return*/, true];
            }
        });
    }); };
}
var Terminals = /** @class */ (function (_super) {
    __extends(Terminals, _super);
    function Terminals(props) {
        var _this = _super.call(this, props) || this;
        _this.userPtyRef = react__WEBPACK_IMPORTED_MODULE_0___default.a.createRef();
        _this.programPtyRef = react__WEBPACK_IMPORTED_MODULE_0___default.a.createRef();
        _this.gdbguiPtyRef = react__WEBPACK_IMPORTED_MODULE_0___default.a.createRef();
        _this.terminal = _this.terminal.bind(_this);
        return _this;
    }
    Terminals.prototype.terminal = function (ref) {
        var className = " bg-black p-0 m-0 h-full align-baseline ";
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: className },
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "absolute h-full w-1/3 align-baseline  ", ref: ref })));
    };
    Terminals.prototype.render = function () {
        var terminalsClass = "w-full h-full relative grid grid-cols-3 ";
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: terminalsClass },
            this.terminal(this.userPtyRef),
            this.terminal(this.gdbguiPtyRef),
            this.terminal(this.programPtyRef)));
    };
    Terminals.prototype.componentDidMount = function () {
        var fitAddon = new xterm_addon_fit__WEBPACK_IMPORTED_MODULE_3__["FitAddon"]();
        var programFitAddon = new xterm_addon_fit__WEBPACK_IMPORTED_MODULE_3__["FitAddon"]();
        var gdbguiFitAddon = new xterm_addon_fit__WEBPACK_IMPORTED_MODULE_3__["FitAddon"]();
        var userPty = new xterm__WEBPACK_IMPORTED_MODULE_2__["Terminal"]({
            cursorBlink: true,
            macOptionIsMeta: true,
            scrollback: 9999
        });
        userPty.loadAddon(fitAddon);
        userPty.open(this.userPtyRef.current);
        userPty.writeln("running command: " + statorgfc__WEBPACK_IMPORTED_MODULE_4__["store"].get("gdb_command"));
        userPty.writeln("");
        userPty.attachCustomKeyEventHandler(
        // @ts-expect-error
        customKeyEventHandler({
            pty_name: "user_pty",
            pty: userPty,
            canPaste: true,
            pidStoreKey: "gdb_pid"
        }));
        _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].getSocket().on("user_pty_response", function (data) {
            userPty.write(data);
        });
        userPty.onKey(function (data, ev) {
            _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].getSocket().emit("pty_interaction", {
                data: { pty_name: "user_pty", key: data.key, action: "write" }
            });
            if (data.domEvent.code === "Enter") {
                _Actions__WEBPACK_IMPORTED_MODULE_7__["default"].onConsoleCommandRun();
            }
        });
        var programPty = new xterm__WEBPACK_IMPORTED_MODULE_2__["Terminal"]({
            cursorBlink: true,
            macOptionIsMeta: true,
            scrollback: 9999
        });
        programPty.loadAddon(programFitAddon);
        programPty.open(this.programPtyRef.current);
        programPty.attachCustomKeyEventHandler(
        // @ts-expect-error
        customKeyEventHandler({
            pty_name: "program_pty",
            pty: programPty,
            canPaste: true,
            pidStoreKey: "inferior_pid"
        }));
        programPty.write(_constants__WEBPACK_IMPORTED_MODULE_6__["default"].xtermColors.grey);
        programPty.write("Program output -- Programs being debugged are connected to this terminal. " +
            "You can read output and send input to the program from here.");
        programPty.writeln(_constants__WEBPACK_IMPORTED_MODULE_6__["default"].xtermColors.reset);
        _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].getSocket().on("program_pty_response", function (pty_response) {
            programPty.write(pty_response);
        });
        programPty.onKey(function (data, ev) {
            _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].getSocket().emit("pty_interaction", {
                data: { pty_name: "program_pty", key: data.key, action: "write" }
            });
        });
        var gdbguiPty = new xterm__WEBPACK_IMPORTED_MODULE_2__["Terminal"]({
            cursorBlink: false,
            macOptionIsMeta: true,
            scrollback: 9999,
            disableStdin: true
            // theme: { background: "#888" }
        });
        gdbguiPty.write(_constants__WEBPACK_IMPORTED_MODULE_6__["default"].xtermColors.grey);
        gdbguiPty.writeln("gdbgui output (read-only)");
        gdbguiPty.writeln("Copy/Paste available in all terminals with ctrl+shift+c, ctrl+shift+v");
        gdbguiPty.write(_constants__WEBPACK_IMPORTED_MODULE_6__["default"].xtermColors.reset);
        gdbguiPty.attachCustomKeyEventHandler(
        // @ts-expect-error
        customKeyEventHandler({ pty_name: "unused", pty: gdbguiPty, canPaste: false }));
        gdbguiPty.loadAddon(gdbguiFitAddon);
        gdbguiPty.open(this.gdbguiPtyRef.current);
        // gdbguiPty is written to elsewhere
        statorgfc__WEBPACK_IMPORTED_MODULE_4__["store"].set("gdbguiPty", gdbguiPty);
        var interval = setInterval(function () {
            fitAddon.fit();
            programFitAddon.fit();
            gdbguiFitAddon.fit();
            var socket = _GdbApi__WEBPACK_IMPORTED_MODULE_1__["default"].getSocket();
            if (socket.disconnected) {
                return;
            }
            socket.emit("pty_interaction", {
                data: {
                    pty_name: "user_pty",
                    rows: userPty.rows,
                    cols: userPty.cols,
                    action: "set_winsize"
                }
            });
            socket.emit("pty_interaction", {
                data: {
                    pty_name: "program_pty",
                    rows: programPty.rows,
                    cols: programPty.cols,
                    action: "set_winsize"
                }
            });
        }, 2000);
        setTimeout(function () {
            fitAddon.fit();
            programFitAddon.fit();
            gdbguiFitAddon.fit();
        }, 0);
    };
    return Terminals;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));



/***/ }),

/***/ "./gdbgui/src/js/Threads.tsx":
/*!***********************************!*\
  !*** ./gdbgui/src/js/Threads.tsx ***!
  \***********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ReactTable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ReactTable */ "./gdbgui/src/js/ReactTable.tsx");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _GdbApi__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./GdbApi */ "./gdbgui/src/js/GdbApi.tsx");
/* harmony import */ var _Memory__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Memory */ "./gdbgui/src/js/Memory.tsx");
/* harmony import */ var _Links__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Links */ "./gdbgui/src/js/Links.tsx");
/* harmony import */ var _MemoryLink__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./MemoryLink */ "./gdbgui/src/js/MemoryLink.tsx");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (undefined && undefined.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};







var FrameArguments = /** @class */ (function (_super) {
    __extends(FrameArguments, _super);
    function FrameArguments() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    FrameArguments.prototype.render_frame_arg = function (frame_arg) {
        return [frame_arg.name, frame_arg.value];
    };
    FrameArguments.prototype.render = function () {
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'args' does not exist on type 'Readonly<{... Remove this comment to see the full error message
        var frame_args = this.props.args;
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'args' does not exist on type 'Readonly<{... Remove this comment to see the full error message
        if (!this.props.args) {
            frame_args = [];
        }
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_ReactTable__WEBPACK_IMPORTED_MODULE_1__["default"]
        // @ts-expect-error ts-migrate(2769) FIXME: Property 'data' does not exist on type 'IntrinsicA... Remove this comment to see the full error message
        , { 
            // @ts-expect-error ts-migrate(2769) FIXME: Property 'data' does not exist on type 'IntrinsicA... Remove this comment to see the full error message
            data: frame_args.map(this.render_frame_arg), style: { fontSize: "0.9em", borderWidth: "0" } }));
    };
    return FrameArguments;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));
var Threads = /** @class */ (function (_super) {
    __extends(Threads, _super);
    function Threads() {
        var _this = 
        // @ts-expect-error ts-migrate(2554) FIXME: Expected 1-2 arguments, but got 0.
        _super.call(this) || this;
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'connectComponentState' does not exist on... Remove this comment to see the full error message
        statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].connectComponentState(_this, [
            "threads",
            "current_thread_id",
            "stack",
            "selected_frame_num"
        ]);
        return _this;
    }
    Threads.select_thread_id = function (thread_id) {
        _GdbApi__WEBPACK_IMPORTED_MODULE_3__["default"].select_thread_id(thread_id);
    };
    Threads.select_frame = function (framenum) {
        statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].set("selected_frame_num", framenum);
        statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].set("line_of_source_to_flash", null);
        statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].set("make_current_line_visible", true);
        _GdbApi__WEBPACK_IMPORTED_MODULE_3__["default"].select_frame(framenum);
    };
    Threads.prototype.render = function () {
        var e_1, _a;
        if (this.state.threads.length <= 0) {
            return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "placeholder" });
        }
        var content = [];
        try {
            for (var _b = __values(this.state.threads), _c = _b.next(); !_c.done; _c = _b.next()) {
                var thread = _c.value;
                var is_current_thread_being_rendered = parseInt(thread.id) === this.state.current_thread_id;
                var stack = Threads.get_stack_for_thread(thread.frame, this.state.stack, is_current_thread_being_rendered);
                var row_data = void 0;
                try {
                    row_data = Threads.get_row_data_for_stack(stack, this.state.selected_frame_num, thread.id, is_current_thread_being_rendered);
                }
                catch (err) {
                    row_data = ["unknown", "unknown", "unknown"];
                    console.log(err);
                }
                content.push(Threads.get_thread_header(thread, is_current_thread_being_rendered));
                content.push(
                // @ts-expect-error ts-migrate(2769) FIXME: Type 'string' is not assignable to type 'never'.
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_ReactTable__WEBPACK_IMPORTED_MODULE_1__["default"], { data: row_data, style: { fontSize: "0.9em", marginBottom: 0 }, key: thread.id, header: ["func", "file", "addr", "args"], classes: ["table-bordered", "table-striped"] }));
                content.push(react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("br", { key: thread.id + "br" }));
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", null, content);
    };
    Threads.get_stack_for_thread = function (cur_frame, stack_data, is_current_thread_being_rendered) {
        var e_2, _a;
        // each thread provides only the frame that it's paused on (cur_frame).
        // we also have the output of `-stack-list-frames` (stack_data), which
        // is the full stack of the selected thread
        if (is_current_thread_being_rendered) {
            try {
                for (var stack_data_1 = __values(stack_data), stack_data_1_1 = stack_data_1.next(); !stack_data_1_1.done; stack_data_1_1 = stack_data_1.next()) {
                    var frame = stack_data_1_1.value;
                    if (frame && cur_frame && frame.addr === cur_frame.addr) {
                        return stack_data;
                    }
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (stack_data_1_1 && !stack_data_1_1.done && (_a = stack_data_1.return)) _a.call(stack_data_1);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
        return [cur_frame];
    };
    Threads.get_thread_header = function (thread, is_current_thread_being_rendered) {
        var selected, cls = "";
        if (is_current_thread_being_rendered) {
            cls = "bold";
            selected = (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "label label-primary", title: "This thread is selected. Variables can be inspected for the current frame of this thread." }, "selected"));
        }
        else {
            selected = (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { className: "pointer btn btn-default btn-xs", onClick: function () {
                    Threads.select_thread_id(thread.id);
                }, title: "Select this thread", style: { fontSize: "75%" } }, "select"));
        }
        var details = _Memory__WEBPACK_IMPORTED_MODULE_4__["default"].make_addrs_into_links_react(thread["target-id"]);
        var core = thread.core ? ", core " + thread.core : "";
        var state = ", " + thread.state;
        var id = ", id " + thread.id;
        var name = thread.name ? ", " + thread.name : "";
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { key: "thread" + thread.id, className: "" + cls, style: { fontSize: "0.9em" } },
            selected,
            " ",
            details,
            id,
            core,
            state,
            name));
    };
    Threads.get_frame_row = function (frame, is_selected_frame, thread_id, is_current_thread_being_rendered, frame_num) {
        var onclick;
        var classes = [];
        var title;
        if (is_selected_frame) {
            // current frame, current thread
            onclick = function () { };
            classes.push("bold");
            title = "this is the active frame of the selected thread (frame id " + frame_num + ")";
        }
        else if (is_current_thread_being_rendered) {
            onclick = function () {
                Threads.select_frame(frame_num);
            };
            classes.push("pointer");
            title = "click to select this frame (frame id " + frame_num + ")";
        }
        else {
            // different thread, allow user to switch threads
            onclick = function () {
                Threads.select_thread_id(thread_id);
            };
            classes.push("pointer");
            title = "click to select this thead (thread id " + thread_id + ")";
        }
        var key = thread_id + frame_num;
        return [
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { key: key, title: title, className: classes.join(" "), onClick: onclick }, frame.func),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_Links__WEBPACK_IMPORTED_MODULE_5__["FileLink"], { fullname: frame.fullname, file: frame.file, line: frame.line }),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_MemoryLink__WEBPACK_IMPORTED_MODULE_6__["default"], { addr: frame.addr }),
            // @ts-expect-error ts-migrate(2769) FIXME: Property 'args' does not exist on type 'IntrinsicA... Remove this comment to see the full error message
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(FrameArguments, { args: frame.args })
        ];
    };
    Threads.get_row_data_for_stack = function (stack, selected_frame_num, thread_id, is_current_thread_being_rendered) {
        var e_3, _a;
        var row_data = [];
        var frame_num = 0;
        try {
            for (var stack_1 = __values(stack), stack_1_1 = stack_1.next(); !stack_1_1.done; stack_1_1 = stack_1.next()) {
                var frame = stack_1_1.value;
                var is_selected_frame = selected_frame_num === frame_num && is_current_thread_being_rendered;
                row_data.push(Threads.get_frame_row(frame || {}, is_selected_frame, thread_id, is_current_thread_being_rendered, frame_num));
                frame_num++;
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (stack_1_1 && !stack_1_1.done && (_a = stack_1.return)) _a.call(stack_1);
            }
            finally { if (e_3) throw e_3.error; }
        }
        if (stack.length === 0) {
            row_data.push(["unknown", "unknown", "unknown"]);
        }
        return row_data;
    };
    Threads.update_stack = function (stack) {
        statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].set("stack", stack);
        statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].set("paused_on_frame", stack[statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].get("selected_frame_num") || 0]);
        statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].set("fullname_to_render", statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].get("paused_on_frame") ? statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].get("paused_on_frame").fullname : {});
        statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].set("line_of_source_to_flash", parseInt(statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].get("paused_on_frame").line));
        statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].set("current_assembly_address", statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].get("paused_on_frame").addr);
        statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].set("make_current_line_visible", true);
    };
    Threads.prototype.set_thread_id = function (id) {
        statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].set("current_thread_id", parseInt(id));
    };
    return Threads;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));
/* harmony default export */ __webpack_exports__["default"] = (Threads);


/***/ }),

/***/ "./gdbgui/src/js/ToolTip.tsx":
/*!***********************************!*\
  !*** ./gdbgui/src/js/ToolTip.tsx ***!
  \***********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_1__);
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


var ToolTip = /** @class */ (function (_super) {
    __extends(ToolTip, _super);
    function ToolTip() {
        var _this = 
        // @ts-expect-error ts-migrate(2554) FIXME: Expected 1-2 arguments, but got 0.
        _super.call(this) || this;
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'connectComponentState' does not exist on... Remove this comment to see the full error message
        statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].connectComponentState(_this, ["tooltip"]);
        _this.timeout = null;
        return _this;
    }
    ToolTip.hide_tooltip = function () {
        statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("tooltip", {
            hidden: true,
            show_for_n_sec: null,
            node: null,
            content: null
        });
    };
    ToolTip.show_tooltip_on_node = function (content, node, show_for_n_sec) {
        if (show_for_n_sec === void 0) { show_for_n_sec = null; }
        statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("tooltip", {
            hidden: false,
            show_for_n_sec: show_for_n_sec,
            node: node,
            content: content
        });
    };
    ToolTip.show_copied_tooltip_on_node = function (node) {
        // @ts-expect-error ts-migrate(2345) FIXME: Argument of type '1' is not assignable to paramete... Remove this comment to see the full error message
        ToolTip.show_tooltip_on_node("copied!", node, 1);
    };
    ToolTip.prototype.render = function () {
        clearTimeout(this.timeout);
        var tooltip = statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("tooltip");
        if (!tooltip.node || tooltip.hidden) {
            return null;
        }
        var rect = tooltip.node.getBoundingClientRect(), assumed_width_px = 200, distance_to_right_edge = window.innerWidth - rect.x, horizontal_buffer = distance_to_right_edge < assumed_width_px
            ? assumed_width_px - distance_to_right_edge
            : 0, left = rect.x - horizontal_buffer + "px", top = rect.y + tooltip.node.offsetHeight + "px";
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
        if (_.isInteger(tooltip.show_for_n_sec)) {
            this.timeout = setTimeout(ToolTip.hide_tooltip, tooltip.show_for_n_sec * 1000);
        }
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { style: {
                top: top,
                left: left,
                maxWidth: "350px",
                background: "white",
                border: "1px solid",
                position: "fixed",
                padding: "5px",
                // @ts-expect-error ts-migrate(2322) FIXME: Type '"121"' is not assignable to type '"-moz-init... Remove this comment to see the full error message
                zIndex: "121"
            } }, tooltip.content));
    };
    return ToolTip;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));
/* harmony default export */ __webpack_exports__["default"] = (ToolTip);


/***/ }),

/***/ "./gdbgui/src/js/ToolTipTourguide.tsx":
/*!********************************************!*\
  !*** ./gdbgui/src/js/ToolTipTourguide.tsx ***!
  \********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Util */ "./gdbgui/src/js/Util.ts");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_2__);
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (undefined && undefined.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};



var ToolTipTourguide = /** @class */ (function (_super) {
    __extends(ToolTipTourguide, _super);
    function ToolTipTourguide(props) {
        var _this = _super.call(this, props) || this;
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'position' does not exist on type '{}'.
        if (!props.position && !(props.top && props.left)) {
            console.warn("did not receive position");
        }
        // @ts-expect-error ts-migrate(2551) FIXME: Property 'ref' does not exist on type 'ToolTipTour... Remove this comment to see the full error message
        _this.ref = react__WEBPACK_IMPORTED_MODULE_0___default.a.createRef();
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'connectComponentState' does not exist on... Remove this comment to see the full error message
        statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].connectComponentState(_this, [
            "tour_guide_step",
            "num_tour_guide_steps",
            "show_tour_guide"
        ]);
        return _this;
    }
    ToolTipTourguide.prototype.componentWillMount = function () {
        statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].set("num_tour_guide_steps", statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].get("num_tour_guide_steps") + 1);
    };
    ToolTipTourguide.dismiss = function () {
        statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].set("show_tour_guide", false);
        statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].set("tour_guide_step", 0);
        _Util__WEBPACK_IMPORTED_MODULE_1__["default"].persist_value_for_key("show_tour_guide");
    };
    ToolTipTourguide.next = function () {
        statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].set("tour_guide_step", statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].get("tour_guide_step") + 1);
    };
    ToolTipTourguide.prototype.guide_finshed = function () {
        statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].set("tour_guide_step", 0);
    };
    ToolTipTourguide.start_guide = function () {
        statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].set("tour_guide_step", 0);
        statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].set("show_tour_guide", true);
        _Util__WEBPACK_IMPORTED_MODULE_1__["default"].persist_value_for_key("show_tour_guide");
    };
    ToolTipTourguide.prototype.componentDidUpdate = function () {
        // @ts-expect-error ts-migrate(2551) FIXME: Property 'ref' does not exist on type 'ToolTipTour... Remove this comment to see the full error message
        if (this.state.show_tour_guide && this.ref.current) {
            // need to ensure absolute position is respected  by setting parent to
            // relative
            // @ts-expect-error ts-migrate(2551) FIXME: Property 'ref' does not exist on type 'ToolTipTour... Remove this comment to see the full error message
            this.ref.current.parentNode.style.position = "relative";
        }
    };
    ToolTipTourguide.prototype.get_position = function (position_name) {
        var top, left;
        switch (position_name) {
            case "left":
                top = "100%";
                left = "-50%";
                break;
            case "right":
                top = "50%";
                left = "0px";
                break;
            case "bottom":
            case "bottomcenter":
                top = "100%";
                left = "50%";
                break;
            case "bottomleft":
                top = "100%";
                left = "0";
                break;
            case "topleft":
                top = "0";
                left = "0";
                break;
            case "overlay":
                top = "50%";
                left = "50%";
                break;
            default:
                // @ts-expect-error ts-migrate(2339) FIXME: Property 'position' does not exist on type 'Readon... Remove this comment to see the full error message
                console.warn("invalid position " + this.props.position);
                top = "100%";
                left = "50%";
                break;
        }
        return [top, left];
    };
    ToolTipTourguide.prototype.render = function () {
        var _a;
        if (!this.state.show_tour_guide) {
            return null;
            // @ts-expect-error ts-migrate(2339) FIXME: Property 'step_num' does not exist on type 'Readon... Remove this comment to see the full error message
        }
        else if (this.props.step_num !== this.state.tour_guide_step) {
            return null;
        }
        var top, left;
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'top' does not exist on type 'Readonly<{}... Remove this comment to see the full error message
        if (this.props.top && this.props.left) {
            // @ts-expect-error ts-migrate(2339) FIXME: Property 'top' does not exist on type 'Readonly<{}... Remove this comment to see the full error message
            top = this.props.top;
            // @ts-expect-error ts-migrate(2339) FIXME: Property 'left' does not exist on type 'Readonly<{... Remove this comment to see the full error message
            left = this.props.left;
        }
        else {
            // @ts-expect-error ts-migrate(2339) FIXME: Property 'position' does not exist on type 'Readon... Remove this comment to see the full error message
            _a = __read(this.get_position(this.props.position), 2), top = _a[0], left = _a[1];
        }
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'step_num' does not exist on type 'Readon... Remove this comment to see the full error message
        var is_last_step = this.props.step_num + 1 === this.state.num_tour_guide_steps, dismiss = is_last_step ? null : (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "btn btn-default pointer", onClick: ToolTipTourguide.dismiss }, "Dismiss"));
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { 
            // @ts-expect-error ts-migrate(2551) FIXME: Property 'ref' does not exist on type 'ToolTipTour... Remove this comment to see the full error message
            ref: this.ref, style: {
                minWidth: "200px",
                maxWidth: "350px",
                background: "white",
                border: "1px solid",
                padding: "5px",
                // @ts-expect-error ts-migrate(2322) FIXME: Type '"1000"' is not assignable to type '"-moz-ini... Remove this comment to see the full error message
                zIndex: "1000",
                position: "absolute",
                overflow: "auto",
                whiteSpace: "normal",
                left: left,
                top: top,
                fontSize: "small",
                pointer: "normal"
            } },
            this.props.content,
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null),
            this.props.step_num + 1,
            " of ",
            this.state.num_tour_guide_steps,
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null),
            dismiss,
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "btn btn-primary pointer", onClick: ToolTipTourguide.next }, is_last_step ? "Finish" : "Next")));
    };
    return ToolTipTourguide;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));
/* harmony default export */ __webpack_exports__["default"] = (ToolTipTourguide);


/***/ }),

/***/ "./gdbgui/src/js/TopBar.tsx":
/*!**********************************!*\
  !*** ./gdbgui/src/js/TopBar.tsx ***!
  \**********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _BinaryLoader__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./BinaryLoader */ "./gdbgui/src/js/BinaryLoader.tsx");
/* harmony import */ var _ControlButtons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ControlButtons */ "./gdbgui/src/js/ControlButtons.tsx");
/* harmony import */ var _Settings__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Settings */ "./gdbgui/src/js/Settings.tsx");
/* harmony import */ var _SourceCodeHeading__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./SourceCodeHeading */ "./gdbgui/src/js/SourceCodeHeading.tsx");
/* harmony import */ var _ToolTipTourguide__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./ToolTipTourguide */ "./gdbgui/src/js/ToolTipTourguide.tsx");
/* harmony import */ var _FileOps__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./FileOps */ "./gdbgui/src/js/FileOps.tsx");
/* harmony import */ var _GdbApi__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./GdbApi */ "./gdbgui/src/js/GdbApi.tsx");
/* harmony import */ var _Actions__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Actions */ "./gdbgui/src/js/Actions.ts");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./constants */ "./gdbgui/src/js/constants.ts");
/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Util */ "./gdbgui/src/js/Util.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();












var onkeyup_jump_to_line = function (e) {
    if (e.keyCode === _constants__WEBPACK_IMPORTED_MODULE_10__["default"].ENTER_BUTTON_NUM) {
        _Actions__WEBPACK_IMPORTED_MODULE_9__["default"].set_line_state(e.currentTarget.value);
    }
};
var show_license = function () {
    _Actions__WEBPACK_IMPORTED_MODULE_9__["default"].show_modal("gdbgui license", react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment, null,
        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", { href: "https://github.com/cs01/gdbgui/blob/master/LICENSE" }, "GNU General Public License v3.0"),
        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, "Copyright \u00A9 Chad Smith"),
        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, "This software can be used personally or commercially for free."),
        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, "Permissions of this strong copyleft license are conditioned on making available complete source code of licensed works and modifications, which include larger works using a licensed work, under the same license. Copyright and license notices must be preserved. Contributors provide an express grant of patent rights."),
        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, "If you wish to redistribute gdbgui as part of a closed source product, you can do so for a fee. Contact chadsmith.software@gmail.com for details.")));
};
var About = {
    show_about: function () {
        _Actions__WEBPACK_IMPORTED_MODULE_9__["default"].show_modal("About gdbgui", react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", null,
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", null,
                "gdbgui, v",
                statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("gdbgui_version")),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", null, "Copyright \u00A9 Chad Smith"),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", null,
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", { href: "https://chadsmith.dev" }, "chadsmith.dev"))));
    }
};
var show_session_info = function () {
    _Actions__WEBPACK_IMPORTED_MODULE_9__["default"].show_modal("session information", react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment, null,
        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("table", null,
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("tbody", null,
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("tr", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("td", null,
                        "gdb version: ",
                        statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("gdb_version"))),
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("tr", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("td", null,
                        "gdb pid for this tab: ",
                        statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("gdb_pid"))),
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("tr", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("td", null,
                        "gdbgui v",
                        statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("gdbgui_version")))))));
};
var menu = (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("ul", { style: { height: 25, padding: 0, paddingRight: "15px", fontSize: "1.3em" }, className: "nav navbar-nav navbar-right" },
    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("li", { id: "menudropdown", className: "dropdown" },
        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", { href: "#", "data-toggle": "dropdown", role: "button", style: { height: 25, padding: 0, paddingRight: 20 }, className: "dropdown-toggle" },
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "glyphicon glyphicon-menu-hamburger" }, " ")),
        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("ul", { className: "dropdown-menu" },
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("li", null,
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", { title: "dashboard", className: "pointer", href: "/dashboard" }, "Dashboard")),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("li", null,
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", { title: "show guide", className: "pointer", onClick: _ToolTipTourguide__WEBPACK_IMPORTED_MODULE_6__["default"].start_guide }, "Show Guide")),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("li", null,
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", { onClick: show_session_info, className: "pointer" }, "Session Information")),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("li", { role: "separator", className: "divider" }),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("li", null,
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", { href: "https://github.com/cs01/gdbgui", className: "pointer" }, "GitHub")),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("li", null,
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", { href: "http://gdbgui.com", className: "pointer" }, "Homepage")),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("li", null,
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", { href: "https://www.youtube.com/channel/UCUCOSclB97r9nd54NpXMV5A" }, "YouTube Channel")),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("li", { role: "separator", className: "divider" }),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("li", null,
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", { onClick: show_license, className: "pointer" }, "License")),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("li", null,
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", { onClick: About.show_about, className: "pointer" }, "About gdbgui"))),
        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_ToolTipTourguide__WEBPACK_IMPORTED_MODULE_6__["default"]
        // @ts-expect-error ts-migrate(2322) FIXME: Property 'top' does not exist on type 'IntrinsicAt... Remove this comment to see the full error message
        , { 
            // @ts-expect-error ts-migrate(2322) FIXME: Property 'top' does not exist on type 'IntrinsicAt... Remove this comment to see the full error message
            top: "100%", left: "-300px", step_num: 0, content: react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", null,
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("h5", null, "Welcome to gdbgui."),
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null,
                    "This guide can be shown at any time by clicking the menu button,",
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "glyphicon glyphicon-menu-hamburger" }, " "),
                    ", then clicking \"Show Guide\".")) }))));
var TopBar = /** @class */ (function (_super) {
    __extends(TopBar, _super);
    function TopBar() {
        var _this = 
        // @ts-expect-error ts-migrate(2554) FIXME: Expected 1-2 arguments, but got 0.
        _super.call(this) || this;
        // state local to the component
        _this.state = {
            assembly_flavor: "intel",
            show_spinner: false
        };
        // global state attached to this component
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'connectComponentState' does not exist on... Remove this comment to see the full error message
        statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].connectComponentState(_this, [
            "debug_in_reverse",
            "reverse_supported",
            "source_code_state",
            "waiting_for_response",
            "show_filesystem",
            "latest_gdbgui_version",
            "gdbgui_version"
        ], _this.store_update_callback.bind(_this));
        _this.spinner_timeout = null;
        _this.spinner_timeout_msec = 5000;
        return _this;
    }
    TopBar.prototype.store_update_callback = function (keys) {
        if (keys.indexOf("waiting_for_response") !== -1) {
            this._clear_spinner_timeout();
            this.setState({ show_spinner: false });
            if (this.state.waiting_for_response === true) {
                // false to true
                this._set_spinner_timeout();
            }
        }
    };
    TopBar.prototype._set_spinner_timeout = function () {
        var _this = this;
        this.spinner_timeout = setTimeout(function () {
            if (_this.state.waiting_for_response) {
                _this.setState({ show_spinner: true });
            }
        }, this.spinner_timeout_msec);
    };
    TopBar.prototype._clear_spinner_timeout = function () {
        clearTimeout(this.spinner_timeout);
    };
    TopBar.prototype.toggle_assembly_flavor = function () {
        var flavor = this.state.assembly_flavor === "att" ? "intel" : "att";
        this.setState({ assembly_flavor: flavor });
        _GdbApi__WEBPACK_IMPORTED_MODULE_8__["default"].set_assembly_flavor(flavor);
        _Actions__WEBPACK_IMPORTED_MODULE_9__["default"].clear_cached_assembly();
        _FileOps__WEBPACK_IMPORTED_MODULE_7__["default"].fetch_assembly_cur_line();
    };
    TopBar.prototype.get_controls = function () {
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { role: "group", style: { marginBottom: 6, height: 25, width: 250 }, className: "btn-group btn-group" },
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_ToolTipTourguide__WEBPACK_IMPORTED_MODULE_6__["default"]
            // @ts-expect-error ts-migrate(2322) FIXME: Property 'step_num' does not exist on type 'Intrin... Remove this comment to see the full error message
            , { 
                // @ts-expect-error ts-migrate(2322) FIXME: Property 'step_num' does not exist on type 'Intrin... Remove this comment to see the full error message
                step_num: 3, position: "bottomleft", onClick: function (e) { return e.stopPropagation(); }, content: react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("h5", null, "These buttons allow you to control execution of the target you are debugging."),
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null,
                        "Hover over these buttons to see a description of their action. For example, the ",
                        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "glyphicon glyphicon-repeat" }),
                        " button starts (or restarts) a program from the beginning."),
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, "Each button has a keyboard shortcut. For example, you can press \"r\" to start running.")) }),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_ControlButtons__WEBPACK_IMPORTED_MODULE_3__["default"], null)));
    };
    TopBar.prototype.render = function () {
        var toggle_assm_button = "";
        if (this.state.source_code_state ===
            _constants__WEBPACK_IMPORTED_MODULE_10__["default"].source_code_states.ASSM_AND_SOURCE_CACHED ||
            this.state.source_code_state === _constants__WEBPACK_IMPORTED_MODULE_10__["default"].source_code_states.ASSM_CACHED) {
            // @ts-expect-error ts-migrate(2322) FIXME: Type 'Element' is not assignable to type 'string'.
            toggle_assm_button = (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { onClick: this.toggle_assembly_flavor.bind(this), type: "button", title: "Toggle between assembly flavors. The options are att or intel.", className: "btn btn-default btn-xs" },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { title: "Currently displaying " + this.state.assembly_flavor + ". Click to toggle." }, this.state.assembly_flavor)));
        }
        var reload_button_disabled = "disabled";
        if (this.state.source_code_state ===
            _constants__WEBPACK_IMPORTED_MODULE_10__["default"].source_code_states.ASSM_AND_SOURCE_CACHED ||
            this.state.source_code_state === _constants__WEBPACK_IMPORTED_MODULE_10__["default"].source_code_states.SOURCE_CACHED) {
            reload_button_disabled = "";
        }
        var reload_button = (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { onClick: _FileOps__WEBPACK_IMPORTED_MODULE_7__["default"].refresh_cached_source_files, type: "button", title: "Erase file from local cache and re-fetch it", className: "btn btn-default btn-xs " + reload_button_disabled },
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", null, "reload file")));
        var spinner = (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "", style: { height: "100%", margin: "5px", width: "14px" } }));
        if (this.state.show_spinner) {
            spinner = (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { className: "glyphicon glyphicon-refresh glyphicon-refresh-animate", style: { height: "100%", margin: "5px", width: "14px" } }));
        }
        var reverse_checkbox = (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("label", { title: "when clicking buttons to the right, pass the `--reverse` " +
                "flag to gdb in an attempt to debug in reverse. This is not always supported. " +
                "rr is known to support reverse debugging. Keyboard shortcuts go in " +
                "reverse when pressed with the shift key.", style: { fontWeight: "normal", fontSize: "0.9em", margin: "5px" } },
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", { type: "checkbox", disabled: !this.state.reverse_supported, checked: statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("debug_in_reverse"), onChange: function (e) {
                    statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("debug_in_reverse", e.target.checked);
                } }),
            "reverse"));
        return (react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { id: "top", style: { background: "#f5f6f7", position: "absolute", width: "100%" } },
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { className: "flexrow" },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_BinaryLoader__WEBPACK_IMPORTED_MODULE_2__["default"], { initial_user_input: this.props.initial_user_input }),
                spinner,
                reverse_checkbox,
                this.get_controls(),
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", { onClick: function () { return _Settings__WEBPACK_IMPORTED_MODULE_4__["default"].toggle_key("show_settings"); }, title: "settings", className: "pointer glyphicon glyphicon-cog", style: { marginRight: "10px", fontSize: "1.3em" } }),
                menu),
            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { style: { marginTop: 3, whitespace: "nowrap" }, className: "flexrow" },
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { role: "group", style: { height: "25px", marginRight: "10px" }, className: "btn-group btn-group" },
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { className: "btn btn-default btn-xs", title: "Toggle file explorer visibility", onClick: function () {
                            var middle_pane_sizes = statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("middle_panes_split_obj").getSizes(), file_explorer_size = middle_pane_sizes[0], source_size = middle_pane_sizes[1], sidebar_size = middle_pane_sizes[2], new_file_explorer_size, new_source_size, new_sidebar_size;
                            if (statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("show_filesystem")) {
                                // hide it since it's shown right now
                                new_file_explorer_size = 0;
                                new_source_size = source_size + file_explorer_size / 2;
                                new_sidebar_size = sidebar_size + file_explorer_size / 2;
                            }
                            else {
                                new_file_explorer_size = 30;
                                new_source_size = Math.max(30, source_size - new_file_explorer_size / 2);
                                new_sidebar_size = 99 - new_file_explorer_size - new_source_size;
                            }
                            statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("show_filesystem", !statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("show_filesystem"));
                            localStorage.setItem("show_filesystem", JSON.stringify(statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("show_filesystem"))); // save this for next session
                            statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"]
                                .get("middle_panes_split_obj")
                                .setSizes([new_file_explorer_size, new_source_size, new_sidebar_size]);
                        } }, statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("show_filesystem") ? "hide filesystem" : "show filesystem"),
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", { onClick: function () { return _FileOps__WEBPACK_IMPORTED_MODULE_7__["default"].fetch_assembly_cur_line(); }, type: "button", title: "fetch disassembly", className: "btn btn-default btn-xs" },
                        react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", null, "fetch disassembly")),
                    reload_button,
                    toggle_assm_button),
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", { onKeyUp: onkeyup_jump_to_line, autoComplete: "on", title: "Enter line number, then press enter", placeholder: "jump to line", style: { width: 150, height: 25, marginLeft: 10 }, className: "form-control dropdown-input" }),
                react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", { style: {
                        marginRight: 5,
                        marginLeft: 5,
                        marginTop: 5,
                        whiteSpace: "nowrap",
                        fontFamily: "monospace",
                        fontSize: "0.7em",
                        display: "flex",
                        overflow: "auto"
                    }, className: "lighttext" },
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_SourceCodeHeading__WEBPACK_IMPORTED_MODULE_5__["default"], null)))));
    };
    TopBar.needs_to_update_gdbgui_version = function () {
        // to actually check each value:
        try {
            return _Util__WEBPACK_IMPORTED_MODULE_11__["default"].is_newer(statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("latest_gdbgui_version"), statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("gdbgui_version"));
        }
        catch (err) {
            console.error(err);
            return true;
        }
    };
    return TopBar;
}(react__WEBPACK_IMPORTED_MODULE_0___default.a.Component));
/* harmony default export */ __webpack_exports__["default"] = (TopBar);


/***/ }),

/***/ "./gdbgui/src/js/Tree.ts":
/*!*******************************!*\
  !*** ./gdbgui/src/js/Tree.ts ***!
  \*******************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _GdbVariable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./GdbVariable */ "./gdbgui/src/js/GdbVariable.tsx");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./gdbgui/src/js/constants.ts");
// a widget to visualize a tree view of a variable with children
// utilizes the amazing http://visjs.org library
var __values = (undefined && undefined.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
/* global vis */



var Tree = {
    el: null,
    width_input: null,
    height_input: null,
    init: function () {
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'subscribeToKeys' does not exist on type ... Remove this comment to see the full error message
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].subscribeToKeys(["root_gdb_tree_var", "expressions", "root_gdb_tree_var"], Tree._render);
        var render_on_enter = function (e) {
            if (e.keyCode === 13) {
                Tree._render();
            }
        };
        // @ts-expect-error ts-migrate(2322) FIXME: Type 'HTMLElement' is not assignable to type 'null... Remove this comment to see the full error message
        Tree.el = document.getElementById(_constants__WEBPACK_IMPORTED_MODULE_2__["default"].tree_component_id);
        // @ts-expect-error ts-migrate(2322) FIXME: Type 'HTMLElement' is not assignable to type 'null... Remove this comment to see the full error message
        Tree.width_input = document.getElementById("tree_width");
        // @ts-expect-error ts-migrate(2322) FIXME: Type 'HTMLElement' is not assignable to type 'null... Remove this comment to see the full error message
        Tree.height_input = document.getElementById("tree_height");
        // @ts-expect-error ts-migrate(2531) FIXME: Object is possibly 'null'.
        Tree.width_input.onkeyup = render_on_enter;
        // @ts-expect-error ts-migrate(2531) FIXME: Object is possibly 'null'.
        Tree.height_input.onkeyup = render_on_enter;
    },
    network: null,
    rendered_gdb_var_tree_root: null,
    gdb_var_being_updated: null,
    _render: function () {
        var gdbvar = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("root_gdb_tree_var");
        if (!gdbvar) {
            // @ts-expect-error ts-migrate(2531) FIXME: Object is possibly 'null'.
            Tree.el.innerHTML = "\n            <span class=placeholder>\n                create an Expression, then click <span class='glyphicon glyphicon-tree-deciduous'></span>\n                when viewing a variable with children to interactively explore a tree view. You can click nodes to\n                expand/collapse them.\n            </span>";
            return;
        }
        var expressions = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get("expressions"), gdb_root_var_to_update = Tree.gdb_var_being_updated
            ? Tree.gdb_var_being_updated
            : gdbvar, gdb_var_obj = _GdbVariable__WEBPACK_IMPORTED_MODULE_1__["default"].get_obj_from_gdb_var_name(expressions, gdb_root_var_to_update);
        if (!gdb_var_obj) {
            // couldn't find this variable name in our list of variables. Probably was a local variable the
            // user graphed, then hit continue, and the variable was erased by gdb. This is expected.
            // "GdbVariable" that users enter persist between stepping through the program though,
            // so it's not expected that this line will be executed for an expression
            statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("root_gdb_tree_var", "");
            return;
        }
        if (gdbvar === Tree.rendered_gdb_var_tree_root) {
            // nodes is an Object with keys corresponding to node id's (which are gdb_var_names)
            Tree._add_nodes_and_edges(gdb_var_obj, undefined, 
            // @ts-expect-error ts-migrate(2531) FIXME: Object is possibly 'null'.
            Tree.network.body.nodes, 
            // @ts-expect-error ts-migrate(2531) FIXME: Object is possibly 'null'.
            Tree.network.body.edges);
        }
        else {
            Tree.render_new_network(gdb_var_obj);
        }
        Tree._update_canvas_size();
        Tree.rendered_gdb_var_tree_root = gdbvar;
        Tree.gdb_var_being_updated = null;
    },
    _update_canvas_size: function () {
        // @ts-expect-error ts-migrate(2531) FIXME: Object is possibly 'null'.
        if (Tree.network && Tree.network.canvas && Tree.network.canvas.options) {
            // @ts-expect-error ts-migrate(2531) FIXME: Object is possibly 'null'.
            if (parseInt(Tree.width_input.value)) {
                // @ts-expect-error ts-migrate(2531) FIXME: Object is possibly 'null'.
                Tree.network.canvas.options["width"] = parseInt(Tree.width_input.value) + "px";
            }
            else {
                // @ts-expect-error ts-migrate(2531) FIXME: Object is possibly 'null'.
                Tree.network.canvas.options["width"] = "100%";
            }
            // @ts-expect-error ts-migrate(2531) FIXME: Object is possibly 'null'.
            if (Tree.height_input.value) {
                // @ts-expect-error ts-migrate(2531) FIXME: Object is possibly 'null'.
                Tree.network.canvas.options["height"] = parseInt(Tree.height_input.value) + "px";
            }
            else {
                // @ts-expect-error ts-migrate(2531) FIXME: Object is possibly 'null'.
                Tree.network.canvas.options["height"] = "100%";
            }
        }
    },
    // @param node: gdb variable object
    // @return string for node label in the tree
    _get_node_label: function (node) {
        var e_1, _a;
        var label = [];
        if (node.value) {
            label.push(node.value);
        }
        if (node.type) {
            label.push(node.type);
        }
        if (node.children.some(function (c) { return c.numchild === 0; })) {
            label.push("field(s):");
        }
        // children field is only populated when user expands a data structure
        // numchild is always present
        // if children have been fetched and are simple values (i.e. don't have children of their own),
        // show them in the same node. If the child has children of its own, show it as a "hidden child" of this node
        var hidden_children = 0;
        try {
            for (var _b = __values(node.children), _c = _b.next(); !_c.done; _c = _b.next()) {
                var child = _c.value;
                if (child.numchild === 0) {
                    label.push(child.exp + ": " + child.value + " (" + child.type + ")");
                }
                else {
                    hidden_children++;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        if (node.show_children_in_ui === false && hidden_children > 0) {
            // children have previously been fetched but are now hidden since user toggled visibility
            var child_text = hidden_children === 1 ? "child" : "children";
            label.push("+ " + hidden_children + " " + child_text);
        }
        else if (node.numchild !== node.children.length) {
            // children have not yet been fetched, but gdb told us this node has children. We don't know if they
            // are "simple" values, or complex with children of their own. We just know they exist.
            var child_text = node.numchild === 1 ? "child" : "children";
            label.push("+ " + node.numchild + " " + child_text);
        }
        return label.join("\n");
    },
    // mutates Tree.nodes and Tree.edges  to (recursively) reflect node and its children
    // by either adding new nodes, modifying existing nodes, or deleting nodes that should be hidden
    // depending on the store of the existing nodes.
    // If updating a node, the background is highlighted yellow if the value changed
    // @param node: gdb variable object that should be added to Tree.nodes
    // @param parent: parent node of node. undefined when node is root.
    // @return nothing
    _add_nodes_and_edges: function (node, parent) {
        var e_2, _a, e_3, _b;
        // add/update this node
        var node_label = Tree._get_node_label(node);
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'nodes' does not exist on type '{ el: nul... Remove this comment to see the full error message
        if (node.name in Tree.nodes._data) {
            // compare old value and new value
            // if value changed, make it yellow!
            // @ts-expect-error ts-migrate(2339) FIXME: Property 'nodes' does not exist on type '{ el: nul... Remove this comment to see the full error message
            var old_label = Tree.nodes._data[node.name].label, bgcolor = node_label === old_label ? "white" : "yellow";
            // @ts-expect-error ts-migrate(2339) FIXME: Property 'nodes' does not exist on type '{ el: nul... Remove this comment to see the full error message
            Tree.nodes.update({
                id: node.name,
                label: Tree._get_node_label(node),
                color: { background: bgcolor }
            });
        }
        else {
            // @ts-expect-error ts-migrate(2339) FIXME: Property 'nodes' does not exist on type '{ el: nul... Remove this comment to see the full error message
            Tree.nodes.add({ id: node.name, label: Tree._get_node_label(node) });
        }
        // add edge from this node to parent if it's not there
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'edges' does not exist on type '{ el: nul... Remove this comment to see the full error message
        if (parent && !(node.name in Tree.edges._data)) {
            // @ts-expect-error ts-migrate(2339) FIXME: Property 'edges' does not exist on type '{ el: nul... Remove this comment to see the full error message
            Tree.edges.add({
                id: node.name,
                from: parent.name,
                to: node.name,
                label: node.exp
            });
        }
        // add/update/delete child nodes
        if (node.show_children_in_ui) {
            try {
                // add/update child nodes
                for (var _c = __values(node.children), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var child = _d.value;
                    if (child.numchild > 0) {
                        Tree._add_nodes_and_edges(child, node);
                    }
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
        else {
            try {
                // recursively delete to make invisible
                for (var _e = __values(node.children), _f = _e.next(); !_f.done; _f = _e.next()) {
                    var child = _f.value;
                    Tree._dfs(child, function (node) {
                        // @ts-expect-error ts-migrate(2339) FIXME: Property 'nodes' does not exist on type '{ el: nul... Remove this comment to see the full error message
                        Tree.nodes.remove({ id: node.name });
                        // @ts-expect-error ts-migrate(2339) FIXME: Property 'edges' does not exist on type '{ el: nul... Remove this comment to see the full error message
                        Tree.edges.remove({ id: node.name });
                    });
                }
            }
            catch (e_3_1) { e_3 = { error: e_3_1 }; }
            finally {
                try {
                    if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
                }
                finally { if (e_3) throw e_3.error; }
            }
        }
    },
    // depth-first search of node and its children. `callback` is run on each node as it is visited by
    // this function
    _dfs: function (node, callback) {
        var e_4, _a;
        callback(node);
        try {
            for (var _b = __values(node.children), _c = _b.next(); !_c.done; _c = _b.next()) {
                var child = _c.value;
                Tree._dfs(child, callback);
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_4) throw e_4.error; }
        }
    },
    // sets Tree.network to be a visjs network consisting of root_gdb_var_obj and all its children
    // @param root_gdb_var_obj root gdb variable object for which a network should be rendered
    // @return nothing
    render_new_network: function (root_gdb_var_obj) {
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'nodes' does not exist on type '{ el: nul... Remove this comment to see the full error message
        Tree.nodes = new vis.DataSet();
        // @ts-expect-error ts-migrate(2339) FIXME: Property 'edges' does not exist on type '{ el: nul... Remove this comment to see the full error message
        Tree.edges = new vis.DataSet();
        // @ts-expect-error ts-migrate(2554) FIXME: Expected 2 arguments, but got 1.
        Tree._add_nodes_and_edges(root_gdb_var_obj);
        // create the network
        var data = {
            // @ts-expect-error ts-migrate(2339) FIXME: Property 'nodes' does not exist on type '{ el: nul... Remove this comment to see the full error message
            nodes: Tree.nodes,
            // @ts-expect-error ts-migrate(2339) FIXME: Property 'edges' does not exist on type '{ el: nul... Remove this comment to see the full error message
            edges: Tree.edges
        };
        // options found by browsing through examples here:
        // http://visjs.org/network_examples.html
        var options = {
            nodes: {
                shape: "box",
                color: { background: "white" }
            },
            layout: {
                randomSeed: 0,
                hierarchical: {
                    direction: "UD",
                    sortMethod: "directed"
                }
            },
            interaction: { dragNodes: true },
            physics: {
                enabled: false
            }
        };
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name 'vis'.
        Tree.network = new vis.Network(Tree.el, data, options);
        // http://visjs.org/examples/network/events/interactionEvents.html
        // @ts-expect-error ts-migrate(2531) FIXME: Object is possibly 'null'.
        Tree.network.on("click", function (params) {
            // left click toggles child visibility
            // @ts-expect-error ts-migrate(2683) FIXME: 'this' implicitly has type 'any' because it does n... Remove this comment to see the full error message
            var gdb_var_name = this.getNodeAt(params.pointer.DOM);
            Tree.gdb_var_being_updated = gdb_var_name;
            if (!gdb_var_name) {
                return;
            }
            if (gdb_var_name) {
                _GdbVariable__WEBPACK_IMPORTED_MODULE_1__["default"]._toggle_children_visibility(gdb_var_name);
            }
        });
    }
};
/* harmony default export */ __webpack_exports__["default"] = (Tree);


/***/ }),

/***/ "./gdbgui/src/js/Util.ts":
/*!*******************************!*\
  !*** ./gdbgui/src/js/Util.ts ***!
  \*******************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_0__);
var __values = (undefined && undefined.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};

/**
 * Some general utility methods
 */
var Util = {
    persist_value_for_key: function (key) {
        try {
            var value = statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].get(key);
            localStorage.setItem(key, JSON.stringify(value));
        }
        catch (err) {
            console.error(err);
        }
    },
    /**
     * Get html table
     * @param columns: array of strings
     * @param data: array of arrays of data
     */
    get_table: function (columns, data, style) {
        var e_1, _a, e_2, _b, e_3, _c;
        if (style === void 0) { style = ""; }
        var result = [
            "<table class='table table-bordered table-condensed' style=\"" + style + "\">"
        ];
        if (columns) {
            result.push("<thead>");
            result.push("<tr>");
            try {
                for (var columns_1 = __values(columns), columns_1_1 = columns_1.next(); !columns_1_1.done; columns_1_1 = columns_1.next()) {
                    var h = columns_1_1.value;
                    result.push("<th>" + h + "</th>");
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (columns_1_1 && !columns_1_1.done && (_a = columns_1.return)) _a.call(columns_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            result.push("</tr>");
            result.push("</thead>");
        }
        if (data) {
            result.push("<tbody>");
            try {
                for (var data_1 = __values(data), data_1_1 = data_1.next(); !data_1_1.done; data_1_1 = data_1.next()) {
                    var row = data_1_1.value;
                    result.push("<tr>");
                    try {
                        for (var row_1 = (e_3 = void 0, __values(row)), row_1_1 = row_1.next(); !row_1_1.done; row_1_1 = row_1.next()) {
                            var cell = row_1_1.value;
                            result.push("<td>" + cell + "</td>");
                        }
                    }
                    catch (e_3_1) { e_3 = { error: e_3_1 }; }
                    finally {
                        try {
                            if (row_1_1 && !row_1_1.done && (_c = row_1.return)) _c.call(row_1);
                        }
                        finally { if (e_3) throw e_3.error; }
                    }
                    result.push("</tr>");
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (data_1_1 && !data_1_1.done && (_b = data_1.return)) _b.call(data_1);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
        result.push("</tbody>");
        result.push("</table>");
        return result.join("\n");
    },
    /**
     * Escape gdb's output to be browser compatible
     * @param s: string to mutate
     */
    escape: function (s) {
        return s
            .replace(/>/g, "&gt;")
            .replace(/</g, "&lt;")
            .replace(/\\n/g, "<br>")
            .replace(/\\r/g, "")
            .replace(/\\"/g, '"')
            .replace(/\\t/g, "&nbsp");
    },
    /**
     * take a string of html in JavaScript and strip out the html
     * http://stackoverflow.com/a/822486/2893090
     */
    get_text_from_html: function (html) {
        var tmp = document.createElement("DIV");
        tmp.innerHTML = html;
        return tmp.textContent || tmp.innerText || "";
    },
    /**
     * @param fullname_and_line: i.e. /path/to/file.c:78
     * @param default_line_if_not_found: i.e. 0
     * @return: Array, with 0'th element == path, 1st element == line
     */
    parse_fullname_and_line: function (fullname_and_line, default_line_if_not_found) {
        if (default_line_if_not_found === void 0) { default_line_if_not_found = undefined; }
        var user_input_array = fullname_and_line.split(":"), fullname = user_input_array[0], line = default_line_if_not_found;
        if (user_input_array.length === 2) {
            line = user_input_array[1];
        }
        // @ts-expect-error ts-migrate(2345) FIXME: Argument of type 'undefined' is not assignable to ... Remove this comment to see the full error message
        return [fullname, parseInt(line)];
    },
    string_to_array_safe_quotes: function (str) {
        var output = [], cur_str = "", in_quotes = false;
        for (var i = 0; i < str.length; i++) {
            var char = str[i];
            if (char === '"') {
                in_quotes = !in_quotes;
                cur_str += char;
            }
            else if (char !== " " || (char === " " && in_quotes)) {
                cur_str += char;
            }
            else if (char === " ") {
                // got a space outside of quotes
                if (cur_str === "") {
                    // a consecutive space. do nothing.
                }
                else {
                    // save this argument, and reset cur_str
                    output.push(cur_str);
                    cur_str = "";
                }
            }
        }
        if (cur_str !== "") {
            output.push(cur_str);
        }
        return output;
    },
    /* Return true is latest is > current
      1.0.0, 0.9.9 -> true
      0.1.0, 0.0.9 -> true
      0.0.9, 0.0.8 -> false
    */
    is_newer: function (latest, current) {
        latest = latest.split(".");
        current = current.split(".");
        if (latest.length !== current.length) {
            return true;
        }
        for (var i in latest) {
            if (latest[i] > current[i]) {
                return true;
            }
        }
        return false;
    }
};
/* harmony default export */ __webpack_exports__["default"] = (Util);


/***/ }),

/***/ "./gdbgui/src/js/constants.ts":
/*!************************************!*\
  !*** ./gdbgui/src/js/constants.ts ***!
  \************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
var constants = {
    ENTER_BUTTON_NUM: 13,
    TAB_BUTTON_NUM: 9,
    LEFT_BUTTON_NUM: 37,
    UP_BUTTON_NUM: 38,
    RIGHT_BUTTON_NUM: 39,
    DOWN_BUTTON_NUM: 40,
    Y_BUTTON_NUM: 89,
    N_BUTTON_NUM: 78,
    COMMA_BUTTON_NUM: 188,
    DATE_FORMAT: "dddd, MMMM Do YYYY, h:mm:ss a",
    IGNORE_ERRORS_TOKEN_STR: "1",
    DISASSEMBLY_FOR_MISSING_FILE_STR: "2",
    CREATE_VAR_STR: "3",
    INLINE_DISASSEMBLY_STR: "4",
    console_entry_type: {
        SENT_COMMAND: "SENT_COMMAND",
        STD_ERR: "STD_ERR",
        STD_OUT: "STD_OUT",
        GDBGUI_OUTPUT: "GDBGUI_OUTPUT",
        GDBGUI_OUTPUT_RAW: "GDBGUI_OUTPUT_RAW",
        AUTOCOMPLETE_OPTION: "AUTOCOMPLETE_OPTION"
    },
    source_code_selection_states: {
        USER_SELECTION: "USER_SELECTION",
        PAUSED_FRAME: "PAUSED_FRAME"
    },
    source_code_states: {
        ASSM_AND_SOURCE_CACHED: "ASSM_AND_SOURCE_CACHED",
        SOURCE_CACHED: "SOURCE_CACHED",
        FETCHING_SOURCE: "FETCHING_SOURCE",
        ASSM_CACHED: "ASSM_CACHED",
        FETCHING_ASSM: "FETCHING_ASSM",
        ASSM_UNAVAILABLE: "ASSM_UNAVAILABLE",
        FILE_MISSING: "FILE_MISSING",
        NONE_AVAILABLE: "NONE_AVAILABLE"
    },
    inferior_states: {
        unknown: "unknown",
        running: "running",
        paused: "paused",
        exited: "exited"
    },
    tree_component_id: "tree",
    default_max_lines_of_code_to_fetch: 500,
    keys_to_not_log_changes_in_console: ["gdb_mi_output"],
    xtermColors: {
        reset: "\x1B[0m",
        red: "\x1B[31m",
        grey: "\x1b[1;30m",
        green: "\x1B[0;32m",
        lgreen: "\x1B[1;32m",
        blue: "\x1B[0;34m",
        lblue: "\x1B[1;34m",
        yellow: "\x1B[0;33m"
    }
};
var colorTypeMap = {};
// @ts-expect-error ts-migrate(7053) FIXME: No index signature with a parameter of type 'strin... Remove this comment to see the full error message
colorTypeMap[constants.console_entry_type.STD_OUT] = constants.xtermColors["reset"];
// @ts-expect-error ts-migrate(7053) FIXME: No index signature with a parameter of type 'strin... Remove this comment to see the full error message
colorTypeMap[constants.console_entry_type.STD_ERR] = constants.xtermColors["red"];
// @ts-expect-error ts-migrate(7053) FIXME: No index signature with a parameter of type 'strin... Remove this comment to see the full error message
colorTypeMap[constants.console_entry_type.SENT_COMMAND] = constants.xtermColors["lblue"];
// @ts-expect-error ts-migrate(7053) FIXME: No index signature with a parameter of type 'strin... Remove this comment to see the full error message
colorTypeMap[constants.console_entry_type.GDBGUI_OUTPUT] =
    constants.xtermColors["yellow"];
// @ts-expect-error ts-migrate(7053) FIXME: No index signature with a parameter of type 'strin... Remove this comment to see the full error message
colorTypeMap[constants.console_entry_type.GDBGUI_OUTPUT_RAW] =
    constants.xtermColors["green"];
// @ts-expect-error ts-migrate(7053) FIXME: Property 'colorTypeMap' does not exist on type '{ ... Remove this comment to see the full error message
constants["colorTypeMap"] = colorTypeMap;
// @ts-expect-error ts-migrate(2551) FIXME: Property 'IGNORE_ERRORS_TOKEN_INT' does not exist ... Remove this comment to see the full error message
constants["IGNORE_ERRORS_TOKEN_INT"] = parseInt(constants.IGNORE_ERRORS_TOKEN_STR);
// @ts-expect-error ts-migrate(2551) FIXME: Property 'DISASSEMBLY_FOR_MISSING_FILE_INT' does n... Remove this comment to see the full error message
constants["DISASSEMBLY_FOR_MISSING_FILE_INT"] = parseInt(constants.DISASSEMBLY_FOR_MISSING_FILE_STR);
// @ts-expect-error ts-migrate(2551) FIXME: Property 'CREATE_VAR_INT' does not exist on type '... Remove this comment to see the full error message
constants["CREATE_VAR_INT"] = parseInt(constants.CREATE_VAR_STR);
// @ts-expect-error ts-migrate(2551) FIXME: Property 'INLINE_DISASSEMBLY_INT' does not exist o... Remove this comment to see the full error message
constants["INLINE_DISASSEMBLY_INT"] = parseInt(constants.INLINE_DISASSEMBLY_STR);
/* harmony default export */ __webpack_exports__["default"] = (Object.freeze(constants));


/***/ }),

/***/ "./gdbgui/src/js/gdbgui.tsx":
/*!**********************************!*\
  !*** ./gdbgui/src/js/gdbgui.tsx ***!
  \**********************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react-dom */ "./node_modules/react-dom/index.js");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "./gdbgui/src/js/constants.ts");
/* harmony import */ var _GdbApi__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./GdbApi */ "./gdbgui/src/js/GdbApi.tsx");
/* harmony import */ var _FileOps__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./FileOps */ "./gdbgui/src/js/FileOps.tsx");
/* harmony import */ var _FoldersView__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./FoldersView */ "./gdbgui/src/js/FoldersView.tsx");
/* harmony import */ var _GlobalEvents__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./GlobalEvents */ "./gdbgui/src/js/GlobalEvents.ts");
/* harmony import */ var _HoverVar__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./HoverVar */ "./gdbgui/src/js/HoverVar.tsx");
/* harmony import */ var _InitialStoreData__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./InitialStoreData */ "./gdbgui/src/js/InitialStoreData.ts");
/* harmony import */ var _MiddleLeft__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./MiddleLeft */ "./gdbgui/src/js/MiddleLeft.tsx");
/* harmony import */ var _GdbguiModal__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./GdbguiModal */ "./gdbgui/src/js/GdbguiModal.tsx");
/* harmony import */ var _RightSidebar__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./RightSidebar */ "./gdbgui/src/js/RightSidebar.tsx");
/* harmony import */ var _Settings__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./Settings */ "./gdbgui/src/js/Settings.tsx");
/* harmony import */ var _ToolTip__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./ToolTip */ "./gdbgui/src/js/ToolTip.tsx");
/* harmony import */ var _TopBar__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./TopBar */ "./gdbgui/src/js/TopBar.tsx");
/* harmony import */ var _ToolTipTourguide__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./ToolTipTourguide */ "./gdbgui/src/js/ToolTipTourguide.tsx");
/* harmony import */ var _static_css_gdbgui_css__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../static/css/gdbgui.css */ "./gdbgui/static/css/gdbgui.css");
/* harmony import */ var _static_css_gdbgui_css__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(_static_css_gdbgui_css__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var _static_css_splitjs_gdbgui_css__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../static/css/splitjs-gdbgui.css */ "./gdbgui/static/css/splitjs-gdbgui.css");
/* harmony import */ var _static_css_splitjs_gdbgui_css__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(_static_css_splitjs_gdbgui_css__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var _Terminals__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./Terminals */ "./gdbgui/src/js/Terminals.tsx");
/**
 * This is the entrypoint to the frontend applicaiton.
 *
 * store (global state) is managed in a single location, and each time the store
 * changes, components are notified and update accordingly.
 *
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/* global Split */
/* global initial_data */
/* global debug */


// @ts-expect-error ts-migrate(2305) FIXME: Module '"statorgfc"' has no exported member 'middl... Remove this comment to see the full error message


















var store_options = {
    immutable: false,
    debounce_ms: 10
};
// @ts-expect-error ts-migrate(2339) FIXME: Property 'initialize' does not exist on type '{ ge... Remove this comment to see the full error message
statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].initialize(_InitialStoreData__WEBPACK_IMPORTED_MODULE_9__["default"], store_options);
// @ts-expect-error ts-migrate(2304) FIXME: Cannot find name 'debug'.
if (debug) {
    // log call store changes in console except if changed key was in
    // constants.keys_to_not_log_changes_in_console
    // @ts-expect-error ts-migrate(2339) FIXME: Property 'use' does not exist on type '{ get(key: ... Remove this comment to see the full error message
    statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].use(function (key, oldval, newval) {
        if (_constants__WEBPACK_IMPORTED_MODULE_3__["default"].keys_to_not_log_changes_in_console.indexOf(key) === -1) {
            statorgfc__WEBPACK_IMPORTED_MODULE_2__["middleware"].logChanges(key, oldval, newval);
        }
        return true;
    });
}
// make this visible in the console
// @ts-expect-error ts-migrate(2339) FIXME: Property 'store' does not exist on type 'Window & ... Remove this comment to see the full error message
window.store = statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"];
var Gdbgui = /** @class */ (function (_super) {
    __extends(Gdbgui, _super);
    function Gdbgui() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Gdbgui.prototype.componentWillMount = function () {
        _GdbApi__WEBPACK_IMPORTED_MODULE_4__["default"].init();
        _GlobalEvents__WEBPACK_IMPORTED_MODULE_7__["default"].init();
        _FileOps__WEBPACK_IMPORTED_MODULE_5__["default"].init(); // this should be initialized before components that use store key 'source_code_state'
    };
    Gdbgui.prototype.render = function () {
        return (react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { className: "splitjs_container" },
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_TopBar__WEBPACK_IMPORTED_MODULE_15__["default"], { initial_user_input: initial_data.initial_binary_and_args }),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { id: "middle", style: { paddingTop: "60px" } },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { id: "folders_view", className: "content", style: { backgroundColor: "#333" } },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_FoldersView__WEBPACK_IMPORTED_MODULE_6__["default"], null)),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { id: "source_code_view", className: "content" },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_MiddleLeft__WEBPACK_IMPORTED_MODULE_10__["default"], null)),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { id: "controls_sidebar", className: "content", style: { overflowX: "visible" } },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_RightSidebar__WEBPACK_IMPORTED_MODULE_12__["default"], { signals: initial_data.signals, debug: debug }))),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { id: "bottom", className: "split split-horizontal", style: { width: "100%", height: "100%" } },
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_ToolTipTourguide__WEBPACK_IMPORTED_MODULE_16__["default"]
                // @ts-expect-error ts-migrate(2322) FIXME: Property 'step_num' does not exist on type 'Intrin... Remove this comment to see the full error message
                , { 
                    // @ts-expect-error ts-migrate(2322) FIXME: Property 'step_num' does not exist on type 'Intrin... Remove this comment to see the full error message
                    step_num: 4, position: "topleft", content: react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", null,
                        react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("h5", null, "You can view gdb's output here."),
                        "You usually don't need to enter commands here, but you have the option to if there is something you can't do in the UI.") }),
                react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div", { id: "bottom_content", className: "split content" },
                    react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Terminals__WEBPACK_IMPORTED_MODULE_19__["Terminals"], null))),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_GdbguiModal__WEBPACK_IMPORTED_MODULE_11__["default"], null),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_HoverVar__WEBPACK_IMPORTED_MODULE_8__["default"], null),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_Settings__WEBPACK_IMPORTED_MODULE_13__["default"], null),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_ToolTip__WEBPACK_IMPORTED_MODULE_14__["default"], null),
            react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("textarea", { style: {
                    width: "0px",
                    height: "0px",
                    position: "absolute",
                    top: "0",
                    left: "-1000px"
                }, ref: function (node) {
                    statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].set("textarea_to_copy_to_clipboard", node);
                } })));
    };
    Gdbgui.prototype.componentDidMount = function () {
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name 'debug'.
        if (debug) {
            // @ts-expect-error ts-migrate(2339) FIXME: Property 'getUnwatchedKeys' does not exist on type... Remove this comment to see the full error message
            console.warn(statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].getUnwatchedKeys());
        }
        // Split the body into different panes using splitjs (https://github.com/nathancahill/Split.js)
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name 'Split'.
        var middle_panes_split_obj = Split(["#folders_view", "#source_code_view", "#controls_sidebar"], {
            gutterSize: 8,
            minSize: 100,
            cursor: "col-resize",
            direction: "horizontal",
            sizes: statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].get("show_filesystem") ? [30, 40, 29] : [0, 70, 29] // adding to exactly 100% is a little buggy due to splitjs, so keep it to 99
        });
        // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name 'Split'.
        Split(["#middle", "#bottom"], {
            gutterSize: 8,
            cursor: "row-resize",
            direction: "vertical",
            sizes: [70, 30]
        });
        statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].set("middle_panes_split_obj", middle_panes_split_obj);
        // Fetch the latest version only if using in normal mode. If debugging, we tend to
        // refresh quite a bit, which might make too many requests to github and cause them
        // to block our ip? Either way it just seems weird to make so many ajax requests.
        if (!statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].get("debug")) {
            // fetch version
            $.ajax({
                url: "https://raw.githubusercontent.com/cs01/gdbgui/master/gdbgui/VERSION.txt",
                cache: false,
                method: "GET",
                success: function (data) {
                    // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
                    statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].set("latest_gdbgui_version", _.trim(data));
                },
                error: function (data) {
                    void data;
                    statorgfc__WEBPACK_IMPORTED_MODULE_2__["store"].set("latest_gdbgui_version", "(could not contact server)");
                }
            });
        }
    };
    return Gdbgui;
}(react__WEBPACK_IMPORTED_MODULE_1___default.a.PureComponent));
react_dom__WEBPACK_IMPORTED_MODULE_0___default.a.render(react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(Gdbgui, null), document.getElementById("gdbgui"));


/***/ }),

/***/ "./gdbgui/src/js/processFeatures.ts":
/*!******************************************!*\
  !*** ./gdbgui/src/js/processFeatures.ts ***!
  \******************************************/
/*! exports provided: processFeatures */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "processFeatures", function() { return processFeatures; });
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_0__);
// https://sourceware.org/gdb/onlinedocs/gdb/GDB_002fMI-Support-Commands.html#GDB_002fMI-Support-Commands

function processFeatures(features) {
    if (features.indexOf("reverse") !== -1) {
        statorgfc__WEBPACK_IMPORTED_MODULE_0__["store"].set("reverse_supported", true);
    }
}


/***/ }),

/***/ "./gdbgui/src/js/process_gdb_response.tsx":
/*!************************************************!*\
  !*** ./gdbgui/src/js/process_gdb_response.tsx ***!
  \************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! statorgfc */ "./node_modules/statorgfc/build/statorgfc.js");
/* harmony import */ var statorgfc__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(statorgfc__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _GdbMiOutput__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./GdbMiOutput */ "./gdbgui/src/js/GdbMiOutput.tsx");
/* harmony import */ var _Breakpoints__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Breakpoints */ "./gdbgui/src/js/Breakpoints.tsx");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants */ "./gdbgui/src/js/constants.ts");
/* harmony import */ var _Threads__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Threads */ "./gdbgui/src/js/Threads.tsx");
/* harmony import */ var _FileOps__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./FileOps */ "./gdbgui/src/js/FileOps.tsx");
/* harmony import */ var _Memory__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Memory */ "./gdbgui/src/js/Memory.tsx");
/* harmony import */ var _GdbApi__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./GdbApi */ "./gdbgui/src/js/GdbApi.tsx");
/* harmony import */ var _Locals__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Locals */ "./gdbgui/src/js/Locals.tsx");
/* harmony import */ var _GdbVariable__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./GdbVariable */ "./gdbgui/src/js/GdbVariable.tsx");
/* harmony import */ var _GdbguiModal__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./GdbguiModal */ "./gdbgui/src/js/GdbguiModal.tsx");
/* harmony import */ var _Actions__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./Actions */ "./gdbgui/src/js/Actions.ts");
/* harmony import */ var _processFeatures__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./processFeatures */ "./gdbgui/src/js/processFeatures.ts");
/**
 * This is the main callback when receiving a response from gdb.
 * This callback generally updates the store, which causes components
 * to update.
 */
var __values = (undefined && undefined.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};














var process_gdb_response = function (response_array) {
    var e_1, _a;
    /**
     * Determines if response is an error and client does not want to be notified of errors for this particular response.
     * @param response: gdb mi response object
     * @return (bool): true if response should be ignored
     */
    var isError = function (response) {
        return response.message === "error";
    };
    var ignoreError = function (response) {
        return (
        // @ts-expect-error ts-migrate(2551) FIXME: Property 'IGNOREERRORS_TOKEN_INT' does not exist o... Remove this comment to see the full error message
        response.token === _constants__WEBPACK_IMPORTED_MODULE_4__["default"].IGNOREERRORS_TOKEN_INT ||
            // @ts-expect-error ts-migrate(2551) FIXME: Property 'CREATE_VAR_INT' does not exist on type '... Remove this comment to see the full error message
            response.token === _constants__WEBPACK_IMPORTED_MODULE_4__["default"].CREATE_VAR_INT);
    };
    var isCreatingVar = function (response) {
        // @ts-expect-error ts-migrate(2551) FIXME: Property 'CREATE_VAR_INT' does not exist on type '... Remove this comment to see the full error message
        return response.token === _constants__WEBPACK_IMPORTED_MODULE_4__["default"].CREATE_VAR_INT;
    };
    var _loop_1 = function (r) {
        // gdb mi output
        _GdbMiOutput__WEBPACK_IMPORTED_MODULE_2__["default"].add_mi_output(r);
        if (isError(r)) {
            if (isCreatingVar(r)) {
                _GdbVariable__WEBPACK_IMPORTED_MODULE_10__["default"].gdb_variable_fetch_failed(r);
                return "continue";
            }
            else if (ignoreError(r)) {
                return "continue";
                // @ts-expect-error ts-migrate(2551) FIXME: Property 'DISASSEMBLY_FOR_MISSING_FILE_INT' does n... Remove this comment to see the full error message
            }
            else if (r.token === _constants__WEBPACK_IMPORTED_MODULE_4__["default"].DISASSEMBLY_FOR_MISSING_FILE_INT) {
                _FileOps__WEBPACK_IMPORTED_MODULE_6__["default"].fetch_disassembly_for_missing_file_failed();
            }
            else if (
            // @ts-expect-error ts-migrate(2551) FIXME: Property 'INLINE_DISASSEMBLY_INT' does not exist o... Remove this comment to see the full error message
            r.token === _constants__WEBPACK_IMPORTED_MODULE_4__["default"].INLINE_DISASSEMBLY_INT &&
                r.payload &&
                r.payload.msg.indexOf("Mode argument must be 0, 1, 2, or 3.") !== -1) {
                // we tried to fetch disassembly for a newer version of gdb, but it didn't work
                // try again with mode 3, for older gdb api's
                statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("gdb_version", ["7", "6", "0"]);
                // @ts-expect-error ts-migrate(2345) FIXME: Argument of type '3' is not assignable to paramete... Remove this comment to see the full error message
                _FileOps__WEBPACK_IMPORTED_MODULE_6__["default"].fetch_assembly_cur_line(3);
            }
            else if (r.payload &&
                r.payload.msg &&
                r.payload.msg.startsWith("Unable to find Mach task port")) {
                _Actions__WEBPACK_IMPORTED_MODULE_12__["default"].add_gdb_response_to_console(r);
                _Actions__WEBPACK_IMPORTED_MODULE_12__["default"].add_console_entries(react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", null, "Follow "),
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", { href: "https://github.com/cs01/gdbgui/issues/55#issuecomment-288209648" }, "these instructions"),
                    react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", null, " to fix this error")), _constants__WEBPACK_IMPORTED_MODULE_4__["default"].console_entry_type.GDBGUI_OUTPUT_RAW);
                return "continue";
            }
        }
        if (r.type === "result" && r.message === "done" && r.payload) {
            // This is special GDB Machine Interface structured data that we
            // can render in the frontend
            if ("bkpt" in r.payload) {
                var new_bkpt_1 = r.payload.bkpt;
                // remove duplicate breakpoints
                var cmds = statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"]
                    .get("breakpoints")
                    .filter(function (b) {
                    return new_bkpt_1.fullname === b.fullname &&
                        new_bkpt_1.func === b.func &&
                        new_bkpt_1.line === b.line;
                })
                    .map(function (b) { return _GdbApi__WEBPACK_IMPORTED_MODULE_8__["default"].get_delete_break_cmd(b.number); });
                _GdbApi__WEBPACK_IMPORTED_MODULE_8__["default"].run_gdb_command(cmds);
                // save this breakpoint
                var bkpt = _Breakpoints__WEBPACK_IMPORTED_MODULE_3__["default"].save_breakpoint(r.payload.bkpt);
                // if executable does not have debug symbols (i.e. not compiled with -g flag)
                // gdb will not return a path, but rather the function name. The function name is
                // not a file, and therefore it cannot be displayed. Make sure the path is known before
                // trying to render the file of the newly created breakpoint.
                // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
                if (_.isString(bkpt.fullname_to_display)) {
                    // a normal breakpoint or child breakpoint
                    _Actions__WEBPACK_IMPORTED_MODULE_12__["default"].view_file(bkpt.fullname_to_display, parseInt(bkpt.line));
                }
                // refresh all breakpoints
                _GdbApi__WEBPACK_IMPORTED_MODULE_8__["default"].refresh_breakpoints();
            }
            if ("BreakpointTable" in r.payload) {
                _Breakpoints__WEBPACK_IMPORTED_MODULE_3__["default"].save_breakpoints(r.payload);
            }
            if ("stack" in r.payload) {
                _Threads__WEBPACK_IMPORTED_MODULE_5__["default"].update_stack(r.payload.stack);
            }
            if ("threads" in r.payload) {
                statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("threads", r.payload.threads);
                statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("current_thread_id", parseInt(r.payload["current-thread-id"]));
            }
            if ("register-names" in r.payload) {
                var names = r.payload["register-names"];
                // filter out empty names
                statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("register_names", names.filter(function (name) { return name !== ""; }));
            }
            if ("register-values" in r.payload) {
                statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("previous_register_values", statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("current_register_values"));
                statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("current_register_values", r.payload["register-values"]);
            }
            if ("asm_insns" in r.payload) {
                _FileOps__WEBPACK_IMPORTED_MODULE_6__["default"].save_new_assembly(r.payload.asm_insns, r.token);
            }
            if ("files" in r.payload) {
                if (r.payload.files.length > 0) {
                    // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name '_'.
                    var source_file_paths = _.uniq(r.payload.files.map(function (f) { return f.fullname; })).sort();
                    statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("source_file_paths", source_file_paths);
                    var language = "c_family";
                    if (source_file_paths.some(function (p) { return p.endsWith(".rs"); })) {
                        language = "rust";
                        var gdb_version_array = statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("gdb_version_array");
                        // rust cannot view registers with gdb 7.12.x
                        if (gdb_version_array[0] == 7 && gdb_version_array[1] == 12) {
                            _Actions__WEBPACK_IMPORTED_MODULE_12__["default"].add_console_entries("Warning: Due to a bug in gdb version " + statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("gdb_version") + ", gdbgui cannot show register values with rust executables. See https://github.com/cs01/gdbgui/issues/64 for details.", _constants__WEBPACK_IMPORTED_MODULE_4__["default"].console_entry_type.STD_ERR);
                            statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("can_fetch_register_values", false);
                        }
                    }
                    else if (source_file_paths.some(function (p) { return p.endsWith(".go"); })) {
                        language = "go";
                    }
                    statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("language", language);
                }
                else {
                    statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("source_file_paths", [
                        "Either no executable is loaded or the executable was compiled without debug symbols."
                    ]);
                    if (statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("inferior_binary_path")) {
                        // @ts-expect-error ts-migrate(2339) FIXME: Property 'render' does not exist on type 'typeof M... Remove this comment to see the full error message
                        _GdbguiModal__WEBPACK_IMPORTED_MODULE_11__["default"].render("Warning", react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", null,
                            "This binary was not compiled with debug symbols. Recompile with the -g flag for a better debugging experience.",
                            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null),
                            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null),
                            "Read more:",
                            " ",
                            react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", { href: "http://www.delorie.com/gnu/docs/gdb/gdb_17.html" }, "http://www.delorie.com/gnu/docs/gdb/gdb_17.html")));
                    }
                }
            }
            if ("memory" in r.payload) {
                _Memory__WEBPACK_IMPORTED_MODULE_7__["default"].add_value_to_cache(r.payload.memory[0].begin, r.payload.memory[0].contents);
            }
            // gdb returns local variables as "variables" which is confusing, because you can also create variables
            // in gdb with '-var-create'. *Those* types of variables are referred to as "expressions" in gdbgui, and
            // are returned by gdbgui as "changelist", or have the keys "has_more", "numchild", "children", or "name".
            if ("variables" in r.payload) {
                _Locals__WEBPACK_IMPORTED_MODULE_9__["default"].save_locals(r.payload.variables);
            }
            // gdbgui expression (aka a gdb variable was changed)
            if ("changelist" in r.payload) {
                _GdbVariable__WEBPACK_IMPORTED_MODULE_10__["default"].handle_changelist(r.payload.changelist);
            }
            // gdbgui expression was evaluated for the first time for a child variable
            if ("has_more" in r.payload && "numchild" in r.payload && "children" in r.payload) {
                _GdbVariable__WEBPACK_IMPORTED_MODULE_10__["default"].gdb_created_children_variables(r);
            }
            // gdbgui expression was evaluated for the first time for a root variable
            if ("name" in r.payload) {
                _GdbVariable__WEBPACK_IMPORTED_MODULE_10__["default"].gdb_created_root_variable(r);
            }
            // features list
            if ("features" in r.payload) {
                Object(_processFeatures__WEBPACK_IMPORTED_MODULE_13__["processFeatures"])(r.payload.features);
            }
            // features list
            if ("target_features" in r.payload) {
                // @ts-expect-error ts-migrate(2304) FIXME: Cannot find name 'processTargetFeatures'.
                processTargetFeatures(r.payload.target_features);
            }
        }
        else if (r.type === "result" && r.message === "error") {
            // render it in the status bar, and don't render the last response in the array as it does by default
            _Actions__WEBPACK_IMPORTED_MODULE_12__["default"].add_gdb_response_to_console(r);
            // we tried to load a binary, but gdb couldn't find it
            if (r.payload.msg ===
                statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("inferior_binary_path") + ": No such file or directory.") {
                _Actions__WEBPACK_IMPORTED_MODULE_12__["default"].inferior_program_exited();
            }
        }
        else if (r.type === "console") {
            _Actions__WEBPACK_IMPORTED_MODULE_12__["default"].add_console_entries(r.payload, r.stream === "stderr"
                ? _constants__WEBPACK_IMPORTED_MODULE_4__["default"].console_entry_type.STD_ERR
                : _constants__WEBPACK_IMPORTED_MODULE_4__["default"].console_entry_type.STD_OUT);
            if (statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].get("gdb_version") === undefined) {
                // parse gdb version from string such as
                // GNU gdb (Ubuntu 7.7.1-0ubuntu5~14.04.2) 7.7.1
                var m = /GNU gdb \(.*\)\s+([0-9|.]*)\\n/g;
                var a = m.exec(r.payload);
                if (Array.isArray(a) && a.length === 2) {
                    statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("gdb_version", a[1]);
                    statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("gdb_version_array", a[1].split("."));
                }
            }
        }
        else if (r.type === "output" || r.type === "target" || r.type === "log") {
            // output of program
            _Actions__WEBPACK_IMPORTED_MODULE_12__["default"].add_console_entries(r.payload, r.stream === "stderr"
                ? _constants__WEBPACK_IMPORTED_MODULE_4__["default"].console_entry_type.STD_ERR
                : _constants__WEBPACK_IMPORTED_MODULE_4__["default"].console_entry_type.STD_OUT);
        }
        else if (r.type === "notify") {
            if (r.message === "thread-group-started") {
                statorgfc__WEBPACK_IMPORTED_MODULE_1__["store"].set("inferior_pid", parseInt(r.payload.pid));
            }
        }
        if (r.message && r.message === "stopped") {
            if (r.payload && r.payload.reason) {
                if (r.payload.reason.includes("exited")) {
                    _Actions__WEBPACK_IMPORTED_MODULE_12__["default"].inferior_program_exited();
                }
                else if (r.payload.reason.includes("breakpoint-hit") ||
                    r.payload.reason.includes("end-stepping-range")) {
                    if (r.payload["new-thread-id"]) {
                        // @ts-expect-error ts-migrate(2339) FIXME: Property 'set_thread_id' does not exist on type 't... Remove this comment to see the full error message
                        _Threads__WEBPACK_IMPORTED_MODULE_5__["default"].set_thread_id(r.payload["new-thread-id"]);
                    }
                    _Actions__WEBPACK_IMPORTED_MODULE_12__["default"].inferior_program_paused(r.payload.frame);
                }
                else if (r.payload.reason === "signal-received") {
                    _Actions__WEBPACK_IMPORTED_MODULE_12__["default"].inferior_program_paused(r.payload.frame);
                    if (r.payload["signal-name"] !== "SIGINT") {
                        _Actions__WEBPACK_IMPORTED_MODULE_12__["default"].add_console_entries("Signal received: (" + r.payload["signal-meaning"] + ", " + r.payload["signal-name"] + ").", _constants__WEBPACK_IMPORTED_MODULE_4__["default"].console_entry_type.GDBGUI_OUTPUT);
                        _Actions__WEBPACK_IMPORTED_MODULE_12__["default"].add_console_entries("If the program exited due to a fault, you can attempt to re-enter " +
                            "the state of the program when the fault occurred by running the " +
                            "command 'backtrace' in the gdb terminal.", _constants__WEBPACK_IMPORTED_MODULE_4__["default"].console_entry_type.GDBGUI_OUTPUT);
                    }
                }
                else {
                    console.warn("TODO handle new reason for stopping. Notify developer of this.");
                    console.warn(r);
                }
            }
            else {
                _Actions__WEBPACK_IMPORTED_MODULE_12__["default"].inferior_program_paused(r.payload.frame);
            }
        }
        else if (r.message && r.message === "connected") {
            _Actions__WEBPACK_IMPORTED_MODULE_12__["default"].remote_connected();
        }
    };
    try {
        for (var response_array_1 = __values(response_array), response_array_1_1 = response_array_1.next(); !response_array_1_1.done; response_array_1_1 = response_array_1.next()) {
            var r = response_array_1_1.value;
            _loop_1(r);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (response_array_1_1 && !response_array_1_1.done && (_a = response_array_1.return)) _a.call(response_array_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
};
/* harmony default export */ __webpack_exports__["default"] = (process_gdb_response);


/***/ }),

/***/ "./gdbgui/src/js/register_descriptions.ts":
/*!************************************************!*\
  !*** ./gdbgui/src/js/register_descriptions.ts ***!
  \************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ({
    // x86_64
    rax: "register a extended (64-bit)",
    rbx: "register b extended (64-bit)",
    rcx: "register c extended (64-bit)",
    rdx: "register d extended (64-bit)",
    rbp: "base pointer (start of stack) (64-bit)",
    rsp: "stack pointer (current location in stack, growing downwards) (64-bit)",
    rsi: "source index (source for data copies) (64-bit)",
    rdi: "destination index (destination for data copies) (64-bit)",
    r8: "register 8 (64-bit)",
    r9: "register 9 (64-bit)",
    r10: "register 10 (64-bit)",
    r11: "register 11 (64-bit)",
    r12: "register 12 (64-bit)",
    r13: "register 13 (64-bit)",
    r14: "register 14 (64-bit)",
    r15: "register 15 (64-bit)",
    rip: "instruction pointer (points to next instruction to execute) (64-bit)",
    eflags: "32-bit register used as a collection of bits representing Boolean values to store the results of operations and the state of the processor",
    cs: "",
    ss: "",
    ds: "",
    es: "",
    fs: "",
    gs: "",
    st0: "",
    st1: "",
    st2: "",
    st3: "",
    st4: "",
    st5: "",
    st6: "",
    st7: "",
    fctrl: "",
    fstat: "",
    ftag: "",
    fiseg: "",
    fioff: "",
    foseg: "",
    fooff: "",
    fop: "",
    xmm0: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
    xmm1: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
    xmm2: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
    xmm3: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
    xmm4: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
    xmm5: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
    xmm6: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
    xmm7: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
    xmm8: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
    xmm9: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
    xmm10: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
    xmm11: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
    xmm12: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
    xmm13: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
    xmm14: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
    xmm15: "128-bit floating point (four 32-bit singles or two 64-bit doubles)",
    mxcsr: "",
    ymm0h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm1h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm2h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm3h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm4h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm5h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm6h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm7h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm8h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm9h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm10h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm11h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm12h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm13h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm14h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm15h: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm0: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm1: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm2: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm3: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm4: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm5: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm6: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm7: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm8: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm9: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm10: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm11: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm12: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm13: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm14: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    ymm15: "256-bit floating point (eight 32-bit singles or four 64-bit doubles)",
    orig_rax: "",
    al: "",
    bl: "",
    cl: "",
    dl: "",
    sil: "",
    dil: "",
    bpl: "",
    spl: "",
    r8l: "",
    r9l: "",
    r10l: "",
    r11l: "",
    r12l: "",
    r13l: "",
    r14l: "",
    r15l: "",
    ah: "",
    bh: "",
    ch: "",
    dh: "",
    ax: "lower 16-bits of eax (accumulator register, used in arithmetic operations)",
    bx: "lower 16-bits of ebx (base register)",
    cx: "lower 16-bits of ecx (counter register, used in shift/rotate instructions and loops)",
    dx: "lower 16-bits of edx (data register, used in arithmetic and I/O)",
    si: "lower 16-bits of esi (source index register)",
    di: "lower 16-bits of edi (destination index register)",
    bp: "lower 16-bits of ebp (base pointer register, points to base of stack)",
    r8w: "",
    r9w: "",
    r10w: "",
    r11w: "",
    r12w: "",
    r13w: "",
    r14w: "",
    r15w: "",
    eax: "general purpose 32-bit register",
    ebx: "general purpose 32-bit register",
    ecx: "general purpose 32-bit register",
    edx: "general purpose 32-bit register",
    esi: "general purpose 32-bit register",
    edi: "general purpose 32-bit register",
    ebp: "32-bit base pointer",
    // ARM
    R0: "Argument1, Return Value (Temporary register)",
    R1: "Argument2, Second 32-bits if double or 64-bit int return value (Temporary register)",
    R2: "Arguments (Temporary register)",
    R3: "Arguments (Temporary register)",
    R4: "R7 is THUMB frame pointer (Permanent register)",
    R5: "R7 is THUMB frame pointer (Permanent register)",
    R6: "R7 is THUMB frame pointer (Permanent register)",
    R7: "R7 is THUMB frame pointer (Permanent register)",
    R8: "R7 is THUMB frame pointer (Permanent register)",
    R9: "R7 is THUMB frame pointer (Permanent register)",
    R10: "R7 is THUMB frame pointer (Permanent register)",
    R11: "ARM frame pointer (Permanent register)",
    R12: "(Temporary register)",
    R13: "Stack pointer (Permanent register)",
    R14: "Link register (Permanent register)",
    R15: "Program counter",
    s0: "VFP single-precision (Temporary register)",
    s1: "VFP single-precision (Temporary register)",
    s2: "VFP single-precision (Temporary register)",
    s3: "VFP single-precision (Temporary register)",
    s4: "VFP single-precision (Temporary register)",
    s5: "VFP single-precision (Temporary register)",
    s6: "VFP single-precision (Temporary register)",
    s7: "VFP single-precision (Temporary register)",
    s8: "VFP single-precision (Temporary register)",
    s9: "VFP single-precision (Temporary register)",
    s10: "VFP single-precision (Temporary register)",
    s11: "VFP single-precision (Temporary register)",
    s12: "VFP single-precision (Temporary register)",
    s13: "VFP single-precision (Temporary register)",
    s14: "VFP single-precision (Temporary register)",
    s15: "VFP single-precision (Temporary register)",
    s16: "VFP single-precision (Permanent register)",
    s17: "VFP single-precision (Permanent register)",
    s18: "VFP single-precision (Permanent register)",
    s19: "VFP single-precision (Permanent register)",
    s20: "VFP single-precision (Permanent register)",
    s21: "VFP single-precision (Permanent register)",
    s22: "VFP single-precision (Permanent register)",
    s23: "VFP single-precision (Permanent register)",
    s24: "VFP single-precision (Permanent register)",
    s25: "VFP single-precision (Permanent register)",
    s26: "VFP single-precision (Permanent register)",
    s27: "VFP single-precision (Permanent register)",
    s28: "VFP single-precision (Permanent register)",
    s29: "VFP single-precision (Permanent register)",
    s30: "VFP single-precision (Permanent register)",
    s31: "VFP single-precision (Permanent register)",
    d0: "VFP double-precision (Temporary register)",
    d1: "VFP double-precision (Temporary register)",
    d2: "VFP double-precision (Temporary register)",
    d3: "VFP double-precision (Temporary register)",
    d4: "VFP double-precision (Temporary register)",
    d5: "VFP double-precision (Temporary register)",
    d6: "VFP double-precision (Temporary register)",
    d7: "VFP double-precision (Temporary register)",
    d8: "VFP double-precision (Permanent register)",
    d9: "VFP double-precision (Permanent register)",
    d10: "VFP double-precision (Permanent register)",
    d11: "VFP double-precision (Permanent register)",
    d12: "VFP double-precision (Permanent register)",
    d13: "VFP double-precision (Permanent register)",
    d14: "VFP double-precision (Permanent register)",
    d15: "VFP double-precision (Permanent register)",
    fpsid: "VFP system ID register",
    fpscr: "VFP status and control register",
    fpexc: "VFP expception register",
    wr0: "WMMX SIMD data register",
    wr1: "WMMX SIMD data register",
    wr2: "WMMX SIMD data register",
    wr3: "WMMX SIMD data register",
    wr4: "WMMX SIMD data register",
    wr5: "WMMX SIMD data register",
    wr6: "WMMX SIMD data register",
    wr7: "WMMX SIMD data register",
    wr8: "WMMX SIMD data register",
    wr9: "WMMX SIMD data register",
    wr10: "WMMX SIMD data register",
    wr11: "WMMX SIMD data register",
    wr12: "WMMX SIMD data register",
    wr13: "WMMX SIMD data register",
    wr14: "WMMX SIMD data register",
    wr15: "WMMX SIMD data register",
    wr16: "WMMX SIMD data register",
    wc0: "WMMX status and control register",
    wc1: "WMMX status and control register",
    wc2: "WMMX status and control register",
    wc3: "WMMX status and control register",
    wc4: "WMMX status and control register",
    wc5: "WMMX status and control register",
    wc6: "WMMX status and control register",
    wc7: "WMMX status and control register",
    wc8: "WMMX status and control register",
    wc9: "WMMX status and control register",
    wc10: "WMMX status and control register",
    wc11: "WMMX status and control register",
    wc12: "WMMX status and control register",
    wc13: "WMMX status and control register",
    wc14: "WMMX status and control register",
    wc15: "WMMX status and control register",
    wc16: "WMMX status and control register",
    wcid: "WMMX coprocessor ID register, synonymous with wc0",
    wcon: "WMMX control register, synonymous with wc1",
    wcssf: "WMMX saturation SIMD flags, synonymous with wc2",
    wcasf: "WMMX saturation SIMD flags, synonymous with wc3",
    wcgr0: "WMMX control general-purpose register, synonymous with wc8",
    wcgr1: "WMMX control general-purpose register, synonymous with wc9",
    wcgr2: "WMMX control general-purpose register, synonymous with wc10",
    wcgr3: "WMMX control general-purpose register, synonymous with wc11"
});


/***/ }),

/***/ "./gdbgui/static/css/gdbgui.css":
/*!**************************************!*\
  !*** ./gdbgui/static/css/gdbgui.css ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var api = __webpack_require__(/*! ../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !../../../node_modules/css-loader/dist/cjs.js!../../../node_modules/postcss-loader/src!./gdbgui.css */ "./node_modules/css-loader/dist/cjs.js!./node_modules/postcss-loader/src/index.js!./gdbgui/static/css/gdbgui.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.i, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./gdbgui/static/css/splitjs-gdbgui.css":
/*!**********************************************!*\
  !*** ./gdbgui/static/css/splitjs-gdbgui.css ***!
  \**********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var api = __webpack_require__(/*! ../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !../../../node_modules/css-loader/dist/cjs.js!../../../node_modules/postcss-loader/src!./splitjs-gdbgui.css */ "./node_modules/css-loader/dist/cjs.js!./node_modules/postcss-loader/src/index.js!./gdbgui/static/css/splitjs-gdbgui.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.i, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./node_modules/backo2/index.js":
/*!**************************************!*\
  !*** ./node_modules/backo2/index.js ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports) {


/**
 * Expose `Backoff`.
 */

module.exports = Backoff;

/**
 * Initialize backoff timer with `opts`.
 *
 * - `min` initial timeout in milliseconds [100]
 * - `max` max timeout [10000]
 * - `jitter` [0]
 * - `factor` [2]
 *
 * @param {Object} opts
 * @api public
 */

function Backoff(opts) {
  opts = opts || {};
  this.ms = opts.min || 100;
  this.max = opts.max || 10000;
  this.factor = opts.factor || 2;
  this.jitter = opts.jitter > 0 && opts.jitter <= 1 ? opts.jitter : 0;
  this.attempts = 0;
}

/**
 * Return the backoff duration.
 *
 * @return {Number}
 * @api public
 */

Backoff.prototype.duration = function(){
  var ms = this.ms * Math.pow(this.factor, this.attempts++);
  if (this.jitter) {
    var rand =  Math.random();
    var deviation = Math.floor(rand * this.jitter * ms);
    ms = (Math.floor(rand * 10) & 1) == 0  ? ms - deviation : ms + deviation;
  }
  return Math.min(ms, this.max) | 0;
};

/**
 * Reset the number of attempts.
 *
 * @api public
 */

Backoff.prototype.reset = function(){
  this.attempts = 0;
};

/**
 * Set the minimum duration
 *
 * @api public
 */

Backoff.prototype.setMin = function(min){
  this.ms = min;
};

/**
 * Set the maximum duration
 *
 * @api public
 */

Backoff.prototype.setMax = function(max){
  this.max = max;
};

/**
 * Set the jitter
 *
 * @api public
 */

Backoff.prototype.setJitter = function(jitter){
  this.jitter = jitter;
};



/***/ }),

/***/ "./node_modules/base64-arraybuffer/lib/base64-arraybuffer.js":
/*!*******************************************************************!*\
  !*** ./node_modules/base64-arraybuffer/lib/base64-arraybuffer.js ***!
  \*******************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

/*
 * base64-arraybuffer
 * https://github.com/niklasvh/base64-arraybuffer
 *
 * Copyright (c) 2012 Niklas von Hertzen
 * Licensed under the MIT license.
 */
(function(chars){
  "use strict";

  exports.encode = function(arraybuffer) {
    var bytes = new Uint8Array(arraybuffer),
    i, len = bytes.length, base64 = "";

    for (i = 0; i < len; i+=3) {
      base64 += chars[bytes[i] >> 2];
      base64 += chars[((bytes[i] & 3) << 4) | (bytes[i + 1] >> 4)];
      base64 += chars[((bytes[i + 1] & 15) << 2) | (bytes[i + 2] >> 6)];
      base64 += chars[bytes[i + 2] & 63];
    }

    if ((len % 3) === 2) {
      base64 = base64.substring(0, base64.length - 1) + "=";
    } else if (len % 3 === 1) {
      base64 = base64.substring(0, base64.length - 2) + "==";
    }

    return base64;
  };

  exports.decode =  function(base64) {
    var bufferLength = base64.length * 0.75,
    len = base64.length, i, p = 0,
    encoded1, encoded2, encoded3, encoded4;

    if (base64[base64.length - 1] === "=") {
      bufferLength--;
      if (base64[base64.length - 2] === "=") {
        bufferLength--;
      }
    }

    var arraybuffer = new ArrayBuffer(bufferLength),
    bytes = new Uint8Array(arraybuffer);

    for (i = 0; i < len; i+=4) {
      encoded1 = chars.indexOf(base64[i]);
      encoded2 = chars.indexOf(base64[i+1]);
      encoded3 = chars.indexOf(base64[i+2]);
      encoded4 = chars.indexOf(base64[i+3]);

      bytes[p++] = (encoded1 << 2) | (encoded2 >> 4);
      bytes[p++] = ((encoded2 & 15) << 4) | (encoded3 >> 2);
      bytes[p++] = ((encoded3 & 3) << 6) | (encoded4 & 63);
    }

    return arraybuffer;
  };
})("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");


/***/ }),

/***/ "./node_modules/base64-js/index.js":
/*!*****************************************!*\
  !*** ./node_modules/base64-js/index.js ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.byteLength = byteLength
exports.toByteArray = toByteArray
exports.fromByteArray = fromByteArray

var lookup = []
var revLookup = []
var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array

var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
for (var i = 0, len = code.length; i < len; ++i) {
  lookup[i] = code[i]
  revLookup[code.charCodeAt(i)] = i
}

// Support decoding URL-safe base64 strings, as Node.js does.
// See: https://en.wikipedia.org/wiki/Base64#URL_applications
revLookup['-'.charCodeAt(0)] = 62
revLookup['_'.charCodeAt(0)] = 63

function getLens (b64) {
  var len = b64.length

  if (len % 4 > 0) {
    throw new Error('Invalid string. Length must be a multiple of 4')
  }

  // Trim off extra bytes after placeholder bytes are found
  // See: https://github.com/beatgammit/base64-js/issues/42
  var validLen = b64.indexOf('=')
  if (validLen === -1) validLen = len

  var placeHoldersLen = validLen === len
    ? 0
    : 4 - (validLen % 4)

  return [validLen, placeHoldersLen]
}

// base64 is 4/3 + up to two characters of the original data
function byteLength (b64) {
  var lens = getLens(b64)
  var validLen = lens[0]
  var placeHoldersLen = lens[1]
  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
}

function _byteLength (b64, validLen, placeHoldersLen) {
  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
}

function toByteArray (b64) {
  var tmp
  var lens = getLens(b64)
  var validLen = lens[0]
  var placeHoldersLen = lens[1]

  var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen))

  var curByte = 0

  // if there are placeholders, only get up to the last complete 4 chars
  var len = placeHoldersLen > 0
    ? validLen - 4
    : validLen

  var i
  for (i = 0; i < len; i += 4) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 18) |
      (revLookup[b64.charCodeAt(i + 1)] << 12) |
      (revLookup[b64.charCodeAt(i + 2)] << 6) |
      revLookup[b64.charCodeAt(i + 3)]
    arr[curByte++] = (tmp >> 16) & 0xFF
    arr[curByte++] = (tmp >> 8) & 0xFF
    arr[curByte++] = tmp & 0xFF
  }

  if (placeHoldersLen === 2) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 2) |
      (revLookup[b64.charCodeAt(i + 1)] >> 4)
    arr[curByte++] = tmp & 0xFF
  }

  if (placeHoldersLen === 1) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 10) |
      (revLookup[b64.charCodeAt(i + 1)] << 4) |
      (revLookup[b64.charCodeAt(i + 2)] >> 2)
    arr[curByte++] = (tmp >> 8) & 0xFF
    arr[curByte++] = tmp & 0xFF
  }

  return arr
}

function tripletToBase64 (num) {
  return lookup[num >> 18 & 0x3F] +
    lookup[num >> 12 & 0x3F] +
    lookup[num >> 6 & 0x3F] +
    lookup[num & 0x3F]
}

function encodeChunk (uint8, start, end) {
  var tmp
  var output = []
  for (var i = start; i < end; i += 3) {
    tmp =
      ((uint8[i] << 16) & 0xFF0000) +
      ((uint8[i + 1] << 8) & 0xFF00) +
      (uint8[i + 2] & 0xFF)
    output.push(tripletToBase64(tmp))
  }
  return output.join('')
}

function fromByteArray (uint8) {
  var tmp
  var len = uint8.length
  var extraBytes = len % 3 // if we have 1 byte left, pad 2 bytes
  var parts = []
  var maxChunkLength = 16383 // must be multiple of 3

  // go through the array every three bytes, we'll deal with trailing stuff later
  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
    parts.push(encodeChunk(uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)))
  }

  // pad the end with zeros, but make sure to not forget the extra bytes
  if (extraBytes === 1) {
    tmp = uint8[len - 1]
    parts.push(
      lookup[tmp >> 2] +
      lookup[(tmp << 4) & 0x3F] +
      '=='
    )
  } else if (extraBytes === 2) {
    tmp = (uint8[len - 2] << 8) + uint8[len - 1]
    parts.push(
      lookup[tmp >> 10] +
      lookup[(tmp >> 4) & 0x3F] +
      lookup[(tmp << 2) & 0x3F] +
      '='
    )
  }

  return parts.join('')
}


/***/ }),

/***/ "./node_modules/buffer/index.js":
/*!**************************************!*\
  !*** ./node_modules/buffer/index.js ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global) {/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <http://feross.org>
 * @license  MIT
 */
/* eslint-disable no-proto */



var base64 = __webpack_require__(/*! base64-js */ "./node_modules/base64-js/index.js")
var ieee754 = __webpack_require__(/*! ieee754 */ "./node_modules/ieee754/index.js")
var isArray = __webpack_require__(/*! isarray */ "./node_modules/isarray/index.js")

exports.Buffer = Buffer
exports.SlowBuffer = SlowBuffer
exports.INSPECT_MAX_BYTES = 50

/**
 * If `Buffer.TYPED_ARRAY_SUPPORT`:
 *   === true    Use Uint8Array implementation (fastest)
 *   === false   Use Object implementation (most compatible, even IE6)
 *
 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
 * Opera 11.6+, iOS 4.2+.
 *
 * Due to various browser bugs, sometimes the Object implementation will be used even
 * when the browser supports typed arrays.
 *
 * Note:
 *
 *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,
 *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.
 *
 *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.
 *
 *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of
 *     incorrect length in some situations.

 * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they
 * get the Object implementation, which is slower but behaves correctly.
 */
Buffer.TYPED_ARRAY_SUPPORT = global.TYPED_ARRAY_SUPPORT !== undefined
  ? global.TYPED_ARRAY_SUPPORT
  : typedArraySupport()

/*
 * Export kMaxLength after typed array support is determined.
 */
exports.kMaxLength = kMaxLength()

function typedArraySupport () {
  try {
    var arr = new Uint8Array(1)
    arr.__proto__ = {__proto__: Uint8Array.prototype, foo: function () { return 42 }}
    return arr.foo() === 42 && // typed array instances can be augmented
        typeof arr.subarray === 'function' && // chrome 9-10 lack `subarray`
        arr.subarray(1, 1).byteLength === 0 // ie10 has broken `subarray`
  } catch (e) {
    return false
  }
}

function kMaxLength () {
  return Buffer.TYPED_ARRAY_SUPPORT
    ? 0x7fffffff
    : 0x3fffffff
}

function createBuffer (that, length) {
  if (kMaxLength() < length) {
    throw new RangeError('Invalid typed array length')
  }
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    // Return an augmented `Uint8Array` instance, for best performance
    that = new Uint8Array(length)
    that.__proto__ = Buffer.prototype
  } else {
    // Fallback: Return an object instance of the Buffer class
    if (that === null) {
      that = new Buffer(length)
    }
    that.length = length
  }

  return that
}

/**
 * The Buffer constructor returns instances of `Uint8Array` that have their
 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
 * returns a single octet.
 *
 * The `Uint8Array` prototype remains unmodified.
 */

function Buffer (arg, encodingOrOffset, length) {
  if (!Buffer.TYPED_ARRAY_SUPPORT && !(this instanceof Buffer)) {
    return new Buffer(arg, encodingOrOffset, length)
  }

  // Common case.
  if (typeof arg === 'number') {
    if (typeof encodingOrOffset === 'string') {
      throw new Error(
        'If encoding is specified then the first argument must be a string'
      )
    }
    return allocUnsafe(this, arg)
  }
  return from(this, arg, encodingOrOffset, length)
}

Buffer.poolSize = 8192 // not used by this implementation

// TODO: Legacy, not needed anymore. Remove in next major version.
Buffer._augment = function (arr) {
  arr.__proto__ = Buffer.prototype
  return arr
}

function from (that, value, encodingOrOffset, length) {
  if (typeof value === 'number') {
    throw new TypeError('"value" argument must not be a number')
  }

  if (typeof ArrayBuffer !== 'undefined' && value instanceof ArrayBuffer) {
    return fromArrayBuffer(that, value, encodingOrOffset, length)
  }

  if (typeof value === 'string') {
    return fromString(that, value, encodingOrOffset)
  }

  return fromObject(that, value)
}

/**
 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
 * if value is a number.
 * Buffer.from(str[, encoding])
 * Buffer.from(array)
 * Buffer.from(buffer)
 * Buffer.from(arrayBuffer[, byteOffset[, length]])
 **/
Buffer.from = function (value, encodingOrOffset, length) {
  return from(null, value, encodingOrOffset, length)
}

if (Buffer.TYPED_ARRAY_SUPPORT) {
  Buffer.prototype.__proto__ = Uint8Array.prototype
  Buffer.__proto__ = Uint8Array
  if (typeof Symbol !== 'undefined' && Symbol.species &&
      Buffer[Symbol.species] === Buffer) {
    // Fix subarray() in ES2016. See: https://github.com/feross/buffer/pull/97
    Object.defineProperty(Buffer, Symbol.species, {
      value: null,
      configurable: true
    })
  }
}

function assertSize (size) {
  if (typeof size !== 'number') {
    throw new TypeError('"size" argument must be a number')
  } else if (size < 0) {
    throw new RangeError('"size" argument must not be negative')
  }
}

function alloc (that, size, fill, encoding) {
  assertSize(size)
  if (size <= 0) {
    return createBuffer(that, size)
  }
  if (fill !== undefined) {
    // Only pay attention to encoding if it's a string. This
    // prevents accidentally sending in a number that would
    // be interpretted as a start offset.
    return typeof encoding === 'string'
      ? createBuffer(that, size).fill(fill, encoding)
      : createBuffer(that, size).fill(fill)
  }
  return createBuffer(that, size)
}

/**
 * Creates a new filled Buffer instance.
 * alloc(size[, fill[, encoding]])
 **/
Buffer.alloc = function (size, fill, encoding) {
  return alloc(null, size, fill, encoding)
}

function allocUnsafe (that, size) {
  assertSize(size)
  that = createBuffer(that, size < 0 ? 0 : checked(size) | 0)
  if (!Buffer.TYPED_ARRAY_SUPPORT) {
    for (var i = 0; i < size; ++i) {
      that[i] = 0
    }
  }
  return that
}

/**
 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
 * */
Buffer.allocUnsafe = function (size) {
  return allocUnsafe(null, size)
}
/**
 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
 */
Buffer.allocUnsafeSlow = function (size) {
  return allocUnsafe(null, size)
}

function fromString (that, string, encoding) {
  if (typeof encoding !== 'string' || encoding === '') {
    encoding = 'utf8'
  }

  if (!Buffer.isEncoding(encoding)) {
    throw new TypeError('"encoding" must be a valid string encoding')
  }

  var length = byteLength(string, encoding) | 0
  that = createBuffer(that, length)

  var actual = that.write(string, encoding)

  if (actual !== length) {
    // Writing a hex string, for example, that contains invalid characters will
    // cause everything after the first invalid character to be ignored. (e.g.
    // 'abxxcd' will be treated as 'ab')
    that = that.slice(0, actual)
  }

  return that
}

function fromArrayLike (that, array) {
  var length = array.length < 0 ? 0 : checked(array.length) | 0
  that = createBuffer(that, length)
  for (var i = 0; i < length; i += 1) {
    that[i] = array[i] & 255
  }
  return that
}

function fromArrayBuffer (that, array, byteOffset, length) {
  array.byteLength // this throws if `array` is not a valid ArrayBuffer

  if (byteOffset < 0 || array.byteLength < byteOffset) {
    throw new RangeError('\'offset\' is out of bounds')
  }

  if (array.byteLength < byteOffset + (length || 0)) {
    throw new RangeError('\'length\' is out of bounds')
  }

  if (byteOffset === undefined && length === undefined) {
    array = new Uint8Array(array)
  } else if (length === undefined) {
    array = new Uint8Array(array, byteOffset)
  } else {
    array = new Uint8Array(array, byteOffset, length)
  }

  if (Buffer.TYPED_ARRAY_SUPPORT) {
    // Return an augmented `Uint8Array` instance, for best performance
    that = array
    that.__proto__ = Buffer.prototype
  } else {
    // Fallback: Return an object instance of the Buffer class
    that = fromArrayLike(that, array)
  }
  return that
}

function fromObject (that, obj) {
  if (Buffer.isBuffer(obj)) {
    var len = checked(obj.length) | 0
    that = createBuffer(that, len)

    if (that.length === 0) {
      return that
    }

    obj.copy(that, 0, 0, len)
    return that
  }

  if (obj) {
    if ((typeof ArrayBuffer !== 'undefined' &&
        obj.buffer instanceof ArrayBuffer) || 'length' in obj) {
      if (typeof obj.length !== 'number' || isnan(obj.length)) {
        return createBuffer(that, 0)
      }
      return fromArrayLike(that, obj)
    }

    if (obj.type === 'Buffer' && isArray(obj.data)) {
      return fromArrayLike(that, obj.data)
    }
  }

  throw new TypeError('First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.')
}

function checked (length) {
  // Note: cannot use `length < kMaxLength()` here because that fails when
  // length is NaN (which is otherwise coerced to zero.)
  if (length >= kMaxLength()) {
    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
                         'size: 0x' + kMaxLength().toString(16) + ' bytes')
  }
  return length | 0
}

function SlowBuffer (length) {
  if (+length != length) { // eslint-disable-line eqeqeq
    length = 0
  }
  return Buffer.alloc(+length)
}

Buffer.isBuffer = function isBuffer (b) {
  return !!(b != null && b._isBuffer)
}

Buffer.compare = function compare (a, b) {
  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
    throw new TypeError('Arguments must be Buffers')
  }

  if (a === b) return 0

  var x = a.length
  var y = b.length

  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i]
      y = b[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

Buffer.isEncoding = function isEncoding (encoding) {
  switch (String(encoding).toLowerCase()) {
    case 'hex':
    case 'utf8':
    case 'utf-8':
    case 'ascii':
    case 'latin1':
    case 'binary':
    case 'base64':
    case 'ucs2':
    case 'ucs-2':
    case 'utf16le':
    case 'utf-16le':
      return true
    default:
      return false
  }
}

Buffer.concat = function concat (list, length) {
  if (!isArray(list)) {
    throw new TypeError('"list" argument must be an Array of Buffers')
  }

  if (list.length === 0) {
    return Buffer.alloc(0)
  }

  var i
  if (length === undefined) {
    length = 0
    for (i = 0; i < list.length; ++i) {
      length += list[i].length
    }
  }

  var buffer = Buffer.allocUnsafe(length)
  var pos = 0
  for (i = 0; i < list.length; ++i) {
    var buf = list[i]
    if (!Buffer.isBuffer(buf)) {
      throw new TypeError('"list" argument must be an Array of Buffers')
    }
    buf.copy(buffer, pos)
    pos += buf.length
  }
  return buffer
}

function byteLength (string, encoding) {
  if (Buffer.isBuffer(string)) {
    return string.length
  }
  if (typeof ArrayBuffer !== 'undefined' && typeof ArrayBuffer.isView === 'function' &&
      (ArrayBuffer.isView(string) || string instanceof ArrayBuffer)) {
    return string.byteLength
  }
  if (typeof string !== 'string') {
    string = '' + string
  }

  var len = string.length
  if (len === 0) return 0

  // Use a for loop to avoid recursion
  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'ascii':
      case 'latin1':
      case 'binary':
        return len
      case 'utf8':
      case 'utf-8':
      case undefined:
        return utf8ToBytes(string).length
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return len * 2
      case 'hex':
        return len >>> 1
      case 'base64':
        return base64ToBytes(string).length
      default:
        if (loweredCase) return utf8ToBytes(string).length // assume utf8
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}
Buffer.byteLength = byteLength

function slowToString (encoding, start, end) {
  var loweredCase = false

  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
  // property of a typed array.

  // This behaves neither like String nor Uint8Array in that we set start/end
  // to their upper/lower bounds if the value passed is out of range.
  // undefined is handled specially as per ECMA-262 6th Edition,
  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
  if (start === undefined || start < 0) {
    start = 0
  }
  // Return early if start > this.length. Done here to prevent potential uint32
  // coercion fail below.
  if (start > this.length) {
    return ''
  }

  if (end === undefined || end > this.length) {
    end = this.length
  }

  if (end <= 0) {
    return ''
  }

  // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
  end >>>= 0
  start >>>= 0

  if (end <= start) {
    return ''
  }

  if (!encoding) encoding = 'utf8'

  while (true) {
    switch (encoding) {
      case 'hex':
        return hexSlice(this, start, end)

      case 'utf8':
      case 'utf-8':
        return utf8Slice(this, start, end)

      case 'ascii':
        return asciiSlice(this, start, end)

      case 'latin1':
      case 'binary':
        return latin1Slice(this, start, end)

      case 'base64':
        return base64Slice(this, start, end)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return utf16leSlice(this, start, end)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = (encoding + '').toLowerCase()
        loweredCase = true
    }
  }
}

// The property is used by `Buffer.isBuffer` and `is-buffer` (in Safari 5-7) to detect
// Buffer instances.
Buffer.prototype._isBuffer = true

function swap (b, n, m) {
  var i = b[n]
  b[n] = b[m]
  b[m] = i
}

Buffer.prototype.swap16 = function swap16 () {
  var len = this.length
  if (len % 2 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 16-bits')
  }
  for (var i = 0; i < len; i += 2) {
    swap(this, i, i + 1)
  }
  return this
}

Buffer.prototype.swap32 = function swap32 () {
  var len = this.length
  if (len % 4 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 32-bits')
  }
  for (var i = 0; i < len; i += 4) {
    swap(this, i, i + 3)
    swap(this, i + 1, i + 2)
  }
  return this
}

Buffer.prototype.swap64 = function swap64 () {
  var len = this.length
  if (len % 8 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 64-bits')
  }
  for (var i = 0; i < len; i += 8) {
    swap(this, i, i + 7)
    swap(this, i + 1, i + 6)
    swap(this, i + 2, i + 5)
    swap(this, i + 3, i + 4)
  }
  return this
}

Buffer.prototype.toString = function toString () {
  var length = this.length | 0
  if (length === 0) return ''
  if (arguments.length === 0) return utf8Slice(this, 0, length)
  return slowToString.apply(this, arguments)
}

Buffer.prototype.equals = function equals (b) {
  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')
  if (this === b) return true
  return Buffer.compare(this, b) === 0
}

Buffer.prototype.inspect = function inspect () {
  var str = ''
  var max = exports.INSPECT_MAX_BYTES
  if (this.length > 0) {
    str = this.toString('hex', 0, max).match(/.{2}/g).join(' ')
    if (this.length > max) str += ' ... '
  }
  return '<Buffer ' + str + '>'
}

Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
  if (!Buffer.isBuffer(target)) {
    throw new TypeError('Argument must be a Buffer')
  }

  if (start === undefined) {
    start = 0
  }
  if (end === undefined) {
    end = target ? target.length : 0
  }
  if (thisStart === undefined) {
    thisStart = 0
  }
  if (thisEnd === undefined) {
    thisEnd = this.length
  }

  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
    throw new RangeError('out of range index')
  }

  if (thisStart >= thisEnd && start >= end) {
    return 0
  }
  if (thisStart >= thisEnd) {
    return -1
  }
  if (start >= end) {
    return 1
  }

  start >>>= 0
  end >>>= 0
  thisStart >>>= 0
  thisEnd >>>= 0

  if (this === target) return 0

  var x = thisEnd - thisStart
  var y = end - start
  var len = Math.min(x, y)

  var thisCopy = this.slice(thisStart, thisEnd)
  var targetCopy = target.slice(start, end)

  for (var i = 0; i < len; ++i) {
    if (thisCopy[i] !== targetCopy[i]) {
      x = thisCopy[i]
      y = targetCopy[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
//
// Arguments:
// - buffer - a Buffer to search
// - val - a string, Buffer, or number
// - byteOffset - an index into `buffer`; will be clamped to an int32
// - encoding - an optional encoding, relevant is val is a string
// - dir - true for indexOf, false for lastIndexOf
function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
  // Empty buffer means no match
  if (buffer.length === 0) return -1

  // Normalize byteOffset
  if (typeof byteOffset === 'string') {
    encoding = byteOffset
    byteOffset = 0
  } else if (byteOffset > 0x7fffffff) {
    byteOffset = 0x7fffffff
  } else if (byteOffset < -0x80000000) {
    byteOffset = -0x80000000
  }
  byteOffset = +byteOffset  // Coerce to Number.
  if (isNaN(byteOffset)) {
    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
    byteOffset = dir ? 0 : (buffer.length - 1)
  }

  // Normalize byteOffset: negative offsets start from the end of the buffer
  if (byteOffset < 0) byteOffset = buffer.length + byteOffset
  if (byteOffset >= buffer.length) {
    if (dir) return -1
    else byteOffset = buffer.length - 1
  } else if (byteOffset < 0) {
    if (dir) byteOffset = 0
    else return -1
  }

  // Normalize val
  if (typeof val === 'string') {
    val = Buffer.from(val, encoding)
  }

  // Finally, search either indexOf (if dir is true) or lastIndexOf
  if (Buffer.isBuffer(val)) {
    // Special case: looking for empty string/buffer always fails
    if (val.length === 0) {
      return -1
    }
    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
  } else if (typeof val === 'number') {
    val = val & 0xFF // Search for a byte value [0-255]
    if (Buffer.TYPED_ARRAY_SUPPORT &&
        typeof Uint8Array.prototype.indexOf === 'function') {
      if (dir) {
        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
      } else {
        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
      }
    }
    return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir)
  }

  throw new TypeError('val must be string, number or Buffer')
}

function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
  var indexSize = 1
  var arrLength = arr.length
  var valLength = val.length

  if (encoding !== undefined) {
    encoding = String(encoding).toLowerCase()
    if (encoding === 'ucs2' || encoding === 'ucs-2' ||
        encoding === 'utf16le' || encoding === 'utf-16le') {
      if (arr.length < 2 || val.length < 2) {
        return -1
      }
      indexSize = 2
      arrLength /= 2
      valLength /= 2
      byteOffset /= 2
    }
  }

  function read (buf, i) {
    if (indexSize === 1) {
      return buf[i]
    } else {
      return buf.readUInt16BE(i * indexSize)
    }
  }

  var i
  if (dir) {
    var foundIndex = -1
    for (i = byteOffset; i < arrLength; i++) {
      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
        if (foundIndex === -1) foundIndex = i
        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
      } else {
        if (foundIndex !== -1) i -= i - foundIndex
        foundIndex = -1
      }
    }
  } else {
    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength
    for (i = byteOffset; i >= 0; i--) {
      var found = true
      for (var j = 0; j < valLength; j++) {
        if (read(arr, i + j) !== read(val, j)) {
          found = false
          break
        }
      }
      if (found) return i
    }
  }

  return -1
}

Buffer.prototype.includes = function includes (val, byteOffset, encoding) {
  return this.indexOf(val, byteOffset, encoding) !== -1
}

Buffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
}

Buffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
}

function hexWrite (buf, string, offset, length) {
  offset = Number(offset) || 0
  var remaining = buf.length - offset
  if (!length) {
    length = remaining
  } else {
    length = Number(length)
    if (length > remaining) {
      length = remaining
    }
  }

  // must be an even number of digits
  var strLen = string.length
  if (strLen % 2 !== 0) throw new TypeError('Invalid hex string')

  if (length > strLen / 2) {
    length = strLen / 2
  }
  for (var i = 0; i < length; ++i) {
    var parsed = parseInt(string.substr(i * 2, 2), 16)
    if (isNaN(parsed)) return i
    buf[offset + i] = parsed
  }
  return i
}

function utf8Write (buf, string, offset, length) {
  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
}

function asciiWrite (buf, string, offset, length) {
  return blitBuffer(asciiToBytes(string), buf, offset, length)
}

function latin1Write (buf, string, offset, length) {
  return asciiWrite(buf, string, offset, length)
}

function base64Write (buf, string, offset, length) {
  return blitBuffer(base64ToBytes(string), buf, offset, length)
}

function ucs2Write (buf, string, offset, length) {
  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
}

Buffer.prototype.write = function write (string, offset, length, encoding) {
  // Buffer#write(string)
  if (offset === undefined) {
    encoding = 'utf8'
    length = this.length
    offset = 0
  // Buffer#write(string, encoding)
  } else if (length === undefined && typeof offset === 'string') {
    encoding = offset
    length = this.length
    offset = 0
  // Buffer#write(string, offset[, length][, encoding])
  } else if (isFinite(offset)) {
    offset = offset | 0
    if (isFinite(length)) {
      length = length | 0
      if (encoding === undefined) encoding = 'utf8'
    } else {
      encoding = length
      length = undefined
    }
  // legacy write(string, encoding, offset, length) - remove in v0.13
  } else {
    throw new Error(
      'Buffer.write(string, encoding, offset[, length]) is no longer supported'
    )
  }

  var remaining = this.length - offset
  if (length === undefined || length > remaining) length = remaining

  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
    throw new RangeError('Attempt to write outside buffer bounds')
  }

  if (!encoding) encoding = 'utf8'

  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'hex':
        return hexWrite(this, string, offset, length)

      case 'utf8':
      case 'utf-8':
        return utf8Write(this, string, offset, length)

      case 'ascii':
        return asciiWrite(this, string, offset, length)

      case 'latin1':
      case 'binary':
        return latin1Write(this, string, offset, length)

      case 'base64':
        // Warning: maxLength not taken into account in base64Write
        return base64Write(this, string, offset, length)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return ucs2Write(this, string, offset, length)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}

Buffer.prototype.toJSON = function toJSON () {
  return {
    type: 'Buffer',
    data: Array.prototype.slice.call(this._arr || this, 0)
  }
}

function base64Slice (buf, start, end) {
  if (start === 0 && end === buf.length) {
    return base64.fromByteArray(buf)
  } else {
    return base64.fromByteArray(buf.slice(start, end))
  }
}

function utf8Slice (buf, start, end) {
  end = Math.min(buf.length, end)
  var res = []

  var i = start
  while (i < end) {
    var firstByte = buf[i]
    var codePoint = null
    var bytesPerSequence = (firstByte > 0xEF) ? 4
      : (firstByte > 0xDF) ? 3
      : (firstByte > 0xBF) ? 2
      : 1

    if (i + bytesPerSequence <= end) {
      var secondByte, thirdByte, fourthByte, tempCodePoint

      switch (bytesPerSequence) {
        case 1:
          if (firstByte < 0x80) {
            codePoint = firstByte
          }
          break
        case 2:
          secondByte = buf[i + 1]
          if ((secondByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F)
            if (tempCodePoint > 0x7F) {
              codePoint = tempCodePoint
            }
          }
          break
        case 3:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F)
            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
              codePoint = tempCodePoint
            }
          }
          break
        case 4:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          fourthByte = buf[i + 3]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F)
            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
              codePoint = tempCodePoint
            }
          }
      }
    }

    if (codePoint === null) {
      // we did not generate a valid codePoint so insert a
      // replacement char (U+FFFD) and advance only 1 byte
      codePoint = 0xFFFD
      bytesPerSequence = 1
    } else if (codePoint > 0xFFFF) {
      // encode to utf16 (surrogate pair dance)
      codePoint -= 0x10000
      res.push(codePoint >>> 10 & 0x3FF | 0xD800)
      codePoint = 0xDC00 | codePoint & 0x3FF
    }

    res.push(codePoint)
    i += bytesPerSequence
  }

  return decodeCodePointsArray(res)
}

// Based on http://stackoverflow.com/a/22747272/680742, the browser with
// the lowest limit is Chrome, with 0x10000 args.
// We go 1 magnitude less, for safety
var MAX_ARGUMENTS_LENGTH = 0x1000

function decodeCodePointsArray (codePoints) {
  var len = codePoints.length
  if (len <= MAX_ARGUMENTS_LENGTH) {
    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
  }

  // Decode in chunks to avoid "call stack size exceeded".
  var res = ''
  var i = 0
  while (i < len) {
    res += String.fromCharCode.apply(
      String,
      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
    )
  }
  return res
}

function asciiSlice (buf, start, end) {
  var ret = ''
  end = Math.min(buf.length, end)

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i] & 0x7F)
  }
  return ret
}

function latin1Slice (buf, start, end) {
  var ret = ''
  end = Math.min(buf.length, end)

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i])
  }
  return ret
}

function hexSlice (buf, start, end) {
  var len = buf.length

  if (!start || start < 0) start = 0
  if (!end || end < 0 || end > len) end = len

  var out = ''
  for (var i = start; i < end; ++i) {
    out += toHex(buf[i])
  }
  return out
}

function utf16leSlice (buf, start, end) {
  var bytes = buf.slice(start, end)
  var res = ''
  for (var i = 0; i < bytes.length; i += 2) {
    res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256)
  }
  return res
}

Buffer.prototype.slice = function slice (start, end) {
  var len = this.length
  start = ~~start
  end = end === undefined ? len : ~~end

  if (start < 0) {
    start += len
    if (start < 0) start = 0
  } else if (start > len) {
    start = len
  }

  if (end < 0) {
    end += len
    if (end < 0) end = 0
  } else if (end > len) {
    end = len
  }

  if (end < start) end = start

  var newBuf
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    newBuf = this.subarray(start, end)
    newBuf.__proto__ = Buffer.prototype
  } else {
    var sliceLen = end - start
    newBuf = new Buffer(sliceLen, undefined)
    for (var i = 0; i < sliceLen; ++i) {
      newBuf[i] = this[i + start]
    }
  }

  return newBuf
}

/*
 * Need to make sure that buffer isn't trying to write out of bounds.
 */
function checkOffset (offset, ext, length) {
  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
}

Buffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var val = this[offset]
  var mul = 1
  var i = 0
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul
  }

  return val
}

Buffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) {
    checkOffset(offset, byteLength, this.length)
  }

  var val = this[offset + --byteLength]
  var mul = 1
  while (byteLength > 0 && (mul *= 0x100)) {
    val += this[offset + --byteLength] * mul
  }

  return val
}

Buffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 1, this.length)
  return this[offset]
}

Buffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  return this[offset] | (this[offset + 1] << 8)
}

Buffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  return (this[offset] << 8) | this[offset + 1]
}

Buffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return ((this[offset]) |
      (this[offset + 1] << 8) |
      (this[offset + 2] << 16)) +
      (this[offset + 3] * 0x1000000)
}

Buffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset] * 0x1000000) +
    ((this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    this[offset + 3])
}

Buffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var val = this[offset]
  var mul = 1
  var i = 0
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul
  }
  mul *= 0x80

  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

  return val
}

Buffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var i = byteLength
  var mul = 1
  var val = this[offset + --i]
  while (i > 0 && (mul *= 0x100)) {
    val += this[offset + --i] * mul
  }
  mul *= 0x80

  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

  return val
}

Buffer.prototype.readInt8 = function readInt8 (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 1, this.length)
  if (!(this[offset] & 0x80)) return (this[offset])
  return ((0xff - this[offset] + 1) * -1)
}

Buffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  var val = this[offset] | (this[offset + 1] << 8)
  return (val & 0x8000) ? val | 0xFFFF0000 : val
}

Buffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  var val = this[offset + 1] | (this[offset] << 8)
  return (val & 0x8000) ? val | 0xFFFF0000 : val
}

Buffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset]) |
    (this[offset + 1] << 8) |
    (this[offset + 2] << 16) |
    (this[offset + 3] << 24)
}

Buffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset] << 24) |
    (this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    (this[offset + 3])
}

Buffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)
  return ieee754.read(this, offset, true, 23, 4)
}

Buffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)
  return ieee754.read(this, offset, false, 23, 4)
}

Buffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 8, this.length)
  return ieee754.read(this, offset, true, 52, 8)
}

Buffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 8, this.length)
  return ieee754.read(this, offset, false, 52, 8)
}

function checkInt (buf, value, offset, ext, max, min) {
  if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
}

Buffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1
    checkInt(this, value, offset, byteLength, maxBytes, 0)
  }

  var mul = 1
  var i = 0
  this[offset] = value & 0xFF
  while (++i < byteLength && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1
    checkInt(this, value, offset, byteLength, maxBytes, 0)
  }

  var i = byteLength - 1
  var mul = 1
  this[offset + i] = value & 0xFF
  while (--i >= 0 && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0)
  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
  this[offset] = (value & 0xff)
  return offset + 1
}

function objectWriteUInt16 (buf, value, offset, littleEndian) {
  if (value < 0) value = 0xffff + value + 1
  for (var i = 0, j = Math.min(buf.length - offset, 2); i < j; ++i) {
    buf[offset + i] = (value & (0xff << (8 * (littleEndian ? i : 1 - i)))) >>>
      (littleEndian ? i : 1 - i) * 8
  }
}

Buffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff)
    this[offset + 1] = (value >>> 8)
  } else {
    objectWriteUInt16(this, value, offset, true)
  }
  return offset + 2
}

Buffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 8)
    this[offset + 1] = (value & 0xff)
  } else {
    objectWriteUInt16(this, value, offset, false)
  }
  return offset + 2
}

function objectWriteUInt32 (buf, value, offset, littleEndian) {
  if (value < 0) value = 0xffffffff + value + 1
  for (var i = 0, j = Math.min(buf.length - offset, 4); i < j; ++i) {
    buf[offset + i] = (value >>> (littleEndian ? i : 3 - i) * 8) & 0xff
  }
}

Buffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset + 3] = (value >>> 24)
    this[offset + 2] = (value >>> 16)
    this[offset + 1] = (value >>> 8)
    this[offset] = (value & 0xff)
  } else {
    objectWriteUInt32(this, value, offset, true)
  }
  return offset + 4
}

Buffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 24)
    this[offset + 1] = (value >>> 16)
    this[offset + 2] = (value >>> 8)
    this[offset + 3] = (value & 0xff)
  } else {
    objectWriteUInt32(this, value, offset, false)
  }
  return offset + 4
}

Buffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) {
    var limit = Math.pow(2, 8 * byteLength - 1)

    checkInt(this, value, offset, byteLength, limit - 1, -limit)
  }

  var i = 0
  var mul = 1
  var sub = 0
  this[offset] = value & 0xFF
  while (++i < byteLength && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
      sub = 1
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) {
    var limit = Math.pow(2, 8 * byteLength - 1)

    checkInt(this, value, offset, byteLength, limit - 1, -limit)
  }

  var i = byteLength - 1
  var mul = 1
  var sub = 0
  this[offset + i] = value & 0xFF
  while (--i >= 0 && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
      sub = 1
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80)
  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
  if (value < 0) value = 0xff + value + 1
  this[offset] = (value & 0xff)
  return offset + 1
}

Buffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff)
    this[offset + 1] = (value >>> 8)
  } else {
    objectWriteUInt16(this, value, offset, true)
  }
  return offset + 2
}

Buffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 8)
    this[offset + 1] = (value & 0xff)
  } else {
    objectWriteUInt16(this, value, offset, false)
  }
  return offset + 2
}

Buffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff)
    this[offset + 1] = (value >>> 8)
    this[offset + 2] = (value >>> 16)
    this[offset + 3] = (value >>> 24)
  } else {
    objectWriteUInt32(this, value, offset, true)
  }
  return offset + 4
}

Buffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
  if (value < 0) value = 0xffffffff + value + 1
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 24)
    this[offset + 1] = (value >>> 16)
    this[offset + 2] = (value >>> 8)
    this[offset + 3] = (value & 0xff)
  } else {
    objectWriteUInt32(this, value, offset, false)
  }
  return offset + 4
}

function checkIEEE754 (buf, value, offset, ext, max, min) {
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
  if (offset < 0) throw new RangeError('Index out of range')
}

function writeFloat (buf, value, offset, littleEndian, noAssert) {
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, -3.4028234663852886e+38)
  }
  ieee754.write(buf, value, offset, littleEndian, 23, 4)
  return offset + 4
}

Buffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
  return writeFloat(this, value, offset, true, noAssert)
}

Buffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
  return writeFloat(this, value, offset, false, noAssert)
}

function writeDouble (buf, value, offset, littleEndian, noAssert) {
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 8, 1.7976931348623157E+308, -1.7976931348623157E+308)
  }
  ieee754.write(buf, value, offset, littleEndian, 52, 8)
  return offset + 8
}

Buffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
  return writeDouble(this, value, offset, true, noAssert)
}

Buffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
  return writeDouble(this, value, offset, false, noAssert)
}

// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
Buffer.prototype.copy = function copy (target, targetStart, start, end) {
  if (!start) start = 0
  if (!end && end !== 0) end = this.length
  if (targetStart >= target.length) targetStart = target.length
  if (!targetStart) targetStart = 0
  if (end > 0 && end < start) end = start

  // Copy 0 bytes; we're done
  if (end === start) return 0
  if (target.length === 0 || this.length === 0) return 0

  // Fatal error conditions
  if (targetStart < 0) {
    throw new RangeError('targetStart out of bounds')
  }
  if (start < 0 || start >= this.length) throw new RangeError('sourceStart out of bounds')
  if (end < 0) throw new RangeError('sourceEnd out of bounds')

  // Are we oob?
  if (end > this.length) end = this.length
  if (target.length - targetStart < end - start) {
    end = target.length - targetStart + start
  }

  var len = end - start
  var i

  if (this === target && start < targetStart && targetStart < end) {
    // descending copy from end
    for (i = len - 1; i >= 0; --i) {
      target[i + targetStart] = this[i + start]
    }
  } else if (len < 1000 || !Buffer.TYPED_ARRAY_SUPPORT) {
    // ascending copy from start
    for (i = 0; i < len; ++i) {
      target[i + targetStart] = this[i + start]
    }
  } else {
    Uint8Array.prototype.set.call(
      target,
      this.subarray(start, start + len),
      targetStart
    )
  }

  return len
}

// Usage:
//    buffer.fill(number[, offset[, end]])
//    buffer.fill(buffer[, offset[, end]])
//    buffer.fill(string[, offset[, end]][, encoding])
Buffer.prototype.fill = function fill (val, start, end, encoding) {
  // Handle string cases:
  if (typeof val === 'string') {
    if (typeof start === 'string') {
      encoding = start
      start = 0
      end = this.length
    } else if (typeof end === 'string') {
      encoding = end
      end = this.length
    }
    if (val.length === 1) {
      var code = val.charCodeAt(0)
      if (code < 256) {
        val = code
      }
    }
    if (encoding !== undefined && typeof encoding !== 'string') {
      throw new TypeError('encoding must be a string')
    }
    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
      throw new TypeError('Unknown encoding: ' + encoding)
    }
  } else if (typeof val === 'number') {
    val = val & 255
  }

  // Invalid ranges are not set to a default, so can range check early.
  if (start < 0 || this.length < start || this.length < end) {
    throw new RangeError('Out of range index')
  }

  if (end <= start) {
    return this
  }

  start = start >>> 0
  end = end === undefined ? this.length : end >>> 0

  if (!val) val = 0

  var i
  if (typeof val === 'number') {
    for (i = start; i < end; ++i) {
      this[i] = val
    }
  } else {
    var bytes = Buffer.isBuffer(val)
      ? val
      : utf8ToBytes(new Buffer(val, encoding).toString())
    var len = bytes.length
    for (i = 0; i < end - start; ++i) {
      this[i + start] = bytes[i % len]
    }
  }

  return this
}

// HELPER FUNCTIONS
// ================

var INVALID_BASE64_RE = /[^+\/0-9A-Za-z-_]/g

function base64clean (str) {
  // Node strips out invalid characters like \n and \t from the string, base64-js does not
  str = stringtrim(str).replace(INVALID_BASE64_RE, '')
  // Node converts strings with length < 2 to ''
  if (str.length < 2) return ''
  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
  while (str.length % 4 !== 0) {
    str = str + '='
  }
  return str
}

function stringtrim (str) {
  if (str.trim) return str.trim()
  return str.replace(/^\s+|\s+$/g, '')
}

function toHex (n) {
  if (n < 16) return '0' + n.toString(16)
  return n.toString(16)
}

function utf8ToBytes (string, units) {
  units = units || Infinity
  var codePoint
  var length = string.length
  var leadSurrogate = null
  var bytes = []

  for (var i = 0; i < length; ++i) {
    codePoint = string.charCodeAt(i)

    // is surrogate component
    if (codePoint > 0xD7FF && codePoint < 0xE000) {
      // last char was a lead
      if (!leadSurrogate) {
        // no lead yet
        if (codePoint > 0xDBFF) {
          // unexpected trail
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
          continue
        } else if (i + 1 === length) {
          // unpaired lead
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
          continue
        }

        // valid lead
        leadSurrogate = codePoint

        continue
      }

      // 2 leads in a row
      if (codePoint < 0xDC00) {
        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
        leadSurrogate = codePoint
        continue
      }

      // valid surrogate pair
      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000
    } else if (leadSurrogate) {
      // valid bmp char, but last char was a lead
      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
    }

    leadSurrogate = null

    // encode utf8
    if (codePoint < 0x80) {
      if ((units -= 1) < 0) break
      bytes.push(codePoint)
    } else if (codePoint < 0x800) {
      if ((units -= 2) < 0) break
      bytes.push(
        codePoint >> 0x6 | 0xC0,
        codePoint & 0x3F | 0x80
      )
    } else if (codePoint < 0x10000) {
      if ((units -= 3) < 0) break
      bytes.push(
        codePoint >> 0xC | 0xE0,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      )
    } else if (codePoint < 0x110000) {
      if ((units -= 4) < 0) break
      bytes.push(
        codePoint >> 0x12 | 0xF0,
        codePoint >> 0xC & 0x3F | 0x80,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      )
    } else {
      throw new Error('Invalid code point')
    }
  }

  return bytes
}

function asciiToBytes (str) {
  var byteArray = []
  for (var i = 0; i < str.length; ++i) {
    // Node's code seems to be doing this and not & 0x7F..
    byteArray.push(str.charCodeAt(i) & 0xFF)
  }
  return byteArray
}

function utf16leToBytes (str, units) {
  var c, hi, lo
  var byteArray = []
  for (var i = 0; i < str.length; ++i) {
    if ((units -= 2) < 0) break

    c = str.charCodeAt(i)
    hi = c >> 8
    lo = c % 256
    byteArray.push(lo)
    byteArray.push(hi)
  }

  return byteArray
}

function base64ToBytes (str) {
  return base64.toByteArray(base64clean(str))
}

function blitBuffer (src, dst, offset, length) {
  for (var i = 0; i < length; ++i) {
    if ((i + offset >= dst.length) || (i >= src.length)) break
    dst[i + offset] = src[i]
  }
  return i
}

function isnan (val) {
  return val !== val // eslint-disable-line no-self-compare
}

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../webpack/buildin/global.js */ "./node_modules/webpack/buildin/global.js")))

/***/ }),

/***/ "./node_modules/component-emitter/index.js":
/*!*************************************************!*\
  !*** ./node_modules/component-emitter/index.js ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {


/**
 * Expose `Emitter`.
 */

if (true) {
  module.exports = Emitter;
}

/**
 * Initialize a new `Emitter`.
 *
 * @api public
 */

function Emitter(obj) {
  if (obj) return mixin(obj);
};

/**
 * Mixin the emitter properties.
 *
 * @param {Object} obj
 * @return {Object}
 * @api private
 */

function mixin(obj) {
  for (var key in Emitter.prototype) {
    obj[key] = Emitter.prototype[key];
  }
  return obj;
}

/**
 * Listen on the given `event` with `fn`.
 *
 * @param {String} event
 * @param {Function} fn
 * @return {Emitter}
 * @api public
 */

Emitter.prototype.on =
Emitter.prototype.addEventListener = function(event, fn){
  this._callbacks = this._callbacks || {};
  (this._callbacks['$' + event] = this._callbacks['$' + event] || [])
    .push(fn);
  return this;
};

/**
 * Adds an `event` listener that will be invoked a single
 * time then automatically removed.
 *
 * @param {String} event
 * @param {Function} fn
 * @return {Emitter}
 * @api public
 */

Emitter.prototype.once = function(event, fn){
  function on() {
    this.off(event, on);
    fn.apply(this, arguments);
  }

  on.fn = fn;
  this.on(event, on);
  return this;
};

/**
 * Remove the given callback for `event` or all
 * registered callbacks.
 *
 * @param {String} event
 * @param {Function} fn
 * @return {Emitter}
 * @api public
 */

Emitter.prototype.off =
Emitter.prototype.removeListener =
Emitter.prototype.removeAllListeners =
Emitter.prototype.removeEventListener = function(event, fn){
  this._callbacks = this._callbacks || {};

  // all
  if (0 == arguments.length) {
    this._callbacks = {};
    return this;
  }

  // specific event
  var callbacks = this._callbacks['$' + event];
  if (!callbacks) return this;

  // remove all handlers
  if (1 == arguments.length) {
    delete this._callbacks['$' + event];
    return this;
  }

  // remove specific handler
  var cb;
  for (var i = 0; i < callbacks.length; i++) {
    cb = callbacks[i];
    if (cb === fn || cb.fn === fn) {
      callbacks.splice(i, 1);
      break;
    }
  }

  // Remove event specific arrays for event types that no
  // one is subscribed for to avoid memory leak.
  if (callbacks.length === 0) {
    delete this._callbacks['$' + event];
  }

  return this;
};

/**
 * Emit `event` with the given args.
 *
 * @param {String} event
 * @param {Mixed} ...
 * @return {Emitter}
 */

Emitter.prototype.emit = function(event){
  this._callbacks = this._callbacks || {};

  var args = new Array(arguments.length - 1)
    , callbacks = this._callbacks['$' + event];

  for (var i = 1; i < arguments.length; i++) {
    args[i - 1] = arguments[i];
  }

  if (callbacks) {
    callbacks = callbacks.slice(0);
    for (var i = 0, len = callbacks.length; i < len; ++i) {
      callbacks[i].apply(this, args);
    }
  }

  return this;
};

/**
 * Return array of callbacks for `event`.
 *
 * @param {String} event
 * @return {Array}
 * @api public
 */

Emitter.prototype.listeners = function(event){
  this._callbacks = this._callbacks || {};
  return this._callbacks['$' + event] || [];
};

/**
 * Check if this emitter has `event` handlers.
 *
 * @param {String} event
 * @return {Boolean}
 * @api public
 */

Emitter.prototype.hasListeners = function(event){
  return !! this.listeners(event).length;
};


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/postcss-loader/src/index.js!./gdbgui/static/css/gdbgui.css":
/*!**************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/postcss-loader/src!./gdbgui/static/css/gdbgui.css ***!
  \**************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.i, "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */\n\n/* Document\n   ========================================================================== */\n\n/**\n * 1. Correct the line height in all browsers.\n * 2. Prevent adjustments of font size after orientation changes in iOS.\n */\n\nhtml {\n  line-height: 1.15; /* 1 */\n  -webkit-text-size-adjust: 100%; /* 2 */\n}\n\n/* Sections\n   ========================================================================== */\n\n/**\n * Remove the margin in all browsers.\n */\n\nbody {\n  margin: 0;\n}\n\n/**\n * Render the `main` element consistently in IE.\n */\n\nmain {\n  display: block;\n}\n\n/**\n * Correct the font size and margin on `h1` elements within `section` and\n * `article` contexts in Chrome, Firefox, and Safari.\n */\n\nh1 {\n  font-size: 2em;\n  margin: 0.67em 0;\n}\n\n/* Grouping content\n   ========================================================================== */\n\n/**\n * 1. Add the correct box sizing in Firefox.\n * 2. Show the overflow in Edge and IE.\n */\n\nhr {\n  box-sizing: content-box; /* 1 */\n  height: 0; /* 1 */\n  overflow: visible; /* 2 */\n}\n\n/**\n * 1. Correct the inheritance and scaling of font size in all browsers.\n * 2. Correct the odd `em` font sizing in all browsers.\n */\n\npre {\n  font-family: monospace, monospace; /* 1 */\n  font-size: 1em; /* 2 */\n}\n\n/* Text-level semantics\n   ========================================================================== */\n\n/**\n * Remove the gray background on active links in IE 10.\n */\n\na {\n  background-color: transparent;\n}\n\n/**\n * 1. Remove the bottom border in Chrome 57-\n * 2. Add the correct text decoration in Chrome, Edge, IE, Opera, and Safari.\n */\n\nabbr[title] {\n  border-bottom: none; /* 1 */\n  text-decoration: underline; /* 2 */\n  -webkit-text-decoration: underline dotted;\n          text-decoration: underline dotted; /* 2 */\n}\n\n/**\n * Add the correct font weight in Chrome, Edge, and Safari.\n */\n\nb,\nstrong {\n  font-weight: bolder;\n}\n\n/**\n * 1. Correct the inheritance and scaling of font size in all browsers.\n * 2. Correct the odd `em` font sizing in all browsers.\n */\n\ncode,\nkbd,\nsamp {\n  font-family: monospace, monospace; /* 1 */\n  font-size: 1em; /* 2 */\n}\n\n/**\n * Add the correct font size in all browsers.\n */\n\nsmall {\n  font-size: 80%;\n}\n\n/**\n * Prevent `sub` and `sup` elements from affecting the line height in\n * all browsers.\n */\n\nsub,\nsup {\n  font-size: 75%;\n  line-height: 0;\n  position: relative;\n  vertical-align: baseline;\n}\n\nsub {\n  bottom: -0.25em;\n}\n\nsup {\n  top: -0.5em;\n}\n\n/* Embedded content\n   ========================================================================== */\n\n/**\n * Remove the border on images inside links in IE 10.\n */\n\nimg {\n  border-style: none;\n}\n\n/* Forms\n   ========================================================================== */\n\n/**\n * 1. Change the font styles in all browsers.\n * 2. Remove the margin in Firefox and Safari.\n */\n\nbutton,\ninput,\noptgroup,\nselect,\ntextarea {\n  font-family: inherit; /* 1 */\n  font-size: 100%; /* 1 */\n  line-height: 1.15; /* 1 */\n  margin: 0; /* 2 */\n}\n\n/**\n * Show the overflow in IE.\n * 1. Show the overflow in Edge.\n */\n\nbutton,\ninput { /* 1 */\n  overflow: visible;\n}\n\n/**\n * Remove the inheritance of text transform in Edge, Firefox, and IE.\n * 1. Remove the inheritance of text transform in Firefox.\n */\n\nbutton,\nselect { /* 1 */\n  text-transform: none;\n}\n\n/**\n * Correct the inability to style clickable types in iOS and Safari.\n */\n\nbutton,\n[type=\"button\"],\n[type=\"reset\"],\n[type=\"submit\"] {\n  -webkit-appearance: button;\n}\n\n/**\n * Remove the inner border and padding in Firefox.\n */\n\nbutton::-moz-focus-inner,\n[type=\"button\"]::-moz-focus-inner,\n[type=\"reset\"]::-moz-focus-inner,\n[type=\"submit\"]::-moz-focus-inner {\n  border-style: none;\n  padding: 0;\n}\n\n/**\n * Restore the focus styles unset by the previous rule.\n */\n\nbutton:-moz-focusring,\n[type=\"button\"]:-moz-focusring,\n[type=\"reset\"]:-moz-focusring,\n[type=\"submit\"]:-moz-focusring {\n  outline: 1px dotted ButtonText;\n}\n\n/**\n * Correct the padding in Firefox.\n */\n\nfieldset {\n  padding: 0.35em 0.75em 0.625em;\n}\n\n/**\n * 1. Correct the text wrapping in Edge and IE.\n * 2. Correct the color inheritance from `fieldset` elements in IE.\n * 3. Remove the padding so developers are not caught out when they zero out\n *    `fieldset` elements in all browsers.\n */\n\nlegend {\n  box-sizing: border-box; /* 1 */\n  color: inherit; /* 2 */\n  display: table; /* 1 */\n  max-width: 100%; /* 1 */\n  padding: 0; /* 3 */\n  white-space: normal; /* 1 */\n}\n\n/**\n * Add the correct vertical alignment in Chrome, Firefox, and Opera.\n */\n\nprogress {\n  vertical-align: baseline;\n}\n\n/**\n * Remove the default vertical scrollbar in IE 10+.\n */\n\ntextarea {\n  overflow: auto;\n}\n\n/**\n * 1. Add the correct box sizing in IE 10.\n * 2. Remove the padding in IE 10.\n */\n\n[type=\"checkbox\"],\n[type=\"radio\"] {\n  box-sizing: border-box; /* 1 */\n  padding: 0; /* 2 */\n}\n\n/**\n * Correct the cursor style of increment and decrement buttons in Chrome.\n */\n\n[type=\"number\"]::-webkit-inner-spin-button,\n[type=\"number\"]::-webkit-outer-spin-button {\n  height: auto;\n}\n\n/**\n * 1. Correct the odd appearance in Chrome and Safari.\n * 2. Correct the outline style in Safari.\n */\n\n[type=\"search\"] {\n  -webkit-appearance: textfield; /* 1 */\n  outline-offset: -2px; /* 2 */\n}\n\n/**\n * Remove the inner padding in Chrome and Safari on macOS.\n */\n\n[type=\"search\"]::-webkit-search-decoration {\n  -webkit-appearance: none;\n}\n\n/**\n * 1. Correct the inability to style clickable types in iOS and Safari.\n * 2. Change font properties to `inherit` in Safari.\n */\n\n::-webkit-file-upload-button {\n  -webkit-appearance: button; /* 1 */\n  font: inherit; /* 2 */\n}\n\n/* Interactive\n   ========================================================================== */\n\n/*\n * Add the correct display in Edge, IE 10+, and Firefox.\n */\n\ndetails {\n  display: block;\n}\n\n/*\n * Add the correct display in all browsers.\n */\n\nsummary {\n  display: list-item;\n}\n\n/* Misc\n   ========================================================================== */\n\n/**\n * Add the correct display in IE 10+.\n */\n\ntemplate {\n  display: none;\n}\n\n/**\n * Add the correct display in IE 10.\n */\n\n[hidden] {\n  display: none;\n}\n\n/**\n * Manually forked from SUIT CSS Base: https://github.com/suitcss/base\n * A thin layer on top of normalize.css that provides a starting point more\n * suitable for web applications.\n */\n\n/**\n * Removes the default spacing and border for appropriate elements.\n */\n\nblockquote,\ndl,\ndd,\nh1,\nh2,\nh3,\nh4,\nh5,\nh6,\nhr,\nfigure,\np,\npre {\n  margin: 0;\n}\n\nbutton {\n  background-color: transparent;\n  background-image: none;\n}\n\n/**\n * Work around a Firefox/IE bug where the transparent `button` background\n * results in a loss of the default `button` focus styles.\n */\n\nbutton:focus {\n  outline: 1px dotted;\n  outline: 5px auto -webkit-focus-ring-color;\n}\n\nfieldset {\n  margin: 0;\n  padding: 0;\n}\n\nol,\nul {\n  list-style: none;\n  margin: 0;\n  padding: 0;\n}\n\n/**\n * Tailwind custom reset styles\n */\n\n/**\n * 1. Use the user's configured `sans` font-family (with Tailwind's default\n *    sans-serif font stack as a fallback) as a sane default.\n * 2. Use Tailwind's default \"normal\" line-height so the user isn't forced\n *    to override it to ensure consistency even when using the default theme.\n */\n\nhtml {\n  font-family: system-ui, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, \"Helvetica Neue\", Arial, \"Noto Sans\", sans-serif, \"Apple Color Emoji\", \"Segoe UI Emoji\", \"Segoe UI Symbol\", \"Noto Color Emoji\"; /* 1 */\n  line-height: 1.5; /* 2 */\n}\n\n/**\n * 1. Prevent padding and border from affecting element width.\n *\n *    We used to set this in the html element and inherit from\n *    the parent element for everything else. This caused issues\n *    in shadow-dom-enhanced elements like <details> where the content\n *    is wrapped by a div with box-sizing set to `content-box`.\n *\n *    https://github.com/mozdevs/cssremedy/issues/4\n *\n *\n * 2. Allow adding a border to an element by just adding a border-width.\n *\n *    By default, the way the browser specifies that an element should have no\n *    border is by setting it's border-style to `none` in the user-agent\n *    stylesheet.\n *\n *    In order to easily add borders to elements by just setting the `border-width`\n *    property, we change the default border-style for all elements to `solid`, and\n *    use border-width to hide them instead. This way our `border` utilities only\n *    need to set the `border-width` property instead of the entire `border`\n *    shorthand, making our border utilities much more straightforward to compose.\n *\n *    https://github.com/tailwindcss/tailwindcss/pull/116\n */\n\n*,\n::before,\n::after {\n  box-sizing: border-box; /* 1 */\n  border-width: 0; /* 2 */\n  border-style: solid; /* 2 */\n  border-color: #e2e8f0; /* 2 */\n}\n\n/*\n * Ensure horizontal rules are visible by default\n */\n\nhr {\n  border-top-width: 1px;\n}\n\n/**\n * Undo the `border-style: none` reset that Normalize applies to images so that\n * our `border-{width}` utilities have the expected effect.\n *\n * The Normalize reset is unnecessary for us since we default the border-width\n * to 0 on all elements.\n *\n * https://github.com/tailwindcss/tailwindcss/issues/362\n */\n\nimg {\n  border-style: solid;\n}\n\ntextarea {\n  resize: vertical;\n}\n\ninput::-moz-placeholder, textarea::-moz-placeholder {\n  color: #a0aec0;\n}\n\ninput:-ms-input-placeholder, textarea:-ms-input-placeholder {\n  color: #a0aec0;\n}\n\ninput::placeholder,\ntextarea::placeholder {\n  color: #a0aec0;\n}\n\nbutton,\n[role=\"button\"] {\n  cursor: pointer;\n}\n\ntable {\n  border-collapse: collapse;\n}\n\nh1,\nh2,\nh3,\nh4,\nh5,\nh6 {\n  font-size: inherit;\n  font-weight: inherit;\n}\n\n/**\n * Reset links to optimize for opt-in styling instead of\n * opt-out.\n */\n\na {\n  color: inherit;\n  text-decoration: inherit;\n}\n\n/**\n * Reset form element properties that are easy to forget to\n * style explicitly so you don't inadvertently introduce\n * styles that deviate from your design system. These styles\n * supplement a partial reset that is already applied by\n * normalize.css.\n */\n\nbutton,\ninput,\noptgroup,\nselect,\ntextarea {\n  padding: 0;\n  line-height: inherit;\n  color: inherit;\n}\n\n/**\n * Use the configured 'mono' font family for elements that\n * are expected to be rendered with a monospace font, falling\n * back to the system monospace stack if there is no configured\n * 'mono' font family.\n */\n\npre,\ncode,\nkbd,\nsamp {\n  font-family: Menlo, Monaco, Consolas, \"Liberation Mono\", \"Courier New\", monospace;\n}\n\n/**\n * Make replaced elements `display: block` by default as that's\n * the behavior you want almost all of the time. Inspired by\n * CSS Remedy, with `svg` added as well.\n *\n * https://github.com/mozdevs/cssremedy/issues/14\n */\n\nimg,\nsvg,\nvideo,\ncanvas,\naudio,\niframe,\nembed,\nobject {\n  display: block;\n  vertical-align: middle;\n}\n\n/**\n * Constrain images and videos to the parent width and preserve\n * their instrinsic aspect ratio.\n *\n * https://github.com/mozdevs/cssremedy/issues/14\n */\n\nimg,\nvideo {\n  max-width: 100%;\n  height: auto;\n}\n\n.container {\n  width: 100%;\n}\n\n@media (min-width: 640px) {\n  .container {\n    max-width: 640px;\n  }\n}\n\n@media (min-width: 768px) {\n  .container {\n    max-width: 768px;\n  }\n}\n\n@media (min-width: 1024px) {\n  .container {\n    max-width: 1024px;\n  }\n}\n\n@media (min-width: 1280px) {\n  .container {\n    max-width: 1280px;\n  }\n}\n\n.space-y-0 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(0px * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(0px * var(--space-y-reverse));\n}\n\n.space-x-0 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(0px * var(--space-x-reverse));\n  margin-left: calc(0px * calc(1 - var(--space-x-reverse)));\n}\n\n.space-y-1 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(0.25rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(0.25rem * var(--space-y-reverse));\n}\n\n.space-x-1 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(0.25rem * var(--space-x-reverse));\n  margin-left: calc(0.25rem * calc(1 - var(--space-x-reverse)));\n}\n\n.space-y-2 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(0.5rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(0.5rem * var(--space-y-reverse));\n}\n\n.space-x-2 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(0.5rem * var(--space-x-reverse));\n  margin-left: calc(0.5rem * calc(1 - var(--space-x-reverse)));\n}\n\n.space-y-3 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(0.75rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(0.75rem * var(--space-y-reverse));\n}\n\n.space-x-3 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(0.75rem * var(--space-x-reverse));\n  margin-left: calc(0.75rem * calc(1 - var(--space-x-reverse)));\n}\n\n.space-y-4 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(1rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(1rem * var(--space-y-reverse));\n}\n\n.space-x-4 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(1rem * var(--space-x-reverse));\n  margin-left: calc(1rem * calc(1 - var(--space-x-reverse)));\n}\n\n.space-y-5 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(1.25rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(1.25rem * var(--space-y-reverse));\n}\n\n.space-x-5 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(1.25rem * var(--space-x-reverse));\n  margin-left: calc(1.25rem * calc(1 - var(--space-x-reverse)));\n}\n\n.space-y-6 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(1.5rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(1.5rem * var(--space-y-reverse));\n}\n\n.space-x-6 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(1.5rem * var(--space-x-reverse));\n  margin-left: calc(1.5rem * calc(1 - var(--space-x-reverse)));\n}\n\n.space-y-8 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(2rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(2rem * var(--space-y-reverse));\n}\n\n.space-x-8 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(2rem * var(--space-x-reverse));\n  margin-left: calc(2rem * calc(1 - var(--space-x-reverse)));\n}\n\n.space-y-10 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(2.5rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(2.5rem * var(--space-y-reverse));\n}\n\n.space-x-10 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(2.5rem * var(--space-x-reverse));\n  margin-left: calc(2.5rem * calc(1 - var(--space-x-reverse)));\n}\n\n.space-y-12 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(3rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(3rem * var(--space-y-reverse));\n}\n\n.space-x-12 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(3rem * var(--space-x-reverse));\n  margin-left: calc(3rem * calc(1 - var(--space-x-reverse)));\n}\n\n.space-y-16 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(4rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(4rem * var(--space-y-reverse));\n}\n\n.space-x-16 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(4rem * var(--space-x-reverse));\n  margin-left: calc(4rem * calc(1 - var(--space-x-reverse)));\n}\n\n.space-y-20 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(5rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(5rem * var(--space-y-reverse));\n}\n\n.space-x-20 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(5rem * var(--space-x-reverse));\n  margin-left: calc(5rem * calc(1 - var(--space-x-reverse)));\n}\n\n.space-y-24 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(6rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(6rem * var(--space-y-reverse));\n}\n\n.space-x-24 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(6rem * var(--space-x-reverse));\n  margin-left: calc(6rem * calc(1 - var(--space-x-reverse)));\n}\n\n.space-y-32 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(8rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(8rem * var(--space-y-reverse));\n}\n\n.space-x-32 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(8rem * var(--space-x-reverse));\n  margin-left: calc(8rem * calc(1 - var(--space-x-reverse)));\n}\n\n.space-y-40 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(10rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(10rem * var(--space-y-reverse));\n}\n\n.space-x-40 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(10rem * var(--space-x-reverse));\n  margin-left: calc(10rem * calc(1 - var(--space-x-reverse)));\n}\n\n.space-y-48 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(12rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(12rem * var(--space-y-reverse));\n}\n\n.space-x-48 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(12rem * var(--space-x-reverse));\n  margin-left: calc(12rem * calc(1 - var(--space-x-reverse)));\n}\n\n.space-y-56 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(14rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(14rem * var(--space-y-reverse));\n}\n\n.space-x-56 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(14rem * var(--space-x-reverse));\n  margin-left: calc(14rem * calc(1 - var(--space-x-reverse)));\n}\n\n.space-y-64 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(16rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(16rem * var(--space-y-reverse));\n}\n\n.space-x-64 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(16rem * var(--space-x-reverse));\n  margin-left: calc(16rem * calc(1 - var(--space-x-reverse)));\n}\n\n.space-y-px > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(1px * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(1px * var(--space-y-reverse));\n}\n\n.space-x-px > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(1px * var(--space-x-reverse));\n  margin-left: calc(1px * calc(1 - var(--space-x-reverse)));\n}\n\n.-space-y-1 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(-0.25rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(-0.25rem * var(--space-y-reverse));\n}\n\n.-space-x-1 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(-0.25rem * var(--space-x-reverse));\n  margin-left: calc(-0.25rem * calc(1 - var(--space-x-reverse)));\n}\n\n.-space-y-2 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(-0.5rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(-0.5rem * var(--space-y-reverse));\n}\n\n.-space-x-2 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(-0.5rem * var(--space-x-reverse));\n  margin-left: calc(-0.5rem * calc(1 - var(--space-x-reverse)));\n}\n\n.-space-y-3 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(-0.75rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(-0.75rem * var(--space-y-reverse));\n}\n\n.-space-x-3 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(-0.75rem * var(--space-x-reverse));\n  margin-left: calc(-0.75rem * calc(1 - var(--space-x-reverse)));\n}\n\n.-space-y-4 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(-1rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(-1rem * var(--space-y-reverse));\n}\n\n.-space-x-4 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(-1rem * var(--space-x-reverse));\n  margin-left: calc(-1rem * calc(1 - var(--space-x-reverse)));\n}\n\n.-space-y-5 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(-1.25rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(-1.25rem * var(--space-y-reverse));\n}\n\n.-space-x-5 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(-1.25rem * var(--space-x-reverse));\n  margin-left: calc(-1.25rem * calc(1 - var(--space-x-reverse)));\n}\n\n.-space-y-6 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(-1.5rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(-1.5rem * var(--space-y-reverse));\n}\n\n.-space-x-6 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(-1.5rem * var(--space-x-reverse));\n  margin-left: calc(-1.5rem * calc(1 - var(--space-x-reverse)));\n}\n\n.-space-y-8 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(-2rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(-2rem * var(--space-y-reverse));\n}\n\n.-space-x-8 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(-2rem * var(--space-x-reverse));\n  margin-left: calc(-2rem * calc(1 - var(--space-x-reverse)));\n}\n\n.-space-y-10 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(-2.5rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(-2.5rem * var(--space-y-reverse));\n}\n\n.-space-x-10 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(-2.5rem * var(--space-x-reverse));\n  margin-left: calc(-2.5rem * calc(1 - var(--space-x-reverse)));\n}\n\n.-space-y-12 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(-3rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(-3rem * var(--space-y-reverse));\n}\n\n.-space-x-12 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(-3rem * var(--space-x-reverse));\n  margin-left: calc(-3rem * calc(1 - var(--space-x-reverse)));\n}\n\n.-space-y-16 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(-4rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(-4rem * var(--space-y-reverse));\n}\n\n.-space-x-16 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(-4rem * var(--space-x-reverse));\n  margin-left: calc(-4rem * calc(1 - var(--space-x-reverse)));\n}\n\n.-space-y-20 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(-5rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(-5rem * var(--space-y-reverse));\n}\n\n.-space-x-20 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(-5rem * var(--space-x-reverse));\n  margin-left: calc(-5rem * calc(1 - var(--space-x-reverse)));\n}\n\n.-space-y-24 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(-6rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(-6rem * var(--space-y-reverse));\n}\n\n.-space-x-24 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(-6rem * var(--space-x-reverse));\n  margin-left: calc(-6rem * calc(1 - var(--space-x-reverse)));\n}\n\n.-space-y-32 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(-8rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(-8rem * var(--space-y-reverse));\n}\n\n.-space-x-32 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(-8rem * var(--space-x-reverse));\n  margin-left: calc(-8rem * calc(1 - var(--space-x-reverse)));\n}\n\n.-space-y-40 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(-10rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(-10rem * var(--space-y-reverse));\n}\n\n.-space-x-40 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(-10rem * var(--space-x-reverse));\n  margin-left: calc(-10rem * calc(1 - var(--space-x-reverse)));\n}\n\n.-space-y-48 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(-12rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(-12rem * var(--space-y-reverse));\n}\n\n.-space-x-48 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(-12rem * var(--space-x-reverse));\n  margin-left: calc(-12rem * calc(1 - var(--space-x-reverse)));\n}\n\n.-space-y-56 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(-14rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(-14rem * var(--space-y-reverse));\n}\n\n.-space-x-56 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(-14rem * var(--space-x-reverse));\n  margin-left: calc(-14rem * calc(1 - var(--space-x-reverse)));\n}\n\n.-space-y-64 > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(-16rem * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(-16rem * var(--space-y-reverse));\n}\n\n.-space-x-64 > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(-16rem * var(--space-x-reverse));\n  margin-left: calc(-16rem * calc(1 - var(--space-x-reverse)));\n}\n\n.-space-y-px > :not(template) ~ :not(template) {\n  --space-y-reverse: 0;\n  margin-top: calc(-1px * calc(1 - var(--space-y-reverse)));\n  margin-bottom: calc(-1px * var(--space-y-reverse));\n}\n\n.-space-x-px > :not(template) ~ :not(template) {\n  --space-x-reverse: 0;\n  margin-right: calc(-1px * var(--space-x-reverse));\n  margin-left: calc(-1px * calc(1 - var(--space-x-reverse)));\n}\n\n.space-y-reverse > :not(template) ~ :not(template) {\n  --space-y-reverse: 1;\n}\n\n.space-x-reverse > :not(template) ~ :not(template) {\n  --space-x-reverse: 1;\n}\n\n.divide-y-0 > :not(template) ~ :not(template) {\n  --divide-y-reverse: 0;\n  border-top-width: calc(0px * calc(1 - var(--divide-y-reverse)));\n  border-bottom-width: calc(0px * var(--divide-y-reverse));\n}\n\n.divide-x-0 > :not(template) ~ :not(template) {\n  --divide-x-reverse: 0;\n  border-right-width: calc(0px * var(--divide-x-reverse));\n  border-left-width: calc(0px * calc(1 - var(--divide-x-reverse)));\n}\n\n.divide-y-2 > :not(template) ~ :not(template) {\n  --divide-y-reverse: 0;\n  border-top-width: calc(2px * calc(1 - var(--divide-y-reverse)));\n  border-bottom-width: calc(2px * var(--divide-y-reverse));\n}\n\n.divide-x-2 > :not(template) ~ :not(template) {\n  --divide-x-reverse: 0;\n  border-right-width: calc(2px * var(--divide-x-reverse));\n  border-left-width: calc(2px * calc(1 - var(--divide-x-reverse)));\n}\n\n.divide-y-4 > :not(template) ~ :not(template) {\n  --divide-y-reverse: 0;\n  border-top-width: calc(4px * calc(1 - var(--divide-y-reverse)));\n  border-bottom-width: calc(4px * var(--divide-y-reverse));\n}\n\n.divide-x-4 > :not(template) ~ :not(template) {\n  --divide-x-reverse: 0;\n  border-right-width: calc(4px * var(--divide-x-reverse));\n  border-left-width: calc(4px * calc(1 - var(--divide-x-reverse)));\n}\n\n.divide-y-8 > :not(template) ~ :not(template) {\n  --divide-y-reverse: 0;\n  border-top-width: calc(8px * calc(1 - var(--divide-y-reverse)));\n  border-bottom-width: calc(8px * var(--divide-y-reverse));\n}\n\n.divide-x-8 > :not(template) ~ :not(template) {\n  --divide-x-reverse: 0;\n  border-right-width: calc(8px * var(--divide-x-reverse));\n  border-left-width: calc(8px * calc(1 - var(--divide-x-reverse)));\n}\n\n.divide-y > :not(template) ~ :not(template) {\n  --divide-y-reverse: 0;\n  border-top-width: calc(1px * calc(1 - var(--divide-y-reverse)));\n  border-bottom-width: calc(1px * var(--divide-y-reverse));\n}\n\n.divide-x > :not(template) ~ :not(template) {\n  --divide-x-reverse: 0;\n  border-right-width: calc(1px * var(--divide-x-reverse));\n  border-left-width: calc(1px * calc(1 - var(--divide-x-reverse)));\n}\n\n.divide-y-reverse > :not(template) ~ :not(template) {\n  --divide-y-reverse: 1;\n}\n\n.divide-x-reverse > :not(template) ~ :not(template) {\n  --divide-x-reverse: 1;\n}\n\n.divide-transparent > :not(template) ~ :not(template) {\n  border-color: transparent;\n}\n\n.divide-current > :not(template) ~ :not(template) {\n  border-color: currentColor;\n}\n\n.divide-black > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #000;\n  border-color: rgba(0, 0, 0, var(--divide-opacity));\n}\n\n.divide-white > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #fff;\n  border-color: rgba(255, 255, 255, var(--divide-opacity));\n}\n\n.divide-gray-100 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #f7fafc;\n  border-color: rgba(247, 250, 252, var(--divide-opacity));\n}\n\n.divide-gray-200 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #edf2f7;\n  border-color: rgba(237, 242, 247, var(--divide-opacity));\n}\n\n.divide-gray-300 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #e2e8f0;\n  border-color: rgba(226, 232, 240, var(--divide-opacity));\n}\n\n.divide-gray-400 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #cbd5e0;\n  border-color: rgba(203, 213, 224, var(--divide-opacity));\n}\n\n.divide-gray-500 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #a0aec0;\n  border-color: rgba(160, 174, 192, var(--divide-opacity));\n}\n\n.divide-gray-600 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #718096;\n  border-color: rgba(113, 128, 150, var(--divide-opacity));\n}\n\n.divide-gray-700 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #4a5568;\n  border-color: rgba(74, 85, 104, var(--divide-opacity));\n}\n\n.divide-gray-800 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #2d3748;\n  border-color: rgba(45, 55, 72, var(--divide-opacity));\n}\n\n.divide-gray-900 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #1a202c;\n  border-color: rgba(26, 32, 44, var(--divide-opacity));\n}\n\n.divide-red-100 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #fff5f5;\n  border-color: rgba(255, 245, 245, var(--divide-opacity));\n}\n\n.divide-red-200 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #fed7d7;\n  border-color: rgba(254, 215, 215, var(--divide-opacity));\n}\n\n.divide-red-300 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #feb2b2;\n  border-color: rgba(254, 178, 178, var(--divide-opacity));\n}\n\n.divide-red-400 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #fc8181;\n  border-color: rgba(252, 129, 129, var(--divide-opacity));\n}\n\n.divide-red-500 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #f56565;\n  border-color: rgba(245, 101, 101, var(--divide-opacity));\n}\n\n.divide-red-600 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #e53e3e;\n  border-color: rgba(229, 62, 62, var(--divide-opacity));\n}\n\n.divide-red-700 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #c53030;\n  border-color: rgba(197, 48, 48, var(--divide-opacity));\n}\n\n.divide-red-800 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #9b2c2c;\n  border-color: rgba(155, 44, 44, var(--divide-opacity));\n}\n\n.divide-red-900 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #742a2a;\n  border-color: rgba(116, 42, 42, var(--divide-opacity));\n}\n\n.divide-orange-100 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #fffaf0;\n  border-color: rgba(255, 250, 240, var(--divide-opacity));\n}\n\n.divide-orange-200 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #feebc8;\n  border-color: rgba(254, 235, 200, var(--divide-opacity));\n}\n\n.divide-orange-300 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #fbd38d;\n  border-color: rgba(251, 211, 141, var(--divide-opacity));\n}\n\n.divide-orange-400 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #f6ad55;\n  border-color: rgba(246, 173, 85, var(--divide-opacity));\n}\n\n.divide-orange-500 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #ed8936;\n  border-color: rgba(237, 137, 54, var(--divide-opacity));\n}\n\n.divide-orange-600 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #dd6b20;\n  border-color: rgba(221, 107, 32, var(--divide-opacity));\n}\n\n.divide-orange-700 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #c05621;\n  border-color: rgba(192, 86, 33, var(--divide-opacity));\n}\n\n.divide-orange-800 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #9c4221;\n  border-color: rgba(156, 66, 33, var(--divide-opacity));\n}\n\n.divide-orange-900 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #7b341e;\n  border-color: rgba(123, 52, 30, var(--divide-opacity));\n}\n\n.divide-yellow-100 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #fffff0;\n  border-color: rgba(255, 255, 240, var(--divide-opacity));\n}\n\n.divide-yellow-200 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #fefcbf;\n  border-color: rgba(254, 252, 191, var(--divide-opacity));\n}\n\n.divide-yellow-300 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #faf089;\n  border-color: rgba(250, 240, 137, var(--divide-opacity));\n}\n\n.divide-yellow-400 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #f6e05e;\n  border-color: rgba(246, 224, 94, var(--divide-opacity));\n}\n\n.divide-yellow-500 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #ecc94b;\n  border-color: rgba(236, 201, 75, var(--divide-opacity));\n}\n\n.divide-yellow-600 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #d69e2e;\n  border-color: rgba(214, 158, 46, var(--divide-opacity));\n}\n\n.divide-yellow-700 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #b7791f;\n  border-color: rgba(183, 121, 31, var(--divide-opacity));\n}\n\n.divide-yellow-800 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #975a16;\n  border-color: rgba(151, 90, 22, var(--divide-opacity));\n}\n\n.divide-yellow-900 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #744210;\n  border-color: rgba(116, 66, 16, var(--divide-opacity));\n}\n\n.divide-green-100 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #f0fff4;\n  border-color: rgba(240, 255, 244, var(--divide-opacity));\n}\n\n.divide-green-200 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #c6f6d5;\n  border-color: rgba(198, 246, 213, var(--divide-opacity));\n}\n\n.divide-green-300 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #9ae6b4;\n  border-color: rgba(154, 230, 180, var(--divide-opacity));\n}\n\n.divide-green-400 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #68d391;\n  border-color: rgba(104, 211, 145, var(--divide-opacity));\n}\n\n.divide-green-500 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #48bb78;\n  border-color: rgba(72, 187, 120, var(--divide-opacity));\n}\n\n.divide-green-600 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #38a169;\n  border-color: rgba(56, 161, 105, var(--divide-opacity));\n}\n\n.divide-green-700 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #2f855a;\n  border-color: rgba(47, 133, 90, var(--divide-opacity));\n}\n\n.divide-green-800 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #276749;\n  border-color: rgba(39, 103, 73, var(--divide-opacity));\n}\n\n.divide-green-900 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #22543d;\n  border-color: rgba(34, 84, 61, var(--divide-opacity));\n}\n\n.divide-teal-100 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #e6fffa;\n  border-color: rgba(230, 255, 250, var(--divide-opacity));\n}\n\n.divide-teal-200 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #b2f5ea;\n  border-color: rgba(178, 245, 234, var(--divide-opacity));\n}\n\n.divide-teal-300 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #81e6d9;\n  border-color: rgba(129, 230, 217, var(--divide-opacity));\n}\n\n.divide-teal-400 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #4fd1c5;\n  border-color: rgba(79, 209, 197, var(--divide-opacity));\n}\n\n.divide-teal-500 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #38b2ac;\n  border-color: rgba(56, 178, 172, var(--divide-opacity));\n}\n\n.divide-teal-600 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #319795;\n  border-color: rgba(49, 151, 149, var(--divide-opacity));\n}\n\n.divide-teal-700 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #2c7a7b;\n  border-color: rgba(44, 122, 123, var(--divide-opacity));\n}\n\n.divide-teal-800 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #285e61;\n  border-color: rgba(40, 94, 97, var(--divide-opacity));\n}\n\n.divide-teal-900 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #234e52;\n  border-color: rgba(35, 78, 82, var(--divide-opacity));\n}\n\n.divide-blue-100 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #ebf8ff;\n  border-color: rgba(235, 248, 255, var(--divide-opacity));\n}\n\n.divide-blue-200 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #bee3f8;\n  border-color: rgba(190, 227, 248, var(--divide-opacity));\n}\n\n.divide-blue-300 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #90cdf4;\n  border-color: rgba(144, 205, 244, var(--divide-opacity));\n}\n\n.divide-blue-400 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #63b3ed;\n  border-color: rgba(99, 179, 237, var(--divide-opacity));\n}\n\n.divide-blue-500 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #4299e1;\n  border-color: rgba(66, 153, 225, var(--divide-opacity));\n}\n\n.divide-blue-600 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #3182ce;\n  border-color: rgba(49, 130, 206, var(--divide-opacity));\n}\n\n.divide-blue-700 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #2b6cb0;\n  border-color: rgba(43, 108, 176, var(--divide-opacity));\n}\n\n.divide-blue-800 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #2c5282;\n  border-color: rgba(44, 82, 130, var(--divide-opacity));\n}\n\n.divide-blue-900 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #2a4365;\n  border-color: rgba(42, 67, 101, var(--divide-opacity));\n}\n\n.divide-indigo-100 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #ebf4ff;\n  border-color: rgba(235, 244, 255, var(--divide-opacity));\n}\n\n.divide-indigo-200 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #c3dafe;\n  border-color: rgba(195, 218, 254, var(--divide-opacity));\n}\n\n.divide-indigo-300 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #a3bffa;\n  border-color: rgba(163, 191, 250, var(--divide-opacity));\n}\n\n.divide-indigo-400 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #7f9cf5;\n  border-color: rgba(127, 156, 245, var(--divide-opacity));\n}\n\n.divide-indigo-500 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #667eea;\n  border-color: rgba(102, 126, 234, var(--divide-opacity));\n}\n\n.divide-indigo-600 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #5a67d8;\n  border-color: rgba(90, 103, 216, var(--divide-opacity));\n}\n\n.divide-indigo-700 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #4c51bf;\n  border-color: rgba(76, 81, 191, var(--divide-opacity));\n}\n\n.divide-indigo-800 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #434190;\n  border-color: rgba(67, 65, 144, var(--divide-opacity));\n}\n\n.divide-indigo-900 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #3c366b;\n  border-color: rgba(60, 54, 107, var(--divide-opacity));\n}\n\n.divide-purple-100 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #faf5ff;\n  border-color: rgba(250, 245, 255, var(--divide-opacity));\n}\n\n.divide-purple-200 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #e9d8fd;\n  border-color: rgba(233, 216, 253, var(--divide-opacity));\n}\n\n.divide-purple-300 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #d6bcfa;\n  border-color: rgba(214, 188, 250, var(--divide-opacity));\n}\n\n.divide-purple-400 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #b794f4;\n  border-color: rgba(183, 148, 244, var(--divide-opacity));\n}\n\n.divide-purple-500 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #9f7aea;\n  border-color: rgba(159, 122, 234, var(--divide-opacity));\n}\n\n.divide-purple-600 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #805ad5;\n  border-color: rgba(128, 90, 213, var(--divide-opacity));\n}\n\n.divide-purple-700 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #6b46c1;\n  border-color: rgba(107, 70, 193, var(--divide-opacity));\n}\n\n.divide-purple-800 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #553c9a;\n  border-color: rgba(85, 60, 154, var(--divide-opacity));\n}\n\n.divide-purple-900 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #44337a;\n  border-color: rgba(68, 51, 122, var(--divide-opacity));\n}\n\n.divide-pink-100 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #fff5f7;\n  border-color: rgba(255, 245, 247, var(--divide-opacity));\n}\n\n.divide-pink-200 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #fed7e2;\n  border-color: rgba(254, 215, 226, var(--divide-opacity));\n}\n\n.divide-pink-300 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #fbb6ce;\n  border-color: rgba(251, 182, 206, var(--divide-opacity));\n}\n\n.divide-pink-400 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #f687b3;\n  border-color: rgba(246, 135, 179, var(--divide-opacity));\n}\n\n.divide-pink-500 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #ed64a6;\n  border-color: rgba(237, 100, 166, var(--divide-opacity));\n}\n\n.divide-pink-600 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #d53f8c;\n  border-color: rgba(213, 63, 140, var(--divide-opacity));\n}\n\n.divide-pink-700 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #b83280;\n  border-color: rgba(184, 50, 128, var(--divide-opacity));\n}\n\n.divide-pink-800 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #97266d;\n  border-color: rgba(151, 38, 109, var(--divide-opacity));\n}\n\n.divide-pink-900 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n  border-color: #702459;\n  border-color: rgba(112, 36, 89, var(--divide-opacity));\n}\n\n.divide-solid > :not(template) ~ :not(template) {\n  border-style: solid;\n}\n\n.divide-dashed > :not(template) ~ :not(template) {\n  border-style: dashed;\n}\n\n.divide-dotted > :not(template) ~ :not(template) {\n  border-style: dotted;\n}\n\n.divide-double > :not(template) ~ :not(template) {\n  border-style: double;\n}\n\n.divide-none > :not(template) ~ :not(template) {\n  border-style: none;\n}\n\n.divide-opacity-0 > :not(template) ~ :not(template) {\n  --divide-opacity: 0;\n}\n\n.divide-opacity-25 > :not(template) ~ :not(template) {\n  --divide-opacity: 0.25;\n}\n\n.divide-opacity-50 > :not(template) ~ :not(template) {\n  --divide-opacity: 0.5;\n}\n\n.divide-opacity-75 > :not(template) ~ :not(template) {\n  --divide-opacity: 0.75;\n}\n\n.divide-opacity-100 > :not(template) ~ :not(template) {\n  --divide-opacity: 1;\n}\n\n.sr-only {\n  position: absolute;\n  width: 1px;\n  height: 1px;\n  padding: 0;\n  margin: -1px;\n  overflow: hidden;\n  clip: rect(0, 0, 0, 0);\n  white-space: nowrap;\n  border-width: 0;\n}\n\n.not-sr-only {\n  position: static;\n  width: auto;\n  height: auto;\n  padding: 0;\n  margin: 0;\n  overflow: visible;\n  clip: auto;\n  white-space: normal;\n}\n\n.focus\\:sr-only:focus {\n  position: absolute;\n  width: 1px;\n  height: 1px;\n  padding: 0;\n  margin: -1px;\n  overflow: hidden;\n  clip: rect(0, 0, 0, 0);\n  white-space: nowrap;\n  border-width: 0;\n}\n\n.focus\\:not-sr-only:focus {\n  position: static;\n  width: auto;\n  height: auto;\n  padding: 0;\n  margin: 0;\n  overflow: visible;\n  clip: auto;\n  white-space: normal;\n}\n\n.appearance-none {\n  -webkit-appearance: none;\n     -moz-appearance: none;\n          appearance: none;\n}\n\n.bg-fixed {\n  background-attachment: fixed;\n}\n\n.bg-local {\n  background-attachment: local;\n}\n\n.bg-scroll {\n  background-attachment: scroll;\n}\n\n.bg-clip-border {\n  background-clip: border-box;\n}\n\n.bg-clip-padding {\n  background-clip: padding-box;\n}\n\n.bg-clip-content {\n  background-clip: content-box;\n}\n\n.bg-clip-text {\n  -webkit-background-clip: text;\n          background-clip: text;\n}\n\n.bg-transparent {\n  background-color: transparent;\n}\n\n.bg-current {\n  background-color: currentColor;\n}\n\n.bg-black {\n  --bg-opacity: 1;\n  background-color: #000;\n  background-color: rgba(0, 0, 0, var(--bg-opacity));\n}\n\n.bg-white {\n  --bg-opacity: 1;\n  background-color: #fff;\n  background-color: rgba(255, 255, 255, var(--bg-opacity));\n}\n\n.bg-gray-100 {\n  --bg-opacity: 1;\n  background-color: #f7fafc;\n  background-color: rgba(247, 250, 252, var(--bg-opacity));\n}\n\n.bg-gray-200 {\n  --bg-opacity: 1;\n  background-color: #edf2f7;\n  background-color: rgba(237, 242, 247, var(--bg-opacity));\n}\n\n.bg-gray-300 {\n  --bg-opacity: 1;\n  background-color: #e2e8f0;\n  background-color: rgba(226, 232, 240, var(--bg-opacity));\n}\n\n.bg-gray-400 {\n  --bg-opacity: 1;\n  background-color: #cbd5e0;\n  background-color: rgba(203, 213, 224, var(--bg-opacity));\n}\n\n.bg-gray-500 {\n  --bg-opacity: 1;\n  background-color: #a0aec0;\n  background-color: rgba(160, 174, 192, var(--bg-opacity));\n}\n\n.bg-gray-600 {\n  --bg-opacity: 1;\n  background-color: #718096;\n  background-color: rgba(113, 128, 150, var(--bg-opacity));\n}\n\n.bg-gray-700 {\n  --bg-opacity: 1;\n  background-color: #4a5568;\n  background-color: rgba(74, 85, 104, var(--bg-opacity));\n}\n\n.bg-gray-800 {\n  --bg-opacity: 1;\n  background-color: #2d3748;\n  background-color: rgba(45, 55, 72, var(--bg-opacity));\n}\n\n.bg-gray-900 {\n  --bg-opacity: 1;\n  background-color: #1a202c;\n  background-color: rgba(26, 32, 44, var(--bg-opacity));\n}\n\n.bg-red-100 {\n  --bg-opacity: 1;\n  background-color: #fff5f5;\n  background-color: rgba(255, 245, 245, var(--bg-opacity));\n}\n\n.bg-red-200 {\n  --bg-opacity: 1;\n  background-color: #fed7d7;\n  background-color: rgba(254, 215, 215, var(--bg-opacity));\n}\n\n.bg-red-300 {\n  --bg-opacity: 1;\n  background-color: #feb2b2;\n  background-color: rgba(254, 178, 178, var(--bg-opacity));\n}\n\n.bg-red-400 {\n  --bg-opacity: 1;\n  background-color: #fc8181;\n  background-color: rgba(252, 129, 129, var(--bg-opacity));\n}\n\n.bg-red-500 {\n  --bg-opacity: 1;\n  background-color: #f56565;\n  background-color: rgba(245, 101, 101, var(--bg-opacity));\n}\n\n.bg-red-600 {\n  --bg-opacity: 1;\n  background-color: #e53e3e;\n  background-color: rgba(229, 62, 62, var(--bg-opacity));\n}\n\n.bg-red-700 {\n  --bg-opacity: 1;\n  background-color: #c53030;\n  background-color: rgba(197, 48, 48, var(--bg-opacity));\n}\n\n.bg-red-800 {\n  --bg-opacity: 1;\n  background-color: #9b2c2c;\n  background-color: rgba(155, 44, 44, var(--bg-opacity));\n}\n\n.bg-red-900 {\n  --bg-opacity: 1;\n  background-color: #742a2a;\n  background-color: rgba(116, 42, 42, var(--bg-opacity));\n}\n\n.bg-orange-100 {\n  --bg-opacity: 1;\n  background-color: #fffaf0;\n  background-color: rgba(255, 250, 240, var(--bg-opacity));\n}\n\n.bg-orange-200 {\n  --bg-opacity: 1;\n  background-color: #feebc8;\n  background-color: rgba(254, 235, 200, var(--bg-opacity));\n}\n\n.bg-orange-300 {\n  --bg-opacity: 1;\n  background-color: #fbd38d;\n  background-color: rgba(251, 211, 141, var(--bg-opacity));\n}\n\n.bg-orange-400 {\n  --bg-opacity: 1;\n  background-color: #f6ad55;\n  background-color: rgba(246, 173, 85, var(--bg-opacity));\n}\n\n.bg-orange-500 {\n  --bg-opacity: 1;\n  background-color: #ed8936;\n  background-color: rgba(237, 137, 54, var(--bg-opacity));\n}\n\n.bg-orange-600 {\n  --bg-opacity: 1;\n  background-color: #dd6b20;\n  background-color: rgba(221, 107, 32, var(--bg-opacity));\n}\n\n.bg-orange-700 {\n  --bg-opacity: 1;\n  background-color: #c05621;\n  background-color: rgba(192, 86, 33, var(--bg-opacity));\n}\n\n.bg-orange-800 {\n  --bg-opacity: 1;\n  background-color: #9c4221;\n  background-color: rgba(156, 66, 33, var(--bg-opacity));\n}\n\n.bg-orange-900 {\n  --bg-opacity: 1;\n  background-color: #7b341e;\n  background-color: rgba(123, 52, 30, var(--bg-opacity));\n}\n\n.bg-yellow-100 {\n  --bg-opacity: 1;\n  background-color: #fffff0;\n  background-color: rgba(255, 255, 240, var(--bg-opacity));\n}\n\n.bg-yellow-200 {\n  --bg-opacity: 1;\n  background-color: #fefcbf;\n  background-color: rgba(254, 252, 191, var(--bg-opacity));\n}\n\n.bg-yellow-300 {\n  --bg-opacity: 1;\n  background-color: #faf089;\n  background-color: rgba(250, 240, 137, var(--bg-opacity));\n}\n\n.bg-yellow-400 {\n  --bg-opacity: 1;\n  background-color: #f6e05e;\n  background-color: rgba(246, 224, 94, var(--bg-opacity));\n}\n\n.bg-yellow-500 {\n  --bg-opacity: 1;\n  background-color: #ecc94b;\n  background-color: rgba(236, 201, 75, var(--bg-opacity));\n}\n\n.bg-yellow-600 {\n  --bg-opacity: 1;\n  background-color: #d69e2e;\n  background-color: rgba(214, 158, 46, var(--bg-opacity));\n}\n\n.bg-yellow-700 {\n  --bg-opacity: 1;\n  background-color: #b7791f;\n  background-color: rgba(183, 121, 31, var(--bg-opacity));\n}\n\n.bg-yellow-800 {\n  --bg-opacity: 1;\n  background-color: #975a16;\n  background-color: rgba(151, 90, 22, var(--bg-opacity));\n}\n\n.bg-yellow-900 {\n  --bg-opacity: 1;\n  background-color: #744210;\n  background-color: rgba(116, 66, 16, var(--bg-opacity));\n}\n\n.bg-green-100 {\n  --bg-opacity: 1;\n  background-color: #f0fff4;\n  background-color: rgba(240, 255, 244, var(--bg-opacity));\n}\n\n.bg-green-200 {\n  --bg-opacity: 1;\n  background-color: #c6f6d5;\n  background-color: rgba(198, 246, 213, var(--bg-opacity));\n}\n\n.bg-green-300 {\n  --bg-opacity: 1;\n  background-color: #9ae6b4;\n  background-color: rgba(154, 230, 180, var(--bg-opacity));\n}\n\n.bg-green-400 {\n  --bg-opacity: 1;\n  background-color: #68d391;\n  background-color: rgba(104, 211, 145, var(--bg-opacity));\n}\n\n.bg-green-500 {\n  --bg-opacity: 1;\n  background-color: #48bb78;\n  background-color: rgba(72, 187, 120, var(--bg-opacity));\n}\n\n.bg-green-600 {\n  --bg-opacity: 1;\n  background-color: #38a169;\n  background-color: rgba(56, 161, 105, var(--bg-opacity));\n}\n\n.bg-green-700 {\n  --bg-opacity: 1;\n  background-color: #2f855a;\n  background-color: rgba(47, 133, 90, var(--bg-opacity));\n}\n\n.bg-green-800 {\n  --bg-opacity: 1;\n  background-color: #276749;\n  background-color: rgba(39, 103, 73, var(--bg-opacity));\n}\n\n.bg-green-900 {\n  --bg-opacity: 1;\n  background-color: #22543d;\n  background-color: rgba(34, 84, 61, var(--bg-opacity));\n}\n\n.bg-teal-100 {\n  --bg-opacity: 1;\n  background-color: #e6fffa;\n  background-color: rgba(230, 255, 250, var(--bg-opacity));\n}\n\n.bg-teal-200 {\n  --bg-opacity: 1;\n  background-color: #b2f5ea;\n  background-color: rgba(178, 245, 234, var(--bg-opacity));\n}\n\n.bg-teal-300 {\n  --bg-opacity: 1;\n  background-color: #81e6d9;\n  background-color: rgba(129, 230, 217, var(--bg-opacity));\n}\n\n.bg-teal-400 {\n  --bg-opacity: 1;\n  background-color: #4fd1c5;\n  background-color: rgba(79, 209, 197, var(--bg-opacity));\n}\n\n.bg-teal-500 {\n  --bg-opacity: 1;\n  background-color: #38b2ac;\n  background-color: rgba(56, 178, 172, var(--bg-opacity));\n}\n\n.bg-teal-600 {\n  --bg-opacity: 1;\n  background-color: #319795;\n  background-color: rgba(49, 151, 149, var(--bg-opacity));\n}\n\n.bg-teal-700 {\n  --bg-opacity: 1;\n  background-color: #2c7a7b;\n  background-color: rgba(44, 122, 123, var(--bg-opacity));\n}\n\n.bg-teal-800 {\n  --bg-opacity: 1;\n  background-color: #285e61;\n  background-color: rgba(40, 94, 97, var(--bg-opacity));\n}\n\n.bg-teal-900 {\n  --bg-opacity: 1;\n  background-color: #234e52;\n  background-color: rgba(35, 78, 82, var(--bg-opacity));\n}\n\n.bg-blue-100 {\n  --bg-opacity: 1;\n  background-color: #ebf8ff;\n  background-color: rgba(235, 248, 255, var(--bg-opacity));\n}\n\n.bg-blue-200 {\n  --bg-opacity: 1;\n  background-color: #bee3f8;\n  background-color: rgba(190, 227, 248, var(--bg-opacity));\n}\n\n.bg-blue-300 {\n  --bg-opacity: 1;\n  background-color: #90cdf4;\n  background-color: rgba(144, 205, 244, var(--bg-opacity));\n}\n\n.bg-blue-400 {\n  --bg-opacity: 1;\n  background-color: #63b3ed;\n  background-color: rgba(99, 179, 237, var(--bg-opacity));\n}\n\n.bg-blue-500 {\n  --bg-opacity: 1;\n  background-color: #4299e1;\n  background-color: rgba(66, 153, 225, var(--bg-opacity));\n}\n\n.bg-blue-600 {\n  --bg-opacity: 1;\n  background-color: #3182ce;\n  background-color: rgba(49, 130, 206, var(--bg-opacity));\n}\n\n.bg-blue-700 {\n  --bg-opacity: 1;\n  background-color: #2b6cb0;\n  background-color: rgba(43, 108, 176, var(--bg-opacity));\n}\n\n.bg-blue-800 {\n  --bg-opacity: 1;\n  background-color: #2c5282;\n  background-color: rgba(44, 82, 130, var(--bg-opacity));\n}\n\n.bg-blue-900 {\n  --bg-opacity: 1;\n  background-color: #2a4365;\n  background-color: rgba(42, 67, 101, var(--bg-opacity));\n}\n\n.bg-indigo-100 {\n  --bg-opacity: 1;\n  background-color: #ebf4ff;\n  background-color: rgba(235, 244, 255, var(--bg-opacity));\n}\n\n.bg-indigo-200 {\n  --bg-opacity: 1;\n  background-color: #c3dafe;\n  background-color: rgba(195, 218, 254, var(--bg-opacity));\n}\n\n.bg-indigo-300 {\n  --bg-opacity: 1;\n  background-color: #a3bffa;\n  background-color: rgba(163, 191, 250, var(--bg-opacity));\n}\n\n.bg-indigo-400 {\n  --bg-opacity: 1;\n  background-color: #7f9cf5;\n  background-color: rgba(127, 156, 245, var(--bg-opacity));\n}\n\n.bg-indigo-500 {\n  --bg-opacity: 1;\n  background-color: #667eea;\n  background-color: rgba(102, 126, 234, var(--bg-opacity));\n}\n\n.bg-indigo-600 {\n  --bg-opacity: 1;\n  background-color: #5a67d8;\n  background-color: rgba(90, 103, 216, var(--bg-opacity));\n}\n\n.bg-indigo-700 {\n  --bg-opacity: 1;\n  background-color: #4c51bf;\n  background-color: rgba(76, 81, 191, var(--bg-opacity));\n}\n\n.bg-indigo-800 {\n  --bg-opacity: 1;\n  background-color: #434190;\n  background-color: rgba(67, 65, 144, var(--bg-opacity));\n}\n\n.bg-indigo-900 {\n  --bg-opacity: 1;\n  background-color: #3c366b;\n  background-color: rgba(60, 54, 107, var(--bg-opacity));\n}\n\n.bg-purple-100 {\n  --bg-opacity: 1;\n  background-color: #faf5ff;\n  background-color: rgba(250, 245, 255, var(--bg-opacity));\n}\n\n.bg-purple-200 {\n  --bg-opacity: 1;\n  background-color: #e9d8fd;\n  background-color: rgba(233, 216, 253, var(--bg-opacity));\n}\n\n.bg-purple-300 {\n  --bg-opacity: 1;\n  background-color: #d6bcfa;\n  background-color: rgba(214, 188, 250, var(--bg-opacity));\n}\n\n.bg-purple-400 {\n  --bg-opacity: 1;\n  background-color: #b794f4;\n  background-color: rgba(183, 148, 244, var(--bg-opacity));\n}\n\n.bg-purple-500 {\n  --bg-opacity: 1;\n  background-color: #9f7aea;\n  background-color: rgba(159, 122, 234, var(--bg-opacity));\n}\n\n.bg-purple-600 {\n  --bg-opacity: 1;\n  background-color: #805ad5;\n  background-color: rgba(128, 90, 213, var(--bg-opacity));\n}\n\n.bg-purple-700 {\n  --bg-opacity: 1;\n  background-color: #6b46c1;\n  background-color: rgba(107, 70, 193, var(--bg-opacity));\n}\n\n.bg-purple-800 {\n  --bg-opacity: 1;\n  background-color: #553c9a;\n  background-color: rgba(85, 60, 154, var(--bg-opacity));\n}\n\n.bg-purple-900 {\n  --bg-opacity: 1;\n  background-color: #44337a;\n  background-color: rgba(68, 51, 122, var(--bg-opacity));\n}\n\n.bg-pink-100 {\n  --bg-opacity: 1;\n  background-color: #fff5f7;\n  background-color: rgba(255, 245, 247, var(--bg-opacity));\n}\n\n.bg-pink-200 {\n  --bg-opacity: 1;\n  background-color: #fed7e2;\n  background-color: rgba(254, 215, 226, var(--bg-opacity));\n}\n\n.bg-pink-300 {\n  --bg-opacity: 1;\n  background-color: #fbb6ce;\n  background-color: rgba(251, 182, 206, var(--bg-opacity));\n}\n\n.bg-pink-400 {\n  --bg-opacity: 1;\n  background-color: #f687b3;\n  background-color: rgba(246, 135, 179, var(--bg-opacity));\n}\n\n.bg-pink-500 {\n  --bg-opacity: 1;\n  background-color: #ed64a6;\n  background-color: rgba(237, 100, 166, var(--bg-opacity));\n}\n\n.bg-pink-600 {\n  --bg-opacity: 1;\n  background-color: #d53f8c;\n  background-color: rgba(213, 63, 140, var(--bg-opacity));\n}\n\n.bg-pink-700 {\n  --bg-opacity: 1;\n  background-color: #b83280;\n  background-color: rgba(184, 50, 128, var(--bg-opacity));\n}\n\n.bg-pink-800 {\n  --bg-opacity: 1;\n  background-color: #97266d;\n  background-color: rgba(151, 38, 109, var(--bg-opacity));\n}\n\n.bg-pink-900 {\n  --bg-opacity: 1;\n  background-color: #702459;\n  background-color: rgba(112, 36, 89, var(--bg-opacity));\n}\n\n.hover\\:bg-transparent:hover {\n  background-color: transparent;\n}\n\n.hover\\:bg-current:hover {\n  background-color: currentColor;\n}\n\n.hover\\:bg-black:hover {\n  --bg-opacity: 1;\n  background-color: #000;\n  background-color: rgba(0, 0, 0, var(--bg-opacity));\n}\n\n.hover\\:bg-white:hover {\n  --bg-opacity: 1;\n  background-color: #fff;\n  background-color: rgba(255, 255, 255, var(--bg-opacity));\n}\n\n.hover\\:bg-gray-100:hover {\n  --bg-opacity: 1;\n  background-color: #f7fafc;\n  background-color: rgba(247, 250, 252, var(--bg-opacity));\n}\n\n.hover\\:bg-gray-200:hover {\n  --bg-opacity: 1;\n  background-color: #edf2f7;\n  background-color: rgba(237, 242, 247, var(--bg-opacity));\n}\n\n.hover\\:bg-gray-300:hover {\n  --bg-opacity: 1;\n  background-color: #e2e8f0;\n  background-color: rgba(226, 232, 240, var(--bg-opacity));\n}\n\n.hover\\:bg-gray-400:hover {\n  --bg-opacity: 1;\n  background-color: #cbd5e0;\n  background-color: rgba(203, 213, 224, var(--bg-opacity));\n}\n\n.hover\\:bg-gray-500:hover {\n  --bg-opacity: 1;\n  background-color: #a0aec0;\n  background-color: rgba(160, 174, 192, var(--bg-opacity));\n}\n\n.hover\\:bg-gray-600:hover {\n  --bg-opacity: 1;\n  background-color: #718096;\n  background-color: rgba(113, 128, 150, var(--bg-opacity));\n}\n\n.hover\\:bg-gray-700:hover {\n  --bg-opacity: 1;\n  background-color: #4a5568;\n  background-color: rgba(74, 85, 104, var(--bg-opacity));\n}\n\n.hover\\:bg-gray-800:hover {\n  --bg-opacity: 1;\n  background-color: #2d3748;\n  background-color: rgba(45, 55, 72, var(--bg-opacity));\n}\n\n.hover\\:bg-gray-900:hover {\n  --bg-opacity: 1;\n  background-color: #1a202c;\n  background-color: rgba(26, 32, 44, var(--bg-opacity));\n}\n\n.hover\\:bg-red-100:hover {\n  --bg-opacity: 1;\n  background-color: #fff5f5;\n  background-color: rgba(255, 245, 245, var(--bg-opacity));\n}\n\n.hover\\:bg-red-200:hover {\n  --bg-opacity: 1;\n  background-color: #fed7d7;\n  background-color: rgba(254, 215, 215, var(--bg-opacity));\n}\n\n.hover\\:bg-red-300:hover {\n  --bg-opacity: 1;\n  background-color: #feb2b2;\n  background-color: rgba(254, 178, 178, var(--bg-opacity));\n}\n\n.hover\\:bg-red-400:hover {\n  --bg-opacity: 1;\n  background-color: #fc8181;\n  background-color: rgba(252, 129, 129, var(--bg-opacity));\n}\n\n.hover\\:bg-red-500:hover {\n  --bg-opacity: 1;\n  background-color: #f56565;\n  background-color: rgba(245, 101, 101, var(--bg-opacity));\n}\n\n.hover\\:bg-red-600:hover {\n  --bg-opacity: 1;\n  background-color: #e53e3e;\n  background-color: rgba(229, 62, 62, var(--bg-opacity));\n}\n\n.hover\\:bg-red-700:hover {\n  --bg-opacity: 1;\n  background-color: #c53030;\n  background-color: rgba(197, 48, 48, var(--bg-opacity));\n}\n\n.hover\\:bg-red-800:hover {\n  --bg-opacity: 1;\n  background-color: #9b2c2c;\n  background-color: rgba(155, 44, 44, var(--bg-opacity));\n}\n\n.hover\\:bg-red-900:hover {\n  --bg-opacity: 1;\n  background-color: #742a2a;\n  background-color: rgba(116, 42, 42, var(--bg-opacity));\n}\n\n.hover\\:bg-orange-100:hover {\n  --bg-opacity: 1;\n  background-color: #fffaf0;\n  background-color: rgba(255, 250, 240, var(--bg-opacity));\n}\n\n.hover\\:bg-orange-200:hover {\n  --bg-opacity: 1;\n  background-color: #feebc8;\n  background-color: rgba(254, 235, 200, var(--bg-opacity));\n}\n\n.hover\\:bg-orange-300:hover {\n  --bg-opacity: 1;\n  background-color: #fbd38d;\n  background-color: rgba(251, 211, 141, var(--bg-opacity));\n}\n\n.hover\\:bg-orange-400:hover {\n  --bg-opacity: 1;\n  background-color: #f6ad55;\n  background-color: rgba(246, 173, 85, var(--bg-opacity));\n}\n\n.hover\\:bg-orange-500:hover {\n  --bg-opacity: 1;\n  background-color: #ed8936;\n  background-color: rgba(237, 137, 54, var(--bg-opacity));\n}\n\n.hover\\:bg-orange-600:hover {\n  --bg-opacity: 1;\n  background-color: #dd6b20;\n  background-color: rgba(221, 107, 32, var(--bg-opacity));\n}\n\n.hover\\:bg-orange-700:hover {\n  --bg-opacity: 1;\n  background-color: #c05621;\n  background-color: rgba(192, 86, 33, var(--bg-opacity));\n}\n\n.hover\\:bg-orange-800:hover {\n  --bg-opacity: 1;\n  background-color: #9c4221;\n  background-color: rgba(156, 66, 33, var(--bg-opacity));\n}\n\n.hover\\:bg-orange-900:hover {\n  --bg-opacity: 1;\n  background-color: #7b341e;\n  background-color: rgba(123, 52, 30, var(--bg-opacity));\n}\n\n.hover\\:bg-yellow-100:hover {\n  --bg-opacity: 1;\n  background-color: #fffff0;\n  background-color: rgba(255, 255, 240, var(--bg-opacity));\n}\n\n.hover\\:bg-yellow-200:hover {\n  --bg-opacity: 1;\n  background-color: #fefcbf;\n  background-color: rgba(254, 252, 191, var(--bg-opacity));\n}\n\n.hover\\:bg-yellow-300:hover {\n  --bg-opacity: 1;\n  background-color: #faf089;\n  background-color: rgba(250, 240, 137, var(--bg-opacity));\n}\n\n.hover\\:bg-yellow-400:hover {\n  --bg-opacity: 1;\n  background-color: #f6e05e;\n  background-color: rgba(246, 224, 94, var(--bg-opacity));\n}\n\n.hover\\:bg-yellow-500:hover {\n  --bg-opacity: 1;\n  background-color: #ecc94b;\n  background-color: rgba(236, 201, 75, var(--bg-opacity));\n}\n\n.hover\\:bg-yellow-600:hover {\n  --bg-opacity: 1;\n  background-color: #d69e2e;\n  background-color: rgba(214, 158, 46, var(--bg-opacity));\n}\n\n.hover\\:bg-yellow-700:hover {\n  --bg-opacity: 1;\n  background-color: #b7791f;\n  background-color: rgba(183, 121, 31, var(--bg-opacity));\n}\n\n.hover\\:bg-yellow-800:hover {\n  --bg-opacity: 1;\n  background-color: #975a16;\n  background-color: rgba(151, 90, 22, var(--bg-opacity));\n}\n\n.hover\\:bg-yellow-900:hover {\n  --bg-opacity: 1;\n  background-color: #744210;\n  background-color: rgba(116, 66, 16, var(--bg-opacity));\n}\n\n.hover\\:bg-green-100:hover {\n  --bg-opacity: 1;\n  background-color: #f0fff4;\n  background-color: rgba(240, 255, 244, var(--bg-opacity));\n}\n\n.hover\\:bg-green-200:hover {\n  --bg-opacity: 1;\n  background-color: #c6f6d5;\n  background-color: rgba(198, 246, 213, var(--bg-opacity));\n}\n\n.hover\\:bg-green-300:hover {\n  --bg-opacity: 1;\n  background-color: #9ae6b4;\n  background-color: rgba(154, 230, 180, var(--bg-opacity));\n}\n\n.hover\\:bg-green-400:hover {\n  --bg-opacity: 1;\n  background-color: #68d391;\n  background-color: rgba(104, 211, 145, var(--bg-opacity));\n}\n\n.hover\\:bg-green-500:hover {\n  --bg-opacity: 1;\n  background-color: #48bb78;\n  background-color: rgba(72, 187, 120, var(--bg-opacity));\n}\n\n.hover\\:bg-green-600:hover {\n  --bg-opacity: 1;\n  background-color: #38a169;\n  background-color: rgba(56, 161, 105, var(--bg-opacity));\n}\n\n.hover\\:bg-green-700:hover {\n  --bg-opacity: 1;\n  background-color: #2f855a;\n  background-color: rgba(47, 133, 90, var(--bg-opacity));\n}\n\n.hover\\:bg-green-800:hover {\n  --bg-opacity: 1;\n  background-color: #276749;\n  background-color: rgba(39, 103, 73, var(--bg-opacity));\n}\n\n.hover\\:bg-green-900:hover {\n  --bg-opacity: 1;\n  background-color: #22543d;\n  background-color: rgba(34, 84, 61, var(--bg-opacity));\n}\n\n.hover\\:bg-teal-100:hover {\n  --bg-opacity: 1;\n  background-color: #e6fffa;\n  background-color: rgba(230, 255, 250, var(--bg-opacity));\n}\n\n.hover\\:bg-teal-200:hover {\n  --bg-opacity: 1;\n  background-color: #b2f5ea;\n  background-color: rgba(178, 245, 234, var(--bg-opacity));\n}\n\n.hover\\:bg-teal-300:hover {\n  --bg-opacity: 1;\n  background-color: #81e6d9;\n  background-color: rgba(129, 230, 217, var(--bg-opacity));\n}\n\n.hover\\:bg-teal-400:hover {\n  --bg-opacity: 1;\n  background-color: #4fd1c5;\n  background-color: rgba(79, 209, 197, var(--bg-opacity));\n}\n\n.hover\\:bg-teal-500:hover {\n  --bg-opacity: 1;\n  background-color: #38b2ac;\n  background-color: rgba(56, 178, 172, var(--bg-opacity));\n}\n\n.hover\\:bg-teal-600:hover {\n  --bg-opacity: 1;\n  background-color: #319795;\n  background-color: rgba(49, 151, 149, var(--bg-opacity));\n}\n\n.hover\\:bg-teal-700:hover {\n  --bg-opacity: 1;\n  background-color: #2c7a7b;\n  background-color: rgba(44, 122, 123, var(--bg-opacity));\n}\n\n.hover\\:bg-teal-800:hover {\n  --bg-opacity: 1;\n  background-color: #285e61;\n  background-color: rgba(40, 94, 97, var(--bg-opacity));\n}\n\n.hover\\:bg-teal-900:hover {\n  --bg-opacity: 1;\n  background-color: #234e52;\n  background-color: rgba(35, 78, 82, var(--bg-opacity));\n}\n\n.hover\\:bg-blue-100:hover {\n  --bg-opacity: 1;\n  background-color: #ebf8ff;\n  background-color: rgba(235, 248, 255, var(--bg-opacity));\n}\n\n.hover\\:bg-blue-200:hover {\n  --bg-opacity: 1;\n  background-color: #bee3f8;\n  background-color: rgba(190, 227, 248, var(--bg-opacity));\n}\n\n.hover\\:bg-blue-300:hover {\n  --bg-opacity: 1;\n  background-color: #90cdf4;\n  background-color: rgba(144, 205, 244, var(--bg-opacity));\n}\n\n.hover\\:bg-blue-400:hover {\n  --bg-opacity: 1;\n  background-color: #63b3ed;\n  background-color: rgba(99, 179, 237, var(--bg-opacity));\n}\n\n.hover\\:bg-blue-500:hover {\n  --bg-opacity: 1;\n  background-color: #4299e1;\n  background-color: rgba(66, 153, 225, var(--bg-opacity));\n}\n\n.hover\\:bg-blue-600:hover {\n  --bg-opacity: 1;\n  background-color: #3182ce;\n  background-color: rgba(49, 130, 206, var(--bg-opacity));\n}\n\n.hover\\:bg-blue-700:hover {\n  --bg-opacity: 1;\n  background-color: #2b6cb0;\n  background-color: rgba(43, 108, 176, var(--bg-opacity));\n}\n\n.hover\\:bg-blue-800:hover {\n  --bg-opacity: 1;\n  background-color: #2c5282;\n  background-color: rgba(44, 82, 130, var(--bg-opacity));\n}\n\n.hover\\:bg-blue-900:hover {\n  --bg-opacity: 1;\n  background-color: #2a4365;\n  background-color: rgba(42, 67, 101, var(--bg-opacity));\n}\n\n.hover\\:bg-indigo-100:hover {\n  --bg-opacity: 1;\n  background-color: #ebf4ff;\n  background-color: rgba(235, 244, 255, var(--bg-opacity));\n}\n\n.hover\\:bg-indigo-200:hover {\n  --bg-opacity: 1;\n  background-color: #c3dafe;\n  background-color: rgba(195, 218, 254, var(--bg-opacity));\n}\n\n.hover\\:bg-indigo-300:hover {\n  --bg-opacity: 1;\n  background-color: #a3bffa;\n  background-color: rgba(163, 191, 250, var(--bg-opacity));\n}\n\n.hover\\:bg-indigo-400:hover {\n  --bg-opacity: 1;\n  background-color: #7f9cf5;\n  background-color: rgba(127, 156, 245, var(--bg-opacity));\n}\n\n.hover\\:bg-indigo-500:hover {\n  --bg-opacity: 1;\n  background-color: #667eea;\n  background-color: rgba(102, 126, 234, var(--bg-opacity));\n}\n\n.hover\\:bg-indigo-600:hover {\n  --bg-opacity: 1;\n  background-color: #5a67d8;\n  background-color: rgba(90, 103, 216, var(--bg-opacity));\n}\n\n.hover\\:bg-indigo-700:hover {\n  --bg-opacity: 1;\n  background-color: #4c51bf;\n  background-color: rgba(76, 81, 191, var(--bg-opacity));\n}\n\n.hover\\:bg-indigo-800:hover {\n  --bg-opacity: 1;\n  background-color: #434190;\n  background-color: rgba(67, 65, 144, var(--bg-opacity));\n}\n\n.hover\\:bg-indigo-900:hover {\n  --bg-opacity: 1;\n  background-color: #3c366b;\n  background-color: rgba(60, 54, 107, var(--bg-opacity));\n}\n\n.hover\\:bg-purple-100:hover {\n  --bg-opacity: 1;\n  background-color: #faf5ff;\n  background-color: rgba(250, 245, 255, var(--bg-opacity));\n}\n\n.hover\\:bg-purple-200:hover {\n  --bg-opacity: 1;\n  background-color: #e9d8fd;\n  background-color: rgba(233, 216, 253, var(--bg-opacity));\n}\n\n.hover\\:bg-purple-300:hover {\n  --bg-opacity: 1;\n  background-color: #d6bcfa;\n  background-color: rgba(214, 188, 250, var(--bg-opacity));\n}\n\n.hover\\:bg-purple-400:hover {\n  --bg-opacity: 1;\n  background-color: #b794f4;\n  background-color: rgba(183, 148, 244, var(--bg-opacity));\n}\n\n.hover\\:bg-purple-500:hover {\n  --bg-opacity: 1;\n  background-color: #9f7aea;\n  background-color: rgba(159, 122, 234, var(--bg-opacity));\n}\n\n.hover\\:bg-purple-600:hover {\n  --bg-opacity: 1;\n  background-color: #805ad5;\n  background-color: rgba(128, 90, 213, var(--bg-opacity));\n}\n\n.hover\\:bg-purple-700:hover {\n  --bg-opacity: 1;\n  background-color: #6b46c1;\n  background-color: rgba(107, 70, 193, var(--bg-opacity));\n}\n\n.hover\\:bg-purple-800:hover {\n  --bg-opacity: 1;\n  background-color: #553c9a;\n  background-color: rgba(85, 60, 154, var(--bg-opacity));\n}\n\n.hover\\:bg-purple-900:hover {\n  --bg-opacity: 1;\n  background-color: #44337a;\n  background-color: rgba(68, 51, 122, var(--bg-opacity));\n}\n\n.hover\\:bg-pink-100:hover {\n  --bg-opacity: 1;\n  background-color: #fff5f7;\n  background-color: rgba(255, 245, 247, var(--bg-opacity));\n}\n\n.hover\\:bg-pink-200:hover {\n  --bg-opacity: 1;\n  background-color: #fed7e2;\n  background-color: rgba(254, 215, 226, var(--bg-opacity));\n}\n\n.hover\\:bg-pink-300:hover {\n  --bg-opacity: 1;\n  background-color: #fbb6ce;\n  background-color: rgba(251, 182, 206, var(--bg-opacity));\n}\n\n.hover\\:bg-pink-400:hover {\n  --bg-opacity: 1;\n  background-color: #f687b3;\n  background-color: rgba(246, 135, 179, var(--bg-opacity));\n}\n\n.hover\\:bg-pink-500:hover {\n  --bg-opacity: 1;\n  background-color: #ed64a6;\n  background-color: rgba(237, 100, 166, var(--bg-opacity));\n}\n\n.hover\\:bg-pink-600:hover {\n  --bg-opacity: 1;\n  background-color: #d53f8c;\n  background-color: rgba(213, 63, 140, var(--bg-opacity));\n}\n\n.hover\\:bg-pink-700:hover {\n  --bg-opacity: 1;\n  background-color: #b83280;\n  background-color: rgba(184, 50, 128, var(--bg-opacity));\n}\n\n.hover\\:bg-pink-800:hover {\n  --bg-opacity: 1;\n  background-color: #97266d;\n  background-color: rgba(151, 38, 109, var(--bg-opacity));\n}\n\n.hover\\:bg-pink-900:hover {\n  --bg-opacity: 1;\n  background-color: #702459;\n  background-color: rgba(112, 36, 89, var(--bg-opacity));\n}\n\n.focus\\:bg-transparent:focus {\n  background-color: transparent;\n}\n\n.focus\\:bg-current:focus {\n  background-color: currentColor;\n}\n\n.focus\\:bg-black:focus {\n  --bg-opacity: 1;\n  background-color: #000;\n  background-color: rgba(0, 0, 0, var(--bg-opacity));\n}\n\n.focus\\:bg-white:focus {\n  --bg-opacity: 1;\n  background-color: #fff;\n  background-color: rgba(255, 255, 255, var(--bg-opacity));\n}\n\n.focus\\:bg-gray-100:focus {\n  --bg-opacity: 1;\n  background-color: #f7fafc;\n  background-color: rgba(247, 250, 252, var(--bg-opacity));\n}\n\n.focus\\:bg-gray-200:focus {\n  --bg-opacity: 1;\n  background-color: #edf2f7;\n  background-color: rgba(237, 242, 247, var(--bg-opacity));\n}\n\n.focus\\:bg-gray-300:focus {\n  --bg-opacity: 1;\n  background-color: #e2e8f0;\n  background-color: rgba(226, 232, 240, var(--bg-opacity));\n}\n\n.focus\\:bg-gray-400:focus {\n  --bg-opacity: 1;\n  background-color: #cbd5e0;\n  background-color: rgba(203, 213, 224, var(--bg-opacity));\n}\n\n.focus\\:bg-gray-500:focus {\n  --bg-opacity: 1;\n  background-color: #a0aec0;\n  background-color: rgba(160, 174, 192, var(--bg-opacity));\n}\n\n.focus\\:bg-gray-600:focus {\n  --bg-opacity: 1;\n  background-color: #718096;\n  background-color: rgba(113, 128, 150, var(--bg-opacity));\n}\n\n.focus\\:bg-gray-700:focus {\n  --bg-opacity: 1;\n  background-color: #4a5568;\n  background-color: rgba(74, 85, 104, var(--bg-opacity));\n}\n\n.focus\\:bg-gray-800:focus {\n  --bg-opacity: 1;\n  background-color: #2d3748;\n  background-color: rgba(45, 55, 72, var(--bg-opacity));\n}\n\n.focus\\:bg-gray-900:focus {\n  --bg-opacity: 1;\n  background-color: #1a202c;\n  background-color: rgba(26, 32, 44, var(--bg-opacity));\n}\n\n.focus\\:bg-red-100:focus {\n  --bg-opacity: 1;\n  background-color: #fff5f5;\n  background-color: rgba(255, 245, 245, var(--bg-opacity));\n}\n\n.focus\\:bg-red-200:focus {\n  --bg-opacity: 1;\n  background-color: #fed7d7;\n  background-color: rgba(254, 215, 215, var(--bg-opacity));\n}\n\n.focus\\:bg-red-300:focus {\n  --bg-opacity: 1;\n  background-color: #feb2b2;\n  background-color: rgba(254, 178, 178, var(--bg-opacity));\n}\n\n.focus\\:bg-red-400:focus {\n  --bg-opacity: 1;\n  background-color: #fc8181;\n  background-color: rgba(252, 129, 129, var(--bg-opacity));\n}\n\n.focus\\:bg-red-500:focus {\n  --bg-opacity: 1;\n  background-color: #f56565;\n  background-color: rgba(245, 101, 101, var(--bg-opacity));\n}\n\n.focus\\:bg-red-600:focus {\n  --bg-opacity: 1;\n  background-color: #e53e3e;\n  background-color: rgba(229, 62, 62, var(--bg-opacity));\n}\n\n.focus\\:bg-red-700:focus {\n  --bg-opacity: 1;\n  background-color: #c53030;\n  background-color: rgba(197, 48, 48, var(--bg-opacity));\n}\n\n.focus\\:bg-red-800:focus {\n  --bg-opacity: 1;\n  background-color: #9b2c2c;\n  background-color: rgba(155, 44, 44, var(--bg-opacity));\n}\n\n.focus\\:bg-red-900:focus {\n  --bg-opacity: 1;\n  background-color: #742a2a;\n  background-color: rgba(116, 42, 42, var(--bg-opacity));\n}\n\n.focus\\:bg-orange-100:focus {\n  --bg-opacity: 1;\n  background-color: #fffaf0;\n  background-color: rgba(255, 250, 240, var(--bg-opacity));\n}\n\n.focus\\:bg-orange-200:focus {\n  --bg-opacity: 1;\n  background-color: #feebc8;\n  background-color: rgba(254, 235, 200, var(--bg-opacity));\n}\n\n.focus\\:bg-orange-300:focus {\n  --bg-opacity: 1;\n  background-color: #fbd38d;\n  background-color: rgba(251, 211, 141, var(--bg-opacity));\n}\n\n.focus\\:bg-orange-400:focus {\n  --bg-opacity: 1;\n  background-color: #f6ad55;\n  background-color: rgba(246, 173, 85, var(--bg-opacity));\n}\n\n.focus\\:bg-orange-500:focus {\n  --bg-opacity: 1;\n  background-color: #ed8936;\n  background-color: rgba(237, 137, 54, var(--bg-opacity));\n}\n\n.focus\\:bg-orange-600:focus {\n  --bg-opacity: 1;\n  background-color: #dd6b20;\n  background-color: rgba(221, 107, 32, var(--bg-opacity));\n}\n\n.focus\\:bg-orange-700:focus {\n  --bg-opacity: 1;\n  background-color: #c05621;\n  background-color: rgba(192, 86, 33, var(--bg-opacity));\n}\n\n.focus\\:bg-orange-800:focus {\n  --bg-opacity: 1;\n  background-color: #9c4221;\n  background-color: rgba(156, 66, 33, var(--bg-opacity));\n}\n\n.focus\\:bg-orange-900:focus {\n  --bg-opacity: 1;\n  background-color: #7b341e;\n  background-color: rgba(123, 52, 30, var(--bg-opacity));\n}\n\n.focus\\:bg-yellow-100:focus {\n  --bg-opacity: 1;\n  background-color: #fffff0;\n  background-color: rgba(255, 255, 240, var(--bg-opacity));\n}\n\n.focus\\:bg-yellow-200:focus {\n  --bg-opacity: 1;\n  background-color: #fefcbf;\n  background-color: rgba(254, 252, 191, var(--bg-opacity));\n}\n\n.focus\\:bg-yellow-300:focus {\n  --bg-opacity: 1;\n  background-color: #faf089;\n  background-color: rgba(250, 240, 137, var(--bg-opacity));\n}\n\n.focus\\:bg-yellow-400:focus {\n  --bg-opacity: 1;\n  background-color: #f6e05e;\n  background-color: rgba(246, 224, 94, var(--bg-opacity));\n}\n\n.focus\\:bg-yellow-500:focus {\n  --bg-opacity: 1;\n  background-color: #ecc94b;\n  background-color: rgba(236, 201, 75, var(--bg-opacity));\n}\n\n.focus\\:bg-yellow-600:focus {\n  --bg-opacity: 1;\n  background-color: #d69e2e;\n  background-color: rgba(214, 158, 46, var(--bg-opacity));\n}\n\n.focus\\:bg-yellow-700:focus {\n  --bg-opacity: 1;\n  background-color: #b7791f;\n  background-color: rgba(183, 121, 31, var(--bg-opacity));\n}\n\n.focus\\:bg-yellow-800:focus {\n  --bg-opacity: 1;\n  background-color: #975a16;\n  background-color: rgba(151, 90, 22, var(--bg-opacity));\n}\n\n.focus\\:bg-yellow-900:focus {\n  --bg-opacity: 1;\n  background-color: #744210;\n  background-color: rgba(116, 66, 16, var(--bg-opacity));\n}\n\n.focus\\:bg-green-100:focus {\n  --bg-opacity: 1;\n  background-color: #f0fff4;\n  background-color: rgba(240, 255, 244, var(--bg-opacity));\n}\n\n.focus\\:bg-green-200:focus {\n  --bg-opacity: 1;\n  background-color: #c6f6d5;\n  background-color: rgba(198, 246, 213, var(--bg-opacity));\n}\n\n.focus\\:bg-green-300:focus {\n  --bg-opacity: 1;\n  background-color: #9ae6b4;\n  background-color: rgba(154, 230, 180, var(--bg-opacity));\n}\n\n.focus\\:bg-green-400:focus {\n  --bg-opacity: 1;\n  background-color: #68d391;\n  background-color: rgba(104, 211, 145, var(--bg-opacity));\n}\n\n.focus\\:bg-green-500:focus {\n  --bg-opacity: 1;\n  background-color: #48bb78;\n  background-color: rgba(72, 187, 120, var(--bg-opacity));\n}\n\n.focus\\:bg-green-600:focus {\n  --bg-opacity: 1;\n  background-color: #38a169;\n  background-color: rgba(56, 161, 105, var(--bg-opacity));\n}\n\n.focus\\:bg-green-700:focus {\n  --bg-opacity: 1;\n  background-color: #2f855a;\n  background-color: rgba(47, 133, 90, var(--bg-opacity));\n}\n\n.focus\\:bg-green-800:focus {\n  --bg-opacity: 1;\n  background-color: #276749;\n  background-color: rgba(39, 103, 73, var(--bg-opacity));\n}\n\n.focus\\:bg-green-900:focus {\n  --bg-opacity: 1;\n  background-color: #22543d;\n  background-color: rgba(34, 84, 61, var(--bg-opacity));\n}\n\n.focus\\:bg-teal-100:focus {\n  --bg-opacity: 1;\n  background-color: #e6fffa;\n  background-color: rgba(230, 255, 250, var(--bg-opacity));\n}\n\n.focus\\:bg-teal-200:focus {\n  --bg-opacity: 1;\n  background-color: #b2f5ea;\n  background-color: rgba(178, 245, 234, var(--bg-opacity));\n}\n\n.focus\\:bg-teal-300:focus {\n  --bg-opacity: 1;\n  background-color: #81e6d9;\n  background-color: rgba(129, 230, 217, var(--bg-opacity));\n}\n\n.focus\\:bg-teal-400:focus {\n  --bg-opacity: 1;\n  background-color: #4fd1c5;\n  background-color: rgba(79, 209, 197, var(--bg-opacity));\n}\n\n.focus\\:bg-teal-500:focus {\n  --bg-opacity: 1;\n  background-color: #38b2ac;\n  background-color: rgba(56, 178, 172, var(--bg-opacity));\n}\n\n.focus\\:bg-teal-600:focus {\n  --bg-opacity: 1;\n  background-color: #319795;\n  background-color: rgba(49, 151, 149, var(--bg-opacity));\n}\n\n.focus\\:bg-teal-700:focus {\n  --bg-opacity: 1;\n  background-color: #2c7a7b;\n  background-color: rgba(44, 122, 123, var(--bg-opacity));\n}\n\n.focus\\:bg-teal-800:focus {\n  --bg-opacity: 1;\n  background-color: #285e61;\n  background-color: rgba(40, 94, 97, var(--bg-opacity));\n}\n\n.focus\\:bg-teal-900:focus {\n  --bg-opacity: 1;\n  background-color: #234e52;\n  background-color: rgba(35, 78, 82, var(--bg-opacity));\n}\n\n.focus\\:bg-blue-100:focus {\n  --bg-opacity: 1;\n  background-color: #ebf8ff;\n  background-color: rgba(235, 248, 255, var(--bg-opacity));\n}\n\n.focus\\:bg-blue-200:focus {\n  --bg-opacity: 1;\n  background-color: #bee3f8;\n  background-color: rgba(190, 227, 248, var(--bg-opacity));\n}\n\n.focus\\:bg-blue-300:focus {\n  --bg-opacity: 1;\n  background-color: #90cdf4;\n  background-color: rgba(144, 205, 244, var(--bg-opacity));\n}\n\n.focus\\:bg-blue-400:focus {\n  --bg-opacity: 1;\n  background-color: #63b3ed;\n  background-color: rgba(99, 179, 237, var(--bg-opacity));\n}\n\n.focus\\:bg-blue-500:focus {\n  --bg-opacity: 1;\n  background-color: #4299e1;\n  background-color: rgba(66, 153, 225, var(--bg-opacity));\n}\n\n.focus\\:bg-blue-600:focus {\n  --bg-opacity: 1;\n  background-color: #3182ce;\n  background-color: rgba(49, 130, 206, var(--bg-opacity));\n}\n\n.focus\\:bg-blue-700:focus {\n  --bg-opacity: 1;\n  background-color: #2b6cb0;\n  background-color: rgba(43, 108, 176, var(--bg-opacity));\n}\n\n.focus\\:bg-blue-800:focus {\n  --bg-opacity: 1;\n  background-color: #2c5282;\n  background-color: rgba(44, 82, 130, var(--bg-opacity));\n}\n\n.focus\\:bg-blue-900:focus {\n  --bg-opacity: 1;\n  background-color: #2a4365;\n  background-color: rgba(42, 67, 101, var(--bg-opacity));\n}\n\n.focus\\:bg-indigo-100:focus {\n  --bg-opacity: 1;\n  background-color: #ebf4ff;\n  background-color: rgba(235, 244, 255, var(--bg-opacity));\n}\n\n.focus\\:bg-indigo-200:focus {\n  --bg-opacity: 1;\n  background-color: #c3dafe;\n  background-color: rgba(195, 218, 254, var(--bg-opacity));\n}\n\n.focus\\:bg-indigo-300:focus {\n  --bg-opacity: 1;\n  background-color: #a3bffa;\n  background-color: rgba(163, 191, 250, var(--bg-opacity));\n}\n\n.focus\\:bg-indigo-400:focus {\n  --bg-opacity: 1;\n  background-color: #7f9cf5;\n  background-color: rgba(127, 156, 245, var(--bg-opacity));\n}\n\n.focus\\:bg-indigo-500:focus {\n  --bg-opacity: 1;\n  background-color: #667eea;\n  background-color: rgba(102, 126, 234, var(--bg-opacity));\n}\n\n.focus\\:bg-indigo-600:focus {\n  --bg-opacity: 1;\n  background-color: #5a67d8;\n  background-color: rgba(90, 103, 216, var(--bg-opacity));\n}\n\n.focus\\:bg-indigo-700:focus {\n  --bg-opacity: 1;\n  background-color: #4c51bf;\n  background-color: rgba(76, 81, 191, var(--bg-opacity));\n}\n\n.focus\\:bg-indigo-800:focus {\n  --bg-opacity: 1;\n  background-color: #434190;\n  background-color: rgba(67, 65, 144, var(--bg-opacity));\n}\n\n.focus\\:bg-indigo-900:focus {\n  --bg-opacity: 1;\n  background-color: #3c366b;\n  background-color: rgba(60, 54, 107, var(--bg-opacity));\n}\n\n.focus\\:bg-purple-100:focus {\n  --bg-opacity: 1;\n  background-color: #faf5ff;\n  background-color: rgba(250, 245, 255, var(--bg-opacity));\n}\n\n.focus\\:bg-purple-200:focus {\n  --bg-opacity: 1;\n  background-color: #e9d8fd;\n  background-color: rgba(233, 216, 253, var(--bg-opacity));\n}\n\n.focus\\:bg-purple-300:focus {\n  --bg-opacity: 1;\n  background-color: #d6bcfa;\n  background-color: rgba(214, 188, 250, var(--bg-opacity));\n}\n\n.focus\\:bg-purple-400:focus {\n  --bg-opacity: 1;\n  background-color: #b794f4;\n  background-color: rgba(183, 148, 244, var(--bg-opacity));\n}\n\n.focus\\:bg-purple-500:focus {\n  --bg-opacity: 1;\n  background-color: #9f7aea;\n  background-color: rgba(159, 122, 234, var(--bg-opacity));\n}\n\n.focus\\:bg-purple-600:focus {\n  --bg-opacity: 1;\n  background-color: #805ad5;\n  background-color: rgba(128, 90, 213, var(--bg-opacity));\n}\n\n.focus\\:bg-purple-700:focus {\n  --bg-opacity: 1;\n  background-color: #6b46c1;\n  background-color: rgba(107, 70, 193, var(--bg-opacity));\n}\n\n.focus\\:bg-purple-800:focus {\n  --bg-opacity: 1;\n  background-color: #553c9a;\n  background-color: rgba(85, 60, 154, var(--bg-opacity));\n}\n\n.focus\\:bg-purple-900:focus {\n  --bg-opacity: 1;\n  background-color: #44337a;\n  background-color: rgba(68, 51, 122, var(--bg-opacity));\n}\n\n.focus\\:bg-pink-100:focus {\n  --bg-opacity: 1;\n  background-color: #fff5f7;\n  background-color: rgba(255, 245, 247, var(--bg-opacity));\n}\n\n.focus\\:bg-pink-200:focus {\n  --bg-opacity: 1;\n  background-color: #fed7e2;\n  background-color: rgba(254, 215, 226, var(--bg-opacity));\n}\n\n.focus\\:bg-pink-300:focus {\n  --bg-opacity: 1;\n  background-color: #fbb6ce;\n  background-color: rgba(251, 182, 206, var(--bg-opacity));\n}\n\n.focus\\:bg-pink-400:focus {\n  --bg-opacity: 1;\n  background-color: #f687b3;\n  background-color: rgba(246, 135, 179, var(--bg-opacity));\n}\n\n.focus\\:bg-pink-500:focus {\n  --bg-opacity: 1;\n  background-color: #ed64a6;\n  background-color: rgba(237, 100, 166, var(--bg-opacity));\n}\n\n.focus\\:bg-pink-600:focus {\n  --bg-opacity: 1;\n  background-color: #d53f8c;\n  background-color: rgba(213, 63, 140, var(--bg-opacity));\n}\n\n.focus\\:bg-pink-700:focus {\n  --bg-opacity: 1;\n  background-color: #b83280;\n  background-color: rgba(184, 50, 128, var(--bg-opacity));\n}\n\n.focus\\:bg-pink-800:focus {\n  --bg-opacity: 1;\n  background-color: #97266d;\n  background-color: rgba(151, 38, 109, var(--bg-opacity));\n}\n\n.focus\\:bg-pink-900:focus {\n  --bg-opacity: 1;\n  background-color: #702459;\n  background-color: rgba(112, 36, 89, var(--bg-opacity));\n}\n\n.bg-none {\n  background-image: none;\n}\n\n.bg-gradient-to-t {\n  background-image: linear-gradient(to top, var(--gradient-color-stops));\n}\n\n.bg-gradient-to-tr {\n  background-image: linear-gradient(to top right, var(--gradient-color-stops));\n}\n\n.bg-gradient-to-r {\n  background-image: linear-gradient(to right, var(--gradient-color-stops));\n}\n\n.bg-gradient-to-br {\n  background-image: linear-gradient(to bottom right, var(--gradient-color-stops));\n}\n\n.bg-gradient-to-b {\n  background-image: linear-gradient(to bottom, var(--gradient-color-stops));\n}\n\n.bg-gradient-to-bl {\n  background-image: linear-gradient(to bottom left, var(--gradient-color-stops));\n}\n\n.bg-gradient-to-l {\n  background-image: linear-gradient(to left, var(--gradient-color-stops));\n}\n\n.bg-gradient-to-tl {\n  background-image: linear-gradient(to top left, var(--gradient-color-stops));\n}\n\n.from-transparent {\n  --gradient-from-color: transparent;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(0, 0, 0, 0));\n}\n\n.from-current {\n  --gradient-from-color: currentColor;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(255, 255, 255, 0));\n}\n\n.from-black {\n  --gradient-from-color: #000;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(0, 0, 0, 0));\n}\n\n.from-white {\n  --gradient-from-color: #fff;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(255, 255, 255, 0));\n}\n\n.from-gray-100 {\n  --gradient-from-color: #f7fafc;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(247, 250, 252, 0));\n}\n\n.from-gray-200 {\n  --gradient-from-color: #edf2f7;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(237, 242, 247, 0));\n}\n\n.from-gray-300 {\n  --gradient-from-color: #e2e8f0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(226, 232, 240, 0));\n}\n\n.from-gray-400 {\n  --gradient-from-color: #cbd5e0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(203, 213, 224, 0));\n}\n\n.from-gray-500 {\n  --gradient-from-color: #a0aec0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(160, 174, 192, 0));\n}\n\n.from-gray-600 {\n  --gradient-from-color: #718096;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(113, 128, 150, 0));\n}\n\n.from-gray-700 {\n  --gradient-from-color: #4a5568;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(74, 85, 104, 0));\n}\n\n.from-gray-800 {\n  --gradient-from-color: #2d3748;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(45, 55, 72, 0));\n}\n\n.from-gray-900 {\n  --gradient-from-color: #1a202c;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(26, 32, 44, 0));\n}\n\n.from-red-100 {\n  --gradient-from-color: #fff5f5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(255, 245, 245, 0));\n}\n\n.from-red-200 {\n  --gradient-from-color: #fed7d7;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(254, 215, 215, 0));\n}\n\n.from-red-300 {\n  --gradient-from-color: #feb2b2;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(254, 178, 178, 0));\n}\n\n.from-red-400 {\n  --gradient-from-color: #fc8181;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(252, 129, 129, 0));\n}\n\n.from-red-500 {\n  --gradient-from-color: #f56565;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(245, 101, 101, 0));\n}\n\n.from-red-600 {\n  --gradient-from-color: #e53e3e;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(229, 62, 62, 0));\n}\n\n.from-red-700 {\n  --gradient-from-color: #c53030;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(197, 48, 48, 0));\n}\n\n.from-red-800 {\n  --gradient-from-color: #9b2c2c;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(155, 44, 44, 0));\n}\n\n.from-red-900 {\n  --gradient-from-color: #742a2a;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(116, 42, 42, 0));\n}\n\n.from-orange-100 {\n  --gradient-from-color: #fffaf0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(255, 250, 240, 0));\n}\n\n.from-orange-200 {\n  --gradient-from-color: #feebc8;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(254, 235, 200, 0));\n}\n\n.from-orange-300 {\n  --gradient-from-color: #fbd38d;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(251, 211, 141, 0));\n}\n\n.from-orange-400 {\n  --gradient-from-color: #f6ad55;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(246, 173, 85, 0));\n}\n\n.from-orange-500 {\n  --gradient-from-color: #ed8936;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(237, 137, 54, 0));\n}\n\n.from-orange-600 {\n  --gradient-from-color: #dd6b20;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(221, 107, 32, 0));\n}\n\n.from-orange-700 {\n  --gradient-from-color: #c05621;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(192, 86, 33, 0));\n}\n\n.from-orange-800 {\n  --gradient-from-color: #9c4221;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(156, 66, 33, 0));\n}\n\n.from-orange-900 {\n  --gradient-from-color: #7b341e;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(123, 52, 30, 0));\n}\n\n.from-yellow-100 {\n  --gradient-from-color: #fffff0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(255, 255, 240, 0));\n}\n\n.from-yellow-200 {\n  --gradient-from-color: #fefcbf;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(254, 252, 191, 0));\n}\n\n.from-yellow-300 {\n  --gradient-from-color: #faf089;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(250, 240, 137, 0));\n}\n\n.from-yellow-400 {\n  --gradient-from-color: #f6e05e;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(246, 224, 94, 0));\n}\n\n.from-yellow-500 {\n  --gradient-from-color: #ecc94b;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(236, 201, 75, 0));\n}\n\n.from-yellow-600 {\n  --gradient-from-color: #d69e2e;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(214, 158, 46, 0));\n}\n\n.from-yellow-700 {\n  --gradient-from-color: #b7791f;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(183, 121, 31, 0));\n}\n\n.from-yellow-800 {\n  --gradient-from-color: #975a16;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(151, 90, 22, 0));\n}\n\n.from-yellow-900 {\n  --gradient-from-color: #744210;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(116, 66, 16, 0));\n}\n\n.from-green-100 {\n  --gradient-from-color: #f0fff4;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(240, 255, 244, 0));\n}\n\n.from-green-200 {\n  --gradient-from-color: #c6f6d5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(198, 246, 213, 0));\n}\n\n.from-green-300 {\n  --gradient-from-color: #9ae6b4;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(154, 230, 180, 0));\n}\n\n.from-green-400 {\n  --gradient-from-color: #68d391;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(104, 211, 145, 0));\n}\n\n.from-green-500 {\n  --gradient-from-color: #48bb78;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(72, 187, 120, 0));\n}\n\n.from-green-600 {\n  --gradient-from-color: #38a169;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(56, 161, 105, 0));\n}\n\n.from-green-700 {\n  --gradient-from-color: #2f855a;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(47, 133, 90, 0));\n}\n\n.from-green-800 {\n  --gradient-from-color: #276749;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(39, 103, 73, 0));\n}\n\n.from-green-900 {\n  --gradient-from-color: #22543d;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(34, 84, 61, 0));\n}\n\n.from-teal-100 {\n  --gradient-from-color: #e6fffa;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(230, 255, 250, 0));\n}\n\n.from-teal-200 {\n  --gradient-from-color: #b2f5ea;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(178, 245, 234, 0));\n}\n\n.from-teal-300 {\n  --gradient-from-color: #81e6d9;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(129, 230, 217, 0));\n}\n\n.from-teal-400 {\n  --gradient-from-color: #4fd1c5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(79, 209, 197, 0));\n}\n\n.from-teal-500 {\n  --gradient-from-color: #38b2ac;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(56, 178, 172, 0));\n}\n\n.from-teal-600 {\n  --gradient-from-color: #319795;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(49, 151, 149, 0));\n}\n\n.from-teal-700 {\n  --gradient-from-color: #2c7a7b;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(44, 122, 123, 0));\n}\n\n.from-teal-800 {\n  --gradient-from-color: #285e61;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(40, 94, 97, 0));\n}\n\n.from-teal-900 {\n  --gradient-from-color: #234e52;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(35, 78, 82, 0));\n}\n\n.from-blue-100 {\n  --gradient-from-color: #ebf8ff;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(235, 248, 255, 0));\n}\n\n.from-blue-200 {\n  --gradient-from-color: #bee3f8;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(190, 227, 248, 0));\n}\n\n.from-blue-300 {\n  --gradient-from-color: #90cdf4;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(144, 205, 244, 0));\n}\n\n.from-blue-400 {\n  --gradient-from-color: #63b3ed;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(99, 179, 237, 0));\n}\n\n.from-blue-500 {\n  --gradient-from-color: #4299e1;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(66, 153, 225, 0));\n}\n\n.from-blue-600 {\n  --gradient-from-color: #3182ce;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(49, 130, 206, 0));\n}\n\n.from-blue-700 {\n  --gradient-from-color: #2b6cb0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(43, 108, 176, 0));\n}\n\n.from-blue-800 {\n  --gradient-from-color: #2c5282;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(44, 82, 130, 0));\n}\n\n.from-blue-900 {\n  --gradient-from-color: #2a4365;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(42, 67, 101, 0));\n}\n\n.from-indigo-100 {\n  --gradient-from-color: #ebf4ff;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(235, 244, 255, 0));\n}\n\n.from-indigo-200 {\n  --gradient-from-color: #c3dafe;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(195, 218, 254, 0));\n}\n\n.from-indigo-300 {\n  --gradient-from-color: #a3bffa;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(163, 191, 250, 0));\n}\n\n.from-indigo-400 {\n  --gradient-from-color: #7f9cf5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(127, 156, 245, 0));\n}\n\n.from-indigo-500 {\n  --gradient-from-color: #667eea;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(102, 126, 234, 0));\n}\n\n.from-indigo-600 {\n  --gradient-from-color: #5a67d8;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(90, 103, 216, 0));\n}\n\n.from-indigo-700 {\n  --gradient-from-color: #4c51bf;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(76, 81, 191, 0));\n}\n\n.from-indigo-800 {\n  --gradient-from-color: #434190;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(67, 65, 144, 0));\n}\n\n.from-indigo-900 {\n  --gradient-from-color: #3c366b;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(60, 54, 107, 0));\n}\n\n.from-purple-100 {\n  --gradient-from-color: #faf5ff;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(250, 245, 255, 0));\n}\n\n.from-purple-200 {\n  --gradient-from-color: #e9d8fd;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(233, 216, 253, 0));\n}\n\n.from-purple-300 {\n  --gradient-from-color: #d6bcfa;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(214, 188, 250, 0));\n}\n\n.from-purple-400 {\n  --gradient-from-color: #b794f4;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(183, 148, 244, 0));\n}\n\n.from-purple-500 {\n  --gradient-from-color: #9f7aea;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(159, 122, 234, 0));\n}\n\n.from-purple-600 {\n  --gradient-from-color: #805ad5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(128, 90, 213, 0));\n}\n\n.from-purple-700 {\n  --gradient-from-color: #6b46c1;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(107, 70, 193, 0));\n}\n\n.from-purple-800 {\n  --gradient-from-color: #553c9a;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(85, 60, 154, 0));\n}\n\n.from-purple-900 {\n  --gradient-from-color: #44337a;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(68, 51, 122, 0));\n}\n\n.from-pink-100 {\n  --gradient-from-color: #fff5f7;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(255, 245, 247, 0));\n}\n\n.from-pink-200 {\n  --gradient-from-color: #fed7e2;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(254, 215, 226, 0));\n}\n\n.from-pink-300 {\n  --gradient-from-color: #fbb6ce;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(251, 182, 206, 0));\n}\n\n.from-pink-400 {\n  --gradient-from-color: #f687b3;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(246, 135, 179, 0));\n}\n\n.from-pink-500 {\n  --gradient-from-color: #ed64a6;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(237, 100, 166, 0));\n}\n\n.from-pink-600 {\n  --gradient-from-color: #d53f8c;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(213, 63, 140, 0));\n}\n\n.from-pink-700 {\n  --gradient-from-color: #b83280;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(184, 50, 128, 0));\n}\n\n.from-pink-800 {\n  --gradient-from-color: #97266d;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(151, 38, 109, 0));\n}\n\n.from-pink-900 {\n  --gradient-from-color: #702459;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(112, 36, 89, 0));\n}\n\n.via-transparent {\n  --gradient-via-color: transparent;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(0, 0, 0, 0));\n}\n\n.via-current {\n  --gradient-via-color: currentColor;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(255, 255, 255, 0));\n}\n\n.via-black {\n  --gradient-via-color: #000;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(0, 0, 0, 0));\n}\n\n.via-white {\n  --gradient-via-color: #fff;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(255, 255, 255, 0));\n}\n\n.via-gray-100 {\n  --gradient-via-color: #f7fafc;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(247, 250, 252, 0));\n}\n\n.via-gray-200 {\n  --gradient-via-color: #edf2f7;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(237, 242, 247, 0));\n}\n\n.via-gray-300 {\n  --gradient-via-color: #e2e8f0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(226, 232, 240, 0));\n}\n\n.via-gray-400 {\n  --gradient-via-color: #cbd5e0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(203, 213, 224, 0));\n}\n\n.via-gray-500 {\n  --gradient-via-color: #a0aec0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(160, 174, 192, 0));\n}\n\n.via-gray-600 {\n  --gradient-via-color: #718096;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(113, 128, 150, 0));\n}\n\n.via-gray-700 {\n  --gradient-via-color: #4a5568;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(74, 85, 104, 0));\n}\n\n.via-gray-800 {\n  --gradient-via-color: #2d3748;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(45, 55, 72, 0));\n}\n\n.via-gray-900 {\n  --gradient-via-color: #1a202c;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(26, 32, 44, 0));\n}\n\n.via-red-100 {\n  --gradient-via-color: #fff5f5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(255, 245, 245, 0));\n}\n\n.via-red-200 {\n  --gradient-via-color: #fed7d7;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(254, 215, 215, 0));\n}\n\n.via-red-300 {\n  --gradient-via-color: #feb2b2;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(254, 178, 178, 0));\n}\n\n.via-red-400 {\n  --gradient-via-color: #fc8181;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(252, 129, 129, 0));\n}\n\n.via-red-500 {\n  --gradient-via-color: #f56565;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(245, 101, 101, 0));\n}\n\n.via-red-600 {\n  --gradient-via-color: #e53e3e;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(229, 62, 62, 0));\n}\n\n.via-red-700 {\n  --gradient-via-color: #c53030;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(197, 48, 48, 0));\n}\n\n.via-red-800 {\n  --gradient-via-color: #9b2c2c;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(155, 44, 44, 0));\n}\n\n.via-red-900 {\n  --gradient-via-color: #742a2a;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(116, 42, 42, 0));\n}\n\n.via-orange-100 {\n  --gradient-via-color: #fffaf0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(255, 250, 240, 0));\n}\n\n.via-orange-200 {\n  --gradient-via-color: #feebc8;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(254, 235, 200, 0));\n}\n\n.via-orange-300 {\n  --gradient-via-color: #fbd38d;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(251, 211, 141, 0));\n}\n\n.via-orange-400 {\n  --gradient-via-color: #f6ad55;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(246, 173, 85, 0));\n}\n\n.via-orange-500 {\n  --gradient-via-color: #ed8936;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(237, 137, 54, 0));\n}\n\n.via-orange-600 {\n  --gradient-via-color: #dd6b20;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(221, 107, 32, 0));\n}\n\n.via-orange-700 {\n  --gradient-via-color: #c05621;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(192, 86, 33, 0));\n}\n\n.via-orange-800 {\n  --gradient-via-color: #9c4221;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(156, 66, 33, 0));\n}\n\n.via-orange-900 {\n  --gradient-via-color: #7b341e;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(123, 52, 30, 0));\n}\n\n.via-yellow-100 {\n  --gradient-via-color: #fffff0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(255, 255, 240, 0));\n}\n\n.via-yellow-200 {\n  --gradient-via-color: #fefcbf;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(254, 252, 191, 0));\n}\n\n.via-yellow-300 {\n  --gradient-via-color: #faf089;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(250, 240, 137, 0));\n}\n\n.via-yellow-400 {\n  --gradient-via-color: #f6e05e;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(246, 224, 94, 0));\n}\n\n.via-yellow-500 {\n  --gradient-via-color: #ecc94b;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(236, 201, 75, 0));\n}\n\n.via-yellow-600 {\n  --gradient-via-color: #d69e2e;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(214, 158, 46, 0));\n}\n\n.via-yellow-700 {\n  --gradient-via-color: #b7791f;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(183, 121, 31, 0));\n}\n\n.via-yellow-800 {\n  --gradient-via-color: #975a16;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(151, 90, 22, 0));\n}\n\n.via-yellow-900 {\n  --gradient-via-color: #744210;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(116, 66, 16, 0));\n}\n\n.via-green-100 {\n  --gradient-via-color: #f0fff4;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(240, 255, 244, 0));\n}\n\n.via-green-200 {\n  --gradient-via-color: #c6f6d5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(198, 246, 213, 0));\n}\n\n.via-green-300 {\n  --gradient-via-color: #9ae6b4;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(154, 230, 180, 0));\n}\n\n.via-green-400 {\n  --gradient-via-color: #68d391;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(104, 211, 145, 0));\n}\n\n.via-green-500 {\n  --gradient-via-color: #48bb78;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(72, 187, 120, 0));\n}\n\n.via-green-600 {\n  --gradient-via-color: #38a169;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(56, 161, 105, 0));\n}\n\n.via-green-700 {\n  --gradient-via-color: #2f855a;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(47, 133, 90, 0));\n}\n\n.via-green-800 {\n  --gradient-via-color: #276749;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(39, 103, 73, 0));\n}\n\n.via-green-900 {\n  --gradient-via-color: #22543d;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(34, 84, 61, 0));\n}\n\n.via-teal-100 {\n  --gradient-via-color: #e6fffa;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(230, 255, 250, 0));\n}\n\n.via-teal-200 {\n  --gradient-via-color: #b2f5ea;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(178, 245, 234, 0));\n}\n\n.via-teal-300 {\n  --gradient-via-color: #81e6d9;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(129, 230, 217, 0));\n}\n\n.via-teal-400 {\n  --gradient-via-color: #4fd1c5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(79, 209, 197, 0));\n}\n\n.via-teal-500 {\n  --gradient-via-color: #38b2ac;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(56, 178, 172, 0));\n}\n\n.via-teal-600 {\n  --gradient-via-color: #319795;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(49, 151, 149, 0));\n}\n\n.via-teal-700 {\n  --gradient-via-color: #2c7a7b;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(44, 122, 123, 0));\n}\n\n.via-teal-800 {\n  --gradient-via-color: #285e61;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(40, 94, 97, 0));\n}\n\n.via-teal-900 {\n  --gradient-via-color: #234e52;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(35, 78, 82, 0));\n}\n\n.via-blue-100 {\n  --gradient-via-color: #ebf8ff;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(235, 248, 255, 0));\n}\n\n.via-blue-200 {\n  --gradient-via-color: #bee3f8;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(190, 227, 248, 0));\n}\n\n.via-blue-300 {\n  --gradient-via-color: #90cdf4;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(144, 205, 244, 0));\n}\n\n.via-blue-400 {\n  --gradient-via-color: #63b3ed;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(99, 179, 237, 0));\n}\n\n.via-blue-500 {\n  --gradient-via-color: #4299e1;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(66, 153, 225, 0));\n}\n\n.via-blue-600 {\n  --gradient-via-color: #3182ce;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(49, 130, 206, 0));\n}\n\n.via-blue-700 {\n  --gradient-via-color: #2b6cb0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(43, 108, 176, 0));\n}\n\n.via-blue-800 {\n  --gradient-via-color: #2c5282;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(44, 82, 130, 0));\n}\n\n.via-blue-900 {\n  --gradient-via-color: #2a4365;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(42, 67, 101, 0));\n}\n\n.via-indigo-100 {\n  --gradient-via-color: #ebf4ff;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(235, 244, 255, 0));\n}\n\n.via-indigo-200 {\n  --gradient-via-color: #c3dafe;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(195, 218, 254, 0));\n}\n\n.via-indigo-300 {\n  --gradient-via-color: #a3bffa;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(163, 191, 250, 0));\n}\n\n.via-indigo-400 {\n  --gradient-via-color: #7f9cf5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(127, 156, 245, 0));\n}\n\n.via-indigo-500 {\n  --gradient-via-color: #667eea;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(102, 126, 234, 0));\n}\n\n.via-indigo-600 {\n  --gradient-via-color: #5a67d8;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(90, 103, 216, 0));\n}\n\n.via-indigo-700 {\n  --gradient-via-color: #4c51bf;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(76, 81, 191, 0));\n}\n\n.via-indigo-800 {\n  --gradient-via-color: #434190;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(67, 65, 144, 0));\n}\n\n.via-indigo-900 {\n  --gradient-via-color: #3c366b;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(60, 54, 107, 0));\n}\n\n.via-purple-100 {\n  --gradient-via-color: #faf5ff;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(250, 245, 255, 0));\n}\n\n.via-purple-200 {\n  --gradient-via-color: #e9d8fd;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(233, 216, 253, 0));\n}\n\n.via-purple-300 {\n  --gradient-via-color: #d6bcfa;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(214, 188, 250, 0));\n}\n\n.via-purple-400 {\n  --gradient-via-color: #b794f4;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(183, 148, 244, 0));\n}\n\n.via-purple-500 {\n  --gradient-via-color: #9f7aea;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(159, 122, 234, 0));\n}\n\n.via-purple-600 {\n  --gradient-via-color: #805ad5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(128, 90, 213, 0));\n}\n\n.via-purple-700 {\n  --gradient-via-color: #6b46c1;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(107, 70, 193, 0));\n}\n\n.via-purple-800 {\n  --gradient-via-color: #553c9a;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(85, 60, 154, 0));\n}\n\n.via-purple-900 {\n  --gradient-via-color: #44337a;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(68, 51, 122, 0));\n}\n\n.via-pink-100 {\n  --gradient-via-color: #fff5f7;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(255, 245, 247, 0));\n}\n\n.via-pink-200 {\n  --gradient-via-color: #fed7e2;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(254, 215, 226, 0));\n}\n\n.via-pink-300 {\n  --gradient-via-color: #fbb6ce;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(251, 182, 206, 0));\n}\n\n.via-pink-400 {\n  --gradient-via-color: #f687b3;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(246, 135, 179, 0));\n}\n\n.via-pink-500 {\n  --gradient-via-color: #ed64a6;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(237, 100, 166, 0));\n}\n\n.via-pink-600 {\n  --gradient-via-color: #d53f8c;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(213, 63, 140, 0));\n}\n\n.via-pink-700 {\n  --gradient-via-color: #b83280;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(184, 50, 128, 0));\n}\n\n.via-pink-800 {\n  --gradient-via-color: #97266d;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(151, 38, 109, 0));\n}\n\n.via-pink-900 {\n  --gradient-via-color: #702459;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(112, 36, 89, 0));\n}\n\n.to-transparent {\n  --gradient-to-color: transparent;\n}\n\n.to-current {\n  --gradient-to-color: currentColor;\n}\n\n.to-black {\n  --gradient-to-color: #000;\n}\n\n.to-white {\n  --gradient-to-color: #fff;\n}\n\n.to-gray-100 {\n  --gradient-to-color: #f7fafc;\n}\n\n.to-gray-200 {\n  --gradient-to-color: #edf2f7;\n}\n\n.to-gray-300 {\n  --gradient-to-color: #e2e8f0;\n}\n\n.to-gray-400 {\n  --gradient-to-color: #cbd5e0;\n}\n\n.to-gray-500 {\n  --gradient-to-color: #a0aec0;\n}\n\n.to-gray-600 {\n  --gradient-to-color: #718096;\n}\n\n.to-gray-700 {\n  --gradient-to-color: #4a5568;\n}\n\n.to-gray-800 {\n  --gradient-to-color: #2d3748;\n}\n\n.to-gray-900 {\n  --gradient-to-color: #1a202c;\n}\n\n.to-red-100 {\n  --gradient-to-color: #fff5f5;\n}\n\n.to-red-200 {\n  --gradient-to-color: #fed7d7;\n}\n\n.to-red-300 {\n  --gradient-to-color: #feb2b2;\n}\n\n.to-red-400 {\n  --gradient-to-color: #fc8181;\n}\n\n.to-red-500 {\n  --gradient-to-color: #f56565;\n}\n\n.to-red-600 {\n  --gradient-to-color: #e53e3e;\n}\n\n.to-red-700 {\n  --gradient-to-color: #c53030;\n}\n\n.to-red-800 {\n  --gradient-to-color: #9b2c2c;\n}\n\n.to-red-900 {\n  --gradient-to-color: #742a2a;\n}\n\n.to-orange-100 {\n  --gradient-to-color: #fffaf0;\n}\n\n.to-orange-200 {\n  --gradient-to-color: #feebc8;\n}\n\n.to-orange-300 {\n  --gradient-to-color: #fbd38d;\n}\n\n.to-orange-400 {\n  --gradient-to-color: #f6ad55;\n}\n\n.to-orange-500 {\n  --gradient-to-color: #ed8936;\n}\n\n.to-orange-600 {\n  --gradient-to-color: #dd6b20;\n}\n\n.to-orange-700 {\n  --gradient-to-color: #c05621;\n}\n\n.to-orange-800 {\n  --gradient-to-color: #9c4221;\n}\n\n.to-orange-900 {\n  --gradient-to-color: #7b341e;\n}\n\n.to-yellow-100 {\n  --gradient-to-color: #fffff0;\n}\n\n.to-yellow-200 {\n  --gradient-to-color: #fefcbf;\n}\n\n.to-yellow-300 {\n  --gradient-to-color: #faf089;\n}\n\n.to-yellow-400 {\n  --gradient-to-color: #f6e05e;\n}\n\n.to-yellow-500 {\n  --gradient-to-color: #ecc94b;\n}\n\n.to-yellow-600 {\n  --gradient-to-color: #d69e2e;\n}\n\n.to-yellow-700 {\n  --gradient-to-color: #b7791f;\n}\n\n.to-yellow-800 {\n  --gradient-to-color: #975a16;\n}\n\n.to-yellow-900 {\n  --gradient-to-color: #744210;\n}\n\n.to-green-100 {\n  --gradient-to-color: #f0fff4;\n}\n\n.to-green-200 {\n  --gradient-to-color: #c6f6d5;\n}\n\n.to-green-300 {\n  --gradient-to-color: #9ae6b4;\n}\n\n.to-green-400 {\n  --gradient-to-color: #68d391;\n}\n\n.to-green-500 {\n  --gradient-to-color: #48bb78;\n}\n\n.to-green-600 {\n  --gradient-to-color: #38a169;\n}\n\n.to-green-700 {\n  --gradient-to-color: #2f855a;\n}\n\n.to-green-800 {\n  --gradient-to-color: #276749;\n}\n\n.to-green-900 {\n  --gradient-to-color: #22543d;\n}\n\n.to-teal-100 {\n  --gradient-to-color: #e6fffa;\n}\n\n.to-teal-200 {\n  --gradient-to-color: #b2f5ea;\n}\n\n.to-teal-300 {\n  --gradient-to-color: #81e6d9;\n}\n\n.to-teal-400 {\n  --gradient-to-color: #4fd1c5;\n}\n\n.to-teal-500 {\n  --gradient-to-color: #38b2ac;\n}\n\n.to-teal-600 {\n  --gradient-to-color: #319795;\n}\n\n.to-teal-700 {\n  --gradient-to-color: #2c7a7b;\n}\n\n.to-teal-800 {\n  --gradient-to-color: #285e61;\n}\n\n.to-teal-900 {\n  --gradient-to-color: #234e52;\n}\n\n.to-blue-100 {\n  --gradient-to-color: #ebf8ff;\n}\n\n.to-blue-200 {\n  --gradient-to-color: #bee3f8;\n}\n\n.to-blue-300 {\n  --gradient-to-color: #90cdf4;\n}\n\n.to-blue-400 {\n  --gradient-to-color: #63b3ed;\n}\n\n.to-blue-500 {\n  --gradient-to-color: #4299e1;\n}\n\n.to-blue-600 {\n  --gradient-to-color: #3182ce;\n}\n\n.to-blue-700 {\n  --gradient-to-color: #2b6cb0;\n}\n\n.to-blue-800 {\n  --gradient-to-color: #2c5282;\n}\n\n.to-blue-900 {\n  --gradient-to-color: #2a4365;\n}\n\n.to-indigo-100 {\n  --gradient-to-color: #ebf4ff;\n}\n\n.to-indigo-200 {\n  --gradient-to-color: #c3dafe;\n}\n\n.to-indigo-300 {\n  --gradient-to-color: #a3bffa;\n}\n\n.to-indigo-400 {\n  --gradient-to-color: #7f9cf5;\n}\n\n.to-indigo-500 {\n  --gradient-to-color: #667eea;\n}\n\n.to-indigo-600 {\n  --gradient-to-color: #5a67d8;\n}\n\n.to-indigo-700 {\n  --gradient-to-color: #4c51bf;\n}\n\n.to-indigo-800 {\n  --gradient-to-color: #434190;\n}\n\n.to-indigo-900 {\n  --gradient-to-color: #3c366b;\n}\n\n.to-purple-100 {\n  --gradient-to-color: #faf5ff;\n}\n\n.to-purple-200 {\n  --gradient-to-color: #e9d8fd;\n}\n\n.to-purple-300 {\n  --gradient-to-color: #d6bcfa;\n}\n\n.to-purple-400 {\n  --gradient-to-color: #b794f4;\n}\n\n.to-purple-500 {\n  --gradient-to-color: #9f7aea;\n}\n\n.to-purple-600 {\n  --gradient-to-color: #805ad5;\n}\n\n.to-purple-700 {\n  --gradient-to-color: #6b46c1;\n}\n\n.to-purple-800 {\n  --gradient-to-color: #553c9a;\n}\n\n.to-purple-900 {\n  --gradient-to-color: #44337a;\n}\n\n.to-pink-100 {\n  --gradient-to-color: #fff5f7;\n}\n\n.to-pink-200 {\n  --gradient-to-color: #fed7e2;\n}\n\n.to-pink-300 {\n  --gradient-to-color: #fbb6ce;\n}\n\n.to-pink-400 {\n  --gradient-to-color: #f687b3;\n}\n\n.to-pink-500 {\n  --gradient-to-color: #ed64a6;\n}\n\n.to-pink-600 {\n  --gradient-to-color: #d53f8c;\n}\n\n.to-pink-700 {\n  --gradient-to-color: #b83280;\n}\n\n.to-pink-800 {\n  --gradient-to-color: #97266d;\n}\n\n.to-pink-900 {\n  --gradient-to-color: #702459;\n}\n\n.hover\\:from-transparent:hover {\n  --gradient-from-color: transparent;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(0, 0, 0, 0));\n}\n\n.hover\\:from-current:hover {\n  --gradient-from-color: currentColor;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(255, 255, 255, 0));\n}\n\n.hover\\:from-black:hover {\n  --gradient-from-color: #000;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(0, 0, 0, 0));\n}\n\n.hover\\:from-white:hover {\n  --gradient-from-color: #fff;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(255, 255, 255, 0));\n}\n\n.hover\\:from-gray-100:hover {\n  --gradient-from-color: #f7fafc;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(247, 250, 252, 0));\n}\n\n.hover\\:from-gray-200:hover {\n  --gradient-from-color: #edf2f7;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(237, 242, 247, 0));\n}\n\n.hover\\:from-gray-300:hover {\n  --gradient-from-color: #e2e8f0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(226, 232, 240, 0));\n}\n\n.hover\\:from-gray-400:hover {\n  --gradient-from-color: #cbd5e0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(203, 213, 224, 0));\n}\n\n.hover\\:from-gray-500:hover {\n  --gradient-from-color: #a0aec0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(160, 174, 192, 0));\n}\n\n.hover\\:from-gray-600:hover {\n  --gradient-from-color: #718096;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(113, 128, 150, 0));\n}\n\n.hover\\:from-gray-700:hover {\n  --gradient-from-color: #4a5568;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(74, 85, 104, 0));\n}\n\n.hover\\:from-gray-800:hover {\n  --gradient-from-color: #2d3748;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(45, 55, 72, 0));\n}\n\n.hover\\:from-gray-900:hover {\n  --gradient-from-color: #1a202c;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(26, 32, 44, 0));\n}\n\n.hover\\:from-red-100:hover {\n  --gradient-from-color: #fff5f5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(255, 245, 245, 0));\n}\n\n.hover\\:from-red-200:hover {\n  --gradient-from-color: #fed7d7;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(254, 215, 215, 0));\n}\n\n.hover\\:from-red-300:hover {\n  --gradient-from-color: #feb2b2;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(254, 178, 178, 0));\n}\n\n.hover\\:from-red-400:hover {\n  --gradient-from-color: #fc8181;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(252, 129, 129, 0));\n}\n\n.hover\\:from-red-500:hover {\n  --gradient-from-color: #f56565;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(245, 101, 101, 0));\n}\n\n.hover\\:from-red-600:hover {\n  --gradient-from-color: #e53e3e;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(229, 62, 62, 0));\n}\n\n.hover\\:from-red-700:hover {\n  --gradient-from-color: #c53030;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(197, 48, 48, 0));\n}\n\n.hover\\:from-red-800:hover {\n  --gradient-from-color: #9b2c2c;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(155, 44, 44, 0));\n}\n\n.hover\\:from-red-900:hover {\n  --gradient-from-color: #742a2a;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(116, 42, 42, 0));\n}\n\n.hover\\:from-orange-100:hover {\n  --gradient-from-color: #fffaf0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(255, 250, 240, 0));\n}\n\n.hover\\:from-orange-200:hover {\n  --gradient-from-color: #feebc8;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(254, 235, 200, 0));\n}\n\n.hover\\:from-orange-300:hover {\n  --gradient-from-color: #fbd38d;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(251, 211, 141, 0));\n}\n\n.hover\\:from-orange-400:hover {\n  --gradient-from-color: #f6ad55;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(246, 173, 85, 0));\n}\n\n.hover\\:from-orange-500:hover {\n  --gradient-from-color: #ed8936;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(237, 137, 54, 0));\n}\n\n.hover\\:from-orange-600:hover {\n  --gradient-from-color: #dd6b20;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(221, 107, 32, 0));\n}\n\n.hover\\:from-orange-700:hover {\n  --gradient-from-color: #c05621;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(192, 86, 33, 0));\n}\n\n.hover\\:from-orange-800:hover {\n  --gradient-from-color: #9c4221;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(156, 66, 33, 0));\n}\n\n.hover\\:from-orange-900:hover {\n  --gradient-from-color: #7b341e;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(123, 52, 30, 0));\n}\n\n.hover\\:from-yellow-100:hover {\n  --gradient-from-color: #fffff0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(255, 255, 240, 0));\n}\n\n.hover\\:from-yellow-200:hover {\n  --gradient-from-color: #fefcbf;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(254, 252, 191, 0));\n}\n\n.hover\\:from-yellow-300:hover {\n  --gradient-from-color: #faf089;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(250, 240, 137, 0));\n}\n\n.hover\\:from-yellow-400:hover {\n  --gradient-from-color: #f6e05e;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(246, 224, 94, 0));\n}\n\n.hover\\:from-yellow-500:hover {\n  --gradient-from-color: #ecc94b;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(236, 201, 75, 0));\n}\n\n.hover\\:from-yellow-600:hover {\n  --gradient-from-color: #d69e2e;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(214, 158, 46, 0));\n}\n\n.hover\\:from-yellow-700:hover {\n  --gradient-from-color: #b7791f;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(183, 121, 31, 0));\n}\n\n.hover\\:from-yellow-800:hover {\n  --gradient-from-color: #975a16;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(151, 90, 22, 0));\n}\n\n.hover\\:from-yellow-900:hover {\n  --gradient-from-color: #744210;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(116, 66, 16, 0));\n}\n\n.hover\\:from-green-100:hover {\n  --gradient-from-color: #f0fff4;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(240, 255, 244, 0));\n}\n\n.hover\\:from-green-200:hover {\n  --gradient-from-color: #c6f6d5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(198, 246, 213, 0));\n}\n\n.hover\\:from-green-300:hover {\n  --gradient-from-color: #9ae6b4;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(154, 230, 180, 0));\n}\n\n.hover\\:from-green-400:hover {\n  --gradient-from-color: #68d391;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(104, 211, 145, 0));\n}\n\n.hover\\:from-green-500:hover {\n  --gradient-from-color: #48bb78;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(72, 187, 120, 0));\n}\n\n.hover\\:from-green-600:hover {\n  --gradient-from-color: #38a169;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(56, 161, 105, 0));\n}\n\n.hover\\:from-green-700:hover {\n  --gradient-from-color: #2f855a;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(47, 133, 90, 0));\n}\n\n.hover\\:from-green-800:hover {\n  --gradient-from-color: #276749;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(39, 103, 73, 0));\n}\n\n.hover\\:from-green-900:hover {\n  --gradient-from-color: #22543d;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(34, 84, 61, 0));\n}\n\n.hover\\:from-teal-100:hover {\n  --gradient-from-color: #e6fffa;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(230, 255, 250, 0));\n}\n\n.hover\\:from-teal-200:hover {\n  --gradient-from-color: #b2f5ea;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(178, 245, 234, 0));\n}\n\n.hover\\:from-teal-300:hover {\n  --gradient-from-color: #81e6d9;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(129, 230, 217, 0));\n}\n\n.hover\\:from-teal-400:hover {\n  --gradient-from-color: #4fd1c5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(79, 209, 197, 0));\n}\n\n.hover\\:from-teal-500:hover {\n  --gradient-from-color: #38b2ac;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(56, 178, 172, 0));\n}\n\n.hover\\:from-teal-600:hover {\n  --gradient-from-color: #319795;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(49, 151, 149, 0));\n}\n\n.hover\\:from-teal-700:hover {\n  --gradient-from-color: #2c7a7b;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(44, 122, 123, 0));\n}\n\n.hover\\:from-teal-800:hover {\n  --gradient-from-color: #285e61;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(40, 94, 97, 0));\n}\n\n.hover\\:from-teal-900:hover {\n  --gradient-from-color: #234e52;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(35, 78, 82, 0));\n}\n\n.hover\\:from-blue-100:hover {\n  --gradient-from-color: #ebf8ff;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(235, 248, 255, 0));\n}\n\n.hover\\:from-blue-200:hover {\n  --gradient-from-color: #bee3f8;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(190, 227, 248, 0));\n}\n\n.hover\\:from-blue-300:hover {\n  --gradient-from-color: #90cdf4;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(144, 205, 244, 0));\n}\n\n.hover\\:from-blue-400:hover {\n  --gradient-from-color: #63b3ed;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(99, 179, 237, 0));\n}\n\n.hover\\:from-blue-500:hover {\n  --gradient-from-color: #4299e1;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(66, 153, 225, 0));\n}\n\n.hover\\:from-blue-600:hover {\n  --gradient-from-color: #3182ce;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(49, 130, 206, 0));\n}\n\n.hover\\:from-blue-700:hover {\n  --gradient-from-color: #2b6cb0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(43, 108, 176, 0));\n}\n\n.hover\\:from-blue-800:hover {\n  --gradient-from-color: #2c5282;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(44, 82, 130, 0));\n}\n\n.hover\\:from-blue-900:hover {\n  --gradient-from-color: #2a4365;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(42, 67, 101, 0));\n}\n\n.hover\\:from-indigo-100:hover {\n  --gradient-from-color: #ebf4ff;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(235, 244, 255, 0));\n}\n\n.hover\\:from-indigo-200:hover {\n  --gradient-from-color: #c3dafe;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(195, 218, 254, 0));\n}\n\n.hover\\:from-indigo-300:hover {\n  --gradient-from-color: #a3bffa;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(163, 191, 250, 0));\n}\n\n.hover\\:from-indigo-400:hover {\n  --gradient-from-color: #7f9cf5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(127, 156, 245, 0));\n}\n\n.hover\\:from-indigo-500:hover {\n  --gradient-from-color: #667eea;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(102, 126, 234, 0));\n}\n\n.hover\\:from-indigo-600:hover {\n  --gradient-from-color: #5a67d8;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(90, 103, 216, 0));\n}\n\n.hover\\:from-indigo-700:hover {\n  --gradient-from-color: #4c51bf;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(76, 81, 191, 0));\n}\n\n.hover\\:from-indigo-800:hover {\n  --gradient-from-color: #434190;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(67, 65, 144, 0));\n}\n\n.hover\\:from-indigo-900:hover {\n  --gradient-from-color: #3c366b;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(60, 54, 107, 0));\n}\n\n.hover\\:from-purple-100:hover {\n  --gradient-from-color: #faf5ff;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(250, 245, 255, 0));\n}\n\n.hover\\:from-purple-200:hover {\n  --gradient-from-color: #e9d8fd;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(233, 216, 253, 0));\n}\n\n.hover\\:from-purple-300:hover {\n  --gradient-from-color: #d6bcfa;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(214, 188, 250, 0));\n}\n\n.hover\\:from-purple-400:hover {\n  --gradient-from-color: #b794f4;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(183, 148, 244, 0));\n}\n\n.hover\\:from-purple-500:hover {\n  --gradient-from-color: #9f7aea;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(159, 122, 234, 0));\n}\n\n.hover\\:from-purple-600:hover {\n  --gradient-from-color: #805ad5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(128, 90, 213, 0));\n}\n\n.hover\\:from-purple-700:hover {\n  --gradient-from-color: #6b46c1;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(107, 70, 193, 0));\n}\n\n.hover\\:from-purple-800:hover {\n  --gradient-from-color: #553c9a;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(85, 60, 154, 0));\n}\n\n.hover\\:from-purple-900:hover {\n  --gradient-from-color: #44337a;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(68, 51, 122, 0));\n}\n\n.hover\\:from-pink-100:hover {\n  --gradient-from-color: #fff5f7;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(255, 245, 247, 0));\n}\n\n.hover\\:from-pink-200:hover {\n  --gradient-from-color: #fed7e2;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(254, 215, 226, 0));\n}\n\n.hover\\:from-pink-300:hover {\n  --gradient-from-color: #fbb6ce;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(251, 182, 206, 0));\n}\n\n.hover\\:from-pink-400:hover {\n  --gradient-from-color: #f687b3;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(246, 135, 179, 0));\n}\n\n.hover\\:from-pink-500:hover {\n  --gradient-from-color: #ed64a6;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(237, 100, 166, 0));\n}\n\n.hover\\:from-pink-600:hover {\n  --gradient-from-color: #d53f8c;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(213, 63, 140, 0));\n}\n\n.hover\\:from-pink-700:hover {\n  --gradient-from-color: #b83280;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(184, 50, 128, 0));\n}\n\n.hover\\:from-pink-800:hover {\n  --gradient-from-color: #97266d;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(151, 38, 109, 0));\n}\n\n.hover\\:from-pink-900:hover {\n  --gradient-from-color: #702459;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(112, 36, 89, 0));\n}\n\n.hover\\:via-transparent:hover {\n  --gradient-via-color: transparent;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(0, 0, 0, 0));\n}\n\n.hover\\:via-current:hover {\n  --gradient-via-color: currentColor;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(255, 255, 255, 0));\n}\n\n.hover\\:via-black:hover {\n  --gradient-via-color: #000;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(0, 0, 0, 0));\n}\n\n.hover\\:via-white:hover {\n  --gradient-via-color: #fff;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(255, 255, 255, 0));\n}\n\n.hover\\:via-gray-100:hover {\n  --gradient-via-color: #f7fafc;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(247, 250, 252, 0));\n}\n\n.hover\\:via-gray-200:hover {\n  --gradient-via-color: #edf2f7;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(237, 242, 247, 0));\n}\n\n.hover\\:via-gray-300:hover {\n  --gradient-via-color: #e2e8f0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(226, 232, 240, 0));\n}\n\n.hover\\:via-gray-400:hover {\n  --gradient-via-color: #cbd5e0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(203, 213, 224, 0));\n}\n\n.hover\\:via-gray-500:hover {\n  --gradient-via-color: #a0aec0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(160, 174, 192, 0));\n}\n\n.hover\\:via-gray-600:hover {\n  --gradient-via-color: #718096;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(113, 128, 150, 0));\n}\n\n.hover\\:via-gray-700:hover {\n  --gradient-via-color: #4a5568;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(74, 85, 104, 0));\n}\n\n.hover\\:via-gray-800:hover {\n  --gradient-via-color: #2d3748;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(45, 55, 72, 0));\n}\n\n.hover\\:via-gray-900:hover {\n  --gradient-via-color: #1a202c;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(26, 32, 44, 0));\n}\n\n.hover\\:via-red-100:hover {\n  --gradient-via-color: #fff5f5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(255, 245, 245, 0));\n}\n\n.hover\\:via-red-200:hover {\n  --gradient-via-color: #fed7d7;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(254, 215, 215, 0));\n}\n\n.hover\\:via-red-300:hover {\n  --gradient-via-color: #feb2b2;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(254, 178, 178, 0));\n}\n\n.hover\\:via-red-400:hover {\n  --gradient-via-color: #fc8181;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(252, 129, 129, 0));\n}\n\n.hover\\:via-red-500:hover {\n  --gradient-via-color: #f56565;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(245, 101, 101, 0));\n}\n\n.hover\\:via-red-600:hover {\n  --gradient-via-color: #e53e3e;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(229, 62, 62, 0));\n}\n\n.hover\\:via-red-700:hover {\n  --gradient-via-color: #c53030;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(197, 48, 48, 0));\n}\n\n.hover\\:via-red-800:hover {\n  --gradient-via-color: #9b2c2c;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(155, 44, 44, 0));\n}\n\n.hover\\:via-red-900:hover {\n  --gradient-via-color: #742a2a;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(116, 42, 42, 0));\n}\n\n.hover\\:via-orange-100:hover {\n  --gradient-via-color: #fffaf0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(255, 250, 240, 0));\n}\n\n.hover\\:via-orange-200:hover {\n  --gradient-via-color: #feebc8;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(254, 235, 200, 0));\n}\n\n.hover\\:via-orange-300:hover {\n  --gradient-via-color: #fbd38d;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(251, 211, 141, 0));\n}\n\n.hover\\:via-orange-400:hover {\n  --gradient-via-color: #f6ad55;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(246, 173, 85, 0));\n}\n\n.hover\\:via-orange-500:hover {\n  --gradient-via-color: #ed8936;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(237, 137, 54, 0));\n}\n\n.hover\\:via-orange-600:hover {\n  --gradient-via-color: #dd6b20;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(221, 107, 32, 0));\n}\n\n.hover\\:via-orange-700:hover {\n  --gradient-via-color: #c05621;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(192, 86, 33, 0));\n}\n\n.hover\\:via-orange-800:hover {\n  --gradient-via-color: #9c4221;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(156, 66, 33, 0));\n}\n\n.hover\\:via-orange-900:hover {\n  --gradient-via-color: #7b341e;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(123, 52, 30, 0));\n}\n\n.hover\\:via-yellow-100:hover {\n  --gradient-via-color: #fffff0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(255, 255, 240, 0));\n}\n\n.hover\\:via-yellow-200:hover {\n  --gradient-via-color: #fefcbf;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(254, 252, 191, 0));\n}\n\n.hover\\:via-yellow-300:hover {\n  --gradient-via-color: #faf089;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(250, 240, 137, 0));\n}\n\n.hover\\:via-yellow-400:hover {\n  --gradient-via-color: #f6e05e;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(246, 224, 94, 0));\n}\n\n.hover\\:via-yellow-500:hover {\n  --gradient-via-color: #ecc94b;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(236, 201, 75, 0));\n}\n\n.hover\\:via-yellow-600:hover {\n  --gradient-via-color: #d69e2e;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(214, 158, 46, 0));\n}\n\n.hover\\:via-yellow-700:hover {\n  --gradient-via-color: #b7791f;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(183, 121, 31, 0));\n}\n\n.hover\\:via-yellow-800:hover {\n  --gradient-via-color: #975a16;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(151, 90, 22, 0));\n}\n\n.hover\\:via-yellow-900:hover {\n  --gradient-via-color: #744210;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(116, 66, 16, 0));\n}\n\n.hover\\:via-green-100:hover {\n  --gradient-via-color: #f0fff4;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(240, 255, 244, 0));\n}\n\n.hover\\:via-green-200:hover {\n  --gradient-via-color: #c6f6d5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(198, 246, 213, 0));\n}\n\n.hover\\:via-green-300:hover {\n  --gradient-via-color: #9ae6b4;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(154, 230, 180, 0));\n}\n\n.hover\\:via-green-400:hover {\n  --gradient-via-color: #68d391;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(104, 211, 145, 0));\n}\n\n.hover\\:via-green-500:hover {\n  --gradient-via-color: #48bb78;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(72, 187, 120, 0));\n}\n\n.hover\\:via-green-600:hover {\n  --gradient-via-color: #38a169;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(56, 161, 105, 0));\n}\n\n.hover\\:via-green-700:hover {\n  --gradient-via-color: #2f855a;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(47, 133, 90, 0));\n}\n\n.hover\\:via-green-800:hover {\n  --gradient-via-color: #276749;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(39, 103, 73, 0));\n}\n\n.hover\\:via-green-900:hover {\n  --gradient-via-color: #22543d;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(34, 84, 61, 0));\n}\n\n.hover\\:via-teal-100:hover {\n  --gradient-via-color: #e6fffa;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(230, 255, 250, 0));\n}\n\n.hover\\:via-teal-200:hover {\n  --gradient-via-color: #b2f5ea;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(178, 245, 234, 0));\n}\n\n.hover\\:via-teal-300:hover {\n  --gradient-via-color: #81e6d9;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(129, 230, 217, 0));\n}\n\n.hover\\:via-teal-400:hover {\n  --gradient-via-color: #4fd1c5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(79, 209, 197, 0));\n}\n\n.hover\\:via-teal-500:hover {\n  --gradient-via-color: #38b2ac;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(56, 178, 172, 0));\n}\n\n.hover\\:via-teal-600:hover {\n  --gradient-via-color: #319795;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(49, 151, 149, 0));\n}\n\n.hover\\:via-teal-700:hover {\n  --gradient-via-color: #2c7a7b;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(44, 122, 123, 0));\n}\n\n.hover\\:via-teal-800:hover {\n  --gradient-via-color: #285e61;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(40, 94, 97, 0));\n}\n\n.hover\\:via-teal-900:hover {\n  --gradient-via-color: #234e52;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(35, 78, 82, 0));\n}\n\n.hover\\:via-blue-100:hover {\n  --gradient-via-color: #ebf8ff;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(235, 248, 255, 0));\n}\n\n.hover\\:via-blue-200:hover {\n  --gradient-via-color: #bee3f8;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(190, 227, 248, 0));\n}\n\n.hover\\:via-blue-300:hover {\n  --gradient-via-color: #90cdf4;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(144, 205, 244, 0));\n}\n\n.hover\\:via-blue-400:hover {\n  --gradient-via-color: #63b3ed;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(99, 179, 237, 0));\n}\n\n.hover\\:via-blue-500:hover {\n  --gradient-via-color: #4299e1;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(66, 153, 225, 0));\n}\n\n.hover\\:via-blue-600:hover {\n  --gradient-via-color: #3182ce;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(49, 130, 206, 0));\n}\n\n.hover\\:via-blue-700:hover {\n  --gradient-via-color: #2b6cb0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(43, 108, 176, 0));\n}\n\n.hover\\:via-blue-800:hover {\n  --gradient-via-color: #2c5282;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(44, 82, 130, 0));\n}\n\n.hover\\:via-blue-900:hover {\n  --gradient-via-color: #2a4365;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(42, 67, 101, 0));\n}\n\n.hover\\:via-indigo-100:hover {\n  --gradient-via-color: #ebf4ff;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(235, 244, 255, 0));\n}\n\n.hover\\:via-indigo-200:hover {\n  --gradient-via-color: #c3dafe;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(195, 218, 254, 0));\n}\n\n.hover\\:via-indigo-300:hover {\n  --gradient-via-color: #a3bffa;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(163, 191, 250, 0));\n}\n\n.hover\\:via-indigo-400:hover {\n  --gradient-via-color: #7f9cf5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(127, 156, 245, 0));\n}\n\n.hover\\:via-indigo-500:hover {\n  --gradient-via-color: #667eea;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(102, 126, 234, 0));\n}\n\n.hover\\:via-indigo-600:hover {\n  --gradient-via-color: #5a67d8;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(90, 103, 216, 0));\n}\n\n.hover\\:via-indigo-700:hover {\n  --gradient-via-color: #4c51bf;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(76, 81, 191, 0));\n}\n\n.hover\\:via-indigo-800:hover {\n  --gradient-via-color: #434190;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(67, 65, 144, 0));\n}\n\n.hover\\:via-indigo-900:hover {\n  --gradient-via-color: #3c366b;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(60, 54, 107, 0));\n}\n\n.hover\\:via-purple-100:hover {\n  --gradient-via-color: #faf5ff;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(250, 245, 255, 0));\n}\n\n.hover\\:via-purple-200:hover {\n  --gradient-via-color: #e9d8fd;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(233, 216, 253, 0));\n}\n\n.hover\\:via-purple-300:hover {\n  --gradient-via-color: #d6bcfa;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(214, 188, 250, 0));\n}\n\n.hover\\:via-purple-400:hover {\n  --gradient-via-color: #b794f4;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(183, 148, 244, 0));\n}\n\n.hover\\:via-purple-500:hover {\n  --gradient-via-color: #9f7aea;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(159, 122, 234, 0));\n}\n\n.hover\\:via-purple-600:hover {\n  --gradient-via-color: #805ad5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(128, 90, 213, 0));\n}\n\n.hover\\:via-purple-700:hover {\n  --gradient-via-color: #6b46c1;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(107, 70, 193, 0));\n}\n\n.hover\\:via-purple-800:hover {\n  --gradient-via-color: #553c9a;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(85, 60, 154, 0));\n}\n\n.hover\\:via-purple-900:hover {\n  --gradient-via-color: #44337a;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(68, 51, 122, 0));\n}\n\n.hover\\:via-pink-100:hover {\n  --gradient-via-color: #fff5f7;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(255, 245, 247, 0));\n}\n\n.hover\\:via-pink-200:hover {\n  --gradient-via-color: #fed7e2;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(254, 215, 226, 0));\n}\n\n.hover\\:via-pink-300:hover {\n  --gradient-via-color: #fbb6ce;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(251, 182, 206, 0));\n}\n\n.hover\\:via-pink-400:hover {\n  --gradient-via-color: #f687b3;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(246, 135, 179, 0));\n}\n\n.hover\\:via-pink-500:hover {\n  --gradient-via-color: #ed64a6;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(237, 100, 166, 0));\n}\n\n.hover\\:via-pink-600:hover {\n  --gradient-via-color: #d53f8c;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(213, 63, 140, 0));\n}\n\n.hover\\:via-pink-700:hover {\n  --gradient-via-color: #b83280;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(184, 50, 128, 0));\n}\n\n.hover\\:via-pink-800:hover {\n  --gradient-via-color: #97266d;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(151, 38, 109, 0));\n}\n\n.hover\\:via-pink-900:hover {\n  --gradient-via-color: #702459;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(112, 36, 89, 0));\n}\n\n.hover\\:to-transparent:hover {\n  --gradient-to-color: transparent;\n}\n\n.hover\\:to-current:hover {\n  --gradient-to-color: currentColor;\n}\n\n.hover\\:to-black:hover {\n  --gradient-to-color: #000;\n}\n\n.hover\\:to-white:hover {\n  --gradient-to-color: #fff;\n}\n\n.hover\\:to-gray-100:hover {\n  --gradient-to-color: #f7fafc;\n}\n\n.hover\\:to-gray-200:hover {\n  --gradient-to-color: #edf2f7;\n}\n\n.hover\\:to-gray-300:hover {\n  --gradient-to-color: #e2e8f0;\n}\n\n.hover\\:to-gray-400:hover {\n  --gradient-to-color: #cbd5e0;\n}\n\n.hover\\:to-gray-500:hover {\n  --gradient-to-color: #a0aec0;\n}\n\n.hover\\:to-gray-600:hover {\n  --gradient-to-color: #718096;\n}\n\n.hover\\:to-gray-700:hover {\n  --gradient-to-color: #4a5568;\n}\n\n.hover\\:to-gray-800:hover {\n  --gradient-to-color: #2d3748;\n}\n\n.hover\\:to-gray-900:hover {\n  --gradient-to-color: #1a202c;\n}\n\n.hover\\:to-red-100:hover {\n  --gradient-to-color: #fff5f5;\n}\n\n.hover\\:to-red-200:hover {\n  --gradient-to-color: #fed7d7;\n}\n\n.hover\\:to-red-300:hover {\n  --gradient-to-color: #feb2b2;\n}\n\n.hover\\:to-red-400:hover {\n  --gradient-to-color: #fc8181;\n}\n\n.hover\\:to-red-500:hover {\n  --gradient-to-color: #f56565;\n}\n\n.hover\\:to-red-600:hover {\n  --gradient-to-color: #e53e3e;\n}\n\n.hover\\:to-red-700:hover {\n  --gradient-to-color: #c53030;\n}\n\n.hover\\:to-red-800:hover {\n  --gradient-to-color: #9b2c2c;\n}\n\n.hover\\:to-red-900:hover {\n  --gradient-to-color: #742a2a;\n}\n\n.hover\\:to-orange-100:hover {\n  --gradient-to-color: #fffaf0;\n}\n\n.hover\\:to-orange-200:hover {\n  --gradient-to-color: #feebc8;\n}\n\n.hover\\:to-orange-300:hover {\n  --gradient-to-color: #fbd38d;\n}\n\n.hover\\:to-orange-400:hover {\n  --gradient-to-color: #f6ad55;\n}\n\n.hover\\:to-orange-500:hover {\n  --gradient-to-color: #ed8936;\n}\n\n.hover\\:to-orange-600:hover {\n  --gradient-to-color: #dd6b20;\n}\n\n.hover\\:to-orange-700:hover {\n  --gradient-to-color: #c05621;\n}\n\n.hover\\:to-orange-800:hover {\n  --gradient-to-color: #9c4221;\n}\n\n.hover\\:to-orange-900:hover {\n  --gradient-to-color: #7b341e;\n}\n\n.hover\\:to-yellow-100:hover {\n  --gradient-to-color: #fffff0;\n}\n\n.hover\\:to-yellow-200:hover {\n  --gradient-to-color: #fefcbf;\n}\n\n.hover\\:to-yellow-300:hover {\n  --gradient-to-color: #faf089;\n}\n\n.hover\\:to-yellow-400:hover {\n  --gradient-to-color: #f6e05e;\n}\n\n.hover\\:to-yellow-500:hover {\n  --gradient-to-color: #ecc94b;\n}\n\n.hover\\:to-yellow-600:hover {\n  --gradient-to-color: #d69e2e;\n}\n\n.hover\\:to-yellow-700:hover {\n  --gradient-to-color: #b7791f;\n}\n\n.hover\\:to-yellow-800:hover {\n  --gradient-to-color: #975a16;\n}\n\n.hover\\:to-yellow-900:hover {\n  --gradient-to-color: #744210;\n}\n\n.hover\\:to-green-100:hover {\n  --gradient-to-color: #f0fff4;\n}\n\n.hover\\:to-green-200:hover {\n  --gradient-to-color: #c6f6d5;\n}\n\n.hover\\:to-green-300:hover {\n  --gradient-to-color: #9ae6b4;\n}\n\n.hover\\:to-green-400:hover {\n  --gradient-to-color: #68d391;\n}\n\n.hover\\:to-green-500:hover {\n  --gradient-to-color: #48bb78;\n}\n\n.hover\\:to-green-600:hover {\n  --gradient-to-color: #38a169;\n}\n\n.hover\\:to-green-700:hover {\n  --gradient-to-color: #2f855a;\n}\n\n.hover\\:to-green-800:hover {\n  --gradient-to-color: #276749;\n}\n\n.hover\\:to-green-900:hover {\n  --gradient-to-color: #22543d;\n}\n\n.hover\\:to-teal-100:hover {\n  --gradient-to-color: #e6fffa;\n}\n\n.hover\\:to-teal-200:hover {\n  --gradient-to-color: #b2f5ea;\n}\n\n.hover\\:to-teal-300:hover {\n  --gradient-to-color: #81e6d9;\n}\n\n.hover\\:to-teal-400:hover {\n  --gradient-to-color: #4fd1c5;\n}\n\n.hover\\:to-teal-500:hover {\n  --gradient-to-color: #38b2ac;\n}\n\n.hover\\:to-teal-600:hover {\n  --gradient-to-color: #319795;\n}\n\n.hover\\:to-teal-700:hover {\n  --gradient-to-color: #2c7a7b;\n}\n\n.hover\\:to-teal-800:hover {\n  --gradient-to-color: #285e61;\n}\n\n.hover\\:to-teal-900:hover {\n  --gradient-to-color: #234e52;\n}\n\n.hover\\:to-blue-100:hover {\n  --gradient-to-color: #ebf8ff;\n}\n\n.hover\\:to-blue-200:hover {\n  --gradient-to-color: #bee3f8;\n}\n\n.hover\\:to-blue-300:hover {\n  --gradient-to-color: #90cdf4;\n}\n\n.hover\\:to-blue-400:hover {\n  --gradient-to-color: #63b3ed;\n}\n\n.hover\\:to-blue-500:hover {\n  --gradient-to-color: #4299e1;\n}\n\n.hover\\:to-blue-600:hover {\n  --gradient-to-color: #3182ce;\n}\n\n.hover\\:to-blue-700:hover {\n  --gradient-to-color: #2b6cb0;\n}\n\n.hover\\:to-blue-800:hover {\n  --gradient-to-color: #2c5282;\n}\n\n.hover\\:to-blue-900:hover {\n  --gradient-to-color: #2a4365;\n}\n\n.hover\\:to-indigo-100:hover {\n  --gradient-to-color: #ebf4ff;\n}\n\n.hover\\:to-indigo-200:hover {\n  --gradient-to-color: #c3dafe;\n}\n\n.hover\\:to-indigo-300:hover {\n  --gradient-to-color: #a3bffa;\n}\n\n.hover\\:to-indigo-400:hover {\n  --gradient-to-color: #7f9cf5;\n}\n\n.hover\\:to-indigo-500:hover {\n  --gradient-to-color: #667eea;\n}\n\n.hover\\:to-indigo-600:hover {\n  --gradient-to-color: #5a67d8;\n}\n\n.hover\\:to-indigo-700:hover {\n  --gradient-to-color: #4c51bf;\n}\n\n.hover\\:to-indigo-800:hover {\n  --gradient-to-color: #434190;\n}\n\n.hover\\:to-indigo-900:hover {\n  --gradient-to-color: #3c366b;\n}\n\n.hover\\:to-purple-100:hover {\n  --gradient-to-color: #faf5ff;\n}\n\n.hover\\:to-purple-200:hover {\n  --gradient-to-color: #e9d8fd;\n}\n\n.hover\\:to-purple-300:hover {\n  --gradient-to-color: #d6bcfa;\n}\n\n.hover\\:to-purple-400:hover {\n  --gradient-to-color: #b794f4;\n}\n\n.hover\\:to-purple-500:hover {\n  --gradient-to-color: #9f7aea;\n}\n\n.hover\\:to-purple-600:hover {\n  --gradient-to-color: #805ad5;\n}\n\n.hover\\:to-purple-700:hover {\n  --gradient-to-color: #6b46c1;\n}\n\n.hover\\:to-purple-800:hover {\n  --gradient-to-color: #553c9a;\n}\n\n.hover\\:to-purple-900:hover {\n  --gradient-to-color: #44337a;\n}\n\n.hover\\:to-pink-100:hover {\n  --gradient-to-color: #fff5f7;\n}\n\n.hover\\:to-pink-200:hover {\n  --gradient-to-color: #fed7e2;\n}\n\n.hover\\:to-pink-300:hover {\n  --gradient-to-color: #fbb6ce;\n}\n\n.hover\\:to-pink-400:hover {\n  --gradient-to-color: #f687b3;\n}\n\n.hover\\:to-pink-500:hover {\n  --gradient-to-color: #ed64a6;\n}\n\n.hover\\:to-pink-600:hover {\n  --gradient-to-color: #d53f8c;\n}\n\n.hover\\:to-pink-700:hover {\n  --gradient-to-color: #b83280;\n}\n\n.hover\\:to-pink-800:hover {\n  --gradient-to-color: #97266d;\n}\n\n.hover\\:to-pink-900:hover {\n  --gradient-to-color: #702459;\n}\n\n.focus\\:from-transparent:focus {\n  --gradient-from-color: transparent;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(0, 0, 0, 0));\n}\n\n.focus\\:from-current:focus {\n  --gradient-from-color: currentColor;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(255, 255, 255, 0));\n}\n\n.focus\\:from-black:focus {\n  --gradient-from-color: #000;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(0, 0, 0, 0));\n}\n\n.focus\\:from-white:focus {\n  --gradient-from-color: #fff;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(255, 255, 255, 0));\n}\n\n.focus\\:from-gray-100:focus {\n  --gradient-from-color: #f7fafc;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(247, 250, 252, 0));\n}\n\n.focus\\:from-gray-200:focus {\n  --gradient-from-color: #edf2f7;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(237, 242, 247, 0));\n}\n\n.focus\\:from-gray-300:focus {\n  --gradient-from-color: #e2e8f0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(226, 232, 240, 0));\n}\n\n.focus\\:from-gray-400:focus {\n  --gradient-from-color: #cbd5e0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(203, 213, 224, 0));\n}\n\n.focus\\:from-gray-500:focus {\n  --gradient-from-color: #a0aec0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(160, 174, 192, 0));\n}\n\n.focus\\:from-gray-600:focus {\n  --gradient-from-color: #718096;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(113, 128, 150, 0));\n}\n\n.focus\\:from-gray-700:focus {\n  --gradient-from-color: #4a5568;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(74, 85, 104, 0));\n}\n\n.focus\\:from-gray-800:focus {\n  --gradient-from-color: #2d3748;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(45, 55, 72, 0));\n}\n\n.focus\\:from-gray-900:focus {\n  --gradient-from-color: #1a202c;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(26, 32, 44, 0));\n}\n\n.focus\\:from-red-100:focus {\n  --gradient-from-color: #fff5f5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(255, 245, 245, 0));\n}\n\n.focus\\:from-red-200:focus {\n  --gradient-from-color: #fed7d7;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(254, 215, 215, 0));\n}\n\n.focus\\:from-red-300:focus {\n  --gradient-from-color: #feb2b2;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(254, 178, 178, 0));\n}\n\n.focus\\:from-red-400:focus {\n  --gradient-from-color: #fc8181;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(252, 129, 129, 0));\n}\n\n.focus\\:from-red-500:focus {\n  --gradient-from-color: #f56565;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(245, 101, 101, 0));\n}\n\n.focus\\:from-red-600:focus {\n  --gradient-from-color: #e53e3e;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(229, 62, 62, 0));\n}\n\n.focus\\:from-red-700:focus {\n  --gradient-from-color: #c53030;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(197, 48, 48, 0));\n}\n\n.focus\\:from-red-800:focus {\n  --gradient-from-color: #9b2c2c;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(155, 44, 44, 0));\n}\n\n.focus\\:from-red-900:focus {\n  --gradient-from-color: #742a2a;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(116, 42, 42, 0));\n}\n\n.focus\\:from-orange-100:focus {\n  --gradient-from-color: #fffaf0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(255, 250, 240, 0));\n}\n\n.focus\\:from-orange-200:focus {\n  --gradient-from-color: #feebc8;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(254, 235, 200, 0));\n}\n\n.focus\\:from-orange-300:focus {\n  --gradient-from-color: #fbd38d;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(251, 211, 141, 0));\n}\n\n.focus\\:from-orange-400:focus {\n  --gradient-from-color: #f6ad55;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(246, 173, 85, 0));\n}\n\n.focus\\:from-orange-500:focus {\n  --gradient-from-color: #ed8936;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(237, 137, 54, 0));\n}\n\n.focus\\:from-orange-600:focus {\n  --gradient-from-color: #dd6b20;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(221, 107, 32, 0));\n}\n\n.focus\\:from-orange-700:focus {\n  --gradient-from-color: #c05621;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(192, 86, 33, 0));\n}\n\n.focus\\:from-orange-800:focus {\n  --gradient-from-color: #9c4221;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(156, 66, 33, 0));\n}\n\n.focus\\:from-orange-900:focus {\n  --gradient-from-color: #7b341e;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(123, 52, 30, 0));\n}\n\n.focus\\:from-yellow-100:focus {\n  --gradient-from-color: #fffff0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(255, 255, 240, 0));\n}\n\n.focus\\:from-yellow-200:focus {\n  --gradient-from-color: #fefcbf;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(254, 252, 191, 0));\n}\n\n.focus\\:from-yellow-300:focus {\n  --gradient-from-color: #faf089;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(250, 240, 137, 0));\n}\n\n.focus\\:from-yellow-400:focus {\n  --gradient-from-color: #f6e05e;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(246, 224, 94, 0));\n}\n\n.focus\\:from-yellow-500:focus {\n  --gradient-from-color: #ecc94b;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(236, 201, 75, 0));\n}\n\n.focus\\:from-yellow-600:focus {\n  --gradient-from-color: #d69e2e;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(214, 158, 46, 0));\n}\n\n.focus\\:from-yellow-700:focus {\n  --gradient-from-color: #b7791f;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(183, 121, 31, 0));\n}\n\n.focus\\:from-yellow-800:focus {\n  --gradient-from-color: #975a16;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(151, 90, 22, 0));\n}\n\n.focus\\:from-yellow-900:focus {\n  --gradient-from-color: #744210;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(116, 66, 16, 0));\n}\n\n.focus\\:from-green-100:focus {\n  --gradient-from-color: #f0fff4;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(240, 255, 244, 0));\n}\n\n.focus\\:from-green-200:focus {\n  --gradient-from-color: #c6f6d5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(198, 246, 213, 0));\n}\n\n.focus\\:from-green-300:focus {\n  --gradient-from-color: #9ae6b4;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(154, 230, 180, 0));\n}\n\n.focus\\:from-green-400:focus {\n  --gradient-from-color: #68d391;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(104, 211, 145, 0));\n}\n\n.focus\\:from-green-500:focus {\n  --gradient-from-color: #48bb78;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(72, 187, 120, 0));\n}\n\n.focus\\:from-green-600:focus {\n  --gradient-from-color: #38a169;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(56, 161, 105, 0));\n}\n\n.focus\\:from-green-700:focus {\n  --gradient-from-color: #2f855a;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(47, 133, 90, 0));\n}\n\n.focus\\:from-green-800:focus {\n  --gradient-from-color: #276749;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(39, 103, 73, 0));\n}\n\n.focus\\:from-green-900:focus {\n  --gradient-from-color: #22543d;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(34, 84, 61, 0));\n}\n\n.focus\\:from-teal-100:focus {\n  --gradient-from-color: #e6fffa;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(230, 255, 250, 0));\n}\n\n.focus\\:from-teal-200:focus {\n  --gradient-from-color: #b2f5ea;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(178, 245, 234, 0));\n}\n\n.focus\\:from-teal-300:focus {\n  --gradient-from-color: #81e6d9;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(129, 230, 217, 0));\n}\n\n.focus\\:from-teal-400:focus {\n  --gradient-from-color: #4fd1c5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(79, 209, 197, 0));\n}\n\n.focus\\:from-teal-500:focus {\n  --gradient-from-color: #38b2ac;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(56, 178, 172, 0));\n}\n\n.focus\\:from-teal-600:focus {\n  --gradient-from-color: #319795;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(49, 151, 149, 0));\n}\n\n.focus\\:from-teal-700:focus {\n  --gradient-from-color: #2c7a7b;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(44, 122, 123, 0));\n}\n\n.focus\\:from-teal-800:focus {\n  --gradient-from-color: #285e61;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(40, 94, 97, 0));\n}\n\n.focus\\:from-teal-900:focus {\n  --gradient-from-color: #234e52;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(35, 78, 82, 0));\n}\n\n.focus\\:from-blue-100:focus {\n  --gradient-from-color: #ebf8ff;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(235, 248, 255, 0));\n}\n\n.focus\\:from-blue-200:focus {\n  --gradient-from-color: #bee3f8;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(190, 227, 248, 0));\n}\n\n.focus\\:from-blue-300:focus {\n  --gradient-from-color: #90cdf4;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(144, 205, 244, 0));\n}\n\n.focus\\:from-blue-400:focus {\n  --gradient-from-color: #63b3ed;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(99, 179, 237, 0));\n}\n\n.focus\\:from-blue-500:focus {\n  --gradient-from-color: #4299e1;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(66, 153, 225, 0));\n}\n\n.focus\\:from-blue-600:focus {\n  --gradient-from-color: #3182ce;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(49, 130, 206, 0));\n}\n\n.focus\\:from-blue-700:focus {\n  --gradient-from-color: #2b6cb0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(43, 108, 176, 0));\n}\n\n.focus\\:from-blue-800:focus {\n  --gradient-from-color: #2c5282;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(44, 82, 130, 0));\n}\n\n.focus\\:from-blue-900:focus {\n  --gradient-from-color: #2a4365;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(42, 67, 101, 0));\n}\n\n.focus\\:from-indigo-100:focus {\n  --gradient-from-color: #ebf4ff;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(235, 244, 255, 0));\n}\n\n.focus\\:from-indigo-200:focus {\n  --gradient-from-color: #c3dafe;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(195, 218, 254, 0));\n}\n\n.focus\\:from-indigo-300:focus {\n  --gradient-from-color: #a3bffa;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(163, 191, 250, 0));\n}\n\n.focus\\:from-indigo-400:focus {\n  --gradient-from-color: #7f9cf5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(127, 156, 245, 0));\n}\n\n.focus\\:from-indigo-500:focus {\n  --gradient-from-color: #667eea;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(102, 126, 234, 0));\n}\n\n.focus\\:from-indigo-600:focus {\n  --gradient-from-color: #5a67d8;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(90, 103, 216, 0));\n}\n\n.focus\\:from-indigo-700:focus {\n  --gradient-from-color: #4c51bf;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(76, 81, 191, 0));\n}\n\n.focus\\:from-indigo-800:focus {\n  --gradient-from-color: #434190;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(67, 65, 144, 0));\n}\n\n.focus\\:from-indigo-900:focus {\n  --gradient-from-color: #3c366b;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(60, 54, 107, 0));\n}\n\n.focus\\:from-purple-100:focus {\n  --gradient-from-color: #faf5ff;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(250, 245, 255, 0));\n}\n\n.focus\\:from-purple-200:focus {\n  --gradient-from-color: #e9d8fd;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(233, 216, 253, 0));\n}\n\n.focus\\:from-purple-300:focus {\n  --gradient-from-color: #d6bcfa;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(214, 188, 250, 0));\n}\n\n.focus\\:from-purple-400:focus {\n  --gradient-from-color: #b794f4;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(183, 148, 244, 0));\n}\n\n.focus\\:from-purple-500:focus {\n  --gradient-from-color: #9f7aea;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(159, 122, 234, 0));\n}\n\n.focus\\:from-purple-600:focus {\n  --gradient-from-color: #805ad5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(128, 90, 213, 0));\n}\n\n.focus\\:from-purple-700:focus {\n  --gradient-from-color: #6b46c1;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(107, 70, 193, 0));\n}\n\n.focus\\:from-purple-800:focus {\n  --gradient-from-color: #553c9a;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(85, 60, 154, 0));\n}\n\n.focus\\:from-purple-900:focus {\n  --gradient-from-color: #44337a;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(68, 51, 122, 0));\n}\n\n.focus\\:from-pink-100:focus {\n  --gradient-from-color: #fff5f7;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(255, 245, 247, 0));\n}\n\n.focus\\:from-pink-200:focus {\n  --gradient-from-color: #fed7e2;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(254, 215, 226, 0));\n}\n\n.focus\\:from-pink-300:focus {\n  --gradient-from-color: #fbb6ce;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(251, 182, 206, 0));\n}\n\n.focus\\:from-pink-400:focus {\n  --gradient-from-color: #f687b3;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(246, 135, 179, 0));\n}\n\n.focus\\:from-pink-500:focus {\n  --gradient-from-color: #ed64a6;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(237, 100, 166, 0));\n}\n\n.focus\\:from-pink-600:focus {\n  --gradient-from-color: #d53f8c;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(213, 63, 140, 0));\n}\n\n.focus\\:from-pink-700:focus {\n  --gradient-from-color: #b83280;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(184, 50, 128, 0));\n}\n\n.focus\\:from-pink-800:focus {\n  --gradient-from-color: #97266d;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(151, 38, 109, 0));\n}\n\n.focus\\:from-pink-900:focus {\n  --gradient-from-color: #702459;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-to-color, rgba(112, 36, 89, 0));\n}\n\n.focus\\:via-transparent:focus {\n  --gradient-via-color: transparent;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(0, 0, 0, 0));\n}\n\n.focus\\:via-current:focus {\n  --gradient-via-color: currentColor;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(255, 255, 255, 0));\n}\n\n.focus\\:via-black:focus {\n  --gradient-via-color: #000;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(0, 0, 0, 0));\n}\n\n.focus\\:via-white:focus {\n  --gradient-via-color: #fff;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(255, 255, 255, 0));\n}\n\n.focus\\:via-gray-100:focus {\n  --gradient-via-color: #f7fafc;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(247, 250, 252, 0));\n}\n\n.focus\\:via-gray-200:focus {\n  --gradient-via-color: #edf2f7;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(237, 242, 247, 0));\n}\n\n.focus\\:via-gray-300:focus {\n  --gradient-via-color: #e2e8f0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(226, 232, 240, 0));\n}\n\n.focus\\:via-gray-400:focus {\n  --gradient-via-color: #cbd5e0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(203, 213, 224, 0));\n}\n\n.focus\\:via-gray-500:focus {\n  --gradient-via-color: #a0aec0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(160, 174, 192, 0));\n}\n\n.focus\\:via-gray-600:focus {\n  --gradient-via-color: #718096;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(113, 128, 150, 0));\n}\n\n.focus\\:via-gray-700:focus {\n  --gradient-via-color: #4a5568;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(74, 85, 104, 0));\n}\n\n.focus\\:via-gray-800:focus {\n  --gradient-via-color: #2d3748;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(45, 55, 72, 0));\n}\n\n.focus\\:via-gray-900:focus {\n  --gradient-via-color: #1a202c;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(26, 32, 44, 0));\n}\n\n.focus\\:via-red-100:focus {\n  --gradient-via-color: #fff5f5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(255, 245, 245, 0));\n}\n\n.focus\\:via-red-200:focus {\n  --gradient-via-color: #fed7d7;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(254, 215, 215, 0));\n}\n\n.focus\\:via-red-300:focus {\n  --gradient-via-color: #feb2b2;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(254, 178, 178, 0));\n}\n\n.focus\\:via-red-400:focus {\n  --gradient-via-color: #fc8181;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(252, 129, 129, 0));\n}\n\n.focus\\:via-red-500:focus {\n  --gradient-via-color: #f56565;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(245, 101, 101, 0));\n}\n\n.focus\\:via-red-600:focus {\n  --gradient-via-color: #e53e3e;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(229, 62, 62, 0));\n}\n\n.focus\\:via-red-700:focus {\n  --gradient-via-color: #c53030;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(197, 48, 48, 0));\n}\n\n.focus\\:via-red-800:focus {\n  --gradient-via-color: #9b2c2c;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(155, 44, 44, 0));\n}\n\n.focus\\:via-red-900:focus {\n  --gradient-via-color: #742a2a;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(116, 42, 42, 0));\n}\n\n.focus\\:via-orange-100:focus {\n  --gradient-via-color: #fffaf0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(255, 250, 240, 0));\n}\n\n.focus\\:via-orange-200:focus {\n  --gradient-via-color: #feebc8;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(254, 235, 200, 0));\n}\n\n.focus\\:via-orange-300:focus {\n  --gradient-via-color: #fbd38d;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(251, 211, 141, 0));\n}\n\n.focus\\:via-orange-400:focus {\n  --gradient-via-color: #f6ad55;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(246, 173, 85, 0));\n}\n\n.focus\\:via-orange-500:focus {\n  --gradient-via-color: #ed8936;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(237, 137, 54, 0));\n}\n\n.focus\\:via-orange-600:focus {\n  --gradient-via-color: #dd6b20;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(221, 107, 32, 0));\n}\n\n.focus\\:via-orange-700:focus {\n  --gradient-via-color: #c05621;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(192, 86, 33, 0));\n}\n\n.focus\\:via-orange-800:focus {\n  --gradient-via-color: #9c4221;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(156, 66, 33, 0));\n}\n\n.focus\\:via-orange-900:focus {\n  --gradient-via-color: #7b341e;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(123, 52, 30, 0));\n}\n\n.focus\\:via-yellow-100:focus {\n  --gradient-via-color: #fffff0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(255, 255, 240, 0));\n}\n\n.focus\\:via-yellow-200:focus {\n  --gradient-via-color: #fefcbf;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(254, 252, 191, 0));\n}\n\n.focus\\:via-yellow-300:focus {\n  --gradient-via-color: #faf089;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(250, 240, 137, 0));\n}\n\n.focus\\:via-yellow-400:focus {\n  --gradient-via-color: #f6e05e;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(246, 224, 94, 0));\n}\n\n.focus\\:via-yellow-500:focus {\n  --gradient-via-color: #ecc94b;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(236, 201, 75, 0));\n}\n\n.focus\\:via-yellow-600:focus {\n  --gradient-via-color: #d69e2e;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(214, 158, 46, 0));\n}\n\n.focus\\:via-yellow-700:focus {\n  --gradient-via-color: #b7791f;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(183, 121, 31, 0));\n}\n\n.focus\\:via-yellow-800:focus {\n  --gradient-via-color: #975a16;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(151, 90, 22, 0));\n}\n\n.focus\\:via-yellow-900:focus {\n  --gradient-via-color: #744210;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(116, 66, 16, 0));\n}\n\n.focus\\:via-green-100:focus {\n  --gradient-via-color: #f0fff4;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(240, 255, 244, 0));\n}\n\n.focus\\:via-green-200:focus {\n  --gradient-via-color: #c6f6d5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(198, 246, 213, 0));\n}\n\n.focus\\:via-green-300:focus {\n  --gradient-via-color: #9ae6b4;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(154, 230, 180, 0));\n}\n\n.focus\\:via-green-400:focus {\n  --gradient-via-color: #68d391;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(104, 211, 145, 0));\n}\n\n.focus\\:via-green-500:focus {\n  --gradient-via-color: #48bb78;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(72, 187, 120, 0));\n}\n\n.focus\\:via-green-600:focus {\n  --gradient-via-color: #38a169;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(56, 161, 105, 0));\n}\n\n.focus\\:via-green-700:focus {\n  --gradient-via-color: #2f855a;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(47, 133, 90, 0));\n}\n\n.focus\\:via-green-800:focus {\n  --gradient-via-color: #276749;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(39, 103, 73, 0));\n}\n\n.focus\\:via-green-900:focus {\n  --gradient-via-color: #22543d;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(34, 84, 61, 0));\n}\n\n.focus\\:via-teal-100:focus {\n  --gradient-via-color: #e6fffa;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(230, 255, 250, 0));\n}\n\n.focus\\:via-teal-200:focus {\n  --gradient-via-color: #b2f5ea;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(178, 245, 234, 0));\n}\n\n.focus\\:via-teal-300:focus {\n  --gradient-via-color: #81e6d9;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(129, 230, 217, 0));\n}\n\n.focus\\:via-teal-400:focus {\n  --gradient-via-color: #4fd1c5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(79, 209, 197, 0));\n}\n\n.focus\\:via-teal-500:focus {\n  --gradient-via-color: #38b2ac;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(56, 178, 172, 0));\n}\n\n.focus\\:via-teal-600:focus {\n  --gradient-via-color: #319795;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(49, 151, 149, 0));\n}\n\n.focus\\:via-teal-700:focus {\n  --gradient-via-color: #2c7a7b;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(44, 122, 123, 0));\n}\n\n.focus\\:via-teal-800:focus {\n  --gradient-via-color: #285e61;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(40, 94, 97, 0));\n}\n\n.focus\\:via-teal-900:focus {\n  --gradient-via-color: #234e52;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(35, 78, 82, 0));\n}\n\n.focus\\:via-blue-100:focus {\n  --gradient-via-color: #ebf8ff;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(235, 248, 255, 0));\n}\n\n.focus\\:via-blue-200:focus {\n  --gradient-via-color: #bee3f8;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(190, 227, 248, 0));\n}\n\n.focus\\:via-blue-300:focus {\n  --gradient-via-color: #90cdf4;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(144, 205, 244, 0));\n}\n\n.focus\\:via-blue-400:focus {\n  --gradient-via-color: #63b3ed;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(99, 179, 237, 0));\n}\n\n.focus\\:via-blue-500:focus {\n  --gradient-via-color: #4299e1;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(66, 153, 225, 0));\n}\n\n.focus\\:via-blue-600:focus {\n  --gradient-via-color: #3182ce;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(49, 130, 206, 0));\n}\n\n.focus\\:via-blue-700:focus {\n  --gradient-via-color: #2b6cb0;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(43, 108, 176, 0));\n}\n\n.focus\\:via-blue-800:focus {\n  --gradient-via-color: #2c5282;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(44, 82, 130, 0));\n}\n\n.focus\\:via-blue-900:focus {\n  --gradient-via-color: #2a4365;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(42, 67, 101, 0));\n}\n\n.focus\\:via-indigo-100:focus {\n  --gradient-via-color: #ebf4ff;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(235, 244, 255, 0));\n}\n\n.focus\\:via-indigo-200:focus {\n  --gradient-via-color: #c3dafe;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(195, 218, 254, 0));\n}\n\n.focus\\:via-indigo-300:focus {\n  --gradient-via-color: #a3bffa;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(163, 191, 250, 0));\n}\n\n.focus\\:via-indigo-400:focus {\n  --gradient-via-color: #7f9cf5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(127, 156, 245, 0));\n}\n\n.focus\\:via-indigo-500:focus {\n  --gradient-via-color: #667eea;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(102, 126, 234, 0));\n}\n\n.focus\\:via-indigo-600:focus {\n  --gradient-via-color: #5a67d8;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(90, 103, 216, 0));\n}\n\n.focus\\:via-indigo-700:focus {\n  --gradient-via-color: #4c51bf;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(76, 81, 191, 0));\n}\n\n.focus\\:via-indigo-800:focus {\n  --gradient-via-color: #434190;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(67, 65, 144, 0));\n}\n\n.focus\\:via-indigo-900:focus {\n  --gradient-via-color: #3c366b;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(60, 54, 107, 0));\n}\n\n.focus\\:via-purple-100:focus {\n  --gradient-via-color: #faf5ff;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(250, 245, 255, 0));\n}\n\n.focus\\:via-purple-200:focus {\n  --gradient-via-color: #e9d8fd;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(233, 216, 253, 0));\n}\n\n.focus\\:via-purple-300:focus {\n  --gradient-via-color: #d6bcfa;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(214, 188, 250, 0));\n}\n\n.focus\\:via-purple-400:focus {\n  --gradient-via-color: #b794f4;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(183, 148, 244, 0));\n}\n\n.focus\\:via-purple-500:focus {\n  --gradient-via-color: #9f7aea;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(159, 122, 234, 0));\n}\n\n.focus\\:via-purple-600:focus {\n  --gradient-via-color: #805ad5;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(128, 90, 213, 0));\n}\n\n.focus\\:via-purple-700:focus {\n  --gradient-via-color: #6b46c1;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(107, 70, 193, 0));\n}\n\n.focus\\:via-purple-800:focus {\n  --gradient-via-color: #553c9a;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(85, 60, 154, 0));\n}\n\n.focus\\:via-purple-900:focus {\n  --gradient-via-color: #44337a;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(68, 51, 122, 0));\n}\n\n.focus\\:via-pink-100:focus {\n  --gradient-via-color: #fff5f7;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(255, 245, 247, 0));\n}\n\n.focus\\:via-pink-200:focus {\n  --gradient-via-color: #fed7e2;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(254, 215, 226, 0));\n}\n\n.focus\\:via-pink-300:focus {\n  --gradient-via-color: #fbb6ce;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(251, 182, 206, 0));\n}\n\n.focus\\:via-pink-400:focus {\n  --gradient-via-color: #f687b3;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(246, 135, 179, 0));\n}\n\n.focus\\:via-pink-500:focus {\n  --gradient-via-color: #ed64a6;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(237, 100, 166, 0));\n}\n\n.focus\\:via-pink-600:focus {\n  --gradient-via-color: #d53f8c;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(213, 63, 140, 0));\n}\n\n.focus\\:via-pink-700:focus {\n  --gradient-via-color: #b83280;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(184, 50, 128, 0));\n}\n\n.focus\\:via-pink-800:focus {\n  --gradient-via-color: #97266d;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(151, 38, 109, 0));\n}\n\n.focus\\:via-pink-900:focus {\n  --gradient-via-color: #702459;\n  --gradient-color-stops: var(--gradient-from-color), var(--gradient-via-color), var(--gradient-to-color, rgba(112, 36, 89, 0));\n}\n\n.focus\\:to-transparent:focus {\n  --gradient-to-color: transparent;\n}\n\n.focus\\:to-current:focus {\n  --gradient-to-color: currentColor;\n}\n\n.focus\\:to-black:focus {\n  --gradient-to-color: #000;\n}\n\n.focus\\:to-white:focus {\n  --gradient-to-color: #fff;\n}\n\n.focus\\:to-gray-100:focus {\n  --gradient-to-color: #f7fafc;\n}\n\n.focus\\:to-gray-200:focus {\n  --gradient-to-color: #edf2f7;\n}\n\n.focus\\:to-gray-300:focus {\n  --gradient-to-color: #e2e8f0;\n}\n\n.focus\\:to-gray-400:focus {\n  --gradient-to-color: #cbd5e0;\n}\n\n.focus\\:to-gray-500:focus {\n  --gradient-to-color: #a0aec0;\n}\n\n.focus\\:to-gray-600:focus {\n  --gradient-to-color: #718096;\n}\n\n.focus\\:to-gray-700:focus {\n  --gradient-to-color: #4a5568;\n}\n\n.focus\\:to-gray-800:focus {\n  --gradient-to-color: #2d3748;\n}\n\n.focus\\:to-gray-900:focus {\n  --gradient-to-color: #1a202c;\n}\n\n.focus\\:to-red-100:focus {\n  --gradient-to-color: #fff5f5;\n}\n\n.focus\\:to-red-200:focus {\n  --gradient-to-color: #fed7d7;\n}\n\n.focus\\:to-red-300:focus {\n  --gradient-to-color: #feb2b2;\n}\n\n.focus\\:to-red-400:focus {\n  --gradient-to-color: #fc8181;\n}\n\n.focus\\:to-red-500:focus {\n  --gradient-to-color: #f56565;\n}\n\n.focus\\:to-red-600:focus {\n  --gradient-to-color: #e53e3e;\n}\n\n.focus\\:to-red-700:focus {\n  --gradient-to-color: #c53030;\n}\n\n.focus\\:to-red-800:focus {\n  --gradient-to-color: #9b2c2c;\n}\n\n.focus\\:to-red-900:focus {\n  --gradient-to-color: #742a2a;\n}\n\n.focus\\:to-orange-100:focus {\n  --gradient-to-color: #fffaf0;\n}\n\n.focus\\:to-orange-200:focus {\n  --gradient-to-color: #feebc8;\n}\n\n.focus\\:to-orange-300:focus {\n  --gradient-to-color: #fbd38d;\n}\n\n.focus\\:to-orange-400:focus {\n  --gradient-to-color: #f6ad55;\n}\n\n.focus\\:to-orange-500:focus {\n  --gradient-to-color: #ed8936;\n}\n\n.focus\\:to-orange-600:focus {\n  --gradient-to-color: #dd6b20;\n}\n\n.focus\\:to-orange-700:focus {\n  --gradient-to-color: #c05621;\n}\n\n.focus\\:to-orange-800:focus {\n  --gradient-to-color: #9c4221;\n}\n\n.focus\\:to-orange-900:focus {\n  --gradient-to-color: #7b341e;\n}\n\n.focus\\:to-yellow-100:focus {\n  --gradient-to-color: #fffff0;\n}\n\n.focus\\:to-yellow-200:focus {\n  --gradient-to-color: #fefcbf;\n}\n\n.focus\\:to-yellow-300:focus {\n  --gradient-to-color: #faf089;\n}\n\n.focus\\:to-yellow-400:focus {\n  --gradient-to-color: #f6e05e;\n}\n\n.focus\\:to-yellow-500:focus {\n  --gradient-to-color: #ecc94b;\n}\n\n.focus\\:to-yellow-600:focus {\n  --gradient-to-color: #d69e2e;\n}\n\n.focus\\:to-yellow-700:focus {\n  --gradient-to-color: #b7791f;\n}\n\n.focus\\:to-yellow-800:focus {\n  --gradient-to-color: #975a16;\n}\n\n.focus\\:to-yellow-900:focus {\n  --gradient-to-color: #744210;\n}\n\n.focus\\:to-green-100:focus {\n  --gradient-to-color: #f0fff4;\n}\n\n.focus\\:to-green-200:focus {\n  --gradient-to-color: #c6f6d5;\n}\n\n.focus\\:to-green-300:focus {\n  --gradient-to-color: #9ae6b4;\n}\n\n.focus\\:to-green-400:focus {\n  --gradient-to-color: #68d391;\n}\n\n.focus\\:to-green-500:focus {\n  --gradient-to-color: #48bb78;\n}\n\n.focus\\:to-green-600:focus {\n  --gradient-to-color: #38a169;\n}\n\n.focus\\:to-green-700:focus {\n  --gradient-to-color: #2f855a;\n}\n\n.focus\\:to-green-800:focus {\n  --gradient-to-color: #276749;\n}\n\n.focus\\:to-green-900:focus {\n  --gradient-to-color: #22543d;\n}\n\n.focus\\:to-teal-100:focus {\n  --gradient-to-color: #e6fffa;\n}\n\n.focus\\:to-teal-200:focus {\n  --gradient-to-color: #b2f5ea;\n}\n\n.focus\\:to-teal-300:focus {\n  --gradient-to-color: #81e6d9;\n}\n\n.focus\\:to-teal-400:focus {\n  --gradient-to-color: #4fd1c5;\n}\n\n.focus\\:to-teal-500:focus {\n  --gradient-to-color: #38b2ac;\n}\n\n.focus\\:to-teal-600:focus {\n  --gradient-to-color: #319795;\n}\n\n.focus\\:to-teal-700:focus {\n  --gradient-to-color: #2c7a7b;\n}\n\n.focus\\:to-teal-800:focus {\n  --gradient-to-color: #285e61;\n}\n\n.focus\\:to-teal-900:focus {\n  --gradient-to-color: #234e52;\n}\n\n.focus\\:to-blue-100:focus {\n  --gradient-to-color: #ebf8ff;\n}\n\n.focus\\:to-blue-200:focus {\n  --gradient-to-color: #bee3f8;\n}\n\n.focus\\:to-blue-300:focus {\n  --gradient-to-color: #90cdf4;\n}\n\n.focus\\:to-blue-400:focus {\n  --gradient-to-color: #63b3ed;\n}\n\n.focus\\:to-blue-500:focus {\n  --gradient-to-color: #4299e1;\n}\n\n.focus\\:to-blue-600:focus {\n  --gradient-to-color: #3182ce;\n}\n\n.focus\\:to-blue-700:focus {\n  --gradient-to-color: #2b6cb0;\n}\n\n.focus\\:to-blue-800:focus {\n  --gradient-to-color: #2c5282;\n}\n\n.focus\\:to-blue-900:focus {\n  --gradient-to-color: #2a4365;\n}\n\n.focus\\:to-indigo-100:focus {\n  --gradient-to-color: #ebf4ff;\n}\n\n.focus\\:to-indigo-200:focus {\n  --gradient-to-color: #c3dafe;\n}\n\n.focus\\:to-indigo-300:focus {\n  --gradient-to-color: #a3bffa;\n}\n\n.focus\\:to-indigo-400:focus {\n  --gradient-to-color: #7f9cf5;\n}\n\n.focus\\:to-indigo-500:focus {\n  --gradient-to-color: #667eea;\n}\n\n.focus\\:to-indigo-600:focus {\n  --gradient-to-color: #5a67d8;\n}\n\n.focus\\:to-indigo-700:focus {\n  --gradient-to-color: #4c51bf;\n}\n\n.focus\\:to-indigo-800:focus {\n  --gradient-to-color: #434190;\n}\n\n.focus\\:to-indigo-900:focus {\n  --gradient-to-color: #3c366b;\n}\n\n.focus\\:to-purple-100:focus {\n  --gradient-to-color: #faf5ff;\n}\n\n.focus\\:to-purple-200:focus {\n  --gradient-to-color: #e9d8fd;\n}\n\n.focus\\:to-purple-300:focus {\n  --gradient-to-color: #d6bcfa;\n}\n\n.focus\\:to-purple-400:focus {\n  --gradient-to-color: #b794f4;\n}\n\n.focus\\:to-purple-500:focus {\n  --gradient-to-color: #9f7aea;\n}\n\n.focus\\:to-purple-600:focus {\n  --gradient-to-color: #805ad5;\n}\n\n.focus\\:to-purple-700:focus {\n  --gradient-to-color: #6b46c1;\n}\n\n.focus\\:to-purple-800:focus {\n  --gradient-to-color: #553c9a;\n}\n\n.focus\\:to-purple-900:focus {\n  --gradient-to-color: #44337a;\n}\n\n.focus\\:to-pink-100:focus {\n  --gradient-to-color: #fff5f7;\n}\n\n.focus\\:to-pink-200:focus {\n  --gradient-to-color: #fed7e2;\n}\n\n.focus\\:to-pink-300:focus {\n  --gradient-to-color: #fbb6ce;\n}\n\n.focus\\:to-pink-400:focus {\n  --gradient-to-color: #f687b3;\n}\n\n.focus\\:to-pink-500:focus {\n  --gradient-to-color: #ed64a6;\n}\n\n.focus\\:to-pink-600:focus {\n  --gradient-to-color: #d53f8c;\n}\n\n.focus\\:to-pink-700:focus {\n  --gradient-to-color: #b83280;\n}\n\n.focus\\:to-pink-800:focus {\n  --gradient-to-color: #97266d;\n}\n\n.focus\\:to-pink-900:focus {\n  --gradient-to-color: #702459;\n}\n\n.bg-opacity-0 {\n  --bg-opacity: 0;\n}\n\n.bg-opacity-25 {\n  --bg-opacity: 0.25;\n}\n\n.bg-opacity-50 {\n  --bg-opacity: 0.5;\n}\n\n.bg-opacity-75 {\n  --bg-opacity: 0.75;\n}\n\n.bg-opacity-100 {\n  --bg-opacity: 1;\n}\n\n.hover\\:bg-opacity-0:hover {\n  --bg-opacity: 0;\n}\n\n.hover\\:bg-opacity-25:hover {\n  --bg-opacity: 0.25;\n}\n\n.hover\\:bg-opacity-50:hover {\n  --bg-opacity: 0.5;\n}\n\n.hover\\:bg-opacity-75:hover {\n  --bg-opacity: 0.75;\n}\n\n.hover\\:bg-opacity-100:hover {\n  --bg-opacity: 1;\n}\n\n.focus\\:bg-opacity-0:focus {\n  --bg-opacity: 0;\n}\n\n.focus\\:bg-opacity-25:focus {\n  --bg-opacity: 0.25;\n}\n\n.focus\\:bg-opacity-50:focus {\n  --bg-opacity: 0.5;\n}\n\n.focus\\:bg-opacity-75:focus {\n  --bg-opacity: 0.75;\n}\n\n.focus\\:bg-opacity-100:focus {\n  --bg-opacity: 1;\n}\n\n.bg-bottom {\n  background-position: bottom;\n}\n\n.bg-center {\n  background-position: center;\n}\n\n.bg-left {\n  background-position: left;\n}\n\n.bg-left-bottom {\n  background-position: left bottom;\n}\n\n.bg-left-top {\n  background-position: left top;\n}\n\n.bg-right {\n  background-position: right;\n}\n\n.bg-right-bottom {\n  background-position: right bottom;\n}\n\n.bg-right-top {\n  background-position: right top;\n}\n\n.bg-top {\n  background-position: top;\n}\n\n.bg-repeat {\n  background-repeat: repeat;\n}\n\n.bg-no-repeat {\n  background-repeat: no-repeat;\n}\n\n.bg-repeat-x {\n  background-repeat: repeat-x;\n}\n\n.bg-repeat-y {\n  background-repeat: repeat-y;\n}\n\n.bg-repeat-round {\n  background-repeat: round;\n}\n\n.bg-repeat-space {\n  background-repeat: space;\n}\n\n.bg-auto {\n  background-size: auto;\n}\n\n.bg-cover {\n  background-size: cover;\n}\n\n.bg-contain {\n  background-size: contain;\n}\n\n.border-collapse {\n  border-collapse: collapse;\n}\n\n.border-separate {\n  border-collapse: separate;\n}\n\n.border-transparent {\n  border-color: transparent;\n}\n\n.border-current {\n  border-color: currentColor;\n}\n\n.border-black {\n  --border-opacity: 1;\n  border-color: #000;\n  border-color: rgba(0, 0, 0, var(--border-opacity));\n}\n\n.border-white {\n  --border-opacity: 1;\n  border-color: #fff;\n  border-color: rgba(255, 255, 255, var(--border-opacity));\n}\n\n.border-gray-100 {\n  --border-opacity: 1;\n  border-color: #f7fafc;\n  border-color: rgba(247, 250, 252, var(--border-opacity));\n}\n\n.border-gray-200 {\n  --border-opacity: 1;\n  border-color: #edf2f7;\n  border-color: rgba(237, 242, 247, var(--border-opacity));\n}\n\n.border-gray-300 {\n  --border-opacity: 1;\n  border-color: #e2e8f0;\n  border-color: rgba(226, 232, 240, var(--border-opacity));\n}\n\n.border-gray-400 {\n  --border-opacity: 1;\n  border-color: #cbd5e0;\n  border-color: rgba(203, 213, 224, var(--border-opacity));\n}\n\n.border-gray-500 {\n  --border-opacity: 1;\n  border-color: #a0aec0;\n  border-color: rgba(160, 174, 192, var(--border-opacity));\n}\n\n.border-gray-600 {\n  --border-opacity: 1;\n  border-color: #718096;\n  border-color: rgba(113, 128, 150, var(--border-opacity));\n}\n\n.border-gray-700 {\n  --border-opacity: 1;\n  border-color: #4a5568;\n  border-color: rgba(74, 85, 104, var(--border-opacity));\n}\n\n.border-gray-800 {\n  --border-opacity: 1;\n  border-color: #2d3748;\n  border-color: rgba(45, 55, 72, var(--border-opacity));\n}\n\n.border-gray-900 {\n  --border-opacity: 1;\n  border-color: #1a202c;\n  border-color: rgba(26, 32, 44, var(--border-opacity));\n}\n\n.border-red-100 {\n  --border-opacity: 1;\n  border-color: #fff5f5;\n  border-color: rgba(255, 245, 245, var(--border-opacity));\n}\n\n.border-red-200 {\n  --border-opacity: 1;\n  border-color: #fed7d7;\n  border-color: rgba(254, 215, 215, var(--border-opacity));\n}\n\n.border-red-300 {\n  --border-opacity: 1;\n  border-color: #feb2b2;\n  border-color: rgba(254, 178, 178, var(--border-opacity));\n}\n\n.border-red-400 {\n  --border-opacity: 1;\n  border-color: #fc8181;\n  border-color: rgba(252, 129, 129, var(--border-opacity));\n}\n\n.border-red-500 {\n  --border-opacity: 1;\n  border-color: #f56565;\n  border-color: rgba(245, 101, 101, var(--border-opacity));\n}\n\n.border-red-600 {\n  --border-opacity: 1;\n  border-color: #e53e3e;\n  border-color: rgba(229, 62, 62, var(--border-opacity));\n}\n\n.border-red-700 {\n  --border-opacity: 1;\n  border-color: #c53030;\n  border-color: rgba(197, 48, 48, var(--border-opacity));\n}\n\n.border-red-800 {\n  --border-opacity: 1;\n  border-color: #9b2c2c;\n  border-color: rgba(155, 44, 44, var(--border-opacity));\n}\n\n.border-red-900 {\n  --border-opacity: 1;\n  border-color: #742a2a;\n  border-color: rgba(116, 42, 42, var(--border-opacity));\n}\n\n.border-orange-100 {\n  --border-opacity: 1;\n  border-color: #fffaf0;\n  border-color: rgba(255, 250, 240, var(--border-opacity));\n}\n\n.border-orange-200 {\n  --border-opacity: 1;\n  border-color: #feebc8;\n  border-color: rgba(254, 235, 200, var(--border-opacity));\n}\n\n.border-orange-300 {\n  --border-opacity: 1;\n  border-color: #fbd38d;\n  border-color: rgba(251, 211, 141, var(--border-opacity));\n}\n\n.border-orange-400 {\n  --border-opacity: 1;\n  border-color: #f6ad55;\n  border-color: rgba(246, 173, 85, var(--border-opacity));\n}\n\n.border-orange-500 {\n  --border-opacity: 1;\n  border-color: #ed8936;\n  border-color: rgba(237, 137, 54, var(--border-opacity));\n}\n\n.border-orange-600 {\n  --border-opacity: 1;\n  border-color: #dd6b20;\n  border-color: rgba(221, 107, 32, var(--border-opacity));\n}\n\n.border-orange-700 {\n  --border-opacity: 1;\n  border-color: #c05621;\n  border-color: rgba(192, 86, 33, var(--border-opacity));\n}\n\n.border-orange-800 {\n  --border-opacity: 1;\n  border-color: #9c4221;\n  border-color: rgba(156, 66, 33, var(--border-opacity));\n}\n\n.border-orange-900 {\n  --border-opacity: 1;\n  border-color: #7b341e;\n  border-color: rgba(123, 52, 30, var(--border-opacity));\n}\n\n.border-yellow-100 {\n  --border-opacity: 1;\n  border-color: #fffff0;\n  border-color: rgba(255, 255, 240, var(--border-opacity));\n}\n\n.border-yellow-200 {\n  --border-opacity: 1;\n  border-color: #fefcbf;\n  border-color: rgba(254, 252, 191, var(--border-opacity));\n}\n\n.border-yellow-300 {\n  --border-opacity: 1;\n  border-color: #faf089;\n  border-color: rgba(250, 240, 137, var(--border-opacity));\n}\n\n.border-yellow-400 {\n  --border-opacity: 1;\n  border-color: #f6e05e;\n  border-color: rgba(246, 224, 94, var(--border-opacity));\n}\n\n.border-yellow-500 {\n  --border-opacity: 1;\n  border-color: #ecc94b;\n  border-color: rgba(236, 201, 75, var(--border-opacity));\n}\n\n.border-yellow-600 {\n  --border-opacity: 1;\n  border-color: #d69e2e;\n  border-color: rgba(214, 158, 46, var(--border-opacity));\n}\n\n.border-yellow-700 {\n  --border-opacity: 1;\n  border-color: #b7791f;\n  border-color: rgba(183, 121, 31, var(--border-opacity));\n}\n\n.border-yellow-800 {\n  --border-opacity: 1;\n  border-color: #975a16;\n  border-color: rgba(151, 90, 22, var(--border-opacity));\n}\n\n.border-yellow-900 {\n  --border-opacity: 1;\n  border-color: #744210;\n  border-color: rgba(116, 66, 16, var(--border-opacity));\n}\n\n.border-green-100 {\n  --border-opacity: 1;\n  border-color: #f0fff4;\n  border-color: rgba(240, 255, 244, var(--border-opacity));\n}\n\n.border-green-200 {\n  --border-opacity: 1;\n  border-color: #c6f6d5;\n  border-color: rgba(198, 246, 213, var(--border-opacity));\n}\n\n.border-green-300 {\n  --border-opacity: 1;\n  border-color: #9ae6b4;\n  border-color: rgba(154, 230, 180, var(--border-opacity));\n}\n\n.border-green-400 {\n  --border-opacity: 1;\n  border-color: #68d391;\n  border-color: rgba(104, 211, 145, var(--border-opacity));\n}\n\n.border-green-500 {\n  --border-opacity: 1;\n  border-color: #48bb78;\n  border-color: rgba(72, 187, 120, var(--border-opacity));\n}\n\n.border-green-600 {\n  --border-opacity: 1;\n  border-color: #38a169;\n  border-color: rgba(56, 161, 105, var(--border-opacity));\n}\n\n.border-green-700 {\n  --border-opacity: 1;\n  border-color: #2f855a;\n  border-color: rgba(47, 133, 90, var(--border-opacity));\n}\n\n.border-green-800 {\n  --border-opacity: 1;\n  border-color: #276749;\n  border-color: rgba(39, 103, 73, var(--border-opacity));\n}\n\n.border-green-900 {\n  --border-opacity: 1;\n  border-color: #22543d;\n  border-color: rgba(34, 84, 61, var(--border-opacity));\n}\n\n.border-teal-100 {\n  --border-opacity: 1;\n  border-color: #e6fffa;\n  border-color: rgba(230, 255, 250, var(--border-opacity));\n}\n\n.border-teal-200 {\n  --border-opacity: 1;\n  border-color: #b2f5ea;\n  border-color: rgba(178, 245, 234, var(--border-opacity));\n}\n\n.border-teal-300 {\n  --border-opacity: 1;\n  border-color: #81e6d9;\n  border-color: rgba(129, 230, 217, var(--border-opacity));\n}\n\n.border-teal-400 {\n  --border-opacity: 1;\n  border-color: #4fd1c5;\n  border-color: rgba(79, 209, 197, var(--border-opacity));\n}\n\n.border-teal-500 {\n  --border-opacity: 1;\n  border-color: #38b2ac;\n  border-color: rgba(56, 178, 172, var(--border-opacity));\n}\n\n.border-teal-600 {\n  --border-opacity: 1;\n  border-color: #319795;\n  border-color: rgba(49, 151, 149, var(--border-opacity));\n}\n\n.border-teal-700 {\n  --border-opacity: 1;\n  border-color: #2c7a7b;\n  border-color: rgba(44, 122, 123, var(--border-opacity));\n}\n\n.border-teal-800 {\n  --border-opacity: 1;\n  border-color: #285e61;\n  border-color: rgba(40, 94, 97, var(--border-opacity));\n}\n\n.border-teal-900 {\n  --border-opacity: 1;\n  border-color: #234e52;\n  border-color: rgba(35, 78, 82, var(--border-opacity));\n}\n\n.border-blue-100 {\n  --border-opacity: 1;\n  border-color: #ebf8ff;\n  border-color: rgba(235, 248, 255, var(--border-opacity));\n}\n\n.border-blue-200 {\n  --border-opacity: 1;\n  border-color: #bee3f8;\n  border-color: rgba(190, 227, 248, var(--border-opacity));\n}\n\n.border-blue-300 {\n  --border-opacity: 1;\n  border-color: #90cdf4;\n  border-color: rgba(144, 205, 244, var(--border-opacity));\n}\n\n.border-blue-400 {\n  --border-opacity: 1;\n  border-color: #63b3ed;\n  border-color: rgba(99, 179, 237, var(--border-opacity));\n}\n\n.border-blue-500 {\n  --border-opacity: 1;\n  border-color: #4299e1;\n  border-color: rgba(66, 153, 225, var(--border-opacity));\n}\n\n.border-blue-600 {\n  --border-opacity: 1;\n  border-color: #3182ce;\n  border-color: rgba(49, 130, 206, var(--border-opacity));\n}\n\n.border-blue-700 {\n  --border-opacity: 1;\n  border-color: #2b6cb0;\n  border-color: rgba(43, 108, 176, var(--border-opacity));\n}\n\n.border-blue-800 {\n  --border-opacity: 1;\n  border-color: #2c5282;\n  border-color: rgba(44, 82, 130, var(--border-opacity));\n}\n\n.border-blue-900 {\n  --border-opacity: 1;\n  border-color: #2a4365;\n  border-color: rgba(42, 67, 101, var(--border-opacity));\n}\n\n.border-indigo-100 {\n  --border-opacity: 1;\n  border-color: #ebf4ff;\n  border-color: rgba(235, 244, 255, var(--border-opacity));\n}\n\n.border-indigo-200 {\n  --border-opacity: 1;\n  border-color: #c3dafe;\n  border-color: rgba(195, 218, 254, var(--border-opacity));\n}\n\n.border-indigo-300 {\n  --border-opacity: 1;\n  border-color: #a3bffa;\n  border-color: rgba(163, 191, 250, var(--border-opacity));\n}\n\n.border-indigo-400 {\n  --border-opacity: 1;\n  border-color: #7f9cf5;\n  border-color: rgba(127, 156, 245, var(--border-opacity));\n}\n\n.border-indigo-500 {\n  --border-opacity: 1;\n  border-color: #667eea;\n  border-color: rgba(102, 126, 234, var(--border-opacity));\n}\n\n.border-indigo-600 {\n  --border-opacity: 1;\n  border-color: #5a67d8;\n  border-color: rgba(90, 103, 216, var(--border-opacity));\n}\n\n.border-indigo-700 {\n  --border-opacity: 1;\n  border-color: #4c51bf;\n  border-color: rgba(76, 81, 191, var(--border-opacity));\n}\n\n.border-indigo-800 {\n  --border-opacity: 1;\n  border-color: #434190;\n  border-color: rgba(67, 65, 144, var(--border-opacity));\n}\n\n.border-indigo-900 {\n  --border-opacity: 1;\n  border-color: #3c366b;\n  border-color: rgba(60, 54, 107, var(--border-opacity));\n}\n\n.border-purple-100 {\n  --border-opacity: 1;\n  border-color: #faf5ff;\n  border-color: rgba(250, 245, 255, var(--border-opacity));\n}\n\n.border-purple-200 {\n  --border-opacity: 1;\n  border-color: #e9d8fd;\n  border-color: rgba(233, 216, 253, var(--border-opacity));\n}\n\n.border-purple-300 {\n  --border-opacity: 1;\n  border-color: #d6bcfa;\n  border-color: rgba(214, 188, 250, var(--border-opacity));\n}\n\n.border-purple-400 {\n  --border-opacity: 1;\n  border-color: #b794f4;\n  border-color: rgba(183, 148, 244, var(--border-opacity));\n}\n\n.border-purple-500 {\n  --border-opacity: 1;\n  border-color: #9f7aea;\n  border-color: rgba(159, 122, 234, var(--border-opacity));\n}\n\n.border-purple-600 {\n  --border-opacity: 1;\n  border-color: #805ad5;\n  border-color: rgba(128, 90, 213, var(--border-opacity));\n}\n\n.border-purple-700 {\n  --border-opacity: 1;\n  border-color: #6b46c1;\n  border-color: rgba(107, 70, 193, var(--border-opacity));\n}\n\n.border-purple-800 {\n  --border-opacity: 1;\n  border-color: #553c9a;\n  border-color: rgba(85, 60, 154, var(--border-opacity));\n}\n\n.border-purple-900 {\n  --border-opacity: 1;\n  border-color: #44337a;\n  border-color: rgba(68, 51, 122, var(--border-opacity));\n}\n\n.border-pink-100 {\n  --border-opacity: 1;\n  border-color: #fff5f7;\n  border-color: rgba(255, 245, 247, var(--border-opacity));\n}\n\n.border-pink-200 {\n  --border-opacity: 1;\n  border-color: #fed7e2;\n  border-color: rgba(254, 215, 226, var(--border-opacity));\n}\n\n.border-pink-300 {\n  --border-opacity: 1;\n  border-color: #fbb6ce;\n  border-color: rgba(251, 182, 206, var(--border-opacity));\n}\n\n.border-pink-400 {\n  --border-opacity: 1;\n  border-color: #f687b3;\n  border-color: rgba(246, 135, 179, var(--border-opacity));\n}\n\n.border-pink-500 {\n  --border-opacity: 1;\n  border-color: #ed64a6;\n  border-color: rgba(237, 100, 166, var(--border-opacity));\n}\n\n.border-pink-600 {\n  --border-opacity: 1;\n  border-color: #d53f8c;\n  border-color: rgba(213, 63, 140, var(--border-opacity));\n}\n\n.border-pink-700 {\n  --border-opacity: 1;\n  border-color: #b83280;\n  border-color: rgba(184, 50, 128, var(--border-opacity));\n}\n\n.border-pink-800 {\n  --border-opacity: 1;\n  border-color: #97266d;\n  border-color: rgba(151, 38, 109, var(--border-opacity));\n}\n\n.border-pink-900 {\n  --border-opacity: 1;\n  border-color: #702459;\n  border-color: rgba(112, 36, 89, var(--border-opacity));\n}\n\n.hover\\:border-transparent:hover {\n  border-color: transparent;\n}\n\n.hover\\:border-current:hover {\n  border-color: currentColor;\n}\n\n.hover\\:border-black:hover {\n  --border-opacity: 1;\n  border-color: #000;\n  border-color: rgba(0, 0, 0, var(--border-opacity));\n}\n\n.hover\\:border-white:hover {\n  --border-opacity: 1;\n  border-color: #fff;\n  border-color: rgba(255, 255, 255, var(--border-opacity));\n}\n\n.hover\\:border-gray-100:hover {\n  --border-opacity: 1;\n  border-color: #f7fafc;\n  border-color: rgba(247, 250, 252, var(--border-opacity));\n}\n\n.hover\\:border-gray-200:hover {\n  --border-opacity: 1;\n  border-color: #edf2f7;\n  border-color: rgba(237, 242, 247, var(--border-opacity));\n}\n\n.hover\\:border-gray-300:hover {\n  --border-opacity: 1;\n  border-color: #e2e8f0;\n  border-color: rgba(226, 232, 240, var(--border-opacity));\n}\n\n.hover\\:border-gray-400:hover {\n  --border-opacity: 1;\n  border-color: #cbd5e0;\n  border-color: rgba(203, 213, 224, var(--border-opacity));\n}\n\n.hover\\:border-gray-500:hover {\n  --border-opacity: 1;\n  border-color: #a0aec0;\n  border-color: rgba(160, 174, 192, var(--border-opacity));\n}\n\n.hover\\:border-gray-600:hover {\n  --border-opacity: 1;\n  border-color: #718096;\n  border-color: rgba(113, 128, 150, var(--border-opacity));\n}\n\n.hover\\:border-gray-700:hover {\n  --border-opacity: 1;\n  border-color: #4a5568;\n  border-color: rgba(74, 85, 104, var(--border-opacity));\n}\n\n.hover\\:border-gray-800:hover {\n  --border-opacity: 1;\n  border-color: #2d3748;\n  border-color: rgba(45, 55, 72, var(--border-opacity));\n}\n\n.hover\\:border-gray-900:hover {\n  --border-opacity: 1;\n  border-color: #1a202c;\n  border-color: rgba(26, 32, 44, var(--border-opacity));\n}\n\n.hover\\:border-red-100:hover {\n  --border-opacity: 1;\n  border-color: #fff5f5;\n  border-color: rgba(255, 245, 245, var(--border-opacity));\n}\n\n.hover\\:border-red-200:hover {\n  --border-opacity: 1;\n  border-color: #fed7d7;\n  border-color: rgba(254, 215, 215, var(--border-opacity));\n}\n\n.hover\\:border-red-300:hover {\n  --border-opacity: 1;\n  border-color: #feb2b2;\n  border-color: rgba(254, 178, 178, var(--border-opacity));\n}\n\n.hover\\:border-red-400:hover {\n  --border-opacity: 1;\n  border-color: #fc8181;\n  border-color: rgba(252, 129, 129, var(--border-opacity));\n}\n\n.hover\\:border-red-500:hover {\n  --border-opacity: 1;\n  border-color: #f56565;\n  border-color: rgba(245, 101, 101, var(--border-opacity));\n}\n\n.hover\\:border-red-600:hover {\n  --border-opacity: 1;\n  border-color: #e53e3e;\n  border-color: rgba(229, 62, 62, var(--border-opacity));\n}\n\n.hover\\:border-red-700:hover {\n  --border-opacity: 1;\n  border-color: #c53030;\n  border-color: rgba(197, 48, 48, var(--border-opacity));\n}\n\n.hover\\:border-red-800:hover {\n  --border-opacity: 1;\n  border-color: #9b2c2c;\n  border-color: rgba(155, 44, 44, var(--border-opacity));\n}\n\n.hover\\:border-red-900:hover {\n  --border-opacity: 1;\n  border-color: #742a2a;\n  border-color: rgba(116, 42, 42, var(--border-opacity));\n}\n\n.hover\\:border-orange-100:hover {\n  --border-opacity: 1;\n  border-color: #fffaf0;\n  border-color: rgba(255, 250, 240, var(--border-opacity));\n}\n\n.hover\\:border-orange-200:hover {\n  --border-opacity: 1;\n  border-color: #feebc8;\n  border-color: rgba(254, 235, 200, var(--border-opacity));\n}\n\n.hover\\:border-orange-300:hover {\n  --border-opacity: 1;\n  border-color: #fbd38d;\n  border-color: rgba(251, 211, 141, var(--border-opacity));\n}\n\n.hover\\:border-orange-400:hover {\n  --border-opacity: 1;\n  border-color: #f6ad55;\n  border-color: rgba(246, 173, 85, var(--border-opacity));\n}\n\n.hover\\:border-orange-500:hover {\n  --border-opacity: 1;\n  border-color: #ed8936;\n  border-color: rgba(237, 137, 54, var(--border-opacity));\n}\n\n.hover\\:border-orange-600:hover {\n  --border-opacity: 1;\n  border-color: #dd6b20;\n  border-color: rgba(221, 107, 32, var(--border-opacity));\n}\n\n.hover\\:border-orange-700:hover {\n  --border-opacity: 1;\n  border-color: #c05621;\n  border-color: rgba(192, 86, 33, var(--border-opacity));\n}\n\n.hover\\:border-orange-800:hover {\n  --border-opacity: 1;\n  border-color: #9c4221;\n  border-color: rgba(156, 66, 33, var(--border-opacity));\n}\n\n.hover\\:border-orange-900:hover {\n  --border-opacity: 1;\n  border-color: #7b341e;\n  border-color: rgba(123, 52, 30, var(--border-opacity));\n}\n\n.hover\\:border-yellow-100:hover {\n  --border-opacity: 1;\n  border-color: #fffff0;\n  border-color: rgba(255, 255, 240, var(--border-opacity));\n}\n\n.hover\\:border-yellow-200:hover {\n  --border-opacity: 1;\n  border-color: #fefcbf;\n  border-color: rgba(254, 252, 191, var(--border-opacity));\n}\n\n.hover\\:border-yellow-300:hover {\n  --border-opacity: 1;\n  border-color: #faf089;\n  border-color: rgba(250, 240, 137, var(--border-opacity));\n}\n\n.hover\\:border-yellow-400:hover {\n  --border-opacity: 1;\n  border-color: #f6e05e;\n  border-color: rgba(246, 224, 94, var(--border-opacity));\n}\n\n.hover\\:border-yellow-500:hover {\n  --border-opacity: 1;\n  border-color: #ecc94b;\n  border-color: rgba(236, 201, 75, var(--border-opacity));\n}\n\n.hover\\:border-yellow-600:hover {\n  --border-opacity: 1;\n  border-color: #d69e2e;\n  border-color: rgba(214, 158, 46, var(--border-opacity));\n}\n\n.hover\\:border-yellow-700:hover {\n  --border-opacity: 1;\n  border-color: #b7791f;\n  border-color: rgba(183, 121, 31, var(--border-opacity));\n}\n\n.hover\\:border-yellow-800:hover {\n  --border-opacity: 1;\n  border-color: #975a16;\n  border-color: rgba(151, 90, 22, var(--border-opacity));\n}\n\n.hover\\:border-yellow-900:hover {\n  --border-opacity: 1;\n  border-color: #744210;\n  border-color: rgba(116, 66, 16, var(--border-opacity));\n}\n\n.hover\\:border-green-100:hover {\n  --border-opacity: 1;\n  border-color: #f0fff4;\n  border-color: rgba(240, 255, 244, var(--border-opacity));\n}\n\n.hover\\:border-green-200:hover {\n  --border-opacity: 1;\n  border-color: #c6f6d5;\n  border-color: rgba(198, 246, 213, var(--border-opacity));\n}\n\n.hover\\:border-green-300:hover {\n  --border-opacity: 1;\n  border-color: #9ae6b4;\n  border-color: rgba(154, 230, 180, var(--border-opacity));\n}\n\n.hover\\:border-green-400:hover {\n  --border-opacity: 1;\n  border-color: #68d391;\n  border-color: rgba(104, 211, 145, var(--border-opacity));\n}\n\n.hover\\:border-green-500:hover {\n  --border-opacity: 1;\n  border-color: #48bb78;\n  border-color: rgba(72, 187, 120, var(--border-opacity));\n}\n\n.hover\\:border-green-600:hover {\n  --border-opacity: 1;\n  border-color: #38a169;\n  border-color: rgba(56, 161, 105, var(--border-opacity));\n}\n\n.hover\\:border-green-700:hover {\n  --border-opacity: 1;\n  border-color: #2f855a;\n  border-color: rgba(47, 133, 90, var(--border-opacity));\n}\n\n.hover\\:border-green-800:hover {\n  --border-opacity: 1;\n  border-color: #276749;\n  border-color: rgba(39, 103, 73, var(--border-opacity));\n}\n\n.hover\\:border-green-900:hover {\n  --border-opacity: 1;\n  border-color: #22543d;\n  border-color: rgba(34, 84, 61, var(--border-opacity));\n}\n\n.hover\\:border-teal-100:hover {\n  --border-opacity: 1;\n  border-color: #e6fffa;\n  border-color: rgba(230, 255, 250, var(--border-opacity));\n}\n\n.hover\\:border-teal-200:hover {\n  --border-opacity: 1;\n  border-color: #b2f5ea;\n  border-color: rgba(178, 245, 234, var(--border-opacity));\n}\n\n.hover\\:border-teal-300:hover {\n  --border-opacity: 1;\n  border-color: #81e6d9;\n  border-color: rgba(129, 230, 217, var(--border-opacity));\n}\n\n.hover\\:border-teal-400:hover {\n  --border-opacity: 1;\n  border-color: #4fd1c5;\n  border-color: rgba(79, 209, 197, var(--border-opacity));\n}\n\n.hover\\:border-teal-500:hover {\n  --border-opacity: 1;\n  border-color: #38b2ac;\n  border-color: rgba(56, 178, 172, var(--border-opacity));\n}\n\n.hover\\:border-teal-600:hover {\n  --border-opacity: 1;\n  border-color: #319795;\n  border-color: rgba(49, 151, 149, var(--border-opacity));\n}\n\n.hover\\:border-teal-700:hover {\n  --border-opacity: 1;\n  border-color: #2c7a7b;\n  border-color: rgba(44, 122, 123, var(--border-opacity));\n}\n\n.hover\\:border-teal-800:hover {\n  --border-opacity: 1;\n  border-color: #285e61;\n  border-color: rgba(40, 94, 97, var(--border-opacity));\n}\n\n.hover\\:border-teal-900:hover {\n  --border-opacity: 1;\n  border-color: #234e52;\n  border-color: rgba(35, 78, 82, var(--border-opacity));\n}\n\n.hover\\:border-blue-100:hover {\n  --border-opacity: 1;\n  border-color: #ebf8ff;\n  border-color: rgba(235, 248, 255, var(--border-opacity));\n}\n\n.hover\\:border-blue-200:hover {\n  --border-opacity: 1;\n  border-color: #bee3f8;\n  border-color: rgba(190, 227, 248, var(--border-opacity));\n}\n\n.hover\\:border-blue-300:hover {\n  --border-opacity: 1;\n  border-color: #90cdf4;\n  border-color: rgba(144, 205, 244, var(--border-opacity));\n}\n\n.hover\\:border-blue-400:hover {\n  --border-opacity: 1;\n  border-color: #63b3ed;\n  border-color: rgba(99, 179, 237, var(--border-opacity));\n}\n\n.hover\\:border-blue-500:hover {\n  --border-opacity: 1;\n  border-color: #4299e1;\n  border-color: rgba(66, 153, 225, var(--border-opacity));\n}\n\n.hover\\:border-blue-600:hover {\n  --border-opacity: 1;\n  border-color: #3182ce;\n  border-color: rgba(49, 130, 206, var(--border-opacity));\n}\n\n.hover\\:border-blue-700:hover {\n  --border-opacity: 1;\n  border-color: #2b6cb0;\n  border-color: rgba(43, 108, 176, var(--border-opacity));\n}\n\n.hover\\:border-blue-800:hover {\n  --border-opacity: 1;\n  border-color: #2c5282;\n  border-color: rgba(44, 82, 130, var(--border-opacity));\n}\n\n.hover\\:border-blue-900:hover {\n  --border-opacity: 1;\n  border-color: #2a4365;\n  border-color: rgba(42, 67, 101, var(--border-opacity));\n}\n\n.hover\\:border-indigo-100:hover {\n  --border-opacity: 1;\n  border-color: #ebf4ff;\n  border-color: rgba(235, 244, 255, var(--border-opacity));\n}\n\n.hover\\:border-indigo-200:hover {\n  --border-opacity: 1;\n  border-color: #c3dafe;\n  border-color: rgba(195, 218, 254, var(--border-opacity));\n}\n\n.hover\\:border-indigo-300:hover {\n  --border-opacity: 1;\n  border-color: #a3bffa;\n  border-color: rgba(163, 191, 250, var(--border-opacity));\n}\n\n.hover\\:border-indigo-400:hover {\n  --border-opacity: 1;\n  border-color: #7f9cf5;\n  border-color: rgba(127, 156, 245, var(--border-opacity));\n}\n\n.hover\\:border-indigo-500:hover {\n  --border-opacity: 1;\n  border-color: #667eea;\n  border-color: rgba(102, 126, 234, var(--border-opacity));\n}\n\n.hover\\:border-indigo-600:hover {\n  --border-opacity: 1;\n  border-color: #5a67d8;\n  border-color: rgba(90, 103, 216, var(--border-opacity));\n}\n\n.hover\\:border-indigo-700:hover {\n  --border-opacity: 1;\n  border-color: #4c51bf;\n  border-color: rgba(76, 81, 191, var(--border-opacity));\n}\n\n.hover\\:border-indigo-800:hover {\n  --border-opacity: 1;\n  border-color: #434190;\n  border-color: rgba(67, 65, 144, var(--border-opacity));\n}\n\n.hover\\:border-indigo-900:hover {\n  --border-opacity: 1;\n  border-color: #3c366b;\n  border-color: rgba(60, 54, 107, var(--border-opacity));\n}\n\n.hover\\:border-purple-100:hover {\n  --border-opacity: 1;\n  border-color: #faf5ff;\n  border-color: rgba(250, 245, 255, var(--border-opacity));\n}\n\n.hover\\:border-purple-200:hover {\n  --border-opacity: 1;\n  border-color: #e9d8fd;\n  border-color: rgba(233, 216, 253, var(--border-opacity));\n}\n\n.hover\\:border-purple-300:hover {\n  --border-opacity: 1;\n  border-color: #d6bcfa;\n  border-color: rgba(214, 188, 250, var(--border-opacity));\n}\n\n.hover\\:border-purple-400:hover {\n  --border-opacity: 1;\n  border-color: #b794f4;\n  border-color: rgba(183, 148, 244, var(--border-opacity));\n}\n\n.hover\\:border-purple-500:hover {\n  --border-opacity: 1;\n  border-color: #9f7aea;\n  border-color: rgba(159, 122, 234, var(--border-opacity));\n}\n\n.hover\\:border-purple-600:hover {\n  --border-opacity: 1;\n  border-color: #805ad5;\n  border-color: rgba(128, 90, 213, var(--border-opacity));\n}\n\n.hover\\:border-purple-700:hover {\n  --border-opacity: 1;\n  border-color: #6b46c1;\n  border-color: rgba(107, 70, 193, var(--border-opacity));\n}\n\n.hover\\:border-purple-800:hover {\n  --border-opacity: 1;\n  border-color: #553c9a;\n  border-color: rgba(85, 60, 154, var(--border-opacity));\n}\n\n.hover\\:border-purple-900:hover {\n  --border-opacity: 1;\n  border-color: #44337a;\n  border-color: rgba(68, 51, 122, var(--border-opacity));\n}\n\n.hover\\:border-pink-100:hover {\n  --border-opacity: 1;\n  border-color: #fff5f7;\n  border-color: rgba(255, 245, 247, var(--border-opacity));\n}\n\n.hover\\:border-pink-200:hover {\n  --border-opacity: 1;\n  border-color: #fed7e2;\n  border-color: rgba(254, 215, 226, var(--border-opacity));\n}\n\n.hover\\:border-pink-300:hover {\n  --border-opacity: 1;\n  border-color: #fbb6ce;\n  border-color: rgba(251, 182, 206, var(--border-opacity));\n}\n\n.hover\\:border-pink-400:hover {\n  --border-opacity: 1;\n  border-color: #f687b3;\n  border-color: rgba(246, 135, 179, var(--border-opacity));\n}\n\n.hover\\:border-pink-500:hover {\n  --border-opacity: 1;\n  border-color: #ed64a6;\n  border-color: rgba(237, 100, 166, var(--border-opacity));\n}\n\n.hover\\:border-pink-600:hover {\n  --border-opacity: 1;\n  border-color: #d53f8c;\n  border-color: rgba(213, 63, 140, var(--border-opacity));\n}\n\n.hover\\:border-pink-700:hover {\n  --border-opacity: 1;\n  border-color: #b83280;\n  border-color: rgba(184, 50, 128, var(--border-opacity));\n}\n\n.hover\\:border-pink-800:hover {\n  --border-opacity: 1;\n  border-color: #97266d;\n  border-color: rgba(151, 38, 109, var(--border-opacity));\n}\n\n.hover\\:border-pink-900:hover {\n  --border-opacity: 1;\n  border-color: #702459;\n  border-color: rgba(112, 36, 89, var(--border-opacity));\n}\n\n.focus\\:border-transparent:focus {\n  border-color: transparent;\n}\n\n.focus\\:border-current:focus {\n  border-color: currentColor;\n}\n\n.focus\\:border-black:focus {\n  --border-opacity: 1;\n  border-color: #000;\n  border-color: rgba(0, 0, 0, var(--border-opacity));\n}\n\n.focus\\:border-white:focus {\n  --border-opacity: 1;\n  border-color: #fff;\n  border-color: rgba(255, 255, 255, var(--border-opacity));\n}\n\n.focus\\:border-gray-100:focus {\n  --border-opacity: 1;\n  border-color: #f7fafc;\n  border-color: rgba(247, 250, 252, var(--border-opacity));\n}\n\n.focus\\:border-gray-200:focus {\n  --border-opacity: 1;\n  border-color: #edf2f7;\n  border-color: rgba(237, 242, 247, var(--border-opacity));\n}\n\n.focus\\:border-gray-300:focus {\n  --border-opacity: 1;\n  border-color: #e2e8f0;\n  border-color: rgba(226, 232, 240, var(--border-opacity));\n}\n\n.focus\\:border-gray-400:focus {\n  --border-opacity: 1;\n  border-color: #cbd5e0;\n  border-color: rgba(203, 213, 224, var(--border-opacity));\n}\n\n.focus\\:border-gray-500:focus {\n  --border-opacity: 1;\n  border-color: #a0aec0;\n  border-color: rgba(160, 174, 192, var(--border-opacity));\n}\n\n.focus\\:border-gray-600:focus {\n  --border-opacity: 1;\n  border-color: #718096;\n  border-color: rgba(113, 128, 150, var(--border-opacity));\n}\n\n.focus\\:border-gray-700:focus {\n  --border-opacity: 1;\n  border-color: #4a5568;\n  border-color: rgba(74, 85, 104, var(--border-opacity));\n}\n\n.focus\\:border-gray-800:focus {\n  --border-opacity: 1;\n  border-color: #2d3748;\n  border-color: rgba(45, 55, 72, var(--border-opacity));\n}\n\n.focus\\:border-gray-900:focus {\n  --border-opacity: 1;\n  border-color: #1a202c;\n  border-color: rgba(26, 32, 44, var(--border-opacity));\n}\n\n.focus\\:border-red-100:focus {\n  --border-opacity: 1;\n  border-color: #fff5f5;\n  border-color: rgba(255, 245, 245, var(--border-opacity));\n}\n\n.focus\\:border-red-200:focus {\n  --border-opacity: 1;\n  border-color: #fed7d7;\n  border-color: rgba(254, 215, 215, var(--border-opacity));\n}\n\n.focus\\:border-red-300:focus {\n  --border-opacity: 1;\n  border-color: #feb2b2;\n  border-color: rgba(254, 178, 178, var(--border-opacity));\n}\n\n.focus\\:border-red-400:focus {\n  --border-opacity: 1;\n  border-color: #fc8181;\n  border-color: rgba(252, 129, 129, var(--border-opacity));\n}\n\n.focus\\:border-red-500:focus {\n  --border-opacity: 1;\n  border-color: #f56565;\n  border-color: rgba(245, 101, 101, var(--border-opacity));\n}\n\n.focus\\:border-red-600:focus {\n  --border-opacity: 1;\n  border-color: #e53e3e;\n  border-color: rgba(229, 62, 62, var(--border-opacity));\n}\n\n.focus\\:border-red-700:focus {\n  --border-opacity: 1;\n  border-color: #c53030;\n  border-color: rgba(197, 48, 48, var(--border-opacity));\n}\n\n.focus\\:border-red-800:focus {\n  --border-opacity: 1;\n  border-color: #9b2c2c;\n  border-color: rgba(155, 44, 44, var(--border-opacity));\n}\n\n.focus\\:border-red-900:focus {\n  --border-opacity: 1;\n  border-color: #742a2a;\n  border-color: rgba(116, 42, 42, var(--border-opacity));\n}\n\n.focus\\:border-orange-100:focus {\n  --border-opacity: 1;\n  border-color: #fffaf0;\n  border-color: rgba(255, 250, 240, var(--border-opacity));\n}\n\n.focus\\:border-orange-200:focus {\n  --border-opacity: 1;\n  border-color: #feebc8;\n  border-color: rgba(254, 235, 200, var(--border-opacity));\n}\n\n.focus\\:border-orange-300:focus {\n  --border-opacity: 1;\n  border-color: #fbd38d;\n  border-color: rgba(251, 211, 141, var(--border-opacity));\n}\n\n.focus\\:border-orange-400:focus {\n  --border-opacity: 1;\n  border-color: #f6ad55;\n  border-color: rgba(246, 173, 85, var(--border-opacity));\n}\n\n.focus\\:border-orange-500:focus {\n  --border-opacity: 1;\n  border-color: #ed8936;\n  border-color: rgba(237, 137, 54, var(--border-opacity));\n}\n\n.focus\\:border-orange-600:focus {\n  --border-opacity: 1;\n  border-color: #dd6b20;\n  border-color: rgba(221, 107, 32, var(--border-opacity));\n}\n\n.focus\\:border-orange-700:focus {\n  --border-opacity: 1;\n  border-color: #c05621;\n  border-color: rgba(192, 86, 33, var(--border-opacity));\n}\n\n.focus\\:border-orange-800:focus {\n  --border-opacity: 1;\n  border-color: #9c4221;\n  border-color: rgba(156, 66, 33, var(--border-opacity));\n}\n\n.focus\\:border-orange-900:focus {\n  --border-opacity: 1;\n  border-color: #7b341e;\n  border-color: rgba(123, 52, 30, var(--border-opacity));\n}\n\n.focus\\:border-yellow-100:focus {\n  --border-opacity: 1;\n  border-color: #fffff0;\n  border-color: rgba(255, 255, 240, var(--border-opacity));\n}\n\n.focus\\:border-yellow-200:focus {\n  --border-opacity: 1;\n  border-color: #fefcbf;\n  border-color: rgba(254, 252, 191, var(--border-opacity));\n}\n\n.focus\\:border-yellow-300:focus {\n  --border-opacity: 1;\n  border-color: #faf089;\n  border-color: rgba(250, 240, 137, var(--border-opacity));\n}\n\n.focus\\:border-yellow-400:focus {\n  --border-opacity: 1;\n  border-color: #f6e05e;\n  border-color: rgba(246, 224, 94, var(--border-opacity));\n}\n\n.focus\\:border-yellow-500:focus {\n  --border-opacity: 1;\n  border-color: #ecc94b;\n  border-color: rgba(236, 201, 75, var(--border-opacity));\n}\n\n.focus\\:border-yellow-600:focus {\n  --border-opacity: 1;\n  border-color: #d69e2e;\n  border-color: rgba(214, 158, 46, var(--border-opacity));\n}\n\n.focus\\:border-yellow-700:focus {\n  --border-opacity: 1;\n  border-color: #b7791f;\n  border-color: rgba(183, 121, 31, var(--border-opacity));\n}\n\n.focus\\:border-yellow-800:focus {\n  --border-opacity: 1;\n  border-color: #975a16;\n  border-color: rgba(151, 90, 22, var(--border-opacity));\n}\n\n.focus\\:border-yellow-900:focus {\n  --border-opacity: 1;\n  border-color: #744210;\n  border-color: rgba(116, 66, 16, var(--border-opacity));\n}\n\n.focus\\:border-green-100:focus {\n  --border-opacity: 1;\n  border-color: #f0fff4;\n  border-color: rgba(240, 255, 244, var(--border-opacity));\n}\n\n.focus\\:border-green-200:focus {\n  --border-opacity: 1;\n  border-color: #c6f6d5;\n  border-color: rgba(198, 246, 213, var(--border-opacity));\n}\n\n.focus\\:border-green-300:focus {\n  --border-opacity: 1;\n  border-color: #9ae6b4;\n  border-color: rgba(154, 230, 180, var(--border-opacity));\n}\n\n.focus\\:border-green-400:focus {\n  --border-opacity: 1;\n  border-color: #68d391;\n  border-color: rgba(104, 211, 145, var(--border-opacity));\n}\n\n.focus\\:border-green-500:focus {\n  --border-opacity: 1;\n  border-color: #48bb78;\n  border-color: rgba(72, 187, 120, var(--border-opacity));\n}\n\n.focus\\:border-green-600:focus {\n  --border-opacity: 1;\n  border-color: #38a169;\n  border-color: rgba(56, 161, 105, var(--border-opacity));\n}\n\n.focus\\:border-green-700:focus {\n  --border-opacity: 1;\n  border-color: #2f855a;\n  border-color: rgba(47, 133, 90, var(--border-opacity));\n}\n\n.focus\\:border-green-800:focus {\n  --border-opacity: 1;\n  border-color: #276749;\n  border-color: rgba(39, 103, 73, var(--border-opacity));\n}\n\n.focus\\:border-green-900:focus {\n  --border-opacity: 1;\n  border-color: #22543d;\n  border-color: rgba(34, 84, 61, var(--border-opacity));\n}\n\n.focus\\:border-teal-100:focus {\n  --border-opacity: 1;\n  border-color: #e6fffa;\n  border-color: rgba(230, 255, 250, var(--border-opacity));\n}\n\n.focus\\:border-teal-200:focus {\n  --border-opacity: 1;\n  border-color: #b2f5ea;\n  border-color: rgba(178, 245, 234, var(--border-opacity));\n}\n\n.focus\\:border-teal-300:focus {\n  --border-opacity: 1;\n  border-color: #81e6d9;\n  border-color: rgba(129, 230, 217, var(--border-opacity));\n}\n\n.focus\\:border-teal-400:focus {\n  --border-opacity: 1;\n  border-color: #4fd1c5;\n  border-color: rgba(79, 209, 197, var(--border-opacity));\n}\n\n.focus\\:border-teal-500:focus {\n  --border-opacity: 1;\n  border-color: #38b2ac;\n  border-color: rgba(56, 178, 172, var(--border-opacity));\n}\n\n.focus\\:border-teal-600:focus {\n  --border-opacity: 1;\n  border-color: #319795;\n  border-color: rgba(49, 151, 149, var(--border-opacity));\n}\n\n.focus\\:border-teal-700:focus {\n  --border-opacity: 1;\n  border-color: #2c7a7b;\n  border-color: rgba(44, 122, 123, var(--border-opacity));\n}\n\n.focus\\:border-teal-800:focus {\n  --border-opacity: 1;\n  border-color: #285e61;\n  border-color: rgba(40, 94, 97, var(--border-opacity));\n}\n\n.focus\\:border-teal-900:focus {\n  --border-opacity: 1;\n  border-color: #234e52;\n  border-color: rgba(35, 78, 82, var(--border-opacity));\n}\n\n.focus\\:border-blue-100:focus {\n  --border-opacity: 1;\n  border-color: #ebf8ff;\n  border-color: rgba(235, 248, 255, var(--border-opacity));\n}\n\n.focus\\:border-blue-200:focus {\n  --border-opacity: 1;\n  border-color: #bee3f8;\n  border-color: rgba(190, 227, 248, var(--border-opacity));\n}\n\n.focus\\:border-blue-300:focus {\n  --border-opacity: 1;\n  border-color: #90cdf4;\n  border-color: rgba(144, 205, 244, var(--border-opacity));\n}\n\n.focus\\:border-blue-400:focus {\n  --border-opacity: 1;\n  border-color: #63b3ed;\n  border-color: rgba(99, 179, 237, var(--border-opacity));\n}\n\n.focus\\:border-blue-500:focus {\n  --border-opacity: 1;\n  border-color: #4299e1;\n  border-color: rgba(66, 153, 225, var(--border-opacity));\n}\n\n.focus\\:border-blue-600:focus {\n  --border-opacity: 1;\n  border-color: #3182ce;\n  border-color: rgba(49, 130, 206, var(--border-opacity));\n}\n\n.focus\\:border-blue-700:focus {\n  --border-opacity: 1;\n  border-color: #2b6cb0;\n  border-color: rgba(43, 108, 176, var(--border-opacity));\n}\n\n.focus\\:border-blue-800:focus {\n  --border-opacity: 1;\n  border-color: #2c5282;\n  border-color: rgba(44, 82, 130, var(--border-opacity));\n}\n\n.focus\\:border-blue-900:focus {\n  --border-opacity: 1;\n  border-color: #2a4365;\n  border-color: rgba(42, 67, 101, var(--border-opacity));\n}\n\n.focus\\:border-indigo-100:focus {\n  --border-opacity: 1;\n  border-color: #ebf4ff;\n  border-color: rgba(235, 244, 255, var(--border-opacity));\n}\n\n.focus\\:border-indigo-200:focus {\n  --border-opacity: 1;\n  border-color: #c3dafe;\n  border-color: rgba(195, 218, 254, var(--border-opacity));\n}\n\n.focus\\:border-indigo-300:focus {\n  --border-opacity: 1;\n  border-color: #a3bffa;\n  border-color: rgba(163, 191, 250, var(--border-opacity));\n}\n\n.focus\\:border-indigo-400:focus {\n  --border-opacity: 1;\n  border-color: #7f9cf5;\n  border-color: rgba(127, 156, 245, var(--border-opacity));\n}\n\n.focus\\:border-indigo-500:focus {\n  --border-opacity: 1;\n  border-color: #667eea;\n  border-color: rgba(102, 126, 234, var(--border-opacity));\n}\n\n.focus\\:border-indigo-600:focus {\n  --border-opacity: 1;\n  border-color: #5a67d8;\n  border-color: rgba(90, 103, 216, var(--border-opacity));\n}\n\n.focus\\:border-indigo-700:focus {\n  --border-opacity: 1;\n  border-color: #4c51bf;\n  border-color: rgba(76, 81, 191, var(--border-opacity));\n}\n\n.focus\\:border-indigo-800:focus {\n  --border-opacity: 1;\n  border-color: #434190;\n  border-color: rgba(67, 65, 144, var(--border-opacity));\n}\n\n.focus\\:border-indigo-900:focus {\n  --border-opacity: 1;\n  border-color: #3c366b;\n  border-color: rgba(60, 54, 107, var(--border-opacity));\n}\n\n.focus\\:border-purple-100:focus {\n  --border-opacity: 1;\n  border-color: #faf5ff;\n  border-color: rgba(250, 245, 255, var(--border-opacity));\n}\n\n.focus\\:border-purple-200:focus {\n  --border-opacity: 1;\n  border-color: #e9d8fd;\n  border-color: rgba(233, 216, 253, var(--border-opacity));\n}\n\n.focus\\:border-purple-300:focus {\n  --border-opacity: 1;\n  border-color: #d6bcfa;\n  border-color: rgba(214, 188, 250, var(--border-opacity));\n}\n\n.focus\\:border-purple-400:focus {\n  --border-opacity: 1;\n  border-color: #b794f4;\n  border-color: rgba(183, 148, 244, var(--border-opacity));\n}\n\n.focus\\:border-purple-500:focus {\n  --border-opacity: 1;\n  border-color: #9f7aea;\n  border-color: rgba(159, 122, 234, var(--border-opacity));\n}\n\n.focus\\:border-purple-600:focus {\n  --border-opacity: 1;\n  border-color: #805ad5;\n  border-color: rgba(128, 90, 213, var(--border-opacity));\n}\n\n.focus\\:border-purple-700:focus {\n  --border-opacity: 1;\n  border-color: #6b46c1;\n  border-color: rgba(107, 70, 193, var(--border-opacity));\n}\n\n.focus\\:border-purple-800:focus {\n  --border-opacity: 1;\n  border-color: #553c9a;\n  border-color: rgba(85, 60, 154, var(--border-opacity));\n}\n\n.focus\\:border-purple-900:focus {\n  --border-opacity: 1;\n  border-color: #44337a;\n  border-color: rgba(68, 51, 122, var(--border-opacity));\n}\n\n.focus\\:border-pink-100:focus {\n  --border-opacity: 1;\n  border-color: #fff5f7;\n  border-color: rgba(255, 245, 247, var(--border-opacity));\n}\n\n.focus\\:border-pink-200:focus {\n  --border-opacity: 1;\n  border-color: #fed7e2;\n  border-color: rgba(254, 215, 226, var(--border-opacity));\n}\n\n.focus\\:border-pink-300:focus {\n  --border-opacity: 1;\n  border-color: #fbb6ce;\n  border-color: rgba(251, 182, 206, var(--border-opacity));\n}\n\n.focus\\:border-pink-400:focus {\n  --border-opacity: 1;\n  border-color: #f687b3;\n  border-color: rgba(246, 135, 179, var(--border-opacity));\n}\n\n.focus\\:border-pink-500:focus {\n  --border-opacity: 1;\n  border-color: #ed64a6;\n  border-color: rgba(237, 100, 166, var(--border-opacity));\n}\n\n.focus\\:border-pink-600:focus {\n  --border-opacity: 1;\n  border-color: #d53f8c;\n  border-color: rgba(213, 63, 140, var(--border-opacity));\n}\n\n.focus\\:border-pink-700:focus {\n  --border-opacity: 1;\n  border-color: #b83280;\n  border-color: rgba(184, 50, 128, var(--border-opacity));\n}\n\n.focus\\:border-pink-800:focus {\n  --border-opacity: 1;\n  border-color: #97266d;\n  border-color: rgba(151, 38, 109, var(--border-opacity));\n}\n\n.focus\\:border-pink-900:focus {\n  --border-opacity: 1;\n  border-color: #702459;\n  border-color: rgba(112, 36, 89, var(--border-opacity));\n}\n\n.border-opacity-0 {\n  --border-opacity: 0;\n}\n\n.border-opacity-25 {\n  --border-opacity: 0.25;\n}\n\n.border-opacity-50 {\n  --border-opacity: 0.5;\n}\n\n.border-opacity-75 {\n  --border-opacity: 0.75;\n}\n\n.border-opacity-100 {\n  --border-opacity: 1;\n}\n\n.hover\\:border-opacity-0:hover {\n  --border-opacity: 0;\n}\n\n.hover\\:border-opacity-25:hover {\n  --border-opacity: 0.25;\n}\n\n.hover\\:border-opacity-50:hover {\n  --border-opacity: 0.5;\n}\n\n.hover\\:border-opacity-75:hover {\n  --border-opacity: 0.75;\n}\n\n.hover\\:border-opacity-100:hover {\n  --border-opacity: 1;\n}\n\n.focus\\:border-opacity-0:focus {\n  --border-opacity: 0;\n}\n\n.focus\\:border-opacity-25:focus {\n  --border-opacity: 0.25;\n}\n\n.focus\\:border-opacity-50:focus {\n  --border-opacity: 0.5;\n}\n\n.focus\\:border-opacity-75:focus {\n  --border-opacity: 0.75;\n}\n\n.focus\\:border-opacity-100:focus {\n  --border-opacity: 1;\n}\n\n.rounded-none {\n  border-radius: 0;\n}\n\n.rounded-sm {\n  border-radius: 0.125rem;\n}\n\n.rounded {\n  border-radius: 0.25rem;\n}\n\n.rounded-md {\n  border-radius: 0.375rem;\n}\n\n.rounded-lg {\n  border-radius: 0.5rem;\n}\n\n.rounded-xl {\n  border-radius: 0.75rem;\n}\n\n.rounded-2xl {\n  border-radius: 1rem;\n}\n\n.rounded-3xl {\n  border-radius: 1.5rem;\n}\n\n.rounded-full {\n  border-radius: 9999px;\n}\n\n.rounded-t-none {\n  border-top-left-radius: 0;\n  border-top-right-radius: 0;\n}\n\n.rounded-r-none {\n  border-top-right-radius: 0;\n  border-bottom-right-radius: 0;\n}\n\n.rounded-b-none {\n  border-bottom-right-radius: 0;\n  border-bottom-left-radius: 0;\n}\n\n.rounded-l-none {\n  border-top-left-radius: 0;\n  border-bottom-left-radius: 0;\n}\n\n.rounded-t-sm {\n  border-top-left-radius: 0.125rem;\n  border-top-right-radius: 0.125rem;\n}\n\n.rounded-r-sm {\n  border-top-right-radius: 0.125rem;\n  border-bottom-right-radius: 0.125rem;\n}\n\n.rounded-b-sm {\n  border-bottom-right-radius: 0.125rem;\n  border-bottom-left-radius: 0.125rem;\n}\n\n.rounded-l-sm {\n  border-top-left-radius: 0.125rem;\n  border-bottom-left-radius: 0.125rem;\n}\n\n.rounded-t {\n  border-top-left-radius: 0.25rem;\n  border-top-right-radius: 0.25rem;\n}\n\n.rounded-r {\n  border-top-right-radius: 0.25rem;\n  border-bottom-right-radius: 0.25rem;\n}\n\n.rounded-b {\n  border-bottom-right-radius: 0.25rem;\n  border-bottom-left-radius: 0.25rem;\n}\n\n.rounded-l {\n  border-top-left-radius: 0.25rem;\n  border-bottom-left-radius: 0.25rem;\n}\n\n.rounded-t-md {\n  border-top-left-radius: 0.375rem;\n  border-top-right-radius: 0.375rem;\n}\n\n.rounded-r-md {\n  border-top-right-radius: 0.375rem;\n  border-bottom-right-radius: 0.375rem;\n}\n\n.rounded-b-md {\n  border-bottom-right-radius: 0.375rem;\n  border-bottom-left-radius: 0.375rem;\n}\n\n.rounded-l-md {\n  border-top-left-radius: 0.375rem;\n  border-bottom-left-radius: 0.375rem;\n}\n\n.rounded-t-lg {\n  border-top-left-radius: 0.5rem;\n  border-top-right-radius: 0.5rem;\n}\n\n.rounded-r-lg {\n  border-top-right-radius: 0.5rem;\n  border-bottom-right-radius: 0.5rem;\n}\n\n.rounded-b-lg {\n  border-bottom-right-radius: 0.5rem;\n  border-bottom-left-radius: 0.5rem;\n}\n\n.rounded-l-lg {\n  border-top-left-radius: 0.5rem;\n  border-bottom-left-radius: 0.5rem;\n}\n\n.rounded-t-xl {\n  border-top-left-radius: 0.75rem;\n  border-top-right-radius: 0.75rem;\n}\n\n.rounded-r-xl {\n  border-top-right-radius: 0.75rem;\n  border-bottom-right-radius: 0.75rem;\n}\n\n.rounded-b-xl {\n  border-bottom-right-radius: 0.75rem;\n  border-bottom-left-radius: 0.75rem;\n}\n\n.rounded-l-xl {\n  border-top-left-radius: 0.75rem;\n  border-bottom-left-radius: 0.75rem;\n}\n\n.rounded-t-2xl {\n  border-top-left-radius: 1rem;\n  border-top-right-radius: 1rem;\n}\n\n.rounded-r-2xl {\n  border-top-right-radius: 1rem;\n  border-bottom-right-radius: 1rem;\n}\n\n.rounded-b-2xl {\n  border-bottom-right-radius: 1rem;\n  border-bottom-left-radius: 1rem;\n}\n\n.rounded-l-2xl {\n  border-top-left-radius: 1rem;\n  border-bottom-left-radius: 1rem;\n}\n\n.rounded-t-3xl {\n  border-top-left-radius: 1.5rem;\n  border-top-right-radius: 1.5rem;\n}\n\n.rounded-r-3xl {\n  border-top-right-radius: 1.5rem;\n  border-bottom-right-radius: 1.5rem;\n}\n\n.rounded-b-3xl {\n  border-bottom-right-radius: 1.5rem;\n  border-bottom-left-radius: 1.5rem;\n}\n\n.rounded-l-3xl {\n  border-top-left-radius: 1.5rem;\n  border-bottom-left-radius: 1.5rem;\n}\n\n.rounded-t-full {\n  border-top-left-radius: 9999px;\n  border-top-right-radius: 9999px;\n}\n\n.rounded-r-full {\n  border-top-right-radius: 9999px;\n  border-bottom-right-radius: 9999px;\n}\n\n.rounded-b-full {\n  border-bottom-right-radius: 9999px;\n  border-bottom-left-radius: 9999px;\n}\n\n.rounded-l-full {\n  border-top-left-radius: 9999px;\n  border-bottom-left-radius: 9999px;\n}\n\n.rounded-tl-none {\n  border-top-left-radius: 0;\n}\n\n.rounded-tr-none {\n  border-top-right-radius: 0;\n}\n\n.rounded-br-none {\n  border-bottom-right-radius: 0;\n}\n\n.rounded-bl-none {\n  border-bottom-left-radius: 0;\n}\n\n.rounded-tl-sm {\n  border-top-left-radius: 0.125rem;\n}\n\n.rounded-tr-sm {\n  border-top-right-radius: 0.125rem;\n}\n\n.rounded-br-sm {\n  border-bottom-right-radius: 0.125rem;\n}\n\n.rounded-bl-sm {\n  border-bottom-left-radius: 0.125rem;\n}\n\n.rounded-tl {\n  border-top-left-radius: 0.25rem;\n}\n\n.rounded-tr {\n  border-top-right-radius: 0.25rem;\n}\n\n.rounded-br {\n  border-bottom-right-radius: 0.25rem;\n}\n\n.rounded-bl {\n  border-bottom-left-radius: 0.25rem;\n}\n\n.rounded-tl-md {\n  border-top-left-radius: 0.375rem;\n}\n\n.rounded-tr-md {\n  border-top-right-radius: 0.375rem;\n}\n\n.rounded-br-md {\n  border-bottom-right-radius: 0.375rem;\n}\n\n.rounded-bl-md {\n  border-bottom-left-radius: 0.375rem;\n}\n\n.rounded-tl-lg {\n  border-top-left-radius: 0.5rem;\n}\n\n.rounded-tr-lg {\n  border-top-right-radius: 0.5rem;\n}\n\n.rounded-br-lg {\n  border-bottom-right-radius: 0.5rem;\n}\n\n.rounded-bl-lg {\n  border-bottom-left-radius: 0.5rem;\n}\n\n.rounded-tl-xl {\n  border-top-left-radius: 0.75rem;\n}\n\n.rounded-tr-xl {\n  border-top-right-radius: 0.75rem;\n}\n\n.rounded-br-xl {\n  border-bottom-right-radius: 0.75rem;\n}\n\n.rounded-bl-xl {\n  border-bottom-left-radius: 0.75rem;\n}\n\n.rounded-tl-2xl {\n  border-top-left-radius: 1rem;\n}\n\n.rounded-tr-2xl {\n  border-top-right-radius: 1rem;\n}\n\n.rounded-br-2xl {\n  border-bottom-right-radius: 1rem;\n}\n\n.rounded-bl-2xl {\n  border-bottom-left-radius: 1rem;\n}\n\n.rounded-tl-3xl {\n  border-top-left-radius: 1.5rem;\n}\n\n.rounded-tr-3xl {\n  border-top-right-radius: 1.5rem;\n}\n\n.rounded-br-3xl {\n  border-bottom-right-radius: 1.5rem;\n}\n\n.rounded-bl-3xl {\n  border-bottom-left-radius: 1.5rem;\n}\n\n.rounded-tl-full {\n  border-top-left-radius: 9999px;\n}\n\n.rounded-tr-full {\n  border-top-right-radius: 9999px;\n}\n\n.rounded-br-full {\n  border-bottom-right-radius: 9999px;\n}\n\n.rounded-bl-full {\n  border-bottom-left-radius: 9999px;\n}\n\n.border-solid {\n  border-style: solid;\n}\n\n.border-dashed {\n  border-style: dashed;\n}\n\n.border-dotted {\n  border-style: dotted;\n}\n\n.border-double {\n  border-style: double;\n}\n\n.border-none {\n  border-style: none;\n}\n\n.border-0 {\n  border-width: 0;\n}\n\n.border-2 {\n  border-width: 2px;\n}\n\n.border-4 {\n  border-width: 4px;\n}\n\n.border-8 {\n  border-width: 8px;\n}\n\n.border {\n  border-width: 1px;\n}\n\n.border-t-0 {\n  border-top-width: 0;\n}\n\n.border-r-0 {\n  border-right-width: 0;\n}\n\n.border-b-0 {\n  border-bottom-width: 0;\n}\n\n.border-l-0 {\n  border-left-width: 0;\n}\n\n.border-t-2 {\n  border-top-width: 2px;\n}\n\n.border-r-2 {\n  border-right-width: 2px;\n}\n\n.border-b-2 {\n  border-bottom-width: 2px;\n}\n\n.border-l-2 {\n  border-left-width: 2px;\n}\n\n.border-t-4 {\n  border-top-width: 4px;\n}\n\n.border-r-4 {\n  border-right-width: 4px;\n}\n\n.border-b-4 {\n  border-bottom-width: 4px;\n}\n\n.border-l-4 {\n  border-left-width: 4px;\n}\n\n.border-t-8 {\n  border-top-width: 8px;\n}\n\n.border-r-8 {\n  border-right-width: 8px;\n}\n\n.border-b-8 {\n  border-bottom-width: 8px;\n}\n\n.border-l-8 {\n  border-left-width: 8px;\n}\n\n.border-t {\n  border-top-width: 1px;\n}\n\n.border-r {\n  border-right-width: 1px;\n}\n\n.border-b {\n  border-bottom-width: 1px;\n}\n\n.border-l {\n  border-left-width: 1px;\n}\n\n.box-border {\n  box-sizing: border-box;\n}\n\n.box-content {\n  box-sizing: content-box;\n}\n\n.cursor-auto {\n  cursor: auto;\n}\n\n.cursor-default {\n  cursor: default;\n}\n\n.cursor-pointer {\n  cursor: pointer;\n}\n\n.cursor-wait {\n  cursor: wait;\n}\n\n.cursor-text {\n  cursor: text;\n}\n\n.cursor-move {\n  cursor: move;\n}\n\n.cursor-not-allowed {\n  cursor: not-allowed;\n}\n\n.block {\n  display: block;\n}\n\n.inline-block {\n  display: inline-block;\n}\n\n.inline {\n  display: inline;\n}\n\n.flex {\n  display: flex;\n}\n\n.inline-flex {\n  display: inline-flex;\n}\n\n.table {\n  display: table;\n}\n\n.table-caption {\n  display: table-caption;\n}\n\n.table-cell {\n  display: table-cell;\n}\n\n.table-column {\n  display: table-column;\n}\n\n.table-column-group {\n  display: table-column-group;\n}\n\n.table-footer-group {\n  display: table-footer-group;\n}\n\n.table-header-group {\n  display: table-header-group;\n}\n\n.table-row-group {\n  display: table-row-group;\n}\n\n.table-row {\n  display: table-row;\n}\n\n.flow-root {\n  display: flow-root;\n}\n\n.grid {\n  display: grid;\n}\n\n.inline-grid {\n  display: inline-grid;\n}\n\n.contents {\n  display: contents;\n}\n\n.hidden {\n  display: none;\n}\n\n.flex-row {\n  flex-direction: row;\n}\n\n.flex-row-reverse {\n  flex-direction: row-reverse;\n}\n\n.flex-col {\n  flex-direction: column;\n}\n\n.flex-col-reverse {\n  flex-direction: column-reverse;\n}\n\n.flex-wrap {\n  flex-wrap: wrap;\n}\n\n.flex-wrap-reverse {\n  flex-wrap: wrap-reverse;\n}\n\n.flex-no-wrap {\n  flex-wrap: nowrap;\n}\n\n.place-items-auto {\n  place-items: auto;\n}\n\n.place-items-start {\n  place-items: start;\n}\n\n.place-items-end {\n  place-items: end;\n}\n\n.place-items-center {\n  place-items: center;\n}\n\n.place-items-stretch {\n  place-items: stretch;\n}\n\n.place-content-center {\n  place-content: center;\n}\n\n.place-content-start {\n  place-content: start;\n}\n\n.place-content-end {\n  place-content: end;\n}\n\n.place-content-between {\n  place-content: space-between;\n}\n\n.place-content-around {\n  place-content: space-around;\n}\n\n.place-content-evenly {\n  place-content: space-evenly;\n}\n\n.place-content-stretch {\n  place-content: stretch;\n}\n\n.place-self-auto {\n  place-self: auto;\n}\n\n.place-self-start {\n  place-self: start;\n}\n\n.place-self-end {\n  place-self: end;\n}\n\n.place-self-center {\n  place-self: center;\n}\n\n.place-self-stretch {\n  place-self: stretch;\n}\n\n.items-start {\n  align-items: flex-start;\n}\n\n.items-end {\n  align-items: flex-end;\n}\n\n.items-center {\n  align-items: center;\n}\n\n.items-baseline {\n  align-items: baseline;\n}\n\n.items-stretch {\n  align-items: stretch;\n}\n\n.content-center {\n  align-content: center;\n}\n\n.content-start {\n  align-content: flex-start;\n}\n\n.content-end {\n  align-content: flex-end;\n}\n\n.content-between {\n  align-content: space-between;\n}\n\n.content-around {\n  align-content: space-around;\n}\n\n.content-evenly {\n  align-content: space-evenly;\n}\n\n.self-auto {\n  align-self: auto;\n}\n\n.self-start {\n  align-self: flex-start;\n}\n\n.self-end {\n  align-self: flex-end;\n}\n\n.self-center {\n  align-self: center;\n}\n\n.self-stretch {\n  align-self: stretch;\n}\n\n.justify-items-auto {\n  justify-items: auto;\n}\n\n.justify-items-start {\n  justify-items: start;\n}\n\n.justify-items-end {\n  justify-items: end;\n}\n\n.justify-items-center {\n  justify-items: center;\n}\n\n.justify-items-stretch {\n  justify-items: stretch;\n}\n\n.justify-start {\n  justify-content: flex-start;\n}\n\n.justify-end {\n  justify-content: flex-end;\n}\n\n.justify-center {\n  justify-content: center;\n}\n\n.justify-between {\n  justify-content: space-between;\n}\n\n.justify-around {\n  justify-content: space-around;\n}\n\n.justify-evenly {\n  justify-content: space-evenly;\n}\n\n.justify-self-auto {\n  justify-self: auto;\n}\n\n.justify-self-start {\n  justify-self: start;\n}\n\n.justify-self-end {\n  justify-self: end;\n}\n\n.justify-self-center {\n  justify-self: center;\n}\n\n.justify-self-stretch {\n  justify-self: stretch;\n}\n\n.flex-1 {\n  flex: 1 1 0%;\n}\n\n.flex-auto {\n  flex: 1 1 auto;\n}\n\n.flex-initial {\n  flex: 0 1 auto;\n}\n\n.flex-none {\n  flex: none;\n}\n\n.flex-grow-0 {\n  flex-grow: 0;\n}\n\n.flex-grow {\n  flex-grow: 1;\n}\n\n.flex-shrink-0 {\n  flex-shrink: 0;\n}\n\n.flex-shrink {\n  flex-shrink: 1;\n}\n\n.order-1 {\n  order: 1;\n}\n\n.order-2 {\n  order: 2;\n}\n\n.order-3 {\n  order: 3;\n}\n\n.order-4 {\n  order: 4;\n}\n\n.order-5 {\n  order: 5;\n}\n\n.order-6 {\n  order: 6;\n}\n\n.order-7 {\n  order: 7;\n}\n\n.order-8 {\n  order: 8;\n}\n\n.order-9 {\n  order: 9;\n}\n\n.order-10 {\n  order: 10;\n}\n\n.order-11 {\n  order: 11;\n}\n\n.order-12 {\n  order: 12;\n}\n\n.order-first {\n  order: -9999;\n}\n\n.order-last {\n  order: 9999;\n}\n\n.order-none {\n  order: 0;\n}\n\n.float-right {\n  float: right;\n}\n\n.float-left {\n  float: left;\n}\n\n.float-none {\n  float: none;\n}\n\n.clearfix:after {\n  content: \"\";\n  display: table;\n  clear: both;\n}\n\n.clear-left {\n  clear: left;\n}\n\n.clear-right {\n  clear: right;\n}\n\n.clear-both {\n  clear: both;\n}\n\n.clear-none {\n  clear: none;\n}\n\n.font-sans {\n  font-family: system-ui, -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, \"Helvetica Neue\", Arial, \"Noto Sans\", sans-serif, \"Apple Color Emoji\", \"Segoe UI Emoji\", \"Segoe UI Symbol\", \"Noto Color Emoji\";\n}\n\n.font-serif {\n  font-family: Georgia, Cambria, \"Times New Roman\", Times, serif;\n}\n\n.font-mono {\n  font-family: Menlo, Monaco, Consolas, \"Liberation Mono\", \"Courier New\", monospace;\n}\n\n.font-hairline {\n  font-weight: 100;\n}\n\n.font-thin {\n  font-weight: 200;\n}\n\n.font-light {\n  font-weight: 300;\n}\n\n.font-normal {\n  font-weight: 400;\n}\n\n.font-medium {\n  font-weight: 500;\n}\n\n.font-semibold {\n  font-weight: 600;\n}\n\n.font-bold {\n  font-weight: 700;\n}\n\n.font-extrabold {\n  font-weight: 800;\n}\n\n.font-black {\n  font-weight: 900;\n}\n\n.hover\\:font-hairline:hover {\n  font-weight: 100;\n}\n\n.hover\\:font-thin:hover {\n  font-weight: 200;\n}\n\n.hover\\:font-light:hover {\n  font-weight: 300;\n}\n\n.hover\\:font-normal:hover {\n  font-weight: 400;\n}\n\n.hover\\:font-medium:hover {\n  font-weight: 500;\n}\n\n.hover\\:font-semibold:hover {\n  font-weight: 600;\n}\n\n.hover\\:font-bold:hover {\n  font-weight: 700;\n}\n\n.hover\\:font-extrabold:hover {\n  font-weight: 800;\n}\n\n.hover\\:font-black:hover {\n  font-weight: 900;\n}\n\n.focus\\:font-hairline:focus {\n  font-weight: 100;\n}\n\n.focus\\:font-thin:focus {\n  font-weight: 200;\n}\n\n.focus\\:font-light:focus {\n  font-weight: 300;\n}\n\n.focus\\:font-normal:focus {\n  font-weight: 400;\n}\n\n.focus\\:font-medium:focus {\n  font-weight: 500;\n}\n\n.focus\\:font-semibold:focus {\n  font-weight: 600;\n}\n\n.focus\\:font-bold:focus {\n  font-weight: 700;\n}\n\n.focus\\:font-extrabold:focus {\n  font-weight: 800;\n}\n\n.focus\\:font-black:focus {\n  font-weight: 900;\n}\n\n.h-0 {\n  height: 0;\n}\n\n.h-1 {\n  height: 0.25rem;\n}\n\n.h-2 {\n  height: 0.5rem;\n}\n\n.h-3 {\n  height: 0.75rem;\n}\n\n.h-4 {\n  height: 1rem;\n}\n\n.h-5 {\n  height: 1.25rem;\n}\n\n.h-6 {\n  height: 1.5rem;\n}\n\n.h-8 {\n  height: 2rem;\n}\n\n.h-10 {\n  height: 2.5rem;\n}\n\n.h-12 {\n  height: 3rem;\n}\n\n.h-16 {\n  height: 4rem;\n}\n\n.h-20 {\n  height: 5rem;\n}\n\n.h-24 {\n  height: 6rem;\n}\n\n.h-32 {\n  height: 8rem;\n}\n\n.h-40 {\n  height: 10rem;\n}\n\n.h-48 {\n  height: 12rem;\n}\n\n.h-56 {\n  height: 14rem;\n}\n\n.h-64 {\n  height: 16rem;\n}\n\n.h-auto {\n  height: auto;\n}\n\n.h-px {\n  height: 1px;\n}\n\n.h-full {\n  height: 100%;\n}\n\n.h-screen {\n  height: 100vh;\n}\n\n.text-xs {\n  font-size: 0.75rem;\n}\n\n.text-sm {\n  font-size: 0.875rem;\n}\n\n.text-base {\n  font-size: 1rem;\n}\n\n.text-lg {\n  font-size: 1.125rem;\n}\n\n.text-xl {\n  font-size: 1.25rem;\n}\n\n.text-2xl {\n  font-size: 1.5rem;\n}\n\n.text-3xl {\n  font-size: 1.875rem;\n}\n\n.text-4xl {\n  font-size: 2.25rem;\n}\n\n.text-5xl {\n  font-size: 3rem;\n}\n\n.text-6xl {\n  font-size: 4rem;\n}\n\n.leading-3 {\n  line-height: .75rem;\n}\n\n.leading-4 {\n  line-height: 1rem;\n}\n\n.leading-5 {\n  line-height: 1.25rem;\n}\n\n.leading-6 {\n  line-height: 1.5rem;\n}\n\n.leading-7 {\n  line-height: 1.75rem;\n}\n\n.leading-8 {\n  line-height: 2rem;\n}\n\n.leading-9 {\n  line-height: 2.25rem;\n}\n\n.leading-10 {\n  line-height: 2.5rem;\n}\n\n.leading-none {\n  line-height: 1;\n}\n\n.leading-tight {\n  line-height: 1.25;\n}\n\n.leading-snug {\n  line-height: 1.375;\n}\n\n.leading-normal {\n  line-height: 1.5;\n}\n\n.leading-relaxed {\n  line-height: 1.625;\n}\n\n.leading-loose {\n  line-height: 2;\n}\n\n.list-inside {\n  list-style-position: inside;\n}\n\n.list-outside {\n  list-style-position: outside;\n}\n\n.list-none {\n  list-style-type: none;\n}\n\n.list-disc {\n  list-style-type: disc;\n}\n\n.list-decimal {\n  list-style-type: decimal;\n}\n\n.m-0 {\n  margin: 0;\n}\n\n.m-1 {\n  margin: 0.25rem;\n}\n\n.m-2 {\n  margin: 0.5rem;\n}\n\n.m-3 {\n  margin: 0.75rem;\n}\n\n.m-4 {\n  margin: 1rem;\n}\n\n.m-5 {\n  margin: 1.25rem;\n}\n\n.m-6 {\n  margin: 1.5rem;\n}\n\n.m-8 {\n  margin: 2rem;\n}\n\n.m-10 {\n  margin: 2.5rem;\n}\n\n.m-12 {\n  margin: 3rem;\n}\n\n.m-16 {\n  margin: 4rem;\n}\n\n.m-20 {\n  margin: 5rem;\n}\n\n.m-24 {\n  margin: 6rem;\n}\n\n.m-32 {\n  margin: 8rem;\n}\n\n.m-40 {\n  margin: 10rem;\n}\n\n.m-48 {\n  margin: 12rem;\n}\n\n.m-56 {\n  margin: 14rem;\n}\n\n.m-64 {\n  margin: 16rem;\n}\n\n.m-auto {\n  margin: auto;\n}\n\n.m-px {\n  margin: 1px;\n}\n\n.-m-1 {\n  margin: -0.25rem;\n}\n\n.-m-2 {\n  margin: -0.5rem;\n}\n\n.-m-3 {\n  margin: -0.75rem;\n}\n\n.-m-4 {\n  margin: -1rem;\n}\n\n.-m-5 {\n  margin: -1.25rem;\n}\n\n.-m-6 {\n  margin: -1.5rem;\n}\n\n.-m-8 {\n  margin: -2rem;\n}\n\n.-m-10 {\n  margin: -2.5rem;\n}\n\n.-m-12 {\n  margin: -3rem;\n}\n\n.-m-16 {\n  margin: -4rem;\n}\n\n.-m-20 {\n  margin: -5rem;\n}\n\n.-m-24 {\n  margin: -6rem;\n}\n\n.-m-32 {\n  margin: -8rem;\n}\n\n.-m-40 {\n  margin: -10rem;\n}\n\n.-m-48 {\n  margin: -12rem;\n}\n\n.-m-56 {\n  margin: -14rem;\n}\n\n.-m-64 {\n  margin: -16rem;\n}\n\n.-m-px {\n  margin: -1px;\n}\n\n.my-0 {\n  margin-top: 0;\n  margin-bottom: 0;\n}\n\n.mx-0 {\n  margin-left: 0;\n  margin-right: 0;\n}\n\n.my-1 {\n  margin-top: 0.25rem;\n  margin-bottom: 0.25rem;\n}\n\n.mx-1 {\n  margin-left: 0.25rem;\n  margin-right: 0.25rem;\n}\n\n.my-2 {\n  margin-top: 0.5rem;\n  margin-bottom: 0.5rem;\n}\n\n.mx-2 {\n  margin-left: 0.5rem;\n  margin-right: 0.5rem;\n}\n\n.my-3 {\n  margin-top: 0.75rem;\n  margin-bottom: 0.75rem;\n}\n\n.mx-3 {\n  margin-left: 0.75rem;\n  margin-right: 0.75rem;\n}\n\n.my-4 {\n  margin-top: 1rem;\n  margin-bottom: 1rem;\n}\n\n.mx-4 {\n  margin-left: 1rem;\n  margin-right: 1rem;\n}\n\n.my-5 {\n  margin-top: 1.25rem;\n  margin-bottom: 1.25rem;\n}\n\n.mx-5 {\n  margin-left: 1.25rem;\n  margin-right: 1.25rem;\n}\n\n.my-6 {\n  margin-top: 1.5rem;\n  margin-bottom: 1.5rem;\n}\n\n.mx-6 {\n  margin-left: 1.5rem;\n  margin-right: 1.5rem;\n}\n\n.my-8 {\n  margin-top: 2rem;\n  margin-bottom: 2rem;\n}\n\n.mx-8 {\n  margin-left: 2rem;\n  margin-right: 2rem;\n}\n\n.my-10 {\n  margin-top: 2.5rem;\n  margin-bottom: 2.5rem;\n}\n\n.mx-10 {\n  margin-left: 2.5rem;\n  margin-right: 2.5rem;\n}\n\n.my-12 {\n  margin-top: 3rem;\n  margin-bottom: 3rem;\n}\n\n.mx-12 {\n  margin-left: 3rem;\n  margin-right: 3rem;\n}\n\n.my-16 {\n  margin-top: 4rem;\n  margin-bottom: 4rem;\n}\n\n.mx-16 {\n  margin-left: 4rem;\n  margin-right: 4rem;\n}\n\n.my-20 {\n  margin-top: 5rem;\n  margin-bottom: 5rem;\n}\n\n.mx-20 {\n  margin-left: 5rem;\n  margin-right: 5rem;\n}\n\n.my-24 {\n  margin-top: 6rem;\n  margin-bottom: 6rem;\n}\n\n.mx-24 {\n  margin-left: 6rem;\n  margin-right: 6rem;\n}\n\n.my-32 {\n  margin-top: 8rem;\n  margin-bottom: 8rem;\n}\n\n.mx-32 {\n  margin-left: 8rem;\n  margin-right: 8rem;\n}\n\n.my-40 {\n  margin-top: 10rem;\n  margin-bottom: 10rem;\n}\n\n.mx-40 {\n  margin-left: 10rem;\n  margin-right: 10rem;\n}\n\n.my-48 {\n  margin-top: 12rem;\n  margin-bottom: 12rem;\n}\n\n.mx-48 {\n  margin-left: 12rem;\n  margin-right: 12rem;\n}\n\n.my-56 {\n  margin-top: 14rem;\n  margin-bottom: 14rem;\n}\n\n.mx-56 {\n  margin-left: 14rem;\n  margin-right: 14rem;\n}\n\n.my-64 {\n  margin-top: 16rem;\n  margin-bottom: 16rem;\n}\n\n.mx-64 {\n  margin-left: 16rem;\n  margin-right: 16rem;\n}\n\n.my-auto {\n  margin-top: auto;\n  margin-bottom: auto;\n}\n\n.mx-auto {\n  margin-left: auto;\n  margin-right: auto;\n}\n\n.my-px {\n  margin-top: 1px;\n  margin-bottom: 1px;\n}\n\n.mx-px {\n  margin-left: 1px;\n  margin-right: 1px;\n}\n\n.-my-1 {\n  margin-top: -0.25rem;\n  margin-bottom: -0.25rem;\n}\n\n.-mx-1 {\n  margin-left: -0.25rem;\n  margin-right: -0.25rem;\n}\n\n.-my-2 {\n  margin-top: -0.5rem;\n  margin-bottom: -0.5rem;\n}\n\n.-mx-2 {\n  margin-left: -0.5rem;\n  margin-right: -0.5rem;\n}\n\n.-my-3 {\n  margin-top: -0.75rem;\n  margin-bottom: -0.75rem;\n}\n\n.-mx-3 {\n  margin-left: -0.75rem;\n  margin-right: -0.75rem;\n}\n\n.-my-4 {\n  margin-top: -1rem;\n  margin-bottom: -1rem;\n}\n\n.-mx-4 {\n  margin-left: -1rem;\n  margin-right: -1rem;\n}\n\n.-my-5 {\n  margin-top: -1.25rem;\n  margin-bottom: -1.25rem;\n}\n\n.-mx-5 {\n  margin-left: -1.25rem;\n  margin-right: -1.25rem;\n}\n\n.-my-6 {\n  margin-top: -1.5rem;\n  margin-bottom: -1.5rem;\n}\n\n.-mx-6 {\n  margin-left: -1.5rem;\n  margin-right: -1.5rem;\n}\n\n.-my-8 {\n  margin-top: -2rem;\n  margin-bottom: -2rem;\n}\n\n.-mx-8 {\n  margin-left: -2rem;\n  margin-right: -2rem;\n}\n\n.-my-10 {\n  margin-top: -2.5rem;\n  margin-bottom: -2.5rem;\n}\n\n.-mx-10 {\n  margin-left: -2.5rem;\n  margin-right: -2.5rem;\n}\n\n.-my-12 {\n  margin-top: -3rem;\n  margin-bottom: -3rem;\n}\n\n.-mx-12 {\n  margin-left: -3rem;\n  margin-right: -3rem;\n}\n\n.-my-16 {\n  margin-top: -4rem;\n  margin-bottom: -4rem;\n}\n\n.-mx-16 {\n  margin-left: -4rem;\n  margin-right: -4rem;\n}\n\n.-my-20 {\n  margin-top: -5rem;\n  margin-bottom: -5rem;\n}\n\n.-mx-20 {\n  margin-left: -5rem;\n  margin-right: -5rem;\n}\n\n.-my-24 {\n  margin-top: -6rem;\n  margin-bottom: -6rem;\n}\n\n.-mx-24 {\n  margin-left: -6rem;\n  margin-right: -6rem;\n}\n\n.-my-32 {\n  margin-top: -8rem;\n  margin-bottom: -8rem;\n}\n\n.-mx-32 {\n  margin-left: -8rem;\n  margin-right: -8rem;\n}\n\n.-my-40 {\n  margin-top: -10rem;\n  margin-bottom: -10rem;\n}\n\n.-mx-40 {\n  margin-left: -10rem;\n  margin-right: -10rem;\n}\n\n.-my-48 {\n  margin-top: -12rem;\n  margin-bottom: -12rem;\n}\n\n.-mx-48 {\n  margin-left: -12rem;\n  margin-right: -12rem;\n}\n\n.-my-56 {\n  margin-top: -14rem;\n  margin-bottom: -14rem;\n}\n\n.-mx-56 {\n  margin-left: -14rem;\n  margin-right: -14rem;\n}\n\n.-my-64 {\n  margin-top: -16rem;\n  margin-bottom: -16rem;\n}\n\n.-mx-64 {\n  margin-left: -16rem;\n  margin-right: -16rem;\n}\n\n.-my-px {\n  margin-top: -1px;\n  margin-bottom: -1px;\n}\n\n.-mx-px {\n  margin-left: -1px;\n  margin-right: -1px;\n}\n\n.mt-0 {\n  margin-top: 0;\n}\n\n.mr-0 {\n  margin-right: 0;\n}\n\n.mb-0 {\n  margin-bottom: 0;\n}\n\n.ml-0 {\n  margin-left: 0;\n}\n\n.mt-1 {\n  margin-top: 0.25rem;\n}\n\n.mr-1 {\n  margin-right: 0.25rem;\n}\n\n.mb-1 {\n  margin-bottom: 0.25rem;\n}\n\n.ml-1 {\n  margin-left: 0.25rem;\n}\n\n.mt-2 {\n  margin-top: 0.5rem;\n}\n\n.mr-2 {\n  margin-right: 0.5rem;\n}\n\n.mb-2 {\n  margin-bottom: 0.5rem;\n}\n\n.ml-2 {\n  margin-left: 0.5rem;\n}\n\n.mt-3 {\n  margin-top: 0.75rem;\n}\n\n.mr-3 {\n  margin-right: 0.75rem;\n}\n\n.mb-3 {\n  margin-bottom: 0.75rem;\n}\n\n.ml-3 {\n  margin-left: 0.75rem;\n}\n\n.mt-4 {\n  margin-top: 1rem;\n}\n\n.mr-4 {\n  margin-right: 1rem;\n}\n\n.mb-4 {\n  margin-bottom: 1rem;\n}\n\n.ml-4 {\n  margin-left: 1rem;\n}\n\n.mt-5 {\n  margin-top: 1.25rem;\n}\n\n.mr-5 {\n  margin-right: 1.25rem;\n}\n\n.mb-5 {\n  margin-bottom: 1.25rem;\n}\n\n.ml-5 {\n  margin-left: 1.25rem;\n}\n\n.mt-6 {\n  margin-top: 1.5rem;\n}\n\n.mr-6 {\n  margin-right: 1.5rem;\n}\n\n.mb-6 {\n  margin-bottom: 1.5rem;\n}\n\n.ml-6 {\n  margin-left: 1.5rem;\n}\n\n.mt-8 {\n  margin-top: 2rem;\n}\n\n.mr-8 {\n  margin-right: 2rem;\n}\n\n.mb-8 {\n  margin-bottom: 2rem;\n}\n\n.ml-8 {\n  margin-left: 2rem;\n}\n\n.mt-10 {\n  margin-top: 2.5rem;\n}\n\n.mr-10 {\n  margin-right: 2.5rem;\n}\n\n.mb-10 {\n  margin-bottom: 2.5rem;\n}\n\n.ml-10 {\n  margin-left: 2.5rem;\n}\n\n.mt-12 {\n  margin-top: 3rem;\n}\n\n.mr-12 {\n  margin-right: 3rem;\n}\n\n.mb-12 {\n  margin-bottom: 3rem;\n}\n\n.ml-12 {\n  margin-left: 3rem;\n}\n\n.mt-16 {\n  margin-top: 4rem;\n}\n\n.mr-16 {\n  margin-right: 4rem;\n}\n\n.mb-16 {\n  margin-bottom: 4rem;\n}\n\n.ml-16 {\n  margin-left: 4rem;\n}\n\n.mt-20 {\n  margin-top: 5rem;\n}\n\n.mr-20 {\n  margin-right: 5rem;\n}\n\n.mb-20 {\n  margin-bottom: 5rem;\n}\n\n.ml-20 {\n  margin-left: 5rem;\n}\n\n.mt-24 {\n  margin-top: 6rem;\n}\n\n.mr-24 {\n  margin-right: 6rem;\n}\n\n.mb-24 {\n  margin-bottom: 6rem;\n}\n\n.ml-24 {\n  margin-left: 6rem;\n}\n\n.mt-32 {\n  margin-top: 8rem;\n}\n\n.mr-32 {\n  margin-right: 8rem;\n}\n\n.mb-32 {\n  margin-bottom: 8rem;\n}\n\n.ml-32 {\n  margin-left: 8rem;\n}\n\n.mt-40 {\n  margin-top: 10rem;\n}\n\n.mr-40 {\n  margin-right: 10rem;\n}\n\n.mb-40 {\n  margin-bottom: 10rem;\n}\n\n.ml-40 {\n  margin-left: 10rem;\n}\n\n.mt-48 {\n  margin-top: 12rem;\n}\n\n.mr-48 {\n  margin-right: 12rem;\n}\n\n.mb-48 {\n  margin-bottom: 12rem;\n}\n\n.ml-48 {\n  margin-left: 12rem;\n}\n\n.mt-56 {\n  margin-top: 14rem;\n}\n\n.mr-56 {\n  margin-right: 14rem;\n}\n\n.mb-56 {\n  margin-bottom: 14rem;\n}\n\n.ml-56 {\n  margin-left: 14rem;\n}\n\n.mt-64 {\n  margin-top: 16rem;\n}\n\n.mr-64 {\n  margin-right: 16rem;\n}\n\n.mb-64 {\n  margin-bottom: 16rem;\n}\n\n.ml-64 {\n  margin-left: 16rem;\n}\n\n.mt-auto {\n  margin-top: auto;\n}\n\n.mr-auto {\n  margin-right: auto;\n}\n\n.mb-auto {\n  margin-bottom: auto;\n}\n\n.ml-auto {\n  margin-left: auto;\n}\n\n.mt-px {\n  margin-top: 1px;\n}\n\n.mr-px {\n  margin-right: 1px;\n}\n\n.mb-px {\n  margin-bottom: 1px;\n}\n\n.ml-px {\n  margin-left: 1px;\n}\n\n.-mt-1 {\n  margin-top: -0.25rem;\n}\n\n.-mr-1 {\n  margin-right: -0.25rem;\n}\n\n.-mb-1 {\n  margin-bottom: -0.25rem;\n}\n\n.-ml-1 {\n  margin-left: -0.25rem;\n}\n\n.-mt-2 {\n  margin-top: -0.5rem;\n}\n\n.-mr-2 {\n  margin-right: -0.5rem;\n}\n\n.-mb-2 {\n  margin-bottom: -0.5rem;\n}\n\n.-ml-2 {\n  margin-left: -0.5rem;\n}\n\n.-mt-3 {\n  margin-top: -0.75rem;\n}\n\n.-mr-3 {\n  margin-right: -0.75rem;\n}\n\n.-mb-3 {\n  margin-bottom: -0.75rem;\n}\n\n.-ml-3 {\n  margin-left: -0.75rem;\n}\n\n.-mt-4 {\n  margin-top: -1rem;\n}\n\n.-mr-4 {\n  margin-right: -1rem;\n}\n\n.-mb-4 {\n  margin-bottom: -1rem;\n}\n\n.-ml-4 {\n  margin-left: -1rem;\n}\n\n.-mt-5 {\n  margin-top: -1.25rem;\n}\n\n.-mr-5 {\n  margin-right: -1.25rem;\n}\n\n.-mb-5 {\n  margin-bottom: -1.25rem;\n}\n\n.-ml-5 {\n  margin-left: -1.25rem;\n}\n\n.-mt-6 {\n  margin-top: -1.5rem;\n}\n\n.-mr-6 {\n  margin-right: -1.5rem;\n}\n\n.-mb-6 {\n  margin-bottom: -1.5rem;\n}\n\n.-ml-6 {\n  margin-left: -1.5rem;\n}\n\n.-mt-8 {\n  margin-top: -2rem;\n}\n\n.-mr-8 {\n  margin-right: -2rem;\n}\n\n.-mb-8 {\n  margin-bottom: -2rem;\n}\n\n.-ml-8 {\n  margin-left: -2rem;\n}\n\n.-mt-10 {\n  margin-top: -2.5rem;\n}\n\n.-mr-10 {\n  margin-right: -2.5rem;\n}\n\n.-mb-10 {\n  margin-bottom: -2.5rem;\n}\n\n.-ml-10 {\n  margin-left: -2.5rem;\n}\n\n.-mt-12 {\n  margin-top: -3rem;\n}\n\n.-mr-12 {\n  margin-right: -3rem;\n}\n\n.-mb-12 {\n  margin-bottom: -3rem;\n}\n\n.-ml-12 {\n  margin-left: -3rem;\n}\n\n.-mt-16 {\n  margin-top: -4rem;\n}\n\n.-mr-16 {\n  margin-right: -4rem;\n}\n\n.-mb-16 {\n  margin-bottom: -4rem;\n}\n\n.-ml-16 {\n  margin-left: -4rem;\n}\n\n.-mt-20 {\n  margin-top: -5rem;\n}\n\n.-mr-20 {\n  margin-right: -5rem;\n}\n\n.-mb-20 {\n  margin-bottom: -5rem;\n}\n\n.-ml-20 {\n  margin-left: -5rem;\n}\n\n.-mt-24 {\n  margin-top: -6rem;\n}\n\n.-mr-24 {\n  margin-right: -6rem;\n}\n\n.-mb-24 {\n  margin-bottom: -6rem;\n}\n\n.-ml-24 {\n  margin-left: -6rem;\n}\n\n.-mt-32 {\n  margin-top: -8rem;\n}\n\n.-mr-32 {\n  margin-right: -8rem;\n}\n\n.-mb-32 {\n  margin-bottom: -8rem;\n}\n\n.-ml-32 {\n  margin-left: -8rem;\n}\n\n.-mt-40 {\n  margin-top: -10rem;\n}\n\n.-mr-40 {\n  margin-right: -10rem;\n}\n\n.-mb-40 {\n  margin-bottom: -10rem;\n}\n\n.-ml-40 {\n  margin-left: -10rem;\n}\n\n.-mt-48 {\n  margin-top: -12rem;\n}\n\n.-mr-48 {\n  margin-right: -12rem;\n}\n\n.-mb-48 {\n  margin-bottom: -12rem;\n}\n\n.-ml-48 {\n  margin-left: -12rem;\n}\n\n.-mt-56 {\n  margin-top: -14rem;\n}\n\n.-mr-56 {\n  margin-right: -14rem;\n}\n\n.-mb-56 {\n  margin-bottom: -14rem;\n}\n\n.-ml-56 {\n  margin-left: -14rem;\n}\n\n.-mt-64 {\n  margin-top: -16rem;\n}\n\n.-mr-64 {\n  margin-right: -16rem;\n}\n\n.-mb-64 {\n  margin-bottom: -16rem;\n}\n\n.-ml-64 {\n  margin-left: -16rem;\n}\n\n.-mt-px {\n  margin-top: -1px;\n}\n\n.-mr-px {\n  margin-right: -1px;\n}\n\n.-mb-px {\n  margin-bottom: -1px;\n}\n\n.-ml-px {\n  margin-left: -1px;\n}\n\n.max-h-full {\n  max-height: 100%;\n}\n\n.max-h-screen {\n  max-height: 100vh;\n}\n\n.max-w-none {\n  max-width: none;\n}\n\n.max-w-xs {\n  max-width: 20rem;\n}\n\n.max-w-sm {\n  max-width: 24rem;\n}\n\n.max-w-md {\n  max-width: 28rem;\n}\n\n.max-w-lg {\n  max-width: 32rem;\n}\n\n.max-w-xl {\n  max-width: 36rem;\n}\n\n.max-w-2xl {\n  max-width: 42rem;\n}\n\n.max-w-3xl {\n  max-width: 48rem;\n}\n\n.max-w-4xl {\n  max-width: 56rem;\n}\n\n.max-w-5xl {\n  max-width: 64rem;\n}\n\n.max-w-6xl {\n  max-width: 72rem;\n}\n\n.max-w-full {\n  max-width: 100%;\n}\n\n.max-w-screen-sm {\n  max-width: 640px;\n}\n\n.max-w-screen-md {\n  max-width: 768px;\n}\n\n.max-w-screen-lg {\n  max-width: 1024px;\n}\n\n.max-w-screen-xl {\n  max-width: 1280px;\n}\n\n.min-h-0 {\n  min-height: 0;\n}\n\n.min-h-full {\n  min-height: 100%;\n}\n\n.min-h-screen {\n  min-height: 100vh;\n}\n\n.min-w-0 {\n  min-width: 0;\n}\n\n.min-w-full {\n  min-width: 100%;\n}\n\n.object-contain {\n  -o-object-fit: contain;\n     object-fit: contain;\n}\n\n.object-cover {\n  -o-object-fit: cover;\n     object-fit: cover;\n}\n\n.object-fill {\n  -o-object-fit: fill;\n     object-fit: fill;\n}\n\n.object-none {\n  -o-object-fit: none;\n     object-fit: none;\n}\n\n.object-scale-down {\n  -o-object-fit: scale-down;\n     object-fit: scale-down;\n}\n\n.object-bottom {\n  -o-object-position: bottom;\n     object-position: bottom;\n}\n\n.object-center {\n  -o-object-position: center;\n     object-position: center;\n}\n\n.object-left {\n  -o-object-position: left;\n     object-position: left;\n}\n\n.object-left-bottom {\n  -o-object-position: left bottom;\n     object-position: left bottom;\n}\n\n.object-left-top {\n  -o-object-position: left top;\n     object-position: left top;\n}\n\n.object-right {\n  -o-object-position: right;\n     object-position: right;\n}\n\n.object-right-bottom {\n  -o-object-position: right bottom;\n     object-position: right bottom;\n}\n\n.object-right-top {\n  -o-object-position: right top;\n     object-position: right top;\n}\n\n.object-top {\n  -o-object-position: top;\n     object-position: top;\n}\n\n.opacity-0 {\n  opacity: 0;\n}\n\n.opacity-25 {\n  opacity: 0.25;\n}\n\n.opacity-50 {\n  opacity: 0.5;\n}\n\n.opacity-75 {\n  opacity: 0.75;\n}\n\n.opacity-100 {\n  opacity: 1;\n}\n\n.hover\\:opacity-0:hover {\n  opacity: 0;\n}\n\n.hover\\:opacity-25:hover {\n  opacity: 0.25;\n}\n\n.hover\\:opacity-50:hover {\n  opacity: 0.5;\n}\n\n.hover\\:opacity-75:hover {\n  opacity: 0.75;\n}\n\n.hover\\:opacity-100:hover {\n  opacity: 1;\n}\n\n.focus\\:opacity-0:focus {\n  opacity: 0;\n}\n\n.focus\\:opacity-25:focus {\n  opacity: 0.25;\n}\n\n.focus\\:opacity-50:focus {\n  opacity: 0.5;\n}\n\n.focus\\:opacity-75:focus {\n  opacity: 0.75;\n}\n\n.focus\\:opacity-100:focus {\n  opacity: 1;\n}\n\n.outline-none {\n  outline: 2px solid transparent;\n  outline-offset: 2px;\n}\n\n.outline-white {\n  outline: 2px dotted white;\n  outline-offset: 2px;\n}\n\n.outline-black {\n  outline: 2px dotted black;\n  outline-offset: 2px;\n}\n\n.focus\\:outline-none:focus {\n  outline: 2px solid transparent;\n  outline-offset: 2px;\n}\n\n.focus\\:outline-white:focus {\n  outline: 2px dotted white;\n  outline-offset: 2px;\n}\n\n.focus\\:outline-black:focus {\n  outline: 2px dotted black;\n  outline-offset: 2px;\n}\n\n.overflow-auto {\n  overflow: auto;\n}\n\n.overflow-hidden {\n  overflow: hidden;\n}\n\n.overflow-visible {\n  overflow: visible;\n}\n\n.overflow-scroll {\n  overflow: scroll;\n}\n\n.overflow-x-auto {\n  overflow-x: auto;\n}\n\n.overflow-y-auto {\n  overflow-y: auto;\n}\n\n.overflow-x-hidden {\n  overflow-x: hidden;\n}\n\n.overflow-y-hidden {\n  overflow-y: hidden;\n}\n\n.overflow-x-visible {\n  overflow-x: visible;\n}\n\n.overflow-y-visible {\n  overflow-y: visible;\n}\n\n.overflow-x-scroll {\n  overflow-x: scroll;\n}\n\n.overflow-y-scroll {\n  overflow-y: scroll;\n}\n\n.scrolling-touch {\n  -webkit-overflow-scrolling: touch;\n}\n\n.scrolling-auto {\n  -webkit-overflow-scrolling: auto;\n}\n\n.overscroll-auto {\n  -ms-scroll-chaining: chained;\n      overscroll-behavior: auto;\n}\n\n.overscroll-contain {\n  -ms-scroll-chaining: none;\n      overscroll-behavior: contain;\n}\n\n.overscroll-none {\n  -ms-scroll-chaining: none;\n      overscroll-behavior: none;\n}\n\n.overscroll-y-auto {\n  overscroll-behavior-y: auto;\n}\n\n.overscroll-y-contain {\n  overscroll-behavior-y: contain;\n}\n\n.overscroll-y-none {\n  overscroll-behavior-y: none;\n}\n\n.overscroll-x-auto {\n  overscroll-behavior-x: auto;\n}\n\n.overscroll-x-contain {\n  overscroll-behavior-x: contain;\n}\n\n.overscroll-x-none {\n  overscroll-behavior-x: none;\n}\n\n.p-0 {\n  padding: 0;\n}\n\n.p-1 {\n  padding: 0.25rem;\n}\n\n.p-2 {\n  padding: 0.5rem;\n}\n\n.p-3 {\n  padding: 0.75rem;\n}\n\n.p-4 {\n  padding: 1rem;\n}\n\n.p-5 {\n  padding: 1.25rem;\n}\n\n.p-6 {\n  padding: 1.5rem;\n}\n\n.p-8 {\n  padding: 2rem;\n}\n\n.p-10 {\n  padding: 2.5rem;\n}\n\n.p-12 {\n  padding: 3rem;\n}\n\n.p-16 {\n  padding: 4rem;\n}\n\n.p-20 {\n  padding: 5rem;\n}\n\n.p-24 {\n  padding: 6rem;\n}\n\n.p-32 {\n  padding: 8rem;\n}\n\n.p-40 {\n  padding: 10rem;\n}\n\n.p-48 {\n  padding: 12rem;\n}\n\n.p-56 {\n  padding: 14rem;\n}\n\n.p-64 {\n  padding: 16rem;\n}\n\n.p-px {\n  padding: 1px;\n}\n\n.py-0 {\n  padding-top: 0;\n  padding-bottom: 0;\n}\n\n.px-0 {\n  padding-left: 0;\n  padding-right: 0;\n}\n\n.py-1 {\n  padding-top: 0.25rem;\n  padding-bottom: 0.25rem;\n}\n\n.px-1 {\n  padding-left: 0.25rem;\n  padding-right: 0.25rem;\n}\n\n.py-2 {\n  padding-top: 0.5rem;\n  padding-bottom: 0.5rem;\n}\n\n.px-2 {\n  padding-left: 0.5rem;\n  padding-right: 0.5rem;\n}\n\n.py-3 {\n  padding-top: 0.75rem;\n  padding-bottom: 0.75rem;\n}\n\n.px-3 {\n  padding-left: 0.75rem;\n  padding-right: 0.75rem;\n}\n\n.py-4 {\n  padding-top: 1rem;\n  padding-bottom: 1rem;\n}\n\n.px-4 {\n  padding-left: 1rem;\n  padding-right: 1rem;\n}\n\n.py-5 {\n  padding-top: 1.25rem;\n  padding-bottom: 1.25rem;\n}\n\n.px-5 {\n  padding-left: 1.25rem;\n  padding-right: 1.25rem;\n}\n\n.py-6 {\n  padding-top: 1.5rem;\n  padding-bottom: 1.5rem;\n}\n\n.px-6 {\n  padding-left: 1.5rem;\n  padding-right: 1.5rem;\n}\n\n.py-8 {\n  padding-top: 2rem;\n  padding-bottom: 2rem;\n}\n\n.px-8 {\n  padding-left: 2rem;\n  padding-right: 2rem;\n}\n\n.py-10 {\n  padding-top: 2.5rem;\n  padding-bottom: 2.5rem;\n}\n\n.px-10 {\n  padding-left: 2.5rem;\n  padding-right: 2.5rem;\n}\n\n.py-12 {\n  padding-top: 3rem;\n  padding-bottom: 3rem;\n}\n\n.px-12 {\n  padding-left: 3rem;\n  padding-right: 3rem;\n}\n\n.py-16 {\n  padding-top: 4rem;\n  padding-bottom: 4rem;\n}\n\n.px-16 {\n  padding-left: 4rem;\n  padding-right: 4rem;\n}\n\n.py-20 {\n  padding-top: 5rem;\n  padding-bottom: 5rem;\n}\n\n.px-20 {\n  padding-left: 5rem;\n  padding-right: 5rem;\n}\n\n.py-24 {\n  padding-top: 6rem;\n  padding-bottom: 6rem;\n}\n\n.px-24 {\n  padding-left: 6rem;\n  padding-right: 6rem;\n}\n\n.py-32 {\n  padding-top: 8rem;\n  padding-bottom: 8rem;\n}\n\n.px-32 {\n  padding-left: 8rem;\n  padding-right: 8rem;\n}\n\n.py-40 {\n  padding-top: 10rem;\n  padding-bottom: 10rem;\n}\n\n.px-40 {\n  padding-left: 10rem;\n  padding-right: 10rem;\n}\n\n.py-48 {\n  padding-top: 12rem;\n  padding-bottom: 12rem;\n}\n\n.px-48 {\n  padding-left: 12rem;\n  padding-right: 12rem;\n}\n\n.py-56 {\n  padding-top: 14rem;\n  padding-bottom: 14rem;\n}\n\n.px-56 {\n  padding-left: 14rem;\n  padding-right: 14rem;\n}\n\n.py-64 {\n  padding-top: 16rem;\n  padding-bottom: 16rem;\n}\n\n.px-64 {\n  padding-left: 16rem;\n  padding-right: 16rem;\n}\n\n.py-px {\n  padding-top: 1px;\n  padding-bottom: 1px;\n}\n\n.px-px {\n  padding-left: 1px;\n  padding-right: 1px;\n}\n\n.pt-0 {\n  padding-top: 0;\n}\n\n.pr-0 {\n  padding-right: 0;\n}\n\n.pb-0 {\n  padding-bottom: 0;\n}\n\n.pl-0 {\n  padding-left: 0;\n}\n\n.pt-1 {\n  padding-top: 0.25rem;\n}\n\n.pr-1 {\n  padding-right: 0.25rem;\n}\n\n.pb-1 {\n  padding-bottom: 0.25rem;\n}\n\n.pl-1 {\n  padding-left: 0.25rem;\n}\n\n.pt-2 {\n  padding-top: 0.5rem;\n}\n\n.pr-2 {\n  padding-right: 0.5rem;\n}\n\n.pb-2 {\n  padding-bottom: 0.5rem;\n}\n\n.pl-2 {\n  padding-left: 0.5rem;\n}\n\n.pt-3 {\n  padding-top: 0.75rem;\n}\n\n.pr-3 {\n  padding-right: 0.75rem;\n}\n\n.pb-3 {\n  padding-bottom: 0.75rem;\n}\n\n.pl-3 {\n  padding-left: 0.75rem;\n}\n\n.pt-4 {\n  padding-top: 1rem;\n}\n\n.pr-4 {\n  padding-right: 1rem;\n}\n\n.pb-4 {\n  padding-bottom: 1rem;\n}\n\n.pl-4 {\n  padding-left: 1rem;\n}\n\n.pt-5 {\n  padding-top: 1.25rem;\n}\n\n.pr-5 {\n  padding-right: 1.25rem;\n}\n\n.pb-5 {\n  padding-bottom: 1.25rem;\n}\n\n.pl-5 {\n  padding-left: 1.25rem;\n}\n\n.pt-6 {\n  padding-top: 1.5rem;\n}\n\n.pr-6 {\n  padding-right: 1.5rem;\n}\n\n.pb-6 {\n  padding-bottom: 1.5rem;\n}\n\n.pl-6 {\n  padding-left: 1.5rem;\n}\n\n.pt-8 {\n  padding-top: 2rem;\n}\n\n.pr-8 {\n  padding-right: 2rem;\n}\n\n.pb-8 {\n  padding-bottom: 2rem;\n}\n\n.pl-8 {\n  padding-left: 2rem;\n}\n\n.pt-10 {\n  padding-top: 2.5rem;\n}\n\n.pr-10 {\n  padding-right: 2.5rem;\n}\n\n.pb-10 {\n  padding-bottom: 2.5rem;\n}\n\n.pl-10 {\n  padding-left: 2.5rem;\n}\n\n.pt-12 {\n  padding-top: 3rem;\n}\n\n.pr-12 {\n  padding-right: 3rem;\n}\n\n.pb-12 {\n  padding-bottom: 3rem;\n}\n\n.pl-12 {\n  padding-left: 3rem;\n}\n\n.pt-16 {\n  padding-top: 4rem;\n}\n\n.pr-16 {\n  padding-right: 4rem;\n}\n\n.pb-16 {\n  padding-bottom: 4rem;\n}\n\n.pl-16 {\n  padding-left: 4rem;\n}\n\n.pt-20 {\n  padding-top: 5rem;\n}\n\n.pr-20 {\n  padding-right: 5rem;\n}\n\n.pb-20 {\n  padding-bottom: 5rem;\n}\n\n.pl-20 {\n  padding-left: 5rem;\n}\n\n.pt-24 {\n  padding-top: 6rem;\n}\n\n.pr-24 {\n  padding-right: 6rem;\n}\n\n.pb-24 {\n  padding-bottom: 6rem;\n}\n\n.pl-24 {\n  padding-left: 6rem;\n}\n\n.pt-32 {\n  padding-top: 8rem;\n}\n\n.pr-32 {\n  padding-right: 8rem;\n}\n\n.pb-32 {\n  padding-bottom: 8rem;\n}\n\n.pl-32 {\n  padding-left: 8rem;\n}\n\n.pt-40 {\n  padding-top: 10rem;\n}\n\n.pr-40 {\n  padding-right: 10rem;\n}\n\n.pb-40 {\n  padding-bottom: 10rem;\n}\n\n.pl-40 {\n  padding-left: 10rem;\n}\n\n.pt-48 {\n  padding-top: 12rem;\n}\n\n.pr-48 {\n  padding-right: 12rem;\n}\n\n.pb-48 {\n  padding-bottom: 12rem;\n}\n\n.pl-48 {\n  padding-left: 12rem;\n}\n\n.pt-56 {\n  padding-top: 14rem;\n}\n\n.pr-56 {\n  padding-right: 14rem;\n}\n\n.pb-56 {\n  padding-bottom: 14rem;\n}\n\n.pl-56 {\n  padding-left: 14rem;\n}\n\n.pt-64 {\n  padding-top: 16rem;\n}\n\n.pr-64 {\n  padding-right: 16rem;\n}\n\n.pb-64 {\n  padding-bottom: 16rem;\n}\n\n.pl-64 {\n  padding-left: 16rem;\n}\n\n.pt-px {\n  padding-top: 1px;\n}\n\n.pr-px {\n  padding-right: 1px;\n}\n\n.pb-px {\n  padding-bottom: 1px;\n}\n\n.pl-px {\n  padding-left: 1px;\n}\n\n.placeholder-transparent::-moz-placeholder {\n  color: transparent;\n}\n\n.placeholder-transparent:-ms-input-placeholder {\n  color: transparent;\n}\n\n.placeholder-transparent::placeholder {\n  color: transparent;\n}\n\n.placeholder-current::-moz-placeholder {\n  color: currentColor;\n}\n\n.placeholder-current:-ms-input-placeholder {\n  color: currentColor;\n}\n\n.placeholder-current::placeholder {\n  color: currentColor;\n}\n\n.placeholder-black::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #000;\n  color: rgba(0, 0, 0, var(--placeholder-opacity));\n}\n\n.placeholder-black:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #000;\n  color: rgba(0, 0, 0, var(--placeholder-opacity));\n}\n\n.placeholder-black::placeholder {\n  --placeholder-opacity: 1;\n  color: #000;\n  color: rgba(0, 0, 0, var(--placeholder-opacity));\n}\n\n.placeholder-white::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #fff;\n  color: rgba(255, 255, 255, var(--placeholder-opacity));\n}\n\n.placeholder-white:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #fff;\n  color: rgba(255, 255, 255, var(--placeholder-opacity));\n}\n\n.placeholder-white::placeholder {\n  --placeholder-opacity: 1;\n  color: #fff;\n  color: rgba(255, 255, 255, var(--placeholder-opacity));\n}\n\n.placeholder-gray-100::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #f7fafc;\n  color: rgba(247, 250, 252, var(--placeholder-opacity));\n}\n\n.placeholder-gray-100:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #f7fafc;\n  color: rgba(247, 250, 252, var(--placeholder-opacity));\n}\n\n.placeholder-gray-100::placeholder {\n  --placeholder-opacity: 1;\n  color: #f7fafc;\n  color: rgba(247, 250, 252, var(--placeholder-opacity));\n}\n\n.placeholder-gray-200::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #edf2f7;\n  color: rgba(237, 242, 247, var(--placeholder-opacity));\n}\n\n.placeholder-gray-200:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #edf2f7;\n  color: rgba(237, 242, 247, var(--placeholder-opacity));\n}\n\n.placeholder-gray-200::placeholder {\n  --placeholder-opacity: 1;\n  color: #edf2f7;\n  color: rgba(237, 242, 247, var(--placeholder-opacity));\n}\n\n.placeholder-gray-300::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #e2e8f0;\n  color: rgba(226, 232, 240, var(--placeholder-opacity));\n}\n\n.placeholder-gray-300:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #e2e8f0;\n  color: rgba(226, 232, 240, var(--placeholder-opacity));\n}\n\n.placeholder-gray-300::placeholder {\n  --placeholder-opacity: 1;\n  color: #e2e8f0;\n  color: rgba(226, 232, 240, var(--placeholder-opacity));\n}\n\n.placeholder-gray-400::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #cbd5e0;\n  color: rgba(203, 213, 224, var(--placeholder-opacity));\n}\n\n.placeholder-gray-400:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #cbd5e0;\n  color: rgba(203, 213, 224, var(--placeholder-opacity));\n}\n\n.placeholder-gray-400::placeholder {\n  --placeholder-opacity: 1;\n  color: #cbd5e0;\n  color: rgba(203, 213, 224, var(--placeholder-opacity));\n}\n\n.placeholder-gray-500::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #a0aec0;\n  color: rgba(160, 174, 192, var(--placeholder-opacity));\n}\n\n.placeholder-gray-500:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #a0aec0;\n  color: rgba(160, 174, 192, var(--placeholder-opacity));\n}\n\n.placeholder-gray-500::placeholder {\n  --placeholder-opacity: 1;\n  color: #a0aec0;\n  color: rgba(160, 174, 192, var(--placeholder-opacity));\n}\n\n.placeholder-gray-600::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #718096;\n  color: rgba(113, 128, 150, var(--placeholder-opacity));\n}\n\n.placeholder-gray-600:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #718096;\n  color: rgba(113, 128, 150, var(--placeholder-opacity));\n}\n\n.placeholder-gray-600::placeholder {\n  --placeholder-opacity: 1;\n  color: #718096;\n  color: rgba(113, 128, 150, var(--placeholder-opacity));\n}\n\n.placeholder-gray-700::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #4a5568;\n  color: rgba(74, 85, 104, var(--placeholder-opacity));\n}\n\n.placeholder-gray-700:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #4a5568;\n  color: rgba(74, 85, 104, var(--placeholder-opacity));\n}\n\n.placeholder-gray-700::placeholder {\n  --placeholder-opacity: 1;\n  color: #4a5568;\n  color: rgba(74, 85, 104, var(--placeholder-opacity));\n}\n\n.placeholder-gray-800::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #2d3748;\n  color: rgba(45, 55, 72, var(--placeholder-opacity));\n}\n\n.placeholder-gray-800:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #2d3748;\n  color: rgba(45, 55, 72, var(--placeholder-opacity));\n}\n\n.placeholder-gray-800::placeholder {\n  --placeholder-opacity: 1;\n  color: #2d3748;\n  color: rgba(45, 55, 72, var(--placeholder-opacity));\n}\n\n.placeholder-gray-900::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #1a202c;\n  color: rgba(26, 32, 44, var(--placeholder-opacity));\n}\n\n.placeholder-gray-900:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #1a202c;\n  color: rgba(26, 32, 44, var(--placeholder-opacity));\n}\n\n.placeholder-gray-900::placeholder {\n  --placeholder-opacity: 1;\n  color: #1a202c;\n  color: rgba(26, 32, 44, var(--placeholder-opacity));\n}\n\n.placeholder-red-100::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #fff5f5;\n  color: rgba(255, 245, 245, var(--placeholder-opacity));\n}\n\n.placeholder-red-100:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #fff5f5;\n  color: rgba(255, 245, 245, var(--placeholder-opacity));\n}\n\n.placeholder-red-100::placeholder {\n  --placeholder-opacity: 1;\n  color: #fff5f5;\n  color: rgba(255, 245, 245, var(--placeholder-opacity));\n}\n\n.placeholder-red-200::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #fed7d7;\n  color: rgba(254, 215, 215, var(--placeholder-opacity));\n}\n\n.placeholder-red-200:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #fed7d7;\n  color: rgba(254, 215, 215, var(--placeholder-opacity));\n}\n\n.placeholder-red-200::placeholder {\n  --placeholder-opacity: 1;\n  color: #fed7d7;\n  color: rgba(254, 215, 215, var(--placeholder-opacity));\n}\n\n.placeholder-red-300::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #feb2b2;\n  color: rgba(254, 178, 178, var(--placeholder-opacity));\n}\n\n.placeholder-red-300:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #feb2b2;\n  color: rgba(254, 178, 178, var(--placeholder-opacity));\n}\n\n.placeholder-red-300::placeholder {\n  --placeholder-opacity: 1;\n  color: #feb2b2;\n  color: rgba(254, 178, 178, var(--placeholder-opacity));\n}\n\n.placeholder-red-400::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #fc8181;\n  color: rgba(252, 129, 129, var(--placeholder-opacity));\n}\n\n.placeholder-red-400:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #fc8181;\n  color: rgba(252, 129, 129, var(--placeholder-opacity));\n}\n\n.placeholder-red-400::placeholder {\n  --placeholder-opacity: 1;\n  color: #fc8181;\n  color: rgba(252, 129, 129, var(--placeholder-opacity));\n}\n\n.placeholder-red-500::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #f56565;\n  color: rgba(245, 101, 101, var(--placeholder-opacity));\n}\n\n.placeholder-red-500:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #f56565;\n  color: rgba(245, 101, 101, var(--placeholder-opacity));\n}\n\n.placeholder-red-500::placeholder {\n  --placeholder-opacity: 1;\n  color: #f56565;\n  color: rgba(245, 101, 101, var(--placeholder-opacity));\n}\n\n.placeholder-red-600::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #e53e3e;\n  color: rgba(229, 62, 62, var(--placeholder-opacity));\n}\n\n.placeholder-red-600:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #e53e3e;\n  color: rgba(229, 62, 62, var(--placeholder-opacity));\n}\n\n.placeholder-red-600::placeholder {\n  --placeholder-opacity: 1;\n  color: #e53e3e;\n  color: rgba(229, 62, 62, var(--placeholder-opacity));\n}\n\n.placeholder-red-700::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #c53030;\n  color: rgba(197, 48, 48, var(--placeholder-opacity));\n}\n\n.placeholder-red-700:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #c53030;\n  color: rgba(197, 48, 48, var(--placeholder-opacity));\n}\n\n.placeholder-red-700::placeholder {\n  --placeholder-opacity: 1;\n  color: #c53030;\n  color: rgba(197, 48, 48, var(--placeholder-opacity));\n}\n\n.placeholder-red-800::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #9b2c2c;\n  color: rgba(155, 44, 44, var(--placeholder-opacity));\n}\n\n.placeholder-red-800:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #9b2c2c;\n  color: rgba(155, 44, 44, var(--placeholder-opacity));\n}\n\n.placeholder-red-800::placeholder {\n  --placeholder-opacity: 1;\n  color: #9b2c2c;\n  color: rgba(155, 44, 44, var(--placeholder-opacity));\n}\n\n.placeholder-red-900::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #742a2a;\n  color: rgba(116, 42, 42, var(--placeholder-opacity));\n}\n\n.placeholder-red-900:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #742a2a;\n  color: rgba(116, 42, 42, var(--placeholder-opacity));\n}\n\n.placeholder-red-900::placeholder {\n  --placeholder-opacity: 1;\n  color: #742a2a;\n  color: rgba(116, 42, 42, var(--placeholder-opacity));\n}\n\n.placeholder-orange-100::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #fffaf0;\n  color: rgba(255, 250, 240, var(--placeholder-opacity));\n}\n\n.placeholder-orange-100:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #fffaf0;\n  color: rgba(255, 250, 240, var(--placeholder-opacity));\n}\n\n.placeholder-orange-100::placeholder {\n  --placeholder-opacity: 1;\n  color: #fffaf0;\n  color: rgba(255, 250, 240, var(--placeholder-opacity));\n}\n\n.placeholder-orange-200::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #feebc8;\n  color: rgba(254, 235, 200, var(--placeholder-opacity));\n}\n\n.placeholder-orange-200:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #feebc8;\n  color: rgba(254, 235, 200, var(--placeholder-opacity));\n}\n\n.placeholder-orange-200::placeholder {\n  --placeholder-opacity: 1;\n  color: #feebc8;\n  color: rgba(254, 235, 200, var(--placeholder-opacity));\n}\n\n.placeholder-orange-300::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #fbd38d;\n  color: rgba(251, 211, 141, var(--placeholder-opacity));\n}\n\n.placeholder-orange-300:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #fbd38d;\n  color: rgba(251, 211, 141, var(--placeholder-opacity));\n}\n\n.placeholder-orange-300::placeholder {\n  --placeholder-opacity: 1;\n  color: #fbd38d;\n  color: rgba(251, 211, 141, var(--placeholder-opacity));\n}\n\n.placeholder-orange-400::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #f6ad55;\n  color: rgba(246, 173, 85, var(--placeholder-opacity));\n}\n\n.placeholder-orange-400:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #f6ad55;\n  color: rgba(246, 173, 85, var(--placeholder-opacity));\n}\n\n.placeholder-orange-400::placeholder {\n  --placeholder-opacity: 1;\n  color: #f6ad55;\n  color: rgba(246, 173, 85, var(--placeholder-opacity));\n}\n\n.placeholder-orange-500::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #ed8936;\n  color: rgba(237, 137, 54, var(--placeholder-opacity));\n}\n\n.placeholder-orange-500:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #ed8936;\n  color: rgba(237, 137, 54, var(--placeholder-opacity));\n}\n\n.placeholder-orange-500::placeholder {\n  --placeholder-opacity: 1;\n  color: #ed8936;\n  color: rgba(237, 137, 54, var(--placeholder-opacity));\n}\n\n.placeholder-orange-600::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #dd6b20;\n  color: rgba(221, 107, 32, var(--placeholder-opacity));\n}\n\n.placeholder-orange-600:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #dd6b20;\n  color: rgba(221, 107, 32, var(--placeholder-opacity));\n}\n\n.placeholder-orange-600::placeholder {\n  --placeholder-opacity: 1;\n  color: #dd6b20;\n  color: rgba(221, 107, 32, var(--placeholder-opacity));\n}\n\n.placeholder-orange-700::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #c05621;\n  color: rgba(192, 86, 33, var(--placeholder-opacity));\n}\n\n.placeholder-orange-700:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #c05621;\n  color: rgba(192, 86, 33, var(--placeholder-opacity));\n}\n\n.placeholder-orange-700::placeholder {\n  --placeholder-opacity: 1;\n  color: #c05621;\n  color: rgba(192, 86, 33, var(--placeholder-opacity));\n}\n\n.placeholder-orange-800::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #9c4221;\n  color: rgba(156, 66, 33, var(--placeholder-opacity));\n}\n\n.placeholder-orange-800:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #9c4221;\n  color: rgba(156, 66, 33, var(--placeholder-opacity));\n}\n\n.placeholder-orange-800::placeholder {\n  --placeholder-opacity: 1;\n  color: #9c4221;\n  color: rgba(156, 66, 33, var(--placeholder-opacity));\n}\n\n.placeholder-orange-900::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #7b341e;\n  color: rgba(123, 52, 30, var(--placeholder-opacity));\n}\n\n.placeholder-orange-900:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #7b341e;\n  color: rgba(123, 52, 30, var(--placeholder-opacity));\n}\n\n.placeholder-orange-900::placeholder {\n  --placeholder-opacity: 1;\n  color: #7b341e;\n  color: rgba(123, 52, 30, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-100::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #fffff0;\n  color: rgba(255, 255, 240, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-100:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #fffff0;\n  color: rgba(255, 255, 240, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-100::placeholder {\n  --placeholder-opacity: 1;\n  color: #fffff0;\n  color: rgba(255, 255, 240, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-200::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #fefcbf;\n  color: rgba(254, 252, 191, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-200:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #fefcbf;\n  color: rgba(254, 252, 191, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-200::placeholder {\n  --placeholder-opacity: 1;\n  color: #fefcbf;\n  color: rgba(254, 252, 191, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-300::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #faf089;\n  color: rgba(250, 240, 137, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-300:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #faf089;\n  color: rgba(250, 240, 137, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-300::placeholder {\n  --placeholder-opacity: 1;\n  color: #faf089;\n  color: rgba(250, 240, 137, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-400::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #f6e05e;\n  color: rgba(246, 224, 94, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-400:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #f6e05e;\n  color: rgba(246, 224, 94, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-400::placeholder {\n  --placeholder-opacity: 1;\n  color: #f6e05e;\n  color: rgba(246, 224, 94, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-500::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #ecc94b;\n  color: rgba(236, 201, 75, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-500:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #ecc94b;\n  color: rgba(236, 201, 75, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-500::placeholder {\n  --placeholder-opacity: 1;\n  color: #ecc94b;\n  color: rgba(236, 201, 75, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-600::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #d69e2e;\n  color: rgba(214, 158, 46, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-600:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #d69e2e;\n  color: rgba(214, 158, 46, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-600::placeholder {\n  --placeholder-opacity: 1;\n  color: #d69e2e;\n  color: rgba(214, 158, 46, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-700::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #b7791f;\n  color: rgba(183, 121, 31, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-700:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #b7791f;\n  color: rgba(183, 121, 31, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-700::placeholder {\n  --placeholder-opacity: 1;\n  color: #b7791f;\n  color: rgba(183, 121, 31, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-800::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #975a16;\n  color: rgba(151, 90, 22, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-800:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #975a16;\n  color: rgba(151, 90, 22, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-800::placeholder {\n  --placeholder-opacity: 1;\n  color: #975a16;\n  color: rgba(151, 90, 22, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-900::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #744210;\n  color: rgba(116, 66, 16, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-900:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #744210;\n  color: rgba(116, 66, 16, var(--placeholder-opacity));\n}\n\n.placeholder-yellow-900::placeholder {\n  --placeholder-opacity: 1;\n  color: #744210;\n  color: rgba(116, 66, 16, var(--placeholder-opacity));\n}\n\n.placeholder-green-100::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #f0fff4;\n  color: rgba(240, 255, 244, var(--placeholder-opacity));\n}\n\n.placeholder-green-100:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #f0fff4;\n  color: rgba(240, 255, 244, var(--placeholder-opacity));\n}\n\n.placeholder-green-100::placeholder {\n  --placeholder-opacity: 1;\n  color: #f0fff4;\n  color: rgba(240, 255, 244, var(--placeholder-opacity));\n}\n\n.placeholder-green-200::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #c6f6d5;\n  color: rgba(198, 246, 213, var(--placeholder-opacity));\n}\n\n.placeholder-green-200:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #c6f6d5;\n  color: rgba(198, 246, 213, var(--placeholder-opacity));\n}\n\n.placeholder-green-200::placeholder {\n  --placeholder-opacity: 1;\n  color: #c6f6d5;\n  color: rgba(198, 246, 213, var(--placeholder-opacity));\n}\n\n.placeholder-green-300::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #9ae6b4;\n  color: rgba(154, 230, 180, var(--placeholder-opacity));\n}\n\n.placeholder-green-300:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #9ae6b4;\n  color: rgba(154, 230, 180, var(--placeholder-opacity));\n}\n\n.placeholder-green-300::placeholder {\n  --placeholder-opacity: 1;\n  color: #9ae6b4;\n  color: rgba(154, 230, 180, var(--placeholder-opacity));\n}\n\n.placeholder-green-400::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #68d391;\n  color: rgba(104, 211, 145, var(--placeholder-opacity));\n}\n\n.placeholder-green-400:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #68d391;\n  color: rgba(104, 211, 145, var(--placeholder-opacity));\n}\n\n.placeholder-green-400::placeholder {\n  --placeholder-opacity: 1;\n  color: #68d391;\n  color: rgba(104, 211, 145, var(--placeholder-opacity));\n}\n\n.placeholder-green-500::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #48bb78;\n  color: rgba(72, 187, 120, var(--placeholder-opacity));\n}\n\n.placeholder-green-500:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #48bb78;\n  color: rgba(72, 187, 120, var(--placeholder-opacity));\n}\n\n.placeholder-green-500::placeholder {\n  --placeholder-opacity: 1;\n  color: #48bb78;\n  color: rgba(72, 187, 120, var(--placeholder-opacity));\n}\n\n.placeholder-green-600::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #38a169;\n  color: rgba(56, 161, 105, var(--placeholder-opacity));\n}\n\n.placeholder-green-600:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #38a169;\n  color: rgba(56, 161, 105, var(--placeholder-opacity));\n}\n\n.placeholder-green-600::placeholder {\n  --placeholder-opacity: 1;\n  color: #38a169;\n  color: rgba(56, 161, 105, var(--placeholder-opacity));\n}\n\n.placeholder-green-700::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #2f855a;\n  color: rgba(47, 133, 90, var(--placeholder-opacity));\n}\n\n.placeholder-green-700:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #2f855a;\n  color: rgba(47, 133, 90, var(--placeholder-opacity));\n}\n\n.placeholder-green-700::placeholder {\n  --placeholder-opacity: 1;\n  color: #2f855a;\n  color: rgba(47, 133, 90, var(--placeholder-opacity));\n}\n\n.placeholder-green-800::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #276749;\n  color: rgba(39, 103, 73, var(--placeholder-opacity));\n}\n\n.placeholder-green-800:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #276749;\n  color: rgba(39, 103, 73, var(--placeholder-opacity));\n}\n\n.placeholder-green-800::placeholder {\n  --placeholder-opacity: 1;\n  color: #276749;\n  color: rgba(39, 103, 73, var(--placeholder-opacity));\n}\n\n.placeholder-green-900::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #22543d;\n  color: rgba(34, 84, 61, var(--placeholder-opacity));\n}\n\n.placeholder-green-900:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #22543d;\n  color: rgba(34, 84, 61, var(--placeholder-opacity));\n}\n\n.placeholder-green-900::placeholder {\n  --placeholder-opacity: 1;\n  color: #22543d;\n  color: rgba(34, 84, 61, var(--placeholder-opacity));\n}\n\n.placeholder-teal-100::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #e6fffa;\n  color: rgba(230, 255, 250, var(--placeholder-opacity));\n}\n\n.placeholder-teal-100:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #e6fffa;\n  color: rgba(230, 255, 250, var(--placeholder-opacity));\n}\n\n.placeholder-teal-100::placeholder {\n  --placeholder-opacity: 1;\n  color: #e6fffa;\n  color: rgba(230, 255, 250, var(--placeholder-opacity));\n}\n\n.placeholder-teal-200::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #b2f5ea;\n  color: rgba(178, 245, 234, var(--placeholder-opacity));\n}\n\n.placeholder-teal-200:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #b2f5ea;\n  color: rgba(178, 245, 234, var(--placeholder-opacity));\n}\n\n.placeholder-teal-200::placeholder {\n  --placeholder-opacity: 1;\n  color: #b2f5ea;\n  color: rgba(178, 245, 234, var(--placeholder-opacity));\n}\n\n.placeholder-teal-300::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #81e6d9;\n  color: rgba(129, 230, 217, var(--placeholder-opacity));\n}\n\n.placeholder-teal-300:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #81e6d9;\n  color: rgba(129, 230, 217, var(--placeholder-opacity));\n}\n\n.placeholder-teal-300::placeholder {\n  --placeholder-opacity: 1;\n  color: #81e6d9;\n  color: rgba(129, 230, 217, var(--placeholder-opacity));\n}\n\n.placeholder-teal-400::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #4fd1c5;\n  color: rgba(79, 209, 197, var(--placeholder-opacity));\n}\n\n.placeholder-teal-400:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #4fd1c5;\n  color: rgba(79, 209, 197, var(--placeholder-opacity));\n}\n\n.placeholder-teal-400::placeholder {\n  --placeholder-opacity: 1;\n  color: #4fd1c5;\n  color: rgba(79, 209, 197, var(--placeholder-opacity));\n}\n\n.placeholder-teal-500::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #38b2ac;\n  color: rgba(56, 178, 172, var(--placeholder-opacity));\n}\n\n.placeholder-teal-500:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #38b2ac;\n  color: rgba(56, 178, 172, var(--placeholder-opacity));\n}\n\n.placeholder-teal-500::placeholder {\n  --placeholder-opacity: 1;\n  color: #38b2ac;\n  color: rgba(56, 178, 172, var(--placeholder-opacity));\n}\n\n.placeholder-teal-600::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #319795;\n  color: rgba(49, 151, 149, var(--placeholder-opacity));\n}\n\n.placeholder-teal-600:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #319795;\n  color: rgba(49, 151, 149, var(--placeholder-opacity));\n}\n\n.placeholder-teal-600::placeholder {\n  --placeholder-opacity: 1;\n  color: #319795;\n  color: rgba(49, 151, 149, var(--placeholder-opacity));\n}\n\n.placeholder-teal-700::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #2c7a7b;\n  color: rgba(44, 122, 123, var(--placeholder-opacity));\n}\n\n.placeholder-teal-700:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #2c7a7b;\n  color: rgba(44, 122, 123, var(--placeholder-opacity));\n}\n\n.placeholder-teal-700::placeholder {\n  --placeholder-opacity: 1;\n  color: #2c7a7b;\n  color: rgba(44, 122, 123, var(--placeholder-opacity));\n}\n\n.placeholder-teal-800::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #285e61;\n  color: rgba(40, 94, 97, var(--placeholder-opacity));\n}\n\n.placeholder-teal-800:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #285e61;\n  color: rgba(40, 94, 97, var(--placeholder-opacity));\n}\n\n.placeholder-teal-800::placeholder {\n  --placeholder-opacity: 1;\n  color: #285e61;\n  color: rgba(40, 94, 97, var(--placeholder-opacity));\n}\n\n.placeholder-teal-900::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #234e52;\n  color: rgba(35, 78, 82, var(--placeholder-opacity));\n}\n\n.placeholder-teal-900:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #234e52;\n  color: rgba(35, 78, 82, var(--placeholder-opacity));\n}\n\n.placeholder-teal-900::placeholder {\n  --placeholder-opacity: 1;\n  color: #234e52;\n  color: rgba(35, 78, 82, var(--placeholder-opacity));\n}\n\n.placeholder-blue-100::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #ebf8ff;\n  color: rgba(235, 248, 255, var(--placeholder-opacity));\n}\n\n.placeholder-blue-100:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #ebf8ff;\n  color: rgba(235, 248, 255, var(--placeholder-opacity));\n}\n\n.placeholder-blue-100::placeholder {\n  --placeholder-opacity: 1;\n  color: #ebf8ff;\n  color: rgba(235, 248, 255, var(--placeholder-opacity));\n}\n\n.placeholder-blue-200::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #bee3f8;\n  color: rgba(190, 227, 248, var(--placeholder-opacity));\n}\n\n.placeholder-blue-200:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #bee3f8;\n  color: rgba(190, 227, 248, var(--placeholder-opacity));\n}\n\n.placeholder-blue-200::placeholder {\n  --placeholder-opacity: 1;\n  color: #bee3f8;\n  color: rgba(190, 227, 248, var(--placeholder-opacity));\n}\n\n.placeholder-blue-300::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #90cdf4;\n  color: rgba(144, 205, 244, var(--placeholder-opacity));\n}\n\n.placeholder-blue-300:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #90cdf4;\n  color: rgba(144, 205, 244, var(--placeholder-opacity));\n}\n\n.placeholder-blue-300::placeholder {\n  --placeholder-opacity: 1;\n  color: #90cdf4;\n  color: rgba(144, 205, 244, var(--placeholder-opacity));\n}\n\n.placeholder-blue-400::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #63b3ed;\n  color: rgba(99, 179, 237, var(--placeholder-opacity));\n}\n\n.placeholder-blue-400:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #63b3ed;\n  color: rgba(99, 179, 237, var(--placeholder-opacity));\n}\n\n.placeholder-blue-400::placeholder {\n  --placeholder-opacity: 1;\n  color: #63b3ed;\n  color: rgba(99, 179, 237, var(--placeholder-opacity));\n}\n\n.placeholder-blue-500::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #4299e1;\n  color: rgba(66, 153, 225, var(--placeholder-opacity));\n}\n\n.placeholder-blue-500:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #4299e1;\n  color: rgba(66, 153, 225, var(--placeholder-opacity));\n}\n\n.placeholder-blue-500::placeholder {\n  --placeholder-opacity: 1;\n  color: #4299e1;\n  color: rgba(66, 153, 225, var(--placeholder-opacity));\n}\n\n.placeholder-blue-600::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #3182ce;\n  color: rgba(49, 130, 206, var(--placeholder-opacity));\n}\n\n.placeholder-blue-600:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #3182ce;\n  color: rgba(49, 130, 206, var(--placeholder-opacity));\n}\n\n.placeholder-blue-600::placeholder {\n  --placeholder-opacity: 1;\n  color: #3182ce;\n  color: rgba(49, 130, 206, var(--placeholder-opacity));\n}\n\n.placeholder-blue-700::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #2b6cb0;\n  color: rgba(43, 108, 176, var(--placeholder-opacity));\n}\n\n.placeholder-blue-700:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #2b6cb0;\n  color: rgba(43, 108, 176, var(--placeholder-opacity));\n}\n\n.placeholder-blue-700::placeholder {\n  --placeholder-opacity: 1;\n  color: #2b6cb0;\n  color: rgba(43, 108, 176, var(--placeholder-opacity));\n}\n\n.placeholder-blue-800::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #2c5282;\n  color: rgba(44, 82, 130, var(--placeholder-opacity));\n}\n\n.placeholder-blue-800:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #2c5282;\n  color: rgba(44, 82, 130, var(--placeholder-opacity));\n}\n\n.placeholder-blue-800::placeholder {\n  --placeholder-opacity: 1;\n  color: #2c5282;\n  color: rgba(44, 82, 130, var(--placeholder-opacity));\n}\n\n.placeholder-blue-900::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #2a4365;\n  color: rgba(42, 67, 101, var(--placeholder-opacity));\n}\n\n.placeholder-blue-900:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #2a4365;\n  color: rgba(42, 67, 101, var(--placeholder-opacity));\n}\n\n.placeholder-blue-900::placeholder {\n  --placeholder-opacity: 1;\n  color: #2a4365;\n  color: rgba(42, 67, 101, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-100::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #ebf4ff;\n  color: rgba(235, 244, 255, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-100:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #ebf4ff;\n  color: rgba(235, 244, 255, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-100::placeholder {\n  --placeholder-opacity: 1;\n  color: #ebf4ff;\n  color: rgba(235, 244, 255, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-200::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #c3dafe;\n  color: rgba(195, 218, 254, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-200:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #c3dafe;\n  color: rgba(195, 218, 254, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-200::placeholder {\n  --placeholder-opacity: 1;\n  color: #c3dafe;\n  color: rgba(195, 218, 254, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-300::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #a3bffa;\n  color: rgba(163, 191, 250, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-300:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #a3bffa;\n  color: rgba(163, 191, 250, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-300::placeholder {\n  --placeholder-opacity: 1;\n  color: #a3bffa;\n  color: rgba(163, 191, 250, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-400::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #7f9cf5;\n  color: rgba(127, 156, 245, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-400:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #7f9cf5;\n  color: rgba(127, 156, 245, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-400::placeholder {\n  --placeholder-opacity: 1;\n  color: #7f9cf5;\n  color: rgba(127, 156, 245, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-500::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #667eea;\n  color: rgba(102, 126, 234, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-500:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #667eea;\n  color: rgba(102, 126, 234, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-500::placeholder {\n  --placeholder-opacity: 1;\n  color: #667eea;\n  color: rgba(102, 126, 234, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-600::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #5a67d8;\n  color: rgba(90, 103, 216, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-600:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #5a67d8;\n  color: rgba(90, 103, 216, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-600::placeholder {\n  --placeholder-opacity: 1;\n  color: #5a67d8;\n  color: rgba(90, 103, 216, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-700::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #4c51bf;\n  color: rgba(76, 81, 191, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-700:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #4c51bf;\n  color: rgba(76, 81, 191, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-700::placeholder {\n  --placeholder-opacity: 1;\n  color: #4c51bf;\n  color: rgba(76, 81, 191, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-800::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #434190;\n  color: rgba(67, 65, 144, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-800:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #434190;\n  color: rgba(67, 65, 144, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-800::placeholder {\n  --placeholder-opacity: 1;\n  color: #434190;\n  color: rgba(67, 65, 144, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-900::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #3c366b;\n  color: rgba(60, 54, 107, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-900:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #3c366b;\n  color: rgba(60, 54, 107, var(--placeholder-opacity));\n}\n\n.placeholder-indigo-900::placeholder {\n  --placeholder-opacity: 1;\n  color: #3c366b;\n  color: rgba(60, 54, 107, var(--placeholder-opacity));\n}\n\n.placeholder-purple-100::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #faf5ff;\n  color: rgba(250, 245, 255, var(--placeholder-opacity));\n}\n\n.placeholder-purple-100:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #faf5ff;\n  color: rgba(250, 245, 255, var(--placeholder-opacity));\n}\n\n.placeholder-purple-100::placeholder {\n  --placeholder-opacity: 1;\n  color: #faf5ff;\n  color: rgba(250, 245, 255, var(--placeholder-opacity));\n}\n\n.placeholder-purple-200::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #e9d8fd;\n  color: rgba(233, 216, 253, var(--placeholder-opacity));\n}\n\n.placeholder-purple-200:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #e9d8fd;\n  color: rgba(233, 216, 253, var(--placeholder-opacity));\n}\n\n.placeholder-purple-200::placeholder {\n  --placeholder-opacity: 1;\n  color: #e9d8fd;\n  color: rgba(233, 216, 253, var(--placeholder-opacity));\n}\n\n.placeholder-purple-300::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #d6bcfa;\n  color: rgba(214, 188, 250, var(--placeholder-opacity));\n}\n\n.placeholder-purple-300:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #d6bcfa;\n  color: rgba(214, 188, 250, var(--placeholder-opacity));\n}\n\n.placeholder-purple-300::placeholder {\n  --placeholder-opacity: 1;\n  color: #d6bcfa;\n  color: rgba(214, 188, 250, var(--placeholder-opacity));\n}\n\n.placeholder-purple-400::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #b794f4;\n  color: rgba(183, 148, 244, var(--placeholder-opacity));\n}\n\n.placeholder-purple-400:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #b794f4;\n  color: rgba(183, 148, 244, var(--placeholder-opacity));\n}\n\n.placeholder-purple-400::placeholder {\n  --placeholder-opacity: 1;\n  color: #b794f4;\n  color: rgba(183, 148, 244, var(--placeholder-opacity));\n}\n\n.placeholder-purple-500::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #9f7aea;\n  color: rgba(159, 122, 234, var(--placeholder-opacity));\n}\n\n.placeholder-purple-500:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #9f7aea;\n  color: rgba(159, 122, 234, var(--placeholder-opacity));\n}\n\n.placeholder-purple-500::placeholder {\n  --placeholder-opacity: 1;\n  color: #9f7aea;\n  color: rgba(159, 122, 234, var(--placeholder-opacity));\n}\n\n.placeholder-purple-600::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #805ad5;\n  color: rgba(128, 90, 213, var(--placeholder-opacity));\n}\n\n.placeholder-purple-600:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #805ad5;\n  color: rgba(128, 90, 213, var(--placeholder-opacity));\n}\n\n.placeholder-purple-600::placeholder {\n  --placeholder-opacity: 1;\n  color: #805ad5;\n  color: rgba(128, 90, 213, var(--placeholder-opacity));\n}\n\n.placeholder-purple-700::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #6b46c1;\n  color: rgba(107, 70, 193, var(--placeholder-opacity));\n}\n\n.placeholder-purple-700:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #6b46c1;\n  color: rgba(107, 70, 193, var(--placeholder-opacity));\n}\n\n.placeholder-purple-700::placeholder {\n  --placeholder-opacity: 1;\n  color: #6b46c1;\n  color: rgba(107, 70, 193, var(--placeholder-opacity));\n}\n\n.placeholder-purple-800::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #553c9a;\n  color: rgba(85, 60, 154, var(--placeholder-opacity));\n}\n\n.placeholder-purple-800:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #553c9a;\n  color: rgba(85, 60, 154, var(--placeholder-opacity));\n}\n\n.placeholder-purple-800::placeholder {\n  --placeholder-opacity: 1;\n  color: #553c9a;\n  color: rgba(85, 60, 154, var(--placeholder-opacity));\n}\n\n.placeholder-purple-900::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #44337a;\n  color: rgba(68, 51, 122, var(--placeholder-opacity));\n}\n\n.placeholder-purple-900:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #44337a;\n  color: rgba(68, 51, 122, var(--placeholder-opacity));\n}\n\n.placeholder-purple-900::placeholder {\n  --placeholder-opacity: 1;\n  color: #44337a;\n  color: rgba(68, 51, 122, var(--placeholder-opacity));\n}\n\n.placeholder-pink-100::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #fff5f7;\n  color: rgba(255, 245, 247, var(--placeholder-opacity));\n}\n\n.placeholder-pink-100:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #fff5f7;\n  color: rgba(255, 245, 247, var(--placeholder-opacity));\n}\n\n.placeholder-pink-100::placeholder {\n  --placeholder-opacity: 1;\n  color: #fff5f7;\n  color: rgba(255, 245, 247, var(--placeholder-opacity));\n}\n\n.placeholder-pink-200::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #fed7e2;\n  color: rgba(254, 215, 226, var(--placeholder-opacity));\n}\n\n.placeholder-pink-200:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #fed7e2;\n  color: rgba(254, 215, 226, var(--placeholder-opacity));\n}\n\n.placeholder-pink-200::placeholder {\n  --placeholder-opacity: 1;\n  color: #fed7e2;\n  color: rgba(254, 215, 226, var(--placeholder-opacity));\n}\n\n.placeholder-pink-300::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #fbb6ce;\n  color: rgba(251, 182, 206, var(--placeholder-opacity));\n}\n\n.placeholder-pink-300:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #fbb6ce;\n  color: rgba(251, 182, 206, var(--placeholder-opacity));\n}\n\n.placeholder-pink-300::placeholder {\n  --placeholder-opacity: 1;\n  color: #fbb6ce;\n  color: rgba(251, 182, 206, var(--placeholder-opacity));\n}\n\n.placeholder-pink-400::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #f687b3;\n  color: rgba(246, 135, 179, var(--placeholder-opacity));\n}\n\n.placeholder-pink-400:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #f687b3;\n  color: rgba(246, 135, 179, var(--placeholder-opacity));\n}\n\n.placeholder-pink-400::placeholder {\n  --placeholder-opacity: 1;\n  color: #f687b3;\n  color: rgba(246, 135, 179, var(--placeholder-opacity));\n}\n\n.placeholder-pink-500::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #ed64a6;\n  color: rgba(237, 100, 166, var(--placeholder-opacity));\n}\n\n.placeholder-pink-500:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #ed64a6;\n  color: rgba(237, 100, 166, var(--placeholder-opacity));\n}\n\n.placeholder-pink-500::placeholder {\n  --placeholder-opacity: 1;\n  color: #ed64a6;\n  color: rgba(237, 100, 166, var(--placeholder-opacity));\n}\n\n.placeholder-pink-600::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #d53f8c;\n  color: rgba(213, 63, 140, var(--placeholder-opacity));\n}\n\n.placeholder-pink-600:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #d53f8c;\n  color: rgba(213, 63, 140, var(--placeholder-opacity));\n}\n\n.placeholder-pink-600::placeholder {\n  --placeholder-opacity: 1;\n  color: #d53f8c;\n  color: rgba(213, 63, 140, var(--placeholder-opacity));\n}\n\n.placeholder-pink-700::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #b83280;\n  color: rgba(184, 50, 128, var(--placeholder-opacity));\n}\n\n.placeholder-pink-700:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #b83280;\n  color: rgba(184, 50, 128, var(--placeholder-opacity));\n}\n\n.placeholder-pink-700::placeholder {\n  --placeholder-opacity: 1;\n  color: #b83280;\n  color: rgba(184, 50, 128, var(--placeholder-opacity));\n}\n\n.placeholder-pink-800::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #97266d;\n  color: rgba(151, 38, 109, var(--placeholder-opacity));\n}\n\n.placeholder-pink-800:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #97266d;\n  color: rgba(151, 38, 109, var(--placeholder-opacity));\n}\n\n.placeholder-pink-800::placeholder {\n  --placeholder-opacity: 1;\n  color: #97266d;\n  color: rgba(151, 38, 109, var(--placeholder-opacity));\n}\n\n.placeholder-pink-900::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #702459;\n  color: rgba(112, 36, 89, var(--placeholder-opacity));\n}\n\n.placeholder-pink-900:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #702459;\n  color: rgba(112, 36, 89, var(--placeholder-opacity));\n}\n\n.placeholder-pink-900::placeholder {\n  --placeholder-opacity: 1;\n  color: #702459;\n  color: rgba(112, 36, 89, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-transparent:focus::-moz-placeholder {\n  color: transparent;\n}\n\n.focus\\:placeholder-transparent:focus:-ms-input-placeholder {\n  color: transparent;\n}\n\n.focus\\:placeholder-transparent:focus::placeholder {\n  color: transparent;\n}\n\n.focus\\:placeholder-current:focus::-moz-placeholder {\n  color: currentColor;\n}\n\n.focus\\:placeholder-current:focus:-ms-input-placeholder {\n  color: currentColor;\n}\n\n.focus\\:placeholder-current:focus::placeholder {\n  color: currentColor;\n}\n\n.focus\\:placeholder-black:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #000;\n  color: rgba(0, 0, 0, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-black:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #000;\n  color: rgba(0, 0, 0, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-black:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #000;\n  color: rgba(0, 0, 0, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-white:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #fff;\n  color: rgba(255, 255, 255, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-white:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #fff;\n  color: rgba(255, 255, 255, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-white:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #fff;\n  color: rgba(255, 255, 255, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-100:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #f7fafc;\n  color: rgba(247, 250, 252, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-100:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #f7fafc;\n  color: rgba(247, 250, 252, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-100:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #f7fafc;\n  color: rgba(247, 250, 252, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-200:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #edf2f7;\n  color: rgba(237, 242, 247, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-200:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #edf2f7;\n  color: rgba(237, 242, 247, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-200:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #edf2f7;\n  color: rgba(237, 242, 247, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-300:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #e2e8f0;\n  color: rgba(226, 232, 240, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-300:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #e2e8f0;\n  color: rgba(226, 232, 240, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-300:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #e2e8f0;\n  color: rgba(226, 232, 240, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-400:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #cbd5e0;\n  color: rgba(203, 213, 224, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-400:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #cbd5e0;\n  color: rgba(203, 213, 224, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-400:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #cbd5e0;\n  color: rgba(203, 213, 224, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-500:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #a0aec0;\n  color: rgba(160, 174, 192, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-500:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #a0aec0;\n  color: rgba(160, 174, 192, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-500:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #a0aec0;\n  color: rgba(160, 174, 192, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-600:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #718096;\n  color: rgba(113, 128, 150, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-600:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #718096;\n  color: rgba(113, 128, 150, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-600:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #718096;\n  color: rgba(113, 128, 150, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-700:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #4a5568;\n  color: rgba(74, 85, 104, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-700:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #4a5568;\n  color: rgba(74, 85, 104, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-700:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #4a5568;\n  color: rgba(74, 85, 104, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-800:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #2d3748;\n  color: rgba(45, 55, 72, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-800:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #2d3748;\n  color: rgba(45, 55, 72, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-800:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #2d3748;\n  color: rgba(45, 55, 72, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-900:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #1a202c;\n  color: rgba(26, 32, 44, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-900:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #1a202c;\n  color: rgba(26, 32, 44, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-gray-900:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #1a202c;\n  color: rgba(26, 32, 44, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-100:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #fff5f5;\n  color: rgba(255, 245, 245, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-100:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #fff5f5;\n  color: rgba(255, 245, 245, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-100:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #fff5f5;\n  color: rgba(255, 245, 245, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-200:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #fed7d7;\n  color: rgba(254, 215, 215, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-200:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #fed7d7;\n  color: rgba(254, 215, 215, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-200:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #fed7d7;\n  color: rgba(254, 215, 215, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-300:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #feb2b2;\n  color: rgba(254, 178, 178, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-300:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #feb2b2;\n  color: rgba(254, 178, 178, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-300:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #feb2b2;\n  color: rgba(254, 178, 178, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-400:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #fc8181;\n  color: rgba(252, 129, 129, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-400:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #fc8181;\n  color: rgba(252, 129, 129, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-400:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #fc8181;\n  color: rgba(252, 129, 129, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-500:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #f56565;\n  color: rgba(245, 101, 101, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-500:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #f56565;\n  color: rgba(245, 101, 101, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-500:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #f56565;\n  color: rgba(245, 101, 101, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-600:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #e53e3e;\n  color: rgba(229, 62, 62, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-600:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #e53e3e;\n  color: rgba(229, 62, 62, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-600:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #e53e3e;\n  color: rgba(229, 62, 62, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-700:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #c53030;\n  color: rgba(197, 48, 48, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-700:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #c53030;\n  color: rgba(197, 48, 48, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-700:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #c53030;\n  color: rgba(197, 48, 48, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-800:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #9b2c2c;\n  color: rgba(155, 44, 44, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-800:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #9b2c2c;\n  color: rgba(155, 44, 44, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-800:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #9b2c2c;\n  color: rgba(155, 44, 44, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-900:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #742a2a;\n  color: rgba(116, 42, 42, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-900:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #742a2a;\n  color: rgba(116, 42, 42, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-red-900:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #742a2a;\n  color: rgba(116, 42, 42, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-100:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #fffaf0;\n  color: rgba(255, 250, 240, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-100:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #fffaf0;\n  color: rgba(255, 250, 240, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-100:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #fffaf0;\n  color: rgba(255, 250, 240, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-200:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #feebc8;\n  color: rgba(254, 235, 200, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-200:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #feebc8;\n  color: rgba(254, 235, 200, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-200:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #feebc8;\n  color: rgba(254, 235, 200, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-300:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #fbd38d;\n  color: rgba(251, 211, 141, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-300:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #fbd38d;\n  color: rgba(251, 211, 141, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-300:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #fbd38d;\n  color: rgba(251, 211, 141, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-400:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #f6ad55;\n  color: rgba(246, 173, 85, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-400:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #f6ad55;\n  color: rgba(246, 173, 85, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-400:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #f6ad55;\n  color: rgba(246, 173, 85, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-500:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #ed8936;\n  color: rgba(237, 137, 54, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-500:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #ed8936;\n  color: rgba(237, 137, 54, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-500:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #ed8936;\n  color: rgba(237, 137, 54, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-600:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #dd6b20;\n  color: rgba(221, 107, 32, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-600:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #dd6b20;\n  color: rgba(221, 107, 32, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-600:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #dd6b20;\n  color: rgba(221, 107, 32, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-700:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #c05621;\n  color: rgba(192, 86, 33, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-700:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #c05621;\n  color: rgba(192, 86, 33, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-700:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #c05621;\n  color: rgba(192, 86, 33, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-800:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #9c4221;\n  color: rgba(156, 66, 33, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-800:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #9c4221;\n  color: rgba(156, 66, 33, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-800:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #9c4221;\n  color: rgba(156, 66, 33, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-900:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #7b341e;\n  color: rgba(123, 52, 30, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-900:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #7b341e;\n  color: rgba(123, 52, 30, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-orange-900:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #7b341e;\n  color: rgba(123, 52, 30, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-100:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #fffff0;\n  color: rgba(255, 255, 240, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-100:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #fffff0;\n  color: rgba(255, 255, 240, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-100:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #fffff0;\n  color: rgba(255, 255, 240, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-200:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #fefcbf;\n  color: rgba(254, 252, 191, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-200:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #fefcbf;\n  color: rgba(254, 252, 191, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-200:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #fefcbf;\n  color: rgba(254, 252, 191, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-300:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #faf089;\n  color: rgba(250, 240, 137, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-300:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #faf089;\n  color: rgba(250, 240, 137, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-300:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #faf089;\n  color: rgba(250, 240, 137, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-400:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #f6e05e;\n  color: rgba(246, 224, 94, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-400:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #f6e05e;\n  color: rgba(246, 224, 94, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-400:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #f6e05e;\n  color: rgba(246, 224, 94, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-500:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #ecc94b;\n  color: rgba(236, 201, 75, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-500:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #ecc94b;\n  color: rgba(236, 201, 75, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-500:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #ecc94b;\n  color: rgba(236, 201, 75, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-600:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #d69e2e;\n  color: rgba(214, 158, 46, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-600:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #d69e2e;\n  color: rgba(214, 158, 46, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-600:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #d69e2e;\n  color: rgba(214, 158, 46, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-700:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #b7791f;\n  color: rgba(183, 121, 31, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-700:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #b7791f;\n  color: rgba(183, 121, 31, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-700:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #b7791f;\n  color: rgba(183, 121, 31, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-800:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #975a16;\n  color: rgba(151, 90, 22, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-800:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #975a16;\n  color: rgba(151, 90, 22, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-800:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #975a16;\n  color: rgba(151, 90, 22, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-900:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #744210;\n  color: rgba(116, 66, 16, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-900:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #744210;\n  color: rgba(116, 66, 16, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-yellow-900:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #744210;\n  color: rgba(116, 66, 16, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-100:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #f0fff4;\n  color: rgba(240, 255, 244, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-100:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #f0fff4;\n  color: rgba(240, 255, 244, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-100:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #f0fff4;\n  color: rgba(240, 255, 244, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-200:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #c6f6d5;\n  color: rgba(198, 246, 213, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-200:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #c6f6d5;\n  color: rgba(198, 246, 213, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-200:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #c6f6d5;\n  color: rgba(198, 246, 213, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-300:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #9ae6b4;\n  color: rgba(154, 230, 180, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-300:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #9ae6b4;\n  color: rgba(154, 230, 180, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-300:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #9ae6b4;\n  color: rgba(154, 230, 180, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-400:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #68d391;\n  color: rgba(104, 211, 145, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-400:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #68d391;\n  color: rgba(104, 211, 145, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-400:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #68d391;\n  color: rgba(104, 211, 145, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-500:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #48bb78;\n  color: rgba(72, 187, 120, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-500:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #48bb78;\n  color: rgba(72, 187, 120, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-500:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #48bb78;\n  color: rgba(72, 187, 120, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-600:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #38a169;\n  color: rgba(56, 161, 105, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-600:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #38a169;\n  color: rgba(56, 161, 105, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-600:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #38a169;\n  color: rgba(56, 161, 105, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-700:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #2f855a;\n  color: rgba(47, 133, 90, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-700:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #2f855a;\n  color: rgba(47, 133, 90, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-700:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #2f855a;\n  color: rgba(47, 133, 90, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-800:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #276749;\n  color: rgba(39, 103, 73, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-800:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #276749;\n  color: rgba(39, 103, 73, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-800:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #276749;\n  color: rgba(39, 103, 73, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-900:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #22543d;\n  color: rgba(34, 84, 61, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-900:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #22543d;\n  color: rgba(34, 84, 61, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-green-900:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #22543d;\n  color: rgba(34, 84, 61, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-100:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #e6fffa;\n  color: rgba(230, 255, 250, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-100:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #e6fffa;\n  color: rgba(230, 255, 250, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-100:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #e6fffa;\n  color: rgba(230, 255, 250, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-200:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #b2f5ea;\n  color: rgba(178, 245, 234, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-200:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #b2f5ea;\n  color: rgba(178, 245, 234, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-200:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #b2f5ea;\n  color: rgba(178, 245, 234, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-300:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #81e6d9;\n  color: rgba(129, 230, 217, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-300:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #81e6d9;\n  color: rgba(129, 230, 217, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-300:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #81e6d9;\n  color: rgba(129, 230, 217, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-400:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #4fd1c5;\n  color: rgba(79, 209, 197, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-400:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #4fd1c5;\n  color: rgba(79, 209, 197, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-400:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #4fd1c5;\n  color: rgba(79, 209, 197, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-500:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #38b2ac;\n  color: rgba(56, 178, 172, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-500:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #38b2ac;\n  color: rgba(56, 178, 172, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-500:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #38b2ac;\n  color: rgba(56, 178, 172, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-600:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #319795;\n  color: rgba(49, 151, 149, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-600:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #319795;\n  color: rgba(49, 151, 149, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-600:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #319795;\n  color: rgba(49, 151, 149, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-700:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #2c7a7b;\n  color: rgba(44, 122, 123, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-700:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #2c7a7b;\n  color: rgba(44, 122, 123, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-700:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #2c7a7b;\n  color: rgba(44, 122, 123, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-800:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #285e61;\n  color: rgba(40, 94, 97, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-800:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #285e61;\n  color: rgba(40, 94, 97, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-800:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #285e61;\n  color: rgba(40, 94, 97, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-900:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #234e52;\n  color: rgba(35, 78, 82, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-900:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #234e52;\n  color: rgba(35, 78, 82, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-teal-900:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #234e52;\n  color: rgba(35, 78, 82, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-100:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #ebf8ff;\n  color: rgba(235, 248, 255, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-100:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #ebf8ff;\n  color: rgba(235, 248, 255, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-100:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #ebf8ff;\n  color: rgba(235, 248, 255, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-200:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #bee3f8;\n  color: rgba(190, 227, 248, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-200:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #bee3f8;\n  color: rgba(190, 227, 248, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-200:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #bee3f8;\n  color: rgba(190, 227, 248, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-300:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #90cdf4;\n  color: rgba(144, 205, 244, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-300:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #90cdf4;\n  color: rgba(144, 205, 244, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-300:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #90cdf4;\n  color: rgba(144, 205, 244, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-400:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #63b3ed;\n  color: rgba(99, 179, 237, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-400:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #63b3ed;\n  color: rgba(99, 179, 237, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-400:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #63b3ed;\n  color: rgba(99, 179, 237, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-500:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #4299e1;\n  color: rgba(66, 153, 225, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-500:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #4299e1;\n  color: rgba(66, 153, 225, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-500:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #4299e1;\n  color: rgba(66, 153, 225, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-600:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #3182ce;\n  color: rgba(49, 130, 206, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-600:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #3182ce;\n  color: rgba(49, 130, 206, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-600:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #3182ce;\n  color: rgba(49, 130, 206, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-700:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #2b6cb0;\n  color: rgba(43, 108, 176, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-700:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #2b6cb0;\n  color: rgba(43, 108, 176, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-700:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #2b6cb0;\n  color: rgba(43, 108, 176, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-800:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #2c5282;\n  color: rgba(44, 82, 130, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-800:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #2c5282;\n  color: rgba(44, 82, 130, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-800:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #2c5282;\n  color: rgba(44, 82, 130, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-900:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #2a4365;\n  color: rgba(42, 67, 101, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-900:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #2a4365;\n  color: rgba(42, 67, 101, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-blue-900:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #2a4365;\n  color: rgba(42, 67, 101, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-100:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #ebf4ff;\n  color: rgba(235, 244, 255, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-100:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #ebf4ff;\n  color: rgba(235, 244, 255, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-100:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #ebf4ff;\n  color: rgba(235, 244, 255, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-200:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #c3dafe;\n  color: rgba(195, 218, 254, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-200:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #c3dafe;\n  color: rgba(195, 218, 254, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-200:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #c3dafe;\n  color: rgba(195, 218, 254, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-300:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #a3bffa;\n  color: rgba(163, 191, 250, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-300:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #a3bffa;\n  color: rgba(163, 191, 250, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-300:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #a3bffa;\n  color: rgba(163, 191, 250, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-400:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #7f9cf5;\n  color: rgba(127, 156, 245, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-400:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #7f9cf5;\n  color: rgba(127, 156, 245, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-400:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #7f9cf5;\n  color: rgba(127, 156, 245, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-500:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #667eea;\n  color: rgba(102, 126, 234, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-500:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #667eea;\n  color: rgba(102, 126, 234, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-500:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #667eea;\n  color: rgba(102, 126, 234, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-600:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #5a67d8;\n  color: rgba(90, 103, 216, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-600:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #5a67d8;\n  color: rgba(90, 103, 216, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-600:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #5a67d8;\n  color: rgba(90, 103, 216, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-700:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #4c51bf;\n  color: rgba(76, 81, 191, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-700:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #4c51bf;\n  color: rgba(76, 81, 191, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-700:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #4c51bf;\n  color: rgba(76, 81, 191, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-800:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #434190;\n  color: rgba(67, 65, 144, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-800:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #434190;\n  color: rgba(67, 65, 144, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-800:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #434190;\n  color: rgba(67, 65, 144, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-900:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #3c366b;\n  color: rgba(60, 54, 107, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-900:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #3c366b;\n  color: rgba(60, 54, 107, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-indigo-900:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #3c366b;\n  color: rgba(60, 54, 107, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-100:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #faf5ff;\n  color: rgba(250, 245, 255, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-100:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #faf5ff;\n  color: rgba(250, 245, 255, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-100:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #faf5ff;\n  color: rgba(250, 245, 255, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-200:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #e9d8fd;\n  color: rgba(233, 216, 253, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-200:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #e9d8fd;\n  color: rgba(233, 216, 253, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-200:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #e9d8fd;\n  color: rgba(233, 216, 253, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-300:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #d6bcfa;\n  color: rgba(214, 188, 250, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-300:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #d6bcfa;\n  color: rgba(214, 188, 250, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-300:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #d6bcfa;\n  color: rgba(214, 188, 250, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-400:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #b794f4;\n  color: rgba(183, 148, 244, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-400:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #b794f4;\n  color: rgba(183, 148, 244, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-400:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #b794f4;\n  color: rgba(183, 148, 244, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-500:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #9f7aea;\n  color: rgba(159, 122, 234, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-500:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #9f7aea;\n  color: rgba(159, 122, 234, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-500:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #9f7aea;\n  color: rgba(159, 122, 234, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-600:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #805ad5;\n  color: rgba(128, 90, 213, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-600:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #805ad5;\n  color: rgba(128, 90, 213, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-600:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #805ad5;\n  color: rgba(128, 90, 213, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-700:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #6b46c1;\n  color: rgba(107, 70, 193, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-700:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #6b46c1;\n  color: rgba(107, 70, 193, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-700:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #6b46c1;\n  color: rgba(107, 70, 193, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-800:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #553c9a;\n  color: rgba(85, 60, 154, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-800:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #553c9a;\n  color: rgba(85, 60, 154, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-800:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #553c9a;\n  color: rgba(85, 60, 154, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-900:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #44337a;\n  color: rgba(68, 51, 122, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-900:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #44337a;\n  color: rgba(68, 51, 122, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-purple-900:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #44337a;\n  color: rgba(68, 51, 122, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-100:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #fff5f7;\n  color: rgba(255, 245, 247, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-100:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #fff5f7;\n  color: rgba(255, 245, 247, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-100:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #fff5f7;\n  color: rgba(255, 245, 247, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-200:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #fed7e2;\n  color: rgba(254, 215, 226, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-200:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #fed7e2;\n  color: rgba(254, 215, 226, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-200:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #fed7e2;\n  color: rgba(254, 215, 226, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-300:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #fbb6ce;\n  color: rgba(251, 182, 206, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-300:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #fbb6ce;\n  color: rgba(251, 182, 206, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-300:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #fbb6ce;\n  color: rgba(251, 182, 206, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-400:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #f687b3;\n  color: rgba(246, 135, 179, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-400:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #f687b3;\n  color: rgba(246, 135, 179, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-400:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #f687b3;\n  color: rgba(246, 135, 179, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-500:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #ed64a6;\n  color: rgba(237, 100, 166, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-500:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #ed64a6;\n  color: rgba(237, 100, 166, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-500:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #ed64a6;\n  color: rgba(237, 100, 166, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-600:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #d53f8c;\n  color: rgba(213, 63, 140, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-600:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #d53f8c;\n  color: rgba(213, 63, 140, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-600:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #d53f8c;\n  color: rgba(213, 63, 140, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-700:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #b83280;\n  color: rgba(184, 50, 128, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-700:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #b83280;\n  color: rgba(184, 50, 128, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-700:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #b83280;\n  color: rgba(184, 50, 128, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-800:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #97266d;\n  color: rgba(151, 38, 109, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-800:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #97266d;\n  color: rgba(151, 38, 109, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-800:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #97266d;\n  color: rgba(151, 38, 109, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-900:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n  color: #702459;\n  color: rgba(112, 36, 89, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-900:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n  color: #702459;\n  color: rgba(112, 36, 89, var(--placeholder-opacity));\n}\n\n.focus\\:placeholder-pink-900:focus::placeholder {\n  --placeholder-opacity: 1;\n  color: #702459;\n  color: rgba(112, 36, 89, var(--placeholder-opacity));\n}\n\n.placeholder-opacity-0::-moz-placeholder {\n  --placeholder-opacity: 0;\n}\n\n.placeholder-opacity-0:-ms-input-placeholder {\n  --placeholder-opacity: 0;\n}\n\n.placeholder-opacity-0::placeholder {\n  --placeholder-opacity: 0;\n}\n\n.placeholder-opacity-25::-moz-placeholder {\n  --placeholder-opacity: 0.25;\n}\n\n.placeholder-opacity-25:-ms-input-placeholder {\n  --placeholder-opacity: 0.25;\n}\n\n.placeholder-opacity-25::placeholder {\n  --placeholder-opacity: 0.25;\n}\n\n.placeholder-opacity-50::-moz-placeholder {\n  --placeholder-opacity: 0.5;\n}\n\n.placeholder-opacity-50:-ms-input-placeholder {\n  --placeholder-opacity: 0.5;\n}\n\n.placeholder-opacity-50::placeholder {\n  --placeholder-opacity: 0.5;\n}\n\n.placeholder-opacity-75::-moz-placeholder {\n  --placeholder-opacity: 0.75;\n}\n\n.placeholder-opacity-75:-ms-input-placeholder {\n  --placeholder-opacity: 0.75;\n}\n\n.placeholder-opacity-75::placeholder {\n  --placeholder-opacity: 0.75;\n}\n\n.placeholder-opacity-100::-moz-placeholder {\n  --placeholder-opacity: 1;\n}\n\n.placeholder-opacity-100:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n}\n\n.placeholder-opacity-100::placeholder {\n  --placeholder-opacity: 1;\n}\n\n.focus\\:placeholder-opacity-0:focus::-moz-placeholder {\n  --placeholder-opacity: 0;\n}\n\n.focus\\:placeholder-opacity-0:focus:-ms-input-placeholder {\n  --placeholder-opacity: 0;\n}\n\n.focus\\:placeholder-opacity-0:focus::placeholder {\n  --placeholder-opacity: 0;\n}\n\n.focus\\:placeholder-opacity-25:focus::-moz-placeholder {\n  --placeholder-opacity: 0.25;\n}\n\n.focus\\:placeholder-opacity-25:focus:-ms-input-placeholder {\n  --placeholder-opacity: 0.25;\n}\n\n.focus\\:placeholder-opacity-25:focus::placeholder {\n  --placeholder-opacity: 0.25;\n}\n\n.focus\\:placeholder-opacity-50:focus::-moz-placeholder {\n  --placeholder-opacity: 0.5;\n}\n\n.focus\\:placeholder-opacity-50:focus:-ms-input-placeholder {\n  --placeholder-opacity: 0.5;\n}\n\n.focus\\:placeholder-opacity-50:focus::placeholder {\n  --placeholder-opacity: 0.5;\n}\n\n.focus\\:placeholder-opacity-75:focus::-moz-placeholder {\n  --placeholder-opacity: 0.75;\n}\n\n.focus\\:placeholder-opacity-75:focus:-ms-input-placeholder {\n  --placeholder-opacity: 0.75;\n}\n\n.focus\\:placeholder-opacity-75:focus::placeholder {\n  --placeholder-opacity: 0.75;\n}\n\n.focus\\:placeholder-opacity-100:focus::-moz-placeholder {\n  --placeholder-opacity: 1;\n}\n\n.focus\\:placeholder-opacity-100:focus:-ms-input-placeholder {\n  --placeholder-opacity: 1;\n}\n\n.focus\\:placeholder-opacity-100:focus::placeholder {\n  --placeholder-opacity: 1;\n}\n\n.pointer-events-none {\n  pointer-events: none;\n}\n\n.pointer-events-auto {\n  pointer-events: auto;\n}\n\n.static {\n  position: static;\n}\n\n.fixed {\n  position: fixed;\n}\n\n.absolute {\n  position: absolute;\n}\n\n.relative {\n  position: relative;\n}\n\n.sticky {\n  position: sticky;\n}\n\n.inset-0 {\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n}\n\n.inset-auto {\n  top: auto;\n  right: auto;\n  bottom: auto;\n  left: auto;\n}\n\n.inset-y-0 {\n  top: 0;\n  bottom: 0;\n}\n\n.inset-x-0 {\n  right: 0;\n  left: 0;\n}\n\n.inset-y-auto {\n  top: auto;\n  bottom: auto;\n}\n\n.inset-x-auto {\n  right: auto;\n  left: auto;\n}\n\n.top-0 {\n  top: 0;\n}\n\n.right-0 {\n  right: 0;\n}\n\n.bottom-0 {\n  bottom: 0;\n}\n\n.left-0 {\n  left: 0;\n}\n\n.top-auto {\n  top: auto;\n}\n\n.right-auto {\n  right: auto;\n}\n\n.bottom-auto {\n  bottom: auto;\n}\n\n.left-auto {\n  left: auto;\n}\n\n.resize-none {\n  resize: none;\n}\n\n.resize-y {\n  resize: vertical;\n}\n\n.resize-x {\n  resize: horizontal;\n}\n\n.resize {\n  resize: both;\n}\n\n.shadow-xs {\n  box-shadow: 0 0 0 1px rgba(0, 0, 0, 0.05);\n}\n\n.shadow-sm {\n  box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);\n}\n\n.shadow {\n  box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);\n}\n\n.shadow-md {\n  box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);\n}\n\n.shadow-lg {\n  box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);\n}\n\n.shadow-xl {\n  box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);\n}\n\n.shadow-2xl {\n  box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);\n}\n\n.shadow-inner {\n  box-shadow: inset 0 2px 4px 0 rgba(0, 0, 0, 0.06);\n}\n\n.shadow-outline {\n  box-shadow: 0 0 0 3px rgba(66, 153, 225, 0.5);\n}\n\n.shadow-none {\n  box-shadow: none;\n}\n\n.hover\\:shadow-xs:hover {\n  box-shadow: 0 0 0 1px rgba(0, 0, 0, 0.05);\n}\n\n.hover\\:shadow-sm:hover {\n  box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);\n}\n\n.hover\\:shadow:hover {\n  box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);\n}\n\n.hover\\:shadow-md:hover {\n  box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);\n}\n\n.hover\\:shadow-lg:hover {\n  box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);\n}\n\n.hover\\:shadow-xl:hover {\n  box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);\n}\n\n.hover\\:shadow-2xl:hover {\n  box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);\n}\n\n.hover\\:shadow-inner:hover {\n  box-shadow: inset 0 2px 4px 0 rgba(0, 0, 0, 0.06);\n}\n\n.hover\\:shadow-outline:hover {\n  box-shadow: 0 0 0 3px rgba(66, 153, 225, 0.5);\n}\n\n.hover\\:shadow-none:hover {\n  box-shadow: none;\n}\n\n.focus\\:shadow-xs:focus {\n  box-shadow: 0 0 0 1px rgba(0, 0, 0, 0.05);\n}\n\n.focus\\:shadow-sm:focus {\n  box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);\n}\n\n.focus\\:shadow:focus {\n  box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);\n}\n\n.focus\\:shadow-md:focus {\n  box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);\n}\n\n.focus\\:shadow-lg:focus {\n  box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);\n}\n\n.focus\\:shadow-xl:focus {\n  box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);\n}\n\n.focus\\:shadow-2xl:focus {\n  box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);\n}\n\n.focus\\:shadow-inner:focus {\n  box-shadow: inset 0 2px 4px 0 rgba(0, 0, 0, 0.06);\n}\n\n.focus\\:shadow-outline:focus {\n  box-shadow: 0 0 0 3px rgba(66, 153, 225, 0.5);\n}\n\n.focus\\:shadow-none:focus {\n  box-shadow: none;\n}\n\n.fill-current {\n  fill: currentColor;\n}\n\n.stroke-current {\n  stroke: currentColor;\n}\n\n.stroke-0 {\n  stroke-width: 0;\n}\n\n.stroke-1 {\n  stroke-width: 1;\n}\n\n.stroke-2 {\n  stroke-width: 2;\n}\n\n.table-auto {\n  table-layout: auto;\n}\n\n.table-fixed {\n  table-layout: fixed;\n}\n\n.text-left {\n  text-align: left;\n}\n\n.text-center {\n  text-align: center;\n}\n\n.text-right {\n  text-align: right;\n}\n\n.text-justify {\n  text-align: justify;\n}\n\n.text-transparent {\n  color: transparent;\n}\n\n.text-current {\n  color: currentColor;\n}\n\n.text-black {\n  --text-opacity: 1;\n  color: #000;\n  color: rgba(0, 0, 0, var(--text-opacity));\n}\n\n.text-white {\n  --text-opacity: 1;\n  color: #fff;\n  color: rgba(255, 255, 255, var(--text-opacity));\n}\n\n.text-gray-100 {\n  --text-opacity: 1;\n  color: #f7fafc;\n  color: rgba(247, 250, 252, var(--text-opacity));\n}\n\n.text-gray-200 {\n  --text-opacity: 1;\n  color: #edf2f7;\n  color: rgba(237, 242, 247, var(--text-opacity));\n}\n\n.text-gray-300 {\n  --text-opacity: 1;\n  color: #e2e8f0;\n  color: rgba(226, 232, 240, var(--text-opacity));\n}\n\n.text-gray-400 {\n  --text-opacity: 1;\n  color: #cbd5e0;\n  color: rgba(203, 213, 224, var(--text-opacity));\n}\n\n.text-gray-500 {\n  --text-opacity: 1;\n  color: #a0aec0;\n  color: rgba(160, 174, 192, var(--text-opacity));\n}\n\n.text-gray-600 {\n  --text-opacity: 1;\n  color: #718096;\n  color: rgba(113, 128, 150, var(--text-opacity));\n}\n\n.text-gray-700 {\n  --text-opacity: 1;\n  color: #4a5568;\n  color: rgba(74, 85, 104, var(--text-opacity));\n}\n\n.text-gray-800 {\n  --text-opacity: 1;\n  color: #2d3748;\n  color: rgba(45, 55, 72, var(--text-opacity));\n}\n\n.text-gray-900 {\n  --text-opacity: 1;\n  color: #1a202c;\n  color: rgba(26, 32, 44, var(--text-opacity));\n}\n\n.text-red-100 {\n  --text-opacity: 1;\n  color: #fff5f5;\n  color: rgba(255, 245, 245, var(--text-opacity));\n}\n\n.text-red-200 {\n  --text-opacity: 1;\n  color: #fed7d7;\n  color: rgba(254, 215, 215, var(--text-opacity));\n}\n\n.text-red-300 {\n  --text-opacity: 1;\n  color: #feb2b2;\n  color: rgba(254, 178, 178, var(--text-opacity));\n}\n\n.text-red-400 {\n  --text-opacity: 1;\n  color: #fc8181;\n  color: rgba(252, 129, 129, var(--text-opacity));\n}\n\n.text-red-500 {\n  --text-opacity: 1;\n  color: #f56565;\n  color: rgba(245, 101, 101, var(--text-opacity));\n}\n\n.text-red-600 {\n  --text-opacity: 1;\n  color: #e53e3e;\n  color: rgba(229, 62, 62, var(--text-opacity));\n}\n\n.text-red-700 {\n  --text-opacity: 1;\n  color: #c53030;\n  color: rgba(197, 48, 48, var(--text-opacity));\n}\n\n.text-red-800 {\n  --text-opacity: 1;\n  color: #9b2c2c;\n  color: rgba(155, 44, 44, var(--text-opacity));\n}\n\n.text-red-900 {\n  --text-opacity: 1;\n  color: #742a2a;\n  color: rgba(116, 42, 42, var(--text-opacity));\n}\n\n.text-orange-100 {\n  --text-opacity: 1;\n  color: #fffaf0;\n  color: rgba(255, 250, 240, var(--text-opacity));\n}\n\n.text-orange-200 {\n  --text-opacity: 1;\n  color: #feebc8;\n  color: rgba(254, 235, 200, var(--text-opacity));\n}\n\n.text-orange-300 {\n  --text-opacity: 1;\n  color: #fbd38d;\n  color: rgba(251, 211, 141, var(--text-opacity));\n}\n\n.text-orange-400 {\n  --text-opacity: 1;\n  color: #f6ad55;\n  color: rgba(246, 173, 85, var(--text-opacity));\n}\n\n.text-orange-500 {\n  --text-opacity: 1;\n  color: #ed8936;\n  color: rgba(237, 137, 54, var(--text-opacity));\n}\n\n.text-orange-600 {\n  --text-opacity: 1;\n  color: #dd6b20;\n  color: rgba(221, 107, 32, var(--text-opacity));\n}\n\n.text-orange-700 {\n  --text-opacity: 1;\n  color: #c05621;\n  color: rgba(192, 86, 33, var(--text-opacity));\n}\n\n.text-orange-800 {\n  --text-opacity: 1;\n  color: #9c4221;\n  color: rgba(156, 66, 33, var(--text-opacity));\n}\n\n.text-orange-900 {\n  --text-opacity: 1;\n  color: #7b341e;\n  color: rgba(123, 52, 30, var(--text-opacity));\n}\n\n.text-yellow-100 {\n  --text-opacity: 1;\n  color: #fffff0;\n  color: rgba(255, 255, 240, var(--text-opacity));\n}\n\n.text-yellow-200 {\n  --text-opacity: 1;\n  color: #fefcbf;\n  color: rgba(254, 252, 191, var(--text-opacity));\n}\n\n.text-yellow-300 {\n  --text-opacity: 1;\n  color: #faf089;\n  color: rgba(250, 240, 137, var(--text-opacity));\n}\n\n.text-yellow-400 {\n  --text-opacity: 1;\n  color: #f6e05e;\n  color: rgba(246, 224, 94, var(--text-opacity));\n}\n\n.text-yellow-500 {\n  --text-opacity: 1;\n  color: #ecc94b;\n  color: rgba(236, 201, 75, var(--text-opacity));\n}\n\n.text-yellow-600 {\n  --text-opacity: 1;\n  color: #d69e2e;\n  color: rgba(214, 158, 46, var(--text-opacity));\n}\n\n.text-yellow-700 {\n  --text-opacity: 1;\n  color: #b7791f;\n  color: rgba(183, 121, 31, var(--text-opacity));\n}\n\n.text-yellow-800 {\n  --text-opacity: 1;\n  color: #975a16;\n  color: rgba(151, 90, 22, var(--text-opacity));\n}\n\n.text-yellow-900 {\n  --text-opacity: 1;\n  color: #744210;\n  color: rgba(116, 66, 16, var(--text-opacity));\n}\n\n.text-green-100 {\n  --text-opacity: 1;\n  color: #f0fff4;\n  color: rgba(240, 255, 244, var(--text-opacity));\n}\n\n.text-green-200 {\n  --text-opacity: 1;\n  color: #c6f6d5;\n  color: rgba(198, 246, 213, var(--text-opacity));\n}\n\n.text-green-300 {\n  --text-opacity: 1;\n  color: #9ae6b4;\n  color: rgba(154, 230, 180, var(--text-opacity));\n}\n\n.text-green-400 {\n  --text-opacity: 1;\n  color: #68d391;\n  color: rgba(104, 211, 145, var(--text-opacity));\n}\n\n.text-green-500 {\n  --text-opacity: 1;\n  color: #48bb78;\n  color: rgba(72, 187, 120, var(--text-opacity));\n}\n\n.text-green-600 {\n  --text-opacity: 1;\n  color: #38a169;\n  color: rgba(56, 161, 105, var(--text-opacity));\n}\n\n.text-green-700 {\n  --text-opacity: 1;\n  color: #2f855a;\n  color: rgba(47, 133, 90, var(--text-opacity));\n}\n\n.text-green-800 {\n  --text-opacity: 1;\n  color: #276749;\n  color: rgba(39, 103, 73, var(--text-opacity));\n}\n\n.text-green-900 {\n  --text-opacity: 1;\n  color: #22543d;\n  color: rgba(34, 84, 61, var(--text-opacity));\n}\n\n.text-teal-100 {\n  --text-opacity: 1;\n  color: #e6fffa;\n  color: rgba(230, 255, 250, var(--text-opacity));\n}\n\n.text-teal-200 {\n  --text-opacity: 1;\n  color: #b2f5ea;\n  color: rgba(178, 245, 234, var(--text-opacity));\n}\n\n.text-teal-300 {\n  --text-opacity: 1;\n  color: #81e6d9;\n  color: rgba(129, 230, 217, var(--text-opacity));\n}\n\n.text-teal-400 {\n  --text-opacity: 1;\n  color: #4fd1c5;\n  color: rgba(79, 209, 197, var(--text-opacity));\n}\n\n.text-teal-500 {\n  --text-opacity: 1;\n  color: #38b2ac;\n  color: rgba(56, 178, 172, var(--text-opacity));\n}\n\n.text-teal-600 {\n  --text-opacity: 1;\n  color: #319795;\n  color: rgba(49, 151, 149, var(--text-opacity));\n}\n\n.text-teal-700 {\n  --text-opacity: 1;\n  color: #2c7a7b;\n  color: rgba(44, 122, 123, var(--text-opacity));\n}\n\n.text-teal-800 {\n  --text-opacity: 1;\n  color: #285e61;\n  color: rgba(40, 94, 97, var(--text-opacity));\n}\n\n.text-teal-900 {\n  --text-opacity: 1;\n  color: #234e52;\n  color: rgba(35, 78, 82, var(--text-opacity));\n}\n\n.text-blue-100 {\n  --text-opacity: 1;\n  color: #ebf8ff;\n  color: rgba(235, 248, 255, var(--text-opacity));\n}\n\n.text-blue-200 {\n  --text-opacity: 1;\n  color: #bee3f8;\n  color: rgba(190, 227, 248, var(--text-opacity));\n}\n\n.text-blue-300 {\n  --text-opacity: 1;\n  color: #90cdf4;\n  color: rgba(144, 205, 244, var(--text-opacity));\n}\n\n.text-blue-400 {\n  --text-opacity: 1;\n  color: #63b3ed;\n  color: rgba(99, 179, 237, var(--text-opacity));\n}\n\n.text-blue-500 {\n  --text-opacity: 1;\n  color: #4299e1;\n  color: rgba(66, 153, 225, var(--text-opacity));\n}\n\n.text-blue-600 {\n  --text-opacity: 1;\n  color: #3182ce;\n  color: rgba(49, 130, 206, var(--text-opacity));\n}\n\n.text-blue-700 {\n  --text-opacity: 1;\n  color: #2b6cb0;\n  color: rgba(43, 108, 176, var(--text-opacity));\n}\n\n.text-blue-800 {\n  --text-opacity: 1;\n  color: #2c5282;\n  color: rgba(44, 82, 130, var(--text-opacity));\n}\n\n.text-blue-900 {\n  --text-opacity: 1;\n  color: #2a4365;\n  color: rgba(42, 67, 101, var(--text-opacity));\n}\n\n.text-indigo-100 {\n  --text-opacity: 1;\n  color: #ebf4ff;\n  color: rgba(235, 244, 255, var(--text-opacity));\n}\n\n.text-indigo-200 {\n  --text-opacity: 1;\n  color: #c3dafe;\n  color: rgba(195, 218, 254, var(--text-opacity));\n}\n\n.text-indigo-300 {\n  --text-opacity: 1;\n  color: #a3bffa;\n  color: rgba(163, 191, 250, var(--text-opacity));\n}\n\n.text-indigo-400 {\n  --text-opacity: 1;\n  color: #7f9cf5;\n  color: rgba(127, 156, 245, var(--text-opacity));\n}\n\n.text-indigo-500 {\n  --text-opacity: 1;\n  color: #667eea;\n  color: rgba(102, 126, 234, var(--text-opacity));\n}\n\n.text-indigo-600 {\n  --text-opacity: 1;\n  color: #5a67d8;\n  color: rgba(90, 103, 216, var(--text-opacity));\n}\n\n.text-indigo-700 {\n  --text-opacity: 1;\n  color: #4c51bf;\n  color: rgba(76, 81, 191, var(--text-opacity));\n}\n\n.text-indigo-800 {\n  --text-opacity: 1;\n  color: #434190;\n  color: rgba(67, 65, 144, var(--text-opacity));\n}\n\n.text-indigo-900 {\n  --text-opacity: 1;\n  color: #3c366b;\n  color: rgba(60, 54, 107, var(--text-opacity));\n}\n\n.text-purple-100 {\n  --text-opacity: 1;\n  color: #faf5ff;\n  color: rgba(250, 245, 255, var(--text-opacity));\n}\n\n.text-purple-200 {\n  --text-opacity: 1;\n  color: #e9d8fd;\n  color: rgba(233, 216, 253, var(--text-opacity));\n}\n\n.text-purple-300 {\n  --text-opacity: 1;\n  color: #d6bcfa;\n  color: rgba(214, 188, 250, var(--text-opacity));\n}\n\n.text-purple-400 {\n  --text-opacity: 1;\n  color: #b794f4;\n  color: rgba(183, 148, 244, var(--text-opacity));\n}\n\n.text-purple-500 {\n  --text-opacity: 1;\n  color: #9f7aea;\n  color: rgba(159, 122, 234, var(--text-opacity));\n}\n\n.text-purple-600 {\n  --text-opacity: 1;\n  color: #805ad5;\n  color: rgba(128, 90, 213, var(--text-opacity));\n}\n\n.text-purple-700 {\n  --text-opacity: 1;\n  color: #6b46c1;\n  color: rgba(107, 70, 193, var(--text-opacity));\n}\n\n.text-purple-800 {\n  --text-opacity: 1;\n  color: #553c9a;\n  color: rgba(85, 60, 154, var(--text-opacity));\n}\n\n.text-purple-900 {\n  --text-opacity: 1;\n  color: #44337a;\n  color: rgba(68, 51, 122, var(--text-opacity));\n}\n\n.text-pink-100 {\n  --text-opacity: 1;\n  color: #fff5f7;\n  color: rgba(255, 245, 247, var(--text-opacity));\n}\n\n.text-pink-200 {\n  --text-opacity: 1;\n  color: #fed7e2;\n  color: rgba(254, 215, 226, var(--text-opacity));\n}\n\n.text-pink-300 {\n  --text-opacity: 1;\n  color: #fbb6ce;\n  color: rgba(251, 182, 206, var(--text-opacity));\n}\n\n.text-pink-400 {\n  --text-opacity: 1;\n  color: #f687b3;\n  color: rgba(246, 135, 179, var(--text-opacity));\n}\n\n.text-pink-500 {\n  --text-opacity: 1;\n  color: #ed64a6;\n  color: rgba(237, 100, 166, var(--text-opacity));\n}\n\n.text-pink-600 {\n  --text-opacity: 1;\n  color: #d53f8c;\n  color: rgba(213, 63, 140, var(--text-opacity));\n}\n\n.text-pink-700 {\n  --text-opacity: 1;\n  color: #b83280;\n  color: rgba(184, 50, 128, var(--text-opacity));\n}\n\n.text-pink-800 {\n  --text-opacity: 1;\n  color: #97266d;\n  color: rgba(151, 38, 109, var(--text-opacity));\n}\n\n.text-pink-900 {\n  --text-opacity: 1;\n  color: #702459;\n  color: rgba(112, 36, 89, var(--text-opacity));\n}\n\n.hover\\:text-transparent:hover {\n  color: transparent;\n}\n\n.hover\\:text-current:hover {\n  color: currentColor;\n}\n\n.hover\\:text-black:hover {\n  --text-opacity: 1;\n  color: #000;\n  color: rgba(0, 0, 0, var(--text-opacity));\n}\n\n.hover\\:text-white:hover {\n  --text-opacity: 1;\n  color: #fff;\n  color: rgba(255, 255, 255, var(--text-opacity));\n}\n\n.hover\\:text-gray-100:hover {\n  --text-opacity: 1;\n  color: #f7fafc;\n  color: rgba(247, 250, 252, var(--text-opacity));\n}\n\n.hover\\:text-gray-200:hover {\n  --text-opacity: 1;\n  color: #edf2f7;\n  color: rgba(237, 242, 247, var(--text-opacity));\n}\n\n.hover\\:text-gray-300:hover {\n  --text-opacity: 1;\n  color: #e2e8f0;\n  color: rgba(226, 232, 240, var(--text-opacity));\n}\n\n.hover\\:text-gray-400:hover {\n  --text-opacity: 1;\n  color: #cbd5e0;\n  color: rgba(203, 213, 224, var(--text-opacity));\n}\n\n.hover\\:text-gray-500:hover {\n  --text-opacity: 1;\n  color: #a0aec0;\n  color: rgba(160, 174, 192, var(--text-opacity));\n}\n\n.hover\\:text-gray-600:hover {\n  --text-opacity: 1;\n  color: #718096;\n  color: rgba(113, 128, 150, var(--text-opacity));\n}\n\n.hover\\:text-gray-700:hover {\n  --text-opacity: 1;\n  color: #4a5568;\n  color: rgba(74, 85, 104, var(--text-opacity));\n}\n\n.hover\\:text-gray-800:hover {\n  --text-opacity: 1;\n  color: #2d3748;\n  color: rgba(45, 55, 72, var(--text-opacity));\n}\n\n.hover\\:text-gray-900:hover {\n  --text-opacity: 1;\n  color: #1a202c;\n  color: rgba(26, 32, 44, var(--text-opacity));\n}\n\n.hover\\:text-red-100:hover {\n  --text-opacity: 1;\n  color: #fff5f5;\n  color: rgba(255, 245, 245, var(--text-opacity));\n}\n\n.hover\\:text-red-200:hover {\n  --text-opacity: 1;\n  color: #fed7d7;\n  color: rgba(254, 215, 215, var(--text-opacity));\n}\n\n.hover\\:text-red-300:hover {\n  --text-opacity: 1;\n  color: #feb2b2;\n  color: rgba(254, 178, 178, var(--text-opacity));\n}\n\n.hover\\:text-red-400:hover {\n  --text-opacity: 1;\n  color: #fc8181;\n  color: rgba(252, 129, 129, var(--text-opacity));\n}\n\n.hover\\:text-red-500:hover {\n  --text-opacity: 1;\n  color: #f56565;\n  color: rgba(245, 101, 101, var(--text-opacity));\n}\n\n.hover\\:text-red-600:hover {\n  --text-opacity: 1;\n  color: #e53e3e;\n  color: rgba(229, 62, 62, var(--text-opacity));\n}\n\n.hover\\:text-red-700:hover {\n  --text-opacity: 1;\n  color: #c53030;\n  color: rgba(197, 48, 48, var(--text-opacity));\n}\n\n.hover\\:text-red-800:hover {\n  --text-opacity: 1;\n  color: #9b2c2c;\n  color: rgba(155, 44, 44, var(--text-opacity));\n}\n\n.hover\\:text-red-900:hover {\n  --text-opacity: 1;\n  color: #742a2a;\n  color: rgba(116, 42, 42, var(--text-opacity));\n}\n\n.hover\\:text-orange-100:hover {\n  --text-opacity: 1;\n  color: #fffaf0;\n  color: rgba(255, 250, 240, var(--text-opacity));\n}\n\n.hover\\:text-orange-200:hover {\n  --text-opacity: 1;\n  color: #feebc8;\n  color: rgba(254, 235, 200, var(--text-opacity));\n}\n\n.hover\\:text-orange-300:hover {\n  --text-opacity: 1;\n  color: #fbd38d;\n  color: rgba(251, 211, 141, var(--text-opacity));\n}\n\n.hover\\:text-orange-400:hover {\n  --text-opacity: 1;\n  color: #f6ad55;\n  color: rgba(246, 173, 85, var(--text-opacity));\n}\n\n.hover\\:text-orange-500:hover {\n  --text-opacity: 1;\n  color: #ed8936;\n  color: rgba(237, 137, 54, var(--text-opacity));\n}\n\n.hover\\:text-orange-600:hover {\n  --text-opacity: 1;\n  color: #dd6b20;\n  color: rgba(221, 107, 32, var(--text-opacity));\n}\n\n.hover\\:text-orange-700:hover {\n  --text-opacity: 1;\n  color: #c05621;\n  color: rgba(192, 86, 33, var(--text-opacity));\n}\n\n.hover\\:text-orange-800:hover {\n  --text-opacity: 1;\n  color: #9c4221;\n  color: rgba(156, 66, 33, var(--text-opacity));\n}\n\n.hover\\:text-orange-900:hover {\n  --text-opacity: 1;\n  color: #7b341e;\n  color: rgba(123, 52, 30, var(--text-opacity));\n}\n\n.hover\\:text-yellow-100:hover {\n  --text-opacity: 1;\n  color: #fffff0;\n  color: rgba(255, 255, 240, var(--text-opacity));\n}\n\n.hover\\:text-yellow-200:hover {\n  --text-opacity: 1;\n  color: #fefcbf;\n  color: rgba(254, 252, 191, var(--text-opacity));\n}\n\n.hover\\:text-yellow-300:hover {\n  --text-opacity: 1;\n  color: #faf089;\n  color: rgba(250, 240, 137, var(--text-opacity));\n}\n\n.hover\\:text-yellow-400:hover {\n  --text-opacity: 1;\n  color: #f6e05e;\n  color: rgba(246, 224, 94, var(--text-opacity));\n}\n\n.hover\\:text-yellow-500:hover {\n  --text-opacity: 1;\n  color: #ecc94b;\n  color: rgba(236, 201, 75, var(--text-opacity));\n}\n\n.hover\\:text-yellow-600:hover {\n  --text-opacity: 1;\n  color: #d69e2e;\n  color: rgba(214, 158, 46, var(--text-opacity));\n}\n\n.hover\\:text-yellow-700:hover {\n  --text-opacity: 1;\n  color: #b7791f;\n  color: rgba(183, 121, 31, var(--text-opacity));\n}\n\n.hover\\:text-yellow-800:hover {\n  --text-opacity: 1;\n  color: #975a16;\n  color: rgba(151, 90, 22, var(--text-opacity));\n}\n\n.hover\\:text-yellow-900:hover {\n  --text-opacity: 1;\n  color: #744210;\n  color: rgba(116, 66, 16, var(--text-opacity));\n}\n\n.hover\\:text-green-100:hover {\n  --text-opacity: 1;\n  color: #f0fff4;\n  color: rgba(240, 255, 244, var(--text-opacity));\n}\n\n.hover\\:text-green-200:hover {\n  --text-opacity: 1;\n  color: #c6f6d5;\n  color: rgba(198, 246, 213, var(--text-opacity));\n}\n\n.hover\\:text-green-300:hover {\n  --text-opacity: 1;\n  color: #9ae6b4;\n  color: rgba(154, 230, 180, var(--text-opacity));\n}\n\n.hover\\:text-green-400:hover {\n  --text-opacity: 1;\n  color: #68d391;\n  color: rgba(104, 211, 145, var(--text-opacity));\n}\n\n.hover\\:text-green-500:hover {\n  --text-opacity: 1;\n  color: #48bb78;\n  color: rgba(72, 187, 120, var(--text-opacity));\n}\n\n.hover\\:text-green-600:hover {\n  --text-opacity: 1;\n  color: #38a169;\n  color: rgba(56, 161, 105, var(--text-opacity));\n}\n\n.hover\\:text-green-700:hover {\n  --text-opacity: 1;\n  color: #2f855a;\n  color: rgba(47, 133, 90, var(--text-opacity));\n}\n\n.hover\\:text-green-800:hover {\n  --text-opacity: 1;\n  color: #276749;\n  color: rgba(39, 103, 73, var(--text-opacity));\n}\n\n.hover\\:text-green-900:hover {\n  --text-opacity: 1;\n  color: #22543d;\n  color: rgba(34, 84, 61, var(--text-opacity));\n}\n\n.hover\\:text-teal-100:hover {\n  --text-opacity: 1;\n  color: #e6fffa;\n  color: rgba(230, 255, 250, var(--text-opacity));\n}\n\n.hover\\:text-teal-200:hover {\n  --text-opacity: 1;\n  color: #b2f5ea;\n  color: rgba(178, 245, 234, var(--text-opacity));\n}\n\n.hover\\:text-teal-300:hover {\n  --text-opacity: 1;\n  color: #81e6d9;\n  color: rgba(129, 230, 217, var(--text-opacity));\n}\n\n.hover\\:text-teal-400:hover {\n  --text-opacity: 1;\n  color: #4fd1c5;\n  color: rgba(79, 209, 197, var(--text-opacity));\n}\n\n.hover\\:text-teal-500:hover {\n  --text-opacity: 1;\n  color: #38b2ac;\n  color: rgba(56, 178, 172, var(--text-opacity));\n}\n\n.hover\\:text-teal-600:hover {\n  --text-opacity: 1;\n  color: #319795;\n  color: rgba(49, 151, 149, var(--text-opacity));\n}\n\n.hover\\:text-teal-700:hover {\n  --text-opacity: 1;\n  color: #2c7a7b;\n  color: rgba(44, 122, 123, var(--text-opacity));\n}\n\n.hover\\:text-teal-800:hover {\n  --text-opacity: 1;\n  color: #285e61;\n  color: rgba(40, 94, 97, var(--text-opacity));\n}\n\n.hover\\:text-teal-900:hover {\n  --text-opacity: 1;\n  color: #234e52;\n  color: rgba(35, 78, 82, var(--text-opacity));\n}\n\n.hover\\:text-blue-100:hover {\n  --text-opacity: 1;\n  color: #ebf8ff;\n  color: rgba(235, 248, 255, var(--text-opacity));\n}\n\n.hover\\:text-blue-200:hover {\n  --text-opacity: 1;\n  color: #bee3f8;\n  color: rgba(190, 227, 248, var(--text-opacity));\n}\n\n.hover\\:text-blue-300:hover {\n  --text-opacity: 1;\n  color: #90cdf4;\n  color: rgba(144, 205, 244, var(--text-opacity));\n}\n\n.hover\\:text-blue-400:hover {\n  --text-opacity: 1;\n  color: #63b3ed;\n  color: rgba(99, 179, 237, var(--text-opacity));\n}\n\n.hover\\:text-blue-500:hover {\n  --text-opacity: 1;\n  color: #4299e1;\n  color: rgba(66, 153, 225, var(--text-opacity));\n}\n\n.hover\\:text-blue-600:hover {\n  --text-opacity: 1;\n  color: #3182ce;\n  color: rgba(49, 130, 206, var(--text-opacity));\n}\n\n.hover\\:text-blue-700:hover {\n  --text-opacity: 1;\n  color: #2b6cb0;\n  color: rgba(43, 108, 176, var(--text-opacity));\n}\n\n.hover\\:text-blue-800:hover {\n  --text-opacity: 1;\n  color: #2c5282;\n  color: rgba(44, 82, 130, var(--text-opacity));\n}\n\n.hover\\:text-blue-900:hover {\n  --text-opacity: 1;\n  color: #2a4365;\n  color: rgba(42, 67, 101, var(--text-opacity));\n}\n\n.hover\\:text-indigo-100:hover {\n  --text-opacity: 1;\n  color: #ebf4ff;\n  color: rgba(235, 244, 255, var(--text-opacity));\n}\n\n.hover\\:text-indigo-200:hover {\n  --text-opacity: 1;\n  color: #c3dafe;\n  color: rgba(195, 218, 254, var(--text-opacity));\n}\n\n.hover\\:text-indigo-300:hover {\n  --text-opacity: 1;\n  color: #a3bffa;\n  color: rgba(163, 191, 250, var(--text-opacity));\n}\n\n.hover\\:text-indigo-400:hover {\n  --text-opacity: 1;\n  color: #7f9cf5;\n  color: rgba(127, 156, 245, var(--text-opacity));\n}\n\n.hover\\:text-indigo-500:hover {\n  --text-opacity: 1;\n  color: #667eea;\n  color: rgba(102, 126, 234, var(--text-opacity));\n}\n\n.hover\\:text-indigo-600:hover {\n  --text-opacity: 1;\n  color: #5a67d8;\n  color: rgba(90, 103, 216, var(--text-opacity));\n}\n\n.hover\\:text-indigo-700:hover {\n  --text-opacity: 1;\n  color: #4c51bf;\n  color: rgba(76, 81, 191, var(--text-opacity));\n}\n\n.hover\\:text-indigo-800:hover {\n  --text-opacity: 1;\n  color: #434190;\n  color: rgba(67, 65, 144, var(--text-opacity));\n}\n\n.hover\\:text-indigo-900:hover {\n  --text-opacity: 1;\n  color: #3c366b;\n  color: rgba(60, 54, 107, var(--text-opacity));\n}\n\n.hover\\:text-purple-100:hover {\n  --text-opacity: 1;\n  color: #faf5ff;\n  color: rgba(250, 245, 255, var(--text-opacity));\n}\n\n.hover\\:text-purple-200:hover {\n  --text-opacity: 1;\n  color: #e9d8fd;\n  color: rgba(233, 216, 253, var(--text-opacity));\n}\n\n.hover\\:text-purple-300:hover {\n  --text-opacity: 1;\n  color: #d6bcfa;\n  color: rgba(214, 188, 250, var(--text-opacity));\n}\n\n.hover\\:text-purple-400:hover {\n  --text-opacity: 1;\n  color: #b794f4;\n  color: rgba(183, 148, 244, var(--text-opacity));\n}\n\n.hover\\:text-purple-500:hover {\n  --text-opacity: 1;\n  color: #9f7aea;\n  color: rgba(159, 122, 234, var(--text-opacity));\n}\n\n.hover\\:text-purple-600:hover {\n  --text-opacity: 1;\n  color: #805ad5;\n  color: rgba(128, 90, 213, var(--text-opacity));\n}\n\n.hover\\:text-purple-700:hover {\n  --text-opacity: 1;\n  color: #6b46c1;\n  color: rgba(107, 70, 193, var(--text-opacity));\n}\n\n.hover\\:text-purple-800:hover {\n  --text-opacity: 1;\n  color: #553c9a;\n  color: rgba(85, 60, 154, var(--text-opacity));\n}\n\n.hover\\:text-purple-900:hover {\n  --text-opacity: 1;\n  color: #44337a;\n  color: rgba(68, 51, 122, var(--text-opacity));\n}\n\n.hover\\:text-pink-100:hover {\n  --text-opacity: 1;\n  color: #fff5f7;\n  color: rgba(255, 245, 247, var(--text-opacity));\n}\n\n.hover\\:text-pink-200:hover {\n  --text-opacity: 1;\n  color: #fed7e2;\n  color: rgba(254, 215, 226, var(--text-opacity));\n}\n\n.hover\\:text-pink-300:hover {\n  --text-opacity: 1;\n  color: #fbb6ce;\n  color: rgba(251, 182, 206, var(--text-opacity));\n}\n\n.hover\\:text-pink-400:hover {\n  --text-opacity: 1;\n  color: #f687b3;\n  color: rgba(246, 135, 179, var(--text-opacity));\n}\n\n.hover\\:text-pink-500:hover {\n  --text-opacity: 1;\n  color: #ed64a6;\n  color: rgba(237, 100, 166, var(--text-opacity));\n}\n\n.hover\\:text-pink-600:hover {\n  --text-opacity: 1;\n  color: #d53f8c;\n  color: rgba(213, 63, 140, var(--text-opacity));\n}\n\n.hover\\:text-pink-700:hover {\n  --text-opacity: 1;\n  color: #b83280;\n  color: rgba(184, 50, 128, var(--text-opacity));\n}\n\n.hover\\:text-pink-800:hover {\n  --text-opacity: 1;\n  color: #97266d;\n  color: rgba(151, 38, 109, var(--text-opacity));\n}\n\n.hover\\:text-pink-900:hover {\n  --text-opacity: 1;\n  color: #702459;\n  color: rgba(112, 36, 89, var(--text-opacity));\n}\n\n.focus\\:text-transparent:focus {\n  color: transparent;\n}\n\n.focus\\:text-current:focus {\n  color: currentColor;\n}\n\n.focus\\:text-black:focus {\n  --text-opacity: 1;\n  color: #000;\n  color: rgba(0, 0, 0, var(--text-opacity));\n}\n\n.focus\\:text-white:focus {\n  --text-opacity: 1;\n  color: #fff;\n  color: rgba(255, 255, 255, var(--text-opacity));\n}\n\n.focus\\:text-gray-100:focus {\n  --text-opacity: 1;\n  color: #f7fafc;\n  color: rgba(247, 250, 252, var(--text-opacity));\n}\n\n.focus\\:text-gray-200:focus {\n  --text-opacity: 1;\n  color: #edf2f7;\n  color: rgba(237, 242, 247, var(--text-opacity));\n}\n\n.focus\\:text-gray-300:focus {\n  --text-opacity: 1;\n  color: #e2e8f0;\n  color: rgba(226, 232, 240, var(--text-opacity));\n}\n\n.focus\\:text-gray-400:focus {\n  --text-opacity: 1;\n  color: #cbd5e0;\n  color: rgba(203, 213, 224, var(--text-opacity));\n}\n\n.focus\\:text-gray-500:focus {\n  --text-opacity: 1;\n  color: #a0aec0;\n  color: rgba(160, 174, 192, var(--text-opacity));\n}\n\n.focus\\:text-gray-600:focus {\n  --text-opacity: 1;\n  color: #718096;\n  color: rgba(113, 128, 150, var(--text-opacity));\n}\n\n.focus\\:text-gray-700:focus {\n  --text-opacity: 1;\n  color: #4a5568;\n  color: rgba(74, 85, 104, var(--text-opacity));\n}\n\n.focus\\:text-gray-800:focus {\n  --text-opacity: 1;\n  color: #2d3748;\n  color: rgba(45, 55, 72, var(--text-opacity));\n}\n\n.focus\\:text-gray-900:focus {\n  --text-opacity: 1;\n  color: #1a202c;\n  color: rgba(26, 32, 44, var(--text-opacity));\n}\n\n.focus\\:text-red-100:focus {\n  --text-opacity: 1;\n  color: #fff5f5;\n  color: rgba(255, 245, 245, var(--text-opacity));\n}\n\n.focus\\:text-red-200:focus {\n  --text-opacity: 1;\n  color: #fed7d7;\n  color: rgba(254, 215, 215, var(--text-opacity));\n}\n\n.focus\\:text-red-300:focus {\n  --text-opacity: 1;\n  color: #feb2b2;\n  color: rgba(254, 178, 178, var(--text-opacity));\n}\n\n.focus\\:text-red-400:focus {\n  --text-opacity: 1;\n  color: #fc8181;\n  color: rgba(252, 129, 129, var(--text-opacity));\n}\n\n.focus\\:text-red-500:focus {\n  --text-opacity: 1;\n  color: #f56565;\n  color: rgba(245, 101, 101, var(--text-opacity));\n}\n\n.focus\\:text-red-600:focus {\n  --text-opacity: 1;\n  color: #e53e3e;\n  color: rgba(229, 62, 62, var(--text-opacity));\n}\n\n.focus\\:text-red-700:focus {\n  --text-opacity: 1;\n  color: #c53030;\n  color: rgba(197, 48, 48, var(--text-opacity));\n}\n\n.focus\\:text-red-800:focus {\n  --text-opacity: 1;\n  color: #9b2c2c;\n  color: rgba(155, 44, 44, var(--text-opacity));\n}\n\n.focus\\:text-red-900:focus {\n  --text-opacity: 1;\n  color: #742a2a;\n  color: rgba(116, 42, 42, var(--text-opacity));\n}\n\n.focus\\:text-orange-100:focus {\n  --text-opacity: 1;\n  color: #fffaf0;\n  color: rgba(255, 250, 240, var(--text-opacity));\n}\n\n.focus\\:text-orange-200:focus {\n  --text-opacity: 1;\n  color: #feebc8;\n  color: rgba(254, 235, 200, var(--text-opacity));\n}\n\n.focus\\:text-orange-300:focus {\n  --text-opacity: 1;\n  color: #fbd38d;\n  color: rgba(251, 211, 141, var(--text-opacity));\n}\n\n.focus\\:text-orange-400:focus {\n  --text-opacity: 1;\n  color: #f6ad55;\n  color: rgba(246, 173, 85, var(--text-opacity));\n}\n\n.focus\\:text-orange-500:focus {\n  --text-opacity: 1;\n  color: #ed8936;\n  color: rgba(237, 137, 54, var(--text-opacity));\n}\n\n.focus\\:text-orange-600:focus {\n  --text-opacity: 1;\n  color: #dd6b20;\n  color: rgba(221, 107, 32, var(--text-opacity));\n}\n\n.focus\\:text-orange-700:focus {\n  --text-opacity: 1;\n  color: #c05621;\n  color: rgba(192, 86, 33, var(--text-opacity));\n}\n\n.focus\\:text-orange-800:focus {\n  --text-opacity: 1;\n  color: #9c4221;\n  color: rgba(156, 66, 33, var(--text-opacity));\n}\n\n.focus\\:text-orange-900:focus {\n  --text-opacity: 1;\n  color: #7b341e;\n  color: rgba(123, 52, 30, var(--text-opacity));\n}\n\n.focus\\:text-yellow-100:focus {\n  --text-opacity: 1;\n  color: #fffff0;\n  color: rgba(255, 255, 240, var(--text-opacity));\n}\n\n.focus\\:text-yellow-200:focus {\n  --text-opacity: 1;\n  color: #fefcbf;\n  color: rgba(254, 252, 191, var(--text-opacity));\n}\n\n.focus\\:text-yellow-300:focus {\n  --text-opacity: 1;\n  color: #faf089;\n  color: rgba(250, 240, 137, var(--text-opacity));\n}\n\n.focus\\:text-yellow-400:focus {\n  --text-opacity: 1;\n  color: #f6e05e;\n  color: rgba(246, 224, 94, var(--text-opacity));\n}\n\n.focus\\:text-yellow-500:focus {\n  --text-opacity: 1;\n  color: #ecc94b;\n  color: rgba(236, 201, 75, var(--text-opacity));\n}\n\n.focus\\:text-yellow-600:focus {\n  --text-opacity: 1;\n  color: #d69e2e;\n  color: rgba(214, 158, 46, var(--text-opacity));\n}\n\n.focus\\:text-yellow-700:focus {\n  --text-opacity: 1;\n  color: #b7791f;\n  color: rgba(183, 121, 31, var(--text-opacity));\n}\n\n.focus\\:text-yellow-800:focus {\n  --text-opacity: 1;\n  color: #975a16;\n  color: rgba(151, 90, 22, var(--text-opacity));\n}\n\n.focus\\:text-yellow-900:focus {\n  --text-opacity: 1;\n  color: #744210;\n  color: rgba(116, 66, 16, var(--text-opacity));\n}\n\n.focus\\:text-green-100:focus {\n  --text-opacity: 1;\n  color: #f0fff4;\n  color: rgba(240, 255, 244, var(--text-opacity));\n}\n\n.focus\\:text-green-200:focus {\n  --text-opacity: 1;\n  color: #c6f6d5;\n  color: rgba(198, 246, 213, var(--text-opacity));\n}\n\n.focus\\:text-green-300:focus {\n  --text-opacity: 1;\n  color: #9ae6b4;\n  color: rgba(154, 230, 180, var(--text-opacity));\n}\n\n.focus\\:text-green-400:focus {\n  --text-opacity: 1;\n  color: #68d391;\n  color: rgba(104, 211, 145, var(--text-opacity));\n}\n\n.focus\\:text-green-500:focus {\n  --text-opacity: 1;\n  color: #48bb78;\n  color: rgba(72, 187, 120, var(--text-opacity));\n}\n\n.focus\\:text-green-600:focus {\n  --text-opacity: 1;\n  color: #38a169;\n  color: rgba(56, 161, 105, var(--text-opacity));\n}\n\n.focus\\:text-green-700:focus {\n  --text-opacity: 1;\n  color: #2f855a;\n  color: rgba(47, 133, 90, var(--text-opacity));\n}\n\n.focus\\:text-green-800:focus {\n  --text-opacity: 1;\n  color: #276749;\n  color: rgba(39, 103, 73, var(--text-opacity));\n}\n\n.focus\\:text-green-900:focus {\n  --text-opacity: 1;\n  color: #22543d;\n  color: rgba(34, 84, 61, var(--text-opacity));\n}\n\n.focus\\:text-teal-100:focus {\n  --text-opacity: 1;\n  color: #e6fffa;\n  color: rgba(230, 255, 250, var(--text-opacity));\n}\n\n.focus\\:text-teal-200:focus {\n  --text-opacity: 1;\n  color: #b2f5ea;\n  color: rgba(178, 245, 234, var(--text-opacity));\n}\n\n.focus\\:text-teal-300:focus {\n  --text-opacity: 1;\n  color: #81e6d9;\n  color: rgba(129, 230, 217, var(--text-opacity));\n}\n\n.focus\\:text-teal-400:focus {\n  --text-opacity: 1;\n  color: #4fd1c5;\n  color: rgba(79, 209, 197, var(--text-opacity));\n}\n\n.focus\\:text-teal-500:focus {\n  --text-opacity: 1;\n  color: #38b2ac;\n  color: rgba(56, 178, 172, var(--text-opacity));\n}\n\n.focus\\:text-teal-600:focus {\n  --text-opacity: 1;\n  color: #319795;\n  color: rgba(49, 151, 149, var(--text-opacity));\n}\n\n.focus\\:text-teal-700:focus {\n  --text-opacity: 1;\n  color: #2c7a7b;\n  color: rgba(44, 122, 123, var(--text-opacity));\n}\n\n.focus\\:text-teal-800:focus {\n  --text-opacity: 1;\n  color: #285e61;\n  color: rgba(40, 94, 97, var(--text-opacity));\n}\n\n.focus\\:text-teal-900:focus {\n  --text-opacity: 1;\n  color: #234e52;\n  color: rgba(35, 78, 82, var(--text-opacity));\n}\n\n.focus\\:text-blue-100:focus {\n  --text-opacity: 1;\n  color: #ebf8ff;\n  color: rgba(235, 248, 255, var(--text-opacity));\n}\n\n.focus\\:text-blue-200:focus {\n  --text-opacity: 1;\n  color: #bee3f8;\n  color: rgba(190, 227, 248, var(--text-opacity));\n}\n\n.focus\\:text-blue-300:focus {\n  --text-opacity: 1;\n  color: #90cdf4;\n  color: rgba(144, 205, 244, var(--text-opacity));\n}\n\n.focus\\:text-blue-400:focus {\n  --text-opacity: 1;\n  color: #63b3ed;\n  color: rgba(99, 179, 237, var(--text-opacity));\n}\n\n.focus\\:text-blue-500:focus {\n  --text-opacity: 1;\n  color: #4299e1;\n  color: rgba(66, 153, 225, var(--text-opacity));\n}\n\n.focus\\:text-blue-600:focus {\n  --text-opacity: 1;\n  color: #3182ce;\n  color: rgba(49, 130, 206, var(--text-opacity));\n}\n\n.focus\\:text-blue-700:focus {\n  --text-opacity: 1;\n  color: #2b6cb0;\n  color: rgba(43, 108, 176, var(--text-opacity));\n}\n\n.focus\\:text-blue-800:focus {\n  --text-opacity: 1;\n  color: #2c5282;\n  color: rgba(44, 82, 130, var(--text-opacity));\n}\n\n.focus\\:text-blue-900:focus {\n  --text-opacity: 1;\n  color: #2a4365;\n  color: rgba(42, 67, 101, var(--text-opacity));\n}\n\n.focus\\:text-indigo-100:focus {\n  --text-opacity: 1;\n  color: #ebf4ff;\n  color: rgba(235, 244, 255, var(--text-opacity));\n}\n\n.focus\\:text-indigo-200:focus {\n  --text-opacity: 1;\n  color: #c3dafe;\n  color: rgba(195, 218, 254, var(--text-opacity));\n}\n\n.focus\\:text-indigo-300:focus {\n  --text-opacity: 1;\n  color: #a3bffa;\n  color: rgba(163, 191, 250, var(--text-opacity));\n}\n\n.focus\\:text-indigo-400:focus {\n  --text-opacity: 1;\n  color: #7f9cf5;\n  color: rgba(127, 156, 245, var(--text-opacity));\n}\n\n.focus\\:text-indigo-500:focus {\n  --text-opacity: 1;\n  color: #667eea;\n  color: rgba(102, 126, 234, var(--text-opacity));\n}\n\n.focus\\:text-indigo-600:focus {\n  --text-opacity: 1;\n  color: #5a67d8;\n  color: rgba(90, 103, 216, var(--text-opacity));\n}\n\n.focus\\:text-indigo-700:focus {\n  --text-opacity: 1;\n  color: #4c51bf;\n  color: rgba(76, 81, 191, var(--text-opacity));\n}\n\n.focus\\:text-indigo-800:focus {\n  --text-opacity: 1;\n  color: #434190;\n  color: rgba(67, 65, 144, var(--text-opacity));\n}\n\n.focus\\:text-indigo-900:focus {\n  --text-opacity: 1;\n  color: #3c366b;\n  color: rgba(60, 54, 107, var(--text-opacity));\n}\n\n.focus\\:text-purple-100:focus {\n  --text-opacity: 1;\n  color: #faf5ff;\n  color: rgba(250, 245, 255, var(--text-opacity));\n}\n\n.focus\\:text-purple-200:focus {\n  --text-opacity: 1;\n  color: #e9d8fd;\n  color: rgba(233, 216, 253, var(--text-opacity));\n}\n\n.focus\\:text-purple-300:focus {\n  --text-opacity: 1;\n  color: #d6bcfa;\n  color: rgba(214, 188, 250, var(--text-opacity));\n}\n\n.focus\\:text-purple-400:focus {\n  --text-opacity: 1;\n  color: #b794f4;\n  color: rgba(183, 148, 244, var(--text-opacity));\n}\n\n.focus\\:text-purple-500:focus {\n  --text-opacity: 1;\n  color: #9f7aea;\n  color: rgba(159, 122, 234, var(--text-opacity));\n}\n\n.focus\\:text-purple-600:focus {\n  --text-opacity: 1;\n  color: #805ad5;\n  color: rgba(128, 90, 213, var(--text-opacity));\n}\n\n.focus\\:text-purple-700:focus {\n  --text-opacity: 1;\n  color: #6b46c1;\n  color: rgba(107, 70, 193, var(--text-opacity));\n}\n\n.focus\\:text-purple-800:focus {\n  --text-opacity: 1;\n  color: #553c9a;\n  color: rgba(85, 60, 154, var(--text-opacity));\n}\n\n.focus\\:text-purple-900:focus {\n  --text-opacity: 1;\n  color: #44337a;\n  color: rgba(68, 51, 122, var(--text-opacity));\n}\n\n.focus\\:text-pink-100:focus {\n  --text-opacity: 1;\n  color: #fff5f7;\n  color: rgba(255, 245, 247, var(--text-opacity));\n}\n\n.focus\\:text-pink-200:focus {\n  --text-opacity: 1;\n  color: #fed7e2;\n  color: rgba(254, 215, 226, var(--text-opacity));\n}\n\n.focus\\:text-pink-300:focus {\n  --text-opacity: 1;\n  color: #fbb6ce;\n  color: rgba(251, 182, 206, var(--text-opacity));\n}\n\n.focus\\:text-pink-400:focus {\n  --text-opacity: 1;\n  color: #f687b3;\n  color: rgba(246, 135, 179, var(--text-opacity));\n}\n\n.focus\\:text-pink-500:focus {\n  --text-opacity: 1;\n  color: #ed64a6;\n  color: rgba(237, 100, 166, var(--text-opacity));\n}\n\n.focus\\:text-pink-600:focus {\n  --text-opacity: 1;\n  color: #d53f8c;\n  color: rgba(213, 63, 140, var(--text-opacity));\n}\n\n.focus\\:text-pink-700:focus {\n  --text-opacity: 1;\n  color: #b83280;\n  color: rgba(184, 50, 128, var(--text-opacity));\n}\n\n.focus\\:text-pink-800:focus {\n  --text-opacity: 1;\n  color: #97266d;\n  color: rgba(151, 38, 109, var(--text-opacity));\n}\n\n.focus\\:text-pink-900:focus {\n  --text-opacity: 1;\n  color: #702459;\n  color: rgba(112, 36, 89, var(--text-opacity));\n}\n\n.text-opacity-0 {\n  --text-opacity: 0;\n}\n\n.text-opacity-25 {\n  --text-opacity: 0.25;\n}\n\n.text-opacity-50 {\n  --text-opacity: 0.5;\n}\n\n.text-opacity-75 {\n  --text-opacity: 0.75;\n}\n\n.text-opacity-100 {\n  --text-opacity: 1;\n}\n\n.hover\\:text-opacity-0:hover {\n  --text-opacity: 0;\n}\n\n.hover\\:text-opacity-25:hover {\n  --text-opacity: 0.25;\n}\n\n.hover\\:text-opacity-50:hover {\n  --text-opacity: 0.5;\n}\n\n.hover\\:text-opacity-75:hover {\n  --text-opacity: 0.75;\n}\n\n.hover\\:text-opacity-100:hover {\n  --text-opacity: 1;\n}\n\n.focus\\:text-opacity-0:focus {\n  --text-opacity: 0;\n}\n\n.focus\\:text-opacity-25:focus {\n  --text-opacity: 0.25;\n}\n\n.focus\\:text-opacity-50:focus {\n  --text-opacity: 0.5;\n}\n\n.focus\\:text-opacity-75:focus {\n  --text-opacity: 0.75;\n}\n\n.focus\\:text-opacity-100:focus {\n  --text-opacity: 1;\n}\n\n.italic {\n  font-style: italic;\n}\n\n.not-italic {\n  font-style: normal;\n}\n\n.uppercase {\n  text-transform: uppercase;\n}\n\n.lowercase {\n  text-transform: lowercase;\n}\n\n.capitalize {\n  text-transform: capitalize;\n}\n\n.normal-case {\n  text-transform: none;\n}\n\n.underline {\n  text-decoration: underline;\n}\n\n.line-through {\n  text-decoration: line-through;\n}\n\n.no-underline {\n  text-decoration: none;\n}\n\n.hover\\:underline:hover {\n  text-decoration: underline;\n}\n\n.hover\\:line-through:hover {\n  text-decoration: line-through;\n}\n\n.hover\\:no-underline:hover {\n  text-decoration: none;\n}\n\n.focus\\:underline:focus {\n  text-decoration: underline;\n}\n\n.focus\\:line-through:focus {\n  text-decoration: line-through;\n}\n\n.focus\\:no-underline:focus {\n  text-decoration: none;\n}\n\n.antialiased {\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n}\n\n.subpixel-antialiased {\n  -webkit-font-smoothing: auto;\n  -moz-osx-font-smoothing: auto;\n}\n\n.ordinal, .slashed-zero, .lining-nums, .oldstyle-nums, .proportional-nums, .tabular-nums, .diagonal-fractions, .stacked-fractions {\n  --font-variant-numeric-ordinal: var(--tailwind-empty,/*!*/ /*!*/);\n  --font-variant-numeric-slashed-zero: var(--tailwind-empty,/*!*/ /*!*/);\n  --font-variant-numeric-figure: var(--tailwind-empty,/*!*/ /*!*/);\n  --font-variant-numeric-spacing: var(--tailwind-empty,/*!*/ /*!*/);\n  --font-variant-numeric-fraction: var(--tailwind-empty,/*!*/ /*!*/);\n  font-variant-numeric: var(--font-variant-numeric-ordinal) var(--font-variant-numeric-slashed-zero) var(--font-variant-numeric-figure) var(--font-variant-numeric-spacing) var(--font-variant-numeric-fraction);\n}\n\n.normal-nums {\n  font-variant-numeric: normal;\n}\n\n.ordinal {\n  --font-variant-numeric-ordinal: ordinal;\n}\n\n.slashed-zero {\n  --font-variant-numeric-slashed-zero: slashed-zero;\n}\n\n.lining-nums {\n  --font-variant-numeric-figure: lining-nums;\n}\n\n.oldstyle-nums {\n  --font-variant-numeric-figure: oldstyle-nums;\n}\n\n.proportional-nums {\n  --font-variant-numeric-spacing: proportional-nums;\n}\n\n.tabular-nums {\n  --font-variant-numeric-spacing: tabular-nums;\n}\n\n.diagonal-fractions {\n  --font-variant-numeric-fraction: diagonal-fractions;\n}\n\n.stacked-fractions {\n  --font-variant-numeric-fraction: stacked-fractions;\n}\n\n.tracking-tighter {\n  letter-spacing: -0.05em;\n}\n\n.tracking-tight {\n  letter-spacing: -0.025em;\n}\n\n.tracking-normal {\n  letter-spacing: 0;\n}\n\n.tracking-wide {\n  letter-spacing: 0.025em;\n}\n\n.tracking-wider {\n  letter-spacing: 0.05em;\n}\n\n.tracking-widest {\n  letter-spacing: 0.1em;\n}\n\n.select-none {\n  -webkit-user-select: none;\n     -moz-user-select: none;\n      -ms-user-select: none;\n          user-select: none;\n}\n\n.select-text {\n  -webkit-user-select: text;\n     -moz-user-select: text;\n      -ms-user-select: text;\n          user-select: text;\n}\n\n.select-all {\n  -webkit-user-select: all;\n     -moz-user-select: all;\n      -ms-user-select: all;\n          user-select: all;\n}\n\n.select-auto {\n  -webkit-user-select: auto;\n     -moz-user-select: auto;\n      -ms-user-select: auto;\n          user-select: auto;\n}\n\n.align-baseline {\n  vertical-align: baseline;\n}\n\n.align-top {\n  vertical-align: top;\n}\n\n.align-middle {\n  vertical-align: middle;\n}\n\n.align-bottom {\n  vertical-align: bottom;\n}\n\n.align-text-top {\n  vertical-align: text-top;\n}\n\n.align-text-bottom {\n  vertical-align: text-bottom;\n}\n\n.visible {\n  visibility: visible;\n}\n\n.invisible {\n  visibility: hidden;\n}\n\n.whitespace-normal {\n  white-space: normal;\n}\n\n.whitespace-no-wrap {\n  white-space: nowrap;\n}\n\n.whitespace-pre {\n  white-space: pre;\n}\n\n.whitespace-pre-line {\n  white-space: pre-line;\n}\n\n.whitespace-pre-wrap {\n  white-space: pre-wrap;\n}\n\n.break-normal {\n  word-wrap: normal;\n  overflow-wrap: normal;\n  word-break: normal;\n}\n\n.break-words {\n  word-wrap: break-word;\n  overflow-wrap: break-word;\n}\n\n.break-all {\n  word-break: break-all;\n}\n\n.truncate {\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n}\n\n.w-0 {\n  width: 0;\n}\n\n.w-1 {\n  width: 0.25rem;\n}\n\n.w-2 {\n  width: 0.5rem;\n}\n\n.w-3 {\n  width: 0.75rem;\n}\n\n.w-4 {\n  width: 1rem;\n}\n\n.w-5 {\n  width: 1.25rem;\n}\n\n.w-6 {\n  width: 1.5rem;\n}\n\n.w-8 {\n  width: 2rem;\n}\n\n.w-10 {\n  width: 2.5rem;\n}\n\n.w-12 {\n  width: 3rem;\n}\n\n.w-16 {\n  width: 4rem;\n}\n\n.w-20 {\n  width: 5rem;\n}\n\n.w-24 {\n  width: 6rem;\n}\n\n.w-32 {\n  width: 8rem;\n}\n\n.w-40 {\n  width: 10rem;\n}\n\n.w-48 {\n  width: 12rem;\n}\n\n.w-56 {\n  width: 14rem;\n}\n\n.w-64 {\n  width: 16rem;\n}\n\n.w-auto {\n  width: auto;\n}\n\n.w-px {\n  width: 1px;\n}\n\n.w-1\\/2 {\n  width: 50%;\n}\n\n.w-1\\/3 {\n  width: 33.333333%;\n}\n\n.w-2\\/3 {\n  width: 66.666667%;\n}\n\n.w-1\\/4 {\n  width: 25%;\n}\n\n.w-2\\/4 {\n  width: 50%;\n}\n\n.w-3\\/4 {\n  width: 75%;\n}\n\n.w-1\\/5 {\n  width: 20%;\n}\n\n.w-2\\/5 {\n  width: 40%;\n}\n\n.w-3\\/5 {\n  width: 60%;\n}\n\n.w-4\\/5 {\n  width: 80%;\n}\n\n.w-1\\/6 {\n  width: 16.666667%;\n}\n\n.w-2\\/6 {\n  width: 33.333333%;\n}\n\n.w-3\\/6 {\n  width: 50%;\n}\n\n.w-4\\/6 {\n  width: 66.666667%;\n}\n\n.w-5\\/6 {\n  width: 83.333333%;\n}\n\n.w-1\\/12 {\n  width: 8.333333%;\n}\n\n.w-2\\/12 {\n  width: 16.666667%;\n}\n\n.w-3\\/12 {\n  width: 25%;\n}\n\n.w-4\\/12 {\n  width: 33.333333%;\n}\n\n.w-5\\/12 {\n  width: 41.666667%;\n}\n\n.w-6\\/12 {\n  width: 50%;\n}\n\n.w-7\\/12 {\n  width: 58.333333%;\n}\n\n.w-8\\/12 {\n  width: 66.666667%;\n}\n\n.w-9\\/12 {\n  width: 75%;\n}\n\n.w-10\\/12 {\n  width: 83.333333%;\n}\n\n.w-11\\/12 {\n  width: 91.666667%;\n}\n\n.w-full {\n  width: 100%;\n}\n\n.w-screen {\n  width: 100vw;\n}\n\n.z-0 {\n  z-index: 0;\n}\n\n.z-10 {\n  z-index: 10;\n}\n\n.z-20 {\n  z-index: 20;\n}\n\n.z-30 {\n  z-index: 30;\n}\n\n.z-40 {\n  z-index: 40;\n}\n\n.z-50 {\n  z-index: 50;\n}\n\n.z-auto {\n  z-index: auto;\n}\n\n.gap-0 {\n  grid-gap: 0;\n  gap: 0;\n}\n\n.gap-1 {\n  grid-gap: 0.25rem;\n  gap: 0.25rem;\n}\n\n.gap-2 {\n  grid-gap: 0.5rem;\n  gap: 0.5rem;\n}\n\n.gap-3 {\n  grid-gap: 0.75rem;\n  gap: 0.75rem;\n}\n\n.gap-4 {\n  grid-gap: 1rem;\n  gap: 1rem;\n}\n\n.gap-5 {\n  grid-gap: 1.25rem;\n  gap: 1.25rem;\n}\n\n.gap-6 {\n  grid-gap: 1.5rem;\n  gap: 1.5rem;\n}\n\n.gap-8 {\n  grid-gap: 2rem;\n  gap: 2rem;\n}\n\n.gap-10 {\n  grid-gap: 2.5rem;\n  gap: 2.5rem;\n}\n\n.gap-12 {\n  grid-gap: 3rem;\n  gap: 3rem;\n}\n\n.gap-16 {\n  grid-gap: 4rem;\n  gap: 4rem;\n}\n\n.gap-20 {\n  grid-gap: 5rem;\n  gap: 5rem;\n}\n\n.gap-24 {\n  grid-gap: 6rem;\n  gap: 6rem;\n}\n\n.gap-32 {\n  grid-gap: 8rem;\n  gap: 8rem;\n}\n\n.gap-40 {\n  grid-gap: 10rem;\n  gap: 10rem;\n}\n\n.gap-48 {\n  grid-gap: 12rem;\n  gap: 12rem;\n}\n\n.gap-56 {\n  grid-gap: 14rem;\n  gap: 14rem;\n}\n\n.gap-64 {\n  grid-gap: 16rem;\n  gap: 16rem;\n}\n\n.gap-px {\n  grid-gap: 1px;\n  gap: 1px;\n}\n\n.col-gap-0 {\n  grid-column-gap: 0;\n  -moz-column-gap: 0;\n       column-gap: 0;\n}\n\n.col-gap-1 {\n  grid-column-gap: 0.25rem;\n  -moz-column-gap: 0.25rem;\n       column-gap: 0.25rem;\n}\n\n.col-gap-2 {\n  grid-column-gap: 0.5rem;\n  -moz-column-gap: 0.5rem;\n       column-gap: 0.5rem;\n}\n\n.col-gap-3 {\n  grid-column-gap: 0.75rem;\n  -moz-column-gap: 0.75rem;\n       column-gap: 0.75rem;\n}\n\n.col-gap-4 {\n  grid-column-gap: 1rem;\n  -moz-column-gap: 1rem;\n       column-gap: 1rem;\n}\n\n.col-gap-5 {\n  grid-column-gap: 1.25rem;\n  -moz-column-gap: 1.25rem;\n       column-gap: 1.25rem;\n}\n\n.col-gap-6 {\n  grid-column-gap: 1.5rem;\n  -moz-column-gap: 1.5rem;\n       column-gap: 1.5rem;\n}\n\n.col-gap-8 {\n  grid-column-gap: 2rem;\n  -moz-column-gap: 2rem;\n       column-gap: 2rem;\n}\n\n.col-gap-10 {\n  grid-column-gap: 2.5rem;\n  -moz-column-gap: 2.5rem;\n       column-gap: 2.5rem;\n}\n\n.col-gap-12 {\n  grid-column-gap: 3rem;\n  -moz-column-gap: 3rem;\n       column-gap: 3rem;\n}\n\n.col-gap-16 {\n  grid-column-gap: 4rem;\n  -moz-column-gap: 4rem;\n       column-gap: 4rem;\n}\n\n.col-gap-20 {\n  grid-column-gap: 5rem;\n  -moz-column-gap: 5rem;\n       column-gap: 5rem;\n}\n\n.col-gap-24 {\n  grid-column-gap: 6rem;\n  -moz-column-gap: 6rem;\n       column-gap: 6rem;\n}\n\n.col-gap-32 {\n  grid-column-gap: 8rem;\n  -moz-column-gap: 8rem;\n       column-gap: 8rem;\n}\n\n.col-gap-40 {\n  grid-column-gap: 10rem;\n  -moz-column-gap: 10rem;\n       column-gap: 10rem;\n}\n\n.col-gap-48 {\n  grid-column-gap: 12rem;\n  -moz-column-gap: 12rem;\n       column-gap: 12rem;\n}\n\n.col-gap-56 {\n  grid-column-gap: 14rem;\n  -moz-column-gap: 14rem;\n       column-gap: 14rem;\n}\n\n.col-gap-64 {\n  grid-column-gap: 16rem;\n  -moz-column-gap: 16rem;\n       column-gap: 16rem;\n}\n\n.col-gap-px {\n  grid-column-gap: 1px;\n  -moz-column-gap: 1px;\n       column-gap: 1px;\n}\n\n.gap-x-0 {\n  grid-column-gap: 0;\n  -moz-column-gap: 0;\n       column-gap: 0;\n}\n\n.gap-x-1 {\n  grid-column-gap: 0.25rem;\n  -moz-column-gap: 0.25rem;\n       column-gap: 0.25rem;\n}\n\n.gap-x-2 {\n  grid-column-gap: 0.5rem;\n  -moz-column-gap: 0.5rem;\n       column-gap: 0.5rem;\n}\n\n.gap-x-3 {\n  grid-column-gap: 0.75rem;\n  -moz-column-gap: 0.75rem;\n       column-gap: 0.75rem;\n}\n\n.gap-x-4 {\n  grid-column-gap: 1rem;\n  -moz-column-gap: 1rem;\n       column-gap: 1rem;\n}\n\n.gap-x-5 {\n  grid-column-gap: 1.25rem;\n  -moz-column-gap: 1.25rem;\n       column-gap: 1.25rem;\n}\n\n.gap-x-6 {\n  grid-column-gap: 1.5rem;\n  -moz-column-gap: 1.5rem;\n       column-gap: 1.5rem;\n}\n\n.gap-x-8 {\n  grid-column-gap: 2rem;\n  -moz-column-gap: 2rem;\n       column-gap: 2rem;\n}\n\n.gap-x-10 {\n  grid-column-gap: 2.5rem;\n  -moz-column-gap: 2.5rem;\n       column-gap: 2.5rem;\n}\n\n.gap-x-12 {\n  grid-column-gap: 3rem;\n  -moz-column-gap: 3rem;\n       column-gap: 3rem;\n}\n\n.gap-x-16 {\n  grid-column-gap: 4rem;\n  -moz-column-gap: 4rem;\n       column-gap: 4rem;\n}\n\n.gap-x-20 {\n  grid-column-gap: 5rem;\n  -moz-column-gap: 5rem;\n       column-gap: 5rem;\n}\n\n.gap-x-24 {\n  grid-column-gap: 6rem;\n  -moz-column-gap: 6rem;\n       column-gap: 6rem;\n}\n\n.gap-x-32 {\n  grid-column-gap: 8rem;\n  -moz-column-gap: 8rem;\n       column-gap: 8rem;\n}\n\n.gap-x-40 {\n  grid-column-gap: 10rem;\n  -moz-column-gap: 10rem;\n       column-gap: 10rem;\n}\n\n.gap-x-48 {\n  grid-column-gap: 12rem;\n  -moz-column-gap: 12rem;\n       column-gap: 12rem;\n}\n\n.gap-x-56 {\n  grid-column-gap: 14rem;\n  -moz-column-gap: 14rem;\n       column-gap: 14rem;\n}\n\n.gap-x-64 {\n  grid-column-gap: 16rem;\n  -moz-column-gap: 16rem;\n       column-gap: 16rem;\n}\n\n.gap-x-px {\n  grid-column-gap: 1px;\n  -moz-column-gap: 1px;\n       column-gap: 1px;\n}\n\n.row-gap-0 {\n  grid-row-gap: 0;\n  row-gap: 0;\n}\n\n.row-gap-1 {\n  grid-row-gap: 0.25rem;\n  row-gap: 0.25rem;\n}\n\n.row-gap-2 {\n  grid-row-gap: 0.5rem;\n  row-gap: 0.5rem;\n}\n\n.row-gap-3 {\n  grid-row-gap: 0.75rem;\n  row-gap: 0.75rem;\n}\n\n.row-gap-4 {\n  grid-row-gap: 1rem;\n  row-gap: 1rem;\n}\n\n.row-gap-5 {\n  grid-row-gap: 1.25rem;\n  row-gap: 1.25rem;\n}\n\n.row-gap-6 {\n  grid-row-gap: 1.5rem;\n  row-gap: 1.5rem;\n}\n\n.row-gap-8 {\n  grid-row-gap: 2rem;\n  row-gap: 2rem;\n}\n\n.row-gap-10 {\n  grid-row-gap: 2.5rem;\n  row-gap: 2.5rem;\n}\n\n.row-gap-12 {\n  grid-row-gap: 3rem;\n  row-gap: 3rem;\n}\n\n.row-gap-16 {\n  grid-row-gap: 4rem;\n  row-gap: 4rem;\n}\n\n.row-gap-20 {\n  grid-row-gap: 5rem;\n  row-gap: 5rem;\n}\n\n.row-gap-24 {\n  grid-row-gap: 6rem;\n  row-gap: 6rem;\n}\n\n.row-gap-32 {\n  grid-row-gap: 8rem;\n  row-gap: 8rem;\n}\n\n.row-gap-40 {\n  grid-row-gap: 10rem;\n  row-gap: 10rem;\n}\n\n.row-gap-48 {\n  grid-row-gap: 12rem;\n  row-gap: 12rem;\n}\n\n.row-gap-56 {\n  grid-row-gap: 14rem;\n  row-gap: 14rem;\n}\n\n.row-gap-64 {\n  grid-row-gap: 16rem;\n  row-gap: 16rem;\n}\n\n.row-gap-px {\n  grid-row-gap: 1px;\n  row-gap: 1px;\n}\n\n.gap-y-0 {\n  grid-row-gap: 0;\n  row-gap: 0;\n}\n\n.gap-y-1 {\n  grid-row-gap: 0.25rem;\n  row-gap: 0.25rem;\n}\n\n.gap-y-2 {\n  grid-row-gap: 0.5rem;\n  row-gap: 0.5rem;\n}\n\n.gap-y-3 {\n  grid-row-gap: 0.75rem;\n  row-gap: 0.75rem;\n}\n\n.gap-y-4 {\n  grid-row-gap: 1rem;\n  row-gap: 1rem;\n}\n\n.gap-y-5 {\n  grid-row-gap: 1.25rem;\n  row-gap: 1.25rem;\n}\n\n.gap-y-6 {\n  grid-row-gap: 1.5rem;\n  row-gap: 1.5rem;\n}\n\n.gap-y-8 {\n  grid-row-gap: 2rem;\n  row-gap: 2rem;\n}\n\n.gap-y-10 {\n  grid-row-gap: 2.5rem;\n  row-gap: 2.5rem;\n}\n\n.gap-y-12 {\n  grid-row-gap: 3rem;\n  row-gap: 3rem;\n}\n\n.gap-y-16 {\n  grid-row-gap: 4rem;\n  row-gap: 4rem;\n}\n\n.gap-y-20 {\n  grid-row-gap: 5rem;\n  row-gap: 5rem;\n}\n\n.gap-y-24 {\n  grid-row-gap: 6rem;\n  row-gap: 6rem;\n}\n\n.gap-y-32 {\n  grid-row-gap: 8rem;\n  row-gap: 8rem;\n}\n\n.gap-y-40 {\n  grid-row-gap: 10rem;\n  row-gap: 10rem;\n}\n\n.gap-y-48 {\n  grid-row-gap: 12rem;\n  row-gap: 12rem;\n}\n\n.gap-y-56 {\n  grid-row-gap: 14rem;\n  row-gap: 14rem;\n}\n\n.gap-y-64 {\n  grid-row-gap: 16rem;\n  row-gap: 16rem;\n}\n\n.gap-y-px {\n  grid-row-gap: 1px;\n  row-gap: 1px;\n}\n\n.grid-flow-row {\n  grid-auto-flow: row;\n}\n\n.grid-flow-col {\n  grid-auto-flow: column;\n}\n\n.grid-flow-row-dense {\n  grid-auto-flow: row dense;\n}\n\n.grid-flow-col-dense {\n  grid-auto-flow: column dense;\n}\n\n.grid-cols-1 {\n  grid-template-columns: repeat(1, minmax(0, 1fr));\n}\n\n.grid-cols-2 {\n  grid-template-columns: repeat(2, minmax(0, 1fr));\n}\n\n.grid-cols-3 {\n  grid-template-columns: repeat(3, minmax(0, 1fr));\n}\n\n.grid-cols-4 {\n  grid-template-columns: repeat(4, minmax(0, 1fr));\n}\n\n.grid-cols-5 {\n  grid-template-columns: repeat(5, minmax(0, 1fr));\n}\n\n.grid-cols-6 {\n  grid-template-columns: repeat(6, minmax(0, 1fr));\n}\n\n.grid-cols-7 {\n  grid-template-columns: repeat(7, minmax(0, 1fr));\n}\n\n.grid-cols-8 {\n  grid-template-columns: repeat(8, minmax(0, 1fr));\n}\n\n.grid-cols-9 {\n  grid-template-columns: repeat(9, minmax(0, 1fr));\n}\n\n.grid-cols-10 {\n  grid-template-columns: repeat(10, minmax(0, 1fr));\n}\n\n.grid-cols-11 {\n  grid-template-columns: repeat(11, minmax(0, 1fr));\n}\n\n.grid-cols-12 {\n  grid-template-columns: repeat(12, minmax(0, 1fr));\n}\n\n.grid-cols-none {\n  grid-template-columns: none;\n}\n\n.auto-cols-auto {\n  grid-auto-columns: auto;\n}\n\n.auto-cols-min {\n  grid-auto-columns: -webkit-min-content;\n  grid-auto-columns: min-content;\n}\n\n.auto-cols-max {\n  grid-auto-columns: -webkit-max-content;\n  grid-auto-columns: max-content;\n}\n\n.auto-cols-fr {\n  grid-auto-columns: minmax(0, 1fr);\n}\n\n.col-auto {\n  grid-column: auto;\n}\n\n.col-span-1 {\n  grid-column: span 1 / span 1;\n}\n\n.col-span-2 {\n  grid-column: span 2 / span 2;\n}\n\n.col-span-3 {\n  grid-column: span 3 / span 3;\n}\n\n.col-span-4 {\n  grid-column: span 4 / span 4;\n}\n\n.col-span-5 {\n  grid-column: span 5 / span 5;\n}\n\n.col-span-6 {\n  grid-column: span 6 / span 6;\n}\n\n.col-span-7 {\n  grid-column: span 7 / span 7;\n}\n\n.col-span-8 {\n  grid-column: span 8 / span 8;\n}\n\n.col-span-9 {\n  grid-column: span 9 / span 9;\n}\n\n.col-span-10 {\n  grid-column: span 10 / span 10;\n}\n\n.col-span-11 {\n  grid-column: span 11 / span 11;\n}\n\n.col-span-12 {\n  grid-column: span 12 / span 12;\n}\n\n.col-span-full {\n  grid-column: 1 / -1;\n}\n\n.col-start-1 {\n  grid-column-start: 1;\n}\n\n.col-start-2 {\n  grid-column-start: 2;\n}\n\n.col-start-3 {\n  grid-column-start: 3;\n}\n\n.col-start-4 {\n  grid-column-start: 4;\n}\n\n.col-start-5 {\n  grid-column-start: 5;\n}\n\n.col-start-6 {\n  grid-column-start: 6;\n}\n\n.col-start-7 {\n  grid-column-start: 7;\n}\n\n.col-start-8 {\n  grid-column-start: 8;\n}\n\n.col-start-9 {\n  grid-column-start: 9;\n}\n\n.col-start-10 {\n  grid-column-start: 10;\n}\n\n.col-start-11 {\n  grid-column-start: 11;\n}\n\n.col-start-12 {\n  grid-column-start: 12;\n}\n\n.col-start-13 {\n  grid-column-start: 13;\n}\n\n.col-start-auto {\n  grid-column-start: auto;\n}\n\n.col-end-1 {\n  grid-column-end: 1;\n}\n\n.col-end-2 {\n  grid-column-end: 2;\n}\n\n.col-end-3 {\n  grid-column-end: 3;\n}\n\n.col-end-4 {\n  grid-column-end: 4;\n}\n\n.col-end-5 {\n  grid-column-end: 5;\n}\n\n.col-end-6 {\n  grid-column-end: 6;\n}\n\n.col-end-7 {\n  grid-column-end: 7;\n}\n\n.col-end-8 {\n  grid-column-end: 8;\n}\n\n.col-end-9 {\n  grid-column-end: 9;\n}\n\n.col-end-10 {\n  grid-column-end: 10;\n}\n\n.col-end-11 {\n  grid-column-end: 11;\n}\n\n.col-end-12 {\n  grid-column-end: 12;\n}\n\n.col-end-13 {\n  grid-column-end: 13;\n}\n\n.col-end-auto {\n  grid-column-end: auto;\n}\n\n.grid-rows-1 {\n  grid-template-rows: repeat(1, minmax(0, 1fr));\n}\n\n.grid-rows-2 {\n  grid-template-rows: repeat(2, minmax(0, 1fr));\n}\n\n.grid-rows-3 {\n  grid-template-rows: repeat(3, minmax(0, 1fr));\n}\n\n.grid-rows-4 {\n  grid-template-rows: repeat(4, minmax(0, 1fr));\n}\n\n.grid-rows-5 {\n  grid-template-rows: repeat(5, minmax(0, 1fr));\n}\n\n.grid-rows-6 {\n  grid-template-rows: repeat(6, minmax(0, 1fr));\n}\n\n.grid-rows-none {\n  grid-template-rows: none;\n}\n\n.auto-rows-auto {\n  grid-auto-rows: auto;\n}\n\n.auto-rows-min {\n  grid-auto-rows: -webkit-min-content;\n  grid-auto-rows: min-content;\n}\n\n.auto-rows-max {\n  grid-auto-rows: -webkit-max-content;\n  grid-auto-rows: max-content;\n}\n\n.auto-rows-fr {\n  grid-auto-rows: minmax(0, 1fr);\n}\n\n.row-auto {\n  grid-row: auto;\n}\n\n.row-span-1 {\n  grid-row: span 1 / span 1;\n}\n\n.row-span-2 {\n  grid-row: span 2 / span 2;\n}\n\n.row-span-3 {\n  grid-row: span 3 / span 3;\n}\n\n.row-span-4 {\n  grid-row: span 4 / span 4;\n}\n\n.row-span-5 {\n  grid-row: span 5 / span 5;\n}\n\n.row-span-6 {\n  grid-row: span 6 / span 6;\n}\n\n.row-span-full {\n  grid-row: 1 / -1;\n}\n\n.row-start-1 {\n  grid-row-start: 1;\n}\n\n.row-start-2 {\n  grid-row-start: 2;\n}\n\n.row-start-3 {\n  grid-row-start: 3;\n}\n\n.row-start-4 {\n  grid-row-start: 4;\n}\n\n.row-start-5 {\n  grid-row-start: 5;\n}\n\n.row-start-6 {\n  grid-row-start: 6;\n}\n\n.row-start-7 {\n  grid-row-start: 7;\n}\n\n.row-start-auto {\n  grid-row-start: auto;\n}\n\n.row-end-1 {\n  grid-row-end: 1;\n}\n\n.row-end-2 {\n  grid-row-end: 2;\n}\n\n.row-end-3 {\n  grid-row-end: 3;\n}\n\n.row-end-4 {\n  grid-row-end: 4;\n}\n\n.row-end-5 {\n  grid-row-end: 5;\n}\n\n.row-end-6 {\n  grid-row-end: 6;\n}\n\n.row-end-7 {\n  grid-row-end: 7;\n}\n\n.row-end-auto {\n  grid-row-end: auto;\n}\n\n.transform {\n  --transform-translate-x: 0;\n  --transform-translate-y: 0;\n  --transform-rotate: 0;\n  --transform-skew-x: 0;\n  --transform-skew-y: 0;\n  --transform-scale-x: 1;\n  --transform-scale-y: 1;\n  transform: translateX(var(--transform-translate-x)) translateY(var(--transform-translate-y)) rotate(var(--transform-rotate)) skewX(var(--transform-skew-x)) skewY(var(--transform-skew-y)) scaleX(var(--transform-scale-x)) scaleY(var(--transform-scale-y));\n}\n\n.transform-none {\n  transform: none;\n}\n\n.origin-center {\n  transform-origin: center;\n}\n\n.origin-top {\n  transform-origin: top;\n}\n\n.origin-top-right {\n  transform-origin: top right;\n}\n\n.origin-right {\n  transform-origin: right;\n}\n\n.origin-bottom-right {\n  transform-origin: bottom right;\n}\n\n.origin-bottom {\n  transform-origin: bottom;\n}\n\n.origin-bottom-left {\n  transform-origin: bottom left;\n}\n\n.origin-left {\n  transform-origin: left;\n}\n\n.origin-top-left {\n  transform-origin: top left;\n}\n\n.scale-0 {\n  --transform-scale-x: 0;\n  --transform-scale-y: 0;\n}\n\n.scale-50 {\n  --transform-scale-x: .5;\n  --transform-scale-y: .5;\n}\n\n.scale-75 {\n  --transform-scale-x: .75;\n  --transform-scale-y: .75;\n}\n\n.scale-90 {\n  --transform-scale-x: .9;\n  --transform-scale-y: .9;\n}\n\n.scale-95 {\n  --transform-scale-x: .95;\n  --transform-scale-y: .95;\n}\n\n.scale-100 {\n  --transform-scale-x: 1;\n  --transform-scale-y: 1;\n}\n\n.scale-105 {\n  --transform-scale-x: 1.05;\n  --transform-scale-y: 1.05;\n}\n\n.scale-110 {\n  --transform-scale-x: 1.1;\n  --transform-scale-y: 1.1;\n}\n\n.scale-125 {\n  --transform-scale-x: 1.25;\n  --transform-scale-y: 1.25;\n}\n\n.scale-150 {\n  --transform-scale-x: 1.5;\n  --transform-scale-y: 1.5;\n}\n\n.scale-x-0 {\n  --transform-scale-x: 0;\n}\n\n.scale-x-50 {\n  --transform-scale-x: .5;\n}\n\n.scale-x-75 {\n  --transform-scale-x: .75;\n}\n\n.scale-x-90 {\n  --transform-scale-x: .9;\n}\n\n.scale-x-95 {\n  --transform-scale-x: .95;\n}\n\n.scale-x-100 {\n  --transform-scale-x: 1;\n}\n\n.scale-x-105 {\n  --transform-scale-x: 1.05;\n}\n\n.scale-x-110 {\n  --transform-scale-x: 1.1;\n}\n\n.scale-x-125 {\n  --transform-scale-x: 1.25;\n}\n\n.scale-x-150 {\n  --transform-scale-x: 1.5;\n}\n\n.scale-y-0 {\n  --transform-scale-y: 0;\n}\n\n.scale-y-50 {\n  --transform-scale-y: .5;\n}\n\n.scale-y-75 {\n  --transform-scale-y: .75;\n}\n\n.scale-y-90 {\n  --transform-scale-y: .9;\n}\n\n.scale-y-95 {\n  --transform-scale-y: .95;\n}\n\n.scale-y-100 {\n  --transform-scale-y: 1;\n}\n\n.scale-y-105 {\n  --transform-scale-y: 1.05;\n}\n\n.scale-y-110 {\n  --transform-scale-y: 1.1;\n}\n\n.scale-y-125 {\n  --transform-scale-y: 1.25;\n}\n\n.scale-y-150 {\n  --transform-scale-y: 1.5;\n}\n\n.hover\\:scale-0:hover {\n  --transform-scale-x: 0;\n  --transform-scale-y: 0;\n}\n\n.hover\\:scale-50:hover {\n  --transform-scale-x: .5;\n  --transform-scale-y: .5;\n}\n\n.hover\\:scale-75:hover {\n  --transform-scale-x: .75;\n  --transform-scale-y: .75;\n}\n\n.hover\\:scale-90:hover {\n  --transform-scale-x: .9;\n  --transform-scale-y: .9;\n}\n\n.hover\\:scale-95:hover {\n  --transform-scale-x: .95;\n  --transform-scale-y: .95;\n}\n\n.hover\\:scale-100:hover {\n  --transform-scale-x: 1;\n  --transform-scale-y: 1;\n}\n\n.hover\\:scale-105:hover {\n  --transform-scale-x: 1.05;\n  --transform-scale-y: 1.05;\n}\n\n.hover\\:scale-110:hover {\n  --transform-scale-x: 1.1;\n  --transform-scale-y: 1.1;\n}\n\n.hover\\:scale-125:hover {\n  --transform-scale-x: 1.25;\n  --transform-scale-y: 1.25;\n}\n\n.hover\\:scale-150:hover {\n  --transform-scale-x: 1.5;\n  --transform-scale-y: 1.5;\n}\n\n.hover\\:scale-x-0:hover {\n  --transform-scale-x: 0;\n}\n\n.hover\\:scale-x-50:hover {\n  --transform-scale-x: .5;\n}\n\n.hover\\:scale-x-75:hover {\n  --transform-scale-x: .75;\n}\n\n.hover\\:scale-x-90:hover {\n  --transform-scale-x: .9;\n}\n\n.hover\\:scale-x-95:hover {\n  --transform-scale-x: .95;\n}\n\n.hover\\:scale-x-100:hover {\n  --transform-scale-x: 1;\n}\n\n.hover\\:scale-x-105:hover {\n  --transform-scale-x: 1.05;\n}\n\n.hover\\:scale-x-110:hover {\n  --transform-scale-x: 1.1;\n}\n\n.hover\\:scale-x-125:hover {\n  --transform-scale-x: 1.25;\n}\n\n.hover\\:scale-x-150:hover {\n  --transform-scale-x: 1.5;\n}\n\n.hover\\:scale-y-0:hover {\n  --transform-scale-y: 0;\n}\n\n.hover\\:scale-y-50:hover {\n  --transform-scale-y: .5;\n}\n\n.hover\\:scale-y-75:hover {\n  --transform-scale-y: .75;\n}\n\n.hover\\:scale-y-90:hover {\n  --transform-scale-y: .9;\n}\n\n.hover\\:scale-y-95:hover {\n  --transform-scale-y: .95;\n}\n\n.hover\\:scale-y-100:hover {\n  --transform-scale-y: 1;\n}\n\n.hover\\:scale-y-105:hover {\n  --transform-scale-y: 1.05;\n}\n\n.hover\\:scale-y-110:hover {\n  --transform-scale-y: 1.1;\n}\n\n.hover\\:scale-y-125:hover {\n  --transform-scale-y: 1.25;\n}\n\n.hover\\:scale-y-150:hover {\n  --transform-scale-y: 1.5;\n}\n\n.focus\\:scale-0:focus {\n  --transform-scale-x: 0;\n  --transform-scale-y: 0;\n}\n\n.focus\\:scale-50:focus {\n  --transform-scale-x: .5;\n  --transform-scale-y: .5;\n}\n\n.focus\\:scale-75:focus {\n  --transform-scale-x: .75;\n  --transform-scale-y: .75;\n}\n\n.focus\\:scale-90:focus {\n  --transform-scale-x: .9;\n  --transform-scale-y: .9;\n}\n\n.focus\\:scale-95:focus {\n  --transform-scale-x: .95;\n  --transform-scale-y: .95;\n}\n\n.focus\\:scale-100:focus {\n  --transform-scale-x: 1;\n  --transform-scale-y: 1;\n}\n\n.focus\\:scale-105:focus {\n  --transform-scale-x: 1.05;\n  --transform-scale-y: 1.05;\n}\n\n.focus\\:scale-110:focus {\n  --transform-scale-x: 1.1;\n  --transform-scale-y: 1.1;\n}\n\n.focus\\:scale-125:focus {\n  --transform-scale-x: 1.25;\n  --transform-scale-y: 1.25;\n}\n\n.focus\\:scale-150:focus {\n  --transform-scale-x: 1.5;\n  --transform-scale-y: 1.5;\n}\n\n.focus\\:scale-x-0:focus {\n  --transform-scale-x: 0;\n}\n\n.focus\\:scale-x-50:focus {\n  --transform-scale-x: .5;\n}\n\n.focus\\:scale-x-75:focus {\n  --transform-scale-x: .75;\n}\n\n.focus\\:scale-x-90:focus {\n  --transform-scale-x: .9;\n}\n\n.focus\\:scale-x-95:focus {\n  --transform-scale-x: .95;\n}\n\n.focus\\:scale-x-100:focus {\n  --transform-scale-x: 1;\n}\n\n.focus\\:scale-x-105:focus {\n  --transform-scale-x: 1.05;\n}\n\n.focus\\:scale-x-110:focus {\n  --transform-scale-x: 1.1;\n}\n\n.focus\\:scale-x-125:focus {\n  --transform-scale-x: 1.25;\n}\n\n.focus\\:scale-x-150:focus {\n  --transform-scale-x: 1.5;\n}\n\n.focus\\:scale-y-0:focus {\n  --transform-scale-y: 0;\n}\n\n.focus\\:scale-y-50:focus {\n  --transform-scale-y: .5;\n}\n\n.focus\\:scale-y-75:focus {\n  --transform-scale-y: .75;\n}\n\n.focus\\:scale-y-90:focus {\n  --transform-scale-y: .9;\n}\n\n.focus\\:scale-y-95:focus {\n  --transform-scale-y: .95;\n}\n\n.focus\\:scale-y-100:focus {\n  --transform-scale-y: 1;\n}\n\n.focus\\:scale-y-105:focus {\n  --transform-scale-y: 1.05;\n}\n\n.focus\\:scale-y-110:focus {\n  --transform-scale-y: 1.1;\n}\n\n.focus\\:scale-y-125:focus {\n  --transform-scale-y: 1.25;\n}\n\n.focus\\:scale-y-150:focus {\n  --transform-scale-y: 1.5;\n}\n\n.rotate-0 {\n  --transform-rotate: 0;\n}\n\n.rotate-1 {\n  --transform-rotate: 1deg;\n}\n\n.rotate-2 {\n  --transform-rotate: 2deg;\n}\n\n.rotate-3 {\n  --transform-rotate: 3deg;\n}\n\n.rotate-6 {\n  --transform-rotate: 6deg;\n}\n\n.rotate-12 {\n  --transform-rotate: 12deg;\n}\n\n.rotate-45 {\n  --transform-rotate: 45deg;\n}\n\n.rotate-90 {\n  --transform-rotate: 90deg;\n}\n\n.rotate-180 {\n  --transform-rotate: 180deg;\n}\n\n.-rotate-180 {\n  --transform-rotate: -180deg;\n}\n\n.-rotate-90 {\n  --transform-rotate: -90deg;\n}\n\n.-rotate-45 {\n  --transform-rotate: -45deg;\n}\n\n.-rotate-12 {\n  --transform-rotate: -12deg;\n}\n\n.-rotate-6 {\n  --transform-rotate: -6deg;\n}\n\n.-rotate-3 {\n  --transform-rotate: -3deg;\n}\n\n.-rotate-2 {\n  --transform-rotate: -2deg;\n}\n\n.-rotate-1 {\n  --transform-rotate: -1deg;\n}\n\n.hover\\:rotate-0:hover {\n  --transform-rotate: 0;\n}\n\n.hover\\:rotate-1:hover {\n  --transform-rotate: 1deg;\n}\n\n.hover\\:rotate-2:hover {\n  --transform-rotate: 2deg;\n}\n\n.hover\\:rotate-3:hover {\n  --transform-rotate: 3deg;\n}\n\n.hover\\:rotate-6:hover {\n  --transform-rotate: 6deg;\n}\n\n.hover\\:rotate-12:hover {\n  --transform-rotate: 12deg;\n}\n\n.hover\\:rotate-45:hover {\n  --transform-rotate: 45deg;\n}\n\n.hover\\:rotate-90:hover {\n  --transform-rotate: 90deg;\n}\n\n.hover\\:rotate-180:hover {\n  --transform-rotate: 180deg;\n}\n\n.hover\\:-rotate-180:hover {\n  --transform-rotate: -180deg;\n}\n\n.hover\\:-rotate-90:hover {\n  --transform-rotate: -90deg;\n}\n\n.hover\\:-rotate-45:hover {\n  --transform-rotate: -45deg;\n}\n\n.hover\\:-rotate-12:hover {\n  --transform-rotate: -12deg;\n}\n\n.hover\\:-rotate-6:hover {\n  --transform-rotate: -6deg;\n}\n\n.hover\\:-rotate-3:hover {\n  --transform-rotate: -3deg;\n}\n\n.hover\\:-rotate-2:hover {\n  --transform-rotate: -2deg;\n}\n\n.hover\\:-rotate-1:hover {\n  --transform-rotate: -1deg;\n}\n\n.focus\\:rotate-0:focus {\n  --transform-rotate: 0;\n}\n\n.focus\\:rotate-1:focus {\n  --transform-rotate: 1deg;\n}\n\n.focus\\:rotate-2:focus {\n  --transform-rotate: 2deg;\n}\n\n.focus\\:rotate-3:focus {\n  --transform-rotate: 3deg;\n}\n\n.focus\\:rotate-6:focus {\n  --transform-rotate: 6deg;\n}\n\n.focus\\:rotate-12:focus {\n  --transform-rotate: 12deg;\n}\n\n.focus\\:rotate-45:focus {\n  --transform-rotate: 45deg;\n}\n\n.focus\\:rotate-90:focus {\n  --transform-rotate: 90deg;\n}\n\n.focus\\:rotate-180:focus {\n  --transform-rotate: 180deg;\n}\n\n.focus\\:-rotate-180:focus {\n  --transform-rotate: -180deg;\n}\n\n.focus\\:-rotate-90:focus {\n  --transform-rotate: -90deg;\n}\n\n.focus\\:-rotate-45:focus {\n  --transform-rotate: -45deg;\n}\n\n.focus\\:-rotate-12:focus {\n  --transform-rotate: -12deg;\n}\n\n.focus\\:-rotate-6:focus {\n  --transform-rotate: -6deg;\n}\n\n.focus\\:-rotate-3:focus {\n  --transform-rotate: -3deg;\n}\n\n.focus\\:-rotate-2:focus {\n  --transform-rotate: -2deg;\n}\n\n.focus\\:-rotate-1:focus {\n  --transform-rotate: -1deg;\n}\n\n.translate-x-0 {\n  --transform-translate-x: 0;\n}\n\n.translate-x-1 {\n  --transform-translate-x: 0.25rem;\n}\n\n.translate-x-2 {\n  --transform-translate-x: 0.5rem;\n}\n\n.translate-x-3 {\n  --transform-translate-x: 0.75rem;\n}\n\n.translate-x-4 {\n  --transform-translate-x: 1rem;\n}\n\n.translate-x-5 {\n  --transform-translate-x: 1.25rem;\n}\n\n.translate-x-6 {\n  --transform-translate-x: 1.5rem;\n}\n\n.translate-x-8 {\n  --transform-translate-x: 2rem;\n}\n\n.translate-x-10 {\n  --transform-translate-x: 2.5rem;\n}\n\n.translate-x-12 {\n  --transform-translate-x: 3rem;\n}\n\n.translate-x-16 {\n  --transform-translate-x: 4rem;\n}\n\n.translate-x-20 {\n  --transform-translate-x: 5rem;\n}\n\n.translate-x-24 {\n  --transform-translate-x: 6rem;\n}\n\n.translate-x-32 {\n  --transform-translate-x: 8rem;\n}\n\n.translate-x-40 {\n  --transform-translate-x: 10rem;\n}\n\n.translate-x-48 {\n  --transform-translate-x: 12rem;\n}\n\n.translate-x-56 {\n  --transform-translate-x: 14rem;\n}\n\n.translate-x-64 {\n  --transform-translate-x: 16rem;\n}\n\n.translate-x-px {\n  --transform-translate-x: 1px;\n}\n\n.-translate-x-1 {\n  --transform-translate-x: -0.25rem;\n}\n\n.-translate-x-2 {\n  --transform-translate-x: -0.5rem;\n}\n\n.-translate-x-3 {\n  --transform-translate-x: -0.75rem;\n}\n\n.-translate-x-4 {\n  --transform-translate-x: -1rem;\n}\n\n.-translate-x-5 {\n  --transform-translate-x: -1.25rem;\n}\n\n.-translate-x-6 {\n  --transform-translate-x: -1.5rem;\n}\n\n.-translate-x-8 {\n  --transform-translate-x: -2rem;\n}\n\n.-translate-x-10 {\n  --transform-translate-x: -2.5rem;\n}\n\n.-translate-x-12 {\n  --transform-translate-x: -3rem;\n}\n\n.-translate-x-16 {\n  --transform-translate-x: -4rem;\n}\n\n.-translate-x-20 {\n  --transform-translate-x: -5rem;\n}\n\n.-translate-x-24 {\n  --transform-translate-x: -6rem;\n}\n\n.-translate-x-32 {\n  --transform-translate-x: -8rem;\n}\n\n.-translate-x-40 {\n  --transform-translate-x: -10rem;\n}\n\n.-translate-x-48 {\n  --transform-translate-x: -12rem;\n}\n\n.-translate-x-56 {\n  --transform-translate-x: -14rem;\n}\n\n.-translate-x-64 {\n  --transform-translate-x: -16rem;\n}\n\n.-translate-x-px {\n  --transform-translate-x: -1px;\n}\n\n.-translate-x-full {\n  --transform-translate-x: -100%;\n}\n\n.-translate-x-1\\/2 {\n  --transform-translate-x: -50%;\n}\n\n.translate-x-1\\/2 {\n  --transform-translate-x: 50%;\n}\n\n.translate-x-full {\n  --transform-translate-x: 100%;\n}\n\n.translate-y-0 {\n  --transform-translate-y: 0;\n}\n\n.translate-y-1 {\n  --transform-translate-y: 0.25rem;\n}\n\n.translate-y-2 {\n  --transform-translate-y: 0.5rem;\n}\n\n.translate-y-3 {\n  --transform-translate-y: 0.75rem;\n}\n\n.translate-y-4 {\n  --transform-translate-y: 1rem;\n}\n\n.translate-y-5 {\n  --transform-translate-y: 1.25rem;\n}\n\n.translate-y-6 {\n  --transform-translate-y: 1.5rem;\n}\n\n.translate-y-8 {\n  --transform-translate-y: 2rem;\n}\n\n.translate-y-10 {\n  --transform-translate-y: 2.5rem;\n}\n\n.translate-y-12 {\n  --transform-translate-y: 3rem;\n}\n\n.translate-y-16 {\n  --transform-translate-y: 4rem;\n}\n\n.translate-y-20 {\n  --transform-translate-y: 5rem;\n}\n\n.translate-y-24 {\n  --transform-translate-y: 6rem;\n}\n\n.translate-y-32 {\n  --transform-translate-y: 8rem;\n}\n\n.translate-y-40 {\n  --transform-translate-y: 10rem;\n}\n\n.translate-y-48 {\n  --transform-translate-y: 12rem;\n}\n\n.translate-y-56 {\n  --transform-translate-y: 14rem;\n}\n\n.translate-y-64 {\n  --transform-translate-y: 16rem;\n}\n\n.translate-y-px {\n  --transform-translate-y: 1px;\n}\n\n.-translate-y-1 {\n  --transform-translate-y: -0.25rem;\n}\n\n.-translate-y-2 {\n  --transform-translate-y: -0.5rem;\n}\n\n.-translate-y-3 {\n  --transform-translate-y: -0.75rem;\n}\n\n.-translate-y-4 {\n  --transform-translate-y: -1rem;\n}\n\n.-translate-y-5 {\n  --transform-translate-y: -1.25rem;\n}\n\n.-translate-y-6 {\n  --transform-translate-y: -1.5rem;\n}\n\n.-translate-y-8 {\n  --transform-translate-y: -2rem;\n}\n\n.-translate-y-10 {\n  --transform-translate-y: -2.5rem;\n}\n\n.-translate-y-12 {\n  --transform-translate-y: -3rem;\n}\n\n.-translate-y-16 {\n  --transform-translate-y: -4rem;\n}\n\n.-translate-y-20 {\n  --transform-translate-y: -5rem;\n}\n\n.-translate-y-24 {\n  --transform-translate-y: -6rem;\n}\n\n.-translate-y-32 {\n  --transform-translate-y: -8rem;\n}\n\n.-translate-y-40 {\n  --transform-translate-y: -10rem;\n}\n\n.-translate-y-48 {\n  --transform-translate-y: -12rem;\n}\n\n.-translate-y-56 {\n  --transform-translate-y: -14rem;\n}\n\n.-translate-y-64 {\n  --transform-translate-y: -16rem;\n}\n\n.-translate-y-px {\n  --transform-translate-y: -1px;\n}\n\n.-translate-y-full {\n  --transform-translate-y: -100%;\n}\n\n.-translate-y-1\\/2 {\n  --transform-translate-y: -50%;\n}\n\n.translate-y-1\\/2 {\n  --transform-translate-y: 50%;\n}\n\n.translate-y-full {\n  --transform-translate-y: 100%;\n}\n\n.hover\\:translate-x-0:hover {\n  --transform-translate-x: 0;\n}\n\n.hover\\:translate-x-1:hover {\n  --transform-translate-x: 0.25rem;\n}\n\n.hover\\:translate-x-2:hover {\n  --transform-translate-x: 0.5rem;\n}\n\n.hover\\:translate-x-3:hover {\n  --transform-translate-x: 0.75rem;\n}\n\n.hover\\:translate-x-4:hover {\n  --transform-translate-x: 1rem;\n}\n\n.hover\\:translate-x-5:hover {\n  --transform-translate-x: 1.25rem;\n}\n\n.hover\\:translate-x-6:hover {\n  --transform-translate-x: 1.5rem;\n}\n\n.hover\\:translate-x-8:hover {\n  --transform-translate-x: 2rem;\n}\n\n.hover\\:translate-x-10:hover {\n  --transform-translate-x: 2.5rem;\n}\n\n.hover\\:translate-x-12:hover {\n  --transform-translate-x: 3rem;\n}\n\n.hover\\:translate-x-16:hover {\n  --transform-translate-x: 4rem;\n}\n\n.hover\\:translate-x-20:hover {\n  --transform-translate-x: 5rem;\n}\n\n.hover\\:translate-x-24:hover {\n  --transform-translate-x: 6rem;\n}\n\n.hover\\:translate-x-32:hover {\n  --transform-translate-x: 8rem;\n}\n\n.hover\\:translate-x-40:hover {\n  --transform-translate-x: 10rem;\n}\n\n.hover\\:translate-x-48:hover {\n  --transform-translate-x: 12rem;\n}\n\n.hover\\:translate-x-56:hover {\n  --transform-translate-x: 14rem;\n}\n\n.hover\\:translate-x-64:hover {\n  --transform-translate-x: 16rem;\n}\n\n.hover\\:translate-x-px:hover {\n  --transform-translate-x: 1px;\n}\n\n.hover\\:-translate-x-1:hover {\n  --transform-translate-x: -0.25rem;\n}\n\n.hover\\:-translate-x-2:hover {\n  --transform-translate-x: -0.5rem;\n}\n\n.hover\\:-translate-x-3:hover {\n  --transform-translate-x: -0.75rem;\n}\n\n.hover\\:-translate-x-4:hover {\n  --transform-translate-x: -1rem;\n}\n\n.hover\\:-translate-x-5:hover {\n  --transform-translate-x: -1.25rem;\n}\n\n.hover\\:-translate-x-6:hover {\n  --transform-translate-x: -1.5rem;\n}\n\n.hover\\:-translate-x-8:hover {\n  --transform-translate-x: -2rem;\n}\n\n.hover\\:-translate-x-10:hover {\n  --transform-translate-x: -2.5rem;\n}\n\n.hover\\:-translate-x-12:hover {\n  --transform-translate-x: -3rem;\n}\n\n.hover\\:-translate-x-16:hover {\n  --transform-translate-x: -4rem;\n}\n\n.hover\\:-translate-x-20:hover {\n  --transform-translate-x: -5rem;\n}\n\n.hover\\:-translate-x-24:hover {\n  --transform-translate-x: -6rem;\n}\n\n.hover\\:-translate-x-32:hover {\n  --transform-translate-x: -8rem;\n}\n\n.hover\\:-translate-x-40:hover {\n  --transform-translate-x: -10rem;\n}\n\n.hover\\:-translate-x-48:hover {\n  --transform-translate-x: -12rem;\n}\n\n.hover\\:-translate-x-56:hover {\n  --transform-translate-x: -14rem;\n}\n\n.hover\\:-translate-x-64:hover {\n  --transform-translate-x: -16rem;\n}\n\n.hover\\:-translate-x-px:hover {\n  --transform-translate-x: -1px;\n}\n\n.hover\\:-translate-x-full:hover {\n  --transform-translate-x: -100%;\n}\n\n.hover\\:-translate-x-1\\/2:hover {\n  --transform-translate-x: -50%;\n}\n\n.hover\\:translate-x-1\\/2:hover {\n  --transform-translate-x: 50%;\n}\n\n.hover\\:translate-x-full:hover {\n  --transform-translate-x: 100%;\n}\n\n.hover\\:translate-y-0:hover {\n  --transform-translate-y: 0;\n}\n\n.hover\\:translate-y-1:hover {\n  