/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.generator.handler.shared;

import com.javonet.core.generator.handler.Handlers;
import com.javonet.core.generator.handler.shared.IHandler;
import com.javonet.sdk.core.JvmCommand;
import java.lang.reflect.Modifier;

public class SharedModifierHandler
implements IHandler {
    @Override
    public Object generateCommand(Object analyzedObject, JvmCommand parentCommand, Handlers handlers) {
        Integer modifier = (Integer)analyzedObject;
        if (Modifier.isPublic(modifier)) {
            return "public";
        }
        if (Modifier.isPrivate(modifier)) {
            return "private";
        }
        if (Modifier.isProtected(modifier)) {
            return "protected";
        }
        return "";
    }

    @Override
    public void generateCode(StringBuilder existingStringBuilder, JvmCommand commonCommand, Object usedObject, Handlers handlers) {
        existingStringBuilder.append(System.getProperty("line.separator"));
        switch (usedObject.toString()) {
            case "public": {
                existingStringBuilder.append("public");
                existingStringBuilder.append(" ");
                break;
            }
            case "private": {
                existingStringBuilder.append("private");
                existingStringBuilder.append(" ");
                break;
            }
            case "protected": {
                existingStringBuilder.append("protected");
                existingStringBuilder.append(" ");
                break;
            }
            case "": {
                existingStringBuilder.append(" ");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unable to properly read modifier: " + usedObject.toString());
            }
        }
    }
}

