/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.handler;

import com.javonet.core.handler.Handler;
import com.javonet.core.handler.loadlibrary.JarAdder;
import com.javonet.core.handler.loadlibrary.JvmClassLoader;
import com.javonet.sdk.core.JvmCommand;
import com.javonet.utils.exceptions.JavonetArgumentsMismatchException;
import java.io.File;
import java.net.URL;

public class LoadLibraryHandler
extends Handler {
    private final int requiredArgumentsCount = 1;
    private final JvmClassLoader jvmClassLoader = new JvmClassLoader(new URL[0], this.getClass().getClassLoader());

    LoadLibraryHandler() {
    }

    @Override
    public Object process(JvmCommand command) throws Exception {
        return this.loadLibrary(command);
    }

    private Object loadLibrary(JvmCommand command) throws Exception {
        if (command.getPayload().length < 1) {
            throw new JavonetArgumentsMismatchException(this.getClass().getName(), 1);
        }
        String assemblyName = command.getPayload()[0].toString();
        File f = new File(assemblyName);
        if (f.exists()) {
            int pos = this.addLibrary(f.toURI().toURL());
            JarAdder.addJarToClasspath(f);
            return 0;
        }
        return 1;
    }

    public int addLibrary(URL path) {
        int pos = this.jvmClassLoader.getURLs().length;
        this.jvmClassLoader.addUrl(path);
        return pos;
    }
}

