/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.protocol;

import com.javonet.core.protocol.TypeEncoder;
import com.javonet.sdk.core.JvmCommand;
import com.javonet.sdk.core.RuntimeLib;
import com.javonet.sdk.internal.ConnectionType;
import com.javonet.utils.TcpConnectionData;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;

public class CommandEncoder {
    private ByteBuffer byteBuffer = ByteBuffer.allocate(0);
    private Deque<JvmCommand> deque = new ArrayDeque<JvmCommand>();

    public byte[] encode(JvmCommand root, ConnectionType connectionType, Optional<TcpConnectionData> tcpAddress) {
        this.byteBuffer = ByteBuffer.allocate(0);
        this.deque.push(root);
        this.insertIntoBuffer(new byte[]{(byte)root.getTargetRuntime().ordinal(), 0});
        this.serializeTcp(connectionType, tcpAddress);
        this.insertIntoBuffer(new byte[]{(byte)RuntimeLib.Jvm.ordinal(), (byte)root.getCommandType().ordinal()});
        return this.encodeRecursively(this.deque);
    }

    private void serializeTcp(ConnectionType connectionType, Optional<TcpConnectionData> tcpAddress) {
        if (ConnectionType.TCP.equals((Object)connectionType) && tcpAddress.isPresent()) {
            String[] ipAddress = tcpAddress.get().getHostname().split("\\.");
            int port = tcpAddress.get().getPort();
            this.insertIntoBuffer(new byte[]{(byte)connectionType.ordinal()});
            for (String address : ipAddress) {
                this.insertIntoBuffer(new byte[]{(byte)Integer.parseInt(address)});
            }
            this.insertIntoBuffer(new byte[]{(byte)port, (byte)(port >>> 8 & 0xFF)});
        } else {
            this.insertIntoBuffer(new byte[]{(byte)connectionType.ordinal()});
            this.insertIntoBuffer(new byte[]{0, 0, 0, 0, 0, 0});
        }
    }

    private byte[] encodeRecursively(Deque<JvmCommand> deque) {
        if (deque.isEmpty()) {
            return this.byteBuffer.array();
        }
        JvmCommand cmd = deque.pop();
        deque.push(cmd.dropFirstPayloadArg());
        if (cmd.getPayload().length > 0) {
            Class<?> targetClass = cmd.getPayload()[0].getClass();
            if (targetClass == JvmCommand.class) {
                JvmCommand innerCommand = (JvmCommand)cmd.getPayload()[0];
                this.insertIntoBuffer(TypeEncoder.encodeCommand(innerCommand));
                deque.push(innerCommand);
            } else {
                byte[] result = TypeEncoder.encodePrimitive(cmd.getPayload()[0]);
                this.insertIntoBuffer(result);
            }
            return this.encodeRecursively(deque);
        }
        deque.pop();
        return this.encodeRecursively(deque);
    }

    private void insertIntoBuffer(byte[] arg) {
        ByteBuffer newByteBuffer = ByteBuffer.allocate(arg.length + this.byteBuffer.limit());
        newByteBuffer.put(this.byteBuffer.array());
        newByteBuffer.put(arg);
        this.byteBuffer = newByteBuffer;
    }
}

