/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk.core;

import com.javonet.sdk.core.JvmCommandType;
import com.javonet.sdk.core.RuntimeLib;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;

public class JvmCommand {
    private final RuntimeLib targetRuntime;
    private final JvmCommandType commandType;
    private Object[] payload = new Object[0];

    public JvmCommand(RuntimeLib targetRuntime, JvmCommandType commandType, Object[] payload) {
        this.targetRuntime = targetRuntime;
        this.commandType = commandType;
        this.payload = payload;
    }

    public int getPayloadSize() {
        return this.payload.length;
    }

    public String payloadToString() {
        StringBuilder sb = new StringBuilder();
        for (Object payloadItem : this.payload) {
            sb.append((String)payloadItem);
            sb.append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    public String toString() {
        return (Object)((Object)this.targetRuntime) + " " + (Object)((Object)this.commandType) + " " + Arrays.toString(this.payload);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JvmCommand that = (JvmCommand)o;
        return this.targetRuntime == that.targetRuntime && this.commandType == that.commandType && Arrays.equals(this.payload, that.payload);
    }

    public JvmCommand createResponse(Object varArgs) {
        if (varArgs.getClass().isArray()) {
            return new JvmCommand(this.targetRuntime, JvmCommandType.RESPONSE, (Object[])varArgs);
        }
        return new JvmCommand(this.targetRuntime, JvmCommandType.RESPONSE, new Object[]{varArgs});
    }

    public JvmCommand createReference(Object varArgs) {
        if (varArgs.getClass().isArray()) {
            return new JvmCommand(this.targetRuntime, JvmCommandType.REFERENCE, (Object[])varArgs);
        }
        return new JvmCommand(this.targetRuntime, JvmCommandType.REFERENCE, new Object[]{varArgs});
    }

    public int hashCode() {
        return 31 * (Objects.hash(new Object[]{this.targetRuntime, this.commandType}) + Arrays.hashCode(this.getHashablePayload()));
    }

    private Object[] getHashablePayload() {
        switch (this.commandType) {
            case LOAD_LIBRARY: 
            case CREATE_INSTANCE: 
            case GET_TYPE: {
                return new Object[]{this.payload[0]};
            }
            case GET_STATIC_FIELD: 
            case SET_STATIC_FIELD: 
            case GET_MODULE: 
            case INVOKE_STATIC_METHOD: 
            case INVOKE_INSTANCE_METHOD: {
                return new Object[]{this.payload[0], this.payload[1]};
            }
        }
        throw new RuntimeException((Object)((Object)this.commandType) + " payload size not implemented");
    }

    public RuntimeLib getTargetRuntime() {
        return this.targetRuntime;
    }

    public JvmCommandType getCommandType() {
        return this.commandType;
    }

    public Object[] getPayload() {
        return this.payload;
    }

    public void setPayload(Object obj, int i) {
        this.payload[i] = obj;
    }

    public JvmCommand dropFirstPayloadArg() {
        return new JvmCommand(this.targetRuntime, this.commandType, Arrays.stream(this.payload).skip(1L).toArray());
    }

    public JvmCommand addArgToPayload(Object arg) {
        return new JvmCommand(this.targetRuntime, this.commandType, Stream.concat(Arrays.stream(this.payload), Stream.of(arg)).toArray());
    }

    public JvmCommand appendArgument(Object arg) {
        return new JvmCommand(this.targetRuntime, this.commandType, Stream.concat(Stream.of(arg), Arrays.stream(this.payload)).toArray());
    }
}

