/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk.internal;

import com.javonet.core.generator.handler.GeneratorHandler;
import com.javonet.core.handler.JvmHandler;
import com.javonet.core.interpreter.JvmInterpreter;
import com.javonet.sdk.core.JvmCommand;
import com.javonet.sdk.core.JvmCommandType;
import com.javonet.sdk.core.RuntimeLib;
import com.javonet.sdk.internal.AbstractModuleContext;
import com.javonet.sdk.internal.AbstractRuntimeContext;
import com.javonet.sdk.internal.AbstractTypeContext;
import com.javonet.sdk.internal.BinariesUnloader;
import com.javonet.sdk.internal.ConnectionType;
import com.javonet.sdk.internal.InvocationContext;
import com.javonet.utils.TcpConnectionData;
import java.util.HashMap;
import java.util.Optional;

public class RuntimeContext
implements AbstractTypeContext,
AbstractModuleContext,
AbstractRuntimeContext {
    private final RuntimeLib runtimeLib;
    private final ConnectionType connectionType;
    private final Optional<TcpConnectionData> tcpAddress;
    private JvmCommand currentCommand;
    private JvmCommand responseCommand;
    private final JvmHandler handler = new JvmHandler();
    private final JvmInterpreter interpreter = new JvmInterpreter();
    private static final HashMap<RuntimeLib, RuntimeContext> memoryRuntimeContexts = new HashMap();
    private static final HashMap<TcpConnectionData, RuntimeContext> networkRuntimeContexts = new HashMap();
    private final GeneratorHandler generatorHandler = new GeneratorHandler();

    public static RuntimeContext getInstance(RuntimeLib runtimeLib, ConnectionType connectionType, Optional<TcpConnectionData> tcpAddress) {
        if (ConnectionType.TCP.equals((Object)connectionType) && tcpAddress.isPresent()) {
            if (networkRuntimeContexts.containsKey(tcpAddress.get())) {
                RuntimeContext runtimeCtx = networkRuntimeContexts.get(tcpAddress.get());
                runtimeCtx.currentCommand = null;
                return runtimeCtx;
            }
            RuntimeContext currentContext = new RuntimeContext(runtimeLib, connectionType, tcpAddress);
            networkRuntimeContexts.put(tcpAddress.get(), currentContext);
            return currentContext;
        }
        if (memoryRuntimeContexts.containsKey((Object)runtimeLib)) {
            RuntimeContext runtimeCtx = memoryRuntimeContexts.get((Object)runtimeLib);
            runtimeCtx.currentCommand = null;
            return runtimeCtx;
        }
        RuntimeContext currentContext = new RuntimeContext(runtimeLib, connectionType, tcpAddress);
        memoryRuntimeContexts.put(runtimeLib, currentContext);
        return currentContext;
    }

    private RuntimeContext(RuntimeLib runtimeLib, ConnectionType connectionType, Optional<TcpConnectionData> tcpAddress) {
        this.runtimeLib = runtimeLib;
        this.connectionType = connectionType;
        this.tcpAddress = tcpAddress;
        if (RuntimeLib.Jvm != runtimeLib) {
            BinariesUnloader.extractBinariesFromJar(runtimeLib);
        }
    }

    @Override
    public void execute(JvmCommand immediateCommand) {
        this.responseCommand = RuntimeLib.Jvm == immediateCommand.getTargetRuntime() ? this.handler.handleCommand(immediateCommand) : this.interpreter.execute(immediateCommand, this.connectionType, this.tcpAddress);
        this.currentCommand = null;
    }

    @Override
    public InvocationContext getType(Object ... args) {
        JvmCommand localCommand = new JvmCommand(this.runtimeLib, JvmCommandType.GET_TYPE, args);
        return new InvocationContext(this.runtimeLib, this.connectionType, this.tcpAddress, this.buildCommand(localCommand));
    }

    @Override
    public RuntimeContext loadLibrary(Object ... args) {
        JvmCommand localCommand = new JvmCommand(this.runtimeLib, JvmCommandType.LOAD_LIBRARY, args);
        this.buildCommand(localCommand);
        this.execute(localCommand);
        return this;
    }

    public InvocationContext invokeGlobalMethod(Object ... args) {
        JvmCommand command = new JvmCommand(this.runtimeLib, JvmCommandType.INVOKE_GLOBAL_METHOD, args);
        return new InvocationContext(this.runtimeLib, this.connectionType, this.tcpAddress, this.buildCommand(command));
    }

    public RuntimeContext generateLibrary(Object ... args) {
        JvmCommand generateLibraryCommand = new JvmCommand(this.runtimeLib, JvmCommandType.GENERATE_LIB, args);
        this.execute(generateLibraryCommand);
        this.generatorHandler.generate(this.currentCommand, System.getProperty("user.dir"));
        return this;
    }

    private JvmCommand buildCommand(JvmCommand cmd) {
        return this.currentCommand == null ? cmd : cmd.appendArgument(this.currentCommand);
    }
}

