/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.utils.exceptions;

import com.javonet.sdk.core.ExceptionType;
import com.javonet.sdk.core.JvmCommand;
import com.javonet.sdk.core.JvmCommandType;

public class ExceptionSerializer {
    public static JvmCommand serializeException(Throwable exception, JvmCommand jvmCommand) {
        JvmCommand exceptionCommand = new JvmCommand(jvmCommand.getTargetRuntime(), JvmCommandType.EXCEPTION, new Object[0]);
        StringBuilder stackClasses = new StringBuilder();
        StringBuilder stackMethods = new StringBuilder();
        StringBuilder stackLines = new StringBuilder();
        StringBuilder stackFiles = new StringBuilder();
        ExceptionSerializer.serializeStackTrace(exception, stackClasses, stackMethods, stackLines, stackFiles);
        exceptionCommand = exceptionCommand.addArgToPayload(ExceptionSerializer.getExceptionCode(exception));
        exceptionCommand = exceptionCommand.addArgToPayload(jvmCommand.toString());
        exceptionCommand = exceptionCommand.addArgToPayload(exception.getClass().getName());
        exceptionCommand = exceptionCommand.addArgToPayload(exception.getMessage());
        exceptionCommand = exceptionCommand.addArgToPayload(stackClasses.toString());
        exceptionCommand = exceptionCommand.addArgToPayload(stackMethods.toString());
        exceptionCommand = exceptionCommand.addArgToPayload(stackLines.toString());
        exceptionCommand = exceptionCommand.addArgToPayload(stackFiles.toString());
        return exceptionCommand;
    }

    private static void serializeStackTrace(Throwable exception, StringBuilder stackClasses, StringBuilder stackMethods, StringBuilder stackLines, StringBuilder stackFiles) {
        for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
            stackClasses.append(stackTraceElement.getClassName()).append("|");
            stackMethods.append(stackTraceElement.getMethodName()).append("|");
            stackLines.append(stackTraceElement.getLineNumber()).append("|");
            stackFiles.append(stackTraceElement.getFileName()).append("|");
        }
    }

    private static Object getExceptionCode(Throwable exception) {
        switch (exception.getClass().getSimpleName()) {
            case "IOException": {
                return ExceptionType.IO_EXCEPTION.ordinal();
            }
            case "FileNotFoundException": {
                return ExceptionType.FILE_NOT_FOUND_EXCEPTION.ordinal();
            }
            case "RuntimeException": {
                return ExceptionType.RUNTIME_EXCEPTION.ordinal();
            }
            case "ArithmeticException": {
                return ExceptionType.ARITHMETIC_EXCEPTION.ordinal();
            }
            case "IllegalArgumentException": {
                return ExceptionType.ILLEGAL_ARGUMENT_EXCEPTION.ordinal();
            }
            case "IndexOutOfBoundsException": 
            case "StringIndexOutOfBoundsException": 
            case "ArrayIndexOutOfBoundsException": {
                return ExceptionType.INDEX_OUT_OF_BOUNDS_EXCEPTION.ordinal();
            }
            case "NullPointerException": {
                return ExceptionType.NULL_POINTER_EXCEPTION.ordinal();
            }
        }
        return exception.getClass().getName();
    }
}

