/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.utils.exceptions;

import com.javonet.sdk.core.ExceptionType;
import com.javonet.sdk.core.JvmCommand;
import com.javonet.utils.exceptions.UncheckedFileNotFoundException;
import com.javonet.utils.exceptions.UncheckedIOException;

public class ExceptionThrower {
    public static void throwException(JvmCommand jvmCommandException) {
        String javonetStackCommand = (String)jvmCommandException.getPayload()[1];
        String exceptionName = (String)jvmCommandException.getPayload()[2];
        String exceptionMessage = (String)jvmCommandException.getPayload()[3];
        StackTraceElement[] stackTrace = jvmCommandException.getPayload().length > 7 ? ExceptionThrower.getLocalStackTrace((String)jvmCommandException.getPayload()[4], (String)jvmCommandException.getPayload()[5], (String)jvmCommandException.getPayload()[6], (String)jvmCommandException.getPayload()[7]) : new StackTraceElement[]{};
        if (jvmCommandException.getPayload()[0] instanceof String) {
            RuntimeException runtimeException = new RuntimeException("Internal Exception: " + jvmCommandException.getPayload()[0] + " " + exceptionMessage);
            runtimeException.setStackTrace(stackTrace);
            throw runtimeException;
        }
        ExceptionType exceptionType = ExceptionType.values()[(Integer)jvmCommandException.getPayload()[0]];
        switch (exceptionType) {
            case EXCEPTION: 
            case RUNTIME_EXCEPTION: {
                RuntimeException runtimeException = new RuntimeException(exceptionMessage);
                runtimeException.setStackTrace(stackTrace);
                throw runtimeException;
            }
            case IO_EXCEPTION: {
                UncheckedIOException uncheckedIOException = new UncheckedIOException(exceptionMessage);
                uncheckedIOException.setStackTrace(stackTrace);
                throw uncheckedIOException;
            }
            case ARITHMETIC_EXCEPTION: {
                ArithmeticException arithmeticException = new ArithmeticException(exceptionMessage);
                arithmeticException.setStackTrace(stackTrace);
                throw arithmeticException;
            }
            case NULL_POINTER_EXCEPTION: {
                NullPointerException nullPointerException = new NullPointerException(exceptionMessage);
                nullPointerException.setStackTrace(stackTrace);
                throw nullPointerException;
            }
            case FILE_NOT_FOUND_EXCEPTION: {
                UncheckedFileNotFoundException uncheckedFileNotFoundException = new UncheckedFileNotFoundException(exceptionMessage);
                uncheckedFileNotFoundException.setStackTrace(stackTrace);
                throw uncheckedFileNotFoundException;
            }
            case ILLEGAL_ARGUMENT_EXCEPTION: {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(exceptionMessage);
                illegalArgumentException.setStackTrace(stackTrace);
                throw illegalArgumentException;
            }
            case INDEX_OUT_OF_BOUNDS_EXCEPTION: {
                IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(exceptionMessage);
                indexOutOfBoundsException.setStackTrace(stackTrace);
                throw indexOutOfBoundsException;
            }
        }
        throw new RuntimeException("Unable to process Exception: " + jvmCommandException.payloadToString());
    }

    private static StackTraceElement[] getLocalStackTrace(String stackTraceClasses, String stackTraceMethods, String stackTraceLines, String stackTraceFiles) {
        String[] stackClasses = stackTraceClasses.split("\\|");
        String[] stackMethods = stackTraceMethods.split("\\|");
        String[] stackLines = stackTraceLines.split("\\|");
        String[] stackFiles = stackTraceFiles.split("\\|");
        StackTraceElement[] result = new StackTraceElement[stackLines.length];
        for (int i = 0; i < stackLines.length; ++i) {
            StackTraceElement ste;
            result[i] = ste = new StackTraceElement(stackClasses[i], stackMethods[i], stackFiles[i], Integer.parseInt(stackLines[i]));
        }
        return result;
    }
}

